---@meta

--
--AndroidJavaRunnable is the Unity representation of a java.lang.Runnable object.
--
---@source UnityEngine.AndroidJNIModule.dll
---@class UnityEngine.AndroidJavaRunnable: System.MulticastDelegate
---@source UnityEngine.AndroidJNIModule.dll
CS.UnityEngine.AndroidJavaRunnable = {}

---@source UnityEngine.AndroidJNIModule.dll
function CS.UnityEngine.AndroidJavaRunnable.Invoke() end

---@source UnityEngine.AndroidJNIModule.dll
---@param callback System.AsyncCallback
---@param object object
---@return IAsyncResult
function CS.UnityEngine.AndroidJavaRunnable.BeginInvoke(callback, object) end

---@source UnityEngine.AndroidJNIModule.dll
---@param result System.IAsyncResult
function CS.UnityEngine.AndroidJavaRunnable.EndInvoke(result) end


---@source UnityEngine.AndroidJNIModule.dll
---@class UnityEngine.AndroidJavaException: System.Exception
---@source UnityEngine.AndroidJNIModule.dll
---@field StackTrace string
---@source UnityEngine.AndroidJNIModule.dll
CS.UnityEngine.AndroidJavaException = {}


--
--This class can be used to implement any java interface. Any java vm method invocation matching the interface on the proxy object will automatically be passed to the c# implementation.
--
---@source UnityEngine.AndroidJNIModule.dll
---@class UnityEngine.AndroidJavaProxy: object
--
--Java interface implemented by the proxy.
--
---@source UnityEngine.AndroidJNIModule.dll
---@field javaInterface UnityEngine.AndroidJavaClass
---@source UnityEngine.AndroidJNIModule.dll
CS.UnityEngine.AndroidJavaProxy = {}

--
--Called by the java vm whenever a method is invoked on the java proxy interface. You can override this to run special code on method invokation, or you can leave the implementation as is, and leave the default behavior which is to look for c# methods matching the signature of the java method.
--
--```plaintext
--Params: methodName - Name of the invoked java method.
--        args - Arguments passed from the java vm - converted into AndroidJavaObject, AndroidJavaClass or a primitive.
--        javaArgs - Arguments passed from the java vm - all objects are represented by AndroidJavaObject, int for instance is represented by a java.lang.Integer object.
--        
--```
--
---@source UnityEngine.AndroidJNIModule.dll
---@param methodName string
---@param args object[]
---@return AndroidJavaObject
function CS.UnityEngine.AndroidJavaProxy.Invoke(methodName, args) end

--
--Called by the java vm whenever a method is invoked on the java proxy interface. You can override this to run special code on method invokation, or you can leave the implementation as is, and leave the default behavior which is to look for c# methods matching the signature of the java method.
--
--```plaintext
--Params: methodName - Name of the invoked java method.
--        args - Arguments passed from the java vm - converted into AndroidJavaObject, AndroidJavaClass or a primitive.
--        javaArgs - Arguments passed from the java vm - all objects are represented by AndroidJavaObject, int for instance is represented by a java.lang.Integer object.
--        
--```
--
---@source UnityEngine.AndroidJNIModule.dll
---@param methodName string
---@param javaArgs UnityEngine.AndroidJavaObject[]
---@return AndroidJavaObject
function CS.UnityEngine.AndroidJavaProxy.Invoke(methodName, javaArgs) end

--
--Returns true when the objects are equal and false if otherwise.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param obj UnityEngine.AndroidJavaObject
---@return Boolean
function CS.UnityEngine.AndroidJavaProxy.equals(obj) end

--
--Returns the hash code of the java proxy object.
--
---@source UnityEngine.AndroidJNIModule.dll
---@return Int32
function CS.UnityEngine.AndroidJavaProxy.hashCode() end

--
--Returns C# class name + " <c# proxy java object>".
--
---@source UnityEngine.AndroidJNIModule.dll
---@return String
function CS.UnityEngine.AndroidJavaProxy.toString() end


--
--AndroidJavaObject is the Unity representation of a generic instance of java.lang.Object.
--
---@source UnityEngine.AndroidJNIModule.dll
---@class UnityEngine.AndroidJavaObject: object
---@source UnityEngine.AndroidJNIModule.dll
CS.UnityEngine.AndroidJavaObject = {}

--
--IDisposable callback.
--
---@source UnityEngine.AndroidJNIModule.dll
function CS.UnityEngine.AndroidJavaObject.Dispose() end

---@source UnityEngine.AndroidJNIModule.dll
---@param methodName string
---@param args T[]
function CS.UnityEngine.AndroidJavaObject.Call(methodName, args) end

--
--Call a Java method on an object.
--
--```plaintext
--Params: methodName - Specifies which method to call.
--        args - An array of parameters passed to the method.
--        
--```
--
---@source UnityEngine.AndroidJNIModule.dll
---@param methodName string
---@param args object[]
function CS.UnityEngine.AndroidJavaObject.Call(methodName, args) end

---@source UnityEngine.AndroidJNIModule.dll
---@param methodName string
---@param args T[]
function CS.UnityEngine.AndroidJavaObject.CallStatic(methodName, args) end

--
--Call a static Java method on a class.
--
--```plaintext
--Params: methodName - Specifies which method to call.
--        args - An array of parameters passed to the method.
--        
--```
--
---@source UnityEngine.AndroidJNIModule.dll
---@param methodName string
---@param args object[]
function CS.UnityEngine.AndroidJavaObject.CallStatic(methodName, args) end

---@source UnityEngine.AndroidJNIModule.dll
---@param fieldName string
---@return FieldType
function CS.UnityEngine.AndroidJavaObject.Get(fieldName) end

---@source UnityEngine.AndroidJNIModule.dll
---@param fieldName string
---@param val FieldType
function CS.UnityEngine.AndroidJavaObject.Set(fieldName, val) end

---@source UnityEngine.AndroidJNIModule.dll
---@param fieldName string
---@return FieldType
function CS.UnityEngine.AndroidJavaObject.GetStatic(fieldName) end

---@source UnityEngine.AndroidJNIModule.dll
---@param fieldName string
---@param val FieldType
function CS.UnityEngine.AndroidJavaObject.SetStatic(fieldName, val) end

--
--Retrieves the raw <tt>jobject</tt> pointer to the Java object.
--
--Note: Using raw JNI functions requires advanced knowledge of the Android Java Native Interface (JNI). Please take note.
--
---@source UnityEngine.AndroidJNIModule.dll
---@return IntPtr
function CS.UnityEngine.AndroidJavaObject.GetRawObject() end

--
--Retrieves the raw <tt>jclass</tt> pointer to the Java class.
--
--Note: Using raw JNI functions requires advanced knowledge of the Android Java Native Interface (JNI). Please take note.
--
---@source UnityEngine.AndroidJNIModule.dll
---@return IntPtr
function CS.UnityEngine.AndroidJavaObject.GetRawClass() end

---@source UnityEngine.AndroidJNIModule.dll
---@param methodName string
---@param args T[]
---@return ReturnType
function CS.UnityEngine.AndroidJavaObject.Call(methodName, args) end

---@source UnityEngine.AndroidJNIModule.dll
---@param methodName string
---@param args object[]
---@return ReturnType
function CS.UnityEngine.AndroidJavaObject.Call(methodName, args) end

---@source UnityEngine.AndroidJNIModule.dll
---@param methodName string
---@param args T[]
---@return ReturnType
function CS.UnityEngine.AndroidJavaObject.CallStatic(methodName, args) end

---@source UnityEngine.AndroidJNIModule.dll
---@param methodName string
---@param args object[]
---@return ReturnType
function CS.UnityEngine.AndroidJavaObject.CallStatic(methodName, args) end


--
--AndroidJavaClass is the Unity representation of a generic instance of java.lang.Class.
--
---@source UnityEngine.AndroidJNIModule.dll
---@class UnityEngine.AndroidJavaClass: UnityEngine.AndroidJavaObject
---@source UnityEngine.AndroidJNIModule.dll
CS.UnityEngine.AndroidJavaClass = {}


---@source UnityEngine.AndroidJNIModule.dll
---@class UnityEngine.jvalue: System.ValueType
---@source UnityEngine.AndroidJNIModule.dll
---@field z bool
---@source UnityEngine.AndroidJNIModule.dll
---@field b sbyte
---@source UnityEngine.AndroidJNIModule.dll
---@field c char
---@source UnityEngine.AndroidJNIModule.dll
---@field s short
---@source UnityEngine.AndroidJNIModule.dll
---@field i int
---@source UnityEngine.AndroidJNIModule.dll
---@field j long
---@source UnityEngine.AndroidJNIModule.dll
---@field f float
---@source UnityEngine.AndroidJNIModule.dll
---@field d double
---@source UnityEngine.AndroidJNIModule.dll
---@field l System.IntPtr
---@source UnityEngine.AndroidJNIModule.dll
CS.UnityEngine.jvalue = {}


--
--Helper interface for JNI interaction; signature creation and method lookups.
--
--Note: Using raw JNI functions requires advanced knowledge of the Android Java Native Interface (JNI). Please take note.
--
---@source UnityEngine.AndroidJNIModule.dll
---@class UnityEngine.AndroidJNIHelper: object
--
--Set debug to true to log calls through the AndroidJNIHelper.
--
---@source UnityEngine.AndroidJNIModule.dll
---@field debug bool
---@source UnityEngine.AndroidJNIModule.dll
CS.UnityEngine.AndroidJNIHelper = {}

--
--Scans a particular Java class for a constructor method matching a signature.
--
--```plaintext
--Params: javaClass - Raw JNI Java class object (obtained by calling AndroidJNI.FindClass).
--        signature - Constructor method signature (e.g. obtained by calling AndroidJNIHelper.GetSignature).
--        
--```
--
---@source UnityEngine.AndroidJNIModule.dll
---@param javaClass System.IntPtr
---@return IntPtr
function CS.UnityEngine.AndroidJNIHelper:GetConstructorID(javaClass) end

--
--Scans a particular Java class for a constructor method matching a signature.
--
--```plaintext
--Params: javaClass - Raw JNI Java class object (obtained by calling AndroidJNI.FindClass).
--        signature - Constructor method signature (e.g. obtained by calling AndroidJNIHelper.GetSignature).
--        
--```
--
---@source UnityEngine.AndroidJNIModule.dll
---@param javaClass System.IntPtr
---@param signature string
---@return IntPtr
function CS.UnityEngine.AndroidJNIHelper:GetConstructorID(javaClass, signature) end

--
--Scans a particular Java class for a method matching a name and a signature.
--
--```plaintext
--Params: javaClass - Raw JNI Java class object (obtained by calling AndroidJNI.FindClass).
--        methodName - Name of the method as declared in Java.
--        signature - Method signature (e.g. obtained by calling AndroidJNIHelper.GetSignature).
--        isStatic - Set to <tt>true<tt> for static methods; <tt>false<tt> for instance (nonstatic) methods.
--        
--```
--
---@source UnityEngine.AndroidJNIModule.dll
---@param javaClass System.IntPtr
---@param methodName string
---@return IntPtr
function CS.UnityEngine.AndroidJNIHelper:GetMethodID(javaClass, methodName) end

--
--Scans a particular Java class for a method matching a name and a signature.
--
--```plaintext
--Params: javaClass - Raw JNI Java class object (obtained by calling AndroidJNI.FindClass).
--        methodName - Name of the method as declared in Java.
--        signature - Method signature (e.g. obtained by calling AndroidJNIHelper.GetSignature).
--        isStatic - Set to <tt>true<tt> for static methods; <tt>false<tt> for instance (nonstatic) methods.
--        
--```
--
---@source UnityEngine.AndroidJNIModule.dll
---@param javaClass System.IntPtr
---@param methodName string
---@param signature string
---@return IntPtr
function CS.UnityEngine.AndroidJNIHelper:GetMethodID(javaClass, methodName, signature) end

--
--Scans a particular Java class for a method matching a name and a signature.
--
--```plaintext
--Params: javaClass - Raw JNI Java class object (obtained by calling AndroidJNI.FindClass).
--        methodName - Name of the method as declared in Java.
--        signature - Method signature (e.g. obtained by calling AndroidJNIHelper.GetSignature).
--        isStatic - Set to <tt>true<tt> for static methods; <tt>false<tt> for instance (nonstatic) methods.
--        
--```
--
---@source UnityEngine.AndroidJNIModule.dll
---@param javaClass System.IntPtr
---@param methodName string
---@param signature string
---@param isStatic bool
---@return IntPtr
function CS.UnityEngine.AndroidJNIHelper:GetMethodID(javaClass, methodName, signature, isStatic) end

--
--Scans a particular Java class for a field matching a name and a signature.
--
--```plaintext
--Params: javaClass - Raw JNI Java class object (obtained by calling AndroidJNI.FindClass).
--        fieldName - Name of the field as declared in Java.
--        signature - Field signature (e.g. obtained by calling AndroidJNIHelper.GetSignature).
--        isStatic - Set to <tt>true<tt> for static fields; <tt>false<tt> for instance (nonstatic) fields.
--        
--```
--
---@source UnityEngine.AndroidJNIModule.dll
---@param javaClass System.IntPtr
---@param fieldName string
---@return IntPtr
function CS.UnityEngine.AndroidJNIHelper:GetFieldID(javaClass, fieldName) end

--
--Scans a particular Java class for a field matching a name and a signature.
--
--```plaintext
--Params: javaClass - Raw JNI Java class object (obtained by calling AndroidJNI.FindClass).
--        fieldName - Name of the field as declared in Java.
--        signature - Field signature (e.g. obtained by calling AndroidJNIHelper.GetSignature).
--        isStatic - Set to <tt>true<tt> for static fields; <tt>false<tt> for instance (nonstatic) fields.
--        
--```
--
---@source UnityEngine.AndroidJNIModule.dll
---@param javaClass System.IntPtr
---@param fieldName string
---@param signature string
---@return IntPtr
function CS.UnityEngine.AndroidJNIHelper:GetFieldID(javaClass, fieldName, signature) end

--
--Scans a particular Java class for a field matching a name and a signature.
--
--```plaintext
--Params: javaClass - Raw JNI Java class object (obtained by calling AndroidJNI.FindClass).
--        fieldName - Name of the field as declared in Java.
--        signature - Field signature (e.g. obtained by calling AndroidJNIHelper.GetSignature).
--        isStatic - Set to <tt>true<tt> for static fields; <tt>false<tt> for instance (nonstatic) fields.
--        
--```
--
---@source UnityEngine.AndroidJNIModule.dll
---@param javaClass System.IntPtr
---@param fieldName string
---@param signature string
---@param isStatic bool
---@return IntPtr
function CS.UnityEngine.AndroidJNIHelper:GetFieldID(javaClass, fieldName, signature, isStatic) end

--
--Creates a UnityJavaRunnable object (implements java.lang.Runnable).
--
--```plaintext
--Params: runnable - A delegate representing the java.lang.Runnable.
--        
--```
--
---@source UnityEngine.AndroidJNIModule.dll
---@param jrunnable UnityEngine.AndroidJavaRunnable
---@return IntPtr
function CS.UnityEngine.AndroidJNIHelper:CreateJavaRunnable(jrunnable) end

--
--Creates a java proxy object which connects to the supplied proxy implementation.
--
--```plaintext
--Params: proxy - An implementatinon of a java interface in c#.
--        
--```
--
---@source UnityEngine.AndroidJNIModule.dll
---@param proxy UnityEngine.AndroidJavaProxy
---@return IntPtr
function CS.UnityEngine.AndroidJNIHelper:CreateJavaProxy(proxy) end

--
--Creates a Java array from a managed array.
--
--```plaintext
--Params: array - Managed array to be converted into a Java array object.
--        
--```
--
---@source UnityEngine.AndroidJNIModule.dll
---@param array System.Array
---@return IntPtr
function CS.UnityEngine.AndroidJNIHelper:ConvertToJNIArray(array) end

--
--Creates the parameter array to be used as argument list when invoking Java code through CallMethod() in AndroidJNI.
--
--```plaintext
--Params: args - An array of objects that should be converted to Call parameters.
--        
--```
--
---@source UnityEngine.AndroidJNIModule.dll
---@param args object[]
function CS.UnityEngine.AndroidJNIHelper:CreateJNIArgArray(args) end

--
--Deletes any local jni references previously allocated by CreateJNIArgArray().
--
--```plaintext
--Params: args - The array of arguments used as a parameter to CreateJNIArgArray().
--        jniArgs - The array returned by CreateJNIArgArray().
--        
--```
--
---@source UnityEngine.AndroidJNIModule.dll
---@param args object[]
---@param jniArgs UnityEngine.jvalue[]
function CS.UnityEngine.AndroidJNIHelper:DeleteJNIArgArray(args, jniArgs) end

--
--Get a JNI method ID for a constructor based on calling arguments.
--
--```plaintext
--Params: javaClass - Raw JNI Java class object (obtained by calling AndroidJNI.FindClass).
--        args - Array with parameters to be passed to the constructor when invoked.
--        
--```
--
---@source UnityEngine.AndroidJNIModule.dll
---@param jclass System.IntPtr
---@param args object[]
---@return IntPtr
function CS.UnityEngine.AndroidJNIHelper:GetConstructorID(jclass, args) end

--
--Get a JNI method ID based on calling arguments.
--
--```plaintext
--Params: javaClass - Raw JNI Java class object (obtained by calling AndroidJNI.FindClass).
--        methodName - Name of the method as declared in Java.
--        args - Array with parameters to be passed to the method when invoked.
--        isStatic - Set to <tt>true<tt> for static methods; <tt>false<tt> for instance (nonstatic) methods.
--        
--```
--
---@source UnityEngine.AndroidJNIModule.dll
---@param jclass System.IntPtr
---@param methodName string
---@param args object[]
---@param isStatic bool
---@return IntPtr
function CS.UnityEngine.AndroidJNIHelper:GetMethodID(jclass, methodName, args, isStatic) end

--
--Creates the JNI signature string for particular object type.
--
--```plaintext
--Params: obj - Object for which a signature is to be produced.
--        
--```
--
---@source UnityEngine.AndroidJNIModule.dll
---@param obj object
---@return String
function CS.UnityEngine.AndroidJNIHelper:GetSignature(obj) end

--
--Creates the JNI signature string for an object parameter list.
--
--```plaintext
--Params: args - Array of object for which a signature is to be produced.
--        
--```
--
---@source UnityEngine.AndroidJNIModule.dll
---@param args object[]
---@return String
function CS.UnityEngine.AndroidJNIHelper:GetSignature(args) end

---@source UnityEngine.AndroidJNIModule.dll
---@param array System.IntPtr
---@return ArrayType
function CS.UnityEngine.AndroidJNIHelper:ConvertFromJNIArray(array) end

---@source UnityEngine.AndroidJNIModule.dll
---@param jclass System.IntPtr
---@param methodName string
---@param args object[]
---@param isStatic bool
---@return IntPtr
function CS.UnityEngine.AndroidJNIHelper:GetMethodID(jclass, methodName, args, isStatic) end

---@source UnityEngine.AndroidJNIModule.dll
---@param jclass System.IntPtr
---@param fieldName string
---@param isStatic bool
---@return IntPtr
function CS.UnityEngine.AndroidJNIHelper:GetFieldID(jclass, fieldName, isStatic) end

---@source UnityEngine.AndroidJNIModule.dll
---@param args object[]
---@return String
function CS.UnityEngine.AndroidJNIHelper:GetSignature(args) end


--
--'Raw' JNI interface to Android Java VM from Unity scripting (C#).
--
--Note: Using raw JNI functions requires advanced knowledge of the Android Java Native Interface (JNI). Please take note.
--
---@source UnityEngine.AndroidJNIModule.dll
---@class UnityEngine.AndroidJNI: object
---@source UnityEngine.AndroidJNIModule.dll
CS.UnityEngine.AndroidJNI = {}

--
--Attaches the current thread to a Java (Dalvik) VM.
--
---@source UnityEngine.AndroidJNIModule.dll
---@return Int32
function CS.UnityEngine.AndroidJNI:AttachCurrentThread() end

--
--Detaches the current thread from a Java (Dalvik) VM.
--
---@source UnityEngine.AndroidJNIModule.dll
---@return Int32
function CS.UnityEngine.AndroidJNI:DetachCurrentThread() end

--
--Returns the version of the native method interface.
--
---@source UnityEngine.AndroidJNIModule.dll
---@return Int32
function CS.UnityEngine.AndroidJNI:GetVersion() end

--
--This function loads a locally-defined class.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param name string
---@return IntPtr
function CS.UnityEngine.AndroidJNI:FindClass(name) end

--
--Converts a <tt>java.lang.reflect.Method<tt> or <tt>java.lang.reflect.Constructor<tt> object to a method ID.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param refMethod System.IntPtr
---@return IntPtr
function CS.UnityEngine.AndroidJNI:FromReflectedMethod(refMethod) end

--
--Converts a <tt>java.lang.reflect.Field</tt> to a field ID.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param refField System.IntPtr
---@return IntPtr
function CS.UnityEngine.AndroidJNI:FromReflectedField(refField) end

--
--Converts a method ID derived from clazz to a <tt>java.lang.reflect.Method<tt> or <tt>java.lang.reflect.Constructor<tt> object.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param clazz System.IntPtr
---@param methodID System.IntPtr
---@param isStatic bool
---@return IntPtr
function CS.UnityEngine.AndroidJNI:ToReflectedMethod(clazz, methodID, isStatic) end

--
--Converts a field ID derived from cls to a <tt>java.lang.reflect.Field</tt> object.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param clazz System.IntPtr
---@param fieldID System.IntPtr
---@param isStatic bool
---@return IntPtr
function CS.UnityEngine.AndroidJNI:ToReflectedField(clazz, fieldID, isStatic) end

--
--If <tt>clazz<tt> represents any class other than the class <tt>Object<tt>, then this function returns the object that represents the superclass of the class specified by <tt>clazz</tt>.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param clazz System.IntPtr
---@return IntPtr
function CS.UnityEngine.AndroidJNI:GetSuperclass(clazz) end

--
--Determines whether an object of <tt>clazz1<tt> can be safely cast to <tt>clazz2<tt>.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param clazz1 System.IntPtr
---@param clazz2 System.IntPtr
---@return Boolean
function CS.UnityEngine.AndroidJNI:IsAssignableFrom(clazz1, clazz2) end

--
--Causes a <tt>java.lang.Throwable</tt> object to be thrown.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param obj System.IntPtr
---@return Int32
function CS.UnityEngine.AndroidJNI:Throw(obj) end

--
--Constructs an exception object from the specified class with the <tt>message</tt> specified by message and causes that exception to be thrown.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param clazz System.IntPtr
---@param message string
---@return Int32
function CS.UnityEngine.AndroidJNI:ThrowNew(clazz, message) end

--
--Determines if an exception is being thrown.
--
---@source UnityEngine.AndroidJNIModule.dll
---@return IntPtr
function CS.UnityEngine.AndroidJNI:ExceptionOccurred() end

--
--Prints an exception and a backtrace of the stack to the <tt>logcat</tt>
--
---@source UnityEngine.AndroidJNIModule.dll
function CS.UnityEngine.AndroidJNI:ExceptionDescribe() end

--
--Clears any exception that is currently being thrown.
--
---@source UnityEngine.AndroidJNIModule.dll
function CS.UnityEngine.AndroidJNI:ExceptionClear() end

--
--Raises a fatal error and does not expect the VM to recover. This function does not return.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param message string
function CS.UnityEngine.AndroidJNI:FatalError(message) end

--
--Creates a new local reference frame, in which at least a given number of local references can be created.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param capacity int
---@return Int32
function CS.UnityEngine.AndroidJNI:PushLocalFrame(capacity) end

--
--Pops off the current local reference frame, frees all the local references, and returns a local reference in the previous local reference frame for the given <tt>result</tt> object.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param ptr System.IntPtr
---@return IntPtr
function CS.UnityEngine.AndroidJNI:PopLocalFrame(ptr) end

--
--Creates a new global reference to the object referred to by the <tt>obj</tt> argument.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param obj System.IntPtr
---@return IntPtr
function CS.UnityEngine.AndroidJNI:NewGlobalRef(obj) end

--
--Deletes the global reference pointed to by <tt>obj</tt>.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param obj System.IntPtr
function CS.UnityEngine.AndroidJNI:DeleteGlobalRef(obj) end

--
--Creates a new global weak reference to the object referred to by the <tt>obj</tt> argument.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param obj System.IntPtr
---@return IntPtr
function CS.UnityEngine.AndroidJNI:NewWeakGlobalRef(obj) end

--
--Deletes the global weak reference pointed to by <tt>obj</tt>.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param obj System.IntPtr
function CS.UnityEngine.AndroidJNI:DeleteWeakGlobalRef(obj) end

--
--Creates a new local reference that refers to the same object as <tt>obj</tt>.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param obj System.IntPtr
---@return IntPtr
function CS.UnityEngine.AndroidJNI:NewLocalRef(obj) end

--
--Deletes the local reference pointed to by <tt>obj</tt>.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param obj System.IntPtr
function CS.UnityEngine.AndroidJNI:DeleteLocalRef(obj) end

--
--Tests whether two references refer to the same Java object.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param obj1 System.IntPtr
---@param obj2 System.IntPtr
---@return Boolean
function CS.UnityEngine.AndroidJNI:IsSameObject(obj1, obj2) end

--
--Ensures that at least a given number of local references can be created in the current thread.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param capacity int
---@return Int32
function CS.UnityEngine.AndroidJNI:EnsureLocalCapacity(capacity) end

--
--Allocates a new Java object without invoking any of the constructors for the object.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param clazz System.IntPtr
---@return IntPtr
function CS.UnityEngine.AndroidJNI:AllocObject(clazz) end

--
--Constructs a new Java object. The method ID indicates which constructor method to invoke. This ID must be obtained by calling GetMethodID() with <init> as the method name and void (V) as the return type.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param clazz System.IntPtr
---@param methodID System.IntPtr
---@param args UnityEngine.jvalue[]
---@return IntPtr
function CS.UnityEngine.AndroidJNI:NewObject(clazz, methodID, args) end

--
--Returns the class of an object.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param obj System.IntPtr
---@return IntPtr
function CS.UnityEngine.AndroidJNI:GetObjectClass(obj) end

--
--Tests whether an object is an instance of a class.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param obj System.IntPtr
---@param clazz System.IntPtr
---@return Boolean
function CS.UnityEngine.AndroidJNI:IsInstanceOf(obj, clazz) end

--
--Returns the method ID for an instance (nonstatic) method of a class or interface.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param clazz System.IntPtr
---@param name string
---@param sig string
---@return IntPtr
function CS.UnityEngine.AndroidJNI:GetMethodID(clazz, name, sig) end

--
--Returns the field ID for an instance (nonstatic) field of a class.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param clazz System.IntPtr
---@param name string
---@param sig string
---@return IntPtr
function CS.UnityEngine.AndroidJNI:GetFieldID(clazz, name, sig) end

--
--Returns the method ID for a static method of a class.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param clazz System.IntPtr
---@param name string
---@param sig string
---@return IntPtr
function CS.UnityEngine.AndroidJNI:GetStaticMethodID(clazz, name, sig) end

--
--Returns the field ID for a static field of a class.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param clazz System.IntPtr
---@param name string
---@param sig string
---@return IntPtr
function CS.UnityEngine.AndroidJNI:GetStaticFieldID(clazz, name, sig) end

--
--Constructs a new <tt>java.lang.String</tt> object from an array of Unicode characters.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param chars string
---@return IntPtr
function CS.UnityEngine.AndroidJNI:NewString(chars) end

--
--Constructs a new <tt>java.lang.String</tt> object from an array of Unicode characters.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param chars char[]
---@return IntPtr
function CS.UnityEngine.AndroidJNI:NewString(chars) end

--
--Constructs a new <tt>java.lang.String</tt> object from an array of characters in modified UTF-8 encoding.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param bytes string
---@return IntPtr
function CS.UnityEngine.AndroidJNI:NewStringUTF(bytes) end

--
--Returns a pointer to the array of Unicode characters of the string. This pointer is valid until ReleaseStringchars() is called.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param str System.IntPtr
---@return String
function CS.UnityEngine.AndroidJNI:GetStringChars(str) end

--
--Returns the length (the count of Unicode characters) of a Java string.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param str System.IntPtr
---@return Int32
function CS.UnityEngine.AndroidJNI:GetStringLength(str) end

--
--Returns the length in bytes of the modified UTF-8 representation of a string.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param str System.IntPtr
---@return Int32
function CS.UnityEngine.AndroidJNI:GetStringUTFLength(str) end

--
--Returns a managed string object representing the string in modified UTF-8 encoding.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param str System.IntPtr
---@return String
function CS.UnityEngine.AndroidJNI:GetStringUTFChars(str) end

--
--Calls a Java instance method defined by <tt>methodID<tt>, optionally passing an array of arguments (<tt>args<tt>) to the method.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param obj System.IntPtr
---@param methodID System.IntPtr
---@param args UnityEngine.jvalue[]
---@return String
function CS.UnityEngine.AndroidJNI:CallStringMethod(obj, methodID, args) end

--
--Calls a Java instance method defined by <tt>methodID<tt>, optionally passing an array of arguments (<tt>args<tt>) to the method.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param obj System.IntPtr
---@param methodID System.IntPtr
---@param args UnityEngine.jvalue[]
---@return IntPtr
function CS.UnityEngine.AndroidJNI:CallObjectMethod(obj, methodID, args) end

--
--Calls a Java instance method defined by <tt>methodID<tt>, optionally passing an array of arguments (<tt>args<tt>) to the method.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param obj System.IntPtr
---@param methodID System.IntPtr
---@param args UnityEngine.jvalue[]
---@return Int32
function CS.UnityEngine.AndroidJNI:CallIntMethod(obj, methodID, args) end

--
--Calls a Java instance method defined by <tt>methodID<tt>, optionally passing an array of arguments (<tt>args<tt>) to the method.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param obj System.IntPtr
---@param methodID System.IntPtr
---@param args UnityEngine.jvalue[]
---@return Boolean
function CS.UnityEngine.AndroidJNI:CallBooleanMethod(obj, methodID, args) end

--
--Calls a Java instance method defined by <tt>methodID<tt>, optionally passing an array of arguments (<tt>args<tt>) to the method.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param obj System.IntPtr
---@param methodID System.IntPtr
---@param args UnityEngine.jvalue[]
---@return Int16
function CS.UnityEngine.AndroidJNI:CallShortMethod(obj, methodID, args) end

--
--Calls a Java instance method defined by <tt>methodID<tt>, optionally passing an array of arguments (<tt>args<tt>) to the method.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param obj System.IntPtr
---@param methodID System.IntPtr
---@param args UnityEngine.jvalue[]
---@return Byte
function CS.UnityEngine.AndroidJNI:CallByteMethod(obj, methodID, args) end

--
--Calls a Java instance method defined by <tt>methodID<tt>, optionally passing an array of arguments (<tt>args<tt>) to the method.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param obj System.IntPtr
---@param methodID System.IntPtr
---@param args UnityEngine.jvalue[]
---@return SByte
function CS.UnityEngine.AndroidJNI:CallSByteMethod(obj, methodID, args) end

--
--Calls a Java instance method defined by <tt>methodID<tt>, optionally passing an array of arguments (<tt>args<tt>) to the method.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param obj System.IntPtr
---@param methodID System.IntPtr
---@param args UnityEngine.jvalue[]
---@return Char
function CS.UnityEngine.AndroidJNI:CallCharMethod(obj, methodID, args) end

--
--Calls a Java instance method defined by <tt>methodID<tt>, optionally passing an array of arguments (<tt>args<tt>) to the method.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param obj System.IntPtr
---@param methodID System.IntPtr
---@param args UnityEngine.jvalue[]
---@return Single
function CS.UnityEngine.AndroidJNI:CallFloatMethod(obj, methodID, args) end

--
--Calls a Java instance method defined by <tt>methodID<tt>, optionally passing an array of arguments (<tt>args<tt>) to the method.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param obj System.IntPtr
---@param methodID System.IntPtr
---@param args UnityEngine.jvalue[]
---@return Double
function CS.UnityEngine.AndroidJNI:CallDoubleMethod(obj, methodID, args) end

--
--Calls a Java instance method defined by <tt>methodID<tt>, optionally passing an array of arguments (<tt>args<tt>) to the method.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param obj System.IntPtr
---@param methodID System.IntPtr
---@param args UnityEngine.jvalue[]
---@return Int64
function CS.UnityEngine.AndroidJNI:CallLongMethod(obj, methodID, args) end

--
--Calls a Java instance method defined by <tt>methodID<tt>, optionally passing an array of arguments (<tt>args<tt>) to the method.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param obj System.IntPtr
---@param methodID System.IntPtr
---@param args UnityEngine.jvalue[]
function CS.UnityEngine.AndroidJNI:CallVoidMethod(obj, methodID, args) end

--
--Returns the value of an instance (nonstatic) field of an object.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param obj System.IntPtr
---@param fieldID System.IntPtr
---@return String
function CS.UnityEngine.AndroidJNI:GetStringField(obj, fieldID) end

--
--Returns the value of an instance (nonstatic) field of an object.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param obj System.IntPtr
---@param fieldID System.IntPtr
---@return IntPtr
function CS.UnityEngine.AndroidJNI:GetObjectField(obj, fieldID) end

--
--Returns the value of an instance (nonstatic) field of an object.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param obj System.IntPtr
---@param fieldID System.IntPtr
---@return Boolean
function CS.UnityEngine.AndroidJNI:GetBooleanField(obj, fieldID) end

--
--Returns the value of an instance (nonstatic) field of an object.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param obj System.IntPtr
---@param fieldID System.IntPtr
---@return Byte
function CS.UnityEngine.AndroidJNI:GetByteField(obj, fieldID) end

--
--Returns the value of an instance (nonstatic) field of an object.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param obj System.IntPtr
---@param fieldID System.IntPtr
---@return SByte
function CS.UnityEngine.AndroidJNI:GetSByteField(obj, fieldID) end

--
--Returns the value of an instance (nonstatic) field of an object.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param obj System.IntPtr
---@param fieldID System.IntPtr
---@return Char
function CS.UnityEngine.AndroidJNI:GetCharField(obj, fieldID) end

--
--Returns the value of an instance (nonstatic) field of an object.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param obj System.IntPtr
---@param fieldID System.IntPtr
---@return Int16
function CS.UnityEngine.AndroidJNI:GetShortField(obj, fieldID) end

--
--Returns the value of an instance (nonstatic) field of an object.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param obj System.IntPtr
---@param fieldID System.IntPtr
---@return Int32
function CS.UnityEngine.AndroidJNI:GetIntField(obj, fieldID) end

--
--Returns the value of an instance (nonstatic) field of an object.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param obj System.IntPtr
---@param fieldID System.IntPtr
---@return Int64
function CS.UnityEngine.AndroidJNI:GetLongField(obj, fieldID) end

--
--Returns the value of an instance (nonstatic) field of an object.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param obj System.IntPtr
---@param fieldID System.IntPtr
---@return Single
function CS.UnityEngine.AndroidJNI:GetFloatField(obj, fieldID) end

--
--Returns the value of an instance (nonstatic) field of an object.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param obj System.IntPtr
---@param fieldID System.IntPtr
---@return Double
function CS.UnityEngine.AndroidJNI:GetDoubleField(obj, fieldID) end

--
--Sets the value of an instance field of the specified object.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param obj System.IntPtr
---@param fieldID System.IntPtr
---@param val string
function CS.UnityEngine.AndroidJNI:SetStringField(obj, fieldID, val) end

--
--Sets the value of an instance field of the specified object.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param obj System.IntPtr
---@param fieldID System.IntPtr
---@param val System.IntPtr
function CS.UnityEngine.AndroidJNI:SetObjectField(obj, fieldID, val) end

--
--Sets the value of an instance field of the specified object.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param obj System.IntPtr
---@param fieldID System.IntPtr
---@param val bool
function CS.UnityEngine.AndroidJNI:SetBooleanField(obj, fieldID, val) end

--
--Sets the value of an instance field of the specified object.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param obj System.IntPtr
---@param fieldID System.IntPtr
---@param val byte
function CS.UnityEngine.AndroidJNI:SetByteField(obj, fieldID, val) end

--
--Sets the value of an instance field of the specified object.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param obj System.IntPtr
---@param fieldID System.IntPtr
---@param val sbyte
function CS.UnityEngine.AndroidJNI:SetSByteField(obj, fieldID, val) end

--
--Sets the value of an instance field of the specified object.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param obj System.IntPtr
---@param fieldID System.IntPtr
---@param val char
function CS.UnityEngine.AndroidJNI:SetCharField(obj, fieldID, val) end

--
--Sets the value of an instance field of the specified object.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param obj System.IntPtr
---@param fieldID System.IntPtr
---@param val short
function CS.UnityEngine.AndroidJNI:SetShortField(obj, fieldID, val) end

--
--Sets the value of an instance field of the specified object.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param obj System.IntPtr
---@param fieldID System.IntPtr
---@param val int
function CS.UnityEngine.AndroidJNI:SetIntField(obj, fieldID, val) end

--
--Sets the value of an instance field of the specified object.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param obj System.IntPtr
---@param fieldID System.IntPtr
---@param val long
function CS.UnityEngine.AndroidJNI:SetLongField(obj, fieldID, val) end

--
--Sets the value of an instance field of the specified object.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param obj System.IntPtr
---@param fieldID System.IntPtr
---@param val float
function CS.UnityEngine.AndroidJNI:SetFloatField(obj, fieldID, val) end

--
--Sets the value of an instance field of the specified object.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param obj System.IntPtr
---@param fieldID System.IntPtr
---@param val double
function CS.UnityEngine.AndroidJNI:SetDoubleField(obj, fieldID, val) end

--
--Invokes the specified <tt>methodID<tt> static method on a Java object, optionally passing in an array of arguments (<tt>args<tt>).
--
---@source UnityEngine.AndroidJNIModule.dll
---@param clazz System.IntPtr
---@param methodID System.IntPtr
---@param args UnityEngine.jvalue[]
---@return String
function CS.UnityEngine.AndroidJNI:CallStaticStringMethod(clazz, methodID, args) end

--
--Invokes the specified <tt>methodID<tt> static method on a Java object, optionally passing in an array of arguments (<tt>args<tt>).
--
---@source UnityEngine.AndroidJNIModule.dll
---@param clazz System.IntPtr
---@param methodID System.IntPtr
---@param args UnityEngine.jvalue[]
---@return IntPtr
function CS.UnityEngine.AndroidJNI:CallStaticObjectMethod(clazz, methodID, args) end

--
--Invokes the specified <tt>methodID<tt> static method on a Java object, optionally passing in an array of arguments (<tt>args<tt>).
--
---@source UnityEngine.AndroidJNIModule.dll
---@param clazz System.IntPtr
---@param methodID System.IntPtr
---@param args UnityEngine.jvalue[]
---@return Int32
function CS.UnityEngine.AndroidJNI:CallStaticIntMethod(clazz, methodID, args) end

--
--Invokes the specified <tt>methodID<tt> static method on a Java object, optionally passing in an array of arguments (<tt>args<tt>).
--
---@source UnityEngine.AndroidJNIModule.dll
---@param clazz System.IntPtr
---@param methodID System.IntPtr
---@param args UnityEngine.jvalue[]
---@return Boolean
function CS.UnityEngine.AndroidJNI:CallStaticBooleanMethod(clazz, methodID, args) end

--
--Invokes the specified <tt>methodID<tt> static method on a Java object, optionally passing in an array of arguments (<tt>args<tt>).
--
---@source UnityEngine.AndroidJNIModule.dll
---@param clazz System.IntPtr
---@param methodID System.IntPtr
---@param args UnityEngine.jvalue[]
---@return Int16
function CS.UnityEngine.AndroidJNI:CallStaticShortMethod(clazz, methodID, args) end

--
--Invokes the specified <tt>methodID<tt> static method on a Java object, optionally passing in an array of arguments (<tt>args<tt>).
--
---@source UnityEngine.AndroidJNIModule.dll
---@param clazz System.IntPtr
---@param methodID System.IntPtr
---@param args UnityEngine.jvalue[]
---@return Byte
function CS.UnityEngine.AndroidJNI:CallStaticByteMethod(clazz, methodID, args) end

--
--Invokes the specified <tt>methodID<tt> static method on a Java object, optionally passing in an array of arguments (<tt>args<tt>).
--
---@source UnityEngine.AndroidJNIModule.dll
---@param clazz System.IntPtr
---@param methodID System.IntPtr
---@param args UnityEngine.jvalue[]
---@return SByte
function CS.UnityEngine.AndroidJNI:CallStaticSByteMethod(clazz, methodID, args) end

--
--Invokes the specified <tt>methodID<tt> static method on a Java object, optionally passing in an array of arguments (<tt>args<tt>).
--
---@source UnityEngine.AndroidJNIModule.dll
---@param clazz System.IntPtr
---@param methodID System.IntPtr
---@param args UnityEngine.jvalue[]
---@return Char
function CS.UnityEngine.AndroidJNI:CallStaticCharMethod(clazz, methodID, args) end

--
--Invokes the specified <tt>methodID<tt> static method on a Java object, optionally passing in an array of arguments (<tt>args<tt>).
--
---@source UnityEngine.AndroidJNIModule.dll
---@param clazz System.IntPtr
---@param methodID System.IntPtr
---@param args UnityEngine.jvalue[]
---@return Single
function CS.UnityEngine.AndroidJNI:CallStaticFloatMethod(clazz, methodID, args) end

--
--Invokes the specified <tt>methodID<tt> static method on a Java object, optionally passing in an array of arguments (<tt>args<tt>).
--
---@source UnityEngine.AndroidJNIModule.dll
---@param clazz System.IntPtr
---@param methodID System.IntPtr
---@param args UnityEngine.jvalue[]
---@return Double
function CS.UnityEngine.AndroidJNI:CallStaticDoubleMethod(clazz, methodID, args) end

--
--Invokes the specified <tt>methodID<tt> static method on a Java object, optionally passing in an array of arguments (<tt>args<tt>).
--
---@source UnityEngine.AndroidJNIModule.dll
---@param clazz System.IntPtr
---@param methodID System.IntPtr
---@param args UnityEngine.jvalue[]
---@return Int64
function CS.UnityEngine.AndroidJNI:CallStaticLongMethod(clazz, methodID, args) end

--
--Invokes the specified <tt>methodID<tt> static method on a Java object, optionally passing in an array of arguments (<tt>args<tt>).
--
---@source UnityEngine.AndroidJNIModule.dll
---@param clazz System.IntPtr
---@param methodID System.IntPtr
---@param args UnityEngine.jvalue[]
function CS.UnityEngine.AndroidJNI:CallStaticVoidMethod(clazz, methodID, args) end

--
--Returns the value of a static field of an object.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param clazz System.IntPtr
---@param fieldID System.IntPtr
---@return String
function CS.UnityEngine.AndroidJNI:GetStaticStringField(clazz, fieldID) end

--
--Returns the value of a static field of an object.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param clazz System.IntPtr
---@param fieldID System.IntPtr
---@return IntPtr
function CS.UnityEngine.AndroidJNI:GetStaticObjectField(clazz, fieldID) end

--
--Returns the value of a static field of an object.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param clazz System.IntPtr
---@param fieldID System.IntPtr
---@return Boolean
function CS.UnityEngine.AndroidJNI:GetStaticBooleanField(clazz, fieldID) end

--
--Returns the value of a static field of an object.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param clazz System.IntPtr
---@param fieldID System.IntPtr
---@return Byte
function CS.UnityEngine.AndroidJNI:GetStaticByteField(clazz, fieldID) end

--
--Returns the value of a static field of an object.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param clazz System.IntPtr
---@param fieldID System.IntPtr
---@return SByte
function CS.UnityEngine.AndroidJNI:GetStaticSByteField(clazz, fieldID) end

--
--Returns the value of a static field of an object.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param clazz System.IntPtr
---@param fieldID System.IntPtr
---@return Char
function CS.UnityEngine.AndroidJNI:GetStaticCharField(clazz, fieldID) end

--
--Returns the value of a static field of an object.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param clazz System.IntPtr
---@param fieldID System.IntPtr
---@return Int16
function CS.UnityEngine.AndroidJNI:GetStaticShortField(clazz, fieldID) end

--
--Returns the value of a static field of an object.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param clazz System.IntPtr
---@param fieldID System.IntPtr
---@return Int32
function CS.UnityEngine.AndroidJNI:GetStaticIntField(clazz, fieldID) end

--
--Returns the value of a static field of an object.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param clazz System.IntPtr
---@param fieldID System.IntPtr
---@return Int64
function CS.UnityEngine.AndroidJNI:GetStaticLongField(clazz, fieldID) end

--
--Returns the value of a static field of an object.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param clazz System.IntPtr
---@param fieldID System.IntPtr
---@return Single
function CS.UnityEngine.AndroidJNI:GetStaticFloatField(clazz, fieldID) end

--
--Returns the value of a static field of an object.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param clazz System.IntPtr
---@param fieldID System.IntPtr
---@return Double
function CS.UnityEngine.AndroidJNI:GetStaticDoubleField(clazz, fieldID) end

--
--Sets the value of a static field in the specified object.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param clazz System.IntPtr
---@param fieldID System.IntPtr
---@param val string
function CS.UnityEngine.AndroidJNI:SetStaticStringField(clazz, fieldID, val) end

--
--Sets the value of a static field in the specified object.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param clazz System.IntPtr
---@param fieldID System.IntPtr
---@param val System.IntPtr
function CS.UnityEngine.AndroidJNI:SetStaticObjectField(clazz, fieldID, val) end

--
--Sets the value of a static field in the specified object.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param clazz System.IntPtr
---@param fieldID System.IntPtr
---@param val bool
function CS.UnityEngine.AndroidJNI:SetStaticBooleanField(clazz, fieldID, val) end

--
--Sets the value of a static field in the specified object.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param clazz System.IntPtr
---@param fieldID System.IntPtr
---@param val byte
function CS.UnityEngine.AndroidJNI:SetStaticByteField(clazz, fieldID, val) end

--
--Sets the value of a static field in the specified object.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param clazz System.IntPtr
---@param fieldID System.IntPtr
---@param val sbyte
function CS.UnityEngine.AndroidJNI:SetStaticSByteField(clazz, fieldID, val) end

--
--Sets the value of a static field in the specified object.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param clazz System.IntPtr
---@param fieldID System.IntPtr
---@param val char
function CS.UnityEngine.AndroidJNI:SetStaticCharField(clazz, fieldID, val) end

--
--Sets the value of a static field in the specified object.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param clazz System.IntPtr
---@param fieldID System.IntPtr
---@param val short
function CS.UnityEngine.AndroidJNI:SetStaticShortField(clazz, fieldID, val) end

--
--Sets the value of a static field in the specified object.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param clazz System.IntPtr
---@param fieldID System.IntPtr
---@param val int
function CS.UnityEngine.AndroidJNI:SetStaticIntField(clazz, fieldID, val) end

--
--Sets the value of a static field in the specified object.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param clazz System.IntPtr
---@param fieldID System.IntPtr
---@param val long
function CS.UnityEngine.AndroidJNI:SetStaticLongField(clazz, fieldID, val) end

--
--Sets the value of a static field in the specified object.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param clazz System.IntPtr
---@param fieldID System.IntPtr
---@param val float
function CS.UnityEngine.AndroidJNI:SetStaticFloatField(clazz, fieldID, val) end

--
--Sets the value of a static field in the specified object.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param clazz System.IntPtr
---@param fieldID System.IntPtr
---@param val double
function CS.UnityEngine.AndroidJNI:SetStaticDoubleField(clazz, fieldID, val) end

--
--Converts a managed array of System.Boolean to a Java array of <tt>boolean</tt>.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param array bool[]
---@return IntPtr
function CS.UnityEngine.AndroidJNI:ToBooleanArray(array) end

--
--Converts a managed array of System.Byte to a Java array of <tt>byte</tt>.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param array byte[]
---@return IntPtr
function CS.UnityEngine.AndroidJNI:ToByteArray(array) end

--
--Converts a managed array of System.SByte to a Java array of <tt>byte</tt>.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param array sbyte[]
---@return IntPtr
function CS.UnityEngine.AndroidJNI:ToSByteArray(array) end

--
--Converts a managed array of System.Char to a Java array of <tt>char</tt>.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param array char[]
---@return IntPtr
function CS.UnityEngine.AndroidJNI:ToCharArray(array) end

--
--Converts a managed array of System.Int16 to a Java array of <tt>short</tt>.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param array short[]
---@return IntPtr
function CS.UnityEngine.AndroidJNI:ToShortArray(array) end

--
--Converts a managed array of System.Int32 to a Java array of <tt>int</tt>.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param array int[]
---@return IntPtr
function CS.UnityEngine.AndroidJNI:ToIntArray(array) end

--
--Converts a managed array of System.Int64 to a Java array of <tt>long</tt>.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param array long[]
---@return IntPtr
function CS.UnityEngine.AndroidJNI:ToLongArray(array) end

--
--Converts a managed array of System.Single to a Java array of <tt>float</tt>.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param array float[]
---@return IntPtr
function CS.UnityEngine.AndroidJNI:ToFloatArray(array) end

--
--Converts a managed array of System.Double to a Java array of <tt>double</tt>.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param array double[]
---@return IntPtr
function CS.UnityEngine.AndroidJNI:ToDoubleArray(array) end

---@source UnityEngine.AndroidJNIModule.dll
---@param array System.IntPtr[]
---@param arrayClass System.IntPtr
---@return IntPtr
function CS.UnityEngine.AndroidJNI:ToObjectArray(array, arrayClass) end

--
--Converts a managed array of System.IntPtr, representing Java objects, to a Java array of <tt>java.lang.Object</tt>.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param array System.IntPtr[]
---@return IntPtr
function CS.UnityEngine.AndroidJNI:ToObjectArray(array) end

--
--Converts a Java array of <tt>boolean</tt> to a managed array of System.Boolean.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param array System.IntPtr
function CS.UnityEngine.AndroidJNI:FromBooleanArray(array) end

--
--Converts a Java array of <tt>byte</tt> to a managed array of System.Byte.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param array System.IntPtr
function CS.UnityEngine.AndroidJNI:FromByteArray(array) end

--
--Converts a Java array of <tt>byte</tt> to a managed array of System.SByte.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param array System.IntPtr
function CS.UnityEngine.AndroidJNI:FromSByteArray(array) end

--
--Converts a Java array of <tt>char</tt> to a managed array of System.Char.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param array System.IntPtr
function CS.UnityEngine.AndroidJNI:FromCharArray(array) end

--
--Converts a Java array of <tt>short</tt> to a managed array of System.Int16.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param array System.IntPtr
function CS.UnityEngine.AndroidJNI:FromShortArray(array) end

--
--Converts a Java array of <tt>int</tt> to a managed array of System.Int32.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param array System.IntPtr
function CS.UnityEngine.AndroidJNI:FromIntArray(array) end

--
--Converts a Java array of <tt>long</tt> to a managed array of System.Int64.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param array System.IntPtr
function CS.UnityEngine.AndroidJNI:FromLongArray(array) end

--
--Converts a Java array of <tt>float</tt> to a managed array of System.Single.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param array System.IntPtr
function CS.UnityEngine.AndroidJNI:FromFloatArray(array) end

--
--Converts a Java array of <tt>double</tt> to a managed array of System.Double.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param array System.IntPtr
function CS.UnityEngine.AndroidJNI:FromDoubleArray(array) end

--
--Converts a Java array of <tt>java.lang.Object</tt> to a managed array of System.IntPtr, representing Java objects.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param array System.IntPtr
function CS.UnityEngine.AndroidJNI:FromObjectArray(array) end

--
--Returns the number of elements in the array.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param array System.IntPtr
---@return Int32
function CS.UnityEngine.AndroidJNI:GetArrayLength(array) end

--
--Constructs a new primitive array object.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param size int
---@return IntPtr
function CS.UnityEngine.AndroidJNI:NewBooleanArray(size) end

--
--Constructs a new primitive array object.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param size int
---@return IntPtr
function CS.UnityEngine.AndroidJNI:NewByteArray(size) end

--
--Constructs a new primitive array object.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param size int
---@return IntPtr
function CS.UnityEngine.AndroidJNI:NewSByteArray(size) end

--
--Constructs a new primitive array object.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param size int
---@return IntPtr
function CS.UnityEngine.AndroidJNI:NewCharArray(size) end

--
--Constructs a new primitive array object.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param size int
---@return IntPtr
function CS.UnityEngine.AndroidJNI:NewShortArray(size) end

--
--Constructs a new primitive array object.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param size int
---@return IntPtr
function CS.UnityEngine.AndroidJNI:NewIntArray(size) end

--
--Constructs a new primitive array object.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param size int
---@return IntPtr
function CS.UnityEngine.AndroidJNI:NewLongArray(size) end

--
--Constructs a new primitive array object.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param size int
---@return IntPtr
function CS.UnityEngine.AndroidJNI:NewFloatArray(size) end

--
--Constructs a new primitive array object.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param size int
---@return IntPtr
function CS.UnityEngine.AndroidJNI:NewDoubleArray(size) end

--
--Constructs a new array holding objects in class <tt>clazz<tt>. All elements are initially set to <tt>obj<tt>.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param size int
---@param clazz System.IntPtr
---@param obj System.IntPtr
---@return IntPtr
function CS.UnityEngine.AndroidJNI:NewObjectArray(size, clazz, obj) end

--
--Returns the value of one element of a primitive array.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param array System.IntPtr
---@param index int
---@return Boolean
function CS.UnityEngine.AndroidJNI:GetBooleanArrayElement(array, index) end

--
--Returns the value of one element of a primitive array.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param array System.IntPtr
---@param index int
---@return Byte
function CS.UnityEngine.AndroidJNI:GetByteArrayElement(array, index) end

--
--Returns the value of one element of a primitive array.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param array System.IntPtr
---@param index int
---@return SByte
function CS.UnityEngine.AndroidJNI:GetSByteArrayElement(array, index) end

--
--Returns the value of one element of a primitive array.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param array System.IntPtr
---@param index int
---@return Char
function CS.UnityEngine.AndroidJNI:GetCharArrayElement(array, index) end

--
--Returns the value of one element of a primitive array.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param array System.IntPtr
---@param index int
---@return Int16
function CS.UnityEngine.AndroidJNI:GetShortArrayElement(array, index) end

--
--Returns the value of one element of a primitive array.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param array System.IntPtr
---@param index int
---@return Int32
function CS.UnityEngine.AndroidJNI:GetIntArrayElement(array, index) end

--
--Returns the value of one element of a primitive array.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param array System.IntPtr
---@param index int
---@return Int64
function CS.UnityEngine.AndroidJNI:GetLongArrayElement(array, index) end

--
--Returns the value of one element of a primitive array.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param array System.IntPtr
---@param index int
---@return Single
function CS.UnityEngine.AndroidJNI:GetFloatArrayElement(array, index) end

--
--Returns the value of one element of a primitive array.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param array System.IntPtr
---@param index int
---@return Double
function CS.UnityEngine.AndroidJNI:GetDoubleArrayElement(array, index) end

--
--Returns an element of an <tt>Object</tt> array.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param array System.IntPtr
---@param index int
---@return IntPtr
function CS.UnityEngine.AndroidJNI:GetObjectArrayElement(array, index) end

--
--Sets the boolean value of one element in a primitive array.
--
--```plaintext
--Params: array - The array of native booleans.
--        index - Index of the array element to set.
--        val - The value to set - for 'true' use 1, for 'false' use 0.
--        
--```
--
---@source UnityEngine.AndroidJNIModule.dll
---@param array System.IntPtr
---@param index int
---@param val byte
function CS.UnityEngine.AndroidJNI:SetBooleanArrayElement(array, index, val) end

--
--Sets the boolean value of one element in a primitive array.
--
--```plaintext
--Params: array - The array of native booleans.
--        index - Index of the array element to set.
--        val - The value to set.
--        
--```
--
---@source UnityEngine.AndroidJNIModule.dll
---@param array System.IntPtr
---@param index int
---@param val bool
function CS.UnityEngine.AndroidJNI:SetBooleanArrayElement(array, index, val) end

--
--Sets the sbyte value of one element in a primitive array.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param array System.IntPtr
---@param index int
---@param val sbyte
function CS.UnityEngine.AndroidJNI:SetByteArrayElement(array, index, val) end

--
--Sets the sbyte value of one element in a primitive array.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param array System.IntPtr
---@param index int
---@param val sbyte
function CS.UnityEngine.AndroidJNI:SetSByteArrayElement(array, index, val) end

--
--Sets the char value of one element in a primitive array.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param array System.IntPtr
---@param index int
---@param val char
function CS.UnityEngine.AndroidJNI:SetCharArrayElement(array, index, val) end

--
--Sets the short value of one element in a primitive array.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param array System.IntPtr
---@param index int
---@param val short
function CS.UnityEngine.AndroidJNI:SetShortArrayElement(array, index, val) end

--
--Sets the int value of one element in a primitive array.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param array System.IntPtr
---@param index int
---@param val int
function CS.UnityEngine.AndroidJNI:SetIntArrayElement(array, index, val) end

--
--Sets the long value of one element in a primitive array.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param array System.IntPtr
---@param index int
---@param val long
function CS.UnityEngine.AndroidJNI:SetLongArrayElement(array, index, val) end

--
--Sets the float value of one element in a primitive array.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param array System.IntPtr
---@param index int
---@param val float
function CS.UnityEngine.AndroidJNI:SetFloatArrayElement(array, index, val) end

--
--Sets the double value of one element in a primitive array.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param array System.IntPtr
---@param index int
---@param val double
function CS.UnityEngine.AndroidJNI:SetDoubleArrayElement(array, index, val) end

--
--Sets an element of an <tt>Object</tt> array.
--
---@source UnityEngine.AndroidJNIModule.dll
---@param array System.IntPtr
---@param index int
---@param obj System.IntPtr
function CS.UnityEngine.AndroidJNI:SetObjectArrayElement(array, index, obj) end


---@source UnityEngine.AnimationModule.dll
---@class UnityEngine.IAnimationClipSource
---@source UnityEngine.AnimationModule.dll
CS.UnityEngine.IAnimationClipSource = {}

---@source UnityEngine.AnimationModule.dll
---@param results System.Collections.Generic.List<UnityEngine.AnimationClip>
function CS.UnityEngine.IAnimationClipSource.GetAnimationClips(results) end


--
--SharedBetweenAnimatorsAttribute is an attribute that specify that this StateMachineBehaviour should be instantiate only once and shared among all Animator instance. This attribute reduce the memory footprint for each controller instance.
--
---@source UnityEngine.AnimationModule.dll
---@class UnityEngine.SharedBetweenAnimatorsAttribute: System.Attribute
---@source UnityEngine.AnimationModule.dll
CS.UnityEngine.SharedBetweenAnimatorsAttribute = {}


--
--StateMachineBehaviour is a component that can be added to a state machine state. It's the base class every script on a state derives from.
--
---@source UnityEngine.AnimationModule.dll
---@class UnityEngine.StateMachineBehaviour: UnityEngine.ScriptableObject
---@source UnityEngine.AnimationModule.dll
CS.UnityEngine.StateMachineBehaviour = {}

---@source UnityEngine.AnimationModule.dll
---@param animator UnityEngine.Animator
---@param stateInfo UnityEngine.AnimatorStateInfo
---@param layerIndex int
function CS.UnityEngine.StateMachineBehaviour.OnStateEnter(animator, stateInfo, layerIndex) end

---@source UnityEngine.AnimationModule.dll
---@param animator UnityEngine.Animator
---@param stateInfo UnityEngine.AnimatorStateInfo
---@param layerIndex int
function CS.UnityEngine.StateMachineBehaviour.OnStateUpdate(animator, stateInfo, layerIndex) end

---@source UnityEngine.AnimationModule.dll
---@param animator UnityEngine.Animator
---@param stateInfo UnityEngine.AnimatorStateInfo
---@param layerIndex int
function CS.UnityEngine.StateMachineBehaviour.OnStateExit(animator, stateInfo, layerIndex) end

---@source UnityEngine.AnimationModule.dll
---@param animator UnityEngine.Animator
---@param stateInfo UnityEngine.AnimatorStateInfo
---@param layerIndex int
function CS.UnityEngine.StateMachineBehaviour.OnStateMove(animator, stateInfo, layerIndex) end

---@source UnityEngine.AnimationModule.dll
---@param animator UnityEngine.Animator
---@param stateInfo UnityEngine.AnimatorStateInfo
---@param layerIndex int
function CS.UnityEngine.StateMachineBehaviour.OnStateIK(animator, stateInfo, layerIndex) end

--
--Called on the first Update frame when making a transition to a state machine. This is not called when making a transition into a state machine sub-state.
--
--```plaintext
--Params: animator - The Animator playing this state machine.
--        stateMachinePathHash - The full path hash for this state machine.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param animator UnityEngine.Animator
---@param stateMachinePathHash int
function CS.UnityEngine.StateMachineBehaviour.OnStateMachineEnter(animator, stateMachinePathHash) end

--
--Called on the last Update frame when making a transition out of a StateMachine. This is not called when making a transition into a StateMachine sub-state.
--
--```plaintext
--Params: animator - The Animator playing this state machine.
--        stateMachinePathHash - The full path hash for this state machine.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param animator UnityEngine.Animator
---@param stateMachinePathHash int
function CS.UnityEngine.StateMachineBehaviour.OnStateMachineExit(animator, stateMachinePathHash) end

---@source UnityEngine.AnimationModule.dll
---@param animator UnityEngine.Animator
---@param stateInfo UnityEngine.AnimatorStateInfo
---@param layerIndex int
---@param controller UnityEngine.Animations.AnimatorControllerPlayable
function CS.UnityEngine.StateMachineBehaviour.OnStateEnter(animator, stateInfo, layerIndex, controller) end

---@source UnityEngine.AnimationModule.dll
---@param animator UnityEngine.Animator
---@param stateInfo UnityEngine.AnimatorStateInfo
---@param layerIndex int
---@param controller UnityEngine.Animations.AnimatorControllerPlayable
function CS.UnityEngine.StateMachineBehaviour.OnStateUpdate(animator, stateInfo, layerIndex, controller) end

---@source UnityEngine.AnimationModule.dll
---@param animator UnityEngine.Animator
---@param stateInfo UnityEngine.AnimatorStateInfo
---@param layerIndex int
---@param controller UnityEngine.Animations.AnimatorControllerPlayable
function CS.UnityEngine.StateMachineBehaviour.OnStateExit(animator, stateInfo, layerIndex, controller) end

---@source UnityEngine.AnimationModule.dll
---@param animator UnityEngine.Animator
---@param stateInfo UnityEngine.AnimatorStateInfo
---@param layerIndex int
---@param controller UnityEngine.Animations.AnimatorControllerPlayable
function CS.UnityEngine.StateMachineBehaviour.OnStateMove(animator, stateInfo, layerIndex, controller) end

---@source UnityEngine.AnimationModule.dll
---@param animator UnityEngine.Animator
---@param stateInfo UnityEngine.AnimatorStateInfo
---@param layerIndex int
---@param controller UnityEngine.Animations.AnimatorControllerPlayable
function CS.UnityEngine.StateMachineBehaviour.OnStateIK(animator, stateInfo, layerIndex, controller) end

---@source UnityEngine.AnimationModule.dll
---@param animator UnityEngine.Animator
---@param stateMachinePathHash int
---@param controller UnityEngine.Animations.AnimatorControllerPlayable
function CS.UnityEngine.StateMachineBehaviour.OnStateMachineEnter(animator, stateMachinePathHash, controller) end

---@source UnityEngine.AnimationModule.dll
---@param animator UnityEngine.Animator
---@param stateMachinePathHash int
---@param controller UnityEngine.Animations.AnimatorControllerPlayable
function CS.UnityEngine.StateMachineBehaviour.OnStateMachineExit(animator, stateMachinePathHash, controller) end


--
--Used by Animation.Play function.
--
---@source UnityEngine.AnimationModule.dll
---@class UnityEngine.PlayMode: System.Enum
--
--Will stop all animations that were started in the same layer. This is the default when playing animations.
--
---@source UnityEngine.AnimationModule.dll
---@field StopSameLayer UnityEngine.PlayMode
--
--Will stop all animations that were started with this component before playing.
--
---@source UnityEngine.AnimationModule.dll
---@field StopAll UnityEngine.PlayMode
---@source UnityEngine.AnimationModule.dll
CS.UnityEngine.PlayMode = {}

---@source 
---@param value any
---@return UnityEngine.PlayMode
function CS.UnityEngine.PlayMode:__CastFrom(value) end


--
--Used by Animation.Play function.
--
---@source UnityEngine.AnimationModule.dll
---@class UnityEngine.QueueMode: System.Enum
--
--Will start playing after all other animations have stopped playing.
--
---@source UnityEngine.AnimationModule.dll
---@field CompleteOthers UnityEngine.QueueMode
--
--Starts playing immediately. This can be used if you just want to quickly create a duplicate animation.
--
---@source UnityEngine.AnimationModule.dll
---@field PlayNow UnityEngine.QueueMode
---@source UnityEngine.AnimationModule.dll
CS.UnityEngine.QueueMode = {}

---@source 
---@param value any
---@return UnityEngine.QueueMode
function CS.UnityEngine.QueueMode:__CastFrom(value) end


--
--Used by Animation.Play function.
--
---@source UnityEngine.AnimationModule.dll
---@class UnityEngine.AnimationBlendMode: System.Enum
--
--Animations will be blended.
--
---@source UnityEngine.AnimationModule.dll
---@field Blend UnityEngine.AnimationBlendMode
--
--Animations will be added.
--
---@source UnityEngine.AnimationModule.dll
---@field Additive UnityEngine.AnimationBlendMode
---@source UnityEngine.AnimationModule.dll
CS.UnityEngine.AnimationBlendMode = {}

---@source 
---@param value any
---@return UnityEngine.AnimationBlendMode
function CS.UnityEngine.AnimationBlendMode:__CastFrom(value) end


---@source UnityEngine.AnimationModule.dll
---@class UnityEngine.AnimationPlayMode: System.Enum
---@source UnityEngine.AnimationModule.dll
---@field Stop UnityEngine.AnimationPlayMode
---@source UnityEngine.AnimationModule.dll
---@field Queue UnityEngine.AnimationPlayMode
---@source UnityEngine.AnimationModule.dll
---@field Mix UnityEngine.AnimationPlayMode
---@source UnityEngine.AnimationModule.dll
CS.UnityEngine.AnimationPlayMode = {}

---@source 
---@param value any
---@return UnityEngine.AnimationPlayMode
function CS.UnityEngine.AnimationPlayMode:__CastFrom(value) end


--
--This enum controlls culling of Animation component.
--
---@source UnityEngine.AnimationModule.dll
---@class UnityEngine.AnimationCullingType: System.Enum
--
--Animation culling is disabled - object is animated even when offscreen.
--
---@source UnityEngine.AnimationModule.dll
---@field AlwaysAnimate UnityEngine.AnimationCullingType
--
--Animation is disabled when renderers are not visible.
--
---@source UnityEngine.AnimationModule.dll
---@field BasedOnRenderers UnityEngine.AnimationCullingType
---@source UnityEngine.AnimationModule.dll
---@field BasedOnClipBounds UnityEngine.AnimationCullingType
---@source UnityEngine.AnimationModule.dll
---@field BasedOnUserBounds UnityEngine.AnimationCullingType
---@source UnityEngine.AnimationModule.dll
CS.UnityEngine.AnimationCullingType = {}

---@source 
---@param value any
---@return UnityEngine.AnimationCullingType
function CS.UnityEngine.AnimationCullingType:__CastFrom(value) end


--
--The animation component is used to play back animations.
--
---@source UnityEngine.AnimationModule.dll
---@class UnityEngine.Animation: UnityEngine.Behaviour
--
--The default animation.
--
---@source UnityEngine.AnimationModule.dll
---@field clip UnityEngine.AnimationClip
--
--Should the default animation clip (the Animation.clip property) automatically start playing on startup?
--
---@source UnityEngine.AnimationModule.dll
---@field playAutomatically bool
--
--How should time beyond the playback range of the clip be treated?
--
---@source UnityEngine.AnimationModule.dll
---@field wrapMode UnityEngine.WrapMode
--
--Is an animation currently being played?
--
---@source UnityEngine.AnimationModule.dll
---@field isPlaying bool
---@source UnityEngine.AnimationModule.dll
---@field this[] UnityEngine.AnimationState
--
--When turned on, animations will be executed in the physics loop. This is only useful in conjunction with kinematic rigidbodies.
--
---@source UnityEngine.AnimationModule.dll
---@field animatePhysics bool
--
--When turned on, Unity might stop animating if it thinks that the results of the animation won't be visible to the user.
--
---@source UnityEngine.AnimationModule.dll
---@field animateOnlyIfVisible bool
--
--Controls culling of this Animation component.
--
---@source UnityEngine.AnimationModule.dll
---@field cullingType UnityEngine.AnimationCullingType
--
--AABB of this Animation animation component in local space.
--
---@source UnityEngine.AnimationModule.dll
---@field localBounds UnityEngine.Bounds
---@source UnityEngine.AnimationModule.dll
CS.UnityEngine.Animation = {}

--
--Stops all playing animations that were started with this Animation.
--
---@source UnityEngine.AnimationModule.dll
function CS.UnityEngine.Animation.Stop() end

--
--Stops an animation named name.
--
---@source UnityEngine.AnimationModule.dll
---@param name string
function CS.UnityEngine.Animation.Stop(name) end

--
--Rewinds all animations.
--
---@source UnityEngine.AnimationModule.dll
function CS.UnityEngine.Animation.Rewind() end

--
--Rewinds the animation named name.
--
---@source UnityEngine.AnimationModule.dll
---@param name string
function CS.UnityEngine.Animation.Rewind(name) end

--
--Samples animations at the current state.
--
---@source UnityEngine.AnimationModule.dll
function CS.UnityEngine.Animation.Sample() end

--
--Is the animation named name playing?
--
---@source UnityEngine.AnimationModule.dll
---@param name string
---@return Boolean
function CS.UnityEngine.Animation.IsPlaying(name) end

---@source UnityEngine.AnimationModule.dll
---@return Boolean
function CS.UnityEngine.Animation.Play() end

--
--Plays an animation without blending.
--
---@source UnityEngine.AnimationModule.dll
---@param mode UnityEngine.PlayMode
---@return Boolean
function CS.UnityEngine.Animation.Play(mode) end

--
--Plays an animation without blending.
--
---@source UnityEngine.AnimationModule.dll
---@param animation string
---@return Boolean
function CS.UnityEngine.Animation.Play(animation) end

--
--Plays an animation without blending.
--
---@source UnityEngine.AnimationModule.dll
---@param animation string
---@param mode UnityEngine.PlayMode
---@return Boolean
function CS.UnityEngine.Animation.Play(animation, mode) end

--
--Fades the animation with name animation in over a period of time seconds and fades other animations out.
--
---@source UnityEngine.AnimationModule.dll
---@param animation string
function CS.UnityEngine.Animation.CrossFade(animation) end

--
--Fades the animation with name animation in over a period of time seconds and fades other animations out.
--
---@source UnityEngine.AnimationModule.dll
---@param animation string
---@param fadeLength float
function CS.UnityEngine.Animation.CrossFade(animation, fadeLength) end

--
--Fades the animation with name animation in over a period of time seconds and fades other animations out.
--
---@source UnityEngine.AnimationModule.dll
---@param animation string
---@param fadeLength float
---@param mode UnityEngine.PlayMode
function CS.UnityEngine.Animation.CrossFade(animation, fadeLength, mode) end

--
--Blends the animation named animation towards targetWeight over the next time seconds.
--
---@source UnityEngine.AnimationModule.dll
---@param animation string
function CS.UnityEngine.Animation.Blend(animation) end

--
--Blends the animation named animation towards targetWeight over the next time seconds.
--
---@source UnityEngine.AnimationModule.dll
---@param animation string
---@param targetWeight float
function CS.UnityEngine.Animation.Blend(animation, targetWeight) end

--
--Blends the animation named animation towards targetWeight over the next time seconds.
--
---@source UnityEngine.AnimationModule.dll
---@param animation string
---@param targetWeight float
---@param fadeLength float
function CS.UnityEngine.Animation.Blend(animation, targetWeight, fadeLength) end

--
--Cross fades an animation after previous animations has finished playing.
--
---@source UnityEngine.AnimationModule.dll
---@param animation string
---@return AnimationState
function CS.UnityEngine.Animation.CrossFadeQueued(animation) end

--
--Cross fades an animation after previous animations has finished playing.
--
---@source UnityEngine.AnimationModule.dll
---@param animation string
---@param fadeLength float
---@return AnimationState
function CS.UnityEngine.Animation.CrossFadeQueued(animation, fadeLength) end

--
--Cross fades an animation after previous animations has finished playing.
--
---@source UnityEngine.AnimationModule.dll
---@param animation string
---@param fadeLength float
---@param queue UnityEngine.QueueMode
---@return AnimationState
function CS.UnityEngine.Animation.CrossFadeQueued(animation, fadeLength, queue) end

--
--Cross fades an animation after previous animations has finished playing.
--
---@source UnityEngine.AnimationModule.dll
---@param animation string
---@param fadeLength float
---@param queue UnityEngine.QueueMode
---@param mode UnityEngine.PlayMode
---@return AnimationState
function CS.UnityEngine.Animation.CrossFadeQueued(animation, fadeLength, queue, mode) end

--
--Plays an animation after previous animations has finished playing.
--
---@source UnityEngine.AnimationModule.dll
---@param animation string
---@return AnimationState
function CS.UnityEngine.Animation.PlayQueued(animation) end

--
--Plays an animation after previous animations has finished playing.
--
---@source UnityEngine.AnimationModule.dll
---@param animation string
---@param queue UnityEngine.QueueMode
---@return AnimationState
function CS.UnityEngine.Animation.PlayQueued(animation, queue) end

--
--Plays an animation after previous animations has finished playing.
--
---@source UnityEngine.AnimationModule.dll
---@param animation string
---@param queue UnityEngine.QueueMode
---@param mode UnityEngine.PlayMode
---@return AnimationState
function CS.UnityEngine.Animation.PlayQueued(animation, queue, mode) end

--
--Adds a clip to the animation with name newName.
--
---@source UnityEngine.AnimationModule.dll
---@param clip UnityEngine.AnimationClip
---@param newName string
function CS.UnityEngine.Animation.AddClip(clip, newName) end

--
--Adds clip to the only play between firstFrame and lastFrame. The new clip will also be added to the animation with name newName.
--
--```plaintext
--Params: addLoopFrame - Should an extra frame be inserted at the end that matches the first frame? Turn this on if you are making a looping animation.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param clip UnityEngine.AnimationClip
---@param newName string
---@param firstFrame int
---@param lastFrame int
function CS.UnityEngine.Animation.AddClip(clip, newName, firstFrame, lastFrame) end

--
--Adds clip to the only play between firstFrame and lastFrame. The new clip will also be added to the animation with name newName.
--
--```plaintext
--Params: addLoopFrame - Should an extra frame be inserted at the end that matches the first frame? Turn this on if you are making a looping animation.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param clip UnityEngine.AnimationClip
---@param newName string
---@param firstFrame int
---@param lastFrame int
---@param addLoopFrame bool
function CS.UnityEngine.Animation.AddClip(clip, newName, firstFrame, lastFrame, addLoopFrame) end

--
--Remove clip from the animation list.
--
---@source UnityEngine.AnimationModule.dll
---@param clip UnityEngine.AnimationClip
function CS.UnityEngine.Animation.RemoveClip(clip) end

--
--Remove clip from the animation list.
--
---@source UnityEngine.AnimationModule.dll
---@param clipName string
function CS.UnityEngine.Animation.RemoveClip(clipName) end

--
--Get the number of clips currently assigned to this animation.
--
---@source UnityEngine.AnimationModule.dll
---@return Int32
function CS.UnityEngine.Animation.GetClipCount() end

---@source UnityEngine.AnimationModule.dll
---@param mode UnityEngine.AnimationPlayMode
---@return Boolean
function CS.UnityEngine.Animation.Play(mode) end

---@source UnityEngine.AnimationModule.dll
---@param animation string
---@param mode UnityEngine.AnimationPlayMode
---@return Boolean
function CS.UnityEngine.Animation.Play(animation, mode) end

---@source UnityEngine.AnimationModule.dll
---@param layer int
function CS.UnityEngine.Animation.SyncLayer(layer) end

---@source UnityEngine.AnimationModule.dll
---@return IEnumerator
function CS.UnityEngine.Animation.GetEnumerator() end

---@source UnityEngine.AnimationModule.dll
---@param name string
---@return AnimationClip
function CS.UnityEngine.Animation.GetClip(name) end


--
--The AnimationState gives full control over animation blending.
--
---@source UnityEngine.AnimationModule.dll
---@class UnityEngine.AnimationState: UnityEngine.TrackedReference
--
--Enables / disables the animation.
--
---@source UnityEngine.AnimationModule.dll
---@field enabled bool
--
--The weight of animation.
--
---@source UnityEngine.AnimationModule.dll
---@field weight float
--
--Wrapping mode of the animation.
--
---@source UnityEngine.AnimationModule.dll
---@field wrapMode UnityEngine.WrapMode
--
--The current time of the animation.
--
---@source UnityEngine.AnimationModule.dll
---@field time float
--
--The normalized time of the animation.
--
---@source UnityEngine.AnimationModule.dll
---@field normalizedTime float
--
--The playback speed of the animation. 1 is normal playback speed.
--
---@source UnityEngine.AnimationModule.dll
---@field speed float
--
--The normalized playback speed.
--
---@source UnityEngine.AnimationModule.dll
---@field normalizedSpeed float
--
--The length of the animation clip in seconds.
--
---@source UnityEngine.AnimationModule.dll
---@field length float
---@source UnityEngine.AnimationModule.dll
---@field layer int
--
--The clip that is being played by this animation state.
--
---@source UnityEngine.AnimationModule.dll
---@field clip UnityEngine.AnimationClip
--
--The name of the animation.
--
---@source UnityEngine.AnimationModule.dll
---@field name string
--
--Which blend mode should be used?
--
---@source UnityEngine.AnimationModule.dll
---@field blendMode UnityEngine.AnimationBlendMode
---@source UnityEngine.AnimationModule.dll
CS.UnityEngine.AnimationState = {}

--
--Adds a transform which should be animated. This allows you to reduce the number of animations you have to create.
--
--```plaintext
--Params: mix - The transform to animate.
--        recursive - Whether to also animate all children of the specified transform.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param mix UnityEngine.Transform
function CS.UnityEngine.AnimationState.AddMixingTransform(mix) end

--
--Adds a transform which should be animated. This allows you to reduce the number of animations you have to create.
--
--```plaintext
--Params: mix - The transform to animate.
--        recursive - Whether to also animate all children of the specified transform.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param mix UnityEngine.Transform
---@param recursive bool
function CS.UnityEngine.AnimationState.AddMixingTransform(mix, recursive) end

--
--Removes a transform which should be animated.
--
---@source UnityEngine.AnimationModule.dll
---@param mix UnityEngine.Transform
function CS.UnityEngine.AnimationState.RemoveMixingTransform(mix) end


--
--AnimationEvent lets you call a script function similar to SendMessage as part of playing back an animation.
--
---@source UnityEngine.AnimationModule.dll
---@class UnityEngine.AnimationEvent: object
---@source UnityEngine.AnimationModule.dll
---@field data string
--
--String parameter that is stored in the event and will be sent to the function.
--
---@source UnityEngine.AnimationModule.dll
---@field stringParameter string
--
--Float parameter that is stored in the event and will be sent to the function.
--
---@source UnityEngine.AnimationModule.dll
---@field floatParameter float
--
--Int parameter that is stored in the event and will be sent to the function.
--
---@source UnityEngine.AnimationModule.dll
---@field intParameter int
--
--Object reference parameter that is stored in the event and will be sent to the function.
--
---@source UnityEngine.AnimationModule.dll
---@field objectReferenceParameter UnityEngine.Object
--
--The name of the function that will be called.
--
---@source UnityEngine.AnimationModule.dll
---@field functionName string
--
--The time at which the event will be fired off.
--
---@source UnityEngine.AnimationModule.dll
---@field time float
--
--Function call options.
--
---@source UnityEngine.AnimationModule.dll
---@field messageOptions UnityEngine.SendMessageOptions
--
--Returns true if this Animation event has been fired by an Animation component.
--
---@source UnityEngine.AnimationModule.dll
---@field isFiredByLegacy bool
--
--Returns true if this Animation event has been fired by an Animator component.
--
---@source UnityEngine.AnimationModule.dll
---@field isFiredByAnimator bool
--
--The animation state that fired this event (Read Only).
--
---@source UnityEngine.AnimationModule.dll
---@field animationState UnityEngine.AnimationState
--
--The animator state info related to this event (Read Only).
--
---@source UnityEngine.AnimationModule.dll
---@field animatorStateInfo UnityEngine.AnimatorStateInfo
--
--The animator clip info related to this event (Read Only).
--
---@source UnityEngine.AnimationModule.dll
---@field animatorClipInfo UnityEngine.AnimatorClipInfo
---@source UnityEngine.AnimationModule.dll
CS.UnityEngine.AnimationEvent = {}


--
--Stores keyframe based animations.
--
---@source UnityEngine.AnimationModule.dll
---@class UnityEngine.AnimationClip: UnityEngine.Motion
--
--Animation length in seconds. (Read Only)
--
---@source UnityEngine.AnimationModule.dll
---@field length float
--
--Frame rate at which keyframes are sampled. (Read Only)
--
---@source UnityEngine.AnimationModule.dll
---@field frameRate float
--
--Sets the default wrap mode used in the animation state.
--
---@source UnityEngine.AnimationModule.dll
---@field wrapMode UnityEngine.WrapMode
--
--AABB of this Animation Clip in local space of Animation component that it is attached too.
--
---@source UnityEngine.AnimationModule.dll
---@field localBounds UnityEngine.Bounds
--
--Set to true if the AnimationClip will be used with the Legacy Animation component ( instead of the Animator ).
--
---@source UnityEngine.AnimationModule.dll
---@field legacy bool
--
--Returns true if the animation contains curve that drives a humanoid rig.
--
---@source UnityEngine.AnimationModule.dll
---@field humanMotion bool
--
--Returns true if the animation clip has no curves and no events.
--
---@source UnityEngine.AnimationModule.dll
---@field empty bool
--
--Returns true if the Animation has animation on the root transform.
--
---@source UnityEngine.AnimationModule.dll
---@field hasGenericRootTransform bool
--
--Returns true if the AnimationClip has editor curves for its root motion.
--
---@source UnityEngine.AnimationModule.dll
---@field hasMotionFloatCurves bool
--
--Returns true if the AnimationClip has root motion curves.
--
---@source UnityEngine.AnimationModule.dll
---@field hasMotionCurves bool
--
--Returns true if the AnimationClip has root Curves.
--
---@source UnityEngine.AnimationModule.dll
---@field hasRootCurves bool
--
--Animation Events for this animation clip.
--
---@source UnityEngine.AnimationModule.dll
---@field events UnityEngine.AnimationEvent[]
---@source UnityEngine.AnimationModule.dll
CS.UnityEngine.AnimationClip = {}

--
--Samples an animation at a given time for any animated properties.
--
--```plaintext
--Params: go - The animated game object.
--        time - The time to sample an animation.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param go UnityEngine.GameObject
---@param time float
function CS.UnityEngine.AnimationClip.SampleAnimation(go, time) end

--
--Assigns the curve to animate a specific property.
--
--```plaintext
--Params: relativePath - Path to the game object this curve applies to. The relativePath
--        is formatted similar to a pathname, e.g. "rootspineleftArm".  If relativePath
--        is empty it refers to the game object the animation clip is attached to.
--        type - The class type of the component that is animated.
--        propertyName - The name or path to the property being animated.
--        curve - The animation curve.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param relativePath string
---@param type System.Type
---@param propertyName string
---@param curve UnityEngine.AnimationCurve
function CS.UnityEngine.AnimationClip.SetCurve(relativePath, type, propertyName, curve) end

--
--Realigns quaternion keys to ensure shortest interpolation paths.
--
---@source UnityEngine.AnimationModule.dll
function CS.UnityEngine.AnimationClip.EnsureQuaternionContinuity() end

--
--Clears all curves from the clip.
--
---@source UnityEngine.AnimationModule.dll
function CS.UnityEngine.AnimationClip.ClearCurves() end

--
--Adds an animation event to the clip.
--
--```plaintext
--Params: evt - AnimationEvent to add.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param evt UnityEngine.AnimationEvent
function CS.UnityEngine.AnimationClip.AddEvent(evt) end


--
--Target.
--
---@source UnityEngine.AnimationModule.dll
---@class UnityEngine.AvatarTarget: System.Enum
--
--The root, the position of the game object.
--
---@source UnityEngine.AnimationModule.dll
---@field Root UnityEngine.AvatarTarget
--
--The body, center of mass.
--
---@source UnityEngine.AnimationModule.dll
---@field Body UnityEngine.AvatarTarget
--
--The left foot.
--
---@source UnityEngine.AnimationModule.dll
---@field LeftFoot UnityEngine.AvatarTarget
--
--The right foot.
--
---@source UnityEngine.AnimationModule.dll
---@field RightFoot UnityEngine.AvatarTarget
--
--The left hand.
--
---@source UnityEngine.AnimationModule.dll
---@field LeftHand UnityEngine.AvatarTarget
--
--The right hand.
--
---@source UnityEngine.AnimationModule.dll
---@field RightHand UnityEngine.AvatarTarget
---@source UnityEngine.AnimationModule.dll
CS.UnityEngine.AvatarTarget = {}

---@source 
---@param value any
---@return UnityEngine.AvatarTarget
function CS.UnityEngine.AvatarTarget:__CastFrom(value) end


--
--Information about what animation clips is played and its weight.
--
---@source UnityEngine.AnimationModule.dll
---@class UnityEngine.AnimationInfo: System.ValueType
--
--Animation clip that is played.
--
---@source UnityEngine.AnimationModule.dll
---@field clip UnityEngine.AnimationClip
--
--The weight of the animation clip.
--
---@source UnityEngine.AnimationModule.dll
---@field weight float
---@source UnityEngine.AnimationModule.dll
CS.UnityEngine.AnimationInfo = {}


--
--Interface to control the Mecanim animation system.
--
---@source UnityEngine.AnimationModule.dll
---@class UnityEngine.Animator: UnityEngine.Behaviour
--
--Returns true if the current rig is optimizable with AnimatorUtility.OptimizeTransformHierarchy.
--
---@source UnityEngine.AnimationModule.dll
---@field isOptimizable bool
--
--Returns true if the current rig is humanoid, false if it is generic.
--
---@source UnityEngine.AnimationModule.dll
---@field isHuman bool
--
--Returns true if the current rig has root motion.
--
---@source UnityEngine.AnimationModule.dll
---@field hasRootMotion bool
--
--Returns the scale of the current Avatar for a humanoid rig, (1 by default if the rig is generic).
--
---@source UnityEngine.AnimationModule.dll
---@field humanScale float
--
--Returns whether the animator is initialized successfully.
--
---@source UnityEngine.AnimationModule.dll
---@field isInitialized bool
--
--Gets the avatar delta position for the last evaluated frame.
--
---@source UnityEngine.AnimationModule.dll
---@field deltaPosition UnityEngine.Vector3
--
--Gets the avatar delta rotation for the last evaluated frame.
--
---@source UnityEngine.AnimationModule.dll
---@field deltaRotation UnityEngine.Quaternion
--
--Gets the avatar velocity  for the last evaluated frame.
--
---@source UnityEngine.AnimationModule.dll
---@field velocity UnityEngine.Vector3
--
--Gets the avatar angular velocity for the last evaluated frame.
--
---@source UnityEngine.AnimationModule.dll
---@field angularVelocity UnityEngine.Vector3
--
--The root position, the position of the game object.
--
---@source UnityEngine.AnimationModule.dll
---@field rootPosition UnityEngine.Vector3
--
--The root rotation, the rotation of the game object.
--
---@source UnityEngine.AnimationModule.dll
---@field rootRotation UnityEngine.Quaternion
--
--Should root motion be applied?
--
---@source UnityEngine.AnimationModule.dll
---@field applyRootMotion bool
--
--When linearVelocityBlending is set to true, the root motion velocity and angular velocity will be blended linearly.
--
---@source UnityEngine.AnimationModule.dll
---@field linearVelocityBlending bool
--
--When turned on, animations will be executed in the physics loop. This is only useful in conjunction with kinematic rigidbodies.
--
---@source UnityEngine.AnimationModule.dll
---@field animatePhysics bool
--
--Specifies the update mode of the Animator.
--
---@source UnityEngine.AnimationModule.dll
---@field updateMode UnityEngine.AnimatorUpdateMode
--
--Returns true if the object has a transform hierarchy.
--
---@source UnityEngine.AnimationModule.dll
---@field hasTransformHierarchy bool
--
--The current gravity weight based on current animations that are played.
--
---@source UnityEngine.AnimationModule.dll
---@field gravityWeight float
--
--The position of the body center of mass.
--
---@source UnityEngine.AnimationModule.dll
---@field bodyPosition UnityEngine.Vector3
--
--The rotation of the body center of mass.
--
---@source UnityEngine.AnimationModule.dll
---@field bodyRotation UnityEngine.Quaternion
--
--Automatic stabilization of feet during transition and blending.
--
---@source UnityEngine.AnimationModule.dll
---@field stabilizeFeet bool
--
--Returns the number of layers in the controller.
--
---@source UnityEngine.AnimationModule.dll
---@field layerCount int
--
--The AnimatorControllerParameter list used by the animator. (Read Only)
--
---@source UnityEngine.AnimationModule.dll
---@field parameters UnityEngine.AnimatorControllerParameter[]
--
--Returns the number of parameters in the controller.
--
---@source UnityEngine.AnimationModule.dll
---@field parameterCount int
--
--Blends pivot point between body center of mass and feet pivot.
--
---@source UnityEngine.AnimationModule.dll
---@field feetPivotActive float
--
--Gets the pivot weight.
--
---@source UnityEngine.AnimationModule.dll
---@field pivotWeight float
--
--Get the current position of the pivot.
--
---@source UnityEngine.AnimationModule.dll
---@field pivotPosition UnityEngine.Vector3
--
--If automatic matching is active.
--
---@source UnityEngine.AnimationModule.dll
---@field isMatchingTarget bool
--
--The playback speed of the Animator. 1 is normal playback speed.
--
---@source UnityEngine.AnimationModule.dll
---@field speed float
--
--Returns the position of the target specified by SetTarget.
--
---@source UnityEngine.AnimationModule.dll
---@field targetPosition UnityEngine.Vector3
--
--Returns the rotation of the target specified by SetTarget.
--
---@source UnityEngine.AnimationModule.dll
---@field targetRotation UnityEngine.Quaternion
--
--Controls culling of this Animator component.
--
---@source UnityEngine.AnimationModule.dll
---@field cullingMode UnityEngine.AnimatorCullingMode
--
--Sets the playback position in the recording buffer.
--
---@source UnityEngine.AnimationModule.dll
---@field playbackTime float
--
--Start time of the first frame of the buffer relative to the frame at which StartRecording was called.
--
---@source UnityEngine.AnimationModule.dll
---@field recorderStartTime float
--
--End time of the recorded clip relative to when StartRecording was called.
--
---@source UnityEngine.AnimationModule.dll
---@field recorderStopTime float
--
--Gets the mode of the Animator recorder.
--
---@source UnityEngine.AnimationModule.dll
---@field recorderMode UnityEngine.AnimatorRecorderMode
--
--The runtime representation of AnimatorController that controls the Animator.
--
---@source UnityEngine.AnimationModule.dll
---@field runtimeAnimatorController UnityEngine.RuntimeAnimatorController
--
--Returns true if Animator has any playables assigned to it.
--
---@source UnityEngine.AnimationModule.dll
---@field hasBoundPlayables bool
--
--Gets/Sets the current Avatar.
--
---@source UnityEngine.AnimationModule.dll
---@field avatar UnityEngine.Avatar
--
--The PlayableGraph created by the Animator.
--
---@source UnityEngine.AnimationModule.dll
---@field playableGraph UnityEngine.Playables.PlayableGraph
--
--Additional layers affects the center of mass.
--
---@source UnityEngine.AnimationModule.dll
---@field layersAffectMassCenter bool
--
--Get left foot bottom height.
--
---@source UnityEngine.AnimationModule.dll
---@field leftFeetBottomHeight float
--
--Get right foot bottom height.
--
---@source UnityEngine.AnimationModule.dll
---@field rightFeetBottomHeight float
---@source UnityEngine.AnimationModule.dll
---@field logWarnings bool
--
--Sets whether the Animator sends events of type AnimationEvent.
--
---@source UnityEngine.AnimationModule.dll
---@field fireEvents bool
--
--Controls the behaviour of the Animator component when a GameObject is disabled.
--
---@source UnityEngine.AnimationModule.dll
---@field keepAnimatorControllerStateOnDisable bool
---@source UnityEngine.AnimationModule.dll
CS.UnityEngine.Animator = {}

--
--Gets the list of AnimatorClipInfo currently played by the current state.
--
--```plaintext
--Params: layerIndex - The layer's index.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param layerIndex int
function CS.UnityEngine.Animator.GetCurrentAnimationClipState(layerIndex) end

--
--Gets the list of AnimatorClipInfo currently played by the next state.
--
--```plaintext
--Params: layerIndex - The layer's index.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param layerIndex int
function CS.UnityEngine.Animator.GetNextAnimationClipState(layerIndex) end

---@source UnityEngine.AnimationModule.dll
function CS.UnityEngine.Animator.Stop() end

--
--The value of the parameter.
--
--```plaintext
--Params: name - The parameter name.
--        id - The parameter ID.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param name string
---@return Single
function CS.UnityEngine.Animator.GetFloat(name) end

--
--The value of the parameter.
--
--```plaintext
--Params: name - The parameter name.
--        id - The parameter ID.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param id int
---@return Single
function CS.UnityEngine.Animator.GetFloat(id) end

--
--Send float values to the Animator to affect transitions.
--
--```plaintext
--Params: name - The parameter name.
--        id - The parameter ID.
--        value - The new parameter value.
--        dampTime - The damper total time.
--        deltaTime - The delta time to give to the damper.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param name string
---@param value float
function CS.UnityEngine.Animator.SetFloat(name, value) end

--
--Send float values to the Animator to affect transitions.
--
--```plaintext
--Params: name - The parameter name.
--        id - The parameter ID.
--        value - The new parameter value.
--        dampTime - The damper total time.
--        deltaTime - The delta time to give to the damper.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param name string
---@param value float
---@param dampTime float
---@param deltaTime float
function CS.UnityEngine.Animator.SetFloat(name, value, dampTime, deltaTime) end

--
--Send float values to the Animator to affect transitions.
--
--```plaintext
--Params: name - The parameter name.
--        id - The parameter ID.
--        value - The new parameter value.
--        dampTime - The damper total time.
--        deltaTime - The delta time to give to the damper.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param id int
---@param value float
function CS.UnityEngine.Animator.SetFloat(id, value) end

--
--Send float values to the Animator to affect transitions.
--
--```plaintext
--Params: name - The parameter name.
--        id - The parameter ID.
--        value - The new parameter value.
--        dampTime - The damper total time.
--        deltaTime - The delta time to give to the damper.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param id int
---@param value float
---@param dampTime float
---@param deltaTime float
function CS.UnityEngine.Animator.SetFloat(id, value, dampTime, deltaTime) end

--
--The value of the parameter.
--
--```plaintext
--Params: name - The parameter name.
--        id - The parameter ID.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param name string
---@return Boolean
function CS.UnityEngine.Animator.GetBool(name) end

--
--The value of the parameter.
--
--```plaintext
--Params: name - The parameter name.
--        id - The parameter ID.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param id int
---@return Boolean
function CS.UnityEngine.Animator.GetBool(id) end

--
--Sets the value of the given boolean parameter.
--
--```plaintext
--Params: name - The parameter name.
--        id - The parameter ID.
--        value - The new parameter value.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param name string
---@param value bool
function CS.UnityEngine.Animator.SetBool(name, value) end

--
--Sets the value of the given boolean parameter.
--
--```plaintext
--Params: name - The parameter name.
--        id - The parameter ID.
--        value - The new parameter value.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param id int
---@param value bool
function CS.UnityEngine.Animator.SetBool(id, value) end

--
--The value of the parameter.
--
--```plaintext
--Params: name - The parameter name.
--        id - The parameter ID.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param name string
---@return Int32
function CS.UnityEngine.Animator.GetInteger(name) end

--
--The value of the parameter.
--
--```plaintext
--Params: name - The parameter name.
--        id - The parameter ID.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param id int
---@return Int32
function CS.UnityEngine.Animator.GetInteger(id) end

--
--Sets the value of the given integer parameter.
--
--```plaintext
--Params: name - The parameter name.
--        id - The parameter ID.
--        value - The new parameter value.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param name string
---@param value int
function CS.UnityEngine.Animator.SetInteger(name, value) end

--
--Sets the value of the given integer parameter.
--
--```plaintext
--Params: name - The parameter name.
--        id - The parameter ID.
--        value - The new parameter value.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param id int
---@param value int
function CS.UnityEngine.Animator.SetInteger(id, value) end

--
--Sets the value of the given trigger parameter.
--
--```plaintext
--Params: name - The parameter name.
--        id - The parameter ID.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param name string
function CS.UnityEngine.Animator.SetTrigger(name) end

--
--Sets the value of the given trigger parameter.
--
--```plaintext
--Params: name - The parameter name.
--        id - The parameter ID.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param id int
function CS.UnityEngine.Animator.SetTrigger(id) end

--
--Resets the value of the given trigger parameter.
--
--```plaintext
--Params: name - The parameter name.
--        id - The parameter ID.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param name string
function CS.UnityEngine.Animator.ResetTrigger(name) end

--
--Resets the value of the given trigger parameter.
--
--```plaintext
--Params: name - The parameter name.
--        id - The parameter ID.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param id int
function CS.UnityEngine.Animator.ResetTrigger(id) end

--
--True if the parameter is controlled by a curve, false otherwise.
--
--```plaintext
--Params: name - The parameter name.
--        id - The parameter ID.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param name string
---@return Boolean
function CS.UnityEngine.Animator.IsParameterControlledByCurve(name) end

--
--True if the parameter is controlled by a curve, false otherwise.
--
--```plaintext
--Params: name - The parameter name.
--        id - The parameter ID.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param id int
---@return Boolean
function CS.UnityEngine.Animator.IsParameterControlledByCurve(id) end

--
--Return the current position of this IK goal in world space.
--
--```plaintext
--Params: goal - The AvatarIKGoal that is queried.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param goal UnityEngine.AvatarIKGoal
---@return Vector3
function CS.UnityEngine.Animator.GetIKPosition(goal) end

--
--Sets the position of an IK goal.
--
--```plaintext
--Params: goal - The AvatarIKGoal that is set.
--        goalPosition - The position in world space.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param goal UnityEngine.AvatarIKGoal
---@param goalPosition UnityEngine.Vector3
function CS.UnityEngine.Animator.SetIKPosition(goal, goalPosition) end

--
--Gets the rotation of an IK goal.
--
--```plaintext
--Params: goal - The AvatarIKGoal that is is queried.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param goal UnityEngine.AvatarIKGoal
---@return Quaternion
function CS.UnityEngine.Animator.GetIKRotation(goal) end

--
--Sets the rotation of an IK goal.
--
--```plaintext
--Params: goal - The AvatarIKGoal that is set.
--        goalRotation - The rotation in world space.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param goal UnityEngine.AvatarIKGoal
---@param goalRotation UnityEngine.Quaternion
function CS.UnityEngine.Animator.SetIKRotation(goal, goalRotation) end

--
--Gets the translative weight of an IK goal (0 = at the original animation before IK, 1 = at the goal).
--
--```plaintext
--Params: goal - The AvatarIKGoal that is queried.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param goal UnityEngine.AvatarIKGoal
---@return Single
function CS.UnityEngine.Animator.GetIKPositionWeight(goal) end

--
--Sets the translative weight of an IK goal (0 = at the original animation before IK, 1 = at the goal).
--
--```plaintext
--Params: goal - The AvatarIKGoal that is set.
--        value - The translative weight.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param goal UnityEngine.AvatarIKGoal
---@param value float
function CS.UnityEngine.Animator.SetIKPositionWeight(goal, value) end

--
--Gets the rotational weight of an IK goal (0 = rotation before IK, 1 = rotation at the IK goal).
--
--```plaintext
--Params: goal - The AvatarIKGoal that is queried.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param goal UnityEngine.AvatarIKGoal
---@return Single
function CS.UnityEngine.Animator.GetIKRotationWeight(goal) end

--
--Sets the rotational weight of an IK goal (0 = rotation before IK, 1 = rotation at the IK goal).
--
--```plaintext
--Params: goal - The AvatarIKGoal that is set.
--        value - The rotational weight.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param goal UnityEngine.AvatarIKGoal
---@param value float
function CS.UnityEngine.Animator.SetIKRotationWeight(goal, value) end

--
--Return the current position of this IK hint in world space.
--
--```plaintext
--Params: hint - The AvatarIKHint that is queried.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param hint UnityEngine.AvatarIKHint
---@return Vector3
function CS.UnityEngine.Animator.GetIKHintPosition(hint) end

--
--Sets the position of an IK hint.
--
--```plaintext
--Params: hint - The AvatarIKHint that is set.
--        hintPosition - The position in world space.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param hint UnityEngine.AvatarIKHint
---@param hintPosition UnityEngine.Vector3
function CS.UnityEngine.Animator.SetIKHintPosition(hint, hintPosition) end

--
--Return translative weight.
--
--```plaintext
--Params: hint - The AvatarIKHint that is queried.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param hint UnityEngine.AvatarIKHint
---@return Single
function CS.UnityEngine.Animator.GetIKHintPositionWeight(hint) end

--
--Sets the translative weight of an IK hint (0 = at the original animation before IK, 1 = at the hint).
--
--```plaintext
--Params: hint - The AvatarIKHint that is set.
--        value - The translative weight.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param hint UnityEngine.AvatarIKHint
---@param value float
function CS.UnityEngine.Animator.SetIKHintPositionWeight(hint, value) end

--
--Sets the look at position.
--
--```plaintext
--Params: lookAtPosition - The position to lookAt.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param lookAtPosition UnityEngine.Vector3
function CS.UnityEngine.Animator.SetLookAtPosition(lookAtPosition) end

--
--Set look at weights.
--
--```plaintext
--Params: weight - (0-1) the global weight of the LookAt, multiplier for other parameters.
--        bodyWeight - (0-1) determines how much the body is involved in the LookAt.
--        headWeight - (0-1) determines how much the head is involved in the LookAt.
--        eyesWeight - (0-1) determines how much the eyes are involved in the LookAt.
--        clampWeight - (0-1) 0.0 means the character is completely unrestrained in motion, 1.0 means he's completely clamped (look at becomes impossible), and 0.5 means he'll be able to move on half of the possible range (180 degrees).
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param weight float
function CS.UnityEngine.Animator.SetLookAtWeight(weight) end

--
--Set look at weights.
--
--```plaintext
--Params: weight - (0-1) the global weight of the LookAt, multiplier for other parameters.
--        bodyWeight - (0-1) determines how much the body is involved in the LookAt.
--        headWeight - (0-1) determines how much the head is involved in the LookAt.
--        eyesWeight - (0-1) determines how much the eyes are involved in the LookAt.
--        clampWeight - (0-1) 0.0 means the character is completely unrestrained in motion, 1.0 means he's completely clamped (look at becomes impossible), and 0.5 means he'll be able to move on half of the possible range (180 degrees).
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param weight float
---@param bodyWeight float
function CS.UnityEngine.Animator.SetLookAtWeight(weight, bodyWeight) end

--
--Set look at weights.
--
--```plaintext
--Params: weight - (0-1) the global weight of the LookAt, multiplier for other parameters.
--        bodyWeight - (0-1) determines how much the body is involved in the LookAt.
--        headWeight - (0-1) determines how much the head is involved in the LookAt.
--        eyesWeight - (0-1) determines how much the eyes are involved in the LookAt.
--        clampWeight - (0-1) 0.0 means the character is completely unrestrained in motion, 1.0 means he's completely clamped (look at becomes impossible), and 0.5 means he'll be able to move on half of the possible range (180 degrees).
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param weight float
---@param bodyWeight float
---@param headWeight float
function CS.UnityEngine.Animator.SetLookAtWeight(weight, bodyWeight, headWeight) end

--
--Set look at weights.
--
--```plaintext
--Params: weight - (0-1) the global weight of the LookAt, multiplier for other parameters.
--        bodyWeight - (0-1) determines how much the body is involved in the LookAt.
--        headWeight - (0-1) determines how much the head is involved in the LookAt.
--        eyesWeight - (0-1) determines how much the eyes are involved in the LookAt.
--        clampWeight - (0-1) 0.0 means the character is completely unrestrained in motion, 1.0 means he's completely clamped (look at becomes impossible), and 0.5 means he'll be able to move on half of the possible range (180 degrees).
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param weight float
---@param bodyWeight float
---@param headWeight float
---@param eyesWeight float
function CS.UnityEngine.Animator.SetLookAtWeight(weight, bodyWeight, headWeight, eyesWeight) end

--
--Set look at weights.
--
--```plaintext
--Params: weight - (0-1) the global weight of the LookAt, multiplier for other parameters.
--        bodyWeight - (0-1) determines how much the body is involved in the LookAt.
--        headWeight - (0-1) determines how much the head is involved in the LookAt.
--        eyesWeight - (0-1) determines how much the eyes are involved in the LookAt.
--        clampWeight - (0-1) 0.0 means the character is completely unrestrained in motion, 1.0 means he's completely clamped (look at becomes impossible), and 0.5 means he'll be able to move on half of the possible range (180 degrees).
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param weight float
---@param bodyWeight float
---@param headWeight float
---@param eyesWeight float
---@param clampWeight float
function CS.UnityEngine.Animator.SetLookAtWeight(weight, bodyWeight, headWeight, eyesWeight, clampWeight) end

--
--Sets local rotation of a human bone during a IK pass.
--
--```plaintext
--Params: humanBoneId - The human bone Id.
--        rotation - The local rotation.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param humanBoneId UnityEngine.HumanBodyBones
---@param rotation UnityEngine.Quaternion
function CS.UnityEngine.Animator.SetBoneLocalRotation(humanBoneId, rotation) end

---@source UnityEngine.AnimationModule.dll
---@return T
function CS.UnityEngine.Animator.GetBehaviour() end

---@source UnityEngine.AnimationModule.dll
function CS.UnityEngine.Animator.GetBehaviours() end

---@source UnityEngine.AnimationModule.dll
---@param fullPathHash int
---@param layerIndex int
function CS.UnityEngine.Animator.GetBehaviours(fullPathHash, layerIndex) end

--
--The layer name.
--
--```plaintext
--Params: layerIndex - The layer index.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param layerIndex int
---@return String
function CS.UnityEngine.Animator.GetLayerName(layerIndex) end

--
--The layer index.
--
--```plaintext
--Params: layerName - The layer name.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param layerName string
---@return Int32
function CS.UnityEngine.Animator.GetLayerIndex(layerName) end

--
--The layer weight.
--
--```plaintext
--Params: layerIndex - The layer index.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param layerIndex int
---@return Single
function CS.UnityEngine.Animator.GetLayerWeight(layerIndex) end

--
--Sets the weight of the layer at the given index.
--
--```plaintext
--Params: layerIndex - The layer index.
--        weight - The new layer weight.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param layerIndex int
---@param weight float
function CS.UnityEngine.Animator.SetLayerWeight(layerIndex, weight) end

--
--An AnimatorStateInfo with the information on the current state.
--
--```plaintext
--Params: layerIndex - The layer index.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param layerIndex int
---@return AnimatorStateInfo
function CS.UnityEngine.Animator.GetCurrentAnimatorStateInfo(layerIndex) end

--
--An AnimatorStateInfo with the information on the next state.
--
--```plaintext
--Params: layerIndex - The layer index.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param layerIndex int
---@return AnimatorStateInfo
function CS.UnityEngine.Animator.GetNextAnimatorStateInfo(layerIndex) end

--
--An AnimatorTransitionInfo with the informations on the current transition.
--
--```plaintext
--Params: layerIndex - The layer's index.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param layerIndex int
---@return AnimatorTransitionInfo
function CS.UnityEngine.Animator.GetAnimatorTransitionInfo(layerIndex) end

--
--The number of AnimatorClipInfo in the current state.
--
--```plaintext
--Params: layerIndex - The layer index.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param layerIndex int
---@return Int32
function CS.UnityEngine.Animator.GetCurrentAnimatorClipInfoCount(layerIndex) end

--
--The number of AnimatorClipInfo in the next state.
--
--```plaintext
--Params: layerIndex - The layer index.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param layerIndex int
---@return Int32
function CS.UnityEngine.Animator.GetNextAnimatorClipInfoCount(layerIndex) end

--
--An array of all the AnimatorClipInfo in the current state.
--
--```plaintext
--Params: layerIndex - The layer index.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param layerIndex int
function CS.UnityEngine.Animator.GetCurrentAnimatorClipInfo(layerIndex) end

--
--An array of all the AnimatorClipInfo in the next state.
--
--```plaintext
--Params: layerIndex - The layer index.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param layerIndex int
function CS.UnityEngine.Animator.GetNextAnimatorClipInfo(layerIndex) end

---@source UnityEngine.AnimationModule.dll
---@param layerIndex int
---@param clips System.Collections.Generic.List<UnityEngine.AnimatorClipInfo>
function CS.UnityEngine.Animator.GetCurrentAnimatorClipInfo(layerIndex, clips) end

---@source UnityEngine.AnimationModule.dll
---@param layerIndex int
---@param clips System.Collections.Generic.List<UnityEngine.AnimatorClipInfo>
function CS.UnityEngine.Animator.GetNextAnimatorClipInfo(layerIndex, clips) end

--
--True if there is a transition on the given layer, false otherwise.
--
--```plaintext
--Params: layerIndex - The layer index.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param layerIndex int
---@return Boolean
function CS.UnityEngine.Animator.IsInTransition(layerIndex) end

--
--See AnimatorController.parameters.
--
---@source UnityEngine.AnimationModule.dll
---@param index int
---@return AnimatorControllerParameter
function CS.UnityEngine.Animator.GetParameter(index) end

---@source UnityEngine.AnimationModule.dll
---@param matchPosition UnityEngine.Vector3
---@param matchRotation UnityEngine.Quaternion
---@param targetBodyPart UnityEngine.AvatarTarget
---@param weightMask UnityEngine.MatchTargetWeightMask
---@param startNormalizedTime float
function CS.UnityEngine.Animator.MatchTarget(matchPosition, matchRotation, targetBodyPart, weightMask, startNormalizedTime) end

--
--Automatically adjust the GameObject position and rotation.
--
--```plaintext
--Params: matchPosition - The position we want the body part to reach.
--        matchRotation - The rotation in which we want the body part to be.
--        targetBodyPart - The body part that is involved in the match.
--        weightMask - Structure that contains weights for matching position and rotation.
--        startNormalizedTime - Start time within the animation clip (0 - beginning of clip, 1 - end of clip).
--        targetNormalizedTime - End time within the animation clip (0 - beginning of clip, 1 - end of clip), values greater than 1 can be set to trigger a match after a certain number of loops. Ex: 2.3 means at 30% of 2nd loop.
--        completeMatch - Allows you to specify what should happen if the MatchTarget function is interrupted. A value of true causes the GameObject to immediately move to the matchPosition if interrupted. A value of false causes the GameObject to stay at its current position if interrupted.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param matchPosition UnityEngine.Vector3
---@param matchRotation UnityEngine.Quaternion
---@param targetBodyPart UnityEngine.AvatarTarget
---@param weightMask UnityEngine.MatchTargetWeightMask
---@param startNormalizedTime float
---@param targetNormalizedTime float
function CS.UnityEngine.Animator.MatchTarget(matchPosition, matchRotation, targetBodyPart, weightMask, startNormalizedTime, targetNormalizedTime) end

---@source UnityEngine.AnimationModule.dll
---@param matchPosition UnityEngine.Vector3
---@param matchRotation UnityEngine.Quaternion
---@param targetBodyPart UnityEngine.AvatarTarget
---@param weightMask UnityEngine.MatchTargetWeightMask
---@param startNormalizedTime float
---@param targetNormalizedTime float
---@param completeMatch bool
function CS.UnityEngine.Animator.MatchTarget(matchPosition, matchRotation, targetBodyPart, weightMask, startNormalizedTime, targetNormalizedTime, completeMatch) end

--
--Interrupts the automatic target matching.
--
---@source UnityEngine.AnimationModule.dll
function CS.UnityEngine.Animator.InterruptMatchTarget() end

--
--Interrupts the automatic target matching.
--
---@source UnityEngine.AnimationModule.dll
---@param completeMatch bool
function CS.UnityEngine.Animator.InterruptMatchTarget(completeMatch) end

---@source UnityEngine.AnimationModule.dll
---@param normalizedTime float
function CS.UnityEngine.Animator.ForceStateNormalizedTime(normalizedTime) end

---@source UnityEngine.AnimationModule.dll
---@param stateName string
---@param fixedTransitionDuration float
function CS.UnityEngine.Animator.CrossFadeInFixedTime(stateName, fixedTransitionDuration) end

---@source UnityEngine.AnimationModule.dll
---@param stateName string
---@param fixedTransitionDuration float
---@param layer int
function CS.UnityEngine.Animator.CrossFadeInFixedTime(stateName, fixedTransitionDuration, layer) end

---@source UnityEngine.AnimationModule.dll
---@param stateName string
---@param fixedTransitionDuration float
---@param layer int
---@param fixedTimeOffset float
function CS.UnityEngine.Animator.CrossFadeInFixedTime(stateName, fixedTransitionDuration, layer, fixedTimeOffset) end

--
--Creates a crossfade from the current state to any other state using times in seconds.
--
--```plaintext
--Params: stateName - The name of the state.
--        stateHashName - The hash name of the state.
--        fixedTransitionDuration - The duration of the transition (in seconds).
--        layer - The layer where the crossfade occurs.
--        fixedTimeOffset - The time of the state (in seconds).
--        normalizedTransitionTime - The time of the transition (normalized).
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param stateName string
---@param fixedTransitionDuration float
---@param layer int
---@param fixedTimeOffset float
---@param normalizedTransitionTime float
function CS.UnityEngine.Animator.CrossFadeInFixedTime(stateName, fixedTransitionDuration, layer, fixedTimeOffset, normalizedTransitionTime) end

---@source UnityEngine.AnimationModule.dll
---@param stateHashName int
---@param fixedTransitionDuration float
---@param layer int
---@param fixedTimeOffset float
function CS.UnityEngine.Animator.CrossFadeInFixedTime(stateHashName, fixedTransitionDuration, layer, fixedTimeOffset) end

---@source UnityEngine.AnimationModule.dll
---@param stateHashName int
---@param fixedTransitionDuration float
---@param layer int
function CS.UnityEngine.Animator.CrossFadeInFixedTime(stateHashName, fixedTransitionDuration, layer) end

---@source UnityEngine.AnimationModule.dll
---@param stateHashName int
---@param fixedTransitionDuration float
function CS.UnityEngine.Animator.CrossFadeInFixedTime(stateHashName, fixedTransitionDuration) end

--
--Creates a crossfade from the current state to any other state using times in seconds.
--
--```plaintext
--Params: stateName - The name of the state.
--        stateHashName - The hash name of the state.
--        fixedTransitionDuration - The duration of the transition (in seconds).
--        layer - The layer where the crossfade occurs.
--        fixedTimeOffset - The time of the state (in seconds).
--        normalizedTransitionTime - The time of the transition (normalized).
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param stateHashName int
---@param fixedTransitionDuration float
---@param layer int
---@param fixedTimeOffset float
---@param normalizedTransitionTime float
function CS.UnityEngine.Animator.CrossFadeInFixedTime(stateHashName, fixedTransitionDuration, layer, fixedTimeOffset, normalizedTransitionTime) end

--
--Forces a write of the default values stored in the animator.
--
---@source UnityEngine.AnimationModule.dll
function CS.UnityEngine.Animator.WriteDefaultValues() end

---@source UnityEngine.AnimationModule.dll
---@param stateName string
---@param normalizedTransitionDuration float
---@param layer int
---@param normalizedTimeOffset float
function CS.UnityEngine.Animator.CrossFade(stateName, normalizedTransitionDuration, layer, normalizedTimeOffset) end

---@source UnityEngine.AnimationModule.dll
---@param stateName string
---@param normalizedTransitionDuration float
---@param layer int
function CS.UnityEngine.Animator.CrossFade(stateName, normalizedTransitionDuration, layer) end

---@source UnityEngine.AnimationModule.dll
---@param stateName string
---@param normalizedTransitionDuration float
function CS.UnityEngine.Animator.CrossFade(stateName, normalizedTransitionDuration) end

--
--Creates a crossfade from the current state to any other state using normalized times.
--
--```plaintext
--Params: stateName - The name of the state.
--        stateHashName - The hash name of the state.
--        normalizedTransitionDuration - The duration of the transition (normalized).
--        layer - The layer where the crossfade occurs.
--        normalizedTimeOffset - The time of the state (normalized).
--        normalizedTransitionTime - The time of the transition (normalized).
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param stateName string
---@param normalizedTransitionDuration float
---@param layer int
---@param normalizedTimeOffset float
---@param normalizedTransitionTime float
function CS.UnityEngine.Animator.CrossFade(stateName, normalizedTransitionDuration, layer, normalizedTimeOffset, normalizedTransitionTime) end

--
--Creates a crossfade from the current state to any other state using normalized times.
--
--```plaintext
--Params: stateName - The name of the state.
--        stateHashName - The hash name of the state.
--        normalizedTransitionDuration - The duration of the transition (normalized).
--        layer - The layer where the crossfade occurs.
--        normalizedTimeOffset - The time of the state (normalized).
--        normalizedTransitionTime - The time of the transition (normalized).
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param stateHashName int
---@param normalizedTransitionDuration float
---@param layer int
---@param normalizedTimeOffset float
---@param normalizedTransitionTime float
function CS.UnityEngine.Animator.CrossFade(stateHashName, normalizedTransitionDuration, layer, normalizedTimeOffset, normalizedTransitionTime) end

---@source UnityEngine.AnimationModule.dll
---@param stateHashName int
---@param normalizedTransitionDuration float
---@param layer int
---@param normalizedTimeOffset float
function CS.UnityEngine.Animator.CrossFade(stateHashName, normalizedTransitionDuration, layer, normalizedTimeOffset) end

---@source UnityEngine.AnimationModule.dll
---@param stateHashName int
---@param normalizedTransitionDuration float
---@param layer int
function CS.UnityEngine.Animator.CrossFade(stateHashName, normalizedTransitionDuration, layer) end

---@source UnityEngine.AnimationModule.dll
---@param stateHashName int
---@param normalizedTransitionDuration float
function CS.UnityEngine.Animator.CrossFade(stateHashName, normalizedTransitionDuration) end

---@source UnityEngine.AnimationModule.dll
---@param stateName string
---@param layer int
function CS.UnityEngine.Animator.PlayInFixedTime(stateName, layer) end

---@source UnityEngine.AnimationModule.dll
---@param stateName string
function CS.UnityEngine.Animator.PlayInFixedTime(stateName) end

--
--Plays a state.
--
--```plaintext
--Params: stateName - The state name.
--        stateNameHash - The state hash name. If stateNameHash is 0, it changes the current state time.
--        layer - The layer index. If layer is -1, it plays the first state with the given state name or hash.
--        fixedTime - The time offset (in seconds).
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param stateName string
---@param layer int
---@param fixedTime float
function CS.UnityEngine.Animator.PlayInFixedTime(stateName, layer, fixedTime) end

--
--Plays a state.
--
--```plaintext
--Params: stateName - The state name.
--        stateNameHash - The state hash name. If stateNameHash is 0, it changes the current state time.
--        layer - The layer index. If layer is -1, it plays the first state with the given state name or hash.
--        fixedTime - The time offset (in seconds).
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param stateNameHash int
---@param layer int
---@param fixedTime float
function CS.UnityEngine.Animator.PlayInFixedTime(stateNameHash, layer, fixedTime) end

---@source UnityEngine.AnimationModule.dll
---@param stateNameHash int
---@param layer int
function CS.UnityEngine.Animator.PlayInFixedTime(stateNameHash, layer) end

---@source UnityEngine.AnimationModule.dll
---@param stateNameHash int
function CS.UnityEngine.Animator.PlayInFixedTime(stateNameHash) end

---@source UnityEngine.AnimationModule.dll
---@param stateName string
---@param layer int
function CS.UnityEngine.Animator.Play(stateName, layer) end

---@source UnityEngine.AnimationModule.dll
---@param stateName string
function CS.UnityEngine.Animator.Play(stateName) end

--
--Plays a state.
--
--```plaintext
--Params: stateName - The state name.
--        stateNameHash - The state hash name. If stateNameHash is 0, it changes the current state time.
--        layer - The layer index. If layer is -1, it plays the first state with the given state name or hash.
--        normalizedTime - The time offset between zero and one.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param stateName string
---@param layer int
---@param normalizedTime float
function CS.UnityEngine.Animator.Play(stateName, layer, normalizedTime) end

--
--Plays a state.
--
--```plaintext
--Params: stateName - The state name.
--        stateNameHash - The state hash name. If stateNameHash is 0, it changes the current state time.
--        layer - The layer index. If layer is -1, it plays the first state with the given state name or hash.
--        normalizedTime - The time offset between zero and one.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param stateNameHash int
---@param layer int
---@param normalizedTime float
function CS.UnityEngine.Animator.Play(stateNameHash, layer, normalizedTime) end

---@source UnityEngine.AnimationModule.dll
---@param stateNameHash int
---@param layer int
function CS.UnityEngine.Animator.Play(stateNameHash, layer) end

---@source UnityEngine.AnimationModule.dll
---@param stateNameHash int
function CS.UnityEngine.Animator.Play(stateNameHash) end

--
--Sets an AvatarTarget and a targetNormalizedTime for the current state.
--
--```plaintext
--Params: targetIndex - The avatar body part that is queried.
--        targetNormalizedTime - The current state Time that is queried.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param targetIndex UnityEngine.AvatarTarget
---@param targetNormalizedTime float
function CS.UnityEngine.Animator.SetTarget(targetIndex, targetNormalizedTime) end

--
--Returns true if the transform is controlled by the Animator\.
--
--```plaintext
--Params: transform - The transform that is queried.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param transform UnityEngine.Transform
---@return Boolean
function CS.UnityEngine.Animator.IsControlled(transform) end

--
--Returns Transform mapped to this human bone id.
--
--```plaintext
--Params: humanBoneId - The human bone that is queried, see enum HumanBodyBones for a list of possible values.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param humanBoneId UnityEngine.HumanBodyBones
---@return Transform
function CS.UnityEngine.Animator.GetBoneTransform(humanBoneId) end

--
--Sets the animator in playback mode.
--
---@source UnityEngine.AnimationModule.dll
function CS.UnityEngine.Animator.StartPlayback() end

--
--Stops the animator playback mode. When playback stops, the avatar resumes getting control from game logic.
--
---@source UnityEngine.AnimationModule.dll
function CS.UnityEngine.Animator.StopPlayback() end

--
--Sets the animator in recording mode, and allocates a circular buffer of size frameCount.
--
--```plaintext
--Params: frameCount - The number of frames (updates) that will be recorded. If frameCount is 0, the recording will continue until the user calls StopRecording. The maximum value for frameCount is 10000.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param frameCount int
function CS.UnityEngine.Animator.StartRecording(frameCount) end

--
--Stops animator record mode.
--
---@source UnityEngine.AnimationModule.dll
function CS.UnityEngine.Animator.StopRecording() end

--
--True if the state exists in this layer, false otherwise.
--
--```plaintext
--Params: layerIndex - The layer index.
--        stateID - The state ID.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param layerIndex int
---@param stateID int
---@return Boolean
function CS.UnityEngine.Animator.HasState(layerIndex, stateID) end

--
--Generates an parameter id from a string.
--
--```plaintext
--Params: name - The string to convert to Id.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param name string
---@return Int32
function CS.UnityEngine.Animator:StringToHash(name) end

--
--Evaluates the animator based on deltaTime.
--
--```plaintext
--Params: deltaTime - The time delta.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param deltaTime float
function CS.UnityEngine.Animator.Update(deltaTime) end

--
--Rebind all the animated properties and mesh data with the Animator.
--
---@source UnityEngine.AnimationModule.dll
function CS.UnityEngine.Animator.Rebind() end

--
--Apply the default Root Motion.
--
---@source UnityEngine.AnimationModule.dll
function CS.UnityEngine.Animator.ApplyBuiltinRootMotion() end

--
--Gets the value of a vector parameter.
--
--```plaintext
--Params: name - The name of the parameter.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param name string
---@return Vector3
function CS.UnityEngine.Animator.GetVector(name) end

--
--Gets the value of a vector parameter.
--
--```plaintext
--Params: id - The id of the parameter. The id is generated using Animator::StringToHash.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param id int
---@return Vector3
function CS.UnityEngine.Animator.GetVector(id) end

--
--Sets the value of a vector parameter.
--
--```plaintext
--Params: name - The name of the parameter.
--        value - The new value for the parameter.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param name string
---@param value UnityEngine.Vector3
function CS.UnityEngine.Animator.SetVector(name, value) end

--
--Sets the value of a vector parameter.
--
--```plaintext
--Params: id - The id of the parameter. The id is generated using Animator::StringToHash.
--        value - The new value for the parameter.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param id int
---@param value UnityEngine.Vector3
function CS.UnityEngine.Animator.SetVector(id, value) end

--
--Gets the value of a quaternion parameter.
--
--```plaintext
--Params: name - The name of the parameter.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param name string
---@return Quaternion
function CS.UnityEngine.Animator.GetQuaternion(name) end

--
--Gets the value of a quaternion parameter.
--
--```plaintext
--Params: id - The id of the parameter. The id is generated using Animator::StringToHash.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param id int
---@return Quaternion
function CS.UnityEngine.Animator.GetQuaternion(id) end

--
--Sets the value of a quaternion parameter.
--
--```plaintext
--Params: name - The name of the parameter.
--        value - The new value for the parameter.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param name string
---@param value UnityEngine.Quaternion
function CS.UnityEngine.Animator.SetQuaternion(name, value) end

--
--Sets the value of a quaternion parameter.
--
--```plaintext
--Params: id - Of the parameter. The id is generated using Animator::StringToHash.
--        value - The new value for the parameter.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param id int
---@param value UnityEngine.Quaternion
function CS.UnityEngine.Animator.SetQuaternion(id, value) end


--
--IK Goal.
--
---@source UnityEngine.AnimationModule.dll
---@class UnityEngine.AvatarIKGoal: System.Enum
--
--The left foot.
--
---@source UnityEngine.AnimationModule.dll
---@field LeftFoot UnityEngine.AvatarIKGoal
--
--The right foot.
--
---@source UnityEngine.AnimationModule.dll
---@field RightFoot UnityEngine.AvatarIKGoal
--
--The left hand.
--
---@source UnityEngine.AnimationModule.dll
---@field LeftHand UnityEngine.AvatarIKGoal
--
--The right hand.
--
---@source UnityEngine.AnimationModule.dll
---@field RightHand UnityEngine.AvatarIKGoal
---@source UnityEngine.AnimationModule.dll
CS.UnityEngine.AvatarIKGoal = {}

---@source 
---@param value any
---@return UnityEngine.AvatarIKGoal
function CS.UnityEngine.AvatarIKGoal:__CastFrom(value) end


--
--IK Hint.
--
---@source UnityEngine.AnimationModule.dll
---@class UnityEngine.AvatarIKHint: System.Enum
--
--The left knee IK hint.
--
---@source UnityEngine.AnimationModule.dll
---@field LeftKnee UnityEngine.AvatarIKHint
--
--The right knee IK hint.
--
---@source UnityEngine.AnimationModule.dll
---@field RightKnee UnityEngine.AvatarIKHint
--
--The left elbow IK hint.
--
---@source UnityEngine.AnimationModule.dll
---@field LeftElbow UnityEngine.AvatarIKHint
--
--The right elbow IK hint.
--
---@source UnityEngine.AnimationModule.dll
---@field RightElbow UnityEngine.AvatarIKHint
---@source UnityEngine.AnimationModule.dll
CS.UnityEngine.AvatarIKHint = {}

---@source 
---@param value any
---@return UnityEngine.AvatarIKHint
function CS.UnityEngine.AvatarIKHint:__CastFrom(value) end


--
--The type of the parameter.
--
---@source UnityEngine.AnimationModule.dll
---@class UnityEngine.AnimatorControllerParameterType: System.Enum
--
--Float type parameter.
--
---@source UnityEngine.AnimationModule.dll
---@field Float UnityEngine.AnimatorControllerParameterType
--
--Int type parameter.
--
---@source UnityEngine.AnimationModule.dll
---@field Int UnityEngine.AnimatorControllerParameterType
--
--Boolean type parameter.
--
---@source UnityEngine.AnimationModule.dll
---@field Bool UnityEngine.AnimatorControllerParameterType
--
--Trigger type parameter.
--
---@source UnityEngine.AnimationModule.dll
---@field Trigger UnityEngine.AnimatorControllerParameterType
---@source UnityEngine.AnimationModule.dll
CS.UnityEngine.AnimatorControllerParameterType = {}

---@source 
---@param value any
---@return UnityEngine.AnimatorControllerParameterType
function CS.UnityEngine.AnimatorControllerParameterType:__CastFrom(value) end


--
--The mode of the Animator's recorder.
--
---@source UnityEngine.AnimationModule.dll
---@class UnityEngine.AnimatorRecorderMode: System.Enum
--
--The Animator recorder is offline.
--
---@source UnityEngine.AnimationModule.dll
---@field Offline UnityEngine.AnimatorRecorderMode
--
--The Animator recorder is in Playback.
--
---@source UnityEngine.AnimationModule.dll
---@field Playback UnityEngine.AnimatorRecorderMode
--
--The Animator recorder is in Record.
--
---@source UnityEngine.AnimationModule.dll
---@field Record UnityEngine.AnimatorRecorderMode
---@source UnityEngine.AnimationModule.dll
CS.UnityEngine.AnimatorRecorderMode = {}

---@source 
---@param value any
---@return UnityEngine.AnimatorRecorderMode
function CS.UnityEngine.AnimatorRecorderMode:__CastFrom(value) end


--
--Describe the unit of a duration.
--
---@source UnityEngine.AnimationModule.dll
---@class UnityEngine.DurationUnit: System.Enum
--
--A fixed duration is a duration expressed in seconds.
--
---@source UnityEngine.AnimationModule.dll
---@field Fixed UnityEngine.DurationUnit
--
--A normalized duration is a duration expressed in percentage.
--
---@source UnityEngine.AnimationModule.dll
---@field Normalized UnityEngine.DurationUnit
---@source UnityEngine.AnimationModule.dll
CS.UnityEngine.DurationUnit = {}

---@source 
---@param value any
---@return UnityEngine.DurationUnit
function CS.UnityEngine.DurationUnit:__CastFrom(value) end


--
--Culling mode for the Animator.
--
---@source UnityEngine.AnimationModule.dll
---@class UnityEngine.AnimatorCullingMode: System.Enum
--
--Always animate the entire character. Object is animated even when offscreen.
--
---@source UnityEngine.AnimationModule.dll
---@field AlwaysAnimate UnityEngine.AnimatorCullingMode
--
--Retarget, IK and write of Transforms are disabled when renderers are not visible.
--
---@source UnityEngine.AnimationModule.dll
---@field CullUpdateTransforms UnityEngine.AnimatorCullingMode
--
--Animation is completely disabled when renderers are not visible.
--
---@source UnityEngine.AnimationModule.dll
---@field CullCompletely UnityEngine.AnimatorCullingMode
---@source UnityEngine.AnimationModule.dll
---@field BasedOnRenderers UnityEngine.AnimatorCullingMode
---@source UnityEngine.AnimationModule.dll
CS.UnityEngine.AnimatorCullingMode = {}

---@source 
---@param value any
---@return UnityEngine.AnimatorCullingMode
function CS.UnityEngine.AnimatorCullingMode:__CastFrom(value) end


--
--The update mode of the Animator.
--
---@source UnityEngine.AnimationModule.dll
---@class UnityEngine.AnimatorUpdateMode: System.Enum
--
--Normal update of the animator.
--
---@source UnityEngine.AnimationModule.dll
---@field Normal UnityEngine.AnimatorUpdateMode
--
--Updates the animator during the physic loop in order to have the animation system synchronized with the physics engine.
--
---@source UnityEngine.AnimationModule.dll
---@field AnimatePhysics UnityEngine.AnimatorUpdateMode
--
--Animator updates independently of Time.timeScale.
--
---@source UnityEngine.AnimationModule.dll
---@field UnscaledTime UnityEngine.AnimatorUpdateMode
---@source UnityEngine.AnimationModule.dll
CS.UnityEngine.AnimatorUpdateMode = {}

---@source 
---@param value any
---@return UnityEngine.AnimatorUpdateMode
function CS.UnityEngine.AnimatorUpdateMode:__CastFrom(value) end


--
--Information about clip being played and blended by the Animator.
--
---@source UnityEngine.AnimationModule.dll
---@class UnityEngine.AnimatorClipInfo: System.ValueType
--
--Returns the animation clip played by the Animator.
--
---@source UnityEngine.AnimationModule.dll
---@field clip UnityEngine.AnimationClip
--
--Returns the blending weight used by the Animator to blend this clip.
--
---@source UnityEngine.AnimationModule.dll
---@field weight float
---@source UnityEngine.AnimationModule.dll
CS.UnityEngine.AnimatorClipInfo = {}


--
--Information about the current or next state.
--
---@source UnityEngine.AnimationModule.dll
---@class UnityEngine.AnimatorStateInfo: System.ValueType
--
--The full path hash for this state.
--
---@source UnityEngine.AnimationModule.dll
---@field fullPathHash int
--
--The hashed name of the State.
--
---@source UnityEngine.AnimationModule.dll
---@field nameHash int
--
--The hash is generated using Animator.StringToHash. The hash does not include the name of the parent layer.
--
---@source UnityEngine.AnimationModule.dll
---@field shortNameHash int
--
--Normalized time of the State.
--
---@source UnityEngine.AnimationModule.dll
---@field normalizedTime float
--
--Current duration of the state.
--
---@source UnityEngine.AnimationModule.dll
---@field length float
--
--The playback speed of the animation. 1 is the normal playback speed.
--
---@source UnityEngine.AnimationModule.dll
---@field speed float
--
--The speed multiplier for this state.
--
---@source UnityEngine.AnimationModule.dll
---@field speedMultiplier float
--
--The Tag of the State.
--
---@source UnityEngine.AnimationModule.dll
---@field tagHash int
--
--Is the state looping.
--
---@source UnityEngine.AnimationModule.dll
---@field loop bool
---@source UnityEngine.AnimationModule.dll
CS.UnityEngine.AnimatorStateInfo = {}

--
--Does name match the name of the active state in the statemachine?
--
---@source UnityEngine.AnimationModule.dll
---@param name string
---@return Boolean
function CS.UnityEngine.AnimatorStateInfo.IsName(name) end

--
--Does tag match the tag of the active state in the statemachine.
--
---@source UnityEngine.AnimationModule.dll
---@param tag string
---@return Boolean
function CS.UnityEngine.AnimatorStateInfo.IsTag(tag) end


--
--Information about the current transition.
--
---@source UnityEngine.AnimationModule.dll
---@class UnityEngine.AnimatorTransitionInfo: System.ValueType
--
--The hash name of the Transition.
--
---@source UnityEngine.AnimationModule.dll
---@field fullPathHash int
--
--The simplified name of the Transition.
--
---@source UnityEngine.AnimationModule.dll
---@field nameHash int
--
--The user-specified name of the Transition.
--
---@source UnityEngine.AnimationModule.dll
---@field userNameHash int
--
--The unit of the transition duration.
--
---@source UnityEngine.AnimationModule.dll
---@field durationUnit UnityEngine.DurationUnit
--
--Duration of the transition.
--
---@source UnityEngine.AnimationModule.dll
---@field duration float
--
--Normalized time of the Transition.
--
---@source UnityEngine.AnimationModule.dll
---@field normalizedTime float
--
--Returns true if the transition is from an AnyState node, or from Animator.CrossFade.
--
---@source UnityEngine.AnimationModule.dll
---@field anyState bool
---@source UnityEngine.AnimationModule.dll
CS.UnityEngine.AnimatorTransitionInfo = {}

--
--Does name match the name of the active Transition.
--
---@source UnityEngine.AnimationModule.dll
---@param name string
---@return Boolean
function CS.UnityEngine.AnimatorTransitionInfo.IsName(name) end

--
--Does userName match the name of the active Transition.
--
---@source UnityEngine.AnimationModule.dll
---@param name string
---@return Boolean
function CS.UnityEngine.AnimatorTransitionInfo.IsUserName(name) end


--
--Use this struct to specify the position and rotation weight mask for Animator.MatchTarget.
--
---@source UnityEngine.AnimationModule.dll
---@class UnityEngine.MatchTargetWeightMask: System.ValueType
--
--Position XYZ weight.
--
---@source UnityEngine.AnimationModule.dll
---@field positionXYZWeight UnityEngine.Vector3
--
--Rotation weight.
--
---@source UnityEngine.AnimationModule.dll
---@field rotationWeight float
---@source UnityEngine.AnimationModule.dll
CS.UnityEngine.MatchTargetWeightMask = {}


--
--Used to communicate between scripting and the controller. Some parameters can be set in scripting and used by the controller, while other parameters are based on Custom Curves in Animation Clips and can be sampled using the scripting API.
--
---@source UnityEngine.AnimationModule.dll
---@class UnityEngine.AnimatorControllerParameter: object
--
--The name of the parameter.
--
---@source UnityEngine.AnimationModule.dll
---@field name string
--
--Returns the hash of the parameter based on its name.
--
---@source UnityEngine.AnimationModule.dll
---@field nameHash int
--
--The type of the parameter.
--
---@source UnityEngine.AnimationModule.dll
---@field type UnityEngine.AnimatorControllerParameterType
--
--The default float value for the parameter.
--
---@source UnityEngine.AnimationModule.dll
---@field defaultFloat float
--
--The default int value for the parameter.
--
---@source UnityEngine.AnimationModule.dll
---@field defaultInt int
--
--The default bool value for the parameter.
--
---@source UnityEngine.AnimationModule.dll
---@field defaultBool bool
---@source UnityEngine.AnimationModule.dll
CS.UnityEngine.AnimatorControllerParameter = {}

---@source UnityEngine.AnimationModule.dll
---@param o object
---@return Boolean
function CS.UnityEngine.AnimatorControllerParameter.Equals(o) end

---@source UnityEngine.AnimationModule.dll
---@return Int32
function CS.UnityEngine.AnimatorControllerParameter.GetHashCode() end


--
--This class defines a pair of clips used by AnimatorOverrideController.
--
---@source UnityEngine.AnimationModule.dll
---@class UnityEngine.AnimationClipPair: object
--
--The original clip from the controller.
--
---@source UnityEngine.AnimationModule.dll
---@field originalClip UnityEngine.AnimationClip
--
--The override animation clip.
--
---@source UnityEngine.AnimationModule.dll
---@field overrideClip UnityEngine.AnimationClip
---@source UnityEngine.AnimationModule.dll
CS.UnityEngine.AnimationClipPair = {}


--
--Interface to control Animator Override Controller.
--
---@source UnityEngine.AnimationModule.dll
---@class UnityEngine.AnimatorOverrideController: UnityEngine.RuntimeAnimatorController
--
--The Runtime Animator Controller that the Animator Override Controller overrides.
--
---@source UnityEngine.AnimationModule.dll
---@field runtimeAnimatorController UnityEngine.RuntimeAnimatorController
---@source UnityEngine.AnimationModule.dll
---@field this[] UnityEngine.AnimationClip
---@source UnityEngine.AnimationModule.dll
---@field this[] UnityEngine.AnimationClip
--
--Returns the count of overrides.
--
---@source UnityEngine.AnimationModule.dll
---@field overridesCount int
--
--Returns the list of orignal Animation Clip from the controller and their override Animation Clip.
--
---@source UnityEngine.AnimationModule.dll
---@field clips UnityEngine.AnimationClipPair[]
---@source UnityEngine.AnimationModule.dll
CS.UnityEngine.AnimatorOverrideController = {}

---@source UnityEngine.AnimationModule.dll
---@param overrides System.Collections.Generic.List<System.Collections.Generic.KeyValuePair<UnityEngine.AnimationClip, UnityEngine.AnimationClip>>
function CS.UnityEngine.AnimatorOverrideController.GetOverrides(overrides) end

---@source UnityEngine.AnimationModule.dll
---@param overrides System.Collections.Generic.IList<System.Collections.Generic.KeyValuePair<UnityEngine.AnimationClip, UnityEngine.AnimationClip>>
function CS.UnityEngine.AnimatorOverrideController.ApplyOverrides(overrides) end


--
--Various utilities for animator manipulation.
--
---@source UnityEngine.AnimationModule.dll
---@class UnityEngine.AnimatorUtility: object
---@source UnityEngine.AnimationModule.dll
CS.UnityEngine.AnimatorUtility = {}

--
--This function will remove all transform hierarchy under GameObject, the animator will write directly transform matrices into the skin mesh matrices saving alot of CPU cycles.
--
--```plaintext
--Params: go - GameObject to Optimize.
--        exposedTransforms - List of transform name to expose.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param go UnityEngine.GameObject
---@param exposedTransforms string[]
function CS.UnityEngine.AnimatorUtility:OptimizeTransformHierarchy(go, exposedTransforms) end

--
--This function will recreate all transform hierarchy under GameObject.
--
--```plaintext
--Params: go - GameObject to Deoptimize.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param go UnityEngine.GameObject
function CS.UnityEngine.AnimatorUtility:DeoptimizeTransformHierarchy(go) end


--
--Enumeration of all the muscles in the body.
--
---@source UnityEngine.AnimationModule.dll
---@class UnityEngine.BodyDof: System.Enum
--
--The spine front-back muscle.
--
---@source UnityEngine.AnimationModule.dll
---@field SpineFrontBack UnityEngine.BodyDof
--
--The spine left-right muscle.
--
---@source UnityEngine.AnimationModule.dll
---@field SpineLeftRight UnityEngine.BodyDof
--
--The spine roll left-right muscle.
--
---@source UnityEngine.AnimationModule.dll
---@field SpineRollLeftRight UnityEngine.BodyDof
--
--The chest front-back muscle.
--
---@source UnityEngine.AnimationModule.dll
---@field ChestFrontBack UnityEngine.BodyDof
--
--The chest left-right muscle.
--
---@source UnityEngine.AnimationModule.dll
---@field ChestLeftRight UnityEngine.BodyDof
--
--The chest roll left-right muscle.
--
---@source UnityEngine.AnimationModule.dll
---@field ChestRollLeftRight UnityEngine.BodyDof
--
--The upper chest front-back muscle.
--
---@source UnityEngine.AnimationModule.dll
---@field UpperChestFrontBack UnityEngine.BodyDof
--
--The upper chest left-right muscle.
--
---@source UnityEngine.AnimationModule.dll
---@field UpperChestLeftRight UnityEngine.BodyDof
--
--The upper chest roll left-right muscle.
--
---@source UnityEngine.AnimationModule.dll
---@field UpperChestRollLeftRight UnityEngine.BodyDof
--
--The last value of the BodyDof enum.
--
---@source UnityEngine.AnimationModule.dll
---@field LastBodyDof UnityEngine.BodyDof
---@source UnityEngine.AnimationModule.dll
CS.UnityEngine.BodyDof = {}

---@source 
---@param value any
---@return UnityEngine.BodyDof
function CS.UnityEngine.BodyDof:__CastFrom(value) end


--
--Enumeration of all the muscles in the head.
--
---@source UnityEngine.AnimationModule.dll
---@class UnityEngine.HeadDof: System.Enum
--
--The neck front-back muscle.
--
---@source UnityEngine.AnimationModule.dll
---@field NeckFrontBack UnityEngine.HeadDof
--
--The neck left-right muscle.
--
---@source UnityEngine.AnimationModule.dll
---@field NeckLeftRight UnityEngine.HeadDof
--
--The neck roll left-right muscle.
--
---@source UnityEngine.AnimationModule.dll
---@field NeckRollLeftRight UnityEngine.HeadDof
--
--The head front-back muscle.
--
---@source UnityEngine.AnimationModule.dll
---@field HeadFrontBack UnityEngine.HeadDof
--
--The head left-right muscle.
--
---@source UnityEngine.AnimationModule.dll
---@field HeadLeftRight UnityEngine.HeadDof
--
--The head roll left-right muscle.
--
---@source UnityEngine.AnimationModule.dll
---@field HeadRollLeftRight UnityEngine.HeadDof
--
--The left eye down-up muscle.
--
---@source UnityEngine.AnimationModule.dll
---@field LeftEyeDownUp UnityEngine.HeadDof
--
--The left eye in-out muscle.
--
---@source UnityEngine.AnimationModule.dll
---@field LeftEyeInOut UnityEngine.HeadDof
--
--The right eye down-up muscle.
--
---@source UnityEngine.AnimationModule.dll
---@field RightEyeDownUp UnityEngine.HeadDof
--
--The right eye in-out muscle.
--
---@source UnityEngine.AnimationModule.dll
---@field RightEyeInOut UnityEngine.HeadDof
--
--The jaw down-up muscle.
--
---@source UnityEngine.AnimationModule.dll
---@field JawDownUp UnityEngine.HeadDof
--
--The jaw left-right muscle.
--
---@source UnityEngine.AnimationModule.dll
---@field JawLeftRight UnityEngine.HeadDof
--
--The last value of the HeadDof enum.
--
---@source UnityEngine.AnimationModule.dll
---@field LastHeadDof UnityEngine.HeadDof
---@source UnityEngine.AnimationModule.dll
CS.UnityEngine.HeadDof = {}

---@source 
---@param value any
---@return UnityEngine.HeadDof
function CS.UnityEngine.HeadDof:__CastFrom(value) end


--
--Enumeration of all the muscles in a leg.
--
---@source UnityEngine.AnimationModule.dll
---@class UnityEngine.LegDof: System.Enum
--
--The upper leg front-back muscle.
--
---@source UnityEngine.AnimationModule.dll
---@field UpperLegFrontBack UnityEngine.LegDof
--
--The upper leg in-out muscle.
--
---@source UnityEngine.AnimationModule.dll
---@field UpperLegInOut UnityEngine.LegDof
--
--The upper leg roll in-out muscle.
--
---@source UnityEngine.AnimationModule.dll
---@field UpperLegRollInOut UnityEngine.LegDof
--
--The leg close-open muscle.
--
---@source UnityEngine.AnimationModule.dll
---@field LegCloseOpen UnityEngine.LegDof
--
--The leg roll in-out muscle.
--
---@source UnityEngine.AnimationModule.dll
---@field LegRollInOut UnityEngine.LegDof
--
--The foot close-open muscle.
--
---@source UnityEngine.AnimationModule.dll
---@field FootCloseOpen UnityEngine.LegDof
--
--The foot in-out muscle.
--
---@source UnityEngine.AnimationModule.dll
---@field FootInOut UnityEngine.LegDof
--
--The toes up-down muscle.
--
---@source UnityEngine.AnimationModule.dll
---@field ToesUpDown UnityEngine.LegDof
--
--The last value of the LegDof enum.
--
---@source UnityEngine.AnimationModule.dll
---@field LastLegDof UnityEngine.LegDof
---@source UnityEngine.AnimationModule.dll
CS.UnityEngine.LegDof = {}

---@source 
---@param value any
---@return UnityEngine.LegDof
function CS.UnityEngine.LegDof:__CastFrom(value) end


--
--Enumeration of all the muscles in an arm.
--
---@source UnityEngine.AnimationModule.dll
---@class UnityEngine.ArmDof: System.Enum
--
--The shoulder down-up muscle.
--
---@source UnityEngine.AnimationModule.dll
---@field ShoulderDownUp UnityEngine.ArmDof
--
--The shoulder front-back muscle.
--
---@source UnityEngine.AnimationModule.dll
---@field ShoulderFrontBack UnityEngine.ArmDof
--
--The arm down-up muscle.
--
---@source UnityEngine.AnimationModule.dll
---@field ArmDownUp UnityEngine.ArmDof
--
--The arm front-back muscle.
--
---@source UnityEngine.AnimationModule.dll
---@field ArmFrontBack UnityEngine.ArmDof
--
--The arm roll in-out muscle.
--
---@source UnityEngine.AnimationModule.dll
---@field ArmRollInOut UnityEngine.ArmDof
--
--The forearm close-open muscle.
--
---@source UnityEngine.AnimationModule.dll
---@field ForeArmCloseOpen UnityEngine.ArmDof
--
--The forearm roll in-out muscle.
--
---@source UnityEngine.AnimationModule.dll
---@field ForeArmRollInOut UnityEngine.ArmDof
--
--The hand down-up muscle.
--
---@source UnityEngine.AnimationModule.dll
---@field HandDownUp UnityEngine.ArmDof
--
--The hand in-out muscle.
--
---@source UnityEngine.AnimationModule.dll
---@field HandInOut UnityEngine.ArmDof
--
--The last value of the ArmDof enum.
--
---@source UnityEngine.AnimationModule.dll
---@field LastArmDof UnityEngine.ArmDof
---@source UnityEngine.AnimationModule.dll
CS.UnityEngine.ArmDof = {}

---@source 
---@param value any
---@return UnityEngine.ArmDof
function CS.UnityEngine.ArmDof:__CastFrom(value) end


--
--Enumeration of all the muscles in a finger.
--
---@source UnityEngine.AnimationModule.dll
---@class UnityEngine.FingerDof: System.Enum
--
--The proximal down-up muscle.
--
---@source UnityEngine.AnimationModule.dll
---@field ProximalDownUp UnityEngine.FingerDof
--
--The proximal in-out muscle.
--
---@source UnityEngine.AnimationModule.dll
---@field ProximalInOut UnityEngine.FingerDof
--
--The intermediate close-open muscle.
--
---@source UnityEngine.AnimationModule.dll
---@field IntermediateCloseOpen UnityEngine.FingerDof
--
--The distal close-open muscle.
--
---@source UnityEngine.AnimationModule.dll
---@field DistalCloseOpen UnityEngine.FingerDof
--
--The last value of the FingerDof enum.
--
---@source UnityEngine.AnimationModule.dll
---@field LastFingerDof UnityEngine.FingerDof
---@source UnityEngine.AnimationModule.dll
CS.UnityEngine.FingerDof = {}

---@source 
---@param value any
---@return UnityEngine.FingerDof
function CS.UnityEngine.FingerDof:__CastFrom(value) end


--
--Enumeration of all the parts in a human.
--
---@source UnityEngine.AnimationModule.dll
---@class UnityEngine.HumanPartDof: System.Enum
--
--The human body part.
--
---@source UnityEngine.AnimationModule.dll
---@field Body UnityEngine.HumanPartDof
--
--The human head part.
--
---@source UnityEngine.AnimationModule.dll
---@field Head UnityEngine.HumanPartDof
--
--The human left leg part.
--
---@source UnityEngine.AnimationModule.dll
---@field LeftLeg UnityEngine.HumanPartDof
--
--The human right leg part.
--
---@source UnityEngine.AnimationModule.dll
---@field RightLeg UnityEngine.HumanPartDof
--
--The human left arm part.
--
---@source UnityEngine.AnimationModule.dll
---@field LeftArm UnityEngine.HumanPartDof
--
--The human right arm part.
--
---@source UnityEngine.AnimationModule.dll
---@field RightArm UnityEngine.HumanPartDof
--
--The human left thumb finger part.
--
---@source UnityEngine.AnimationModule.dll
---@field LeftThumb UnityEngine.HumanPartDof
--
--The human left index finger part.
--
---@source UnityEngine.AnimationModule.dll
---@field LeftIndex UnityEngine.HumanPartDof
--
--The human left middle finger part.
--
---@source UnityEngine.AnimationModule.dll
---@field LeftMiddle UnityEngine.HumanPartDof
--
--The human left ring finger part.
--
---@source UnityEngine.AnimationModule.dll
---@field LeftRing UnityEngine.HumanPartDof
--
--The human left little finger part.
--
---@source UnityEngine.AnimationModule.dll
---@field LeftLittle UnityEngine.HumanPartDof
--
--The human right thumb finger part.
--
---@source UnityEngine.AnimationModule.dll
---@field RightThumb UnityEngine.HumanPartDof
--
--The human right index finger part.
--
---@source UnityEngine.AnimationModule.dll
---@field RightIndex UnityEngine.HumanPartDof
--
--The human right middle finger part.
--
---@source UnityEngine.AnimationModule.dll
---@field RightMiddle UnityEngine.HumanPartDof
--
--The human right ring finger part.
--
---@source UnityEngine.AnimationModule.dll
---@field RightRing UnityEngine.HumanPartDof
--
--The human right little finger part.
--
---@source UnityEngine.AnimationModule.dll
---@field RightLittle UnityEngine.HumanPartDof
---@source UnityEngine.AnimationModule.dll
---@field LastHumanPartDof UnityEngine.HumanPartDof
---@source UnityEngine.AnimationModule.dll
CS.UnityEngine.HumanPartDof = {}

---@source 
---@param value any
---@return UnityEngine.HumanPartDof
function CS.UnityEngine.HumanPartDof:__CastFrom(value) end


--
--Human Body Bones.
--
---@source UnityEngine.AnimationModule.dll
---@class UnityEngine.HumanBodyBones: System.Enum
--
--This is the Hips bone.
--
---@source UnityEngine.AnimationModule.dll
---@field Hips UnityEngine.HumanBodyBones
--
--This is the Left Upper Leg bone.
--
---@source UnityEngine.AnimationModule.dll
---@field LeftUpperLeg UnityEngine.HumanBodyBones
--
--This is the Right Upper Leg bone.
--
---@source UnityEngine.AnimationModule.dll
---@field RightUpperLeg UnityEngine.HumanBodyBones
--
--This is the Left Knee bone.
--
---@source UnityEngine.AnimationModule.dll
---@field LeftLowerLeg UnityEngine.HumanBodyBones
--
--This is the Right Knee bone.
--
---@source UnityEngine.AnimationModule.dll
---@field RightLowerLeg UnityEngine.HumanBodyBones
--
--This is the Left Ankle bone.
--
---@source UnityEngine.AnimationModule.dll
---@field LeftFoot UnityEngine.HumanBodyBones
--
--This is the Right Ankle bone.
--
---@source UnityEngine.AnimationModule.dll
---@field RightFoot UnityEngine.HumanBodyBones
--
--This is the first Spine bone.
--
---@source UnityEngine.AnimationModule.dll
---@field Spine UnityEngine.HumanBodyBones
--
--This is the Chest bone.
--
---@source UnityEngine.AnimationModule.dll
---@field Chest UnityEngine.HumanBodyBones
--
--This is the Upper Chest bone.
--
---@source UnityEngine.AnimationModule.dll
---@field UpperChest UnityEngine.HumanBodyBones
--
--This is the Neck bone.
--
---@source UnityEngine.AnimationModule.dll
---@field Neck UnityEngine.HumanBodyBones
--
--This is the Head bone.
--
---@source UnityEngine.AnimationModule.dll
---@field Head UnityEngine.HumanBodyBones
--
--This is the Left Shoulder bone.
--
---@source UnityEngine.AnimationModule.dll
---@field LeftShoulder UnityEngine.HumanBodyBones
--
--This is the Right Shoulder bone.
--
---@source UnityEngine.AnimationModule.dll
---@field RightShoulder UnityEngine.HumanBodyBones
--
--This is the Left Upper Arm bone.
--
---@source UnityEngine.AnimationModule.dll
---@field LeftUpperArm UnityEngine.HumanBodyBones
--
--This is the Right Upper Arm bone.
--
---@source UnityEngine.AnimationModule.dll
---@field RightUpperArm UnityEngine.HumanBodyBones
--
--This is the Left Elbow bone.
--
---@source UnityEngine.AnimationModule.dll
---@field LeftLowerArm UnityEngine.HumanBodyBones
--
--This is the Right Elbow bone.
--
---@source UnityEngine.AnimationModule.dll
---@field RightLowerArm UnityEngine.HumanBodyBones
--
--This is the Left Wrist bone.
--
---@source UnityEngine.AnimationModule.dll
---@field LeftHand UnityEngine.HumanBodyBones
--
--This is the Right Wrist bone.
--
---@source UnityEngine.AnimationModule.dll
---@field RightHand UnityEngine.HumanBodyBones
--
--This is the Left Toes bone.
--
---@source UnityEngine.AnimationModule.dll
---@field LeftToes UnityEngine.HumanBodyBones
--
--This is the Right Toes bone.
--
---@source UnityEngine.AnimationModule.dll
---@field RightToes UnityEngine.HumanBodyBones
--
--This is the Left Eye bone.
--
---@source UnityEngine.AnimationModule.dll
---@field LeftEye UnityEngine.HumanBodyBones
--
--This is the Right Eye bone.
--
---@source UnityEngine.AnimationModule.dll
---@field RightEye UnityEngine.HumanBodyBones
--
--This is the Jaw bone.
--
---@source UnityEngine.AnimationModule.dll
---@field Jaw UnityEngine.HumanBodyBones
--
--This is the left thumb 1st phalange.
--
---@source UnityEngine.AnimationModule.dll
---@field LeftThumbProximal UnityEngine.HumanBodyBones
--
--This is the left thumb 2nd phalange.
--
---@source UnityEngine.AnimationModule.dll
---@field LeftThumbIntermediate UnityEngine.HumanBodyBones
--
--This is the left thumb 3rd phalange.
--
---@source UnityEngine.AnimationModule.dll
---@field LeftThumbDistal UnityEngine.HumanBodyBones
--
--This is the left index 1st phalange.
--
---@source UnityEngine.AnimationModule.dll
---@field LeftIndexProximal UnityEngine.HumanBodyBones
--
--This is the left index 2nd phalange.
--
---@source UnityEngine.AnimationModule.dll
---@field LeftIndexIntermediate UnityEngine.HumanBodyBones
--
--This is the left index 3rd phalange.
--
---@source UnityEngine.AnimationModule.dll
---@field LeftIndexDistal UnityEngine.HumanBodyBones
--
--This is the left middle 1st phalange.
--
---@source UnityEngine.AnimationModule.dll
---@field LeftMiddleProximal UnityEngine.HumanBodyBones
--
--This is the left middle 2nd phalange.
--
---@source UnityEngine.AnimationModule.dll
---@field LeftMiddleIntermediate UnityEngine.HumanBodyBones
--
--This is the left middle 3rd phalange.
--
---@source UnityEngine.AnimationModule.dll
---@field LeftMiddleDistal UnityEngine.HumanBodyBones
--
--This is the left ring 1st phalange.
--
---@source UnityEngine.AnimationModule.dll
---@field LeftRingProximal UnityEngine.HumanBodyBones
--
--This is the left ring 2nd phalange.
--
---@source UnityEngine.AnimationModule.dll
---@field LeftRingIntermediate UnityEngine.HumanBodyBones
--
--This is the left ring 3rd phalange.
--
---@source UnityEngine.AnimationModule.dll
---@field LeftRingDistal UnityEngine.HumanBodyBones
--
--This is the left little 1st phalange.
--
---@source UnityEngine.AnimationModule.dll
---@field LeftLittleProximal UnityEngine.HumanBodyBones
--
--This is the left little 2nd phalange.
--
---@source UnityEngine.AnimationModule.dll
---@field LeftLittleIntermediate UnityEngine.HumanBodyBones
--
--This is the left little 3rd phalange.
--
---@source UnityEngine.AnimationModule.dll
---@field LeftLittleDistal UnityEngine.HumanBodyBones
--
--This is the right thumb 1st phalange.
--
---@source UnityEngine.AnimationModule.dll
---@field RightThumbProximal UnityEngine.HumanBodyBones
--
--This is the right thumb 2nd phalange.
--
---@source UnityEngine.AnimationModule.dll
---@field RightThumbIntermediate UnityEngine.HumanBodyBones
--
--This is the right thumb 3rd phalange.
--
---@source UnityEngine.AnimationModule.dll
---@field RightThumbDistal UnityEngine.HumanBodyBones
--
--This is the right index 1st phalange.
--
---@source UnityEngine.AnimationModule.dll
---@field RightIndexProximal UnityEngine.HumanBodyBones
--
--This is the right index 2nd phalange.
--
---@source UnityEngine.AnimationModule.dll
---@field RightIndexIntermediate UnityEngine.HumanBodyBones
--
--This is the right index 3rd phalange.
--
---@source UnityEngine.AnimationModule.dll
---@field RightIndexDistal UnityEngine.HumanBodyBones
--
--This is the right middle 1st phalange.
--
---@source UnityEngine.AnimationModule.dll
---@field RightMiddleProximal UnityEngine.HumanBodyBones
--
--This is the right middle 2nd phalange.
--
---@source UnityEngine.AnimationModule.dll
---@field RightMiddleIntermediate UnityEngine.HumanBodyBones
--
--This is the right middle 3rd phalange.
--
---@source UnityEngine.AnimationModule.dll
---@field RightMiddleDistal UnityEngine.HumanBodyBones
--
--This is the right ring 1st phalange.
--
---@source UnityEngine.AnimationModule.dll
---@field RightRingProximal UnityEngine.HumanBodyBones
--
--This is the right ring 2nd phalange.
--
---@source UnityEngine.AnimationModule.dll
---@field RightRingIntermediate UnityEngine.HumanBodyBones
--
--This is the right ring 3rd phalange.
--
---@source UnityEngine.AnimationModule.dll
---@field RightRingDistal UnityEngine.HumanBodyBones
--
--This is the right little 1st phalange.
--
---@source UnityEngine.AnimationModule.dll
---@field RightLittleProximal UnityEngine.HumanBodyBones
--
--This is the right little 2nd phalange.
--
---@source UnityEngine.AnimationModule.dll
---@field RightLittleIntermediate UnityEngine.HumanBodyBones
--
--This is the right little 3rd phalange.
--
---@source UnityEngine.AnimationModule.dll
---@field RightLittleDistal UnityEngine.HumanBodyBones
--
--This is the Last bone index delimiter.
--
---@source UnityEngine.AnimationModule.dll
---@field LastBone UnityEngine.HumanBodyBones
---@source UnityEngine.AnimationModule.dll
CS.UnityEngine.HumanBodyBones = {}

---@source 
---@param value any
---@return UnityEngine.HumanBodyBones
function CS.UnityEngine.HumanBodyBones:__CastFrom(value) end


--
--Avatar definition.
--
---@source UnityEngine.AnimationModule.dll
---@class UnityEngine.Avatar: UnityEngine.Object
--
--Return true if this avatar is a valid mecanim avatar. It can be a generic avatar or a human avatar.
--
---@source UnityEngine.AnimationModule.dll
---@field isValid bool
--
--Return true if this avatar is a valid human avatar.
--
---@source UnityEngine.AnimationModule.dll
---@field isHuman bool
--
--Returns the HumanDescription used to create this Avatar.
--
---@source UnityEngine.AnimationModule.dll
---@field humanDescription UnityEngine.HumanDescription
---@source UnityEngine.AnimationModule.dll
CS.UnityEngine.Avatar = {}


--
--Details of the Transform name mapped to the skeleton bone of a model and its default position and rotation in the T-pose.
--
---@source UnityEngine.AnimationModule.dll
---@class UnityEngine.SkeletonBone: System.ValueType
--
--The name of the Transform mapped to the bone.
--
---@source UnityEngine.AnimationModule.dll
---@field name string
--
--The T-pose position of the bone in local space.
--
---@source UnityEngine.AnimationModule.dll
---@field position UnityEngine.Vector3
--
--The T-pose rotation of the bone in local space.
--
---@source UnityEngine.AnimationModule.dll
---@field rotation UnityEngine.Quaternion
--
--The T-pose scaling of the bone in local space.
--
---@source UnityEngine.AnimationModule.dll
---@field scale UnityEngine.Vector3
---@source UnityEngine.AnimationModule.dll
---@field transformModified int
---@source UnityEngine.AnimationModule.dll
CS.UnityEngine.SkeletonBone = {}


--
--This class stores the rotation limits that define the muscle for a single human bone.
--
---@source UnityEngine.AnimationModule.dll
---@class UnityEngine.HumanLimit: System.ValueType
--
--Should this limit use the default values?
--
---@source UnityEngine.AnimationModule.dll
---@field useDefaultValues bool
--
--The maximum negative rotation away from the initial value that this muscle can apply.
--
---@source UnityEngine.AnimationModule.dll
---@field min UnityEngine.Vector3
--
--The maximum rotation away from the initial value that this muscle can apply.
--
---@source UnityEngine.AnimationModule.dll
---@field max UnityEngine.Vector3
--
--The default orientation of a bone when no muscle action is applied.
--
---@source UnityEngine.AnimationModule.dll
---@field center UnityEngine.Vector3
--
--Length of the bone to which the limit is applied.
--
---@source UnityEngine.AnimationModule.dll
---@field axisLength float
---@source UnityEngine.AnimationModule.dll
CS.UnityEngine.HumanLimit = {}


--
--The mapping between a bone in the model and the conceptual bone in the Mecanim human anatomy.
--
---@source UnityEngine.AnimationModule.dll
---@class UnityEngine.HumanBone: System.ValueType
--
--The rotation limits that define the muscle for this bone.
--
---@source UnityEngine.AnimationModule.dll
---@field limit UnityEngine.HumanLimit
--
--The name of the bone to which the Mecanim human bone is mapped.
--
---@source UnityEngine.AnimationModule.dll
---@field boneName string
--
--The name of the Mecanim human bone to which the bone from the model is mapped.
--
---@source UnityEngine.AnimationModule.dll
---@field humanName string
---@source UnityEngine.AnimationModule.dll
CS.UnityEngine.HumanBone = {}


--
--Class that holds humanoid avatar parameters to pass to the AvatarBuilder.BuildHumanAvatar function.
--
---@source UnityEngine.AnimationModule.dll
---@class UnityEngine.HumanDescription: System.ValueType
--
--Mapping between Mecanim bone names and bone names in the rig.
--
---@source UnityEngine.AnimationModule.dll
---@field human UnityEngine.HumanBone[]
--
--List of bone Transforms to include in the model.
--
---@source UnityEngine.AnimationModule.dll
---@field skeleton UnityEngine.SkeletonBone[]
--
--Defines how the upper arm's roll/twisting is distributed between the shoulder and elbow joints.
--
---@source UnityEngine.AnimationModule.dll
---@field upperArmTwist float
--
--Defines how the lower arm's roll/twisting is distributed between the elbow and wrist joints.
--
---@source UnityEngine.AnimationModule.dll
---@field lowerArmTwist float
--
--Defines how the upper leg's roll/twisting is distributed between the thigh and knee joints.
--
---@source UnityEngine.AnimationModule.dll
---@field upperLegTwist float
--
--Defines how the lower leg's roll/twisting is distributed between the knee and ankle.
--
---@source UnityEngine.AnimationModule.dll
---@field lowerLegTwist float
--
--Amount by which the arm's length is allowed to stretch when using IK.
--
---@source UnityEngine.AnimationModule.dll
---@field armStretch float
--
--Amount by which the leg's length is allowed to stretch when using IK.
--
---@source UnityEngine.AnimationModule.dll
---@field legStretch float
--
--Modification to the minimum distance between the feet of a humanoid model.
--
---@source UnityEngine.AnimationModule.dll
---@field feetSpacing float
--
--True for any human that has a translation Degree of Freedom (DoF). It is set to false by default.
--
---@source UnityEngine.AnimationModule.dll
---@field hasTranslationDoF bool
---@source UnityEngine.AnimationModule.dll
CS.UnityEngine.HumanDescription = {}


--
--Class to build avatars from user scripts.
--
---@source UnityEngine.AnimationModule.dll
---@class UnityEngine.AvatarBuilder: object
---@source UnityEngine.AnimationModule.dll
CS.UnityEngine.AvatarBuilder = {}

--
--Returns the Avatar, you must always always check the avatar is valid before using it with Avatar.isValid.
--
--```plaintext
--Params: go - Root object of your transform hierachy. It must be the top most gameobject when you create the avatar.
--        humanDescription - Humanoid description of the avatar.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param go UnityEngine.GameObject
---@param humanDescription UnityEngine.HumanDescription
---@return Avatar
function CS.UnityEngine.AvatarBuilder:BuildHumanAvatar(go, humanDescription) end

--
--Create a new generic avatar.
--
--```plaintext
--Params: go - Root object of your transform hierarchy.
--        rootMotionTransformName - Transform name of the root motion transform. If empty no root motion is defined and you must take care of avatar movement yourself.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param go UnityEngine.GameObject
---@param rootMotionTransformName string
---@return Avatar
function CS.UnityEngine.AvatarBuilder:BuildGenericAvatar(go, rootMotionTransformName) end


--
--Avatar body part.
--
---@source UnityEngine.AnimationModule.dll
---@class UnityEngine.AvatarMaskBodyPart: System.Enum
--
--The Root.
--
---@source UnityEngine.AnimationModule.dll
---@field Root UnityEngine.AvatarMaskBodyPart
--
--The Body.
--
---@source UnityEngine.AnimationModule.dll
---@field Body UnityEngine.AvatarMaskBodyPart
--
--The Head.
--
---@source UnityEngine.AnimationModule.dll
---@field Head UnityEngine.AvatarMaskBodyPart
--
--The Left Leg.
--
---@source UnityEngine.AnimationModule.dll
---@field LeftLeg UnityEngine.AvatarMaskBodyPart
--
--The Right Leg.
--
---@source UnityEngine.AnimationModule.dll
---@field RightLeg UnityEngine.AvatarMaskBodyPart
--
--The Left Arm.
--
---@source UnityEngine.AnimationModule.dll
---@field LeftArm UnityEngine.AvatarMaskBodyPart
--
--The Right Arm.
--
---@source UnityEngine.AnimationModule.dll
---@field RightArm UnityEngine.AvatarMaskBodyPart
--
--Left Fingers.
--
---@source UnityEngine.AnimationModule.dll
---@field LeftFingers UnityEngine.AvatarMaskBodyPart
--
--Right Fingers.
--
---@source UnityEngine.AnimationModule.dll
---@field RightFingers UnityEngine.AvatarMaskBodyPart
--
--Left Foot IK.
--
---@source UnityEngine.AnimationModule.dll
---@field LeftFootIK UnityEngine.AvatarMaskBodyPart
--
--Right Foot IK.
--
---@source UnityEngine.AnimationModule.dll
---@field RightFootIK UnityEngine.AvatarMaskBodyPart
--
--Left Hand IK.
--
---@source UnityEngine.AnimationModule.dll
---@field LeftHandIK UnityEngine.AvatarMaskBodyPart
--
--Right Hand IK.
--
---@source UnityEngine.AnimationModule.dll
---@field RightHandIK UnityEngine.AvatarMaskBodyPart
--
--Total number of body parts.
--
---@source UnityEngine.AnimationModule.dll
---@field LastBodyPart UnityEngine.AvatarMaskBodyPart
---@source UnityEngine.AnimationModule.dll
CS.UnityEngine.AvatarMaskBodyPart = {}

---@source 
---@param value any
---@return UnityEngine.AvatarMaskBodyPart
function CS.UnityEngine.AvatarMaskBodyPart:__CastFrom(value) end


--
--AvatarMask is used to mask out humanoid body parts and transforms.
--
---@source UnityEngine.AnimationModule.dll
---@class UnityEngine.AvatarMask: UnityEngine.Object
--
--The number of humanoid body parts.
--
---@source UnityEngine.AnimationModule.dll
---@field humanoidBodyPartCount int
--
--Number of transforms.
--
---@source UnityEngine.AnimationModule.dll
---@field transformCount int
---@source UnityEngine.AnimationModule.dll
CS.UnityEngine.AvatarMask = {}

--
--Returns true if the humanoid body part at the given index is active.
--
--```plaintext
--Params: index - The index of the humanoid body part.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param index UnityEngine.AvatarMaskBodyPart
---@return Boolean
function CS.UnityEngine.AvatarMask.GetHumanoidBodyPartActive(index) end

--
--Sets the humanoid body part at the given index to active or not.
--
--```plaintext
--Params: index - The index of the humanoid body part.
--        value - Active or not.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param index UnityEngine.AvatarMaskBodyPart
---@param value bool
function CS.UnityEngine.AvatarMask.SetHumanoidBodyPartActive(index, value) end

---@source UnityEngine.AnimationModule.dll
---@param transform UnityEngine.Transform
function CS.UnityEngine.AvatarMask.AddTransformPath(transform) end

--
--Adds a transform path into the AvatarMask.
--
--```plaintext
--Params: transform - The transform to add into the AvatarMask.
--        recursive - Whether to also add all children of the specified transform.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param transform UnityEngine.Transform
---@param recursive bool
function CS.UnityEngine.AvatarMask.AddTransformPath(transform, recursive) end

---@source UnityEngine.AnimationModule.dll
---@param transform UnityEngine.Transform
function CS.UnityEngine.AvatarMask.RemoveTransformPath(transform) end

--
--Removes a transform path from the AvatarMask.
--
--```plaintext
--Params: transform - The Transform that should be removed from the AvatarMask.
--        recursive - Whether to also remove all children of the specified transform.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param transform UnityEngine.Transform
---@param recursive bool
function CS.UnityEngine.AvatarMask.RemoveTransformPath(transform, recursive) end

--
--Returns the path of the transform at the given index.
--
--```plaintext
--Params: index - The index of the transform.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param index int
---@return String
function CS.UnityEngine.AvatarMask.GetTransformPath(index) end

--
--Sets the path of the transform at the given index.
--
--```plaintext
--Params: index - The index of the transform.
--        path - The path of the transform.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param index int
---@param path string
function CS.UnityEngine.AvatarMask.SetTransformPath(index, path) end

--
--Returns true if the transform at the given index is active.
--
--```plaintext
--Params: index - The index of the transform.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param index int
---@return Boolean
function CS.UnityEngine.AvatarMask.GetTransformActive(index) end

--
--Sets the tranform at the given index to active or not.
--
--```plaintext
--Params: index - The index of the transform.
--        value - Active or not.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param index int
---@param value bool
function CS.UnityEngine.AvatarMask.SetTransformActive(index, value) end


--
--Retargetable humanoid pose.
--
---@source UnityEngine.AnimationModule.dll
---@class UnityEngine.HumanPose: System.ValueType
--
--The human body position for that pose.
--
---@source UnityEngine.AnimationModule.dll
---@field bodyPosition UnityEngine.Vector3
--
--The human body orientation for that pose.
--
---@source UnityEngine.AnimationModule.dll
---@field bodyRotation UnityEngine.Quaternion
--
--The array of muscle values for that pose.
--
---@source UnityEngine.AnimationModule.dll
---@field muscles float[]
---@source UnityEngine.AnimationModule.dll
CS.UnityEngine.HumanPose = {}


--
--Use this class to create, read, and write the HumanPose for a humanoid avatar skeleton hierarchy or an avatar pose.
--
---@source UnityEngine.AnimationModule.dll
---@class UnityEngine.HumanPoseHandler: object
---@source UnityEngine.AnimationModule.dll
CS.UnityEngine.HumanPoseHandler = {}

---@source UnityEngine.AnimationModule.dll
function CS.UnityEngine.HumanPoseHandler.Dispose() end

---@source UnityEngine.AnimationModule.dll
---@param humanPose UnityEngine.HumanPose
function CS.UnityEngine.HumanPoseHandler.GetHumanPose(humanPose) end

---@source UnityEngine.AnimationModule.dll
---@param humanPose UnityEngine.HumanPose
function CS.UnityEngine.HumanPoseHandler.SetHumanPose(humanPose) end

---@source UnityEngine.AnimationModule.dll
---@param humanPose UnityEngine.HumanPose
function CS.UnityEngine.HumanPoseHandler.GetInternalHumanPose(humanPose) end

---@source UnityEngine.AnimationModule.dll
---@param humanPose UnityEngine.HumanPose
function CS.UnityEngine.HumanPoseHandler.SetInternalHumanPose(humanPose) end

---@source UnityEngine.AnimationModule.dll
---@param avatarPose Unity.Collections.NativeArray<float>
function CS.UnityEngine.HumanPoseHandler.GetInternalAvatarPose(avatarPose) end

---@source UnityEngine.AnimationModule.dll
---@param avatarPose Unity.Collections.NativeArray<float>
function CS.UnityEngine.HumanPoseHandler.SetInternalAvatarPose(avatarPose) end


--
--Details of all the human bone and muscle types defined by Mecanim.
--
---@source UnityEngine.AnimationModule.dll
---@class UnityEngine.HumanTrait: object
--
--The number of human muscle types defined by Mecanim.
--
---@source UnityEngine.AnimationModule.dll
---@field MuscleCount int
--
--Array of the names of all human muscle types defined by Mecanim.
--
---@source UnityEngine.AnimationModule.dll
---@field MuscleName string[]
--
--The number of human bone types defined by Mecanim.
--
---@source UnityEngine.AnimationModule.dll
---@field BoneCount int
--
--Array of the names of all human bone types defined by Mecanim.
--
---@source UnityEngine.AnimationModule.dll
---@field BoneName string[]
--
--The number of bone types that are required by Mecanim for any human model.
--
---@source UnityEngine.AnimationModule.dll
---@field RequiredBoneCount int
---@source UnityEngine.AnimationModule.dll
CS.UnityEngine.HumanTrait = {}

--
--Obtain the muscle index for a particular bone index and "degree of freedom".
--
--```plaintext
--Params: i - Bone index.
--        dofIndex - Number representing a "degree of freedom": 0 for X-Axis, 1 for Y-Axis, 2 for Z-Axis.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param i int
---@param dofIndex int
---@return Int32
function CS.UnityEngine.HumanTrait:MuscleFromBone(i, dofIndex) end

--
--Return the bone to which a particular muscle is connected.
--
--```plaintext
--Params: i - Muscle index.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param i int
---@return Int32
function CS.UnityEngine.HumanTrait:BoneFromMuscle(i) end

--
--Is the bone a member of the minimal set of bones that Mecanim requires for a human model?
--
--```plaintext
--Params: i - Index of the bone to test.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param i int
---@return Boolean
function CS.UnityEngine.HumanTrait:RequiredBone(i) end

--
--Get the default minimum value of rotation for a muscle in degrees.
--
--```plaintext
--Params: i - Muscle index.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param i int
---@return Single
function CS.UnityEngine.HumanTrait:GetMuscleDefaultMin(i) end

--
--Get the default maximum value of rotation for a muscle in degrees.
--
--```plaintext
--Params: i - Muscle index.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param i int
---@return Single
function CS.UnityEngine.HumanTrait:GetMuscleDefaultMax(i) end

--
--The bone hierarchy mass.
--
--```plaintext
--Params: i - The humanoid bone index.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param i int
---@return Single
function CS.UnityEngine.HumanTrait:GetBoneDefaultHierarchyMass(i) end

--
--Humanoid bone index of parent.
--
--```plaintext
--Params: i - Humanoid bone index to get parent from.
--        
--```
--
---@source UnityEngine.AnimationModule.dll
---@param i int
---@return Int32
function CS.UnityEngine.HumanTrait:GetParentBone(i) end


--
--Base class for AnimationClips and BlendTrees.
--
---@source UnityEngine.AnimationModule.dll
---@class UnityEngine.Motion: UnityEngine.Object
---@source UnityEngine.AnimationModule.dll
---@field averageDuration float
---@source UnityEngine.AnimationModule.dll
---@field averageAngularSpeed float
---@source UnityEngine.AnimationModule.dll
---@field averageSpeed UnityEngine.Vector3
---@source UnityEngine.AnimationModule.dll
---@field apparentSpeed float
---@source UnityEngine.AnimationModule.dll
---@field isLooping bool
---@source UnityEngine.AnimationModule.dll
---@field legacy bool
---@source UnityEngine.AnimationModule.dll
---@field isHumanMotion bool
---@source UnityEngine.AnimationModule.dll
---@field isAnimatorMotion bool
---@source UnityEngine.AnimationModule.dll
CS.UnityEngine.Motion = {}

---@source UnityEngine.AnimationModule.dll
---@param val bool
---@return Boolean
function CS.UnityEngine.Motion.ValidateIfRetargetable(val) end


--
--The runtime representation of the AnimatorController. Use this representation to change the Animator Controller during runtime.
--
---@source UnityEngine.AnimationModule.dll
---@class UnityEngine.RuntimeAnimatorController: UnityEngine.Object
--
--Retrieves all AnimationClip used by the controller.
--
---@source UnityEngine.AnimationModule.dll
---@field animationClips UnityEngine.AnimationClip[]
---@source UnityEngine.AnimationModule.dll
CS.UnityEngine.RuntimeAnimatorController = {}


--
--Asynchronous create request for an AssetBundle.
--
---@source UnityEngine.AssetBundleModule.dll
---@class UnityEngine.AssetBundleCreateRequest: UnityEngine.AsyncOperation
--
--Asset object being loaded (Read Only).
--
---@source UnityEngine.AssetBundleModule.dll
---@field assetBundle UnityEngine.AssetBundle
---@source UnityEngine.AssetBundleModule.dll
CS.UnityEngine.AssetBundleCreateRequest = {}


--
--Manifest for all the AssetBundles in the build.
--
---@source UnityEngine.AssetBundleModule.dll
---@class UnityEngine.AssetBundleManifest: UnityEngine.Object
---@source UnityEngine.AssetBundleModule.dll
CS.UnityEngine.AssetBundleManifest = {}

--
--An array of asset bundle names.
--
---@source UnityEngine.AssetBundleModule.dll
function CS.UnityEngine.AssetBundleManifest.GetAllAssetBundles() end

--
--An array of asset bundle names.
--
---@source UnityEngine.AssetBundleModule.dll
function CS.UnityEngine.AssetBundleManifest.GetAllAssetBundlesWithVariant() end

--
--The 128-bit hash for the asset bundle.
--
--```plaintext
--Params: assetBundleName - Name of the asset bundle.
--        
--```
--
---@source UnityEngine.AssetBundleModule.dll
---@param assetBundleName string
---@return Hash128
function CS.UnityEngine.AssetBundleManifest.GetAssetBundleHash(assetBundleName) end

--
--Array of asset bundle names this asset bundle depends on.
--
--```plaintext
--Params: assetBundleName - Name of the asset bundle.
--        
--```
--
---@source UnityEngine.AssetBundleModule.dll
---@param assetBundleName string
function CS.UnityEngine.AssetBundleManifest.GetDirectDependencies(assetBundleName) end

--
--Get all the dependent AssetBundles for the given AssetBundle.
--
--```plaintext
--Params: assetBundleName - Name of the asset bundle.
--        
--```
--
---@source UnityEngine.AssetBundleModule.dll
---@param assetBundleName string
function CS.UnityEngine.AssetBundleManifest.GetAllDependencies(assetBundleName) end


--
--Asynchronous AssetBundle recompression from one compression method and level to another.
--
---@source UnityEngine.AssetBundleModule.dll
---@class UnityEngine.AssetBundleRecompressOperation: UnityEngine.AsyncOperation
--
--A string describing the recompression operation result (Read Only).
--
---@source UnityEngine.AssetBundleModule.dll
---@field humanReadableResult string
--
--Path of the AssetBundle being recompressed (Read Only).
--
---@source UnityEngine.AssetBundleModule.dll
---@field inputPath string
--
--Path of the resulting recompressed AssetBundle (Read Only).
--
---@source UnityEngine.AssetBundleModule.dll
---@field outputPath string
--
--Result of the recompression operation.
--
---@source UnityEngine.AssetBundleModule.dll
---@field result UnityEngine.AssetBundleLoadResult
--
--True if the recompress operation is complete and was successful, otherwise false (Read Only).
--
---@source UnityEngine.AssetBundleModule.dll
---@field success bool
---@source UnityEngine.AssetBundleModule.dll
CS.UnityEngine.AssetBundleRecompressOperation = {}


--
--Asynchronous load request from an AssetBundle.
--
---@source UnityEngine.AssetBundleModule.dll
---@class UnityEngine.AssetBundleRequest: UnityEngine.ResourceRequest
--
--Asset object being loaded (Read Only).
--
---@source UnityEngine.AssetBundleModule.dll
---@field asset UnityEngine.Object
--
--Asset objects with sub assets being loaded. (Read Only)
--
---@source UnityEngine.AssetBundleModule.dll
---@field allAssets UnityEngine.Object[]
---@source UnityEngine.AssetBundleModule.dll
CS.UnityEngine.AssetBundleRequest = {}


--
--Compression Method for Asset Bundles.
--
---@source UnityEngine.AssetBundleModule.dll
---@class UnityEngine.CompressionType: System.Enum
--
--Uncompressed Asset Bundles are larger than compressed Asset Bundles, but they are the fastest to access once downloaded.
--
---@source UnityEngine.AssetBundleModule.dll
---@field None UnityEngine.CompressionType
--
--LZMA compression results in smaller compressed Asset Bundles but they must be entirely decompressed before use.
--
---@source UnityEngine.AssetBundleModule.dll
---@field Lzma UnityEngine.CompressionType
--
--LZ4 compression results in larger compressed files than LZMA, but does not require the entire bundle to be decompressed before use.
--
---@source UnityEngine.AssetBundleModule.dll
---@field Lz4 UnityEngine.CompressionType
--
--LZ4HC is a high compression variant of LZ4. LZ4HC compression results in larger compressed files than LZMA, but does not require the entire bundle to be decompressed before use.
--
---@source UnityEngine.AssetBundleModule.dll
---@field Lz4HC UnityEngine.CompressionType
---@source UnityEngine.AssetBundleModule.dll
CS.UnityEngine.CompressionType = {}

---@source 
---@param value any
---@return UnityEngine.CompressionType
function CS.UnityEngine.CompressionType:__CastFrom(value) end


--
--Compression Levels relate to how much time should be spent compressing Assets into an Asset Bundle.
--
---@source UnityEngine.AssetBundleModule.dll
---@class UnityEngine.CompressionLevel: System.Enum
--
--No compression.
--
---@source UnityEngine.AssetBundleModule.dll
---@field None UnityEngine.CompressionLevel
---@source UnityEngine.AssetBundleModule.dll
---@field Fastest UnityEngine.CompressionLevel
---@source UnityEngine.AssetBundleModule.dll
---@field Fast UnityEngine.CompressionLevel
---@source UnityEngine.AssetBundleModule.dll
---@field Normal UnityEngine.CompressionLevel
---@source UnityEngine.AssetBundleModule.dll
---@field High UnityEngine.CompressionLevel
---@source UnityEngine.AssetBundleModule.dll
---@field Maximum UnityEngine.CompressionLevel
---@source UnityEngine.AssetBundleModule.dll
CS.UnityEngine.CompressionLevel = {}

---@source 
---@param value any
---@return UnityEngine.CompressionLevel
function CS.UnityEngine.CompressionLevel:__CastFrom(value) end


--
--Contains information about compression methods, compression levels and block sizes that are supported by Asset Bundle compression at build time and recompression at runtime.
--
---@source UnityEngine.AssetBundleModule.dll
---@class UnityEngine.BuildCompression: System.ValueType
--
--Uncompressed Asset Bundle.
--
---@source UnityEngine.AssetBundleModule.dll
---@field Uncompressed UnityEngine.BuildCompression
--
--LZ4HC "Chunk Based" Compression.
--
---@source UnityEngine.AssetBundleModule.dll
---@field LZ4 UnityEngine.BuildCompression
--
--LZMA Compression.
--
---@source UnityEngine.AssetBundleModule.dll
---@field LZMA UnityEngine.BuildCompression
--
--Uncompressed Asset Bundle.
--
---@source UnityEngine.AssetBundleModule.dll
---@field UncompressedRuntime UnityEngine.BuildCompression
--
--LZ4 Compression for runtime recompression.
--
---@source UnityEngine.AssetBundleModule.dll
---@field LZ4Runtime UnityEngine.BuildCompression
---@source UnityEngine.AssetBundleModule.dll
---@field compression UnityEngine.CompressionType
---@source UnityEngine.AssetBundleModule.dll
---@field level UnityEngine.CompressionLevel
---@source UnityEngine.AssetBundleModule.dll
---@field blockSize uint
---@source UnityEngine.AssetBundleModule.dll
CS.UnityEngine.BuildCompression = {}


--
--Controls the global audio settings from script.
--
---@source UnityEngine.AudioModule.dll
---@class UnityEngine.AudioSettings: object
---@source UnityEngine.AudioModule.dll
---@field driverCaps UnityEngine.AudioSpeakerMode
--
--Returns the speaker mode capability of the current audio driver. (Read Only)
--
---@source UnityEngine.AudioModule.dll
---@field driverCapabilities UnityEngine.AudioSpeakerMode
--
--Gets the current speaker mode. Default is 2 channel stereo.
--
---@source UnityEngine.AudioModule.dll
---@field speakerMode UnityEngine.AudioSpeakerMode
--
--Returns the current time of the audio system.
--
---@source UnityEngine.AudioModule.dll
---@field dspTime double
--
--Get the mixer's current output rate.
--
---@source UnityEngine.AudioModule.dll
---@field outputSampleRate int
---@source UnityEngine.AudioModule.dll
---@field OnAudioConfigurationChanged UnityEngine.AudioSettings.AudioConfigurationChangeHandler
---@source UnityEngine.AudioModule.dll
CS.UnityEngine.AudioSettings = {}

---@source UnityEngine.AudioModule.dll
---@param bufferLength int
---@param numBuffers int
function CS.UnityEngine.AudioSettings:GetDSPBufferSize(bufferLength, numBuffers) end

---@source UnityEngine.AudioModule.dll
---@param bufferLength int
---@param numBuffers int
function CS.UnityEngine.AudioSettings:SetDSPBufferSize(bufferLength, numBuffers) end

--
--An array of spatializer names.
--
---@source UnityEngine.AudioModule.dll
function CS.UnityEngine.AudioSettings:GetSpatializerPluginNames() end

--
--The spatializer plugin name.
--
---@source UnityEngine.AudioModule.dll
---@return String
function CS.UnityEngine.AudioSettings:GetSpatializerPluginName() end

--
--Sets the spatializer plugin for all platform groups. If a null or empty string is passed in, the existing spatializer plugin will be cleared.
--
--```plaintext
--Params: pluginName - The spatializer plugin name.
--        
--```
--
---@source UnityEngine.AudioModule.dll
---@param pluginName string
function CS.UnityEngine.AudioSettings:SetSpatializerPluginName(pluginName) end

--
--The new configuration to be applied.
--
---@source UnityEngine.AudioModule.dll
---@return AudioConfiguration
function CS.UnityEngine.AudioSettings:GetConfiguration() end

--
--True if all settings could be successfully applied.
--
--```plaintext
--Params: config - The new configuration to be used.
--        
--```
--
---@source UnityEngine.AudioModule.dll
---@param config UnityEngine.AudioConfiguration
---@return Boolean
function CS.UnityEngine.AudioSettings:Reset(config) end

---@source UnityEngine.AudioModule.dll
---@param value UnityEngine.AudioSettings.AudioConfigurationChangeHandler
function CS.UnityEngine.AudioSettings:add_OnAudioConfigurationChanged(value) end

---@source UnityEngine.AudioModule.dll
---@param value UnityEngine.AudioSettings.AudioConfigurationChangeHandler
function CS.UnityEngine.AudioSettings:remove_OnAudioConfigurationChanged(value) end


--
--A delegate called whenever the global audio settings are changed, either by AudioSettings.Reset or by an external device change such as the OS control panel changing the sample rate or because the default output device was changed, for example when plugging in an HDMI monitor or a USB headset.
--
--```plaintext
--Params: deviceWasChanged - True if the change was caused by an device change.
--        
--```
--
---@source UnityEngine.AudioModule.dll
---@class UnityEngine.AudioConfigurationChangeHandler: System.MulticastDelegate
---@source UnityEngine.AudioModule.dll
CS.UnityEngine.AudioConfigurationChangeHandler = {}

---@source UnityEngine.AudioModule.dll
---@param deviceWasChanged bool
function CS.UnityEngine.AudioConfigurationChangeHandler.Invoke(deviceWasChanged) end

---@source UnityEngine.AudioModule.dll
---@param deviceWasChanged bool
---@param callback System.AsyncCallback
---@param object object
---@return IAsyncResult
function CS.UnityEngine.AudioConfigurationChangeHandler.BeginInvoke(deviceWasChanged, callback, object) end

---@source UnityEngine.AudioModule.dll
---@param result System.IAsyncResult
function CS.UnityEngine.AudioConfigurationChangeHandler.EndInvoke(result) end


--
--This class encapsulates properties and methods to handle audio output thread on iOS/Android.
--
---@source UnityEngine.AudioModule.dll
---@class UnityEngine.Mobile: object
--
--Returns true if current device media volume is 0.
--
---@source UnityEngine.AudioModule.dll
---@field muteState bool
--
--Set this property to true to make audio output thread automatically stop when device media volume is set to 0 and to start it again when volume is not 0.
--
---@source UnityEngine.AudioModule.dll
---@field stopAudioOutputOnMute bool
--
--Returns true if audio output thread is working.
--
---@source UnityEngine.AudioModule.dll
---@field audioOutputStarted bool
---@source UnityEngine.AudioModule.dll
---@field OnMuteStateChanged System.Action<bool>
---@source UnityEngine.AudioModule.dll
CS.UnityEngine.Mobile = {}

---@source UnityEngine.AudioModule.dll
---@param value System.Action<bool>
function CS.UnityEngine.Mobile:add_OnMuteStateChanged(value) end

---@source UnityEngine.AudioModule.dll
---@param value System.Action<bool>
function CS.UnityEngine.Mobile:remove_OnMuteStateChanged(value) end

--
--Starts audio output thread on Android/iOS.
--
---@source UnityEngine.AudioModule.dll
function CS.UnityEngine.Mobile:StartAudioOutput() end

--
--Stops audio thread on Android/iOS.
--
---@source UnityEngine.AudioModule.dll
function CS.UnityEngine.Mobile:StopAudioOutput() end


--
--A representation of audio sources in 3D.
--
---@source UnityEngine.AudioModule.dll
---@class UnityEngine.AudioSource: UnityEngine.AudioBehaviour
--
--PanLevel has been deprecated. Use spatialBlend instead.
--
---@source UnityEngine.AudioModule.dll
---@field panLevel float
--
--Pan has been deprecated. Use panStereo instead.
--
---@source UnityEngine.AudioModule.dll
---@field pan float
--
--The volume of the audio source (0.0 to 1.0).
--
---@source UnityEngine.AudioModule.dll
---@field volume float
--
--The pitch of the audio source.
--
---@source UnityEngine.AudioModule.dll
---@field pitch float
--
--Playback position in seconds.
--
---@source UnityEngine.AudioModule.dll
---@field time float
--
--Playback position in PCM samples.
--
---@source UnityEngine.AudioModule.dll
---@field timeSamples int
--
--The default AudioClip to play.
--
---@source UnityEngine.AudioModule.dll
---@field clip UnityEngine.AudioClip
--
--The target group to which the AudioSource should route its signal.
--
---@source UnityEngine.AudioModule.dll
---@field outputAudioMixerGroup UnityEngine.Audio.AudioMixerGroup
--
--Gets or sets the gamepad audio output type for this audio source.
--
---@source UnityEngine.AudioModule.dll
---@field gamepadSpeakerOutputType UnityEngine.GamepadSpeakerOutputType
--
--Is the clip playing right now (Read Only)?
--
---@source UnityEngine.AudioModule.dll
---@field isPlaying bool
--
--True if all sounds played by the AudioSource (main sound started by Play() or playOnAwake as well as one-shots) are culled by the audio system.
--
---@source UnityEngine.AudioModule.dll
---@field isVirtual bool
--
--Is the audio clip looping?
--
---@source UnityEngine.AudioModule.dll
---@field loop bool
--
--This makes the audio source not take into account the volume of the audio listener.
--
---@source UnityEngine.AudioModule.dll
---@field ignoreListenerVolume bool
--
--If set to true, the audio source will automatically start playing on awake.
--
---@source UnityEngine.AudioModule.dll
---@field playOnAwake bool
--
--Allows AudioSource to play even though AudioListener.pause is set to true. This is useful for the menu element sounds or background music in pause menus.
--
---@source UnityEngine.AudioModule.dll
---@field ignoreListenerPause bool
--
--Whether the Audio Source should be updated in the fixed or dynamic update.
--
---@source UnityEngine.AudioModule.dll
---@field velocityUpdateMode UnityEngine.AudioVelocityUpdateMode
--
--Pans a playing sound in a stereo way (left or right). This only applies to sounds that are Mono or Stereo.
--
---@source UnityEngine.AudioModule.dll
---@field panStereo float
--
--Sets how much this AudioSource is affected by 3D spatialisation calculations (attenuation, doppler etc). 0.0 makes the sound full 2D, 1.0 makes it full 3D.
--
---@source UnityEngine.AudioModule.dll
---@field spatialBlend float
--
--Enables or disables spatialization.
--
---@source UnityEngine.AudioModule.dll
---@field spatialize bool
--
--Determines if the spatializer effect is inserted before or after the effect filters.
--
---@source UnityEngine.AudioModule.dll
---@field spatializePostEffects bool
--
--The amount by which the signal from the AudioSource will be mixed into the global reverb associated with the Reverb Zones.
--
---@source UnityEngine.AudioModule.dll
---@field reverbZoneMix float
--
--Bypass effects (Applied from filter components or global listener filters).
--
---@source UnityEngine.AudioModule.dll
---@field bypassEffects bool
--
--When set global effects on the AudioListener will not be applied to the audio signal generated by the AudioSource. Does not apply if the AudioSource is playing into a mixer group.
--
---@source UnityEngine.AudioModule.dll
---@field bypassListenerEffects bool
--
--When set doesn't route the signal from an AudioSource into the global reverb associated with reverb zones.
--
---@source UnityEngine.AudioModule.dll
---@field bypassReverbZones bool
--
--Sets the Doppler scale for this AudioSource.
--
---@source UnityEngine.AudioModule.dll
---@field dopplerLevel float
--
--Sets the spread angle (in degrees) of a 3d stereo or multichannel sound in speaker space.
--
---@source UnityEngine.AudioModule.dll
---@field spread float
--
--Sets the priority of the AudioSource.
--
---@source UnityEngine.AudioModule.dll
---@field priority int
--
--Un- / Mutes the AudioSource. Mute sets the volume=0, Un-Mute restore the original volume.
--
---@source UnityEngine.AudioModule.dll
---@field mute bool
--
--Within the Min distance the AudioSource will cease to grow louder in volume.
--
---@source UnityEngine.AudioModule.dll
---@field minDistance float
--
--(Logarithmic rolloff) MaxDistance is the distance a sound stops attenuating at.
--
---@source UnityEngine.AudioModule.dll
---@field maxDistance float
--
--Sets/Gets how the AudioSource attenuates over distance.
--
---@source UnityEngine.AudioModule.dll
---@field rolloffMode UnityEngine.AudioRolloffMode
---@source UnityEngine.AudioModule.dll
---@field minVolume float
---@source UnityEngine.AudioModule.dll
---@field maxVolume float
---@source UnityEngine.AudioModule.dll
---@field rolloffFactor float
---@source UnityEngine.AudioModule.dll
CS.UnityEngine.AudioSource = {}

--
--Returns TRUE if enabling audio output through this users controller was successful.
--
--```plaintext
--Params: slot - Slot number of the gamepad (0-3).
--        
--```
--
---@source UnityEngine.AudioModule.dll
---@param slot int
---@return Boolean
function CS.UnityEngine.AudioSource.PlayOnGamepad(slot) end

--
--Returns true if successful.
--
---@source UnityEngine.AudioModule.dll
---@return Boolean
function CS.UnityEngine.AudioSource.DisableGamepadOutput() end

---@source UnityEngine.AudioModule.dll
---@param slot int
---@param mixLevel int
---@return Boolean
function CS.UnityEngine.AudioSource.SetGamepadSpeakerMixLevel(slot, mixLevel) end

---@source UnityEngine.AudioModule.dll
---@param slot int
---@return Boolean
function CS.UnityEngine.AudioSource.SetGamepadSpeakerMixLevelDefault(slot) end

---@source UnityEngine.AudioModule.dll
---@param slot int
---@param restricted bool
---@return Boolean
function CS.UnityEngine.AudioSource.SetGamepadSpeakerRestrictedAudio(slot, restricted) end

--
--Returns true if the gamepad supports the specified audio output type.
--
--```plaintext
--Params: outputType - The desired output type.
--        
--```
--
---@source UnityEngine.AudioModule.dll
---@param outputType UnityEngine.GamepadSpeakerOutputType
---@return Boolean
function CS.UnityEngine.AudioSource:GamepadSpeakerSupportsOutputType(outputType) end

---@source UnityEngine.AudioModule.dll
function CS.UnityEngine.AudioSource.Play() end

--
--Plays the clip.
--
--```plaintext
--Params: delay - Deprecated. Delay in number of samples, assuming a 44100Hz sample rate (meaning that Play(44100) will delay the playing by exactly 1 sec).
--        
--```
--
---@source UnityEngine.AudioModule.dll
---@param delay ulong
function CS.UnityEngine.AudioSource.Play(delay) end

--
--Plays the clip with a delay specified in seconds. Users are advised to use this function instead of the old Play(delay) function that took a delay specified in samples relative to a reference rate of 44.1 kHz as an argument.
--
--```plaintext
--Params: delay - Delay time specified in seconds.
--        
--```
--
---@source UnityEngine.AudioModule.dll
---@param delay float
function CS.UnityEngine.AudioSource.PlayDelayed(delay) end

--
--Plays the clip at a specific time on the absolute time-line that AudioSettings.dspTime reads from.
--
--```plaintext
--Params: time - Time in seconds on the absolute time-line that AudioSettings.dspTime refers to for when the sound should start playing.
--        
--```
--
---@source UnityEngine.AudioModule.dll
---@param time double
function CS.UnityEngine.AudioSource.PlayScheduled(time) end

--
--Plays an AudioClip, and scales the AudioSource volume by volumeScale.
--
--```plaintext
--Params: clip - The clip being played.
--        volumeScale - The scale of the volume (0-1).
--        
--```
--
---@source UnityEngine.AudioModule.dll
---@param clip UnityEngine.AudioClip
function CS.UnityEngine.AudioSource.PlayOneShot(clip) end

--
--Plays an AudioClip, and scales the AudioSource volume by volumeScale.
--
--```plaintext
--Params: clip - The clip being played.
--        volumeScale - The scale of the volume (0-1).
--        
--```
--
---@source UnityEngine.AudioModule.dll
---@param clip UnityEngine.AudioClip
---@param volumeScale float
function CS.UnityEngine.AudioSource.PlayOneShot(clip, volumeScale) end

--
--Changes the time at which a sound that has already been scheduled to play will start.
--
--```plaintext
--Params: time - Time in seconds.
--        
--```
--
---@source UnityEngine.AudioModule.dll
---@param time double
function CS.UnityEngine.AudioSource.SetScheduledStartTime(time) end

--
--Changes the time at which a sound that has already been scheduled to play will end. Notice that depending on the timing not all rescheduling requests can be fulfilled.
--
--```plaintext
--Params: time - Time in seconds.
--        
--```
--
---@source UnityEngine.AudioModule.dll
---@param time double
function CS.UnityEngine.AudioSource.SetScheduledEndTime(time) end

--
--Stops playing the clip.
--
---@source UnityEngine.AudioModule.dll
function CS.UnityEngine.AudioSource.Stop() end

--
--Pauses playing the clip.
--
---@source UnityEngine.AudioModule.dll
function CS.UnityEngine.AudioSource.Pause() end

--
--Unpause the paused playback of this AudioSource.
--
---@source UnityEngine.AudioModule.dll
function CS.UnityEngine.AudioSource.UnPause() end

--
--Plays an AudioClip at a given position in world space.
--
--```plaintext
--Params: clip - Audio data to play.
--        position - Position in world space from which sound originates.
--        volume - Playback volume.
--        
--```
--
---@source UnityEngine.AudioModule.dll
---@param clip UnityEngine.AudioClip
---@param position UnityEngine.Vector3
function CS.UnityEngine.AudioSource:PlayClipAtPoint(clip, position) end

--
--Plays an AudioClip at a given position in world space.
--
--```plaintext
--Params: clip - Audio data to play.
--        position - Position in world space from which sound originates.
--        volume - Playback volume.
--        
--```
--
---@source UnityEngine.AudioModule.dll
---@param clip UnityEngine.AudioClip
---@param position UnityEngine.Vector3
---@param volume float
function CS.UnityEngine.AudioSource:PlayClipAtPoint(clip, position, volume) end

--
--Set the custom curve for the given AudioSourceCurveType.
--
--```plaintext
--Params: type - The curve type that should be set.
--        curve - The curve that should be applied to the given curve type.
--        
--```
--
---@source UnityEngine.AudioModule.dll
---@param type UnityEngine.AudioSourceCurveType
---@param curve UnityEngine.AnimationCurve
function CS.UnityEngine.AudioSource.SetCustomCurve(type, curve) end

--
--The custom AnimationCurve corresponding to the given curve type.
--
--```plaintext
--Params: type - The curve type to get.
--        
--```
--
---@source UnityEngine.AudioModule.dll
---@param type UnityEngine.AudioSourceCurveType
---@return AnimationCurve
function CS.UnityEngine.AudioSource.GetCustomCurve(type) end

--
--Deprecated Version. Returns a block of the currently playing source's output data.
--
---@source UnityEngine.AudioModule.dll
---@param numSamples int
---@param channel int
function CS.UnityEngine.AudioSource.GetOutputData(numSamples, channel) end

--
--Provides a block of the currently playing source's output data.
--
--```plaintext
--Params: samples - The array to populate with audio samples. Its length must be a power of 2.
--        channel - The channel to sample from.
--        
--```
--
---@source UnityEngine.AudioModule.dll
---@param samples float[]
---@param channel int
function CS.UnityEngine.AudioSource.GetOutputData(samples, channel) end

--
--Deprecated Version. Returns a block of the currently playing source's spectrum data.
--
--```plaintext
--Params: numSamples - The number of samples to retrieve. Must be a power of 2.
--        channel - The channel to sample from.
--        window - The FFTWindow type to use when sampling.
--        
--```
--
---@source UnityEngine.AudioModule.dll
---@param numSamples int
---@param channel int
---@param window UnityEngine.FFTWindow
function CS.UnityEngine.AudioSource.GetSpectrumData(numSamples, channel, window) end

--
--Provides a block of the currently playing audio source's spectrum data.
--
--```plaintext
--Params: samples - The array to populate with audio samples. Its length must be a power of 2.
--        channel - The channel to sample from.
--        window - The FFTWindow type to use when sampling.
--        
--```
--
---@source UnityEngine.AudioModule.dll
---@param samples float[]
---@param channel int
---@param window UnityEngine.FFTWindow
function CS.UnityEngine.AudioSource.GetSpectrumData(samples, channel, window) end

--
--True, if the parameter could be set.
--
--```plaintext
--Params: index - Zero-based index of user-defined parameter to be set.
--        value - New value of the user-defined parameter.
--        
--```
--
---@source UnityEngine.AudioModule.dll
---@param index int
---@param value float
---@return Boolean
function CS.UnityEngine.AudioSource.SetSpatializerFloat(index, value) end

---@source UnityEngine.AudioModule.dll
---@param index int
---@param value float
---@return Boolean
function CS.UnityEngine.AudioSource.GetSpatializerFloat(index, value) end

---@source UnityEngine.AudioModule.dll
---@param index int
---@param value float
---@return Boolean
function CS.UnityEngine.AudioSource.GetAmbisonicDecoderFloat(index, value) end

--
--True, if the parameter could be set.
--
--```plaintext
--Params: index - Zero-based index of user-defined parameter to be set.
--        value - New value of the user-defined parameter.
--        
--```
--
---@source UnityEngine.AudioModule.dll
---@param index int
---@param value float
---@return Boolean
function CS.UnityEngine.AudioSource.SetAmbisonicDecoderFloat(index, value) end


--
--The Audio Low Pass Filter passes low frequencies of an AudioSource or all sounds reaching an AudioListener, while removing frequencies higher than the Cutoff Frequency.
--
---@source UnityEngine.AudioModule.dll
---@class UnityEngine.AudioLowPassFilter: UnityEngine.Behaviour
---@source UnityEngine.AudioModule.dll
---@field lowpassResonaceQ float
--
--Returns or sets the current custom frequency cutoff curve.
--
---@source UnityEngine.AudioModule.dll
---@field customCutoffCurve UnityEngine.AnimationCurve
--
--Lowpass cutoff frequency in hz. 10.0 to 22000.0. Default = 5000.0.
--
---@source UnityEngine.AudioModule.dll
---@field cutoffFrequency float
--
--Determines how much the filter's self-resonance is dampened.
--
---@source UnityEngine.AudioModule.dll
---@field lowpassResonanceQ float
---@source UnityEngine.AudioModule.dll
CS.UnityEngine.AudioLowPassFilter = {}


--
--The Audio High Pass Filter passes high frequencies of an AudioSource, and cuts off signals with frequencies lower than the Cutoff Frequency.
--
---@source UnityEngine.AudioModule.dll
---@class UnityEngine.AudioHighPassFilter: UnityEngine.Behaviour
---@source UnityEngine.AudioModule.dll
---@field highpassResonaceQ float
--
--Highpass cutoff frequency in hz. 10.0 to 22000.0. Default = 5000.0.
--
---@source UnityEngine.AudioModule.dll
---@field cutoffFrequency float
--
--Determines how much the filter's self-resonance isdampened.
--
---@source UnityEngine.AudioModule.dll
---@field highpassResonanceQ float
---@source UnityEngine.AudioModule.dll
CS.UnityEngine.AudioHighPassFilter = {}


--
--The Audio Reverb Filter takes an Audio Clip and distorts it to create a custom reverb effect.
--
---@source UnityEngine.AudioModule.dll
---@class UnityEngine.AudioReverbFilter: UnityEngine.Behaviour
---@source UnityEngine.AudioModule.dll
---@field lFReference float
--
--Set/Get reverb preset properties.
--
---@source UnityEngine.AudioModule.dll
---@field reverbPreset UnityEngine.AudioReverbPreset
--
--Mix level of dry signal in output in millibels (mB). Ranges from -10000.0 to 0.0. Default is 0.
--
---@source UnityEngine.AudioModule.dll
---@field dryLevel float
--
--Room effect level at low frequencies in millibels (mB). Ranges from -10000.0 to 0.0. Default is 0.0.
--
---@source UnityEngine.AudioModule.dll
---@field room float
--
--Room effect high-frequency level re. low frequency level in millibels (mB). Ranges from -10000.0 to 0.0. Default is 0.0.
--
---@source UnityEngine.AudioModule.dll
---@field roomHF float
---@source UnityEngine.AudioModule.dll
---@field roomRolloffFactor float
--
--Reverberation decay time at low-frequencies in seconds. Ranges from 0.1 to 20.0. Default is 1.0.
--
---@source UnityEngine.AudioModule.dll
---@field decayTime float
--
--Decay HF Ratio : High-frequency to low-frequency decay time ratio. Ranges from 0.1 to 2.0. Default is 0.5.
--
---@source UnityEngine.AudioModule.dll
---@field decayHFRatio float
--
--Early reflections level relative to room effect in millibels (mB). Ranges from -10000.0 to 1000.0. Default is -10000.0.
--
---@source UnityEngine.AudioModule.dll
---@field reflectionsLevel float
--
--Late reverberation level relative to room effect in millibels (mB). Ranges from -10000.0 to 2000.0. Default is 0.0.
--
---@source UnityEngine.AudioModule.dll
---@field reflectionsDelay float
--
--Late reverberation level relative to room effect in millibels (mB). Ranges from -10000.0 to 2000.0. Default is 0.0.
--
---@source UnityEngine.AudioModule.dll
---@field reverbLevel float
--
--Late reverberation delay time relative to first reflection in seconds. Ranges from 0.0 to 0.1. Default is 0.04.
--
---@source UnityEngine.AudioModule.dll
---@field reverbDelay float
--
--Reverberation diffusion (echo density) in percent. Ranges from 0.0 to 100.0. Default is 100.0.
--
---@source UnityEngine.AudioModule.dll
---@field diffusion float
--
--Reverberation density (modal density) in percent. Ranges from 0.0 to 100.0. Default is 100.0.
--
---@source UnityEngine.AudioModule.dll
---@field density float
--
--Reference high frequency in hertz (Hz). Ranges from 1000.0 to 20000.0. Default is 5000.0.
--
---@source UnityEngine.AudioModule.dll
---@field hfReference float
--
--Room effect low-frequency level in millibels (mB). Ranges from -10000.0 to 0.0. Default is 0.0.
--
---@source UnityEngine.AudioModule.dll
---@field roomLF float
--
--Reference low-frequency in hertz (Hz). Ranges from 20.0 to 1000.0. Default is 250.0.
--
---@source UnityEngine.AudioModule.dll
---@field lfReference float
---@source UnityEngine.AudioModule.dll
CS.UnityEngine.AudioReverbFilter = {}


--
--These are speaker types defined for use with AudioSettings.speakerMode.
--
---@source UnityEngine.AudioModule.dll
---@class UnityEngine.AudioSpeakerMode: System.Enum
--
--Channel count is unaffected.
--
---@source UnityEngine.AudioModule.dll
---@field Raw UnityEngine.AudioSpeakerMode
--
--Channel count is set to 1. The speakers are monaural.
--
---@source UnityEngine.AudioModule.dll
---@field Mono UnityEngine.AudioSpeakerMode
--
--Channel count is set to 2. The speakers are stereo. This is the editor default.
--
---@source UnityEngine.AudioModule.dll
---@field Stereo UnityEngine.AudioSpeakerMode
--
--Channel count is set to 4. 4 speaker setup. This includes front left, front right, rear left, rear right.
--
---@source UnityEngine.AudioModule.dll
---@field Quad UnityEngine.AudioSpeakerMode
--
--Channel count is set to 5. 5 speaker setup. This includes front left, front right, center, rear left, rear right.
--
---@source UnityEngine.AudioModule.dll
---@field Surround UnityEngine.AudioSpeakerMode
--
--Channel count is set to 6. 5.1 speaker setup. This includes front left, front right, center, rear left, rear right and a subwoofer.
--
---@source UnityEngine.AudioModule.dll
---@field Mode5point1 UnityEngine.AudioSpeakerMode
--
--Channel count is set to 8. 7.1 speaker setup. This includes front left, front right, center, rear left, rear right, side left, side right and a subwoofer.
--
---@source UnityEngine.AudioModule.dll
---@field Mode7point1 UnityEngine.AudioSpeakerMode
--
--Channel count is set to 2. Stereo output, but data is encoded in a way that is picked up by a Prologic/Prologic2 decoder and split into a 5.1 speaker setup.
--
---@source UnityEngine.AudioModule.dll
---@field Prologic UnityEngine.AudioSpeakerMode
---@source UnityEngine.AudioModule.dll
CS.UnityEngine.AudioSpeakerMode = {}

---@source 
---@param value any
---@return UnityEngine.AudioSpeakerMode
function CS.UnityEngine.AudioSpeakerMode:__CastFrom(value) end


--
--Value describing the current load state of the audio data associated with an AudioClip.
--
---@source UnityEngine.AudioModule.dll
---@class UnityEngine.AudioDataLoadState: System.Enum
--
--Value returned by AudioClip.loadState for an AudioClip that has no audio data loaded and where loading has not been initiated yet.
--
---@source UnityEngine.AudioModule.dll
---@field Unloaded UnityEngine.AudioDataLoadState
--
--Value returned by AudioClip.loadState for an AudioClip that is currently loading audio data.
--
---@source UnityEngine.AudioModule.dll
---@field Loading UnityEngine.AudioDataLoadState
--
--Value returned by AudioClip.loadState for an AudioClip that has succeeded loading its audio data.
--
---@source UnityEngine.AudioModule.dll
---@field Loaded UnityEngine.AudioDataLoadState
--
--Value returned by AudioClip.loadState for an AudioClip that has failed loading its audio data.
--
---@source UnityEngine.AudioModule.dll
---@field Failed UnityEngine.AudioDataLoadState
---@source UnityEngine.AudioModule.dll
CS.UnityEngine.AudioDataLoadState = {}

---@source 
---@param value any
---@return UnityEngine.AudioDataLoadState
function CS.UnityEngine.AudioDataLoadState:__CastFrom(value) end


--
--Specifies the current properties or desired properties to be set for the audio system.
--
---@source UnityEngine.AudioModule.dll
---@class UnityEngine.AudioConfiguration: System.ValueType
--
--The current speaker mode used by the audio output device.
--
---@source UnityEngine.AudioModule.dll
---@field speakerMode UnityEngine.AudioSpeakerMode
--
--The length of the DSP buffer in samples determining the latency of sounds by the audio output device.
--
---@source UnityEngine.AudioModule.dll
---@field dspBufferSize int
--
--The current sample rate of the audio output device used.
--
---@source UnityEngine.AudioModule.dll
---@field sampleRate int
--
--The current maximum number of simultaneously audible sounds in the game.
--
---@source UnityEngine.AudioModule.dll
---@field numRealVoices int
--
--The  maximum number of managed sounds in the game. Beyond this limit sounds will simply stop playing.
--
---@source UnityEngine.AudioModule.dll
---@field numVirtualVoices int
---@source UnityEngine.AudioModule.dll
CS.UnityEngine.AudioConfiguration = {}


--
--An enum containing different compression types.
--
---@source UnityEngine.AudioModule.dll
---@class UnityEngine.AudioCompressionFormat: System.Enum
--
--Uncompressed pulse-code modulation.
--
---@source UnityEngine.AudioModule.dll
---@field PCM UnityEngine.AudioCompressionFormat
--
--Vorbis compression format.
--
---@source UnityEngine.AudioModule.dll
---@field Vorbis UnityEngine.AudioCompressionFormat
--
--Adaptive differential pulse-code modulation.
--
---@source UnityEngine.AudioModule.dll
---@field ADPCM UnityEngine.AudioCompressionFormat
--
--MPEG Audio Layer III.
--
---@source UnityEngine.AudioModule.dll
---@field MP3 UnityEngine.AudioCompressionFormat
--
--Sony proprietary hardware format.
--
---@source UnityEngine.AudioModule.dll
---@field VAG UnityEngine.AudioCompressionFormat
--
--Sony proprietory hardware codec.
--
---@source UnityEngine.AudioModule.dll
---@field HEVAG UnityEngine.AudioCompressionFormat
--
--Xbox One proprietary hardware format.
--
---@source UnityEngine.AudioModule.dll
---@field XMA UnityEngine.AudioCompressionFormat
--
--AAC Audio Compression.
--
---@source UnityEngine.AudioModule.dll
---@field AAC UnityEngine.AudioCompressionFormat
--
--Nintendo ADPCM audio compression format.
--
---@source UnityEngine.AudioModule.dll
---@field GCADPCM UnityEngine.AudioCompressionFormat
--
--Sony proprietary hardware format.
--
---@source UnityEngine.AudioModule.dll
---@field ATRAC9 UnityEngine.AudioCompressionFormat
---@source UnityEngine.AudioModule.dll
CS.UnityEngine.AudioCompressionFormat = {}

---@source 
---@param value any
---@return UnityEngine.AudioCompressionFormat
function CS.UnityEngine.AudioCompressionFormat:__CastFrom(value) end


--
--Determines how the audio clip is loaded in.
--
---@source UnityEngine.AudioModule.dll
---@class UnityEngine.AudioClipLoadType: System.Enum
--
--The audio data is decompressed when the audio clip is loaded.
--
---@source UnityEngine.AudioModule.dll
---@field DecompressOnLoad UnityEngine.AudioClipLoadType
--
--The audio data of the clip will be kept in memory in compressed form.
--
---@source UnityEngine.AudioModule.dll
---@field CompressedInMemory UnityEngine.AudioClipLoadType
--
--Streams audio data from disk.
--
---@source UnityEngine.AudioModule.dll
---@field Streaming UnityEngine.AudioClipLoadType
---@source UnityEngine.AudioModule.dll
CS.UnityEngine.AudioClipLoadType = {}

---@source 
---@param value any
---@return UnityEngine.AudioClipLoadType
function CS.UnityEngine.AudioClipLoadType:__CastFrom(value) end


--
--Describes when an AudioSource or AudioListener is updated.
--
---@source UnityEngine.AudioModule.dll
---@class UnityEngine.AudioVelocityUpdateMode: System.Enum
--
--Updates the source or listener in the MonoBehaviour.FixedUpdate loop if it is attached to a Rigidbody, dynamic MonoBehaviour.Update otherwise.
--
---@source UnityEngine.AudioModule.dll
---@field Auto UnityEngine.AudioVelocityUpdateMode
--
--Updates the source or listener in the MonoBehaviour.FixedUpdate loop.
--
---@source UnityEngine.AudioModule.dll
---@field Fixed UnityEngine.AudioVelocityUpdateMode
--
--Updates the source or listener in the dynamic MonoBehaviour.Update loop.
--
---@source UnityEngine.AudioModule.dll
---@field Dynamic UnityEngine.AudioVelocityUpdateMode
---@source UnityEngine.AudioModule.dll
CS.UnityEngine.AudioVelocityUpdateMode = {}

---@source 
---@param value any
---@return UnityEngine.AudioVelocityUpdateMode
function CS.UnityEngine.AudioVelocityUpdateMode:__CastFrom(value) end


--
--Spectrum analysis windowing types.
--
---@source UnityEngine.AudioModule.dll
---@class UnityEngine.FFTWindow: System.Enum
--
--W[n] = 1.0.
--
---@source UnityEngine.AudioModule.dll
---@field Rectangular UnityEngine.FFTWindow
--
--W[n] = TRI(2n/N).
--
---@source UnityEngine.AudioModule.dll
---@field Triangle UnityEngine.FFTWindow
--
--W[n] = 0.54 - (0.46 * COS(n/N) ).
--
---@source UnityEngine.AudioModule.dll
---@field Hamming UnityEngine.FFTWindow
--
--W[n] = 0.5 * (1.0 - COS(n/N) ).
--
---@source UnityEngine.AudioModule.dll
---@field Hanning UnityEngine.FFTWindow
--
--W[n] = 0.42 - (0.5 * COS(nN) ) + (0.08 * COS(2.0 * nN) ).
--
---@source UnityEngine.AudioModule.dll
---@field Blackman UnityEngine.FFTWindow
--
--W[n] = 0.35875 - (0.48829 * COS(1.0 * nN)) + (0.14128 * COS(2.0 * nN)) - (0.01168 * COS(3.0 * n/N)).
--
---@source UnityEngine.AudioModule.dll
---@field BlackmanHarris UnityEngine.FFTWindow
---@source UnityEngine.AudioModule.dll
CS.UnityEngine.FFTWindow = {}

---@source 
---@param value any
---@return UnityEngine.FFTWindow
function CS.UnityEngine.FFTWindow:__CastFrom(value) end


--
--Rolloff modes that a 3D sound can have in an audio source.
--
---@source UnityEngine.AudioModule.dll
---@class UnityEngine.AudioRolloffMode: System.Enum
--
--Use this mode when you want a real-world rolloff.
--
---@source UnityEngine.AudioModule.dll
---@field Logarithmic UnityEngine.AudioRolloffMode
--
--Use this mode when you want to lower the volume of your sound over the distance.
--
---@source UnityEngine.AudioModule.dll
---@field Linear UnityEngine.AudioRolloffMode
--
--Use this when you want to use a custom rolloff.
--
---@source UnityEngine.AudioModule.dll
---@field Custom UnityEngine.AudioRolloffMode
---@source UnityEngine.AudioModule.dll
CS.UnityEngine.AudioRolloffMode = {}

---@source 
---@param value any
---@return UnityEngine.AudioRolloffMode
function CS.UnityEngine.AudioRolloffMode:__CastFrom(value) end


--
--This defines the curve type of the different custom curves that can be queried and set within the AudioSource.
--
---@source UnityEngine.AudioModule.dll
---@class UnityEngine.AudioSourceCurveType: System.Enum
--
--Custom Volume Rolloff.
--
---@source UnityEngine.AudioModule.dll
---@field CustomRolloff UnityEngine.AudioSourceCurveType
--
--The Spatial Blend.
--
---@source UnityEngine.AudioModule.dll
---@field SpatialBlend UnityEngine.AudioSourceCurveType
--
--Reverb Zone Mix.
--
---@source UnityEngine.AudioModule.dll
---@field ReverbZoneMix UnityEngine.AudioSourceCurveType
--
--The 3D Spread.
--
---@source UnityEngine.AudioModule.dll
---@field Spread UnityEngine.AudioSourceCurveType
---@source UnityEngine.AudioModule.dll
CS.UnityEngine.AudioSourceCurveType = {}

---@source 
---@param value any
---@return UnityEngine.AudioSourceCurveType
function CS.UnityEngine.AudioSourceCurveType:__CastFrom(value) end


--
--Gamepad audio output types.
--
---@source UnityEngine.AudioModule.dll
---@class UnityEngine.GamepadSpeakerOutputType: System.Enum
--
--Audio output is through the gamepads audio speaker if the gamepad supports playing audio.
--
---@source UnityEngine.AudioModule.dll
---@field Speaker UnityEngine.GamepadSpeakerOutputType
--
--Audio output is through the gamepads vibration device if the gamepad supports playing audio as vibration.
--
---@source UnityEngine.AudioModule.dll
---@field Vibration UnityEngine.GamepadSpeakerOutputType
---@source UnityEngine.AudioModule.dll
CS.UnityEngine.GamepadSpeakerOutputType = {}

---@source 
---@param value any
---@return UnityEngine.GamepadSpeakerOutputType
function CS.UnityEngine.GamepadSpeakerOutputType:__CastFrom(value) end


--
--Reverb presets used by the Reverb Zone class and the audio reverb filter.
--
---@source UnityEngine.AudioModule.dll
---@class UnityEngine.AudioReverbPreset: System.Enum
--
--No reverb preset selected.
--
---@source UnityEngine.AudioModule.dll
---@field Off UnityEngine.AudioReverbPreset
--
--Generic preset.
--
---@source UnityEngine.AudioModule.dll
---@field Generic UnityEngine.AudioReverbPreset
--
--Padded cell preset.
--
---@source UnityEngine.AudioModule.dll
---@field PaddedCell UnityEngine.AudioReverbPreset
--
--Room preset.
--
---@source UnityEngine.AudioModule.dll
---@field Room UnityEngine.AudioReverbPreset
--
--Bathroom preset.
--
---@source UnityEngine.AudioModule.dll
---@field Bathroom UnityEngine.AudioReverbPreset
--
--Livingroom preset.
--
---@source UnityEngine.AudioModule.dll
---@field Livingroom UnityEngine.AudioReverbPreset
--
--Stoneroom preset.
--
---@source UnityEngine.AudioModule.dll
---@field Stoneroom UnityEngine.AudioReverbPreset
--
--Auditorium preset.
--
---@source UnityEngine.AudioModule.dll
---@field Auditorium UnityEngine.AudioReverbPreset
--
--Concert hall preset.
--
---@source UnityEngine.AudioModule.dll
---@field Concerthall UnityEngine.AudioReverbPreset
--
--Cave preset.
--
---@source UnityEngine.AudioModule.dll
---@field Cave UnityEngine.AudioReverbPreset
--
--Arena preset.
--
---@source UnityEngine.AudioModule.dll
---@field Arena UnityEngine.AudioReverbPreset
--
--Hangar preset.
--
---@source UnityEngine.AudioModule.dll
---@field Hangar UnityEngine.AudioReverbPreset
--
--Carpeted hallway preset.
--
---@source UnityEngine.AudioModule.dll
---@field CarpetedHallway UnityEngine.AudioReverbPreset
--
--Hallway preset.
--
---@source UnityEngine.AudioModule.dll
---@field Hallway UnityEngine.AudioReverbPreset
--
--Stone corridor preset.
--
---@source UnityEngine.AudioModule.dll
---@field StoneCorridor UnityEngine.AudioReverbPreset
--
--Alley preset.
--
---@source UnityEngine.AudioModule.dll
---@field Alley UnityEngine.AudioReverbPreset
--
--Forest preset.
--
---@source UnityEngine.AudioModule.dll
---@field Forest UnityEngine.AudioReverbPreset
--
--City preset.
--
---@source UnityEngine.AudioModule.dll
---@field City UnityEngine.AudioReverbPreset
--
--Mountains preset.
--
---@source UnityEngine.AudioModule.dll
---@field Mountains UnityEngine.AudioReverbPreset
--
--Quarry preset.
--
---@source UnityEngine.AudioModule.dll
---@field Quarry UnityEngine.AudioReverbPreset
--
--Plain preset.
--
---@source UnityEngine.AudioModule.dll
---@field Plain UnityEngine.AudioReverbPreset
--
--Parking Lot preset.
--
---@source UnityEngine.AudioModule.dll
---@field ParkingLot UnityEngine.AudioReverbPreset
--
--Sewer pipe preset.
--
---@source UnityEngine.AudioModule.dll
---@field SewerPipe UnityEngine.AudioReverbPreset
--
--Underwater presset.
--
---@source UnityEngine.AudioModule.dll
---@field Underwater UnityEngine.AudioReverbPreset
--
--Drugged preset.
--
---@source UnityEngine.AudioModule.dll
---@field Drugged UnityEngine.AudioReverbPreset
--
--Dizzy preset.
--
---@source UnityEngine.AudioModule.dll
---@field Dizzy UnityEngine.AudioReverbPreset
--
--Psychotic preset.
--
---@source UnityEngine.AudioModule.dll
---@field Psychotic UnityEngine.AudioReverbPreset
--
--User defined preset.
--
---@source UnityEngine.AudioModule.dll
---@field User UnityEngine.AudioReverbPreset
---@source UnityEngine.AudioModule.dll
CS.UnityEngine.AudioReverbPreset = {}

---@source 
---@param value any
---@return UnityEngine.AudioReverbPreset
function CS.UnityEngine.AudioReverbPreset:__CastFrom(value) end


--
--A container for audio data.
--
---@source UnityEngine.AudioModule.dll
---@class UnityEngine.AudioClip: UnityEngine.Object
--
--The length of the audio clip in seconds. (Read Only)
--
---@source UnityEngine.AudioModule.dll
---@field length float
--
--The length of the audio clip in samples. (Read Only)
--
---@source UnityEngine.AudioModule.dll
---@field samples int
--
--The number of channels in the audio clip. (Read Only)
--
---@source UnityEngine.AudioModule.dll
---@field channels int
--
--The sample frequency of the clip in Hertz. (Read Only)
--
---@source UnityEngine.AudioModule.dll
---@field frequency int
--
--Returns true if the AudioClip is ready to play (read-only).
--
---@source UnityEngine.AudioModule.dll
---@field isReadyToPlay bool
--
--The load type of the clip (read-only).
--
---@source UnityEngine.AudioModule.dll
---@field loadType UnityEngine.AudioClipLoadType
--
--Preloads audio data of the clip when the clip asset is loaded. When this flag is off, scripts have to call AudioClip.LoadAudioData() to load the data before the clip can be played. Properties like length, channels and format are available before the audio data has been loaded.
--
---@source UnityEngine.AudioModule.dll
---@field preloadAudioData bool
--
--Returns true if this audio clip is ambisonic (read-only).
--
---@source UnityEngine.AudioModule.dll
---@field ambisonic bool
--
--Corresponding to the "Load In Background" flag in the inspector, when this flag is set, the loading will happen delayed without blocking the main thread.
--
---@source UnityEngine.AudioModule.dll
---@field loadInBackground bool
--
--Returns the current load state of the audio data associated with an AudioClip.
--
---@source UnityEngine.AudioModule.dll
---@field loadState UnityEngine.AudioDataLoadState
---@source UnityEngine.AudioModule.dll
CS.UnityEngine.AudioClip = {}

--
--Returns true if loading succeeded.
--
---@source UnityEngine.AudioModule.dll
---@return Boolean
function CS.UnityEngine.AudioClip.LoadAudioData() end

--
--Returns false if unloading failed.
--
---@source UnityEngine.AudioModule.dll
---@return Boolean
function CS.UnityEngine.AudioClip.UnloadAudioData() end

--
--Fills an array with sample data from the clip.
--
---@source UnityEngine.AudioModule.dll
---@param data float[]
---@param offsetSamples int
---@return Boolean
function CS.UnityEngine.AudioClip.GetData(data, offsetSamples) end

--
--Set sample data in a clip.
--
---@source UnityEngine.AudioModule.dll
---@param data float[]
---@param offsetSamples int
---@return Boolean
function CS.UnityEngine.AudioClip.SetData(data, offsetSamples) end

--
--A reference to the created AudioClip.
--
--```plaintext
--Params: name - Name of clip.
--        lengthSamples - Number of sample frames.
--        channels - Number of channels per frame.
--        frequency - Sample frequency of clip.
--        _3D - Audio clip is played back in 3D.
--        stream - True if clip is streamed, that is if the pcmreadercallback generates data on the fly.
--        pcmreadercallback - This callback is invoked to generate a block of sample data. Non-streamed clips call this only once at creation time while streamed clips call this continuously.
--        pcmsetpositioncallback - This callback is invoked whenever the clip loops or changes playback position.
--        
--```
--
---@source UnityEngine.AudioModule.dll
---@param name string
---@param lengthSamples int
---@param channels int
---@param frequency int
---@param _3D bool
---@param stream bool
---@return AudioClip
function CS.UnityEngine.AudioClip:Create(name, lengthSamples, channels, frequency, _3D, stream) end

---@source UnityEngine.AudioModule.dll
---@param name string
---@param lengthSamples int
---@param channels int
---@param frequency int
---@param _3D bool
---@param stream bool
---@param pcmreadercallback UnityEngine.AudioClip.PCMReaderCallback
---@return AudioClip
function CS.UnityEngine.AudioClip:Create(name, lengthSamples, channels, frequency, _3D, stream, pcmreadercallback) end

---@source UnityEngine.AudioModule.dll
---@param name string
---@param lengthSamples int
---@param channels int
---@param frequency int
---@param _3D bool
---@param stream bool
---@param pcmreadercallback UnityEngine.AudioClip.PCMReaderCallback
---@param pcmsetpositioncallback UnityEngine.AudioClip.PCMSetPositionCallback
---@return AudioClip
function CS.UnityEngine.AudioClip:Create(name, lengthSamples, channels, frequency, _3D, stream, pcmreadercallback, pcmsetpositioncallback) end

--
--A reference to the created AudioClip.
--
--```plaintext
--Params: name - Name of clip.
--        lengthSamples - Number of sample frames.
--        channels - Number of channels per frame.
--        frequency - Sample frequency of clip.
--        _3D - Audio clip is played back in 3D.
--        stream - True if clip is streamed, that is if the pcmreadercallback generates data on the fly.
--        pcmreadercallback - This callback is invoked to generate a block of sample data. Non-streamed clips call this only once at creation time while streamed clips call this continuously.
--        pcmsetpositioncallback - This callback is invoked whenever the clip loops or changes playback position.
--        
--```
--
---@source UnityEngine.AudioModule.dll
---@param name string
---@param lengthSamples int
---@param channels int
---@param frequency int
---@param stream bool
---@return AudioClip
function CS.UnityEngine.AudioClip:Create(name, lengthSamples, channels, frequency, stream) end

---@source UnityEngine.AudioModule.dll
---@param name string
---@param lengthSamples int
---@param channels int
---@param frequency int
---@param stream bool
---@param pcmreadercallback UnityEngine.AudioClip.PCMReaderCallback
---@return AudioClip
function CS.UnityEngine.AudioClip:Create(name, lengthSamples, channels, frequency, stream, pcmreadercallback) end

---@source UnityEngine.AudioModule.dll
---@param name string
---@param lengthSamples int
---@param channels int
---@param frequency int
---@param stream bool
---@param pcmreadercallback UnityEngine.AudioClip.PCMReaderCallback
---@param pcmsetpositioncallback UnityEngine.AudioClip.PCMSetPositionCallback
---@return AudioClip
function CS.UnityEngine.AudioClip:Create(name, lengthSamples, channels, frequency, stream, pcmreadercallback, pcmsetpositioncallback) end


--
--The Audio Echo Filter repeats a sound after a given Delay, attenuating the repetitions based on the Decay Ratio.
--
---@source UnityEngine.AudioModule.dll
---@class UnityEngine.AudioEchoFilter: UnityEngine.Behaviour
--
--Echo delay in ms. 10 to 5000. Default = 500.
--
---@source UnityEngine.AudioModule.dll
---@field delay float
--
--Echo decay per delay. 0 to 1. 1.0 = No decay, 0.0 = total decay (i.e. simple 1 line delay). Default = 0.5.
--
---@source UnityEngine.AudioModule.dll
---@field decayRatio float
--
--Volume of original signal to pass to output. 0.0 to 1.0. Default = 1.0.
--
---@source UnityEngine.AudioModule.dll
---@field dryMix float
--
--Volume of echo signal to pass to output. 0.0 to 1.0. Default = 1.0.
--
---@source UnityEngine.AudioModule.dll
---@field wetMix float
---@source UnityEngine.AudioModule.dll
CS.UnityEngine.AudioEchoFilter = {}


--
--The Audio Chorus Filter takes an Audio Clip and processes it creating a chorus effect.
--
---@source UnityEngine.AudioModule.dll
---@class UnityEngine.AudioChorusFilter: UnityEngine.Behaviour
--
--Volume of original signal to pass to output. 0.0 to 1.0. Default = 0.5.
--
---@source UnityEngine.AudioModule.dll
---@field dryMix float
--
--Volume of 1st chorus tap. 0.0 to 1.0. Default = 0.5.
--
---@source UnityEngine.AudioModule.dll
---@field wetMix1 float
--
--Volume of 2nd chorus tap. This tap is 90 degrees out of phase of the first tap. 0.0 to 1.0. Default = 0.5.
--
---@source UnityEngine.AudioModule.dll
---@field wetMix2 float
--
--Volume of 3rd chorus tap. This tap is 90 degrees out of phase of the second tap. 0.0 to 1.0. Default = 0.5.
--
---@source UnityEngine.AudioModule.dll
---@field wetMix3 float
--
--Chorus delay in ms. 0.1 to 100.0. Default = 40.0 ms.
--
---@source UnityEngine.AudioModule.dll
---@field delay float
--
--Chorus modulation rate in hz. 0.0 to 20.0. Default = 0.8 hz.
--
---@source UnityEngine.AudioModule.dll
---@field rate float
--
--Chorus modulation depth. 0.0 to 1.0. Default = 0.03.
--
---@source UnityEngine.AudioModule.dll
---@field depth float
--
--Chorus feedback. Controls how much of the wet signal gets fed back into the chorus buffer. 0.0 to 1.0. Default = 0.0.
--
---@source UnityEngine.AudioModule.dll
---@field feedback float
---@source UnityEngine.AudioModule.dll
CS.UnityEngine.AudioChorusFilter = {}


--
--Use this class to record to an AudioClip using a connected microphone.
--
---@source UnityEngine.AudioModule.dll
---@class UnityEngine.Microphone: object
--
--A list of available microphone devices, identified by name.
--
---@source UnityEngine.AudioModule.dll
---@field devices string[]
---@source UnityEngine.AudioModule.dll
CS.UnityEngine.Microphone = {}

--
--The function returns null if the recording fails to start.
--
--```plaintext
--Params: deviceName - The name of the device.
--        loop - Indicates whether the recording should continue recording if lengthSec is reached, and wrap around and record from the beginning of the AudioClip.
--        lengthSec - Is the length of the AudioClip produced by the recording.
--        frequency - The sample rate of the AudioClip produced by the recording.
--        
--```
--
---@source UnityEngine.AudioModule.dll
---@param deviceName string
---@param loop bool
---@param lengthSec int
---@param frequency int
---@return AudioClip
function CS.UnityEngine.Microphone:Start(deviceName, loop, lengthSec, frequency) end

--
--Stops recording.
--
--```plaintext
--Params: deviceName - The name of the device.
--        
--```
--
---@source UnityEngine.AudioModule.dll
---@param deviceName string
function CS.UnityEngine.Microphone:End(deviceName) end

--
--Query if a device is currently recording.
--
--```plaintext
--Params: deviceName - The name of the device.
--        
--```
--
---@source UnityEngine.AudioModule.dll
---@param deviceName string
---@return Boolean
function CS.UnityEngine.Microphone:IsRecording(deviceName) end

--
--Get the position in samples of the recording.
--
--```plaintext
--Params: deviceName - The name of the device.
--        
--```
--
---@source UnityEngine.AudioModule.dll
---@param deviceName string
---@return Int32
function CS.UnityEngine.Microphone:GetPosition(deviceName) end

---@source UnityEngine.AudioModule.dll
---@param deviceName string
---@param minFreq int
---@param maxFreq int
function CS.UnityEngine.Microphone:GetDeviceCaps(deviceName, minFreq, maxFreq) end


--
--Delegate called each time AudioClip reads data.
--
--```plaintext
--Params: data - Array of floats containing data read from the clip.
--        
--```
--
---@source UnityEngine.AudioModule.dll
---@class UnityEngine.PCMReaderCallback: System.MulticastDelegate
---@source UnityEngine.AudioModule.dll
CS.UnityEngine.PCMReaderCallback = {}

---@source UnityEngine.AudioModule.dll
---@param data float[]
function CS.UnityEngine.PCMReaderCallback.Invoke(data) end

---@source UnityEngine.AudioModule.dll
---@param data float[]
---@param callback System.AsyncCallback
---@param object object
---@return IAsyncResult
function CS.UnityEngine.PCMReaderCallback.BeginInvoke(data, callback, object) end

---@source UnityEngine.AudioModule.dll
---@param result System.IAsyncResult
function CS.UnityEngine.PCMReaderCallback.EndInvoke(result) end


--
--Delegate called each time AudioClip changes read position.
--
--```plaintext
--Params: position - New position in the audio clip.
--        
--```
--
---@source UnityEngine.AudioModule.dll
---@class UnityEngine.PCMSetPositionCallback: System.MulticastDelegate
---@source UnityEngine.AudioModule.dll
CS.UnityEngine.PCMSetPositionCallback = {}

---@source UnityEngine.AudioModule.dll
---@param position int
function CS.UnityEngine.PCMSetPositionCallback.Invoke(position) end

---@source UnityEngine.AudioModule.dll
---@param position int
---@param callback System.AsyncCallback
---@param object object
---@return IAsyncResult
function CS.UnityEngine.PCMSetPositionCallback.BeginInvoke(position, callback, object) end

---@source UnityEngine.AudioModule.dll
---@param result System.IAsyncResult
function CS.UnityEngine.PCMSetPositionCallback.EndInvoke(result) end


---@source UnityEngine.AudioModule.dll
---@class UnityEngine.AudioBehaviour: UnityEngine.Behaviour
---@source UnityEngine.AudioModule.dll
CS.UnityEngine.AudioBehaviour = {}


--
--Representation of a listener in 3D space.
--
---@source UnityEngine.AudioModule.dll
---@class UnityEngine.AudioListener: UnityEngine.AudioBehaviour
--
--Controls the game sound volume (0.0 to 1.0).
--
---@source UnityEngine.AudioModule.dll
---@field volume float
--
--The paused state of the audio system.
--
---@source UnityEngine.AudioModule.dll
---@field pause bool
--
--This lets you set whether the Audio Listener should be updated in the fixed or dynamic update.
--
---@source UnityEngine.AudioModule.dll
---@field velocityUpdateMode UnityEngine.AudioVelocityUpdateMode
---@source UnityEngine.AudioModule.dll
CS.UnityEngine.AudioListener = {}

--
--Deprecated Version. Returns a block of the listener (master)'s output data.
--
---@source UnityEngine.AudioModule.dll
---@param numSamples int
---@param channel int
function CS.UnityEngine.AudioListener:GetOutputData(numSamples, channel) end

--
--Provides a block of the listener (master)'s output data.
--
--```plaintext
--Params: samples - The array to populate with audio samples. Its length must be a power of 2.
--        channel - The channel to sample from.
--        
--```
--
---@source UnityEngine.AudioModule.dll
---@param samples float[]
---@param channel int
function CS.UnityEngine.AudioListener:GetOutputData(samples, channel) end

--
--Deprecated Version. Returns a block of the listener (master)'s spectrum data.
--
--```plaintext
--Params: numSamples - Number of values (the length of the samples array). Must be a power of 2. Min = 64. Max = 8192.
--        channel - The channel to sample from.
--        window - The FFTWindow type to use when sampling.
--        
--```
--
---@source UnityEngine.AudioModule.dll
---@param numSamples int
---@param channel int
---@param window UnityEngine.FFTWindow
function CS.UnityEngine.AudioListener:GetSpectrumData(numSamples, channel, window) end

--
--Provides a block of the listener (master)'s spectrum data.
--
--```plaintext
--Params: samples - The array to populate with audio samples. Its length must be a power of 2.
--        channel - The channel to sample from.
--        window - The FFTWindow type to use when sampling.
--        
--```
--
---@source UnityEngine.AudioModule.dll
---@param samples float[]
---@param channel int
---@param window UnityEngine.FFTWindow
function CS.UnityEngine.AudioListener:GetSpectrumData(samples, channel, window) end


--
--Allow recording the main output of the game or specific groups in the AudioMixer.
--
---@source UnityEngine.AudioModule.dll
---@class UnityEngine.AudioRenderer: object
---@source UnityEngine.AudioModule.dll
CS.UnityEngine.AudioRenderer = {}

--
--True if the engine was switched into output recording mode. False if it is already recording.
--
---@source UnityEngine.AudioModule.dll
---@return Boolean
function CS.UnityEngine.AudioRenderer:Start() end

--
--True if the engine was recording when this function was called.
--
---@source UnityEngine.AudioModule.dll
---@return Boolean
function CS.UnityEngine.AudioRenderer:Stop() end

--
--Number of samples available since last recorded frame.
--
---@source UnityEngine.AudioModule.dll
---@return Int32
function CS.UnityEngine.AudioRenderer:GetSampleCountForCaptureFrame() end

---@source UnityEngine.AudioModule.dll
---@param buffer Unity.Collections.NativeArray<float>
---@return Boolean
function CS.UnityEngine.AudioRenderer:Render(buffer) end


--
--Reverb Zones are used when you want to create location based ambient effects in the Scene.
--
---@source UnityEngine.AudioModule.dll
---@class UnityEngine.AudioReverbZone: UnityEngine.Behaviour
--
--The distance from the centerpoint that the reverb will have full effect at. Default = 10.0.
--
---@source UnityEngine.AudioModule.dll
---@field minDistance float
--
--The distance from the centerpoint that the reverb will not have any effect. Default = 15.0.
--
---@source UnityEngine.AudioModule.dll
---@field maxDistance float
--
--Set/Get reverb preset properties.
--
---@source UnityEngine.AudioModule.dll
---@field reverbPreset UnityEngine.AudioReverbPreset
--
--Room effect level (at mid frequencies).
--
---@source UnityEngine.AudioModule.dll
---@field room int
--
--Relative room effect level at high frequencies.
--
---@source UnityEngine.AudioModule.dll
---@field roomHF int
--
--Relative room effect level at low frequencies.
--
---@source UnityEngine.AudioModule.dll
---@field roomLF int
--
--Reverberation decay time at mid frequencies.
--
---@source UnityEngine.AudioModule.dll
---@field decayTime float
--
--High-frequency to mid-frequency decay time ratio.
--
---@source UnityEngine.AudioModule.dll
---@field decayHFRatio float
--
--Early reflections level relative to room effect.
--
---@source UnityEngine.AudioModule.dll
---@field reflections int
--
--Initial reflection delay time.
--
---@source UnityEngine.AudioModule.dll
---@field reflectionsDelay float
--
--Late reverberation level relative to room effect.
--
---@source UnityEngine.AudioModule.dll
---@field reverb int
--
--Late reverberation delay time relative to initial reflection.
--
---@source UnityEngine.AudioModule.dll
---@field reverbDelay float
--
--Reference high frequency (hz).
--
---@source UnityEngine.AudioModule.dll
---@field HFReference float
--
--Reference low frequency (hz).
--
---@source UnityEngine.AudioModule.dll
---@field LFReference float
--
--Like rolloffscale in global settings, but for reverb room size effect.
--
---@source UnityEngine.AudioModule.dll
---@field roomRolloffFactor float
--
--Value that controls the echo density in the late reverberation decay.
--
---@source UnityEngine.AudioModule.dll
---@field diffusion float
--
--Value that controls the modal density in the late reverberation decay.
--
---@source UnityEngine.AudioModule.dll
---@field density float
---@source UnityEngine.AudioModule.dll
CS.UnityEngine.AudioReverbZone = {}


--
--MovieTexture has been removed. Use VideoPlayer instead.
--
---@source UnityEngine.AudioModule.dll
---@class UnityEngine.MovieTexture: UnityEngine.Texture
--
--MovieTexture has been removed. Use VideoPlayer instead.
--
---@source UnityEngine.AudioModule.dll
---@field audioClip UnityEngine.AudioClip
--
--MovieTexture has been removed. Use VideoPlayer instead.
--
---@source UnityEngine.AudioModule.dll
---@field loop bool
--
--MovieTexture has been removed. Use VideoPlayer instead.
--
---@source UnityEngine.AudioModule.dll
---@field isPlaying bool
--
--MovieTexture has been removed. Use VideoPlayer instead.
--
---@source UnityEngine.AudioModule.dll
---@field isReadyToPlay bool
--
--MovieTexture has been removed. Use VideoPlayer instead.
--
---@source UnityEngine.AudioModule.dll
---@field duration float
---@source UnityEngine.AudioModule.dll
CS.UnityEngine.MovieTexture = {}

--
--MovieTexture has been removed. Use VideoPlayer instead.
--
---@source UnityEngine.AudioModule.dll
function CS.UnityEngine.MovieTexture.Play() end

--
--MovieTexture has been removed. Use VideoPlayer instead.
--
---@source UnityEngine.AudioModule.dll
function CS.UnityEngine.MovieTexture.Stop() end

--
--MovieTexture has been removed. Use VideoPlayer instead.
--
---@source UnityEngine.AudioModule.dll
function CS.UnityEngine.MovieTexture.Pause() end


--
--The Audio Distortion Filter distorts the sound from an AudioSource or sounds reaching the AudioListener.
--
---@source UnityEngine.AudioModule.dll
---@class UnityEngine.AudioDistortionFilter: UnityEngine.Behaviour
--
--Distortion value. 0.0 to 1.0. Default = 0.5.
--
---@source UnityEngine.AudioModule.dll
---@field distortionLevel float
---@source UnityEngine.AudioModule.dll
CS.UnityEngine.AudioDistortionFilter = {}


---@source UnityEngine.AudioModule.dll
---@class UnityEngine.WebCamFlags: System.Enum
---@source UnityEngine.AudioModule.dll
---@field FrontFacing UnityEngine.WebCamFlags
---@source UnityEngine.AudioModule.dll
---@field AutoFocusPointSupported UnityEngine.WebCamFlags
---@source UnityEngine.AudioModule.dll
CS.UnityEngine.WebCamFlags = {}

---@source 
---@param value any
---@return UnityEngine.WebCamFlags
function CS.UnityEngine.WebCamFlags:__CastFrom(value) end


--
--Enum representing the different types of web camera device.
--
---@source UnityEngine.AudioModule.dll
---@class UnityEngine.WebCamKind: System.Enum
--
--Wide angle (default) camera.
--
---@source UnityEngine.AudioModule.dll
---@field WideAngle UnityEngine.WebCamKind
--
--A Telephoto camera device. These devices have a longer focal length than a wide-angle camera.
--
---@source UnityEngine.AudioModule.dll
---@field Telephoto UnityEngine.WebCamKind
--
--Camera which supports synchronized color and depth data (currently these are only dual back and true depth cameras on latest iOS devices).
--
---@source UnityEngine.AudioModule.dll
---@field ColorAndDepth UnityEngine.WebCamKind
--
--Ultra wide angle camera. These devices have a shorter focal length than a wide-angle camera.
--
---@source UnityEngine.AudioModule.dll
---@field UltraWideAngle UnityEngine.WebCamKind
---@source UnityEngine.AudioModule.dll
CS.UnityEngine.WebCamKind = {}

---@source 
---@param value any
---@return UnityEngine.WebCamKind
function CS.UnityEngine.WebCamKind:__CastFrom(value) end


--
--A structure describing the webcam device.
--
---@source UnityEngine.AudioModule.dll
---@class UnityEngine.WebCamDevice: System.ValueType
--
--A human-readable name of the device. Varies across different systems.
--
---@source UnityEngine.AudioModule.dll
---@field name string
--
--True if camera faces the same direction a screen does, false otherwise.
--
---@source UnityEngine.AudioModule.dll
---@field isFrontFacing bool
--
--Property of type WebCamKind denoting the kind of webcam device.
--
---@source UnityEngine.AudioModule.dll
---@field kind UnityEngine.WebCamKind
--
--A string identifier used to create a depth data based WebCamTexture.
--
---@source UnityEngine.AudioModule.dll
---@field depthCameraName string
--
--Returns true if the camera supports automatic focusing on points of interest and false otherwise.
--
---@source UnityEngine.AudioModule.dll
---@field isAutoFocusPointSupported bool
--
--Possible WebCamTexture resolutions for this device.
--
---@source UnityEngine.AudioModule.dll
---@field availableResolutions UnityEngine.Resolution[]
---@source UnityEngine.AudioModule.dll
CS.UnityEngine.WebCamDevice = {}


--
--WebCam Textures are textures onto which the live video input is rendered.
--
---@source UnityEngine.AudioModule.dll
---@class UnityEngine.WebCamTexture: UnityEngine.Texture
--
--Return a list of available devices.
--
---@source UnityEngine.AudioModule.dll
---@field devices UnityEngine.WebCamDevice[]
--
--Returns if the camera is currently playing.
--
---@source UnityEngine.AudioModule.dll
---@field isPlaying bool
--
--Set this to specify the name of the device to use.
--
---@source UnityEngine.AudioModule.dll
---@field deviceName string
--
--Set the requested frame rate of the camera device (in frames per second).
--
---@source UnityEngine.AudioModule.dll
---@field requestedFPS float
--
--Set the requested width of the camera device.
--
---@source UnityEngine.AudioModule.dll
---@field requestedWidth int
--
--Set the requested height of the camera device.
--
---@source UnityEngine.AudioModule.dll
---@field requestedHeight int
--
--Returns an clockwise angle (in degrees), which can be used to rotate a polygon so camera contents are shown in correct orientation.
--
---@source UnityEngine.AudioModule.dll
---@field videoRotationAngle int
--
--Returns if the texture image is vertically flipped.
--
---@source UnityEngine.AudioModule.dll
---@field videoVerticallyMirrored bool
--
--Did the video buffer update this frame?
--
---@source UnityEngine.AudioModule.dll
---@field didUpdateThisFrame bool
--
--This property allows you to set/get the auto focus point of the camera. This works only on Android and iOS devices.
--
---@source UnityEngine.AudioModule.dll
---@field autoFocusPoint UnityEngine.Vector2?
--
--This property is true if the texture is based on depth data.
--
---@source UnityEngine.AudioModule.dll
---@field isDepth bool
---@source UnityEngine.AudioModule.dll
CS.UnityEngine.WebCamTexture = {}

--
--Starts the camera.
--
---@source UnityEngine.AudioModule.dll
function CS.UnityEngine.WebCamTexture.Play() end

--
--Pauses the camera.
--
---@source UnityEngine.AudioModule.dll
function CS.UnityEngine.WebCamTexture.Pause() end

--
--Stops the camera.
--
---@source UnityEngine.AudioModule.dll
function CS.UnityEngine.WebCamTexture.Stop() end

--
--Returns pixel color at coordinates (x, y).
--
---@source UnityEngine.AudioModule.dll
---@param x int
---@param y int
---@return Color
function CS.UnityEngine.WebCamTexture.GetPixel(x, y) end

--
--An array that contains a copy of the requested pixel colors, represented by Color structs.
--
---@source UnityEngine.AudioModule.dll
function CS.UnityEngine.WebCamTexture.GetPixels() end

--
--Get a block of pixel colors.
--
---@source UnityEngine.AudioModule.dll
---@param x int
---@param y int
---@param blockWidth int
---@param blockHeight int
function CS.UnityEngine.WebCamTexture.GetPixels(x, y, blockWidth, blockHeight) end

---@source UnityEngine.AudioModule.dll
function CS.UnityEngine.WebCamTexture.GetPixels32() end

--
--An array that contains a copy of the requested pixel colors, represented by Color32 structs.
--
--```plaintext
--Params: colors - Optional array to receive pixel data.
--        
--```
--
---@source UnityEngine.AudioModule.dll
---@param colors UnityEngine.Color32[]
function CS.UnityEngine.WebCamTexture.GetPixels32(colors) end


--
--Interface for reading and writing inputs in a Unity Cluster.
--
---@source UnityEngine.ClusterInputModule.dll
---@class UnityEngine.ClusterInput: object
---@source UnityEngine.ClusterInputModule.dll
CS.UnityEngine.ClusterInput = {}

--
--Returns the axis value as a continous float.
--
--```plaintext
--Params: name - Name of input to poll.c.
--        
--```
--
---@source UnityEngine.ClusterInputModule.dll
---@param name string
---@return Single
function CS.UnityEngine.ClusterInput:GetAxis(name) end

--
--Returns the binary value of a button.
--
--```plaintext
--Params: name - Name of input to poll.
--        
--```
--
---@source UnityEngine.ClusterInputModule.dll
---@param name string
---@return Boolean
function CS.UnityEngine.ClusterInput:GetButton(name) end

--
--Return the position of a tracker as a Vector3.
--
--```plaintext
--Params: name - Name of input to poll.
--        
--```
--
---@source UnityEngine.ClusterInputModule.dll
---@param name string
---@return Vector3
function CS.UnityEngine.ClusterInput:GetTrackerPosition(name) end

--
--Returns the rotation of a tracker as a Quaternion.
--
--```plaintext
--Params: name - Name of input to poll.
--        
--```
--
---@source UnityEngine.ClusterInputModule.dll
---@param name string
---@return Quaternion
function CS.UnityEngine.ClusterInput:GetTrackerRotation(name) end

--
--Sets the axis value for this input. Only works for input typed Custom.
--
--```plaintext
--Params: name - Name of input to modify.
--        value - Value to set.
--        
--```
--
---@source UnityEngine.ClusterInputModule.dll
---@param name string
---@param value float
function CS.UnityEngine.ClusterInput:SetAxis(name, value) end

--
--Sets the button value for this input. Only works for input typed Custom.
--
--```plaintext
--Params: name - Name of input to modify.
--        value - Value to set.
--        
--```
--
---@source UnityEngine.ClusterInputModule.dll
---@param name string
---@param value bool
function CS.UnityEngine.ClusterInput:SetButton(name, value) end

--
--Sets the tracker position for this input. Only works for input typed Custom.
--
--```plaintext
--Params: name - Name of input to modify.
--        value - Value to set.
--        
--```
--
---@source UnityEngine.ClusterInputModule.dll
---@param name string
---@param value UnityEngine.Vector3
function CS.UnityEngine.ClusterInput:SetTrackerPosition(name, value) end

--
--Sets the tracker rotation for this input. Only works for input typed Custom.
--
--```plaintext
--Params: name - Name of input to modify.
--        value - Value to set.
--        
--```
--
---@source UnityEngine.ClusterInputModule.dll
---@param name string
---@param value UnityEngine.Quaternion
function CS.UnityEngine.ClusterInput:SetTrackerRotation(name, value) end

--
--True if the operation succeed.
--
--```plaintext
--Params: name - Name of the input entry. This has to be unique.
--        deviceName - Device name registered to VRPN server.
--        serverUrl - URL to the vrpn server.
--        index - Index of the Input entry, refer to vrpn.cfg if unsure.
--        type - Type of the input.
--        
--```
--
---@source UnityEngine.ClusterInputModule.dll
---@param name string
---@param deviceName string
---@param serverUrl string
---@param index int
---@param type UnityEngine.ClusterInputType
---@return Boolean
function CS.UnityEngine.ClusterInput:AddInput(name, deviceName, serverUrl, index, type) end

--
--Edit an input entry which added via ClusterInput.AddInput.
--
--```plaintext
--Params: name - Name of the input entry. This has to be unique.
--        deviceName - Device name registered to VRPN server.
--        serverUrl - URL to the vrpn server.
--        index - Index of the Input entry, refer to vrpn.cfg if unsure.
--        type - Type of the ClusterInputType as follow.
--        
--```
--
---@source UnityEngine.ClusterInputModule.dll
---@param name string
---@param deviceName string
---@param serverUrl string
---@param index int
---@param type UnityEngine.ClusterInputType
---@return Boolean
function CS.UnityEngine.ClusterInput:EditInput(name, deviceName, serverUrl, index, type) end

--
--Check the connection status of the device to the VRPN server it connected to.
--
--```plaintext
--Params: name - Name of the input entry.
--        
--```
--
---@source UnityEngine.ClusterInputModule.dll
---@param name string
---@return Boolean
function CS.UnityEngine.ClusterInput:CheckConnectionToServer(name) end


--
--A helper class that contains static method to inquire status of Unity Cluster.
--
---@source UnityEngine.ClusterRendererModule.dll
---@class UnityEngine.ClusterNetwork: object
--
--Check whether the current instance is a master node in the cluster network.
--
---@source UnityEngine.ClusterRendererModule.dll
---@field isMasterOfCluster bool
--
--Check whether the current instance is disconnected from the cluster network.
--
---@source UnityEngine.ClusterRendererModule.dll
---@field isDisconnected bool
--
--To acquire or set the node index of the current machine from the cluster network.
--
---@source UnityEngine.ClusterRendererModule.dll
---@field nodeIndex int
---@source UnityEngine.ClusterRendererModule.dll
CS.UnityEngine.ClusterNetwork = {}


---@source UnityEngine.ClusterRendererModule.dll
---@class UnityEngine.ClusterSerialization: object
---@source UnityEngine.ClusterRendererModule.dll
CS.UnityEngine.ClusterSerialization = {}

---@source UnityEngine.ClusterRendererModule.dll
---@param buffer Unity.Collections.NativeArray<byte>
---@return Int32
function CS.UnityEngine.ClusterSerialization:SaveTimeManagerState(buffer) end

---@source UnityEngine.ClusterRendererModule.dll
---@param buffer Unity.Collections.NativeArray<byte>
---@return Boolean
function CS.UnityEngine.ClusterSerialization:RestoreTimeManagerState(buffer) end

---@source UnityEngine.ClusterRendererModule.dll
---@param buffer Unity.Collections.NativeArray<byte>
---@return Int32
function CS.UnityEngine.ClusterSerialization:SaveInputManagerState(buffer) end

---@source UnityEngine.ClusterRendererModule.dll
---@param buffer Unity.Collections.NativeArray<byte>
---@return Boolean
function CS.UnityEngine.ClusterSerialization:RestoreInputManagerState(buffer) end

---@source UnityEngine.ClusterRendererModule.dll
---@param buffer Unity.Collections.NativeArray<byte>
---@return Int32
function CS.UnityEngine.ClusterSerialization:SaveClusterInputState(buffer) end

---@source UnityEngine.ClusterRendererModule.dll
---@param buffer Unity.Collections.NativeArray<byte>
---@return Boolean
function CS.UnityEngine.ClusterSerialization:RestoreClusterInputState(buffer) end


--
--Options for how to send a message.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.SendMessageOptions: System.Enum
--
--A receiver is required for SendMessage.
--
---@source UnityEngine.CoreModule.dll
---@field RequireReceiver UnityEngine.SendMessageOptions
--
--No receiver is required for SendMessage.
--
---@source UnityEngine.CoreModule.dll
---@field DontRequireReceiver UnityEngine.SendMessageOptions
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.SendMessageOptions = {}

---@source 
---@param value any
---@return UnityEngine.SendMessageOptions
function CS.UnityEngine.SendMessageOptions:__CastFrom(value) end


--
--The various primitives that can be created using the GameObject.CreatePrimitive function.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.PrimitiveType: System.Enum
--
--A sphere primitive.
--
---@source UnityEngine.CoreModule.dll
---@field Sphere UnityEngine.PrimitiveType
--
--A capsule primitive.
--
---@source UnityEngine.CoreModule.dll
---@field Capsule UnityEngine.PrimitiveType
--
--A cylinder primitive.
--
---@source UnityEngine.CoreModule.dll
---@field Cylinder UnityEngine.PrimitiveType
--
--A cube primitive.
--
---@source UnityEngine.CoreModule.dll
---@field Cube UnityEngine.PrimitiveType
--
--A plane primitive.
--
---@source UnityEngine.CoreModule.dll
---@field Plane UnityEngine.PrimitiveType
--
--A quad primitive.
--
---@source UnityEngine.CoreModule.dll
---@field Quad UnityEngine.PrimitiveType
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.PrimitiveType = {}

---@source 
---@param value any
---@return UnityEngine.PrimitiveType
function CS.UnityEngine.PrimitiveType:__CastFrom(value) end


--
--The coordinate space in which to operate.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.Space: System.Enum
--
--Applies transformation relative to the world coordinate system.
--
---@source UnityEngine.CoreModule.dll
---@field World UnityEngine.Space
--
--Applies transformation relative to the local coordinate system.
--
---@source UnityEngine.CoreModule.dll
---@field Self UnityEngine.Space
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.Space = {}

---@source 
---@param value any
---@return UnityEngine.Space
function CS.UnityEngine.Space:__CastFrom(value) end


--
--The platform application is running. Returned by Application.platform.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.RuntimePlatform: System.Enum
--
--In the Unity editor on macOS.
--
---@source UnityEngine.CoreModule.dll
---@field OSXEditor UnityEngine.RuntimePlatform
--
--In the player on macOS.
--
---@source UnityEngine.CoreModule.dll
---@field OSXPlayer UnityEngine.RuntimePlatform
--
--In the player on Windows.
--
---@source UnityEngine.CoreModule.dll
---@field WindowsPlayer UnityEngine.RuntimePlatform
--
--In the web player on macOS.
--
---@source UnityEngine.CoreModule.dll
---@field OSXWebPlayer UnityEngine.RuntimePlatform
--
--In the Dashboard widget on macOS.
--
---@source UnityEngine.CoreModule.dll
---@field OSXDashboardPlayer UnityEngine.RuntimePlatform
--
--In the web player on Windows.
--
---@source UnityEngine.CoreModule.dll
---@field WindowsWebPlayer UnityEngine.RuntimePlatform
--
--In the Unity editor on Windows.
--
---@source UnityEngine.CoreModule.dll
---@field WindowsEditor UnityEngine.RuntimePlatform
--
--In the player on the iPhone.
--
---@source UnityEngine.CoreModule.dll
---@field IPhonePlayer UnityEngine.RuntimePlatform
---@source UnityEngine.CoreModule.dll
---@field XBOX360 UnityEngine.RuntimePlatform
---@source UnityEngine.CoreModule.dll
---@field PS3 UnityEngine.RuntimePlatform
--
--In the player on Android devices.
--
---@source UnityEngine.CoreModule.dll
---@field Android UnityEngine.RuntimePlatform
---@source UnityEngine.CoreModule.dll
---@field NaCl UnityEngine.RuntimePlatform
---@source UnityEngine.CoreModule.dll
---@field FlashPlayer UnityEngine.RuntimePlatform
--
--In the player on Linux.
--
---@source UnityEngine.CoreModule.dll
---@field LinuxPlayer UnityEngine.RuntimePlatform
--
--In the Unity editor on Linux.
--
---@source UnityEngine.CoreModule.dll
---@field LinuxEditor UnityEngine.RuntimePlatform
--
--In the player on WebGL
--
---@source UnityEngine.CoreModule.dll
---@field WebGLPlayer UnityEngine.RuntimePlatform
---@source UnityEngine.CoreModule.dll
---@field MetroPlayerX86 UnityEngine.RuntimePlatform
--
--In the player on Windows Store Apps when CPU architecture is X86.
--
---@source UnityEngine.CoreModule.dll
---@field WSAPlayerX86 UnityEngine.RuntimePlatform
---@source UnityEngine.CoreModule.dll
---@field MetroPlayerX64 UnityEngine.RuntimePlatform
--
--In the player on Windows Store Apps when CPU architecture is X64.
--
---@source UnityEngine.CoreModule.dll
---@field WSAPlayerX64 UnityEngine.RuntimePlatform
---@source UnityEngine.CoreModule.dll
---@field MetroPlayerARM UnityEngine.RuntimePlatform
--
--In the player on Windows Store Apps when CPU architecture is ARM.
--
---@source UnityEngine.CoreModule.dll
---@field WSAPlayerARM UnityEngine.RuntimePlatform
---@source UnityEngine.CoreModule.dll
---@field WP8Player UnityEngine.RuntimePlatform
---@source UnityEngine.CoreModule.dll
---@field BB10Player UnityEngine.RuntimePlatform
---@source UnityEngine.CoreModule.dll
---@field BlackBerryPlayer UnityEngine.RuntimePlatform
---@source UnityEngine.CoreModule.dll
---@field TizenPlayer UnityEngine.RuntimePlatform
---@source UnityEngine.CoreModule.dll
---@field PSP2 UnityEngine.RuntimePlatform
--
--In the player on the Playstation 4.
--
---@source UnityEngine.CoreModule.dll
---@field PS4 UnityEngine.RuntimePlatform
---@source UnityEngine.CoreModule.dll
---@field PSM UnityEngine.RuntimePlatform
--
--In the player on Xbox One.
--
---@source UnityEngine.CoreModule.dll
---@field XboxOne UnityEngine.RuntimePlatform
---@source UnityEngine.CoreModule.dll
---@field SamsungTVPlayer UnityEngine.RuntimePlatform
---@source UnityEngine.CoreModule.dll
---@field WiiU UnityEngine.RuntimePlatform
--
--In the player on the Apple's tvOS.
--
---@source UnityEngine.CoreModule.dll
---@field tvOS UnityEngine.RuntimePlatform
--
--In the player on Nintendo Switch.
--
---@source UnityEngine.CoreModule.dll
---@field Switch UnityEngine.RuntimePlatform
---@source UnityEngine.CoreModule.dll
---@field Lumin UnityEngine.RuntimePlatform
--
--In the player on Stadia.
--
---@source UnityEngine.CoreModule.dll
---@field Stadia UnityEngine.RuntimePlatform
--
--In the player on CloudRendering.
--
---@source UnityEngine.CoreModule.dll
---@field CloudRendering UnityEngine.RuntimePlatform
---@source UnityEngine.CoreModule.dll
---@field GameCoreScarlett UnityEngine.RuntimePlatform
---@source UnityEngine.CoreModule.dll
---@field GameCoreXboxSeries UnityEngine.RuntimePlatform
---@source UnityEngine.CoreModule.dll
---@field GameCoreXboxOne UnityEngine.RuntimePlatform
--
--In the player on the Playstation 5.
--
---@source UnityEngine.CoreModule.dll
---@field PS5 UnityEngine.RuntimePlatform
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.RuntimePlatform = {}

---@source 
---@param value any
---@return UnityEngine.RuntimePlatform
function CS.UnityEngine.RuntimePlatform:__CastFrom(value) end


--
--The language the user's operating system is running in. Returned by Application.systemLanguage.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.SystemLanguage: System.Enum
--
--Afrikaans.
--
---@source UnityEngine.CoreModule.dll
---@field Afrikaans UnityEngine.SystemLanguage
--
--Arabic.
--
---@source UnityEngine.CoreModule.dll
---@field Arabic UnityEngine.SystemLanguage
--
--Basque.
--
---@source UnityEngine.CoreModule.dll
---@field Basque UnityEngine.SystemLanguage
--
--Belarusian.
--
---@source UnityEngine.CoreModule.dll
---@field Belarusian UnityEngine.SystemLanguage
--
--Bulgarian.
--
---@source UnityEngine.CoreModule.dll
---@field Bulgarian UnityEngine.SystemLanguage
--
--Catalan.
--
---@source UnityEngine.CoreModule.dll
---@field Catalan UnityEngine.SystemLanguage
--
--Chinese.
--
---@source UnityEngine.CoreModule.dll
---@field Chinese UnityEngine.SystemLanguage
--
--Czech.
--
---@source UnityEngine.CoreModule.dll
---@field Czech UnityEngine.SystemLanguage
--
--Danish.
--
---@source UnityEngine.CoreModule.dll
---@field Danish UnityEngine.SystemLanguage
--
--Dutch.
--
---@source UnityEngine.CoreModule.dll
---@field Dutch UnityEngine.SystemLanguage
--
--English.
--
---@source UnityEngine.CoreModule.dll
---@field English UnityEngine.SystemLanguage
--
--Estonian.
--
---@source UnityEngine.CoreModule.dll
---@field Estonian UnityEngine.SystemLanguage
--
--Faroese.
--
---@source UnityEngine.CoreModule.dll
---@field Faroese UnityEngine.SystemLanguage
--
--Finnish.
--
---@source UnityEngine.CoreModule.dll
---@field Finnish UnityEngine.SystemLanguage
--
--French.
--
---@source UnityEngine.CoreModule.dll
---@field French UnityEngine.SystemLanguage
--
--German.
--
---@source UnityEngine.CoreModule.dll
---@field German UnityEngine.SystemLanguage
--
--Greek.
--
---@source UnityEngine.CoreModule.dll
---@field Greek UnityEngine.SystemLanguage
--
--Hebrew.
--
---@source UnityEngine.CoreModule.dll
---@field Hebrew UnityEngine.SystemLanguage
---@source UnityEngine.CoreModule.dll
---@field Hugarian UnityEngine.SystemLanguage
--
--Icelandic.
--
---@source UnityEngine.CoreModule.dll
---@field Icelandic UnityEngine.SystemLanguage
--
--Indonesian.
--
---@source UnityEngine.CoreModule.dll
---@field Indonesian UnityEngine.SystemLanguage
--
--Italian.
--
---@source UnityEngine.CoreModule.dll
---@field Italian UnityEngine.SystemLanguage
--
--Japanese.
--
---@source UnityEngine.CoreModule.dll
---@field Japanese UnityEngine.SystemLanguage
--
--Korean.
--
---@source UnityEngine.CoreModule.dll
---@field Korean UnityEngine.SystemLanguage
--
--Latvian.
--
---@source UnityEngine.CoreModule.dll
---@field Latvian UnityEngine.SystemLanguage
--
--Lithuanian.
--
---@source UnityEngine.CoreModule.dll
---@field Lithuanian UnityEngine.SystemLanguage
--
--Norwegian.
--
---@source UnityEngine.CoreModule.dll
---@field Norwegian UnityEngine.SystemLanguage
--
--Polish.
--
---@source UnityEngine.CoreModule.dll
---@field Polish UnityEngine.SystemLanguage
--
--Portuguese.
--
---@source UnityEngine.CoreModule.dll
---@field Portuguese UnityEngine.SystemLanguage
--
--Romanian.
--
---@source UnityEngine.CoreModule.dll
---@field Romanian UnityEngine.SystemLanguage
--
--Russian.
--
---@source UnityEngine.CoreModule.dll
---@field Russian UnityEngine.SystemLanguage
--
--Serbo-Croatian.
--
---@source UnityEngine.CoreModule.dll
---@field SerboCroatian UnityEngine.SystemLanguage
--
--Slovak.
--
---@source UnityEngine.CoreModule.dll
---@field Slovak UnityEngine.SystemLanguage
--
--Slovenian.
--
---@source UnityEngine.CoreModule.dll
---@field Slovenian UnityEngine.SystemLanguage
--
--Spanish.
--
---@source UnityEngine.CoreModule.dll
---@field Spanish UnityEngine.SystemLanguage
--
--Swedish.
--
---@source UnityEngine.CoreModule.dll
---@field Swedish UnityEngine.SystemLanguage
--
--Thai.
--
---@source UnityEngine.CoreModule.dll
---@field Thai UnityEngine.SystemLanguage
--
--Turkish.
--
---@source UnityEngine.CoreModule.dll
---@field Turkish UnityEngine.SystemLanguage
--
--Ukrainian.
--
---@source UnityEngine.CoreModule.dll
---@field Ukrainian UnityEngine.SystemLanguage
--
--Vietnamese.
--
---@source UnityEngine.CoreModule.dll
---@field Vietnamese UnityEngine.SystemLanguage
--
--ChineseSimplified.
--
---@source UnityEngine.CoreModule.dll
---@field ChineseSimplified UnityEngine.SystemLanguage
--
--ChineseTraditional.
--
---@source UnityEngine.CoreModule.dll
---@field ChineseTraditional UnityEngine.SystemLanguage
--
--Unknown.
--
---@source UnityEngine.CoreModule.dll
---@field Unknown UnityEngine.SystemLanguage
--
--Hungarian.
--
---@source UnityEngine.CoreModule.dll
---@field Hungarian UnityEngine.SystemLanguage
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.SystemLanguage = {}

---@source 
---@param value any
---@return UnityEngine.SystemLanguage
function CS.UnityEngine.SystemLanguage:__CastFrom(value) end


--
--The type of the log message in Debug.unityLogger.Log or delegate registered with Application.RegisterLogCallback.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.LogType: System.Enum
--
--LogType used for Errors.
--
---@source UnityEngine.CoreModule.dll
---@field Error UnityEngine.LogType
--
--LogType used for Asserts. (These could also indicate an error inside Unity itself.)
--
---@source UnityEngine.CoreModule.dll
---@field Assert UnityEngine.LogType
--
--LogType used for Warnings.
--
---@source UnityEngine.CoreModule.dll
---@field Warning UnityEngine.LogType
--
--LogType used for regular log messages.
--
---@source UnityEngine.CoreModule.dll
---@field Log UnityEngine.LogType
--
--LogType used for Exceptions.
--
---@source UnityEngine.CoreModule.dll
---@field Exception UnityEngine.LogType
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.LogType = {}

---@source 
---@param value any
---@return UnityEngine.LogType
function CS.UnityEngine.LogType:__CastFrom(value) end


--
--Option flags for specifying special treatment of a log message.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.LogOption: System.Enum
--
--Normal log message.
--
---@source UnityEngine.CoreModule.dll
---@field None UnityEngine.LogOption
--
--The log message will not have a stacktrace appended automatically.
--
---@source UnityEngine.CoreModule.dll
---@field NoStacktrace UnityEngine.LogOption
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.LogOption = {}

---@source 
---@param value any
---@return UnityEngine.LogOption
function CS.UnityEngine.LogOption:__CastFrom(value) end


--
--Priority of a thread.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.ThreadPriority: System.Enum
--
--Lowest thread priority.
--
---@source UnityEngine.CoreModule.dll
---@field Low UnityEngine.ThreadPriority
--
--Below normal thread priority.
--
---@source UnityEngine.CoreModule.dll
---@field BelowNormal UnityEngine.ThreadPriority
--
--Normal thread priority.
--
---@source UnityEngine.CoreModule.dll
---@field Normal UnityEngine.ThreadPriority
--
--Highest thread priority.
--
---@source UnityEngine.CoreModule.dll
---@field High UnityEngine.ThreadPriority
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.ThreadPriority = {}

---@source 
---@param value any
---@return UnityEngine.ThreadPriority
function CS.UnityEngine.ThreadPriority:__CastFrom(value) end


--
--SortingLayer allows you to set the render order of multiple sprites easily. There is always a default SortingLayer named "Default" which all sprites are added to initially. Added more SortingLayers to easily control the order of rendering of groups of sprites. Layers can be ordered before or after the default layer.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.SortingLayer: System.ValueType
--
--This is the unique id assigned to the layer. It is not an ordered running value and it should not be used to compare with other layers to determine the sorting order.
--
---@source UnityEngine.CoreModule.dll
---@field id int
--
--Returns the name of the layer as defined in the TagManager.
--
---@source UnityEngine.CoreModule.dll
---@field name string
--
--This is the relative value that indicates the sort order of this layer relative to the other layers.
--
---@source UnityEngine.CoreModule.dll
---@field value int
--
--Returns all the layers defined in this project.
--
---@source UnityEngine.CoreModule.dll
---@field layers UnityEngine.SortingLayer[]
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.SortingLayer = {}

--
--The final sorting value of the layer relative to other layers.
--
--```plaintext
--Params: id - The unique value of the sorting layer as returned by any renderer's sortingLayerID property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param id int
---@return Int32
function CS.UnityEngine.SortingLayer:GetLayerValueFromID(id) end

--
--The final sorting value of the layer relative to other layers.
--
--```plaintext
--Params: name - The unique value of the sorting layer as returned by any renderer's sortingLayerID property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@return Int32
function CS.UnityEngine.SortingLayer:GetLayerValueFromName(name) end

--
--The unique id of the layer with name.
--
--```plaintext
--Params: name - The name of the layer.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@return Int32
function CS.UnityEngine.SortingLayer:NameToID(name) end

--
--The name of the layer with id or "<unknown layer>" for invalid id.
--
--```plaintext
--Params: id - The unique id of the layer.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param id int
---@return String
function CS.UnityEngine.SortingLayer:IDToName(id) end

--
--True if the id provided is valid and assigned to a layer.
--
--```plaintext
--Params: id - The unique id of a layer.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param id int
---@return Boolean
function CS.UnityEngine.SortingLayer:IsValid(id) end


--
--Sets which weights to use when calculating curve segments.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.WeightedMode: System.Enum
--
--Exclude both inWeight or outWeight when calculating curve segments.
--
---@source UnityEngine.CoreModule.dll
---@field None UnityEngine.WeightedMode
--
--Include inWeight when calculating the previous curve segment.
--
---@source UnityEngine.CoreModule.dll
---@field In UnityEngine.WeightedMode
--
--Include outWeight when calculating the next curve segment.
--
---@source UnityEngine.CoreModule.dll
---@field Out UnityEngine.WeightedMode
--
--Include inWeight and outWeight when calculating curve segments.
--
---@source UnityEngine.CoreModule.dll
---@field Both UnityEngine.WeightedMode
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.WeightedMode = {}

---@source 
---@param value any
---@return UnityEngine.WeightedMode
function CS.UnityEngine.WeightedMode:__CastFrom(value) end


--
--A single keyframe that can be injected into an animation curve.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.Keyframe: System.ValueType
--
--The time of the keyframe.
--
---@source UnityEngine.CoreModule.dll
---@field time float
--
--The value of the curve at keyframe.
--
---@source UnityEngine.CoreModule.dll
---@field value float
--
--Sets the incoming tangent for this key. The incoming tangent affects the slope of the curve from the previous key to this key.
--
---@source UnityEngine.CoreModule.dll
---@field inTangent float
--
--Sets the outgoing tangent for this key. The outgoing tangent affects the slope of the curve from this key to the next key.
--
---@source UnityEngine.CoreModule.dll
---@field outTangent float
--
--Sets the incoming weight for this key. The incoming weight affects the slope of the curve from the previous key to this key.
--
---@source UnityEngine.CoreModule.dll
---@field inWeight float
--
--Sets the outgoing weight for this key. The outgoing weight affects the slope of the curve from this key to the next key.
--
---@source UnityEngine.CoreModule.dll
---@field outWeight float
--
--Weighted mode for the keyframe.
--
---@source UnityEngine.CoreModule.dll
---@field weightedMode UnityEngine.WeightedMode
--
--TangentMode is deprecated.  Use AnimationUtility.SetKeyLeftTangentMode or AnimationUtility.SetKeyRightTangentMode instead.
--
---@source UnityEngine.CoreModule.dll
---@field tangentMode int
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.Keyframe = {}


--
--Determines how time is treated outside of the keyframed range of an AnimationClip or AnimationCurve.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.WrapMode: System.Enum
--
--When time reaches the end of the animation clip, the clip will automatically stop playing and time will be reset to beginning of the clip.
--
---@source UnityEngine.CoreModule.dll
---@field Once UnityEngine.WrapMode
--
--When time reaches the end of the animation clip, time will continue at the beginning.
--
---@source UnityEngine.CoreModule.dll
---@field Loop UnityEngine.WrapMode
--
--When time reaches the end of the animation clip, time will ping pong back between beginning and end.
--
---@source UnityEngine.CoreModule.dll
---@field PingPong UnityEngine.WrapMode
--
--Reads the default repeat mode set higher up.
--
---@source UnityEngine.CoreModule.dll
---@field Default UnityEngine.WrapMode
--
--Plays back the animation. When it reaches the end, it will keep playing the last frame and never stop playing.
--
---@source UnityEngine.CoreModule.dll
---@field ClampForever UnityEngine.WrapMode
---@source UnityEngine.CoreModule.dll
---@field Clamp UnityEngine.WrapMode
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.WrapMode = {}

---@source 
---@param value any
---@return UnityEngine.WrapMode
function CS.UnityEngine.WrapMode:__CastFrom(value) end


--
--Store a collection of Keyframes that can be evaluated over time.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.AnimationCurve: object
--
--All keys defined in the animation curve.
--
---@source UnityEngine.CoreModule.dll
---@field keys UnityEngine.Keyframe[]
---@source UnityEngine.CoreModule.dll
---@field this[] UnityEngine.Keyframe
--
--The number of keys in the curve. (Read Only)
--
---@source UnityEngine.CoreModule.dll
---@field length int
--
--The behaviour of the animation before the first keyframe.
--
---@source UnityEngine.CoreModule.dll
---@field preWrapMode UnityEngine.WrapMode
--
--The behaviour of the animation after the last keyframe.
--
---@source UnityEngine.CoreModule.dll
---@field postWrapMode UnityEngine.WrapMode
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.AnimationCurve = {}

--
--The value of the curve, at the point in time specified.
--
--```plaintext
--Params: time - The time within the curve you want to evaluate (the horizontal axis in the curve graph).
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param time float
---@return Single
function CS.UnityEngine.AnimationCurve.Evaluate(time) end

--
--The index of the added key, or -1 if the key could not be added.
--
--```plaintext
--Params: time - The time at which to add the key (horizontal axis in the curve graph).
--        value - The value for the key (vertical axis in the curve graph).
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param time float
---@param value float
---@return Int32
function CS.UnityEngine.AnimationCurve.AddKey(time, value) end

--
--The index of the added key, or -1 if the key could not be added.
--
--```plaintext
--Params: key - The key to add to the curve.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param key UnityEngine.Keyframe
---@return Int32
function CS.UnityEngine.AnimationCurve.AddKey(key) end

--
--The index of the keyframe after moving it.
--
--```plaintext
--Params: index - The index of the key to move.
--        key - The key (with its new time) to insert.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param index int
---@param key UnityEngine.Keyframe
---@return Int32
function CS.UnityEngine.AnimationCurve.MoveKey(index, key) end

--
--Removes a key.
--
--```plaintext
--Params: index - The index of the key to remove.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param index int
function CS.UnityEngine.AnimationCurve.RemoveKey(index) end

--
--Smooth the in and out tangents of the keyframe at index.
--
--```plaintext
--Params: index - The index of the keyframe to be smoothed.
--        weight - The smoothing weight to apply to the keyframe's tangents.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param index int
---@param weight float
function CS.UnityEngine.AnimationCurve.SmoothTangents(index, weight) end

--
--The constant curve created from the specified values.
--
--```plaintext
--Params: timeStart - The start time for the constant curve.
--        timeEnd - The start time for the constant curve.
--        value - The value for the constant curve.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param timeStart float
---@param timeEnd float
---@param value float
---@return AnimationCurve
function CS.UnityEngine.AnimationCurve:Constant(timeStart, timeEnd, value) end

--
--The linear curve created from the specified values.
--
--```plaintext
--Params: timeStart - The start time for the linear curve.
--        valueStart - The start value for the linear curve.
--        timeEnd - The end time for the linear curve.
--        valueEnd - The end value for the linear curve.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param timeStart float
---@param valueStart float
---@param timeEnd float
---@param valueEnd float
---@return AnimationCurve
function CS.UnityEngine.AnimationCurve:Linear(timeStart, valueStart, timeEnd, valueEnd) end

--
--The ease-in and out curve generated from the specified values.
--
--```plaintext
--Params: timeStart - The start time for the ease curve.
--        valueStart - The start value for the ease curve.
--        timeEnd - The end time for the ease curve.
--        valueEnd - The end value for the ease curve.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param timeStart float
---@param valueStart float
---@param timeEnd float
---@param valueEnd float
---@return AnimationCurve
function CS.UnityEngine.AnimationCurve:EaseInOut(timeStart, valueStart, timeEnd, valueEnd) end

---@source UnityEngine.CoreModule.dll
---@param o object
---@return Boolean
function CS.UnityEngine.AnimationCurve.Equals(o) end

---@source UnityEngine.CoreModule.dll
---@param other UnityEngine.AnimationCurve
---@return Boolean
function CS.UnityEngine.AnimationCurve.Equals(other) end

---@source UnityEngine.CoreModule.dll
---@return Int32
function CS.UnityEngine.AnimationCurve.GetHashCode() end


--
--Access to application run-time data.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.Application: object
--
--Is some level being loaded? (Read Only) (Obsolete).
--
---@source UnityEngine.CoreModule.dll
---@field isLoadingLevel bool
--
--How many bytes have we downloaded from the main unity web stream (Read Only).
--
---@source UnityEngine.CoreModule.dll
---@field streamedBytes int
--
--Indicates whether Unity's webplayer security model is enabled.
--
---@source UnityEngine.CoreModule.dll
---@field webSecurityEnabled bool
--
--Returns true when called in any kind of built Player, or when called in the Editor in Play Mode (Read Only).
--
---@source UnityEngine.CoreModule.dll
---@field isPlaying bool
--
--Whether the player currently has focus. Read-only.
--
---@source UnityEngine.CoreModule.dll
---@field isFocused bool
--
--Returns a GUID for this build (Read Only).
--
---@source UnityEngine.CoreModule.dll
---@field buildGUID string
--
--Should the player be running when the application is in the background?
--
---@source UnityEngine.CoreModule.dll
---@field runInBackground bool
--
--Returns true when Unity is launched with the -batchmode flag from the command line (Read Only).
--
---@source UnityEngine.CoreModule.dll
---@field isBatchMode bool
--
--Contains the path to the game data folder on the target device (Read Only).
--
---@source UnityEngine.CoreModule.dll
---@field dataPath string
--
--The path to the StreamingAssets folder (Read Only).
--
---@source UnityEngine.CoreModule.dll
---@field streamingAssetsPath string
--
--(Read Only) Contains the path to a persistent data directory.
--
---@source UnityEngine.CoreModule.dll
---@field persistentDataPath string
--
--Contains the path to a temporary data / cache directory (Read Only).
--
---@source UnityEngine.CoreModule.dll
---@field temporaryCachePath string
--
--The URL of the document. For WebGL, this a web URL. For Android, iOS, or Universal Windows Platform (UWP) this is a deep link URL. (Read Only)
--
---@source UnityEngine.CoreModule.dll
---@field absoluteURL string
--
--The version of the Unity runtime used to play the content.
--
---@source UnityEngine.CoreModule.dll
---@field unityVersion string
--
--Returns application version number  (Read Only).
--
---@source UnityEngine.CoreModule.dll
---@field version string
--
--Returns the name of the store or package that installed the application (Read Only).
--
---@source UnityEngine.CoreModule.dll
---@field installerName string
--
--Returns application identifier at runtime. On Apple platforms this is the 'bundleIdentifier' saved in the info.plist file, on Android it's the 'package' from the AndroidManifest.xml.
--
---@source UnityEngine.CoreModule.dll
---@field identifier string
--
--Returns application install mode (Read Only).
--
---@source UnityEngine.CoreModule.dll
---@field installMode UnityEngine.ApplicationInstallMode
--
--Returns application running in sandbox (Read Only).
--
---@source UnityEngine.CoreModule.dll
---@field sandboxType UnityEngine.ApplicationSandboxType
--
--Returns application product name (Read Only).
--
---@source UnityEngine.CoreModule.dll
---@field productName string
--
--Return application company name (Read Only).
--
---@source UnityEngine.CoreModule.dll
---@field companyName string
--
--A unique cloud project identifier. It is unique for every project (Read Only).
--
---@source UnityEngine.CoreModule.dll
---@field cloudProjectId string
--
--Instructs the game to try to render at a specified frame rate.
--
---@source UnityEngine.CoreModule.dll
---@field targetFrameRate int
--
--Obsolete. Use Application.SetStackTraceLogType.
--
---@source UnityEngine.CoreModule.dll
---@field stackTraceLogType UnityEngine.StackTraceLogType
--
--Returns the path to the console log file, or an empty string if the current platform does not support log files.
--
---@source UnityEngine.CoreModule.dll
---@field consoleLogPath string
--
--Priority of background loading thread.
--
---@source UnityEngine.CoreModule.dll
---@field backgroundLoadingPriority UnityEngine.ThreadPriority
--
--Returns false if application is altered in any way after it was built.
--
---@source UnityEngine.CoreModule.dll
---@field genuine bool
--
--Returns true if application integrity can be confirmed.
--
---@source UnityEngine.CoreModule.dll
---@field genuineCheckAvailable bool
--
--Checks whether splash screen is being shown.
--
---@source UnityEngine.CoreModule.dll
---@field isShowingSplashScreen bool
--
--Returns the platform the game is running on (Read Only).
--
---@source UnityEngine.CoreModule.dll
---@field platform UnityEngine.RuntimePlatform
--
--Is the current Runtime platform a known mobile platform.
--
---@source UnityEngine.CoreModule.dll
---@field isMobilePlatform bool
--
--Is the current Runtime platform a known console platform.
--
---@source UnityEngine.CoreModule.dll
---@field isConsolePlatform bool
--
--The language the user's operating system is running in.
--
---@source UnityEngine.CoreModule.dll
---@field systemLanguage UnityEngine.SystemLanguage
--
--Returns the type of Internet reachability currently possible on the device.
--
---@source UnityEngine.CoreModule.dll
---@field internetReachability UnityEngine.NetworkReachability
---@source UnityEngine.CoreModule.dll
---@field isPlayer bool
--
--The total number of levels available (Read Only).
--
---@source UnityEngine.CoreModule.dll
---@field levelCount int
--
--Note: This is now obsolete. Use SceneManager.GetActiveScene instead. (Read Only).
--
---@source UnityEngine.CoreModule.dll
---@field loadedLevel int
--
--The name of the level that was last loaded (Read Only).
--
---@source UnityEngine.CoreModule.dll
---@field loadedLevelName string
--
--Are we running inside the Unity editor? (Read Only)
--
---@source UnityEngine.CoreModule.dll
---@field isEditor bool
---@source UnityEngine.CoreModule.dll
---@field lowMemory UnityEngine.Application.LowMemoryCallback
---@source UnityEngine.CoreModule.dll
---@field logMessageReceived UnityEngine.Application.LogCallback
---@source UnityEngine.CoreModule.dll
---@field logMessageReceivedThreaded UnityEngine.Application.LogCallback
---@source UnityEngine.CoreModule.dll
---@field onBeforeRender UnityEngine.Events.UnityAction
---@source UnityEngine.CoreModule.dll
---@field focusChanged System.Action<bool>
---@source UnityEngine.CoreModule.dll
---@field deepLinkActivated System.Action<string>
---@source UnityEngine.CoreModule.dll
---@field wantsToQuit System.Func<bool>
---@source UnityEngine.CoreModule.dll
---@field quitting System.Action
---@source UnityEngine.CoreModule.dll
---@field unloading System.Action
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.Application = {}

---@source UnityEngine.CoreModule.dll
---@param exitCode int
function CS.UnityEngine.Application:Quit(exitCode) end

--
--Quits the player application.
--
--```plaintext
--Params: exitCode - An optional exit code to return when the player application terminates on Windows, Mac and Linux. Defaults to 0.
--        
--```
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.Application:Quit() end

--
--Cancels quitting the application. This is useful for showing a splash screen at the end of a game.
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.Application:CancelQuit() end

--
--Unloads the Unity Player.
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.Application:Unload() end

--
--How far has the download progressed? [0...1].
--
---@source UnityEngine.CoreModule.dll
---@param levelIndex int
---@return Single
function CS.UnityEngine.Application:GetStreamProgressForLevel(levelIndex) end

--
--How far has the download progressed? [0...1].
--
---@source UnityEngine.CoreModule.dll
---@param levelName string
---@return Single
function CS.UnityEngine.Application:GetStreamProgressForLevel(levelName) end

--
--Can the streamed level be loaded?
--
---@source UnityEngine.CoreModule.dll
---@param levelIndex int
---@return Boolean
function CS.UnityEngine.Application:CanStreamedLevelBeLoaded(levelIndex) end

--
--Can the streamed level be loaded?
--
---@source UnityEngine.CoreModule.dll
---@param levelName string
---@return Boolean
function CS.UnityEngine.Application:CanStreamedLevelBeLoaded(levelName) end

--
--True if the object is part of the playing world.
--
--```plaintext
--Params: obj - The object to test.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param obj UnityEngine.Object
---@return Boolean
function CS.UnityEngine.Application:IsPlaying(obj) end

--
--Returns an array of feature tags in use for this build.
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.Application:GetBuildTags() end

--
--Set an array of feature tags for this build.
--
---@source UnityEngine.CoreModule.dll
---@param buildTags string[]
function CS.UnityEngine.Application:SetBuildTags(buildTags) end

--
--Is Unity activated with the Pro license?
--
---@source UnityEngine.CoreModule.dll
---@return Boolean
function CS.UnityEngine.Application:HasProLicense() end

--
--Execution of a script function in the contained web page.
--
--```plaintext
--Params: script - The Javascript function to call.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param script string
function CS.UnityEngine.Application:ExternalEval(script) end

---@source UnityEngine.CoreModule.dll
---@param delegateMethod UnityEngine.Application.AdvertisingIdentifierCallback
---@return Boolean
function CS.UnityEngine.Application:RequestAdvertisingIdentifierAsync(delegateMethod) end

--
--Opens the URL specified, subject to the permissions and limitations of your app’s current platform and environment. This is handled in different ways depending on the nature of the URL, and with different security restrictions, depending on the runtime platform.
--
--```plaintext
--Params: url - The URL to open.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param url string
function CS.UnityEngine.Application:OpenURL(url) end

---@source UnityEngine.CoreModule.dll
---@param mode int
function CS.UnityEngine.Application:ForceCrash(mode) end

--
--Get stack trace logging options. The default value is StackTraceLogType.ScriptOnly.
--
---@source UnityEngine.CoreModule.dll
---@param logType UnityEngine.LogType
---@return StackTraceLogType
function CS.UnityEngine.Application:GetStackTraceLogType(logType) end

--
--Set stack trace logging options. The default value is StackTraceLogType.ScriptOnly.
--
---@source UnityEngine.CoreModule.dll
---@param logType UnityEngine.LogType
---@param stackTraceType UnityEngine.StackTraceLogType
function CS.UnityEngine.Application:SetStackTraceLogType(logType, stackTraceType) end

--
--Request authorization to use the webcam or microphone on iOS.
--
---@source UnityEngine.CoreModule.dll
---@param mode UnityEngine.UserAuthorization
---@return AsyncOperation
function CS.UnityEngine.Application:RequestUserAuthorization(mode) end

--
--Check if the user has authorized use of the webcam or microphone in the Web Player.
--
---@source UnityEngine.CoreModule.dll
---@param mode UnityEngine.UserAuthorization
---@return Boolean
function CS.UnityEngine.Application:HasUserAuthorization(mode) end

---@source UnityEngine.CoreModule.dll
---@param value UnityEngine.Application.LowMemoryCallback
function CS.UnityEngine.Application:add_lowMemory(value) end

---@source UnityEngine.CoreModule.dll
---@param value UnityEngine.Application.LowMemoryCallback
function CS.UnityEngine.Application:remove_lowMemory(value) end

---@source UnityEngine.CoreModule.dll
---@param value UnityEngine.Application.LogCallback
function CS.UnityEngine.Application:add_logMessageReceived(value) end

---@source UnityEngine.CoreModule.dll
---@param value UnityEngine.Application.LogCallback
function CS.UnityEngine.Application:remove_logMessageReceived(value) end

---@source UnityEngine.CoreModule.dll
---@param value UnityEngine.Application.LogCallback
function CS.UnityEngine.Application:add_logMessageReceivedThreaded(value) end

---@source UnityEngine.CoreModule.dll
---@param value UnityEngine.Application.LogCallback
function CS.UnityEngine.Application:remove_logMessageReceivedThreaded(value) end

--
--Calls a function in the web page that contains the WebGL Player.
--
--```plaintext
--Params: functionName - Name of the function to call.
--        args - Array of arguments passed in the call.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param functionName string
---@param args object[]
function CS.UnityEngine.Application:ExternalCall(functionName, args) end

---@source UnityEngine.CoreModule.dll
---@param o UnityEngine.Object
function CS.UnityEngine.Application:DontDestroyOnLoad(o) end

--
--Captures a screenshot at path filename as a PNG file.
--
--```plaintext
--Params: filename - Pathname to save the screenshot file to.
--        superSize - Factor by which to increase resolution.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param filename string
---@param superSize int
function CS.UnityEngine.Application:CaptureScreenshot(filename, superSize) end

--
--Captures a screenshot at path filename as a PNG file.
--
--```plaintext
--Params: filename - Pathname to save the screenshot file to.
--        superSize - Factor by which to increase resolution.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param filename string
function CS.UnityEngine.Application:CaptureScreenshot(filename) end

---@source UnityEngine.CoreModule.dll
---@param value UnityEngine.Events.UnityAction
function CS.UnityEngine.Application:add_onBeforeRender(value) end

---@source UnityEngine.CoreModule.dll
---@param value UnityEngine.Events.UnityAction
function CS.UnityEngine.Application:remove_onBeforeRender(value) end

---@source UnityEngine.CoreModule.dll
---@param value System.Action<bool>
function CS.UnityEngine.Application:add_focusChanged(value) end

---@source UnityEngine.CoreModule.dll
---@param value System.Action<bool>
function CS.UnityEngine.Application:remove_focusChanged(value) end

---@source UnityEngine.CoreModule.dll
---@param value System.Action<string>
function CS.UnityEngine.Application:add_deepLinkActivated(value) end

---@source UnityEngine.CoreModule.dll
---@param value System.Action<string>
function CS.UnityEngine.Application:remove_deepLinkActivated(value) end

---@source UnityEngine.CoreModule.dll
---@param value System.Func<bool>
function CS.UnityEngine.Application:add_wantsToQuit(value) end

---@source UnityEngine.CoreModule.dll
---@param value System.Func<bool>
function CS.UnityEngine.Application:remove_wantsToQuit(value) end

---@source UnityEngine.CoreModule.dll
---@param value System.Action
function CS.UnityEngine.Application:add_quitting(value) end

---@source UnityEngine.CoreModule.dll
---@param value System.Action
function CS.UnityEngine.Application:remove_quitting(value) end

---@source UnityEngine.CoreModule.dll
---@param value System.Action
function CS.UnityEngine.Application:add_unloading(value) end

---@source UnityEngine.CoreModule.dll
---@param value System.Action
function CS.UnityEngine.Application:remove_unloading(value) end

---@source UnityEngine.CoreModule.dll
---@param handler UnityEngine.Application.LogCallback
function CS.UnityEngine.Application:RegisterLogCallback(handler) end

---@source UnityEngine.CoreModule.dll
---@param handler UnityEngine.Application.LogCallback
function CS.UnityEngine.Application:RegisterLogCallbackThreaded(handler) end

--
--Note: This is now obsolete. Use SceneManager.LoadScene instead.
--
--```plaintext
--Params: index - The level to load.
--        name - The name of the level to load.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param index int
function CS.UnityEngine.Application:LoadLevel(index) end

--
--Note: This is now obsolete. Use SceneManager.LoadScene instead.
--
--```plaintext
--Params: index - The level to load.
--        name - The name of the level to load.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
function CS.UnityEngine.Application:LoadLevel(name) end

--
--Loads a level additively.
--
---@source UnityEngine.CoreModule.dll
---@param index int
function CS.UnityEngine.Application:LoadLevelAdditive(index) end

--
--Loads a level additively.
--
---@source UnityEngine.CoreModule.dll
---@param name string
function CS.UnityEngine.Application:LoadLevelAdditive(name) end

--
--Loads the level asynchronously in the background.
--
---@source UnityEngine.CoreModule.dll
---@param index int
---@return AsyncOperation
function CS.UnityEngine.Application:LoadLevelAsync(index) end

--
--Loads the level asynchronously in the background.
--
---@source UnityEngine.CoreModule.dll
---@param levelName string
---@return AsyncOperation
function CS.UnityEngine.Application:LoadLevelAsync(levelName) end

--
--Loads the level additively and asynchronously in the background.
--
---@source UnityEngine.CoreModule.dll
---@param index int
---@return AsyncOperation
function CS.UnityEngine.Application:LoadLevelAdditiveAsync(index) end

--
--Loads the level additively and asynchronously in the background.
--
---@source UnityEngine.CoreModule.dll
---@param levelName string
---@return AsyncOperation
function CS.UnityEngine.Application:LoadLevelAdditiveAsync(levelName) end

--
--Return true if the Scene is unloaded.
--
--```plaintext
--Params: index - Index of the Scene in the PlayerSettings to unload.
--        scenePath - Name of the Scene to Unload.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param index int
---@return Boolean
function CS.UnityEngine.Application:UnloadLevel(index) end

--
--Return true if the Scene is unloaded.
--
--```plaintext
--Params: index - Index of the Scene in the PlayerSettings to unload.
--        scenePath - Name of the Scene to Unload.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param scenePath string
---@return Boolean
function CS.UnityEngine.Application:UnloadLevel(scenePath) end


--
--Delegate method for fetching advertising ID.
--
--```plaintext
--Params: advertisingId - Advertising ID.
--        trackingEnabled - Indicates whether user has chosen to limit ad tracking.
--        errorMsg - Error message.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.AdvertisingIdentifierCallback: System.MulticastDelegate
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.AdvertisingIdentifierCallback = {}

---@source UnityEngine.CoreModule.dll
---@param advertisingId string
---@param trackingEnabled bool
---@param errorMsg string
function CS.UnityEngine.AdvertisingIdentifierCallback.Invoke(advertisingId, trackingEnabled, errorMsg) end

---@source UnityEngine.CoreModule.dll
---@param advertisingId string
---@param trackingEnabled bool
---@param errorMsg string
---@param callback System.AsyncCallback
---@param object object
---@return IAsyncResult
function CS.UnityEngine.AdvertisingIdentifierCallback.BeginInvoke(advertisingId, trackingEnabled, errorMsg, callback, object) end

---@source UnityEngine.CoreModule.dll
---@param result System.IAsyncResult
function CS.UnityEngine.AdvertisingIdentifierCallback.EndInvoke(result) end


--
--This is the delegate function when a mobile device notifies of low memory.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.LowMemoryCallback: System.MulticastDelegate
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.LowMemoryCallback = {}

---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.LowMemoryCallback.Invoke() end

---@source UnityEngine.CoreModule.dll
---@param callback System.AsyncCallback
---@param object object
---@return IAsyncResult
function CS.UnityEngine.LowMemoryCallback.BeginInvoke(callback, object) end

---@source UnityEngine.CoreModule.dll
---@param result System.IAsyncResult
function CS.UnityEngine.LowMemoryCallback.EndInvoke(result) end


--
--Use this delegate type with Application.logMessageReceived or Application.logMessageReceivedThreaded to monitor what gets logged.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.LogCallback: System.MulticastDelegate
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.LogCallback = {}

---@source UnityEngine.CoreModule.dll
---@param condition string
---@param stackTrace string
---@param type UnityEngine.LogType
function CS.UnityEngine.LogCallback.Invoke(condition, stackTrace, type) end

---@source UnityEngine.CoreModule.dll
---@param condition string
---@param stackTrace string
---@param type UnityEngine.LogType
---@param callback System.AsyncCallback
---@param object object
---@return IAsyncResult
function CS.UnityEngine.LogCallback.BeginInvoke(condition, stackTrace, type, callback, object) end

---@source UnityEngine.CoreModule.dll
---@param result System.IAsyncResult
function CS.UnityEngine.LogCallback.EndInvoke(result) end


--
--Stack trace logging options.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.StackTraceLogType: System.Enum
--
--No stack trace will be outputed to log.
--
---@source UnityEngine.CoreModule.dll
---@field None UnityEngine.StackTraceLogType
--
--Only managed stack trace will be outputed.
--
---@source UnityEngine.CoreModule.dll
---@field ScriptOnly UnityEngine.StackTraceLogType
--
--Native and managed stack trace will be logged.
--
---@source UnityEngine.CoreModule.dll
---@field Full UnityEngine.StackTraceLogType
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.StackTraceLogType = {}

---@source 
---@param value any
---@return UnityEngine.StackTraceLogType
function CS.UnityEngine.StackTraceLogType:__CastFrom(value) end


--
--Describes network reachability options.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.NetworkReachability: System.Enum
--
--Network is not reachable.
--
---@source UnityEngine.CoreModule.dll
---@field NotReachable UnityEngine.NetworkReachability
--
--Network is reachable via carrier data network.
--
---@source UnityEngine.CoreModule.dll
---@field ReachableViaCarrierDataNetwork UnityEngine.NetworkReachability
--
--Network is reachable via WiFi or cable.
--
---@source UnityEngine.CoreModule.dll
---@field ReachableViaLocalAreaNetwork UnityEngine.NetworkReachability
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.NetworkReachability = {}

---@source 
---@param value any
---@return UnityEngine.NetworkReachability
function CS.UnityEngine.NetworkReachability:__CastFrom(value) end


--
--Constants to pass to Application.RequestUserAuthorization.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.UserAuthorization: System.Enum
--
--Request permission to use any video input sources attached to the computer.
--
---@source UnityEngine.CoreModule.dll
---@field WebCam UnityEngine.UserAuthorization
--
--Request permission to use any audio input sources attached to the computer.
--
---@source UnityEngine.CoreModule.dll
---@field Microphone UnityEngine.UserAuthorization
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.UserAuthorization = {}

---@source 
---@param value any
---@return UnityEngine.UserAuthorization
function CS.UnityEngine.UserAuthorization:__CastFrom(value) end


--
--Application installation mode (Read Only).
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.ApplicationInstallMode: System.Enum
--
--Application install mode unknown.
--
---@source UnityEngine.CoreModule.dll
---@field Unknown UnityEngine.ApplicationInstallMode
--
--Application installed via online store.
--
---@source UnityEngine.CoreModule.dll
---@field Store UnityEngine.ApplicationInstallMode
--
--Application installed via developer build.
--
---@source UnityEngine.CoreModule.dll
---@field DeveloperBuild UnityEngine.ApplicationInstallMode
--
--Application installed via ad hoc distribution.
--
---@source UnityEngine.CoreModule.dll
---@field Adhoc UnityEngine.ApplicationInstallMode
--
--Application installed via enterprise distribution.
--
---@source UnityEngine.CoreModule.dll
---@field Enterprise UnityEngine.ApplicationInstallMode
--
--Application running in editor.
--
---@source UnityEngine.CoreModule.dll
---@field Editor UnityEngine.ApplicationInstallMode
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.ApplicationInstallMode = {}

---@source 
---@param value any
---@return UnityEngine.ApplicationInstallMode
function CS.UnityEngine.ApplicationInstallMode:__CastFrom(value) end


--
--Application sandbox type.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.ApplicationSandboxType: System.Enum
--
--Application sandbox type is unknown.
--
---@source UnityEngine.CoreModule.dll
---@field Unknown UnityEngine.ApplicationSandboxType
--
--Application not running in a sandbox.
--
---@source UnityEngine.CoreModule.dll
---@field NotSandboxed UnityEngine.ApplicationSandboxType
--
--Application is running in a sandbox.
--
---@source UnityEngine.CoreModule.dll
---@field Sandboxed UnityEngine.ApplicationSandboxType
--
--Application is running in broken sandbox.
--
---@source UnityEngine.CoreModule.dll
---@field SandboxBroken UnityEngine.ApplicationSandboxType
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.ApplicationSandboxType = {}

---@source 
---@param value any
---@return UnityEngine.ApplicationSandboxType
function CS.UnityEngine.ApplicationSandboxType:__CastFrom(value) end


--
--Type of the imported(native) data.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.AudioType: System.Enum
--
--3rd party / unknown plugin format.
--
---@source UnityEngine.CoreModule.dll
---@field UNKNOWN UnityEngine.AudioType
--
--Acc - not supported.
--
---@source UnityEngine.CoreModule.dll
---@field ACC UnityEngine.AudioType
--
--Aiff.
--
---@source UnityEngine.CoreModule.dll
---@field AIFF UnityEngine.AudioType
--
--Impulse tracker.
--
---@source UnityEngine.CoreModule.dll
---@field IT UnityEngine.AudioType
--
--Protracker / Fasttracker MOD.
--
---@source UnityEngine.CoreModule.dll
---@field MOD UnityEngine.AudioType
--
--MP2/MP3 MPEG.
--
---@source UnityEngine.CoreModule.dll
---@field MPEG UnityEngine.AudioType
--
--Ogg vorbis.
--
---@source UnityEngine.CoreModule.dll
---@field OGGVORBIS UnityEngine.AudioType
--
--ScreamTracker 3.
--
---@source UnityEngine.CoreModule.dll
---@field S3M UnityEngine.AudioType
--
--Microsoft WAV.
--
---@source UnityEngine.CoreModule.dll
---@field WAV UnityEngine.AudioType
--
--FastTracker 2 XM.
--
---@source UnityEngine.CoreModule.dll
---@field XM UnityEngine.AudioType
--
--Xbox360 XMA.
--
---@source UnityEngine.CoreModule.dll
---@field XMA UnityEngine.AudioType
--
--VAG.
--
---@source UnityEngine.CoreModule.dll
---@field VAG UnityEngine.AudioType
--
--iPhone hardware decoder, supports AAC, ALAC and MP3. Extracodecdata is a pointer to an FMOD_AUDIOQUEUE_EXTRACODECDATA structure.
--
---@source UnityEngine.CoreModule.dll
---@field AUDIOQUEUE UnityEngine.AudioType
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.AudioType = {}

---@source 
---@param value any
---@return UnityEngine.AudioType
function CS.UnityEngine.AudioType:__CastFrom(value) end


--
--Data structure for downloading AssetBundles to a customized cache path. See Also:UnityWebRequestAssetBundle.GetAssetBundle for more information.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.CachedAssetBundle: System.ValueType
--
--AssetBundle name which is used as the customized cache path.
--
---@source UnityEngine.CoreModule.dll
---@field name string
--
--Hash128 which is used as the version of the AssetBundle.
--
---@source UnityEngine.CoreModule.dll
---@field hash UnityEngine.Hash128
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.CachedAssetBundle = {}


--
--Data structure for cache. Please refer to See Also:Caching.AddCache for more information.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.Cache: System.ValueType
--
--Returns true if the cache is valid.
--
---@source UnityEngine.CoreModule.dll
---@field valid bool
--
--Returns true if the cache is ready.
--
---@source UnityEngine.CoreModule.dll
---@field ready bool
--
--Returns true if the cache is readonly.
--
---@source UnityEngine.CoreModule.dll
---@field readOnly bool
--
--Returns the path of the cache.
--
---@source UnityEngine.CoreModule.dll
---@field path string
--
--Returns the index of the cache in the cache list.
--
---@source UnityEngine.CoreModule.dll
---@field index int
--
--Returns the number of currently unused bytes in the cache.
--
---@source UnityEngine.CoreModule.dll
---@field spaceFree long
--
--Allows you to specify the total number of bytes that can be allocated for the cache.
--
---@source UnityEngine.CoreModule.dll
---@field maximumAvailableStorageSpace long
--
--Returns the used disk space in bytes.
--
---@source UnityEngine.CoreModule.dll
---@field spaceOccupied long
--
--The number of seconds that an AssetBundle may remain unused in the cache before it is automatically deleted.
--
---@source UnityEngine.CoreModule.dll
---@field expirationDelay int
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.Cache = {}

---@source UnityEngine.CoreModule.dll
---@param lhs UnityEngine.Cache
---@param rhs UnityEngine.Cache
---@return Boolean
function CS.UnityEngine.Cache:op_Equality(lhs, rhs) end

---@source UnityEngine.CoreModule.dll
---@param lhs UnityEngine.Cache
---@param rhs UnityEngine.Cache
---@return Boolean
function CS.UnityEngine.Cache:op_Inequality(lhs, rhs) end

---@source UnityEngine.CoreModule.dll
---@return Int32
function CS.UnityEngine.Cache.GetHashCode() end

---@source UnityEngine.CoreModule.dll
---@param other object
---@return Boolean
function CS.UnityEngine.Cache.Equals(other) end

---@source UnityEngine.CoreModule.dll
---@param other UnityEngine.Cache
---@return Boolean
function CS.UnityEngine.Cache.Equals(other) end

--
--Returns True when cache clearing succeeded.
--
--```plaintext
--Params: expiration - The number of seconds that AssetBundles may remain unused in the cache.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@return Boolean
function CS.UnityEngine.Cache.ClearCache() end

--
--Returns True when cache clearing succeeded.
--
--```plaintext
--Params: expiration - The number of seconds that AssetBundles may remain unused in the cache.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param expiration int
---@return Boolean
function CS.UnityEngine.Cache.ClearCache(expiration) end


---@source UnityEngine.CoreModule.dll
---@class UnityEngine.CacheIndex: System.ValueType
---@source UnityEngine.CoreModule.dll
---@field name string
---@source UnityEngine.CoreModule.dll
---@field bytesUsed int
---@source UnityEngine.CoreModule.dll
---@field expires int
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.CacheIndex = {}


--
--The Caching class lets you manage cached AssetBundles, downloaded using UnityWebRequestAssetBundle.GetAssetBundle().
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.Caching: object
--
--Controls compression of cache data. Enabled by default.
--
---@source UnityEngine.CoreModule.dll
---@field compressionEnabled bool
--
--Returns true if Caching system is ready for use.
--
---@source UnityEngine.CoreModule.dll
---@field ready bool
---@source UnityEngine.CoreModule.dll
---@field spaceUsed int
---@source UnityEngine.CoreModule.dll
---@field spaceOccupied long
---@source UnityEngine.CoreModule.dll
---@field spaceAvailable int
---@source UnityEngine.CoreModule.dll
---@field spaceFree long
---@source UnityEngine.CoreModule.dll
---@field maximumAvailableDiskSpace long
---@source UnityEngine.CoreModule.dll
---@field expirationDelay int
--
--Returns the cache count in the cache list.
--
---@source UnityEngine.CoreModule.dll
---@field cacheCount int
--
--Returns the default cache which is added by Unity internally.
--
---@source UnityEngine.CoreModule.dll
---@field defaultCache UnityEngine.Cache
--
--Gets or sets the current cache in which AssetBundles should be cached.
--
---@source UnityEngine.CoreModule.dll
---@field currentCacheForWriting UnityEngine.Cache
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.Caching = {}

--
--True when cache clearing succeeded, false if cache was in use.
--
--```plaintext
--Params: expiration - The number of seconds that AssetBundles may remain unused in the cache.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@return Boolean
function CS.UnityEngine.Caching:ClearCache() end

--
--True when cache clearing succeeded, false if cache was in use.
--
--```plaintext
--Params: expiration - The number of seconds that AssetBundles may remain unused in the cache.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param expiration int
---@return Boolean
function CS.UnityEngine.Caching:ClearCache(expiration) end

--
--Returns true when cache clearing succeeded.  Can return false if any cached bundle is in use.
--
--```plaintext
--Params: assetBundleName - The AssetBundle name.
--        hash - Version needs to be cleaned.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param assetBundleName string
---@param hash UnityEngine.Hash128
---@return Boolean
function CS.UnityEngine.Caching:ClearCachedVersion(assetBundleName, hash) end

--
--Returns true when cache clearing succeeded.
--
--```plaintext
--Params: assetBundleName - The AssetBundle name.
--        hash - Version needs to be kept.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param assetBundleName string
---@param hash UnityEngine.Hash128
---@return Boolean
function CS.UnityEngine.Caching:ClearOtherCachedVersions(assetBundleName, hash) end

--
--Returns true when cache clearing succeeded.
--
--```plaintext
--Params: assetBundleName - The AssetBundle name.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param assetBundleName string
---@return Boolean
function CS.UnityEngine.Caching:ClearAllCachedVersions(assetBundleName) end

---@source UnityEngine.CoreModule.dll
---@param assetBundleName string
---@param outCachedVersions System.Collections.Generic.List<UnityEngine.Hash128>
function CS.UnityEngine.Caching:GetCachedVersions(assetBundleName, outCachedVersions) end

--
--True if an AssetBundle matching the url and version parameters has previously been loaded using UnityWebRequestAssetBundle.GetAssetBundle() and is currently stored in the cache. Returns false if the AssetBundle is not in cache, either because it has been flushed from the cache or was never loaded using the Caching API.
--
--```plaintext
--Params: string - Url The filename of the AssetBundle. Domain and path information are stripped from this string automatically.
--        int - Version The version number of the AssetBundle to check for. Negative values are not allowed.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param url string
---@param version int
---@return Boolean
function CS.UnityEngine.Caching:IsVersionCached(url, version) end

---@source UnityEngine.CoreModule.dll
---@param url string
---@param hash UnityEngine.Hash128
---@return Boolean
function CS.UnityEngine.Caching:IsVersionCached(url, hash) end

---@source UnityEngine.CoreModule.dll
---@param cachedBundle UnityEngine.CachedAssetBundle
---@return Boolean
function CS.UnityEngine.Caching:IsVersionCached(cachedBundle) end

--
--Bumps the timestamp of a cached file to be the current time.
--
---@source UnityEngine.CoreModule.dll
---@param url string
---@param version int
---@return Boolean
function CS.UnityEngine.Caching:MarkAsUsed(url, version) end

---@source UnityEngine.CoreModule.dll
---@param url string
---@param hash UnityEngine.Hash128
---@return Boolean
function CS.UnityEngine.Caching:MarkAsUsed(url, hash) end

---@source UnityEngine.CoreModule.dll
---@param cachedBundle UnityEngine.CachedAssetBundle
---@return Boolean
function CS.UnityEngine.Caching:MarkAsUsed(cachedBundle) end

---@source UnityEngine.CoreModule.dll
---@param url string
---@param version int
function CS.UnityEngine.Caching:SetNoBackupFlag(url, version) end

---@source UnityEngine.CoreModule.dll
---@param url string
---@param hash UnityEngine.Hash128
function CS.UnityEngine.Caching:SetNoBackupFlag(url, hash) end

---@source UnityEngine.CoreModule.dll
---@param cachedBundle UnityEngine.CachedAssetBundle
function CS.UnityEngine.Caching:SetNoBackupFlag(cachedBundle) end

---@source UnityEngine.CoreModule.dll
---@param url string
---@param version int
function CS.UnityEngine.Caching:ResetNoBackupFlag(url, version) end

---@source UnityEngine.CoreModule.dll
---@param url string
---@param hash UnityEngine.Hash128
function CS.UnityEngine.Caching:ResetNoBackupFlag(url, hash) end

---@source UnityEngine.CoreModule.dll
---@param cachedBundle UnityEngine.CachedAssetBundle
function CS.UnityEngine.Caching:ResetNoBackupFlag(cachedBundle) end

---@source UnityEngine.CoreModule.dll
---@param url string
---@return Int32
function CS.UnityEngine.Caching:GetVersionFromCache(url) end

--
--Add a cache with the given path.
--
--```plaintext
--Params: cachePath - Path to the cache folder.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param cachePath string
---@return Cache
function CS.UnityEngine.Caching:AddCache(cachePath) end

--
--A reference to the Cache at the index specified.
--
--```plaintext
--Params: cacheIndex - Index of the cache to get.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param cacheIndex int
---@return Cache
function CS.UnityEngine.Caching:GetCacheAt(cacheIndex) end

--
--A reference to the Cache with the given path.
--
--```plaintext
--Params: cachePath - The cache path.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param cachePath string
---@return Cache
function CS.UnityEngine.Caching:GetCacheByPath(cachePath) end

---@source UnityEngine.CoreModule.dll
---@param cachePaths System.Collections.Generic.List<string>
function CS.UnityEngine.Caching:GetAllCachePaths(cachePaths) end

--
--Returns true if the Cache is removed.
--
--```plaintext
--Params: cache - The Cache to be removed.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param cache UnityEngine.Cache
---@return Boolean
function CS.UnityEngine.Caching:RemoveCache(cache) end

--
--Moves the source Cache before the destination Cache in the cache list.
--
--```plaintext
--Params: src - The Cache to move.
--        dst - The Cache which should come after the source Cache in the cache list.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param src UnityEngine.Cache
---@param dst UnityEngine.Cache
function CS.UnityEngine.Caching:MoveCacheBefore(src, dst) end

--
--Moves the source Cache after the destination Cache in the cache list.
--
--```plaintext
--Params: src - The Cache to move.
--        dst - The Cache which should come before the source Cache in the cache list.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param src UnityEngine.Cache
---@param dst UnityEngine.Cache
function CS.UnityEngine.Caching:MoveCacheAfter(src, dst) end

---@source UnityEngine.CoreModule.dll
---@return Boolean
function CS.UnityEngine.Caching:CleanCache() end


--
--A Camera is a device through which the player views the world.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.Camera: UnityEngine.Behaviour
--
--Delegate that you can use to execute custom code before a Camera culls the scene.
--
---@source UnityEngine.CoreModule.dll
---@field onPreCull UnityEngine.Camera.CameraCallback
--
--Delegate that you can use to execute custom code before a Camera renders the scene.
--
---@source UnityEngine.CoreModule.dll
---@field onPreRender UnityEngine.Camera.CameraCallback
--
--Delegate that you can use to execute custom code after a Camera renders the scene.
--
---@source UnityEngine.CoreModule.dll
---@field onPostRender UnityEngine.Camera.CameraCallback
--
--The distance of the near clipping plane from the the Camera, in world units.
--
---@source UnityEngine.CoreModule.dll
---@field nearClipPlane float
--
--The distance of the far clipping plane from the Camera, in world units.
--
---@source UnityEngine.CoreModule.dll
---@field farClipPlane float
--
--The field of view of the camera in degrees.
--
---@source UnityEngine.CoreModule.dll
---@field fieldOfView float
--
--The rendering path that should be used, if possible.
--
---@source UnityEngine.CoreModule.dll
---@field renderingPath UnityEngine.RenderingPath
--
--The rendering path that is currently being used (Read Only).
--
---@source UnityEngine.CoreModule.dll
---@field actualRenderingPath UnityEngine.RenderingPath
--
--High dynamic range rendering.
--
---@source UnityEngine.CoreModule.dll
---@field allowHDR bool
--
--MSAA rendering.
--
---@source UnityEngine.CoreModule.dll
---@field allowMSAA bool
--
--Dynamic Resolution Scaling.
--
---@source UnityEngine.CoreModule.dll
---@field allowDynamicResolution bool
--
--Should camera rendering be forced into a RenderTexture.
--
---@source UnityEngine.CoreModule.dll
---@field forceIntoRenderTexture bool
--
--Camera's half-size when in orthographic mode.
--
---@source UnityEngine.CoreModule.dll
---@field orthographicSize float
--
--Is the camera orthographic (true) or perspective (false)?
--
---@source UnityEngine.CoreModule.dll
---@field orthographic bool
--
--Opaque object sorting mode.
--
---@source UnityEngine.CoreModule.dll
---@field opaqueSortMode UnityEngine.Rendering.OpaqueSortMode
--
--Transparent object sorting mode.
--
---@source UnityEngine.CoreModule.dll
---@field transparencySortMode UnityEngine.TransparencySortMode
--
--An axis that describes the direction along which the distances of objects are measured for the purpose of sorting.
--
---@source UnityEngine.CoreModule.dll
---@field transparencySortAxis UnityEngine.Vector3
--
--Camera's depth in the camera rendering order.
--
---@source UnityEngine.CoreModule.dll
---@field depth float
--
--The aspect ratio (width divided by height).
--
---@source UnityEngine.CoreModule.dll
---@field aspect float
--
--Get the world-space speed of the camera (Read Only).
--
---@source UnityEngine.CoreModule.dll
---@field velocity UnityEngine.Vector3
--
--This is used to render parts of the Scene selectively.
--
---@source UnityEngine.CoreModule.dll
---@field cullingMask int
--
--Mask to select which layers can trigger events on the camera.
--
---@source UnityEngine.CoreModule.dll
---@field eventMask int
--
--How to perform per-layer culling for a Camera.
--
---@source UnityEngine.CoreModule.dll
---@field layerCullSpherical bool
--
--Identifies what kind of camera this is, using the CameraType enum.
--
---@source UnityEngine.CoreModule.dll
---@field cameraType UnityEngine.CameraType
--
--Sets the culling maks used to determine which objects from which Scenes to draw.
--See EditorSceneManager.SetSceneCullingMask.
--
---@source UnityEngine.CoreModule.dll
---@field overrideSceneCullingMask ulong
--
--Per-layer culling distances.
--
---@source UnityEngine.CoreModule.dll
---@field layerCullDistances float[]
--
--Whether or not the Camera will use occlusion culling during rendering.
--
---@source UnityEngine.CoreModule.dll
---@field useOcclusionCulling bool
--
--Sets a custom matrix for the camera to use for all culling queries.
--
---@source UnityEngine.CoreModule.dll
---@field cullingMatrix UnityEngine.Matrix4x4
--
--The color with which the screen will be cleared.
--
---@source UnityEngine.CoreModule.dll
---@field backgroundColor UnityEngine.Color
--
--How the camera clears the background.
--
---@source UnityEngine.CoreModule.dll
---@field clearFlags UnityEngine.CameraClearFlags
--
--How and if camera generates a depth texture.
--
---@source UnityEngine.CoreModule.dll
---@field depthTextureMode UnityEngine.DepthTextureMode
--
--Should the camera clear the stencil buffer after the deferred light pass?
--
---@source UnityEngine.CoreModule.dll
---@field clearStencilAfterLightingPass bool
--
--Enable [UsePhysicalProperties] to use physical camera properties to compute the field of view and the frustum.
--
---@source UnityEngine.CoreModule.dll
---@field usePhysicalProperties bool
--
--The size of the camera sensor, expressed in millimeters.
--
---@source UnityEngine.CoreModule.dll
---@field sensorSize UnityEngine.Vector2
--
--The lens offset of the camera. The lens shift is relative to the sensor size. For example, a lens shift of 0.5 offsets the sensor by half its horizontal size.
--
---@source UnityEngine.CoreModule.dll
---@field lensShift UnityEngine.Vector2
--
--The camera focal length, expressed in millimeters. To use this property, enable UsePhysicalProperties.
--
---@source UnityEngine.CoreModule.dll
---@field focalLength float
--
--There are two gates for a camera, the sensor gate and the resolution gate. The physical camera sensor gate is defined by the sensorSize property, the resolution gate is defined by the render target area.
--
---@source UnityEngine.CoreModule.dll
---@field gateFit UnityEngine.Camera.GateFitMode
--
--Where on the screen is the camera rendered in normalized coordinates.
--
---@source UnityEngine.CoreModule.dll
---@field rect UnityEngine.Rect
--
--Where on the screen is the camera rendered in pixel coordinates.
--
---@source UnityEngine.CoreModule.dll
---@field pixelRect UnityEngine.Rect
--
--How wide is the camera in pixels (not accounting for dynamic resolution scaling) (Read Only).
--
---@source UnityEngine.CoreModule.dll
---@field pixelWidth int
--
--How tall is the camera in pixels (not accounting for dynamic resolution scaling) (Read Only).
--
---@source UnityEngine.CoreModule.dll
---@field pixelHeight int
--
--How wide is the camera in pixels (accounting for dynamic resolution scaling) (Read Only).
--
---@source UnityEngine.CoreModule.dll
---@field scaledPixelWidth int
--
--How tall is the camera in pixels (accounting for dynamic resolution scaling) (Read Only).
--
---@source UnityEngine.CoreModule.dll
---@field scaledPixelHeight int
--
--Destination render texture.
--
---@source UnityEngine.CoreModule.dll
---@field targetTexture UnityEngine.RenderTexture
--
--Gets the temporary RenderTexture target for this Camera.
--
---@source UnityEngine.CoreModule.dll
---@field activeTexture UnityEngine.RenderTexture
--
--Set the target display for this Camera.
--
---@source UnityEngine.CoreModule.dll
---@field targetDisplay int
--
--Matrix that transforms from camera space to world space (Read Only).
--
---@source UnityEngine.CoreModule.dll
---@field cameraToWorldMatrix UnityEngine.Matrix4x4
--
--Matrix that transforms from world to camera space.
--
---@source UnityEngine.CoreModule.dll
---@field worldToCameraMatrix UnityEngine.Matrix4x4
--
--Set a custom projection matrix.
--
---@source UnityEngine.CoreModule.dll
---@field projectionMatrix UnityEngine.Matrix4x4
--
--Get or set the raw projection matrix with no camera offset (no jittering).
--
---@source UnityEngine.CoreModule.dll
---@field nonJitteredProjectionMatrix UnityEngine.Matrix4x4
--
--Should the jittered matrix be used for transparency rendering?
--
---@source UnityEngine.CoreModule.dll
---@field useJitteredProjectionMatrixForTransparentRendering bool
--
--Get the view projection matrix used on the last frame.
--
---@source UnityEngine.CoreModule.dll
---@field previousViewProjectionMatrix UnityEngine.Matrix4x4
--
--The first enabled Camera component that is tagged "MainCamera" (Read Only).
--
---@source UnityEngine.CoreModule.dll
---@field main UnityEngine.Camera
--
--The camera we are currently rendering with, for low-level render control only (Read Only).
--
---@source UnityEngine.CoreModule.dll
---@field current UnityEngine.Camera
--
--If not null, the camera will only render the contents of the specified Scene.
--
---@source UnityEngine.CoreModule.dll
---@field scene UnityEngine.SceneManagement.Scene
--
--Stereoscopic rendering.
--
---@source UnityEngine.CoreModule.dll
---@field stereoEnabled bool
--
--The distance between the virtual eyes. Use this to query or set the current eye separation. Note that most VR devices provide this value, in which case setting the value will have no effect.
--
---@source UnityEngine.CoreModule.dll
---@field stereoSeparation float
--
--Distance to a point where virtual eyes converge.
--
---@source UnityEngine.CoreModule.dll
---@field stereoConvergence float
--
--Determines whether the stereo view matrices are suitable to allow for a single pass cull.
--
---@source UnityEngine.CoreModule.dll
---@field areVRStereoViewMatricesWithinSingleCullTolerance bool
--
--Defines which eye of a VR display the Camera renders into.
--
---@source UnityEngine.CoreModule.dll
---@field stereoTargetEye UnityEngine.StereoTargetEyeMask
--
--Returns the eye that is currently rendering.
--If called when stereo is not enabled it will return Camera.MonoOrStereoscopicEye.Mono.
--
--If called during a camera rendering callback such as OnRenderImage it will return the currently rendering eye.
--
--If called outside of a rendering callback and stereo is enabled, it will return the default eye which is Camera.MonoOrStereoscopicEye.Left.
--
---@source UnityEngine.CoreModule.dll
---@field stereoActiveEye UnityEngine.Camera.MonoOrStereoscopicEye
--
--The number of cameras in the current Scene.
--
---@source UnityEngine.CoreModule.dll
---@field allCamerasCount int
--
--Returns all enabled cameras in the Scene.
--
---@source UnityEngine.CoreModule.dll
---@field allCameras UnityEngine.Camera[]
--
--Number of command buffers set up on this camera (Read Only).
--
---@source UnityEngine.CoreModule.dll
---@field commandBufferCount int
---@source UnityEngine.CoreModule.dll
---@field isOrthoGraphic bool
---@source UnityEngine.CoreModule.dll
---@field mainCamera UnityEngine.Camera
---@source UnityEngine.CoreModule.dll
---@field near float
---@source UnityEngine.CoreModule.dll
---@field far float
---@source UnityEngine.CoreModule.dll
---@field fov float
--
--High dynamic range rendering.
--
---@source UnityEngine.CoreModule.dll
---@field hdr bool
--
--Render only once and use resulting image for both eyes.
--
---@source UnityEngine.CoreModule.dll
---@field stereoMirrorMode bool
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.Camera = {}

--
--Revert all camera parameters to default.
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.Camera.Reset() end

--
--Resets this Camera's transparency sort settings to the default. Default transparency settings are taken from GraphicsSettings instead of directly from this Camera.
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.Camera.ResetTransparencySortSettings() end

--
--Revert the aspect ratio to the screen's aspect ratio.
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.Camera.ResetAspect() end

--
--Make culling queries reflect the camera's built in parameters.
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.Camera.ResetCullingMatrix() end

--
--Make the camera render with shader replacement.
--
---@source UnityEngine.CoreModule.dll
---@param shader UnityEngine.Shader
---@param replacementTag string
function CS.UnityEngine.Camera.SetReplacementShader(shader, replacementTag) end

--
--Remove shader replacement from camera.
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.Camera.ResetReplacementShader() end

--
--Returns the effective vertical field of view.
--
---@source UnityEngine.CoreModule.dll
---@return Single
function CS.UnityEngine.Camera.GetGateFittedFieldOfView() end

--
--Returns the effective lens shift value.
--
---@source UnityEngine.CoreModule.dll
---@return Vector2
function CS.UnityEngine.Camera.GetGateFittedLensShift() end

--
--Sets the Camera to render to the chosen buffers of one or more RenderTextures.
--
--```plaintext
--Params: colorBuffer - The RenderBuffer(s) to which color information will be rendered.
--        depthBuffer - The RenderBuffer to which depth information will be rendered.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param colorBuffer UnityEngine.RenderBuffer
---@param depthBuffer UnityEngine.RenderBuffer
function CS.UnityEngine.Camera.SetTargetBuffers(colorBuffer, depthBuffer) end

--
--Sets the Camera to render to the chosen buffers of one or more RenderTextures.
--
--```plaintext
--Params: colorBuffer - The RenderBuffer(s) to which color information will be rendered.
--        depthBuffer - The RenderBuffer to which depth information will be rendered.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param colorBuffer UnityEngine.RenderBuffer[]
---@param depthBuffer UnityEngine.RenderBuffer
function CS.UnityEngine.Camera.SetTargetBuffers(colorBuffer, depthBuffer) end

--
--Make the rendering position reflect the camera's position in the Scene.
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.Camera.ResetWorldToCameraMatrix() end

--
--Make the projection reflect normal camera's parameters.
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.Camera.ResetProjectionMatrix() end

--
--Oblique near-plane projection matrix.
--
--```plaintext
--Params: clipPlane - Vector4 that describes a clip plane.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param clipPlane UnityEngine.Vector4
---@return Matrix4x4
function CS.UnityEngine.Camera.CalculateObliqueMatrix(clipPlane) end

---@source UnityEngine.CoreModule.dll
---@param position UnityEngine.Vector3
---@param eye UnityEngine.Camera.MonoOrStereoscopicEye
---@return Vector3
function CS.UnityEngine.Camera.WorldToScreenPoint(position, eye) end

---@source UnityEngine.CoreModule.dll
---@param position UnityEngine.Vector3
---@param eye UnityEngine.Camera.MonoOrStereoscopicEye
---@return Vector3
function CS.UnityEngine.Camera.WorldToViewportPoint(position, eye) end

---@source UnityEngine.CoreModule.dll
---@param position UnityEngine.Vector3
---@param eye UnityEngine.Camera.MonoOrStereoscopicEye
---@return Vector3
function CS.UnityEngine.Camera.ViewportToWorldPoint(position, eye) end

---@source UnityEngine.CoreModule.dll
---@param position UnityEngine.Vector3
---@param eye UnityEngine.Camera.MonoOrStereoscopicEye
---@return Vector3
function CS.UnityEngine.Camera.ScreenToWorldPoint(position, eye) end

--
--Transforms position from world space into screen space.
--
--```plaintext
--Params: eye - Optional argument that can be used to specify which eye transform to use. Default is Mono.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param position UnityEngine.Vector3
---@return Vector3
function CS.UnityEngine.Camera.WorldToScreenPoint(position) end

--
--Transforms position from world space into viewport space.
--
--```plaintext
--Params: eye - Optional argument that can be used to specify which eye transform to use. Default is Mono.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param position UnityEngine.Vector3
---@return Vector3
function CS.UnityEngine.Camera.WorldToViewportPoint(position) end

--
--The 3d vector in World space.
--
--```plaintext
--Params: position - The 3d vector in Viewport space.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param position UnityEngine.Vector3
---@return Vector3
function CS.UnityEngine.Camera.ViewportToWorldPoint(position) end

--
--The worldspace point created by converting the screen space point at the provided distance z from the camera plane.
--
--```plaintext
--Params: position - A screen space position (often mouse x, y), plus a z position for depth (for example, a camera clipping plane).
--        eye - By default, Camera.MonoOrStereoscopicEye.Mono. Can be set to Camera.MonoOrStereoscopicEye.Left or Camera.MonoOrStereoscopicEye.Right for use in stereoscopic rendering (e.g., for VR).
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param position UnityEngine.Vector3
---@return Vector3
function CS.UnityEngine.Camera.ScreenToWorldPoint(position) end

--
--Transforms position from screen space into viewport space.
--
---@source UnityEngine.CoreModule.dll
---@param position UnityEngine.Vector3
---@return Vector3
function CS.UnityEngine.Camera.ScreenToViewportPoint(position) end

--
--Transforms position from viewport space into screen space.
--
---@source UnityEngine.CoreModule.dll
---@param position UnityEngine.Vector3
---@return Vector3
function CS.UnityEngine.Camera.ViewportToScreenPoint(position) end

---@source UnityEngine.CoreModule.dll
---@param pos UnityEngine.Vector3
---@param eye UnityEngine.Camera.MonoOrStereoscopicEye
---@return Ray
function CS.UnityEngine.Camera.ViewportPointToRay(pos, eye) end

--
--Returns a ray going from camera through a viewport point.
--
--```plaintext
--Params: eye - Optional argument that can be used to specify which eye transform to use. Default is Mono.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param pos UnityEngine.Vector3
---@return Ray
function CS.UnityEngine.Camera.ViewportPointToRay(pos) end

---@source UnityEngine.CoreModule.dll
---@param pos UnityEngine.Vector3
---@param eye UnityEngine.Camera.MonoOrStereoscopicEye
---@return Ray
function CS.UnityEngine.Camera.ScreenPointToRay(pos, eye) end

--
--Returns a ray going from camera through a screen point.
--
--```plaintext
--Params: eye - Optional argument that can be used to specify which eye transform to use. Default is Mono.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param pos UnityEngine.Vector3
---@return Ray
function CS.UnityEngine.Camera.ScreenPointToRay(pos) end

---@source UnityEngine.CoreModule.dll
---@param viewport UnityEngine.Rect
---@param z float
---@param eye UnityEngine.Camera.MonoOrStereoscopicEye
---@param outCorners UnityEngine.Vector3[]
function CS.UnityEngine.Camera.CalculateFrustumCorners(viewport, z, eye, outCorners) end

---@source UnityEngine.CoreModule.dll
---@param output UnityEngine.Matrix4x4
---@param focalLength float
---@param sensorSize UnityEngine.Vector2
---@param lensShift UnityEngine.Vector2
---@param nearClip float
---@param farClip float
---@param gateFitParameters UnityEngine.Camera.GateFitParameters
function CS.UnityEngine.Camera:CalculateProjectionMatrixFromPhysicalProperties(output, focalLength, sensorSize, lensShift, nearClip, farClip, gateFitParameters) end

--
--field of view in degrees.
--
--```plaintext
--Params: focalLength - Focal length in millimeters.
--        sensorSize - Sensor size in millimeters. Use the sensor height to get the vertical field of view. Use the sensor width to get the horizontal field of view.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param focalLength float
---@param sensorSize float
---@return Single
function CS.UnityEngine.Camera:FocalLengthToFieldOfView(focalLength, sensorSize) end

--
--Focal length in millimeters.
--
--```plaintext
--Params: fieldOfView - field of view in degrees.
--        sensorSize - Sensor size in millimeters.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param fieldOfView float
---@param sensorSize float
---@return Single
function CS.UnityEngine.Camera:FieldOfViewToFocalLength(fieldOfView, sensorSize) end

--
--Converts the horizontal field of view (FOV) to the vertical FOV, based on the value of the aspect ratio parameter.
--
--```plaintext
--Params: horizontalFOV - The horizontal FOV value in degrees.
--        aspectRatio - The aspect ratio value used for the conversion
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param horizontalFieldOfView float
---@param aspectRatio float
---@return Single
function CS.UnityEngine.Camera:HorizontalToVerticalFieldOfView(horizontalFieldOfView, aspectRatio) end

--
--Converts the vertical field of view (FOV) to the horizontal FOV, based on the value of the aspect ratio parameter.
--
--```plaintext
--Params: verticalFieldOfView - The vertical FOV value in degrees.
--        aspectRatio - The aspect ratio value used for the conversion
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param verticalFieldOfView float
---@param aspectRatio float
---@return Single
function CS.UnityEngine.Camera:VerticalToHorizontalFieldOfView(verticalFieldOfView, aspectRatio) end

---@source UnityEngine.CoreModule.dll
---@param eye UnityEngine.Camera.StereoscopicEye
---@return Matrix4x4
function CS.UnityEngine.Camera.GetStereoNonJitteredProjectionMatrix(eye) end

---@source UnityEngine.CoreModule.dll
---@param eye UnityEngine.Camera.StereoscopicEye
---@return Matrix4x4
function CS.UnityEngine.Camera.GetStereoViewMatrix(eye) end

---@source UnityEngine.CoreModule.dll
---@param eye UnityEngine.Camera.StereoscopicEye
function CS.UnityEngine.Camera.CopyStereoDeviceProjectionMatrixToNonJittered(eye) end

---@source UnityEngine.CoreModule.dll
---@param eye UnityEngine.Camera.StereoscopicEye
---@return Matrix4x4
function CS.UnityEngine.Camera.GetStereoProjectionMatrix(eye) end

---@source UnityEngine.CoreModule.dll
---@param eye UnityEngine.Camera.StereoscopicEye
---@param matrix UnityEngine.Matrix4x4
function CS.UnityEngine.Camera.SetStereoProjectionMatrix(eye, matrix) end

--
--Reset the camera to using the Unity computed projection matrices for all stereoscopic eyes.
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.Camera.ResetStereoProjectionMatrices() end

---@source UnityEngine.CoreModule.dll
---@param eye UnityEngine.Camera.StereoscopicEye
---@param matrix UnityEngine.Matrix4x4
function CS.UnityEngine.Camera.SetStereoViewMatrix(eye, matrix) end

--
--Reset the camera to using the Unity computed view matrices for all stereoscopic eyes.
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.Camera.ResetStereoViewMatrices() end

--
--Fills an array of Camera with the current cameras in the Scene, without allocating a new array.
--
--```plaintext
--Params: cameras - An array to be filled up with cameras currently in the Scene.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param cameras UnityEngine.Camera[]
---@return Int32
function CS.UnityEngine.Camera:GetAllCameras(cameras) end

--
--False if rendering fails, else true.
--
--```plaintext
--Params: cubemap - The cube map to render to.
--        faceMask - A bitmask which determines which of the six faces are rendered to.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param cubemap UnityEngine.Cubemap
---@param faceMask int
---@return Boolean
function CS.UnityEngine.Camera.RenderToCubemap(cubemap, faceMask) end

---@source UnityEngine.CoreModule.dll
---@param cubemap UnityEngine.Cubemap
---@return Boolean
function CS.UnityEngine.Camera.RenderToCubemap(cubemap) end

--
--False if rendering fails, else true.
--
--```plaintext
--Params: faceMask - A bitfield indicating which cubemap faces should be rendered into.
--        cubemap - The texture to render to.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param cubemap UnityEngine.RenderTexture
---@param faceMask int
---@return Boolean
function CS.UnityEngine.Camera.RenderToCubemap(cubemap, faceMask) end

---@source UnityEngine.CoreModule.dll
---@param cubemap UnityEngine.RenderTexture
---@return Boolean
function CS.UnityEngine.Camera.RenderToCubemap(cubemap) end

---@source UnityEngine.CoreModule.dll
---@param cubemap UnityEngine.RenderTexture
---@param faceMask int
---@param stereoEye UnityEngine.Camera.MonoOrStereoscopicEye
---@return Boolean
function CS.UnityEngine.Camera.RenderToCubemap(cubemap, faceMask, stereoEye) end

--
--Render the camera manually.
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.Camera.Render() end

--
--Render the camera with shader replacement.
--
---@source UnityEngine.CoreModule.dll
---@param shader UnityEngine.Shader
---@param replacementTag string
function CS.UnityEngine.Camera.RenderWithShader(shader, replacementTag) end

---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.Camera.RenderDontRestore() end

---@source UnityEngine.CoreModule.dll
---@param renderRequests System.Collections.Generic.List<UnityEngine.Camera.RenderRequest>
function CS.UnityEngine.Camera.SubmitRenderRequests(renderRequests) end

---@source UnityEngine.CoreModule.dll
---@param cur UnityEngine.Camera
function CS.UnityEngine.Camera:SetupCurrent(cur) end

--
--Makes this camera's settings match other camera.
--
--```plaintext
--Params: other - Copy camera settings to the other camera.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param other UnityEngine.Camera
function CS.UnityEngine.Camera.CopyFrom(other) end

--
--Remove command buffers from execution at a specified place.
--
--```plaintext
--Params: evt - When to execute the command buffer during rendering.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param evt UnityEngine.Rendering.CameraEvent
function CS.UnityEngine.Camera.RemoveCommandBuffers(evt) end

--
--Remove all command buffers set on this camera.
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.Camera.RemoveAllCommandBuffers() end

--
--Add a command buffer to be executed at a specified place.
--
--```plaintext
--Params: evt - When to execute the command buffer during rendering.
--        buffer - The buffer to execute.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param evt UnityEngine.Rendering.CameraEvent
---@param buffer UnityEngine.Rendering.CommandBuffer
function CS.UnityEngine.Camera.AddCommandBuffer(evt, buffer) end

--
--Adds a command buffer to the GPU's async compute queues and executes that command buffer when graphics processing reaches a given point.
--
--```plaintext
--Params: evt - The point during the graphics processing at which this command buffer should commence on the GPU.
--        buffer - The buffer to execute.
--        queueType - The desired async compute queue type to execute the buffer on.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param evt UnityEngine.Rendering.CameraEvent
---@param buffer UnityEngine.Rendering.CommandBuffer
---@param queueType UnityEngine.Rendering.ComputeQueueType
function CS.UnityEngine.Camera.AddCommandBufferAsync(evt, buffer, queueType) end

--
--Remove command buffer from execution at a specified place.
--
--```plaintext
--Params: evt - When to execute the command buffer during rendering.
--        buffer - The buffer to execute.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param evt UnityEngine.Rendering.CameraEvent
---@param buffer UnityEngine.Rendering.CommandBuffer
function CS.UnityEngine.Camera.RemoveCommandBuffer(evt, buffer) end

--
--Array of command buffers.
--
--```plaintext
--Params: evt - When to execute the command buffer during rendering.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param evt UnityEngine.Rendering.CameraEvent
function CS.UnityEngine.Camera.GetCommandBuffers(evt) end

---@source UnityEngine.CoreModule.dll
---@param cullingParameters UnityEngine.Rendering.ScriptableCullingParameters
---@return Boolean
function CS.UnityEngine.Camera.TryGetCullingParameters(cullingParameters) end

---@source UnityEngine.CoreModule.dll
---@param stereoAware bool
---@param cullingParameters UnityEngine.Rendering.ScriptableCullingParameters
---@return Boolean
function CS.UnityEngine.Camera.TryGetCullingParameters(stereoAware, cullingParameters) end

---@source UnityEngine.CoreModule.dll
---@return Single
function CS.UnityEngine.Camera.GetScreenWidth() end

---@source UnityEngine.CoreModule.dll
---@return Single
function CS.UnityEngine.Camera.GetScreenHeight() end

---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.Camera.DoClear() end

--
--Reset to the default field of view.
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.Camera.ResetFieldOfView() end

--
--Set custom view matrices for both eyes.
--
--```plaintext
--Params: leftMatrix - View matrix for the stereo left eye.
--        rightMatrix - View matrix for the stereo right eye.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param leftMatrix UnityEngine.Matrix4x4
---@param rightMatrix UnityEngine.Matrix4x4
function CS.UnityEngine.Camera.SetStereoViewMatrices(leftMatrix, rightMatrix) end

--
--Sets custom projection matrices for both the left and right stereoscopic eyes.
--
--```plaintext
--Params: leftMatrix - Projection matrix for the stereoscopic left eye.
--        rightMatrix - Projection matrix for the stereoscopic right eye.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param leftMatrix UnityEngine.Matrix4x4
---@param rightMatrix UnityEngine.Matrix4x4
function CS.UnityEngine.Camera.SetStereoProjectionMatrices(leftMatrix, rightMatrix) end

---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.Camera.GetStereoViewMatrices() end

---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.Camera.GetStereoProjectionMatrices() end


--
--A pair of SphereColliders used to define shapes for Cloth objects to collide against.
--
---@source UnityEngine.ClothModule.dll
---@class UnityEngine.ClothSphereColliderPair: System.ValueType
--
--The first SphereCollider of a ClothSphereColliderPair.
--
---@source UnityEngine.ClothModule.dll
---@field first UnityEngine.SphereCollider
--
--The second SphereCollider of a ClothSphereColliderPair.
--
---@source UnityEngine.ClothModule.dll
---@field second UnityEngine.SphereCollider
---@source UnityEngine.ClothModule.dll
CS.UnityEngine.ClothSphereColliderPair = {}


--
--The ClothSkinningCoefficient struct is used to set up how a Cloth component is allowed to move with respect to the SkinnedMeshRenderer it is attached to.
--
---@source UnityEngine.ClothModule.dll
---@class UnityEngine.ClothSkinningCoefficient: System.ValueType
--
--Distance a vertex is allowed to travel from the skinned mesh vertex position.
--
---@source UnityEngine.ClothModule.dll
---@field maxDistance float
--
--Definition of a sphere a vertex is not allowed to enter. This allows collision against the animated cloth.
--
---@source UnityEngine.ClothModule.dll
---@field collisionSphereDistance float
---@source UnityEngine.ClothModule.dll
CS.UnityEngine.ClothSkinningCoefficient = {}


--
--The Cloth class provides an interface to cloth simulation physics.
--
---@source UnityEngine.ClothModule.dll
---@class UnityEngine.Cloth: UnityEngine.Component
--
--The current vertex positions of the cloth object.
--
---@source UnityEngine.ClothModule.dll
---@field vertices UnityEngine.Vector3[]
--
--The current normals of the cloth object.
--
---@source UnityEngine.ClothModule.dll
---@field normals UnityEngine.Vector3[]
--
--The cloth skinning coefficients used to set up how the cloth interacts with the skinned mesh.
--
---@source UnityEngine.ClothModule.dll
---@field coefficients UnityEngine.ClothSkinningCoefficient[]
--
--An array of CapsuleColliders which this Cloth instance should collide with.
--
---@source UnityEngine.ClothModule.dll
---@field capsuleColliders UnityEngine.CapsuleCollider[]
--
--An array of ClothSphereColliderPairs which this Cloth instance should collide with.
--
---@source UnityEngine.ClothModule.dll
---@field sphereColliders UnityEngine.ClothSphereColliderPair[]
--
--Cloth's sleep threshold.
--
---@source UnityEngine.ClothModule.dll
---@field sleepThreshold float
--
--Bending stiffness of the cloth.
--
---@source UnityEngine.ClothModule.dll
---@field bendingStiffness float
--
--Stretching stiffness of the cloth.
--
---@source UnityEngine.ClothModule.dll
---@field stretchingStiffness float
--
--Damp cloth motion.
--
---@source UnityEngine.ClothModule.dll
---@field damping float
--
--A constant, external acceleration applied to the cloth.
--
---@source UnityEngine.ClothModule.dll
---@field externalAcceleration UnityEngine.Vector3
--
--A random, external acceleration applied to the cloth.
--
---@source UnityEngine.ClothModule.dll
---@field randomAcceleration UnityEngine.Vector3
--
--Should gravity affect the cloth simulation?
--
---@source UnityEngine.ClothModule.dll
---@field useGravity bool
--
--Is this cloth enabled?
--
---@source UnityEngine.ClothModule.dll
---@field enabled bool
--
--The friction of the cloth when colliding with the character.
--
---@source UnityEngine.ClothModule.dll
---@field friction float
--
--How much to increase mass of colliding particles.
--
---@source UnityEngine.ClothModule.dll
---@field collisionMassScale float
--
--Enable continuous collision to improve collision stability.
--
---@source UnityEngine.ClothModule.dll
---@field enableContinuousCollision bool
--
--Add one virtual particle per triangle to improve collision stability.
--
---@source UnityEngine.ClothModule.dll
---@field useVirtualParticles float
--
--How much world-space movement of the character will affect cloth vertices.
--
---@source UnityEngine.ClothModule.dll
---@field worldVelocityScale float
--
--How much world-space acceleration of the character will affect cloth vertices.
--
---@source UnityEngine.ClothModule.dll
---@field worldAccelerationScale float
--
--Number of cloth solver iterations per second.
--
---@source UnityEngine.ClothModule.dll
---@field clothSolverFrequency float
---@source UnityEngine.ClothModule.dll
---@field solverFrequency bool
--
--Use Tether Anchors.
--
---@source UnityEngine.ClothModule.dll
---@field useTethers bool
--
--Sets the stiffness frequency parameter.
--
---@source UnityEngine.ClothModule.dll
---@field stiffnessFrequency float
--
--Minimum distance at which two cloth particles repel each other (default: 0.0).
--
---@source UnityEngine.ClothModule.dll
---@field selfCollisionDistance float
--
--Self-collision stiffness defines how strong the separating impulse should be for colliding particles.
--
---@source UnityEngine.ClothModule.dll
---@field selfCollisionStiffness float
---@source UnityEngine.ClothModule.dll
---@field useContinuousCollision float
---@source UnityEngine.ClothModule.dll
---@field selfCollision bool
---@source UnityEngine.ClothModule.dll
CS.UnityEngine.Cloth = {}

--
--Clear the pending transform changes from affecting the cloth simulation.
--
---@source UnityEngine.ClothModule.dll
function CS.UnityEngine.Cloth.ClearTransformMotion() end

---@source UnityEngine.ClothModule.dll
---@param indices System.Collections.Generic.List<uint>
function CS.UnityEngine.Cloth.GetSelfAndInterCollisionIndices(indices) end

---@source UnityEngine.ClothModule.dll
---@param indices System.Collections.Generic.List<uint>
function CS.UnityEngine.Cloth.SetSelfAndInterCollisionIndices(indices) end

---@source UnityEngine.ClothModule.dll
---@param indicesOutList System.Collections.Generic.List<uint>
function CS.UnityEngine.Cloth.GetVirtualParticleIndices(indicesOutList) end

---@source UnityEngine.ClothModule.dll
---@param indicesIn System.Collections.Generic.List<uint>
function CS.UnityEngine.Cloth.SetVirtualParticleIndices(indicesIn) end

---@source UnityEngine.ClothModule.dll
---@param weightsOutList System.Collections.Generic.List<UnityEngine.Vector3>
function CS.UnityEngine.Cloth.GetVirtualParticleWeights(weightsOutList) end

---@source UnityEngine.ClothModule.dll
---@param weights System.Collections.Generic.List<UnityEngine.Vector3>
function CS.UnityEngine.Cloth.SetVirtualParticleWeights(weights) end

--
--Fade the cloth simulation in or out.
--
--```plaintext
--Params: enabled - Fading enabled or not.
--        
--```
--
---@source UnityEngine.ClothModule.dll
---@param enabled bool
---@param interpolationTime float
function CS.UnityEngine.Cloth.SetEnabledFading(enabled, interpolationTime) end

---@source UnityEngine.ClothModule.dll
---@param enabled bool
function CS.UnityEngine.Cloth.SetEnabledFading(enabled) end


--
--Values to determine the type of input value to be expect from one entry of ClusterInput.
--
---@source UnityEngine.ClusterInputModule.dll
---@class UnityEngine.ClusterInputType: System.Enum
--
--Device that return a binary result of pressed or not pressed.
--
---@source UnityEngine.ClusterInputModule.dll
---@field Button UnityEngine.ClusterInputType
--
--Device is an analog axis that provides continuous value represented by a float.
--
---@source UnityEngine.ClusterInputModule.dll
---@field Axis UnityEngine.ClusterInputType
--
--Device that provide position and orientation values.
--
---@source UnityEngine.ClusterInputModule.dll
---@field Tracker UnityEngine.ClusterInputType
--
--A user customized input.
--
---@source UnityEngine.ClusterInputModule.dll
---@field CustomProvidedInput UnityEngine.ClusterInputType
---@source UnityEngine.ClusterInputModule.dll
CS.UnityEngine.ClusterInputType = {}

---@source 
---@param value any
---@return UnityEngine.ClusterInputType
function CS.UnityEngine.ClusterInputType:__CastFrom(value) end


--
--Holds data for a single application crash event and provides access to all gathered crash reports.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.CrashReport: object
--
--Time, when the crash occured.
--
---@source UnityEngine.CoreModule.dll
---@field time System.DateTime
--
--Crash report data as formatted text.
--
---@source UnityEngine.CoreModule.dll
---@field text string
--
--Returns all currently available reports in a new array.
--
---@source UnityEngine.CoreModule.dll
---@field reports UnityEngine.CrashReport[]
--
--Returns last crash report, or null if no reports are available.
--
---@source UnityEngine.CoreModule.dll
---@field lastReport UnityEngine.CrashReport
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.CrashReport = {}

--
--Remove all reports from available reports list.
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.CrashReport:RemoveAll() end

--
--Remove report from available reports list.
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.CrashReport.Remove() end


---@source UnityEngine.CoreModule.dll
---@class UnityEngine.EventProvider: object
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.EventProvider = {}

---@source UnityEngine.CoreModule.dll
---@param value int
---@param text string
function CS.UnityEngine.EventProvider:WriteCustomEvent(value, text) end


--
--Represents an axis aligned bounding box.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.Bounds: System.ValueType
--
--The center of the bounding box.
--
---@source UnityEngine.CoreModule.dll
---@field center UnityEngine.Vector3
--
--The total size of the box. This is always twice as large as the extents.
--
---@source UnityEngine.CoreModule.dll
---@field size UnityEngine.Vector3
--
--The extents of the Bounding Box. This is always half of the size of the Bounds.
--
---@source UnityEngine.CoreModule.dll
---@field extents UnityEngine.Vector3
--
--The minimal point of the box. This is always equal to center-extents.
--
---@source UnityEngine.CoreModule.dll
---@field min UnityEngine.Vector3
--
--The maximal point of the box. This is always equal to center+extents.
--
---@source UnityEngine.CoreModule.dll
---@field max UnityEngine.Vector3
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.Bounds = {}

---@source UnityEngine.CoreModule.dll
---@return Int32
function CS.UnityEngine.Bounds.GetHashCode() end

---@source UnityEngine.CoreModule.dll
---@param other object
---@return Boolean
function CS.UnityEngine.Bounds.Equals(other) end

---@source UnityEngine.CoreModule.dll
---@param other UnityEngine.Bounds
---@return Boolean
function CS.UnityEngine.Bounds.Equals(other) end

---@source UnityEngine.CoreModule.dll
---@param lhs UnityEngine.Bounds
---@param rhs UnityEngine.Bounds
---@return Boolean
function CS.UnityEngine.Bounds:op_Equality(lhs, rhs) end

---@source UnityEngine.CoreModule.dll
---@param lhs UnityEngine.Bounds
---@param rhs UnityEngine.Bounds
---@return Boolean
function CS.UnityEngine.Bounds:op_Inequality(lhs, rhs) end

--
--Sets the bounds to the min and max value of the box.
--
---@source UnityEngine.CoreModule.dll
---@param min UnityEngine.Vector3
---@param max UnityEngine.Vector3
function CS.UnityEngine.Bounds.SetMinMax(min, max) end

--
--Grows the Bounds to include the point.
--
---@source UnityEngine.CoreModule.dll
---@param point UnityEngine.Vector3
function CS.UnityEngine.Bounds.Encapsulate(point) end

--
--Grow the bounds to encapsulate the bounds.
--
---@source UnityEngine.CoreModule.dll
---@param bounds UnityEngine.Bounds
function CS.UnityEngine.Bounds.Encapsulate(bounds) end

--
--Expand the bounds by increasing its size by amount along each side.
--
---@source UnityEngine.CoreModule.dll
---@param amount float
function CS.UnityEngine.Bounds.Expand(amount) end

--
--Expand the bounds by increasing its size by amount along each side.
--
---@source UnityEngine.CoreModule.dll
---@param amount UnityEngine.Vector3
function CS.UnityEngine.Bounds.Expand(amount) end

--
--Does another bounding box intersect with this bounding box?
--
---@source UnityEngine.CoreModule.dll
---@param bounds UnityEngine.Bounds
---@return Boolean
function CS.UnityEngine.Bounds.Intersects(bounds) end

--
--Does ray intersect this bounding box?
--
---@source UnityEngine.CoreModule.dll
---@param ray UnityEngine.Ray
---@return Boolean
function CS.UnityEngine.Bounds.IntersectRay(ray) end

---@source UnityEngine.CoreModule.dll
---@param ray UnityEngine.Ray
---@param distance float
---@return Boolean
function CS.UnityEngine.Bounds.IntersectRay(ray, distance) end

--
--Returns a formatted string for the bounds.
--
--```plaintext
--Params: format - A numeric format string.
--        formatProvider - An object that specifies culture-specific formatting.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@return String
function CS.UnityEngine.Bounds.ToString() end

--
--Returns a formatted string for the bounds.
--
--```plaintext
--Params: format - A numeric format string.
--        formatProvider - An object that specifies culture-specific formatting.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param format string
---@return String
function CS.UnityEngine.Bounds.ToString(format) end

--
--Returns a formatted string for the bounds.
--
--```plaintext
--Params: format - A numeric format string.
--        formatProvider - An object that specifies culture-specific formatting.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param format string
---@param formatProvider System.IFormatProvider
---@return String
function CS.UnityEngine.Bounds.ToString(format, formatProvider) end

--
--Is point contained in the bounding box?
--
---@source UnityEngine.CoreModule.dll
---@param point UnityEngine.Vector3
---@return Boolean
function CS.UnityEngine.Bounds.Contains(point) end

--
--The smallest squared distance between the point and this bounding box.
--
---@source UnityEngine.CoreModule.dll
---@param point UnityEngine.Vector3
---@return Single
function CS.UnityEngine.Bounds.SqrDistance(point) end

--
--The point on the bounding box or inside the bounding box.
--
--```plaintext
--Params: point - Arbitrary point.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param point UnityEngine.Vector3
---@return Vector3
function CS.UnityEngine.Bounds.ClosestPoint(point) end


--
--Represents an axis aligned bounding box with all values as integers.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.BoundsInt: System.ValueType
--
--X value of the minimal point of the box.
--
---@source UnityEngine.CoreModule.dll
---@field x int
--
--Y value of the minimal point of the box.
--
---@source UnityEngine.CoreModule.dll
---@field y int
--
--Z value of the minimal point of the box.
--
---@source UnityEngine.CoreModule.dll
---@field z int
--
--The center of the bounding box.
--
---@source UnityEngine.CoreModule.dll
---@field center UnityEngine.Vector3
--
--The minimal point of the box.
--
---@source UnityEngine.CoreModule.dll
---@field min UnityEngine.Vector3Int
--
--The maximal point of the box.
--
---@source UnityEngine.CoreModule.dll
---@field max UnityEngine.Vector3Int
--
--The minimal x point of the box.
--
---@source UnityEngine.CoreModule.dll
---@field xMin int
--
--The minimal y point of the box.
--
---@source UnityEngine.CoreModule.dll
---@field yMin int
--
--The minimal z point of the box.
--
---@source UnityEngine.CoreModule.dll
---@field zMin int
--
--The maximal x point of the box.
--
---@source UnityEngine.CoreModule.dll
---@field xMax int
--
--The maximal y point of the box.
--
---@source UnityEngine.CoreModule.dll
---@field yMax int
--
--The maximal z point of the box.
--
---@source UnityEngine.CoreModule.dll
---@field zMax int
--
--The position of the bounding box.
--
---@source UnityEngine.CoreModule.dll
---@field position UnityEngine.Vector3Int
--
--The total size of the box.
--
---@source UnityEngine.CoreModule.dll
---@field size UnityEngine.Vector3Int
--
--A BoundsInt.PositionCollection that contains all positions within the BoundsInt.
--
---@source UnityEngine.CoreModule.dll
---@field allPositionsWithin UnityEngine.BoundsInt.PositionEnumerator
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.BoundsInt = {}

--
--Sets the bounds to the min and max value of the box.
--
---@source UnityEngine.CoreModule.dll
---@param minPosition UnityEngine.Vector3Int
---@param maxPosition UnityEngine.Vector3Int
function CS.UnityEngine.BoundsInt.SetMinMax(minPosition, maxPosition) end

--
--Clamps the position and size of this bounding box to the given bounds.
--
--```plaintext
--Params: bounds - Bounds to clamp to.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param bounds UnityEngine.BoundsInt
function CS.UnityEngine.BoundsInt.ClampToBounds(bounds) end

--
--Is point contained in the bounding box?
--
--```plaintext
--Params: position - Point to check.
--        inclusive - Whether the max limits are included in the check.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param position UnityEngine.Vector3Int
---@return Boolean
function CS.UnityEngine.BoundsInt.Contains(position) end

--
--Returns a formatted string for the bounds.
--
--```plaintext
--Params: format - A numeric format string.
--        formatProvider - An object that specifies culture-specific formatting.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@return String
function CS.UnityEngine.BoundsInt.ToString() end

--
--Returns a formatted string for the bounds.
--
--```plaintext
--Params: format - A numeric format string.
--        formatProvider - An object that specifies culture-specific formatting.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param format string
---@return String
function CS.UnityEngine.BoundsInt.ToString(format) end

--
--Returns a formatted string for the bounds.
--
--```plaintext
--Params: format - A numeric format string.
--        formatProvider - An object that specifies culture-specific formatting.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param format string
---@param formatProvider System.IFormatProvider
---@return String
function CS.UnityEngine.BoundsInt.ToString(format, formatProvider) end

---@source UnityEngine.CoreModule.dll
---@param lhs UnityEngine.BoundsInt
---@param rhs UnityEngine.BoundsInt
---@return Boolean
function CS.UnityEngine.BoundsInt:op_Equality(lhs, rhs) end

---@source UnityEngine.CoreModule.dll
---@param lhs UnityEngine.BoundsInt
---@param rhs UnityEngine.BoundsInt
---@return Boolean
function CS.UnityEngine.BoundsInt:op_Inequality(lhs, rhs) end

---@source UnityEngine.CoreModule.dll
---@param other object
---@return Boolean
function CS.UnityEngine.BoundsInt.Equals(other) end

---@source UnityEngine.CoreModule.dll
---@param other UnityEngine.BoundsInt
---@return Boolean
function CS.UnityEngine.BoundsInt.Equals(other) end

---@source UnityEngine.CoreModule.dll
---@return Int32
function CS.UnityEngine.BoundsInt.GetHashCode() end


--
--An iterator that allows you to iterate over all positions within the BoundsInt.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.PositionEnumerator: System.ValueType
--
--Current position of the enumerator.
--
---@source UnityEngine.CoreModule.dll
---@field Current UnityEngine.Vector3Int
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.PositionEnumerator = {}

--
--This BoundsInt.PositionEnumerator.
--
---@source UnityEngine.CoreModule.dll
---@return PositionEnumerator
function CS.UnityEngine.PositionEnumerator.GetEnumerator() end

--
--Whether the enumerator has successfully moved to the next position.
--
---@source UnityEngine.CoreModule.dll
---@return Boolean
function CS.UnityEngine.PositionEnumerator.MoveNext() end

--
--Resets this enumerator to its starting state.
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.PositionEnumerator.Reset() end


--
--Utility class for common geometric functions.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.GeometryUtility: object
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.GeometryUtility = {}

--
--The planes that form the camera's view frustum.
--
--```plaintext
--Params: camera - The camera with the view frustum that you want to calculate planes from.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param camera UnityEngine.Camera
function CS.UnityEngine.GeometryUtility:CalculateFrustumPlanes(camera) end

--
--The planes that enclose the projection space described by the matrix.
--
--```plaintext
--Params: worldToProjectionMatrix - A matrix that transforms from world space to projection space, from which the planes will be calculated.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param worldToProjectionMatrix UnityEngine.Matrix4x4
function CS.UnityEngine.GeometryUtility:CalculateFrustumPlanes(worldToProjectionMatrix) end

--
--Calculates frustum planes.
--
--```plaintext
--Params: camera - The camera with the view frustum that you want to calculate planes from.
--        planes - An array of 6 Planes that will be overwritten with the calculated plane values.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param camera UnityEngine.Camera
---@param planes UnityEngine.Plane[]
function CS.UnityEngine.GeometryUtility:CalculateFrustumPlanes(camera, planes) end

--
--Calculates frustum planes.
--
--```plaintext
--Params: worldToProjectionMatrix - A matrix that transforms from world space to projection space, from which the planes will be calculated.
--        planes - An array of 6 Planes that will be overwritten with the calculated plane values.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param worldToProjectionMatrix UnityEngine.Matrix4x4
---@param planes UnityEngine.Plane[]
function CS.UnityEngine.GeometryUtility:CalculateFrustumPlanes(worldToProjectionMatrix, planes) end

--
--Calculates the axis-aligned bounding box.
--
--```plaintext
--Params: positions - An array that stores the location of 3d positions.
--        transform - A matrix that changes the position, rotation and size of the bounds calculation.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param positions UnityEngine.Vector3[]
---@param transform UnityEngine.Matrix4x4
---@return Bounds
function CS.UnityEngine.GeometryUtility:CalculateBounds(positions, transform) end

---@source UnityEngine.CoreModule.dll
---@param vertices UnityEngine.Vector3[]
---@param plane UnityEngine.Plane
---@return Boolean
function CS.UnityEngine.GeometryUtility:TryCreatePlaneFromPolygon(vertices, plane) end

--
--Returns true if bounds are inside the plane array.
--
---@source UnityEngine.CoreModule.dll
---@param planes UnityEngine.Plane[]
---@param bounds UnityEngine.Bounds
---@return Boolean
function CS.UnityEngine.GeometryUtility:TestPlanesAABB(planes, bounds) end


--
--Representation of a plane in 3D space.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.Plane: System.ValueType
--
--Normal vector of the plane.
--
---@source UnityEngine.CoreModule.dll
---@field normal UnityEngine.Vector3
--
--The distance measured from the Plane to the origin, along the Plane's normal.
--
---@source UnityEngine.CoreModule.dll
---@field distance float
--
--Returns a copy of the plane that faces in the opposite direction.
--
---@source UnityEngine.CoreModule.dll
---@field flipped UnityEngine.Plane
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.Plane = {}

--
--Sets a plane using a point that lies within it along with a normal to orient it.
--
--```plaintext
--Params: inNormal - The plane's normal vector.
--        inPoint - A point that lies on the plane.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param inNormal UnityEngine.Vector3
---@param inPoint UnityEngine.Vector3
function CS.UnityEngine.Plane.SetNormalAndPosition(inNormal, inPoint) end

--
--Sets a plane using three points that lie within it.  The points go around clockwise as you look down on the top surface of the plane.
--
--```plaintext
--Params: a - First point in clockwise order.
--        b - Second point in clockwise order.
--        c - Third point in clockwise order.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param a UnityEngine.Vector3
---@param b UnityEngine.Vector3
---@param c UnityEngine.Vector3
function CS.UnityEngine.Plane.Set3Points(a, b, c) end

--
--Makes the plane face in the opposite direction.
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.Plane.Flip() end

--
--Moves the plane in space by the translation vector.
--
--```plaintext
--Params: translation - The offset in space to move the plane with.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param translation UnityEngine.Vector3
function CS.UnityEngine.Plane.Translate(translation) end

--
--The translated plane.
--
--```plaintext
--Params: plane - The plane to move in space.
--        translation - The offset in space to move the plane with.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param plane UnityEngine.Plane
---@param translation UnityEngine.Vector3
---@return Plane
function CS.UnityEngine.Plane:Translate(plane, translation) end

--
--A point on the plane that is closest to point.
--
--```plaintext
--Params: point - The point to project onto the plane.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param point UnityEngine.Vector3
---@return Vector3
function CS.UnityEngine.Plane.ClosestPointOnPlane(point) end

--
--Returns a signed distance from plane to point.
--
---@source UnityEngine.CoreModule.dll
---@param point UnityEngine.Vector3
---@return Single
function CS.UnityEngine.Plane.GetDistanceToPoint(point) end

--
--Is a point on the positive side of the plane?
--
---@source UnityEngine.CoreModule.dll
---@param point UnityEngine.Vector3
---@return Boolean
function CS.UnityEngine.Plane.GetSide(point) end

--
--Are two points on the same side of the plane?
--
---@source UnityEngine.CoreModule.dll
---@param inPt0 UnityEngine.Vector3
---@param inPt1 UnityEngine.Vector3
---@return Boolean
function CS.UnityEngine.Plane.SameSide(inPt0, inPt1) end

---@source UnityEngine.CoreModule.dll
---@param ray UnityEngine.Ray
---@param enter float
---@return Boolean
function CS.UnityEngine.Plane.Raycast(ray, enter) end

---@source UnityEngine.CoreModule.dll
---@return String
function CS.UnityEngine.Plane.ToString() end

---@source UnityEngine.CoreModule.dll
---@param format string
---@return String
function CS.UnityEngine.Plane.ToString(format) end

---@source UnityEngine.CoreModule.dll
---@param format string
---@param formatProvider System.IFormatProvider
---@return String
function CS.UnityEngine.Plane.ToString(format, formatProvider) end


--
--Representation of rays.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.Ray: System.ValueType
--
--The origin point of the ray.
--
---@source UnityEngine.CoreModule.dll
---@field origin UnityEngine.Vector3
--
--The direction of the ray.
--
---@source UnityEngine.CoreModule.dll
---@field direction UnityEngine.Vector3
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.Ray = {}

--
--Returns a point at distance units along the ray.
--
---@source UnityEngine.CoreModule.dll
---@param distance float
---@return Vector3
function CS.UnityEngine.Ray.GetPoint(distance) end

--
--Returns a formatted string for this ray.
--
--```plaintext
--Params: format - A numeric format string.
--        formatProvider - An object that specifies culture-specific formatting.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@return String
function CS.UnityEngine.Ray.ToString() end

--
--Returns a formatted string for this ray.
--
--```plaintext
--Params: format - A numeric format string.
--        formatProvider - An object that specifies culture-specific formatting.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param format string
---@return String
function CS.UnityEngine.Ray.ToString(format) end

--
--Returns a formatted string for this ray.
--
--```plaintext
--Params: format - A numeric format string.
--        formatProvider - An object that specifies culture-specific formatting.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param format string
---@param formatProvider System.IFormatProvider
---@return String
function CS.UnityEngine.Ray.ToString(format, formatProvider) end


--
--A ray in 2D space.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.Ray2D: System.ValueType
--
--The starting point of the ray in world space.
--
---@source UnityEngine.CoreModule.dll
---@field origin UnityEngine.Vector2
--
--The direction of the ray in world space.
--
---@source UnityEngine.CoreModule.dll
---@field direction UnityEngine.Vector2
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.Ray2D = {}

--
--Get a point that lies a given distance along a ray.
--
--```plaintext
--Params: distance - Distance of the desired point along the path of the ray.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param distance float
---@return Vector2
function CS.UnityEngine.Ray2D.GetPoint(distance) end

--
--Returns a formatted string for this 2D ray.
--
--```plaintext
--Params: format - A numeric format string.
--        formatProvider - An object that specifies culture-specific formatting.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@return String
function CS.UnityEngine.Ray2D.ToString() end

--
--Returns a formatted string for this 2D ray.
--
--```plaintext
--Params: format - A numeric format string.
--        formatProvider - An object that specifies culture-specific formatting.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param format string
---@return String
function CS.UnityEngine.Ray2D.ToString(format) end

--
--Returns a formatted string for this 2D ray.
--
--```plaintext
--Params: format - A numeric format string.
--        formatProvider - An object that specifies culture-specific formatting.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param format string
---@param formatProvider System.IFormatProvider
---@return String
function CS.UnityEngine.Ray2D.ToString(format, formatProvider) end


--
--A 2D Rectangle defined by X and Y position, width and height.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.Rect: System.ValueType
--
--Shorthand for writing new Rect(0,0,0,0).
--
---@source UnityEngine.CoreModule.dll
---@field zero UnityEngine.Rect
--
--The X coordinate of the rectangle.
--
---@source UnityEngine.CoreModule.dll
---@field x float
--
--The Y coordinate of the rectangle.
--
---@source UnityEngine.CoreModule.dll
---@field y float
--
--The X and Y position of the rectangle.
--
---@source UnityEngine.CoreModule.dll
---@field position UnityEngine.Vector2
--
--The position of the center of the rectangle.
--
---@source UnityEngine.CoreModule.dll
---@field center UnityEngine.Vector2
--
--The position of the minimum corner of the rectangle.
--
---@source UnityEngine.CoreModule.dll
---@field min UnityEngine.Vector2
--
--The position of the maximum corner of the rectangle.
--
---@source UnityEngine.CoreModule.dll
---@field max UnityEngine.Vector2
--
--The width of the rectangle, measured from the X position.
--
---@source UnityEngine.CoreModule.dll
---@field width float
--
--The height of the rectangle, measured from the Y position.
--
---@source UnityEngine.CoreModule.dll
---@field height float
--
--The width and height of the rectangle.
--
---@source UnityEngine.CoreModule.dll
---@field size UnityEngine.Vector2
--
--The minimum X coordinate of the rectangle.
--
---@source UnityEngine.CoreModule.dll
---@field xMin float
--
--The minimum Y coordinate of the rectangle.
--
---@source UnityEngine.CoreModule.dll
---@field yMin float
--
--The maximum X coordinate of the rectangle.
--
---@source UnityEngine.CoreModule.dll
---@field xMax float
--
--The maximum Y coordinate of the rectangle.
--
---@source UnityEngine.CoreModule.dll
---@field yMax float
---@source UnityEngine.CoreModule.dll
---@field left float
---@source UnityEngine.CoreModule.dll
---@field right float
---@source UnityEngine.CoreModule.dll
---@field top float
---@source UnityEngine.CoreModule.dll
---@field bottom float
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.Rect = {}

--
--A rectangle matching the specified coordinates.
--
--```plaintext
--Params: xmin - The minimum X coordinate.
--        ymin - The minimum Y coordinate.
--        xmax - The maximum X coordinate.
--        ymax - The maximum Y coordinate.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param xmin float
---@param ymin float
---@param xmax float
---@param ymax float
---@return Rect
function CS.UnityEngine.Rect:MinMaxRect(xmin, ymin, xmax, ymax) end

--
--Set components of an existing Rect.
--
---@source UnityEngine.CoreModule.dll
---@param x float
---@param y float
---@param width float
---@param height float
function CS.UnityEngine.Rect.Set(x, y, width, height) end

--
--True if the point lies within the specified rectangle.
--
--```plaintext
--Params: point - Point to test.
--        allowInverse - Does the test allow the Rect's width and height to be negative?
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param point UnityEngine.Vector2
---@return Boolean
function CS.UnityEngine.Rect.Contains(point) end

--
--True if the point lies within the specified rectangle.
--
--```plaintext
--Params: point - Point to test.
--        allowInverse - Does the test allow the Rect's width and height to be negative?
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param point UnityEngine.Vector3
---@return Boolean
function CS.UnityEngine.Rect.Contains(point) end

--
--True if the point lies within the specified rectangle.
--
--```plaintext
--Params: point - Point to test.
--        allowInverse - Does the test allow the Rect's width and height to be negative?
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param point UnityEngine.Vector3
---@param allowInverse bool
---@return Boolean
function CS.UnityEngine.Rect.Contains(point, allowInverse) end

--
--Returns true if the other rectangle overlaps this one. If allowInverse is present and true, the widths and heights of the Rects are allowed to take negative values (ie, the min value is greater than the max), and the test will still work.
--
--```plaintext
--Params: other - Other rectangle to test overlapping with.
--        allowInverse - Does the test allow the widths and heights of the Rects to be negative?
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param other UnityEngine.Rect
---@return Boolean
function CS.UnityEngine.Rect.Overlaps(other) end

--
--Returns true if the other rectangle overlaps this one. If allowInverse is present and true, the widths and heights of the Rects are allowed to take negative values (ie, the min value is greater than the max), and the test will still work.
--
--```plaintext
--Params: other - Other rectangle to test overlapping with.
--        allowInverse - Does the test allow the widths and heights of the Rects to be negative?
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param other UnityEngine.Rect
---@param allowInverse bool
---@return Boolean
function CS.UnityEngine.Rect.Overlaps(other, allowInverse) end

--
--Returns a point inside a rectangle, given normalized coordinates.
--
--```plaintext
--Params: rectangle - Rectangle to get a point inside.
--        normalizedRectCoordinates - Normalized coordinates to get a point for.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param rectangle UnityEngine.Rect
---@param normalizedRectCoordinates UnityEngine.Vector2
---@return Vector2
function CS.UnityEngine.Rect:NormalizedToPoint(rectangle, normalizedRectCoordinates) end

--
--Returns the normalized coordinates cooresponding the the point.
--
--```plaintext
--Params: rectangle - Rectangle to get normalized coordinates inside.
--        point - A point inside the rectangle to get normalized coordinates for.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param rectangle UnityEngine.Rect
---@param point UnityEngine.Vector2
---@return Vector2
function CS.UnityEngine.Rect:PointToNormalized(rectangle, point) end

---@source UnityEngine.CoreModule.dll
---@param lhs UnityEngine.Rect
---@param rhs UnityEngine.Rect
---@return Boolean
function CS.UnityEngine.Rect:op_Inequality(lhs, rhs) end

---@source UnityEngine.CoreModule.dll
---@param lhs UnityEngine.Rect
---@param rhs UnityEngine.Rect
---@return Boolean
function CS.UnityEngine.Rect:op_Equality(lhs, rhs) end

---@source UnityEngine.CoreModule.dll
---@return Int32
function CS.UnityEngine.Rect.GetHashCode() end

---@source UnityEngine.CoreModule.dll
---@param other object
---@return Boolean
function CS.UnityEngine.Rect.Equals(other) end

---@source UnityEngine.CoreModule.dll
---@param other UnityEngine.Rect
---@return Boolean
function CS.UnityEngine.Rect.Equals(other) end

--
--Returns a formatted string for this Rect.
--
--```plaintext
--Params: format - A numeric format string.
--        formatProvider - An object that specifies culture-specific formatting.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@return String
function CS.UnityEngine.Rect.ToString() end

--
--Returns a formatted string for this Rect.
--
--```plaintext
--Params: format - A numeric format string.
--        formatProvider - An object that specifies culture-specific formatting.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param format string
---@return String
function CS.UnityEngine.Rect.ToString(format) end

--
--Returns a formatted string for this Rect.
--
--```plaintext
--Params: format - A numeric format string.
--        formatProvider - An object that specifies culture-specific formatting.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param format string
---@param formatProvider System.IFormatProvider
---@return String
function CS.UnityEngine.Rect.ToString(format, formatProvider) end


--
--A 2D Rectangle defined by x, y, width, height with integers.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.RectInt: System.ValueType
--
--Left coordinate of the rectangle.
--
---@source UnityEngine.CoreModule.dll
---@field x int
--
--Top coordinate of the rectangle.
--
---@source UnityEngine.CoreModule.dll
---@field y int
--
--Center coordinate of the rectangle.
--
---@source UnityEngine.CoreModule.dll
---@field center UnityEngine.Vector2
--
--The lower left corner of the rectangle; which is the minimal position of the rectangle along the x- and y-axes, when it is aligned to both axes.
--
---@source UnityEngine.CoreModule.dll
---@field min UnityEngine.Vector2Int
--
--The upper right corner of the rectangle; which is the maximal position of the rectangle along the x- and y-axes, when it is aligned to both axes.
--
---@source UnityEngine.CoreModule.dll
---@field max UnityEngine.Vector2Int
--
--Width of the rectangle.
--
---@source UnityEngine.CoreModule.dll
---@field width int
--
--Height of the rectangle.
--
---@source UnityEngine.CoreModule.dll
---@field height int
--
--Shows the minimum X value of the RectInt.
--
---@source UnityEngine.CoreModule.dll
---@field xMin int
--
--Show the minimum Y value of the RectInt.
--
---@source UnityEngine.CoreModule.dll
---@field yMin int
--
--Shows the maximum X value of the RectInt.
--
---@source UnityEngine.CoreModule.dll
---@field xMax int
--
--Shows the maximum Y value of the RectInt.
--
---@source UnityEngine.CoreModule.dll
---@field yMax int
--
--Returns the position (x, y) of the RectInt.
--
---@source UnityEngine.CoreModule.dll
---@field position UnityEngine.Vector2Int
--
--Returns the width and height of the RectInt.
--
---@source UnityEngine.CoreModule.dll
---@field size UnityEngine.Vector2Int
--
--A RectInt.PositionCollection that contains all positions within the RectInt.
--
---@source UnityEngine.CoreModule.dll
---@field allPositionsWithin UnityEngine.RectInt.PositionEnumerator
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.RectInt = {}

--
--Sets the bounds to the min and max value of the rect.
--
---@source UnityEngine.CoreModule.dll
---@param minPosition UnityEngine.Vector2Int
---@param maxPosition UnityEngine.Vector2Int
function CS.UnityEngine.RectInt.SetMinMax(minPosition, maxPosition) end

--
--Clamps the position and size of the RectInt to the given bounds.
--
--```plaintext
--Params: bounds - Bounds to clamp the RectInt.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param bounds UnityEngine.RectInt
function CS.UnityEngine.RectInt.ClampToBounds(bounds) end

--
--Whether the position is within the RectInt.
--
--```plaintext
--Params: position - Position to check.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param position UnityEngine.Vector2Int
---@return Boolean
function CS.UnityEngine.RectInt.Contains(position) end

--
--True if the other rectangle overlaps this one.
--
--```plaintext
--Params: other - Other rectangle to test overlapping with.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param other UnityEngine.RectInt
---@return Boolean
function CS.UnityEngine.RectInt.Overlaps(other) end

--
--Returns the x, y, width and height of the RectInt.
--
--```plaintext
--Params: format - A numeric format string.
--        formatProvider - An object that specifies culture-specific formatting.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@return String
function CS.UnityEngine.RectInt.ToString() end

--
--Returns the x, y, width and height of the RectInt.
--
--```plaintext
--Params: format - A numeric format string.
--        formatProvider - An object that specifies culture-specific formatting.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param format string
---@return String
function CS.UnityEngine.RectInt.ToString(format) end

--
--Returns the x, y, width and height of the RectInt.
--
--```plaintext
--Params: format - A numeric format string.
--        formatProvider - An object that specifies culture-specific formatting.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param format string
---@param formatProvider System.IFormatProvider
---@return String
function CS.UnityEngine.RectInt.ToString(format, formatProvider) end

--
--Returns true if the given RectInt is equal to this RectInt.
--
---@source UnityEngine.CoreModule.dll
---@param other UnityEngine.RectInt
---@return Boolean
function CS.UnityEngine.RectInt.Equals(other) end


--
--An iterator that allows you to iterate over all positions within the RectInt.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.PositionEnumerator: System.ValueType
--
--Current position of the enumerator.
--
---@source UnityEngine.CoreModule.dll
---@field Current UnityEngine.Vector2Int
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.PositionEnumerator = {}

--
--This RectInt.PositionEnumerator.
--
---@source UnityEngine.CoreModule.dll
---@return PositionEnumerator
function CS.UnityEngine.PositionEnumerator.GetEnumerator() end

--
--Whether the enumerator has successfully moved to the next position.
--
---@source UnityEngine.CoreModule.dll
---@return Boolean
function CS.UnityEngine.PositionEnumerator.MoveNext() end

--
--Resets this enumerator to its starting state.
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.PositionEnumerator.Reset() end


--
--Offsets for rectangles, borders, etc.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.RectOffset: object
--
--Left edge size.
--
---@source UnityEngine.CoreModule.dll
---@field left int
--
--Right edge size.
--
---@source UnityEngine.CoreModule.dll
---@field right int
--
--Top edge size.
--
---@source UnityEngine.CoreModule.dll
---@field top int
--
--Bottom edge size.
--
---@source UnityEngine.CoreModule.dll
---@field bottom int
--
--Shortcut for left + right. (Read Only)
--
---@source UnityEngine.CoreModule.dll
---@field horizontal int
--
--Shortcut for top + bottom. (Read Only)
--
---@source UnityEngine.CoreModule.dll
---@field vertical int
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.RectOffset = {}

--
--Returns a formatted string for this RectOffset.
--
--```plaintext
--Params: format - A numeric format string.
--        formatProvider - An object that specifies culture-specific formatting.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@return String
function CS.UnityEngine.RectOffset.ToString() end

--
--Returns a formatted string for this RectOffset.
--
--```plaintext
--Params: format - A numeric format string.
--        formatProvider - An object that specifies culture-specific formatting.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param format string
---@return String
function CS.UnityEngine.RectOffset.ToString(format) end

--
--Returns a formatted string for this RectOffset.
--
--```plaintext
--Params: format - A numeric format string.
--        formatProvider - An object that specifies culture-specific formatting.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param format string
---@param formatProvider System.IFormatProvider
---@return String
function CS.UnityEngine.RectOffset.ToString(format, formatProvider) end

--
--Add the border offsets to a rect.
--
---@source UnityEngine.CoreModule.dll
---@param rect UnityEngine.Rect
---@return Rect
function CS.UnityEngine.RectOffset.Add(rect) end

--
--Remove the border offsets from a rect.
--
---@source UnityEngine.CoreModule.dll
---@param rect UnityEngine.Rect
---@return Rect
function CS.UnityEngine.RectOffset.Remove(rect) end


--
--Allows to control the dynamic Global Illumination.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.DynamicGI: object
--
--Allows for scaling the contribution coming from realtime & baked lightmaps.
--
--Note: this value can be set in the Lighting Window UI and it is serialized, that is not the case for other properties in this class.
--
---@source UnityEngine.CoreModule.dll
---@field indirectScale float
--
--Determines the percentage change in lighting intensity that triggers Unity to recalculate the real-time lightmap.
--
---@source UnityEngine.CoreModule.dll
---@field updateThreshold float
--
--The number of milliseconds that can be spent on material updates.
--
---@source UnityEngine.CoreModule.dll
---@field materialUpdateTimeSlice int
--
--When enabled, new dynamic Global Illumination output is shown in each frame.
--
---@source UnityEngine.CoreModule.dll
---@field synchronousMode bool
--
--Is precomputed realtime Global Illumination output converged?
--
---@source UnityEngine.CoreModule.dll
---@field isConverged bool
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.DynamicGI = {}

--
--Allows to set an emissive color for a given renderer quickly, without the need to render the emissive input for the entire system.
--
--```plaintext
--Params: renderer - The Renderer that should get a new color.
--        color - The emissive Color.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param renderer UnityEngine.Renderer
---@param color UnityEngine.Color
function CS.UnityEngine.DynamicGI:SetEmissive(renderer, color) end

--
--Allows overriding the distant environment lighting for Realtime GI, without changing the Skybox Material.
--
--```plaintext
--Params: input - Array of float values to be used for Realtime GI environment lighting.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param input float[]
function CS.UnityEngine.DynamicGI:SetEnvironmentData(input) end

--
--Schedules an update of the environment texture.
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.DynamicGI:UpdateEnvironment() end

--
--Schedules an update of the albedo and emissive textures of a system that contains the renderer or the terrain.
--
--```plaintext
--Params: renderer - The Renderer to use when searching for a system to update.
--        terrain - The Terrain to use when searching for systems to update.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param renderer UnityEngine.Renderer
function CS.UnityEngine.DynamicGI:UpdateMaterials(renderer) end

---@source UnityEngine.CoreModule.dll
---@param renderer UnityEngine.Object
function CS.UnityEngine.DynamicGI:UpdateMaterials(renderer) end

---@source UnityEngine.CoreModule.dll
---@param renderer UnityEngine.Object
---@param x int
---@param y int
---@param width int
---@param height int
function CS.UnityEngine.DynamicGI:UpdateMaterials(renderer, x, y, width, height) end


--
--An object containing settings for precomputing lighting data, that Unity can serialize as a.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.LightingSettings: UnityEngine.Object
--
--Whether to enable the Baked Global Illumination system for this Scene.
--
---@source UnityEngine.CoreModule.dll
---@field bakedGI bool
--
--Whether to enable the Realtime Global Illumination system for this Scene.
--
---@source UnityEngine.CoreModule.dll
---@field realtimeGI bool
--
--Determines the lightmap that Unity stores environment lighting in.
--
---@source UnityEngine.CoreModule.dll
---@field realtimeEnvironmentLighting bool
--
--Whether the Unity Editor automatically precomputes lighting data when the Scene data changes. (Editor only).
--
---@source UnityEngine.CoreModule.dll
---@field autoGenerate bool
--
--Sets the MixedLightingMode that Unity uses for all Mixed Lights in the Scene. (Editor only).
--
---@source UnityEngine.CoreModule.dll
---@field mixedBakeMode UnityEngine.MixedLightingMode
--
--The intensity of surface albedo throughout the Scene when considered in lighting calculations. This value influences the energy of light at each bounce. (Editor only).
--
---@source UnityEngine.CoreModule.dll
---@field albedoBoost float
--
--Multiplies the intensity of of indirect lighting in lightmaps. (Editor only).
--
---@source UnityEngine.CoreModule.dll
---@field indirectScale float
--
--Determines which backend to use for baking lightmaps in the Baked Global Illumination system. (Editor only).
--
---@source UnityEngine.CoreModule.dll
---@field lightmapper UnityEngine.LightingSettings.Lightmapper
--
--The maximum size in pixels of an individual lightmap texture. (Editor only).
--
---@source UnityEngine.CoreModule.dll
---@field lightmapMaxSize int
--
--Defines the number of texels to use per world unit when generating lightmaps.
--
---@source UnityEngine.CoreModule.dll
---@field lightmapResolution float
--
--Sets the distance (in texels) between separate UV tiles in lightmaps. (Editor only).
--
---@source UnityEngine.CoreModule.dll
---@field lightmapPadding int
--
--Whether to compress the lightmap textures that the Progressive Lightmapper generates. (Editor only)
--
---@source UnityEngine.CoreModule.dll
---@field compressLightmaps bool
--
--Whether to apply ambient occlusion to lightmaps. (Editor only).
--
---@source UnityEngine.CoreModule.dll
---@field ao bool
--
--The distance that a ray travels before Unity considers it to be unoccluded when calculating ambient occlusion in lightmaps. (Editor only).
--
---@source UnityEngine.CoreModule.dll
---@field aoMaxDistance float
--
--Sets the contrast of ambient occlusion that Unity applies to indirect lighting in lightmaps. (Editor only).
--
---@source UnityEngine.CoreModule.dll
---@field aoExponentIndirect float
--
--Determines the degree to which direct lighting is considered when calculating ambient occlusion in lightmaps. (Editor only).
--
---@source UnityEngine.CoreModule.dll
---@field aoExponentDirect float
--
--Whether the Progressive Lightmapper extracts Ambient Occlusion to a separate lightmap. (Editor only).
--
---@source UnityEngine.CoreModule.dll
---@field extractAO bool
--
--Determines whether the lightmapper should generate directional or non-directional lightmaps. (Editor only).
--
---@source UnityEngine.CoreModule.dll
---@field directionalityMode UnityEngine.LightmapsMode
--
--Whether the Progressive Lightmapper exports machine learning training data to the Project folder when it performs the bake. ( Editor only).
--
---@source UnityEngine.CoreModule.dll
---@field exportTrainingData bool
--
--Determines the name of the destination folder for the exported textures. (Editor only).
--
---@source UnityEngine.CoreModule.dll
---@field trainingDataDestination string
--
--Defines the number of texels that Enlighten uses per world unit when calculating indirect lighting. (Editor only).
--
---@source UnityEngine.CoreModule.dll
---@field indirectResolution float
--
--Specifies whether the Editor calculates the final global illumination light bounce at the same resolution as the baked lightmap.
--
---@source UnityEngine.CoreModule.dll
---@field finalGather bool
--
--Controls the number of rays emitted for every final gather point. A final gather point is a lightmap texel in the final, composited lightmap. (Editor only).
--
---@source UnityEngine.CoreModule.dll
---@field finalGatherRayCount float
--
--Controls whether a denoising filter is applied to the final gather output.
--
---@source UnityEngine.CoreModule.dll
---@field finalGatherFiltering bool
---@source UnityEngine.CoreModule.dll
---@field sampling UnityEngine.LightingSettings.Sampling
--
--Specifies the number of samples the Progressive Lightmapper uses for direct lighting calculations. (Editor only).
--
---@source UnityEngine.CoreModule.dll
---@field directSampleCount int
--
--Specifies the number of samples the Progressive Lightmapper uses for indirect lighting calculations. (Editor only).
--
---@source UnityEngine.CoreModule.dll
---@field indirectSampleCount int
--
--This property is now obsolete. Use LightingSettings.maxBounces.
--
---@source UnityEngine.CoreModule.dll
---@field bounces int
--
--Stores the maximum number of bounces the Progressive Lightmapper computes for indirect lighting. (Editor only)
--
---@source UnityEngine.CoreModule.dll
---@field maxBounces int
--
--This property is now obsolete. Use LightingSettings.minBounces.
--
---@source UnityEngine.CoreModule.dll
---@field russianRouletteStartBounce int
--
--Stores the minimum number of bounces the Progressive Lightmapper computes for indirect lighting. (Editor only)
--
---@source UnityEngine.CoreModule.dll
---@field minBounces int
--
--Whether the Progressive Lightmapper prioritizes baking visible texels within the frustum of the Scene view. (Editor only).
--
---@source UnityEngine.CoreModule.dll
---@field prioritizeView bool
--
--Specifies the filter type that the Progressive Lightmapper uses for ambient occlusion. (Editor only).
--
---@source UnityEngine.CoreModule.dll
---@field filteringMode UnityEngine.LightingSettings.FilterMode
--
--Determines the denoiser that the Progressive Lightmapper applies to direct lighting. (Editor only).
--
---@source UnityEngine.CoreModule.dll
---@field denoiserTypeDirect UnityEngine.LightingSettings.DenoiserType
--
--Determines the denoiser that the Progressive Lightmapper applies to indirect lighting. (Editor only).
--
---@source UnityEngine.CoreModule.dll
---@field denoiserTypeIndirect UnityEngine.LightingSettings.DenoiserType
--
--Determines the type of denoising that the Progressive Lightmapper applies to ambient occlusion in lightmaps. (Editor only).
--
---@source UnityEngine.CoreModule.dll
---@field denoiserTypeAO UnityEngine.LightingSettings.DenoiserType
--
--Specifies the filter kernel that the Progressive Lightmapper uses for the direct lighting. (Editor only).
--
---@source UnityEngine.CoreModule.dll
---@field filterTypeDirect UnityEngine.LightingSettings.FilterType
--
--Specifies the filter kernel that the Progressive Lightmapper uses for indirect lighting. (Editor only).
--
---@source UnityEngine.CoreModule.dll
---@field filterTypeIndirect UnityEngine.LightingSettings.FilterType
--
--Specifies the filter kernel that the Progressive Lightmapper uses for ambient occlusion. (Editor only).
--
---@source UnityEngine.CoreModule.dll
---@field filterTypeAO UnityEngine.LightingSettings.FilterType
--
--Specifies the radius the Progressive Lightmapper used to filter the indirect lighting component of the lightmap when using Gaussian filter. (Editor only).
--
---@source UnityEngine.CoreModule.dll
---@field filteringGaussRadiusDirect int
--
--Specifies the method used by the Progressive Lightmapper to reduce noise in lightmaps. (Editor only).
--
---@source UnityEngine.CoreModule.dll
---@field filteringGaussRadiusIndirect int
--
--Specifies the radius the Progressive Lightmapper uses to filter the direct lighting component of the lightmap when using Gaussian filter. (Editor only).
--
---@source UnityEngine.CoreModule.dll
---@field filteringGaussRadiusAO int
--
--Specifies the threshold the Progressive Lightmapper uses to filter the indirect lighting component of the lightmap when using the A-Trous filter. (Editor only).
--
---@source UnityEngine.CoreModule.dll
---@field filteringAtrousPositionSigmaDirect float
--
--Specifies the radius the Progressive Lightmapper uses to filter the ambient occlusion component in the lightmap when using Gaussian filter. (Editor only).
--
---@source UnityEngine.CoreModule.dll
---@field filteringAtrousPositionSigmaIndirect float
--
--Specifies the threshold the Progressive Lightmapper uses to filter direct light stored in the lightmap when using the A-Trous filter. (Editor only).
--
---@source UnityEngine.CoreModule.dll
---@field filteringAtrousPositionSigmaAO float
--
--Specifies the number of samples the Progressive Lightmapper uses when sampling indirect lighting from the skybox. (Editor only).
--
---@source UnityEngine.CoreModule.dll
---@field environmentSampleCount int
--
--Specifies the number of samples to use for Light Probes relative to the number of samples for lightmap texels. (Editor only).
--
---@source UnityEngine.CoreModule.dll
---@field lightProbeSampleCountMultiplier float
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.LightingSettings = {}


--
--Backends available for baking lighting.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.Lightmapper: System.Enum
--
--Backend for baking lighting with Enlighten Baked Global Illumination, based on the Enlighten radiosity middleware.
--
---@source UnityEngine.CoreModule.dll
---@field Enlighten UnityEngine.LightingSettings.Lightmapper
--
--Backend for baking lighting using the CPU. Uses a progressive path tracing algorithm.
--
---@source UnityEngine.CoreModule.dll
---@field ProgressiveCPU UnityEngine.LightingSettings.Lightmapper
--
--Backend for baking lighting using the GPU. Uses a progressive path tracing algorithm.
--
---@source UnityEngine.CoreModule.dll
---@field ProgressiveGPU UnityEngine.LightingSettings.Lightmapper
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.Lightmapper = {}

---@source 
---@param value any
---@return UnityEngine.LightingSettings.Lightmapper
function CS.UnityEngine.Lightmapper:__CastFrom(value) end


--
--Enum used to specify how the sensor gate (sensor frame) defined by Camera.sensorSize fits into the resolution gate (render frame).
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.GateFitMode: System.Enum
--
--Fit the resolution gate vertically within the sensor gate.
--
---@source UnityEngine.CoreModule.dll
---@field Vertical UnityEngine.Camera.GateFitMode
--
--Fit the resolution gate horizontally within the sensor gate.
--
---@source UnityEngine.CoreModule.dll
---@field Horizontal UnityEngine.Camera.GateFitMode
--
--Automatically selects a horizontal or vertical fit so that the sensor gate fits completely inside the resolution gate.
--
---@source UnityEngine.CoreModule.dll
---@field Fill UnityEngine.Camera.GateFitMode
--
--Automatically selects a horizontal or vertical fit so that the render frame fits completely inside the resolution gate.
--
---@source UnityEngine.CoreModule.dll
---@field Overscan UnityEngine.Camera.GateFitMode
--
--Stretch the sensor gate to fit exactly into the resolution gate.
--
---@source UnityEngine.CoreModule.dll
---@field None UnityEngine.Camera.GateFitMode
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.GateFitMode = {}

---@source 
---@param value any
---@return UnityEngine.Camera.GateFitMode
function CS.UnityEngine.GateFitMode:__CastFrom(value) end


---@source UnityEngine.CoreModule.dll
---@class UnityEngine.Sampling: System.Enum
---@source UnityEngine.CoreModule.dll
---@field Auto UnityEngine.LightingSettings.Sampling
---@source UnityEngine.CoreModule.dll
---@field Fixed UnityEngine.LightingSettings.Sampling
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.Sampling = {}

---@source 
---@param value any
---@return UnityEngine.LightingSettings.Sampling
function CS.UnityEngine.Sampling:__CastFrom(value) end


--
--The available filtering modes for the Progressive Lightmapper.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.FilterMode: System.Enum
--
--No filtering.
--
---@source UnityEngine.CoreModule.dll
---@field None UnityEngine.LightingSettings.FilterMode
--
--The filtering is configured automatically.
--
---@source UnityEngine.CoreModule.dll
---@field Auto UnityEngine.LightingSettings.FilterMode
--
--When enabled, you can configure the filtering settings for the Progressive Lightmapper. When disabled, the default filtering settings apply.
--
---@source UnityEngine.CoreModule.dll
---@field Advanced UnityEngine.LightingSettings.FilterMode
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.FilterMode = {}

---@source 
---@param value any
---@return UnityEngine.LightingSettings.FilterMode
function CS.UnityEngine.FilterMode:__CastFrom(value) end


--
--Enumerates which axis to use when expressing the value for the field of view.
--                The default value is Camera.FieldOfViewAxis.Vertical.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.FieldOfViewAxis: System.Enum
--
--Specifies the field of view as vertical.
--
---@source UnityEngine.CoreModule.dll
---@field Vertical UnityEngine.Camera.FieldOfViewAxis
--
--Specifies the field of view as horizontal.
--
---@source UnityEngine.CoreModule.dll
---@field Horizontal UnityEngine.Camera.FieldOfViewAxis
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.FieldOfViewAxis = {}

---@source 
---@param value any
---@return UnityEngine.Camera.FieldOfViewAxis
function CS.UnityEngine.FieldOfViewAxis:__CastFrom(value) end


--
--The available denoisers for the Progressive Lightmapper.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.DenoiserType: System.Enum
--
--Use this to disable denoising for the lightmap.
--
---@source UnityEngine.CoreModule.dll
---@field None UnityEngine.LightingSettings.DenoiserType
--
--NVIDIA Optix Denoiser.
--
---@source UnityEngine.CoreModule.dll
---@field Optix UnityEngine.LightingSettings.DenoiserType
--
--Intel Open Image Denoiser.
--
---@source UnityEngine.CoreModule.dll
---@field OpenImage UnityEngine.LightingSettings.DenoiserType
--
--RadeonPro Denoiser.
--
---@source UnityEngine.CoreModule.dll
---@field RadeonPro UnityEngine.LightingSettings.DenoiserType
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.DenoiserType = {}

---@source 
---@param value any
---@return UnityEngine.LightingSettings.DenoiserType
function CS.UnityEngine.DenoiserType:__CastFrom(value) end


--
--Wrapper for gate fit parameters
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.GateFitParameters: System.ValueType
--
--GateFitMode to use. See Camera.GateFitMode.
--
---@source UnityEngine.CoreModule.dll
---@field mode UnityEngine.Camera.GateFitMode
--
--Aspect ratio of the resolution gate.
--
---@source UnityEngine.CoreModule.dll
---@field aspect float
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.GateFitParameters = {}


--
--The available filter kernels for the Progressive Lightmapper.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.FilterType: System.Enum
--
--When enabled, the lightmap uses a Gaussian filter.
--
---@source UnityEngine.CoreModule.dll
---@field Gaussian UnityEngine.LightingSettings.FilterType
--
--When enabled, the lightmap uses an A-Trous filter.
--
---@source UnityEngine.CoreModule.dll
---@field ATrous UnityEngine.LightingSettings.FilterType
--
--When enabled, the lightmap uses no filtering.
--
---@source UnityEngine.CoreModule.dll
---@field None UnityEngine.LightingSettings.FilterType
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.FilterType = {}

---@source 
---@param value any
---@return UnityEngine.LightingSettings.FilterType
function CS.UnityEngine.FilterType:__CastFrom(value) end


--
--Enum used to specify either the left or the right eye of a stereoscopic camera.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.StereoscopicEye: System.Enum
--
--Specifies the target to be the left eye.
--
---@source UnityEngine.CoreModule.dll
---@field Left UnityEngine.Camera.StereoscopicEye
--
--Specifies the target to be the right eye.
--
---@source UnityEngine.CoreModule.dll
---@field Right UnityEngine.Camera.StereoscopicEye
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.StereoscopicEye = {}

---@source 
---@param value any
---@return UnityEngine.Camera.StereoscopicEye
function CS.UnityEngine.StereoscopicEye:__CastFrom(value) end


--
--Gizmos are used to give visual debugging or setup aids in the Scene view.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.Gizmos: object
--
--Sets the color for the gizmos that will be drawn next.
--
---@source UnityEngine.CoreModule.dll
---@field color UnityEngine.Color
--
--Sets the Matrix4x4 that the Unity Editor uses to draw Gizmos.
--
---@source UnityEngine.CoreModule.dll
---@field matrix UnityEngine.Matrix4x4
--
--Set a texture that contains the exposure correction for LightProbe gizmos. The value is sampled from the red channel in the middle of the texture.
--
---@source UnityEngine.CoreModule.dll
---@field exposure UnityEngine.Texture
--
--Set a scale for Light Probe gizmos. This scale will be used to render the spherical harmonic preview spheres.
--
---@source UnityEngine.CoreModule.dll
---@field probeSize float
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.Gizmos = {}

--
--Draws a line starting at from towards to.
--
---@source UnityEngine.CoreModule.dll
---@param from UnityEngine.Vector3
---@param to UnityEngine.Vector3
function CS.UnityEngine.Gizmos:DrawLine(from, to) end

--
--Draws a wireframe sphere with center and radius.
--
---@source UnityEngine.CoreModule.dll
---@param center UnityEngine.Vector3
---@param radius float
function CS.UnityEngine.Gizmos:DrawWireSphere(center, radius) end

--
--Draws a solid sphere with center and radius.
--
---@source UnityEngine.CoreModule.dll
---@param center UnityEngine.Vector3
---@param radius float
function CS.UnityEngine.Gizmos:DrawSphere(center, radius) end

--
--Draw a wireframe box with center and size.
--
---@source UnityEngine.CoreModule.dll
---@param center UnityEngine.Vector3
---@param size UnityEngine.Vector3
function CS.UnityEngine.Gizmos:DrawWireCube(center, size) end

--
--Draw a solid box with center and size.
--
---@source UnityEngine.CoreModule.dll
---@param center UnityEngine.Vector3
---@param size UnityEngine.Vector3
function CS.UnityEngine.Gizmos:DrawCube(center, size) end

--
--Draws a mesh.
--
--```plaintext
--Params: mesh - Mesh to draw as a gizmo.
--        position - Position (default is zero).
--        rotation - Rotation (default is no rotation).
--        scale - Scale (default is no scale).
--        submeshIndex - Submesh to draw (default is -1, which draws whole mesh).
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param submeshIndex int
---@param position UnityEngine.Vector3
---@param rotation UnityEngine.Quaternion
---@param scale UnityEngine.Vector3
function CS.UnityEngine.Gizmos:DrawMesh(mesh, submeshIndex, position, rotation, scale) end

--
--Draws a wireframe mesh.
--
--```plaintext
--Params: mesh - Mesh to draw as a gizmo.
--        position - Position (default is zero).
--        rotation - Rotation (default is no rotation).
--        scale - Scale (default is no scale).
--        submeshIndex - Submesh to draw (default is -1, which draws whole mesh).
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param submeshIndex int
---@param position UnityEngine.Vector3
---@param rotation UnityEngine.Quaternion
---@param scale UnityEngine.Vector3
function CS.UnityEngine.Gizmos:DrawWireMesh(mesh, submeshIndex, position, rotation, scale) end

--
--Draw an icon at a position in the Scene view.
--
---@source UnityEngine.CoreModule.dll
---@param center UnityEngine.Vector3
---@param name string
---@param allowScaling bool
function CS.UnityEngine.Gizmos:DrawIcon(center, name, allowScaling) end

---@source UnityEngine.CoreModule.dll
---@param center UnityEngine.Vector3
---@param name string
---@param allowScaling bool
---@param tint UnityEngine.Color
function CS.UnityEngine.Gizmos:DrawIcon(center, name, allowScaling, tint) end

--
--Draw a texture in the Scene.
--
--```plaintext
--Params: screenRect - The size and position of the texture on the "screen" defined by the XY plane.
--        texture - The texture to be displayed.
--        mat - An optional material to apply the texture.
--        leftBorder - Inset from the rectangle's left edge.
--        rightBorder - Inset from the rectangle's right edge.
--        topBorder - Inset from the rectangle's top edge.
--        bottomBorder - Inset from the rectangle's bottom edge.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param screenRect UnityEngine.Rect
---@param texture UnityEngine.Texture
---@param leftBorder int
---@param rightBorder int
---@param topBorder int
---@param bottomBorder int
---@param mat UnityEngine.Material
function CS.UnityEngine.Gizmos:DrawGUITexture(screenRect, texture, leftBorder, rightBorder, topBorder, bottomBorder, mat) end

--
--Draw a camera frustum using the currently set Gizmos.matrix for it's location and rotation.
--
--```plaintext
--Params: center - The apex of the truncated pyramid.
--        fov - Vertical field of view (ie, the angle at the apex in degrees).
--        maxRange - Distance of the frustum's far plane.
--        minRange - Distance of the frustum's near plane.
--        aspect - Width/height ratio.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param center UnityEngine.Vector3
---@param fov float
---@param maxRange float
---@param minRange float
---@param aspect float
function CS.UnityEngine.Gizmos:DrawFrustum(center, fov, maxRange, minRange, aspect) end

--
--Draws a ray starting at from to from + direction.
--
---@source UnityEngine.CoreModule.dll
---@param r UnityEngine.Ray
function CS.UnityEngine.Gizmos:DrawRay(r) end

--
--Draws a ray starting at from to from + direction.
--
---@source UnityEngine.CoreModule.dll
---@param from UnityEngine.Vector3
---@param direction UnityEngine.Vector3
function CS.UnityEngine.Gizmos:DrawRay(from, direction) end

---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param position UnityEngine.Vector3
---@param rotation UnityEngine.Quaternion
function CS.UnityEngine.Gizmos:DrawMesh(mesh, position, rotation) end

---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param position UnityEngine.Vector3
function CS.UnityEngine.Gizmos:DrawMesh(mesh, position) end

---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
function CS.UnityEngine.Gizmos:DrawMesh(mesh) end

--
--Draws a mesh.
--
--```plaintext
--Params: mesh - Mesh to draw as a gizmo.
--        position - Position (default is zero).
--        rotation - Rotation (default is no rotation).
--        scale - Scale (default is no scale).
--        submeshIndex - Submesh to draw (default is -1, which draws whole mesh).
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param position UnityEngine.Vector3
---@param rotation UnityEngine.Quaternion
---@param scale UnityEngine.Vector3
function CS.UnityEngine.Gizmos:DrawMesh(mesh, position, rotation, scale) end

---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param submeshIndex int
---@param position UnityEngine.Vector3
---@param rotation UnityEngine.Quaternion
function CS.UnityEngine.Gizmos:DrawMesh(mesh, submeshIndex, position, rotation) end

---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param submeshIndex int
---@param position UnityEngine.Vector3
function CS.UnityEngine.Gizmos:DrawMesh(mesh, submeshIndex, position) end

---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param submeshIndex int
function CS.UnityEngine.Gizmos:DrawMesh(mesh, submeshIndex) end

---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param position UnityEngine.Vector3
---@param rotation UnityEngine.Quaternion
function CS.UnityEngine.Gizmos:DrawWireMesh(mesh, position, rotation) end

---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param position UnityEngine.Vector3
function CS.UnityEngine.Gizmos:DrawWireMesh(mesh, position) end

---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
function CS.UnityEngine.Gizmos:DrawWireMesh(mesh) end

--
--Draws a wireframe mesh.
--
--```plaintext
--Params: mesh - Mesh to draw as a gizmo.
--        position - Position (default is zero).
--        rotation - Rotation (default is no rotation).
--        scale - Scale (default is no scale).
--        submeshIndex - Submesh to draw (default is -1, which draws whole mesh).
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param position UnityEngine.Vector3
---@param rotation UnityEngine.Quaternion
---@param scale UnityEngine.Vector3
function CS.UnityEngine.Gizmos:DrawWireMesh(mesh, position, rotation, scale) end

---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param submeshIndex int
---@param position UnityEngine.Vector3
---@param rotation UnityEngine.Quaternion
function CS.UnityEngine.Gizmos:DrawWireMesh(mesh, submeshIndex, position, rotation) end

---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param submeshIndex int
---@param position UnityEngine.Vector3
function CS.UnityEngine.Gizmos:DrawWireMesh(mesh, submeshIndex, position) end

---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param submeshIndex int
function CS.UnityEngine.Gizmos:DrawWireMesh(mesh, submeshIndex) end

--
--Draw an icon at a position in the Scene view.
--
---@source UnityEngine.CoreModule.dll
---@param center UnityEngine.Vector3
---@param name string
function CS.UnityEngine.Gizmos:DrawIcon(center, name) end

--
--Draw a texture in the Scene.
--
--```plaintext
--Params: screenRect - The size and position of the texture on the "screen" defined by the XY plane.
--        texture - The texture to be displayed.
--        mat - An optional material to apply the texture.
--        leftBorder - Inset from the rectangle's left edge.
--        rightBorder - Inset from the rectangle's right edge.
--        topBorder - Inset from the rectangle's top edge.
--        bottomBorder - Inset from the rectangle's bottom edge.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param screenRect UnityEngine.Rect
---@param texture UnityEngine.Texture
function CS.UnityEngine.Gizmos:DrawGUITexture(screenRect, texture) end

--
--Draw a texture in the Scene.
--
--```plaintext
--Params: screenRect - The size and position of the texture on the "screen" defined by the XY plane.
--        texture - The texture to be displayed.
--        mat - An optional material to apply the texture.
--        leftBorder - Inset from the rectangle's left edge.
--        rightBorder - Inset from the rectangle's right edge.
--        topBorder - Inset from the rectangle's top edge.
--        bottomBorder - Inset from the rectangle's bottom edge.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param screenRect UnityEngine.Rect
---@param texture UnityEngine.Texture
---@param mat UnityEngine.Material
function CS.UnityEngine.Gizmos:DrawGUITexture(screenRect, texture, mat) end

--
--Draw a texture in the Scene.
--
--```plaintext
--Params: screenRect - The size and position of the texture on the "screen" defined by the XY plane.
--        texture - The texture to be displayed.
--        mat - An optional material to apply the texture.
--        leftBorder - Inset from the rectangle's left edge.
--        rightBorder - Inset from the rectangle's right edge.
--        topBorder - Inset from the rectangle's top edge.
--        bottomBorder - Inset from the rectangle's bottom edge.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param screenRect UnityEngine.Rect
---@param texture UnityEngine.Texture
---@param leftBorder int
---@param rightBorder int
---@param topBorder int
---@param bottomBorder int
function CS.UnityEngine.Gizmos:DrawGUITexture(screenRect, texture, leftBorder, rightBorder, topBorder, bottomBorder) end


--
--A Camera eye corresponding to the left or right human eye for stereoscopic rendering, or neither for non-stereoscopic rendering.
--
--A single Camera can render both left and right views in a single frame. Therefore, this enum describes which eye the Camera is currently rendering when returned by Camera.stereoActiveEye during a rendering callback (such as Camera.OnRenderImage), or which eye to act on when passed into a function.
--
--The default value is Camera.MonoOrStereoscopicEye.Left, so Camera.MonoOrStereoscopicEye.Left may be returned by some methods or properties when called outside of rendering if stereoscopic rendering is enabled.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.MonoOrStereoscopicEye: System.Enum
--
--Camera eye corresponding to stereoscopic rendering of the left eye.
--
---@source UnityEngine.CoreModule.dll
---@field Left UnityEngine.Camera.MonoOrStereoscopicEye
--
--Camera eye corresponding to stereoscopic rendering of the right eye.
--
---@source UnityEngine.CoreModule.dll
---@field Right UnityEngine.Camera.MonoOrStereoscopicEye
--
--Camera eye corresponding to non-stereoscopic rendering.
--
---@source UnityEngine.CoreModule.dll
---@field Mono UnityEngine.Camera.MonoOrStereoscopicEye
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.MonoOrStereoscopicEye = {}

---@source 
---@param value any
---@return UnityEngine.Camera.MonoOrStereoscopicEye
function CS.UnityEngine.MonoOrStereoscopicEye:__CastFrom(value) end


--
--Modes available for submitting when making a render request.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.RenderRequestMode: System.Enum
--
--Default value for a request.
--
---@source UnityEngine.CoreModule.dll
---@field None UnityEngine.Camera.RenderRequestMode
--
--The render request outputs an object InstanceID buffer.
--
---@source UnityEngine.CoreModule.dll
---@field ObjectId UnityEngine.Camera.RenderRequestMode
--
--The render request outputs a depth value.
--
---@source UnityEngine.CoreModule.dll
---@field Depth UnityEngine.Camera.RenderRequestMode
--
--The render request outputs the interpolated vertex normal.
--
---@source UnityEngine.CoreModule.dll
---@field VertexNormal UnityEngine.Camera.RenderRequestMode
--
--The render request outputs a world position buffer.
--
---@source UnityEngine.CoreModule.dll
---@field WorldPosition UnityEngine.Camera.RenderRequestMode
--
--The render request outputs an entity id.
--
---@source UnityEngine.CoreModule.dll
---@field EntityId UnityEngine.Camera.RenderRequestMode
--
--The render request outputs the materials albedo / base color.
--
---@source UnityEngine.CoreModule.dll
---@field BaseColor UnityEngine.Camera.RenderRequestMode
--
--The render request returns the materials specular color buffer.
--
---@source UnityEngine.CoreModule.dll
---@field SpecularColor UnityEngine.Camera.RenderRequestMode
--
--The render outputs the materials metal value.
--
---@source UnityEngine.CoreModule.dll
---@field Metallic UnityEngine.Camera.RenderRequestMode
--
--The render request outputs the materials emission value.
--
---@source UnityEngine.CoreModule.dll
---@field Emission UnityEngine.Camera.RenderRequestMode
--
--The render request outputs the per pixel normal.
--
---@source UnityEngine.CoreModule.dll
---@field Normal UnityEngine.Camera.RenderRequestMode
--
--The render request returns the materials smoothness buffer.
--
---@source UnityEngine.CoreModule.dll
---@field Smoothness UnityEngine.Camera.RenderRequestMode
--
--The render request returns the material ambient occlusion buffer.
--
---@source UnityEngine.CoreModule.dll
---@field Occlusion UnityEngine.Camera.RenderRequestMode
--
--The render request outputs the materials diffuse color.
--
---@source UnityEngine.CoreModule.dll
---@field DiffuseColor UnityEngine.Camera.RenderRequestMode
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.RenderRequestMode = {}

---@source 
---@param value any
---@return UnityEngine.Camera.RenderRequestMode
function CS.UnityEngine.RenderRequestMode:__CastFrom(value) end


--
--Defines in which space render requests will be be outputted.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.RenderRequestOutputSpace: System.Enum
--
--RenderRequests will be rendered in screenspace from the perspective of the camera.
--
---@source UnityEngine.CoreModule.dll
---@field ScreenSpace UnityEngine.Camera.RenderRequestOutputSpace
--
--RenderRequests will be outputted in UV 0 space of the rendered mesh.
--
---@source UnityEngine.CoreModule.dll
---@field UV0 UnityEngine.Camera.RenderRequestOutputSpace
--
--RenderRequests will be outputted in UV 1 space of the rendered mesh.
--
---@source UnityEngine.CoreModule.dll
---@field UV1 UnityEngine.Camera.RenderRequestOutputSpace
--
--RenderRequests will be outputted in UV 2 space of the rendered mesh.
--
---@source UnityEngine.CoreModule.dll
---@field UV2 UnityEngine.Camera.RenderRequestOutputSpace
--
--RenderRequests will be outputted in UV 3 space of the rendered mesh.
--
---@source UnityEngine.CoreModule.dll
---@field UV3 UnityEngine.Camera.RenderRequestOutputSpace
--
--RenderRequests will be outputted in UV 4 space of the rendered mesh.
--
---@source UnityEngine.CoreModule.dll
---@field UV4 UnityEngine.Camera.RenderRequestOutputSpace
--
--RenderRequests will be outputted in UV 5 space of the rendered mesh.
--
---@source UnityEngine.CoreModule.dll
---@field UV5 UnityEngine.Camera.RenderRequestOutputSpace
--
--RenderRequests will be outputted in UV 6 space of the rendered mesh.
--
---@source UnityEngine.CoreModule.dll
---@field UV6 UnityEngine.Camera.RenderRequestOutputSpace
--
--RenderRequests will be outputted in UV 7 space of the rendered mesh.
--
---@source UnityEngine.CoreModule.dll
---@field UV7 UnityEngine.Camera.RenderRequestOutputSpace
--
--RenderRequests will be outputted in UV 8 space of the rendered mesh.
--
---@source UnityEngine.CoreModule.dll
---@field UV8 UnityEngine.Camera.RenderRequestOutputSpace
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.RenderRequestOutputSpace = {}

---@source 
---@param value any
---@return UnityEngine.Camera.RenderRequestOutputSpace
function CS.UnityEngine.RenderRequestOutputSpace:__CastFrom(value) end


--
--Use this BeforeRenderOrderAttribute when you need to specify a custom callback order for Application.onBeforeRender.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.BeforeRenderOrderAttribute: System.Attribute
--
--The order, lowest to highest, that the Application.onBeforeRender event recievers will be called in.
--
---@source UnityEngine.CoreModule.dll
---@field order int
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.BeforeRenderOrderAttribute = {}


--
--A request that can be used for making specific rendering requests.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.RenderRequest: System.ValueType
--
--Is this request properly formed.
--
---@source UnityEngine.CoreModule.dll
---@field isValid bool
--
--The type of request.
--
---@source UnityEngine.CoreModule.dll
---@field mode UnityEngine.Camera.RenderRequestMode
--
--The result of the request.
--
---@source UnityEngine.CoreModule.dll
---@field result UnityEngine.RenderTexture
--
--Defines in which space render requests will be be outputted.
--
---@source UnityEngine.CoreModule.dll
---@field outputSpace UnityEngine.Camera.RenderRequestOutputSpace
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.RenderRequest = {}


--
--BillboardAsset describes how a billboard is rendered.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.BillboardAsset: UnityEngine.Object
--
--Width of the billboard.
--
---@source UnityEngine.CoreModule.dll
---@field width float
--
--Height of the billboard.
--
---@source UnityEngine.CoreModule.dll
---@field height float
--
--Height of the billboard that is below ground.
--
---@source UnityEngine.CoreModule.dll
---@field bottom float
--
--Number of pre-rendered images that can be switched when the billboard is viewed from different angles.
--
---@source UnityEngine.CoreModule.dll
---@field imageCount int
--
--Number of vertices in the billboard mesh.
--
---@source UnityEngine.CoreModule.dll
---@field vertexCount int
--
--Number of indices in the billboard mesh.
--
---@source UnityEngine.CoreModule.dll
---@field indexCount int
--
--The material used for rendering.
--
---@source UnityEngine.CoreModule.dll
---@field material UnityEngine.Material
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.BillboardAsset = {}

---@source UnityEngine.CoreModule.dll
---@param imageTexCoords System.Collections.Generic.List<UnityEngine.Vector4>
function CS.UnityEngine.BillboardAsset.GetImageTexCoords(imageTexCoords) end

--
--Get the array of billboard image texture coordinate data.
--
--```plaintext
--Params: imageTexCoords - The list that receives the array.
--        
--```
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.BillboardAsset.GetImageTexCoords() end

---@source UnityEngine.CoreModule.dll
---@param imageTexCoords System.Collections.Generic.List<UnityEngine.Vector4>
function CS.UnityEngine.BillboardAsset.SetImageTexCoords(imageTexCoords) end

--
--Set the array of billboard image texture coordinate data.
--
--```plaintext
--Params: imageTexCoords - The array of data to set.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param imageTexCoords UnityEngine.Vector4[]
function CS.UnityEngine.BillboardAsset.SetImageTexCoords(imageTexCoords) end

---@source UnityEngine.CoreModule.dll
---@param vertices System.Collections.Generic.List<UnityEngine.Vector2>
function CS.UnityEngine.BillboardAsset.GetVertices(vertices) end

--
--Get the vertices of the billboard mesh.
--
--```plaintext
--Params: vertices - The list that receives the array.
--        
--```
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.BillboardAsset.GetVertices() end

---@source UnityEngine.CoreModule.dll
---@param vertices System.Collections.Generic.List<UnityEngine.Vector2>
function CS.UnityEngine.BillboardAsset.SetVertices(vertices) end

--
--Set the vertices of the billboard mesh.
--
--```plaintext
--Params: vertices - The array of data to set.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param vertices UnityEngine.Vector2[]
function CS.UnityEngine.BillboardAsset.SetVertices(vertices) end

---@source UnityEngine.CoreModule.dll
---@param indices System.Collections.Generic.List<ushort>
function CS.UnityEngine.BillboardAsset.GetIndices(indices) end

--
--Get the indices of the billboard mesh.
--
--```plaintext
--Params: indices - The list that receives the array.
--        
--```
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.BillboardAsset.GetIndices() end

---@source UnityEngine.CoreModule.dll
---@param indices System.Collections.Generic.List<ushort>
function CS.UnityEngine.BillboardAsset.SetIndices(indices) end

--
--Set the indices of the billboard mesh.
--
--```plaintext
--Params: indices - The array of data to set.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param indices ushort[]
function CS.UnityEngine.BillboardAsset.SetIndices(indices) end


--
--Renders a billboard from a BillboardAsset.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.BillboardRenderer: UnityEngine.Renderer
--
--The BillboardAsset to render.
--
---@source UnityEngine.CoreModule.dll
---@field billboard UnityEngine.BillboardAsset
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.BillboardRenderer = {}


--
--Describes a single bounding sphere for use by a CullingGroup.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.BoundingSphere: System.ValueType
--
--The position of the center of the BoundingSphere.
--
---@source UnityEngine.CoreModule.dll
---@field position UnityEngine.Vector3
--
--The radius of the BoundingSphere.
--
---@source UnityEngine.CoreModule.dll
---@field radius float
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.BoundingSphere = {}


--
--Provides information about the current and previous states of one sphere in a CullingGroup.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.CullingGroupEvent: System.ValueType
--
--The index of the sphere that has changed.
--
---@source UnityEngine.CoreModule.dll
---@field index int
--
--Was the sphere considered visible by the most recent culling pass?
--
---@source UnityEngine.CoreModule.dll
---@field isVisible bool
--
--Was the sphere visible before the most recent culling pass?
--
---@source UnityEngine.CoreModule.dll
---@field wasVisible bool
--
--Did this sphere change from being invisible to being visible in the most recent culling pass?
--
---@source UnityEngine.CoreModule.dll
---@field hasBecomeVisible bool
--
--Did this sphere change from being visible to being invisible in the most recent culling pass?
--
---@source UnityEngine.CoreModule.dll
---@field hasBecomeInvisible bool
--
--The current distance band index of the sphere, after the most recent culling pass.
--
---@source UnityEngine.CoreModule.dll
---@field currentDistance int
--
--The distance band index of the sphere before the most recent culling pass.
--
---@source UnityEngine.CoreModule.dll
---@field previousDistance int
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.CullingGroupEvent = {}


--
--Custom Render Texture Manager.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.CustomRenderTextureManager: object
---@source UnityEngine.CoreModule.dll
---@field textureLoaded System.Action<UnityEngine.CustomRenderTexture>
---@source UnityEngine.CoreModule.dll
---@field textureUnloaded System.Action<UnityEngine.CustomRenderTexture>
---@source UnityEngine.CoreModule.dll
---@field updateTriggered System.Action<UnityEngine.CustomRenderTexture, int>
---@source UnityEngine.CoreModule.dll
---@field initializeTriggered System.Action<UnityEngine.CustomRenderTexture>
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.CustomRenderTextureManager = {}

---@source UnityEngine.CoreModule.dll
---@param value System.Action<UnityEngine.CustomRenderTexture>
function CS.UnityEngine.CustomRenderTextureManager:add_textureLoaded(value) end

---@source UnityEngine.CoreModule.dll
---@param value System.Action<UnityEngine.CustomRenderTexture>
function CS.UnityEngine.CustomRenderTextureManager:remove_textureLoaded(value) end

---@source UnityEngine.CoreModule.dll
---@param value System.Action<UnityEngine.CustomRenderTexture>
function CS.UnityEngine.CustomRenderTextureManager:add_textureUnloaded(value) end

---@source UnityEngine.CoreModule.dll
---@param value System.Action<UnityEngine.CustomRenderTexture>
function CS.UnityEngine.CustomRenderTextureManager:remove_textureUnloaded(value) end

---@source UnityEngine.CoreModule.dll
---@param currentCustomRenderTextures System.Collections.Generic.List<UnityEngine.CustomRenderTexture>
function CS.UnityEngine.CustomRenderTextureManager:GetAllCustomRenderTextures(currentCustomRenderTextures) end

---@source UnityEngine.CoreModule.dll
---@param value System.Action<UnityEngine.CustomRenderTexture, int>
function CS.UnityEngine.CustomRenderTextureManager:add_updateTriggered(value) end

---@source UnityEngine.CoreModule.dll
---@param value System.Action<UnityEngine.CustomRenderTexture, int>
function CS.UnityEngine.CustomRenderTextureManager:remove_updateTriggered(value) end

---@source UnityEngine.CoreModule.dll
---@param value System.Action<UnityEngine.CustomRenderTexture>
function CS.UnityEngine.CustomRenderTextureManager:add_initializeTriggered(value) end

---@source UnityEngine.CoreModule.dll
---@param value System.Action<UnityEngine.CustomRenderTexture>
function CS.UnityEngine.CustomRenderTextureManager:remove_initializeTriggered(value) end


--
--Describes a set of bounding spheres that should have their visibility and distances maintained.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.CullingGroup: object
--
--Sets the callback that will be called when a sphere's visibility and/or distance state has changed.
--
---@source UnityEngine.CoreModule.dll
---@field onStateChanged UnityEngine.CullingGroup.StateChanged
--
--Pauses culling group execution.
--
---@source UnityEngine.CoreModule.dll
---@field enabled bool
--
--Locks the CullingGroup to a specific camera.
--
---@source UnityEngine.CoreModule.dll
---@field targetCamera UnityEngine.Camera
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.CullingGroup = {}

--
--Clean up all memory used by the CullingGroup immediately.
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.CullingGroup.Dispose() end

--
--Sets the array of bounding sphere definitions that the CullingGroup should compute culling for.
--
--```plaintext
--Params: array - The BoundingSpheres to cull.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param array UnityEngine.BoundingSphere[]
function CS.UnityEngine.CullingGroup.SetBoundingSpheres(array) end

--
--Sets the number of bounding spheres in the bounding spheres array that are actually being used.
--
--```plaintext
--Params: count - The number of bounding spheres being used.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param count int
function CS.UnityEngine.CullingGroup.SetBoundingSphereCount(count) end

--
--Erase a given bounding sphere by moving the final sphere on top of it.
--
--```plaintext
--Params: index - The index of the entry to erase.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param index int
function CS.UnityEngine.CullingGroup.EraseSwapBack(index) end

---@source UnityEngine.CoreModule.dll
---@param index int
---@param myArray T[]
---@param size int
function CS.UnityEngine.CullingGroup:EraseSwapBack(index, myArray, size) end

--
--The number of sphere indices found and written into the result array.
--
--```plaintext
--Params: visible - True if only visible spheres should be retrieved; false if only invisible spheres should be retrieved.
--        distanceIndex - The distance band that retrieved spheres must be in.
--        result - An array that will be filled with the retrieved sphere indices.
--        firstIndex - The index of the sphere to begin searching at.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param visible bool
---@param result int[]
---@param firstIndex int
---@return Int32
function CS.UnityEngine.CullingGroup.QueryIndices(visible, result, firstIndex) end

--
--The number of sphere indices found and written into the result array.
--
--```plaintext
--Params: visible - True if only visible spheres should be retrieved; false if only invisible spheres should be retrieved.
--        distanceIndex - The distance band that retrieved spheres must be in.
--        result - An array that will be filled with the retrieved sphere indices.
--        firstIndex - The index of the sphere to begin searching at.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param distanceIndex int
---@param result int[]
---@param firstIndex int
---@return Int32
function CS.UnityEngine.CullingGroup.QueryIndices(distanceIndex, result, firstIndex) end

--
--The number of sphere indices found and written into the result array.
--
--```plaintext
--Params: visible - True if only visible spheres should be retrieved; false if only invisible spheres should be retrieved.
--        distanceIndex - The distance band that retrieved spheres must be in.
--        result - An array that will be filled with the retrieved sphere indices.
--        firstIndex - The index of the sphere to begin searching at.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param visible bool
---@param distanceIndex int
---@param result int[]
---@param firstIndex int
---@return Int32
function CS.UnityEngine.CullingGroup.QueryIndices(visible, distanceIndex, result, firstIndex) end

--
--True if the sphere is visible; false if it is invisible.
--
--```plaintext
--Params: index - The index of the bounding sphere.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param index int
---@return Boolean
function CS.UnityEngine.CullingGroup.IsVisible(index) end

--
--The sphere's current distance band index.
--
--```plaintext
--Params: index - The index of the sphere.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param index int
---@return Int32
function CS.UnityEngine.CullingGroup.GetDistance(index) end

--
--Set bounding distances for 'distance bands' the group should compute, as well as options for how spheres falling into each distance band should be treated.
--
--```plaintext
--Params: distances - An array of bounding distances. The distances should be sorted in increasing order.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param distances float[]
function CS.UnityEngine.CullingGroup.SetBoundingDistances(distances) end

--
--Set the reference point from which distance bands are measured.
--
--```plaintext
--Params: point - A fixed point to measure the distance from.
--        transform - A transform to measure the distance from. The transform's position will be automatically tracked.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param point UnityEngine.Vector3
function CS.UnityEngine.CullingGroup.SetDistanceReferencePoint(point) end

--
--Set the reference point from which distance bands are measured.
--
--```plaintext
--Params: point - A fixed point to measure the distance from.
--        transform - A transform to measure the distance from. The transform's position will be automatically tracked.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param transform UnityEngine.Transform
function CS.UnityEngine.CullingGroup.SetDistanceReferencePoint(transform) end


--
--Provides access to a display / screen for rendering operations.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.Display: object
--
--The list of currently connected displays.
--
---@source UnityEngine.CoreModule.dll
---@field displays UnityEngine.Display[]
--
--Horizontal resolution that the display is rendering at.
--
---@source UnityEngine.CoreModule.dll
---@field renderingWidth int
--
--Vertical resolution that the display is rendering at.
--
---@source UnityEngine.CoreModule.dll
---@field renderingHeight int
--
--Horizontal native display resolution.
--
---@source UnityEngine.CoreModule.dll
---@field systemWidth int
--
--Vertical native display resolution.
--
---@source UnityEngine.CoreModule.dll
---@field systemHeight int
--
--Color RenderBuffer.
--
---@source UnityEngine.CoreModule.dll
---@field colorBuffer UnityEngine.RenderBuffer
--
--Depth RenderBuffer.
--
---@source UnityEngine.CoreModule.dll
---@field depthBuffer UnityEngine.RenderBuffer
--
--Gets the state of the display and returns true if the display is active and false if otherwise.
--
---@source UnityEngine.CoreModule.dll
---@field active bool
--
--True when the back buffer requires an intermediate texture to render.
--
---@source UnityEngine.CoreModule.dll
---@field requiresBlitToBackbuffer bool
--
--True when doing a blit to the back buffer requires manual color space conversion.
--
---@source UnityEngine.CoreModule.dll
---@field requiresSrgbBlitToBackbuffer bool
--
--Main Display.
--
---@source UnityEngine.CoreModule.dll
---@field main UnityEngine.Display
--
--Get the Editors active GameView display target.
--
---@source UnityEngine.CoreModule.dll
---@field activeEditorGameViewTarget int
---@source UnityEngine.CoreModule.dll
---@field onDisplaysUpdated UnityEngine.Display.DisplaysUpdatedDelegate
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.Display = {}

--
--Activate an external display. Eg. Secondary Monitors connected to the System.
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.Display.Activate() end

--
--This overloaded function available for Windows allows specifying desired Window Width, Height and Refresh Rate.
--
--```plaintext
--Params: width - Desired Width of the Window (for Windows only. On Linux and Mac uses Screen Width).
--        height - Desired Height of the Window (for Windows only. On Linux and Mac uses Screen Height).
--        refreshRate - Desired Refresh Rate.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param width int
---@param height int
---@param refreshRate int
function CS.UnityEngine.Display.Activate(width, height, refreshRate) end

--
--Set rendering size and position on screen (Windows only).
--
--```plaintext
--Params: width - Change Window Width (Windows Only).
--        height - Change Window Height (Windows Only).
--        x - Change Window Position X (Windows Only).
--        y - Change Window Position Y (Windows Only).
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param width int
---@param height int
---@param x int
---@param y int
function CS.UnityEngine.Display.SetParams(width, height, x, y) end

--
--Sets rendering resolution for the display.
--
--```plaintext
--Params: w - Rendering width in pixels.
--        h - Rendering height in pixels.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param w int
---@param h int
function CS.UnityEngine.Display.SetRenderingResolution(w, h) end

---@source UnityEngine.CoreModule.dll
---@return Boolean
function CS.UnityEngine.Display:MultiDisplayLicense() end

--
--Query relative mouse coordinates.
--
--```plaintext
--Params: inputMouseCoordinates - Mouse Input Position as Coordinates.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param inputMouseCoordinates UnityEngine.Vector3
---@return Vector3
function CS.UnityEngine.Display:RelativeMouseAt(inputMouseCoordinates) end

---@source UnityEngine.CoreModule.dll
---@param value UnityEngine.Display.DisplaysUpdatedDelegate
function CS.UnityEngine.Display:add_onDisplaysUpdated(value) end

---@source UnityEngine.CoreModule.dll
---@param value UnityEngine.Display.DisplaysUpdatedDelegate
function CS.UnityEngine.Display:remove_onDisplaysUpdated(value) end


---@source UnityEngine.CoreModule.dll
---@class UnityEngine.DisplaysUpdatedDelegate: System.MulticastDelegate
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.DisplaysUpdatedDelegate = {}

---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.DisplaysUpdatedDelegate.Invoke() end

---@source UnityEngine.CoreModule.dll
---@param callback System.AsyncCallback
---@param object object
---@return IAsyncResult
function CS.UnityEngine.DisplaysUpdatedDelegate.BeginInvoke(callback, object) end

---@source UnityEngine.CoreModule.dll
---@param result System.IAsyncResult
function CS.UnityEngine.DisplaysUpdatedDelegate.EndInvoke(result) end


--
--FlareLayer component.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.FlareLayer: UnityEngine.Behaviour
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.FlareLayer = {}


--
--Platform agnostic fullscreen mode. Not all platforms support all modes.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.FullScreenMode: System.Enum
--
--Exclusive Mode.
--
---@source UnityEngine.CoreModule.dll
---@field ExclusiveFullScreen UnityEngine.FullScreenMode
--
--Fullscreen window.
--
---@source UnityEngine.CoreModule.dll
---@field FullScreenWindow UnityEngine.FullScreenMode
--
--Maximized window.
--
---@source UnityEngine.CoreModule.dll
---@field MaximizedWindow UnityEngine.FullScreenMode
--
--Windowed.
--
---@source UnityEngine.CoreModule.dll
---@field Windowed UnityEngine.FullScreenMode
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.FullScreenMode = {}

---@source 
---@param value any
---@return UnityEngine.FullScreenMode
function CS.UnityEngine.FullScreenMode:__CastFrom(value) end


--
--The reflection probe is used to capture the surroundings into a texture which is passed to the shaders and used for reflections.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.ReflectionProbe: UnityEngine.Behaviour
---@source UnityEngine.CoreModule.dll
---@field type UnityEngine.Rendering.ReflectionProbeType
--
--The size of the box area in which reflections will be applied to the objects. Measured in the probes's local space.
--
---@source UnityEngine.CoreModule.dll
---@field size UnityEngine.Vector3
--
--The center of the box area in which reflections will be applied to the objects. Measured in the probes's local space.
--
---@source UnityEngine.CoreModule.dll
---@field center UnityEngine.Vector3
--
--The near clipping plane distance when rendering the probe.
--
---@source UnityEngine.CoreModule.dll
---@field nearClipPlane float
--
--The far clipping plane distance when rendering the probe.
--
---@source UnityEngine.CoreModule.dll
---@field farClipPlane float
--
--The intensity modifier that is applied to the texture of reflection probe in the shader.
--
---@source UnityEngine.CoreModule.dll
---@field intensity float
--
--The bounding volume of the reflection probe (Read Only).
--
---@source UnityEngine.CoreModule.dll
---@field bounds UnityEngine.Bounds
--
--Should this reflection probe use HDR rendering?
--
---@source UnityEngine.CoreModule.dll
---@field hdr bool
--
--Specifies whether Unity should render non-static GameObjects into the Reflection Probe. If you set this to true, Unity renders non-static GameObjects into the Reflection Probe. If you set this to false, Unity does not render non-static GameObjects into the Reflection Probe. Unity only takes this property into account if the Reflection Probe's Type is Custom.
--
---@source UnityEngine.CoreModule.dll
---@field renderDynamicObjects bool
--
--Shadow drawing distance when rendering the probe.
--
---@source UnityEngine.CoreModule.dll
---@field shadowDistance float
--
--Resolution of the underlying reflection texture in pixels.
--
---@source UnityEngine.CoreModule.dll
---@field resolution int
--
--This is used to render parts of the reflecion probe's surrounding selectively.
--
---@source UnityEngine.CoreModule.dll
---@field cullingMask int
--
--How the reflection probe clears the background.
--
---@source UnityEngine.CoreModule.dll
---@field clearFlags UnityEngine.Rendering.ReflectionProbeClearFlags
--
--The color with which the texture of reflection probe will be cleared.
--
---@source UnityEngine.CoreModule.dll
---@field backgroundColor UnityEngine.Color
--
--Distance around probe used for blending (used in deferred probes).
--
---@source UnityEngine.CoreModule.dll
---@field blendDistance float
--
--Should this reflection probe use box projection?
--
---@source UnityEngine.CoreModule.dll
---@field boxProjection bool
--
--Should reflection probe texture be generated in the Editor (ReflectionProbeMode.Baked) or should probe use custom specified texure (ReflectionProbeMode.Custom)?
--
---@source UnityEngine.CoreModule.dll
---@field mode UnityEngine.Rendering.ReflectionProbeMode
--
--Reflection probe importance.
--
---@source UnityEngine.CoreModule.dll
---@field importance int
--
--Sets the way the probe will refresh.
--
--See Also: ReflectionProbeRefreshMode.
--
---@source UnityEngine.CoreModule.dll
---@field refreshMode UnityEngine.Rendering.ReflectionProbeRefreshMode
--
--Sets this probe time-slicing mode
--
--See Also: ReflectionProbeTimeSlicingMode.
--
---@source UnityEngine.CoreModule.dll
---@field timeSlicingMode UnityEngine.Rendering.ReflectionProbeTimeSlicingMode
--
--Reference to the baked texture of the reflection probe's surrounding.
--
---@source UnityEngine.CoreModule.dll
---@field bakedTexture UnityEngine.Texture
--
--Reference to the baked texture of the reflection probe's surrounding. Use this to assign custom reflection texture.
--
---@source UnityEngine.CoreModule.dll
---@field customBakedTexture UnityEngine.Texture
--
--Reference to the realtime texture of the reflection probe's surroundings. Use this to assign a RenderTexture to use for realtime reflection.
--
---@source UnityEngine.CoreModule.dll
---@field realtimeTexture UnityEngine.RenderTexture
--
--Texture which is passed to the shader of the objects in the vicinity of the reflection probe (Read Only).
--
---@source UnityEngine.CoreModule.dll
---@field texture UnityEngine.Texture
--
--HDR decode values of the reflection probe texture.
--
---@source UnityEngine.CoreModule.dll
---@field textureHDRDecodeValues UnityEngine.Vector4
---@source UnityEngine.CoreModule.dll
---@field minBakedCubemapResolution int
---@source UnityEngine.CoreModule.dll
---@field maxBakedCubemapResolution int
--
--HDR decode values of the default reflection probe texture.
--
---@source UnityEngine.CoreModule.dll
---@field defaultTextureHDRDecodeValues UnityEngine.Vector4
--
--Texture which is used outside of all reflection probes (Read Only).
--
---@source UnityEngine.CoreModule.dll
---@field defaultTexture UnityEngine.Texture
---@source UnityEngine.CoreModule.dll
---@field reflectionProbeChanged System.Action<UnityEngine.ReflectionProbe, UnityEngine.ReflectionProbe.ReflectionProbeEvent>
---@source UnityEngine.CoreModule.dll
---@field defaultReflectionSet System.Action<UnityEngine.Cubemap>
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.ReflectionProbe = {}

--
--Revert all ReflectionProbe parameters to default.
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.ReflectionProbe.Reset() end

---@source UnityEngine.CoreModule.dll
---@return Int32
function CS.UnityEngine.ReflectionProbe.RenderProbe() end

--
--An integer representing a RenderID which can subsequently be used to check if the probe has finished rendering while rendering in time-slice mode.
--
--          See Also: IsFinishedRendering
--          See Also: timeSlicingMode
--
--```plaintext
--Params: targetTexture - Target RendeTexture in which rendering should be done. Specifying null will update the probe's default texture.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param targetTexture UnityEngine.RenderTexture
---@return Int32
function CS.UnityEngine.ReflectionProbe.RenderProbe(targetTexture) end

--
--True if the render has finished, false otherwise.
--
--          See Also: timeSlicingMode
--
--```plaintext
--Params: renderId - An integer representing the RenderID as returned by the RenderProbe method.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param renderId int
---@return Boolean
function CS.UnityEngine.ReflectionProbe.IsFinishedRendering(renderId) end

--
--Returns trues if cubemaps were blended, false otherwise.
--
--```plaintext
--Params: src - Cubemap to blend from.
--        dst - Cubemap to blend to.
--        blend - Blend weight.
--        target - RenderTexture which will hold the result of the blend.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param src UnityEngine.Texture
---@param dst UnityEngine.Texture
---@param blend float
---@param target UnityEngine.RenderTexture
---@return Boolean
function CS.UnityEngine.ReflectionProbe:BlendCubemap(src, dst, blend, target) end

---@source UnityEngine.CoreModule.dll
---@param value System.Action<UnityEngine.ReflectionProbe, UnityEngine.ReflectionProbe.ReflectionProbeEvent>
function CS.UnityEngine.ReflectionProbe:add_reflectionProbeChanged(value) end

---@source UnityEngine.CoreModule.dll
---@param value System.Action<UnityEngine.ReflectionProbe, UnityEngine.ReflectionProbe.ReflectionProbeEvent>
function CS.UnityEngine.ReflectionProbe:remove_reflectionProbeChanged(value) end

---@source UnityEngine.CoreModule.dll
---@param value System.Action<UnityEngine.Cubemap>
function CS.UnityEngine.ReflectionProbe:add_defaultReflectionSet(value) end

---@source UnityEngine.CoreModule.dll
---@param value System.Action<UnityEngine.Cubemap>
function CS.UnityEngine.ReflectionProbe:remove_defaultReflectionSet(value) end


--
--Constants for special values of Screen.sleepTimeout.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.SleepTimeout: object
--
--Prevent screen dimming.
--
---@source UnityEngine.CoreModule.dll
---@field NeverSleep int
--
--Set the sleep timeout to whatever the user has specified in the system settings.
--
---@source UnityEngine.CoreModule.dll
---@field SystemSetting int
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.SleepTimeout = {}


--
--Types of events that occur when ReflectionProbe components are used in a Scene.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.ReflectionProbeEvent: System.Enum
--
--An event that occurs when a Reflection Probe component is added to a Scene or enabled in a Scene.
--
---@source UnityEngine.CoreModule.dll
---@field ReflectionProbeAdded UnityEngine.ReflectionProbe.ReflectionProbeEvent
--
--An event that occurs when a Reflection Probe component is unloaded from a Scene or disabled in a Scene.
--
---@source UnityEngine.CoreModule.dll
---@field ReflectionProbeRemoved UnityEngine.ReflectionProbe.ReflectionProbeEvent
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.ReflectionProbeEvent = {}

---@source 
---@param value any
---@return UnityEngine.ReflectionProbe.ReflectionProbeEvent
function CS.UnityEngine.ReflectionProbeEvent:__CastFrom(value) end


--
--Provides access to display information.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.Screen: object
--
--The current width of the screen window in pixels (Read Only).
--
---@source UnityEngine.CoreModule.dll
---@field width int
--
--The current height of the screen window in pixels (Read Only).
--
---@source UnityEngine.CoreModule.dll
---@field height int
--
--The current DPI of the screen / device (Read Only).
--
---@source UnityEngine.CoreModule.dll
---@field dpi float
--
--The current screen resolution (Read Only).
--
---@source UnityEngine.CoreModule.dll
---@field currentResolution UnityEngine.Resolution
--
--Returns all full-screen resolutions that the monitor supports (Read Only).
--
---@source UnityEngine.CoreModule.dll
---@field resolutions UnityEngine.Resolution[]
--
--Enables full-screen mode for the application.
--
---@source UnityEngine.CoreModule.dll
---@field fullScreen bool
--
--Set this property to one of the values in FullScreenMode to change the display mode of your application.
--
---@source UnityEngine.CoreModule.dll
---@field fullScreenMode UnityEngine.FullScreenMode
--
--Returns the safe area of the screen in pixels (Read Only).
--
---@source UnityEngine.CoreModule.dll
---@field safeArea UnityEngine.Rect
--
--Returns a list of screen areas that are not functional for displaying content (Read Only).
--
---@source UnityEngine.CoreModule.dll
---@field cutouts UnityEngine.Rect[]
--
--Enables auto-rotation to portrait.
--
---@source UnityEngine.CoreModule.dll
---@field autorotateToPortrait bool
--
--Enables auto-rotation to portrait, upside down.
--
---@source UnityEngine.CoreModule.dll
---@field autorotateToPortraitUpsideDown bool
--
--Enables auto-rotation to landscape left
--
---@source UnityEngine.CoreModule.dll
---@field autorotateToLandscapeLeft bool
--
--Enables auto-rotation to landscape right.
--
---@source UnityEngine.CoreModule.dll
---@field autorotateToLandscapeRight bool
--
--Specifies logical orientation of the screen.
--
---@source UnityEngine.CoreModule.dll
---@field orientation UnityEngine.ScreenOrientation
--
--A power saving setting, allowing the screen to dim some time after the last active user interaction.
--
---@source UnityEngine.CoreModule.dll
---@field sleepTimeout int
--
--The current brightness of the screen.
--
---@source UnityEngine.CoreModule.dll
---@field brightness float
---@source UnityEngine.CoreModule.dll
---@field GetResolution UnityEngine.Resolution[]
--
--Should the cursor be visible?
--
---@source UnityEngine.CoreModule.dll
---@field showCursor bool
--
--Enable cursor locking
--
---@source UnityEngine.CoreModule.dll
---@field lockCursor bool
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.Screen = {}

--
--Switches the screen resolution.
--
---@source UnityEngine.CoreModule.dll
---@param width int
---@param height int
---@param fullscreenMode UnityEngine.FullScreenMode
---@param preferredRefreshRate int
function CS.UnityEngine.Screen:SetResolution(width, height, fullscreenMode, preferredRefreshRate) end

--
--Switches the screen resolution.
--
---@source UnityEngine.CoreModule.dll
---@param width int
---@param height int
---@param fullscreenMode UnityEngine.FullScreenMode
function CS.UnityEngine.Screen:SetResolution(width, height, fullscreenMode) end

--
--Switches the screen resolution.
--
---@source UnityEngine.CoreModule.dll
---@param width int
---@param height int
---@param fullscreen bool
---@param preferredRefreshRate int
function CS.UnityEngine.Screen:SetResolution(width, height, fullscreen, preferredRefreshRate) end

--
--Switches the screen resolution.
--
---@source UnityEngine.CoreModule.dll
---@param width int
---@param height int
---@param fullscreen bool
function CS.UnityEngine.Screen:SetResolution(width, height, fullscreen) end


--
--Color or depth buffer part of a RenderTexture.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.RenderBuffer: System.ValueType
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.RenderBuffer = {}

--
--Returns native RenderBuffer. Be warned this is not native Texture, but rather pointer to unity struct that can be used with native unity API. Currently such API exists only on iOS.
--
---@source UnityEngine.CoreModule.dll
---@return IntPtr
function CS.UnityEngine.RenderBuffer.GetNativeRenderBufferPtr() end


--
--Intended usage of the buffer.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.ComputeBufferMode: System.Enum
--
--Static buffer, only initial upload allowed by the CPU
--
---@source UnityEngine.CoreModule.dll
---@field Immutable UnityEngine.ComputeBufferMode
--
--Dynamic buffer.
--
---@source UnityEngine.CoreModule.dll
---@field Dynamic UnityEngine.ComputeBufferMode
--
--Legacy mode, do not use.
--
---@source UnityEngine.CoreModule.dll
---@field Circular UnityEngine.ComputeBufferMode
--
--Stream Out / Transform Feedback output buffer. Internal use only.
--
---@source UnityEngine.CoreModule.dll
---@field StreamOut UnityEngine.ComputeBufferMode
--
--Dynamic, unsynchronized access to the buffer.
--
---@source UnityEngine.CoreModule.dll
---@field SubUpdates UnityEngine.ComputeBufferMode
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.ComputeBufferMode = {}

---@source 
---@param value any
---@return UnityEngine.ComputeBufferMode
function CS.UnityEngine.ComputeBufferMode:__CastFrom(value) end


--
--Raw interface to Unity's drawing functions.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.Graphics: object
--
--Returns the currently active color gamut.
--
---@source UnityEngine.CoreModule.dll
---@field activeColorGamut UnityEngine.ColorGamut
--
--The GraphicsTier for the current device.
--
---@source UnityEngine.CoreModule.dll
---@field activeTier UnityEngine.Rendering.GraphicsTier
--
--True when rendering over native UI is enabled in Player Settings (readonly).
--
---@source UnityEngine.CoreModule.dll
---@field preserveFramebufferAlpha bool
--
--The minimum OpenGL ES version. The value is specified in PlayerSettings.
--
---@source UnityEngine.CoreModule.dll
---@field minOpenGLESVersion UnityEngine.Rendering.OpenGLESVersion
--
--Currently active color buffer (Read Only).
--
---@source UnityEngine.CoreModule.dll
---@field activeColorBuffer UnityEngine.RenderBuffer
--
--Currently active depth/stencil buffer (Read Only).
--
---@source UnityEngine.CoreModule.dll
---@field activeDepthBuffer UnityEngine.RenderBuffer
---@source UnityEngine.CoreModule.dll
---@field deviceName string
---@source UnityEngine.CoreModule.dll
---@field deviceVendor string
---@source UnityEngine.CoreModule.dll
---@field deviceVersion string
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.Graphics = {}

--
--Clear random write targets for level pixel shaders.
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.Graphics:ClearRandomWriteTargets() end

--
--Execute a command buffer.
--
--```plaintext
--Params: buffer - The buffer to execute.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param buffer UnityEngine.Rendering.CommandBuffer
function CS.UnityEngine.Graphics:ExecuteCommandBuffer(buffer) end

--
--Executes a command buffer on an async compute queue with the queue selected based on the ComputeQueueType parameter passed.
--
--```plaintext
--Params: buffer - The CommandBuffer to be executed.
--        queueType - Describes the desired async compute queue the supplied CommandBuffer should be executed on.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param buffer UnityEngine.Rendering.CommandBuffer
---@param queueType UnityEngine.Rendering.ComputeQueueType
function CS.UnityEngine.Graphics:ExecuteCommandBufferAsync(buffer, queueType) end

--
--Sets current render target.
--
--```plaintext
--Params: rt - RenderTexture to set as active render target.
--        mipLevel - Mipmap level to render into (use 0 if not mipmapped).
--        face - Cubemap face to render into (use Unknown if not a cubemap).
--        depthSlice - Depth slice to render into (use 0 if not a 3D or 2DArray render target).
--        colorBuffer - Color buffer to render into.
--        depthBuffer - Depth buffer to render into.
--        colorBuffers - Color buffers to render into (for multiple render target effects).
--        setup - Full render target setup information.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param rt UnityEngine.RenderTexture
---@param mipLevel int
---@param face UnityEngine.CubemapFace
---@param depthSlice int
function CS.UnityEngine.Graphics:SetRenderTarget(rt, mipLevel, face, depthSlice) end

--
--Sets current render target.
--
--```plaintext
--Params: rt - RenderTexture to set as active render target.
--        mipLevel - Mipmap level to render into (use 0 if not mipmapped).
--        face - Cubemap face to render into (use Unknown if not a cubemap).
--        depthSlice - Depth slice to render into (use 0 if not a 3D or 2DArray render target).
--        colorBuffer - Color buffer to render into.
--        depthBuffer - Depth buffer to render into.
--        colorBuffers - Color buffers to render into (for multiple render target effects).
--        setup - Full render target setup information.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param colorBuffer UnityEngine.RenderBuffer
---@param depthBuffer UnityEngine.RenderBuffer
---@param mipLevel int
---@param face UnityEngine.CubemapFace
---@param depthSlice int
function CS.UnityEngine.Graphics:SetRenderTarget(colorBuffer, depthBuffer, mipLevel, face, depthSlice) end

--
--Sets current render target.
--
--```plaintext
--Params: rt - RenderTexture to set as active render target.
--        mipLevel - Mipmap level to render into (use 0 if not mipmapped).
--        face - Cubemap face to render into (use Unknown if not a cubemap).
--        depthSlice - Depth slice to render into (use 0 if not a 3D or 2DArray render target).
--        colorBuffer - Color buffer to render into.
--        depthBuffer - Depth buffer to render into.
--        colorBuffers - Color buffers to render into (for multiple render target effects).
--        setup - Full render target setup information.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param colorBuffers UnityEngine.RenderBuffer[]
---@param depthBuffer UnityEngine.RenderBuffer
function CS.UnityEngine.Graphics:SetRenderTarget(colorBuffers, depthBuffer) end

--
--Sets current render target.
--
--```plaintext
--Params: rt - RenderTexture to set as active render target.
--        mipLevel - Mipmap level to render into (use 0 if not mipmapped).
--        face - Cubemap face to render into (use Unknown if not a cubemap).
--        depthSlice - Depth slice to render into (use 0 if not a 3D or 2DArray render target).
--        colorBuffer - Color buffer to render into.
--        depthBuffer - Depth buffer to render into.
--        colorBuffers - Color buffers to render into (for multiple render target effects).
--        setup - Full render target setup information.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param setup UnityEngine.RenderTargetSetup
function CS.UnityEngine.Graphics:SetRenderTarget(setup) end

--
--Set random write target for level pixel shaders.
--
--```plaintext
--Params: index - Index of the random write target in the shader.
--        uav - Buffer or texture to set as the write target.
--        preserveCounterValue - Whether to leave the append/consume counter value unchanged.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param index int
---@param uav UnityEngine.RenderTexture
function CS.UnityEngine.Graphics:SetRandomWriteTarget(index, uav) end

--
--Set random write target for level pixel shaders.
--
--```plaintext
--Params: index - Index of the random write target in the shader.
--        uav - Buffer or texture to set as the write target.
--        preserveCounterValue - Whether to leave the append/consume counter value unchanged.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param index int
---@param uav UnityEngine.ComputeBuffer
---@param preserveCounterValue bool
function CS.UnityEngine.Graphics:SetRandomWriteTarget(index, uav, preserveCounterValue) end

--
--Set random write target for level pixel shaders.
--
--```plaintext
--Params: index - Index of the random write target in the shader.
--        uav - Buffer or texture to set as the write target.
--        preserveCounterValue - Whether to leave the append/consume counter value unchanged.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param index int
---@param uav UnityEngine.GraphicsBuffer
---@param preserveCounterValue bool
function CS.UnityEngine.Graphics:SetRandomWriteTarget(index, uav, preserveCounterValue) end

--
--Copy texture contents.
--
--```plaintext
--Params: src - Source texture.
--        dst - Destination texture.
--        srcElement - Source texture element (cubemap face, texture array layer or 3D texture depth slice).
--        srcMip - Source texture mipmap level.
--        dstElement - Destination texture element (cubemap face, texture array layer or 3D texture depth slice).
--        dstMip - Destination texture mipmap level.
--        srcX - X coordinate of source texture region to copy (left side is zero).
--        srcY - Y coordinate of source texture region to copy (bottom is zero).
--        srcWidth - Width of source texture region to copy.
--        srcHeight - Height of source texture region to copy.
--        dstX - X coordinate of where to copy region in destination texture (left side is zero).
--        dstY - Y coordinate of where to copy region in destination texture (bottom is zero).
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param src UnityEngine.Texture
---@param dst UnityEngine.Texture
function CS.UnityEngine.Graphics:CopyTexture(src, dst) end

---@source UnityEngine.CoreModule.dll
---@param src UnityEngine.Texture
---@param srcElement int
---@param dst UnityEngine.Texture
---@param dstElement int
function CS.UnityEngine.Graphics:CopyTexture(src, srcElement, dst, dstElement) end

--
--Copy texture contents.
--
--```plaintext
--Params: src - Source texture.
--        dst - Destination texture.
--        srcElement - Source texture element (cubemap face, texture array layer or 3D texture depth slice).
--        srcMip - Source texture mipmap level.
--        dstElement - Destination texture element (cubemap face, texture array layer or 3D texture depth slice).
--        dstMip - Destination texture mipmap level.
--        srcX - X coordinate of source texture region to copy (left side is zero).
--        srcY - Y coordinate of source texture region to copy (bottom is zero).
--        srcWidth - Width of source texture region to copy.
--        srcHeight - Height of source texture region to copy.
--        dstX - X coordinate of where to copy region in destination texture (left side is zero).
--        dstY - Y coordinate of where to copy region in destination texture (bottom is zero).
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param src UnityEngine.Texture
---@param srcElement int
---@param srcMip int
---@param dst UnityEngine.Texture
---@param dstElement int
---@param dstMip int
function CS.UnityEngine.Graphics:CopyTexture(src, srcElement, srcMip, dst, dstElement, dstMip) end

--
--Copy texture contents.
--
--```plaintext
--Params: src - Source texture.
--        dst - Destination texture.
--        srcElement - Source texture element (cubemap face, texture array layer or 3D texture depth slice).
--        srcMip - Source texture mipmap level.
--        dstElement - Destination texture element (cubemap face, texture array layer or 3D texture depth slice).
--        dstMip - Destination texture mipmap level.
--        srcX - X coordinate of source texture region to copy (left side is zero).
--        srcY - Y coordinate of source texture region to copy (bottom is zero).
--        srcWidth - Width of source texture region to copy.
--        srcHeight - Height of source texture region to copy.
--        dstX - X coordinate of where to copy region in destination texture (left side is zero).
--        dstY - Y coordinate of where to copy region in destination texture (bottom is zero).
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param src UnityEngine.Texture
---@param srcElement int
---@param srcMip int
---@param srcX int
---@param srcY int
---@param srcWidth int
---@param srcHeight int
---@param dst UnityEngine.Texture
---@param dstElement int
---@param dstMip int
---@param dstX int
---@param dstY int
function CS.UnityEngine.Graphics:CopyTexture(src, srcElement, srcMip, srcX, srcY, srcWidth, srcHeight, dst, dstElement, dstMip, dstX, dstY) end

--
--True if the call succeeded.
--
--```plaintext
--Params: src - Source texture.
--        dst - Destination texture.
--        srcElement - Source element (e.g. cubemap face).  Set this to 0 for 2D source textures.
--        dstElement - Destination element (e.g. cubemap face or texture array element).
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param src UnityEngine.Texture
---@param dst UnityEngine.Texture
---@return Boolean
function CS.UnityEngine.Graphics:ConvertTexture(src, dst) end

--
--True if the call succeeded.
--
--```plaintext
--Params: src - Source texture.
--        dst - Destination texture.
--        srcElement - Source element (e.g. cubemap face).  Set this to 0 for 2D source textures.
--        dstElement - Destination element (e.g. cubemap face or texture array element).
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param src UnityEngine.Texture
---@param srcElement int
---@param dst UnityEngine.Texture
---@param dstElement int
---@return Boolean
function CS.UnityEngine.Graphics:ConvertTexture(src, srcElement, dst, dstElement) end

--
--Returns a new GraphicsFence.
--
--```plaintext
--Params: stage - The synchronization stage. See Graphics.CreateGraphicsFence.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param stage UnityEngine.Rendering.SynchronisationStage
---@return GraphicsFence
function CS.UnityEngine.Graphics:CreateAsyncGraphicsFence(stage) end

--
--Returns a new GraphicsFence.
--
--```plaintext
--Params: stage - The synchronization stage. See Graphics.CreateGraphicsFence.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@return GraphicsFence
function CS.UnityEngine.Graphics:CreateAsyncGraphicsFence() end

---@source UnityEngine.CoreModule.dll
---@param fenceType UnityEngine.Rendering.GraphicsFenceType
---@param stage UnityEngine.Rendering.SynchronisationStageFlags
---@return GraphicsFence
function CS.UnityEngine.Graphics:CreateGraphicsFence(fenceType, stage) end

--
--Instructs the GPU's processing of the graphics queue to wait until the given GraphicsFence is passed.
--
--```plaintext
--Params: fence - The GraphicsFence that the GPU will be instructed to wait upon before proceeding with its processing of the graphics queue.
--        stage - On some platforms there is a significant gap between the vertex processing completing and the pixel processing begining for a given draw call. This parameter allows for requested wait to be before the next items vertex or pixel processing begins. If a compute shader dispatch is the next item to be submitted then this parameter is ignored.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param fence UnityEngine.Rendering.GraphicsFence
function CS.UnityEngine.Graphics:WaitOnAsyncGraphicsFence(fence) end

--
--Instructs the GPU's processing of the graphics queue to wait until the given GraphicsFence is passed.
--
--```plaintext
--Params: fence - The GraphicsFence that the GPU will be instructed to wait upon before proceeding with its processing of the graphics queue.
--        stage - On some platforms there is a significant gap between the vertex processing completing and the pixel processing begining for a given draw call. This parameter allows for requested wait to be before the next items vertex or pixel processing begins. If a compute shader dispatch is the next item to be submitted then this parameter is ignored.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param fence UnityEngine.Rendering.GraphicsFence
---@param stage UnityEngine.Rendering.SynchronisationStage
function CS.UnityEngine.Graphics:WaitOnAsyncGraphicsFence(fence, stage) end

--
--Draw a texture in screen coordinates.
--
--```plaintext
--Params: screenRect - Rectangle on the screen to use for the texture. In pixel coordinates with (0,0) in the upper-left corner.
--        texture - Texture to draw.
--        sourceRect - Region of the texture to use. In normalized coordinates with (0,0) in the bottom-left corner.
--        leftBorder - Number of pixels from the left that are not affected by scale.
--        rightBorder - Number of pixels from the right that are not affected by scale.
--        topBorder - Number of pixels from the top that are not affected by scale.
--        bottomBorder - Number of pixels from the bottom that are not affected by scale.
--        color - Color that modulates the output. The neutral value is (0.5, 0.5, 0.5, 0.5). Set as vertex color for the shader.
--        mat - Custom Material that can be used to draw the texture. If null is passed, a default material with the Internal-GUITexture.shader is used.
--        pass - If -1 (default), draws all passes in the material. Otherwise, draws given pass only.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param screenRect UnityEngine.Rect
---@param texture UnityEngine.Texture
---@param sourceRect UnityEngine.Rect
---@param leftBorder int
---@param rightBorder int
---@param topBorder int
---@param bottomBorder int
---@param color UnityEngine.Color
---@param mat UnityEngine.Material
---@param pass int
function CS.UnityEngine.Graphics:DrawTexture(screenRect, texture, sourceRect, leftBorder, rightBorder, topBorder, bottomBorder, color, mat, pass) end

--
--Draw a texture in screen coordinates.
--
--```plaintext
--Params: screenRect - Rectangle on the screen to use for the texture. In pixel coordinates with (0,0) in the upper-left corner.
--        texture - Texture to draw.
--        sourceRect - Region of the texture to use. In normalized coordinates with (0,0) in the bottom-left corner.
--        leftBorder - Number of pixels from the left that are not affected by scale.
--        rightBorder - Number of pixels from the right that are not affected by scale.
--        topBorder - Number of pixels from the top that are not affected by scale.
--        bottomBorder - Number of pixels from the bottom that are not affected by scale.
--        color - Color that modulates the output. The neutral value is (0.5, 0.5, 0.5, 0.5). Set as vertex color for the shader.
--        mat - Custom Material that can be used to draw the texture. If null is passed, a default material with the Internal-GUITexture.shader is used.
--        pass - If -1 (default), draws all passes in the material. Otherwise, draws given pass only.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param screenRect UnityEngine.Rect
---@param texture UnityEngine.Texture
---@param sourceRect UnityEngine.Rect
---@param leftBorder int
---@param rightBorder int
---@param topBorder int
---@param bottomBorder int
---@param mat UnityEngine.Material
---@param pass int
function CS.UnityEngine.Graphics:DrawTexture(screenRect, texture, sourceRect, leftBorder, rightBorder, topBorder, bottomBorder, mat, pass) end

--
--Draw a texture in screen coordinates.
--
--```plaintext
--Params: screenRect - Rectangle on the screen to use for the texture. In pixel coordinates with (0,0) in the upper-left corner.
--        texture - Texture to draw.
--        sourceRect - Region of the texture to use. In normalized coordinates with (0,0) in the bottom-left corner.
--        leftBorder - Number of pixels from the left that are not affected by scale.
--        rightBorder - Number of pixels from the right that are not affected by scale.
--        topBorder - Number of pixels from the top that are not affected by scale.
--        bottomBorder - Number of pixels from the bottom that are not affected by scale.
--        color - Color that modulates the output. The neutral value is (0.5, 0.5, 0.5, 0.5). Set as vertex color for the shader.
--        mat - Custom Material that can be used to draw the texture. If null is passed, a default material with the Internal-GUITexture.shader is used.
--        pass - If -1 (default), draws all passes in the material. Otherwise, draws given pass only.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param screenRect UnityEngine.Rect
---@param texture UnityEngine.Texture
---@param leftBorder int
---@param rightBorder int
---@param topBorder int
---@param bottomBorder int
---@param mat UnityEngine.Material
---@param pass int
function CS.UnityEngine.Graphics:DrawTexture(screenRect, texture, leftBorder, rightBorder, topBorder, bottomBorder, mat, pass) end

--
--Draw a texture in screen coordinates.
--
--```plaintext
--Params: screenRect - Rectangle on the screen to use for the texture. In pixel coordinates with (0,0) in the upper-left corner.
--        texture - Texture to draw.
--        sourceRect - Region of the texture to use. In normalized coordinates with (0,0) in the bottom-left corner.
--        leftBorder - Number of pixels from the left that are not affected by scale.
--        rightBorder - Number of pixels from the right that are not affected by scale.
--        topBorder - Number of pixels from the top that are not affected by scale.
--        bottomBorder - Number of pixels from the bottom that are not affected by scale.
--        color - Color that modulates the output. The neutral value is (0.5, 0.5, 0.5, 0.5). Set as vertex color for the shader.
--        mat - Custom Material that can be used to draw the texture. If null is passed, a default material with the Internal-GUITexture.shader is used.
--        pass - If -1 (default), draws all passes in the material. Otherwise, draws given pass only.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param screenRect UnityEngine.Rect
---@param texture UnityEngine.Texture
---@param mat UnityEngine.Material
---@param pass int
function CS.UnityEngine.Graphics:DrawTexture(screenRect, texture, mat, pass) end

--
--Draw a mesh immediately.
--
--```plaintext
--Params: mesh - The Mesh to draw.
--        position - Position of the mesh.
--        rotation - Rotation of the mesh.
--        matrix - The transformation matrix of the mesh (combines position, rotation and other transformations).
--        materialIndex - Subset of the mesh to draw.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param position UnityEngine.Vector3
---@param rotation UnityEngine.Quaternion
---@param materialIndex int
function CS.UnityEngine.Graphics:DrawMeshNow(mesh, position, rotation, materialIndex) end

--
--Draw a mesh immediately.
--
--```plaintext
--Params: mesh - The Mesh to draw.
--        position - Position of the mesh.
--        rotation - Rotation of the mesh.
--        matrix - The transformation matrix of the mesh (combines position, rotation and other transformations).
--        materialIndex - Subset of the mesh to draw.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param matrix UnityEngine.Matrix4x4
---@param materialIndex int
function CS.UnityEngine.Graphics:DrawMeshNow(mesh, matrix, materialIndex) end

--
--Draw a mesh immediately.
--
--```plaintext
--Params: mesh - The Mesh to draw.
--        position - Position of the mesh.
--        rotation - Rotation of the mesh.
--        matrix - The transformation matrix of the mesh (combines position, rotation and other transformations).
--        materialIndex - Subset of the mesh to draw.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param position UnityEngine.Vector3
---@param rotation UnityEngine.Quaternion
function CS.UnityEngine.Graphics:DrawMeshNow(mesh, position, rotation) end

--
--Draw a mesh immediately.
--
--```plaintext
--Params: mesh - The Mesh to draw.
--        position - Position of the mesh.
--        rotation - Rotation of the mesh.
--        matrix - The transformation matrix of the mesh (combines position, rotation and other transformations).
--        materialIndex - Subset of the mesh to draw.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param matrix UnityEngine.Matrix4x4
function CS.UnityEngine.Graphics:DrawMeshNow(mesh, matrix) end

--
--Draw a mesh.
--
--```plaintext
--Params: mesh - The Mesh to draw.
--        position - Position of the mesh.
--        rotation - Rotation of the mesh.
--        matrix - Transformation matrix of the mesh (combines position, rotation and other transformations).
--        material - Material to use.
--        layer - to use.
--        camera - If null (default), the mesh will be drawn in all cameras. Otherwise it will be rendered in the given Camera only.
--        submeshIndex - Which subset of the mesh to draw. This applies only to meshes that are composed of several materials.
--        properties - Additional material properties to apply onto material just before this mesh will be drawn. See MaterialPropertyBlock.
--        castShadows - Determines whether the mesh can cast shadows.
--        receiveShadows - Determines whether the mesh can receive shadows.
--        useLightProbes - Should the mesh use light probes?
--        probeAnchor - If used, the mesh will use this Transform's position to sample light probes and find the matching reflection probe.
--        lightProbeUsage - LightProbeUsage for the mesh.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param position UnityEngine.Vector3
---@param rotation UnityEngine.Quaternion
---@param material UnityEngine.Material
---@param layer int
---@param camera UnityEngine.Camera
---@param submeshIndex int
---@param properties UnityEngine.MaterialPropertyBlock
---@param castShadows bool
---@param receiveShadows bool
---@param useLightProbes bool
function CS.UnityEngine.Graphics:DrawMesh(mesh, position, rotation, material, layer, camera, submeshIndex, properties, castShadows, receiveShadows, useLightProbes) end

--
--Draw a mesh.
--
--```plaintext
--Params: mesh - The Mesh to draw.
--        position - Position of the mesh.
--        rotation - Rotation of the mesh.
--        matrix - Transformation matrix of the mesh (combines position, rotation and other transformations).
--        material - Material to use.
--        layer - to use.
--        camera - If null (default), the mesh will be drawn in all cameras. Otherwise it will be rendered in the given Camera only.
--        submeshIndex - Which subset of the mesh to draw. This applies only to meshes that are composed of several materials.
--        properties - Additional material properties to apply onto material just before this mesh will be drawn. See MaterialPropertyBlock.
--        castShadows - Determines whether the mesh can cast shadows.
--        receiveShadows - Determines whether the mesh can receive shadows.
--        useLightProbes - Should the mesh use light probes?
--        probeAnchor - If used, the mesh will use this Transform's position to sample light probes and find the matching reflection probe.
--        lightProbeUsage - LightProbeUsage for the mesh.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param position UnityEngine.Vector3
---@param rotation UnityEngine.Quaternion
---@param material UnityEngine.Material
---@param layer int
---@param camera UnityEngine.Camera
---@param submeshIndex int
---@param properties UnityEngine.MaterialPropertyBlock
---@param castShadows UnityEngine.Rendering.ShadowCastingMode
---@param receiveShadows bool
---@param probeAnchor UnityEngine.Transform
---@param useLightProbes bool
function CS.UnityEngine.Graphics:DrawMesh(mesh, position, rotation, material, layer, camera, submeshIndex, properties, castShadows, receiveShadows, probeAnchor, useLightProbes) end

--
--Draw a mesh.
--
--```plaintext
--Params: mesh - The Mesh to draw.
--        position - Position of the mesh.
--        rotation - Rotation of the mesh.
--        matrix - Transformation matrix of the mesh (combines position, rotation and other transformations).
--        material - Material to use.
--        layer - to use.
--        camera - If null (default), the mesh will be drawn in all cameras. Otherwise it will be rendered in the given Camera only.
--        submeshIndex - Which subset of the mesh to draw. This applies only to meshes that are composed of several materials.
--        properties - Additional material properties to apply onto material just before this mesh will be drawn. See MaterialPropertyBlock.
--        castShadows - Determines whether the mesh can cast shadows.
--        receiveShadows - Determines whether the mesh can receive shadows.
--        useLightProbes - Should the mesh use light probes?
--        probeAnchor - If used, the mesh will use this Transform's position to sample light probes and find the matching reflection probe.
--        lightProbeUsage - LightProbeUsage for the mesh.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param matrix UnityEngine.Matrix4x4
---@param material UnityEngine.Material
---@param layer int
---@param camera UnityEngine.Camera
---@param submeshIndex int
---@param properties UnityEngine.MaterialPropertyBlock
---@param castShadows bool
---@param receiveShadows bool
---@param useLightProbes bool
function CS.UnityEngine.Graphics:DrawMesh(mesh, matrix, material, layer, camera, submeshIndex, properties, castShadows, receiveShadows, useLightProbes) end

--
--Draw a mesh.
--
--```plaintext
--Params: mesh - The Mesh to draw.
--        position - Position of the mesh.
--        rotation - Rotation of the mesh.
--        matrix - Transformation matrix of the mesh (combines position, rotation and other transformations).
--        material - Material to use.
--        layer - to use.
--        camera - If null (default), the mesh will be drawn in all cameras. Otherwise it will be rendered in the given Camera only.
--        submeshIndex - Which subset of the mesh to draw. This applies only to meshes that are composed of several materials.
--        properties - Additional material properties to apply onto material just before this mesh will be drawn. See MaterialPropertyBlock.
--        castShadows - Determines whether the mesh can cast shadows.
--        receiveShadows - Determines whether the mesh can receive shadows.
--        useLightProbes - Should the mesh use light probes?
--        probeAnchor - If used, the mesh will use this Transform's position to sample light probes and find the matching reflection probe.
--        lightProbeUsage - LightProbeUsage for the mesh.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param matrix UnityEngine.Matrix4x4
---@param material UnityEngine.Material
---@param layer int
---@param camera UnityEngine.Camera
---@param submeshIndex int
---@param properties UnityEngine.MaterialPropertyBlock
---@param castShadows UnityEngine.Rendering.ShadowCastingMode
---@param receiveShadows bool
---@param probeAnchor UnityEngine.Transform
---@param lightProbeUsage UnityEngine.Rendering.LightProbeUsage
---@param lightProbeProxyVolume UnityEngine.LightProbeProxyVolume
function CS.UnityEngine.Graphics:DrawMesh(mesh, matrix, material, layer, camera, submeshIndex, properties, castShadows, receiveShadows, probeAnchor, lightProbeUsage, lightProbeProxyVolume) end

--
--Draws the same mesh multiple times using GPU instancing.
--
--```plaintext
--Params: mesh - The Mesh to draw.
--        submeshIndex - Which subset of the mesh to draw. This applies only to meshes that are composed of several materials.
--        material - Material to use.
--        matrices - The array of object transformation matrices.
--        count - The number of instances to be drawn.
--        properties - Additional material properties to apply. See MaterialPropertyBlock.
--        castShadows - Determines whether the Meshes should cast shadows.
--        receiveShadows - Determines whether the Meshes should receive shadows.
--        layer - to use.
--        camera - If null (default), the mesh will be drawn in all cameras. Otherwise it will be drawn in the given Camera only.
--        lightProbeUsage - LightProbeUsage for the instances.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param submeshIndex int
---@param material UnityEngine.Material
---@param matrices UnityEngine.Matrix4x4[]
---@param count int
---@param properties UnityEngine.MaterialPropertyBlock
---@param castShadows UnityEngine.Rendering.ShadowCastingMode
---@param receiveShadows bool
---@param layer int
---@param camera UnityEngine.Camera
---@param lightProbeUsage UnityEngine.Rendering.LightProbeUsage
---@param lightProbeProxyVolume UnityEngine.LightProbeProxyVolume
function CS.UnityEngine.Graphics:DrawMeshInstanced(mesh, submeshIndex, material, matrices, count, properties, castShadows, receiveShadows, layer, camera, lightProbeUsage, lightProbeProxyVolume) end

---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param submeshIndex int
---@param material UnityEngine.Material
---@param matrices System.Collections.Generic.List<UnityEngine.Matrix4x4>
---@param properties UnityEngine.MaterialPropertyBlock
---@param castShadows UnityEngine.Rendering.ShadowCastingMode
---@param receiveShadows bool
---@param layer int
---@param camera UnityEngine.Camera
---@param lightProbeUsage UnityEngine.Rendering.LightProbeUsage
---@param lightProbeProxyVolume UnityEngine.LightProbeProxyVolume
function CS.UnityEngine.Graphics:DrawMeshInstanced(mesh, submeshIndex, material, matrices, properties, castShadows, receiveShadows, layer, camera, lightProbeUsage, lightProbeProxyVolume) end

--
--Draws the same mesh multiple times using GPU instancing.
--This is similar to Graphics.DrawMeshInstancedIndirect, except that when the instance count is known from script, it can be supplied directly using this method, rather than via a ComputeBuffer.
--
--```plaintext
--Params: mesh - The Mesh to draw.
--        submeshIndex - Which subset of the mesh to draw. This applies only to meshes that are composed of several materials.
--        material - Material to use.
--        bounds - The bounding volume surrounding the instances you intend to draw.
--        count - The number of instances to be drawn.
--        properties - Additional material properties to apply. See MaterialPropertyBlock.
--        castShadows - Determines whether the Meshes should cast shadows.
--        receiveShadows - Determines whether the Meshes should receive shadows.
--        layer - to use.
--        camera - If null (default), the mesh will be drawn in all cameras. Otherwise it will be drawn in the given Camera only.
--        lightProbeUsage - LightProbeUsage for the instances.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param submeshIndex int
---@param material UnityEngine.Material
---@param bounds UnityEngine.Bounds
---@param count int
---@param properties UnityEngine.MaterialPropertyBlock
---@param castShadows UnityEngine.Rendering.ShadowCastingMode
---@param receiveShadows bool
---@param layer int
---@param camera UnityEngine.Camera
---@param lightProbeUsage UnityEngine.Rendering.LightProbeUsage
---@param lightProbeProxyVolume UnityEngine.LightProbeProxyVolume
function CS.UnityEngine.Graphics:DrawMeshInstancedProcedural(mesh, submeshIndex, material, bounds, count, properties, castShadows, receiveShadows, layer, camera, lightProbeUsage, lightProbeProxyVolume) end

--
--Draws the same mesh multiple times using GPU instancing.
--
--```plaintext
--Params: mesh - The Mesh to draw.
--        submeshIndex - Which subset of the mesh to draw. This applies only to meshes that are composed of several materials.
--        material - Material to use.
--        bounds - The bounding volume surrounding the instances you intend to draw.
--        bufferWithArgs - The GPU buffer containing the arguments for how many instances of this mesh to draw.
--        argsOffset - The byte offset into the buffer, where the draw arguments start.
--        properties - Additional material properties to apply. See MaterialPropertyBlock.
--        castShadows - Determines whether the mesh can cast shadows.
--        receiveShadows - Determines whether the mesh can receive shadows.
--        layer - to use.
--        camera - If null (default), the mesh will be drawn in all cameras. Otherwise it will be drawn in the given Camera only.
--        lightProbeUsage - LightProbeUsage for the instances.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param submeshIndex int
---@param material UnityEngine.Material
---@param bounds UnityEngine.Bounds
---@param bufferWithArgs UnityEngine.ComputeBuffer
---@param argsOffset int
---@param properties UnityEngine.MaterialPropertyBlock
---@param castShadows UnityEngine.Rendering.ShadowCastingMode
---@param receiveShadows bool
---@param layer int
---@param camera UnityEngine.Camera
---@param lightProbeUsage UnityEngine.Rendering.LightProbeUsage
---@param lightProbeProxyVolume UnityEngine.LightProbeProxyVolume
function CS.UnityEngine.Graphics:DrawMeshInstancedIndirect(mesh, submeshIndex, material, bounds, bufferWithArgs, argsOffset, properties, castShadows, receiveShadows, layer, camera, lightProbeUsage, lightProbeProxyVolume) end

--
--Draws the same mesh multiple times using GPU instancing.
--
--```plaintext
--Params: mesh - The Mesh to draw.
--        submeshIndex - Which subset of the mesh to draw. This applies only to meshes that are composed of several materials.
--        material - Material to use.
--        bounds - The bounding volume surrounding the instances you intend to draw.
--        bufferWithArgs - The GPU buffer containing the arguments for how many instances of this mesh to draw.
--        argsOffset - The byte offset into the buffer, where the draw arguments start.
--        properties - Additional material properties to apply. See MaterialPropertyBlock.
--        castShadows - Determines whether the mesh can cast shadows.
--        receiveShadows - Determines whether the mesh can receive shadows.
--        layer - to use.
--        camera - If null (default), the mesh will be drawn in all cameras. Otherwise it will be drawn in the given Camera only.
--        lightProbeUsage - LightProbeUsage for the instances.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param submeshIndex int
---@param material UnityEngine.Material
---@param bounds UnityEngine.Bounds
---@param bufferWithArgs UnityEngine.GraphicsBuffer
---@param argsOffset int
---@param properties UnityEngine.MaterialPropertyBlock
---@param castShadows UnityEngine.Rendering.ShadowCastingMode
---@param receiveShadows bool
---@param layer int
---@param camera UnityEngine.Camera
---@param lightProbeUsage UnityEngine.Rendering.LightProbeUsage
---@param lightProbeProxyVolume UnityEngine.LightProbeProxyVolume
function CS.UnityEngine.Graphics:DrawMeshInstancedIndirect(mesh, submeshIndex, material, bounds, bufferWithArgs, argsOffset, properties, castShadows, receiveShadows, layer, camera, lightProbeUsage, lightProbeProxyVolume) end

--
--Draws procedural geometry on the GPU.
--
--```plaintext
--Params: topology - Topology of the procedural geometry.
--        vertexCount - Vertex count to render.
--        instanceCount - Instance count to render.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param topology UnityEngine.MeshTopology
---@param vertexCount int
---@param instanceCount int
function CS.UnityEngine.Graphics:DrawProceduralNow(topology, vertexCount, instanceCount) end

--
--Draws procedural geometry on the GPU.
--
--```plaintext
--Params: topology - Topology of the procedural geometry.
--        indexCount - Index count to render.
--        instanceCount - Instance count to render.
--        indexBuffer - Index buffer used to submit vertices to the GPU.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param topology UnityEngine.MeshTopology
---@param indexBuffer UnityEngine.GraphicsBuffer
---@param indexCount int
---@param instanceCount int
function CS.UnityEngine.Graphics:DrawProceduralNow(topology, indexBuffer, indexCount, instanceCount) end

--
--Draws procedural geometry on the GPU.
--
--```plaintext
--Params: topology - Topology of the procedural geometry.
--        bufferWithArgs - Buffer with draw arguments.
--        argsOffset - Byte offset where in the buffer the draw arguments are.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param topology UnityEngine.MeshTopology
---@param bufferWithArgs UnityEngine.ComputeBuffer
---@param argsOffset int
function CS.UnityEngine.Graphics:DrawProceduralIndirectNow(topology, bufferWithArgs, argsOffset) end

--
--Draws procedural geometry on the GPU.
--
--```plaintext
--Params: topology - Topology of the procedural geometry.
--        indexBuffer - Index buffer used to submit vertices to the GPU.
--        bufferWithArgs - Buffer with draw arguments.
--        argsOffset - Byte offset where in the buffer the draw arguments are.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param topology UnityEngine.MeshTopology
---@param indexBuffer UnityEngine.GraphicsBuffer
---@param bufferWithArgs UnityEngine.ComputeBuffer
---@param argsOffset int
function CS.UnityEngine.Graphics:DrawProceduralIndirectNow(topology, indexBuffer, bufferWithArgs, argsOffset) end

--
--Draws procedural geometry on the GPU.
--
--```plaintext
--Params: topology - Topology of the procedural geometry.
--        bufferWithArgs - Buffer with draw arguments.
--        argsOffset - Byte offset where in the buffer the draw arguments are.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param topology UnityEngine.MeshTopology
---@param bufferWithArgs UnityEngine.GraphicsBuffer
---@param argsOffset int
function CS.UnityEngine.Graphics:DrawProceduralIndirectNow(topology, bufferWithArgs, argsOffset) end

--
--Draws procedural geometry on the GPU.
--
--```plaintext
--Params: topology - Topology of the procedural geometry.
--        indexBuffer - Index buffer used to submit vertices to the GPU.
--        bufferWithArgs - Buffer with draw arguments.
--        argsOffset - Byte offset where in the buffer the draw arguments are.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param topology UnityEngine.MeshTopology
---@param indexBuffer UnityEngine.GraphicsBuffer
---@param bufferWithArgs UnityEngine.GraphicsBuffer
---@param argsOffset int
function CS.UnityEngine.Graphics:DrawProceduralIndirectNow(topology, indexBuffer, bufferWithArgs, argsOffset) end

--
--Draws procedural geometry on the GPU.
--
--```plaintext
--Params: material - Material to use.
--        bounds - The bounding volume surrounding the instances you intend to draw.
--        topology - Topology of the procedural geometry.
--        instanceCount - Instance count to render.
--        vertexCount - Vertex count to render.
--        camera - If null (default), the mesh will be drawn in all cameras. Otherwise it will be rendered in the given Camera only.
--        properties - Additional material properties to apply onto material just before this mesh will be drawn. See MaterialPropertyBlock.
--        castShadows - Determines whether the mesh can cast shadows.
--        receiveShadows - Determines whether the mesh can receive shadows.
--        layer - to use.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param material UnityEngine.Material
---@param bounds UnityEngine.Bounds
---@param topology UnityEngine.MeshTopology
---@param vertexCount int
---@param instanceCount int
---@param camera UnityEngine.Camera
---@param properties UnityEngine.MaterialPropertyBlock
---@param castShadows UnityEngine.Rendering.ShadowCastingMode
---@param receiveShadows bool
---@param layer int
function CS.UnityEngine.Graphics:DrawProcedural(material, bounds, topology, vertexCount, instanceCount, camera, properties, castShadows, receiveShadows, layer) end

--
--Draws procedural geometry on the GPU.
--
--```plaintext
--Params: material - Material to use.
--        bounds - The bounding volume surrounding the instances you intend to draw.
--        topology - Topology of the procedural geometry.
--        indexBuffer - Index buffer used to submit vertices to the GPU.
--        instanceCount - Instance count to render.
--        indexCount - Index count to render.
--        camera - If null (default), the mesh will be drawn in all cameras. Otherwise it will be rendered in the given Camera only.
--        properties - Additional material properties to apply onto material just before this mesh will be drawn. See MaterialPropertyBlock.
--        castShadows - Determines whether the mesh can cast shadows.
--        receiveShadows - Determines whether the mesh can receive shadows.
--        layer - to use.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param material UnityEngine.Material
---@param bounds UnityEngine.Bounds
---@param topology UnityEngine.MeshTopology
---@param indexBuffer UnityEngine.GraphicsBuffer
---@param indexCount int
---@param instanceCount int
---@param camera UnityEngine.Camera
---@param properties UnityEngine.MaterialPropertyBlock
---@param castShadows UnityEngine.Rendering.ShadowCastingMode
---@param receiveShadows bool
---@param layer int
function CS.UnityEngine.Graphics:DrawProcedural(material, bounds, topology, indexBuffer, indexCount, instanceCount, camera, properties, castShadows, receiveShadows, layer) end

--
--Draws procedural geometry on the GPU.
--
--```plaintext
--Params: material - Material to use.
--        bounds - The bounding volume surrounding the instances you intend to draw.
--        topology - Topology of the procedural geometry.
--        camera - If null (default), the mesh will be drawn in all cameras. Otherwise it will be rendered in the given Camera only.
--        bufferWithArgs - Buffer with draw arguments.
--        argsOffset - Byte offset where in the buffer the draw arguments are.
--        properties - Additional material properties to apply onto material just before this mesh will be drawn. See MaterialPropertyBlock.
--        castShadows - Determines whether the mesh can cast shadows.
--        receiveShadows - Determines whether the mesh can receive shadows.
--        layer - to use.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param material UnityEngine.Material
---@param bounds UnityEngine.Bounds
---@param topology UnityEngine.MeshTopology
---@param bufferWithArgs UnityEngine.ComputeBuffer
---@param argsOffset int
---@param camera UnityEngine.Camera
---@param properties UnityEngine.MaterialPropertyBlock
---@param castShadows UnityEngine.Rendering.ShadowCastingMode
---@param receiveShadows bool
---@param layer int
function CS.UnityEngine.Graphics:DrawProceduralIndirect(material, bounds, topology, bufferWithArgs, argsOffset, camera, properties, castShadows, receiveShadows, layer) end

--
--Draws procedural geometry on the GPU.
--
--```plaintext
--Params: material - Material to use.
--        bounds - The bounding volume surrounding the instances you intend to draw.
--        topology - Topology of the procedural geometry.
--        indexBuffer - Index buffer used to submit vertices to the GPU.
--        camera - If null (default), the mesh will be drawn in all cameras. Otherwise it will be rendered in the given Camera only.
--        bufferWithArgs - Buffer with draw arguments.
--        argsOffset - Byte offset where in the buffer the draw arguments are.
--        properties - Additional material properties to apply onto material just before this mesh will be drawn. See MaterialPropertyBlock.
--        castShadows - Determines whether the mesh can cast shadows.
--        receiveShadows - Determines whether the mesh can receive shadows.
--        layer - to use.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param material UnityEngine.Material
---@param bounds UnityEngine.Bounds
---@param topology UnityEngine.MeshTopology
---@param indexBuffer UnityEngine.GraphicsBuffer
---@param bufferWithArgs UnityEngine.ComputeBuffer
---@param argsOffset int
---@param camera UnityEngine.Camera
---@param properties UnityEngine.MaterialPropertyBlock
---@param castShadows UnityEngine.Rendering.ShadowCastingMode
---@param receiveShadows bool
---@param layer int
function CS.UnityEngine.Graphics:DrawProceduralIndirect(material, bounds, topology, indexBuffer, bufferWithArgs, argsOffset, camera, properties, castShadows, receiveShadows, layer) end

--
--Copies source texture into destination render texture with a shader.
--
--```plaintext
--Params: source - Source texture.
--        dest - The destination RenderTexture. Set this to null to blit directly to screen. See description for more information.
--        mat - Material to use. Material's shader could do some post-processing effect, for example.
--        pass - If -1 (default), draws all passes in the material. Otherwise, draws given pass only.
--        offset - Offset applied to the source texture coordinate.
--        scale - Scale applied to the source texture coordinate.
--        sourceDepthSlice - The texture array source slice to perform the blit from.
--        destDepthSlice - The texture array destination slice to perform the blit to.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param source UnityEngine.Texture
---@param dest UnityEngine.RenderTexture
function CS.UnityEngine.Graphics:Blit(source, dest) end

--
--Copies source texture into destination render texture with a shader.
--
--```plaintext
--Params: source - Source texture.
--        dest - The destination RenderTexture. Set this to null to blit directly to screen. See description for more information.
--        mat - Material to use. Material's shader could do some post-processing effect, for example.
--        pass - If -1 (default), draws all passes in the material. Otherwise, draws given pass only.
--        offset - Offset applied to the source texture coordinate.
--        scale - Scale applied to the source texture coordinate.
--        sourceDepthSlice - The texture array source slice to perform the blit from.
--        destDepthSlice - The texture array destination slice to perform the blit to.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param source UnityEngine.Texture
---@param dest UnityEngine.RenderTexture
---@param sourceDepthSlice int
---@param destDepthSlice int
function CS.UnityEngine.Graphics:Blit(source, dest, sourceDepthSlice, destDepthSlice) end

--
--Copies source texture into destination render texture with a shader.
--
--```plaintext
--Params: source - Source texture.
--        dest - The destination RenderTexture. Set this to null to blit directly to screen. See description for more information.
--        mat - Material to use. Material's shader could do some post-processing effect, for example.
--        pass - If -1 (default), draws all passes in the material. Otherwise, draws given pass only.
--        offset - Offset applied to the source texture coordinate.
--        scale - Scale applied to the source texture coordinate.
--        sourceDepthSlice - The texture array source slice to perform the blit from.
--        destDepthSlice - The texture array destination slice to perform the blit to.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param source UnityEngine.Texture
---@param dest UnityEngine.RenderTexture
---@param scale UnityEngine.Vector2
---@param offset UnityEngine.Vector2
function CS.UnityEngine.Graphics:Blit(source, dest, scale, offset) end

--
--Copies source texture into destination render texture with a shader.
--
--```plaintext
--Params: source - Source texture.
--        dest - The destination RenderTexture. Set this to null to blit directly to screen. See description for more information.
--        mat - Material to use. Material's shader could do some post-processing effect, for example.
--        pass - If -1 (default), draws all passes in the material. Otherwise, draws given pass only.
--        offset - Offset applied to the source texture coordinate.
--        scale - Scale applied to the source texture coordinate.
--        sourceDepthSlice - The texture array source slice to perform the blit from.
--        destDepthSlice - The texture array destination slice to perform the blit to.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param source UnityEngine.Texture
---@param dest UnityEngine.RenderTexture
---@param scale UnityEngine.Vector2
---@param offset UnityEngine.Vector2
---@param sourceDepthSlice int
---@param destDepthSlice int
function CS.UnityEngine.Graphics:Blit(source, dest, scale, offset, sourceDepthSlice, destDepthSlice) end

--
--Copies source texture into destination render texture with a shader.
--
--```plaintext
--Params: source - Source texture.
--        dest - The destination RenderTexture. Set this to null to blit directly to screen. See description for more information.
--        mat - Material to use. Material's shader could do some post-processing effect, for example.
--        pass - If -1 (default), draws all passes in the material. Otherwise, draws given pass only.
--        offset - Offset applied to the source texture coordinate.
--        scale - Scale applied to the source texture coordinate.
--        sourceDepthSlice - The texture array source slice to perform the blit from.
--        destDepthSlice - The texture array destination slice to perform the blit to.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param source UnityEngine.Texture
---@param dest UnityEngine.RenderTexture
---@param mat UnityEngine.Material
---@param pass int
function CS.UnityEngine.Graphics:Blit(source, dest, mat, pass) end

---@source UnityEngine.CoreModule.dll
---@param source UnityEngine.Texture
---@param dest UnityEngine.RenderTexture
---@param mat UnityEngine.Material
---@param pass int
---@param destDepthSlice int
function CS.UnityEngine.Graphics:Blit(source, dest, mat, pass, destDepthSlice) end

---@source UnityEngine.CoreModule.dll
---@param source UnityEngine.Texture
---@param dest UnityEngine.RenderTexture
---@param mat UnityEngine.Material
function CS.UnityEngine.Graphics:Blit(source, dest, mat) end

--
--Copies source texture into destination render texture with a shader.
--
--```plaintext
--Params: source - Source texture.
--        dest - The destination RenderTexture. Set this to null to blit directly to screen. See description for more information.
--        mat - Material to use. Material's shader could do some post-processing effect, for example.
--        pass - If -1 (default), draws all passes in the material. Otherwise, draws given pass only.
--        offset - Offset applied to the source texture coordinate.
--        scale - Scale applied to the source texture coordinate.
--        sourceDepthSlice - The texture array source slice to perform the blit from.
--        destDepthSlice - The texture array destination slice to perform the blit to.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param source UnityEngine.Texture
---@param mat UnityEngine.Material
---@param pass int
function CS.UnityEngine.Graphics:Blit(source, mat, pass) end

--
--Copies source texture into destination render texture with a shader.
--
--```plaintext
--Params: source - Source texture.
--        dest - The destination RenderTexture. Set this to null to blit directly to screen. See description for more information.
--        mat - Material to use. Material's shader could do some post-processing effect, for example.
--        pass - If -1 (default), draws all passes in the material. Otherwise, draws given pass only.
--        offset - Offset applied to the source texture coordinate.
--        scale - Scale applied to the source texture coordinate.
--        sourceDepthSlice - The texture array source slice to perform the blit from.
--        destDepthSlice - The texture array destination slice to perform the blit to.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param source UnityEngine.Texture
---@param mat UnityEngine.Material
---@param pass int
---@param destDepthSlice int
function CS.UnityEngine.Graphics:Blit(source, mat, pass, destDepthSlice) end

---@source UnityEngine.CoreModule.dll
---@param source UnityEngine.Texture
---@param mat UnityEngine.Material
function CS.UnityEngine.Graphics:Blit(source, mat) end

--
--Copies source texture into destination, for multi-tap shader.
--
--```plaintext
--Params: source - Source texture.
--        dest - Destination RenderTexture, or null to blit directly to screen.
--        mat - Material to use for copying. Material's shader should do some post-processing effect.
--        offsets - Variable number of filtering offsets. Offsets are given in pixels.
--        destDepthSlice - The texture array destination slice to blit to.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param source UnityEngine.Texture
---@param dest UnityEngine.RenderTexture
---@param mat UnityEngine.Material
---@param offsets UnityEngine.Vector2[]
function CS.UnityEngine.Graphics:BlitMultiTap(source, dest, mat, offsets) end

--
--Copies source texture into destination, for multi-tap shader.
--
--```plaintext
--Params: source - Source texture.
--        dest - Destination RenderTexture, or null to blit directly to screen.
--        mat - Material to use for copying. Material's shader should do some post-processing effect.
--        offsets - Variable number of filtering offsets. Offsets are given in pixels.
--        destDepthSlice - The texture array destination slice to blit to.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param source UnityEngine.Texture
---@param dest UnityEngine.RenderTexture
---@param mat UnityEngine.Material
---@param destDepthSlice int
---@param offsets UnityEngine.Vector2[]
function CS.UnityEngine.Graphics:BlitMultiTap(source, dest, mat, destDepthSlice, offsets) end

---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param position UnityEngine.Vector3
---@param rotation UnityEngine.Quaternion
function CS.UnityEngine.Graphics:DrawMesh(mesh, position, rotation) end

---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param position UnityEngine.Vector3
---@param rotation UnityEngine.Quaternion
---@param materialIndex int
function CS.UnityEngine.Graphics:DrawMesh(mesh, position, rotation, materialIndex) end

---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param matrix UnityEngine.Matrix4x4
function CS.UnityEngine.Graphics:DrawMesh(mesh, matrix) end

---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param matrix UnityEngine.Matrix4x4
---@param materialIndex int
function CS.UnityEngine.Graphics:DrawMesh(mesh, matrix, materialIndex) end

---@source UnityEngine.CoreModule.dll
---@param topology UnityEngine.MeshTopology
---@param vertexCount int
---@param instanceCount int
function CS.UnityEngine.Graphics:DrawProcedural(topology, vertexCount, instanceCount) end

---@source UnityEngine.CoreModule.dll
---@param topology UnityEngine.MeshTopology
---@param bufferWithArgs UnityEngine.ComputeBuffer
---@param argsOffset int
function CS.UnityEngine.Graphics:DrawProceduralIndirect(topology, bufferWithArgs, argsOffset) end

--
--This functionality is deprecated, and should no longer be used. Please use Graphics.CreateGraphicsFence.
--
---@source UnityEngine.CoreModule.dll
---@param stage UnityEngine.Rendering.SynchronisationStage
---@return GPUFence
function CS.UnityEngine.Graphics:CreateGPUFence(stage) end

--
--This functionality is deprecated, and should no longer be used. Please use Graphics.WaitOnAsyncGraphicsFence.
--
---@source UnityEngine.CoreModule.dll
---@param fence UnityEngine.Rendering.GPUFence
---@param stage UnityEngine.Rendering.SynchronisationStage
function CS.UnityEngine.Graphics:WaitOnGPUFence(fence, stage) end

---@source UnityEngine.CoreModule.dll
---@return GPUFence
function CS.UnityEngine.Graphics:CreateGPUFence() end

---@source UnityEngine.CoreModule.dll
---@param fence UnityEngine.Rendering.GPUFence
function CS.UnityEngine.Graphics:WaitOnGPUFence(fence) end

---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param position UnityEngine.Vector3
---@param rotation UnityEngine.Quaternion
---@param material UnityEngine.Material
---@param layer int
function CS.UnityEngine.Graphics:DrawMesh(mesh, position, rotation, material, layer) end

---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param position UnityEngine.Vector3
---@param rotation UnityEngine.Quaternion
---@param material UnityEngine.Material
---@param layer int
---@param camera UnityEngine.Camera
function CS.UnityEngine.Graphics:DrawMesh(mesh, position, rotation, material, layer, camera) end

---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param position UnityEngine.Vector3
---@param rotation UnityEngine.Quaternion
---@param material UnityEngine.Material
---@param layer int
---@param camera UnityEngine.Camera
---@param submeshIndex int
function CS.UnityEngine.Graphics:DrawMesh(mesh, position, rotation, material, layer, camera, submeshIndex) end

---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param position UnityEngine.Vector3
---@param rotation UnityEngine.Quaternion
---@param material UnityEngine.Material
---@param layer int
---@param camera UnityEngine.Camera
---@param submeshIndex int
---@param properties UnityEngine.MaterialPropertyBlock
function CS.UnityEngine.Graphics:DrawMesh(mesh, position, rotation, material, layer, camera, submeshIndex, properties) end

---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param position UnityEngine.Vector3
---@param rotation UnityEngine.Quaternion
---@param material UnityEngine.Material
---@param layer int
---@param camera UnityEngine.Camera
---@param submeshIndex int
---@param properties UnityEngine.MaterialPropertyBlock
---@param castShadows bool
function CS.UnityEngine.Graphics:DrawMesh(mesh, position, rotation, material, layer, camera, submeshIndex, properties, castShadows) end

---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param position UnityEngine.Vector3
---@param rotation UnityEngine.Quaternion
---@param material UnityEngine.Material
---@param layer int
---@param camera UnityEngine.Camera
---@param submeshIndex int
---@param properties UnityEngine.MaterialPropertyBlock
---@param castShadows bool
---@param receiveShadows bool
function CS.UnityEngine.Graphics:DrawMesh(mesh, position, rotation, material, layer, camera, submeshIndex, properties, castShadows, receiveShadows) end

---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param position UnityEngine.Vector3
---@param rotation UnityEngine.Quaternion
---@param material UnityEngine.Material
---@param layer int
---@param camera UnityEngine.Camera
---@param submeshIndex int
---@param properties UnityEngine.MaterialPropertyBlock
---@param castShadows UnityEngine.Rendering.ShadowCastingMode
function CS.UnityEngine.Graphics:DrawMesh(mesh, position, rotation, material, layer, camera, submeshIndex, properties, castShadows) end

---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param position UnityEngine.Vector3
---@param rotation UnityEngine.Quaternion
---@param material UnityEngine.Material
---@param layer int
---@param camera UnityEngine.Camera
---@param submeshIndex int
---@param properties UnityEngine.MaterialPropertyBlock
---@param castShadows UnityEngine.Rendering.ShadowCastingMode
---@param receiveShadows bool
function CS.UnityEngine.Graphics:DrawMesh(mesh, position, rotation, material, layer, camera, submeshIndex, properties, castShadows, receiveShadows) end

---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param position UnityEngine.Vector3
---@param rotation UnityEngine.Quaternion
---@param material UnityEngine.Material
---@param layer int
---@param camera UnityEngine.Camera
---@param submeshIndex int
---@param properties UnityEngine.MaterialPropertyBlock
---@param castShadows UnityEngine.Rendering.ShadowCastingMode
---@param receiveShadows bool
---@param probeAnchor UnityEngine.Transform
function CS.UnityEngine.Graphics:DrawMesh(mesh, position, rotation, material, layer, camera, submeshIndex, properties, castShadows, receiveShadows, probeAnchor) end

---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param matrix UnityEngine.Matrix4x4
---@param material UnityEngine.Material
---@param layer int
function CS.UnityEngine.Graphics:DrawMesh(mesh, matrix, material, layer) end

---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param matrix UnityEngine.Matrix4x4
---@param material UnityEngine.Material
---@param layer int
---@param camera UnityEngine.Camera
function CS.UnityEngine.Graphics:DrawMesh(mesh, matrix, material, layer, camera) end

---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param matrix UnityEngine.Matrix4x4
---@param material UnityEngine.Material
---@param layer int
---@param camera UnityEngine.Camera
---@param submeshIndex int
function CS.UnityEngine.Graphics:DrawMesh(mesh, matrix, material, layer, camera, submeshIndex) end

---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param matrix UnityEngine.Matrix4x4
---@param material UnityEngine.Material
---@param layer int
---@param camera UnityEngine.Camera
---@param submeshIndex int
---@param properties UnityEngine.MaterialPropertyBlock
function CS.UnityEngine.Graphics:DrawMesh(mesh, matrix, material, layer, camera, submeshIndex, properties) end

---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param matrix UnityEngine.Matrix4x4
---@param material UnityEngine.Material
---@param layer int
---@param camera UnityEngine.Camera
---@param submeshIndex int
---@param properties UnityEngine.MaterialPropertyBlock
---@param castShadows bool
function CS.UnityEngine.Graphics:DrawMesh(mesh, matrix, material, layer, camera, submeshIndex, properties, castShadows) end

---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param matrix UnityEngine.Matrix4x4
---@param material UnityEngine.Material
---@param layer int
---@param camera UnityEngine.Camera
---@param submeshIndex int
---@param properties UnityEngine.MaterialPropertyBlock
---@param castShadows bool
---@param receiveShadows bool
function CS.UnityEngine.Graphics:DrawMesh(mesh, matrix, material, layer, camera, submeshIndex, properties, castShadows, receiveShadows) end

---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param matrix UnityEngine.Matrix4x4
---@param material UnityEngine.Material
---@param layer int
---@param camera UnityEngine.Camera
---@param submeshIndex int
---@param properties UnityEngine.MaterialPropertyBlock
---@param castShadows UnityEngine.Rendering.ShadowCastingMode
function CS.UnityEngine.Graphics:DrawMesh(mesh, matrix, material, layer, camera, submeshIndex, properties, castShadows) end

---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param matrix UnityEngine.Matrix4x4
---@param material UnityEngine.Material
---@param layer int
---@param camera UnityEngine.Camera
---@param submeshIndex int
---@param properties UnityEngine.MaterialPropertyBlock
---@param castShadows UnityEngine.Rendering.ShadowCastingMode
---@param receiveShadows bool
function CS.UnityEngine.Graphics:DrawMesh(mesh, matrix, material, layer, camera, submeshIndex, properties, castShadows, receiveShadows) end

---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param matrix UnityEngine.Matrix4x4
---@param material UnityEngine.Material
---@param layer int
---@param camera UnityEngine.Camera
---@param submeshIndex int
---@param properties UnityEngine.MaterialPropertyBlock
---@param castShadows UnityEngine.Rendering.ShadowCastingMode
---@param receiveShadows bool
---@param probeAnchor UnityEngine.Transform
function CS.UnityEngine.Graphics:DrawMesh(mesh, matrix, material, layer, camera, submeshIndex, properties, castShadows, receiveShadows, probeAnchor) end

--
--Draw a mesh.
--
--```plaintext
--Params: mesh - The Mesh to draw.
--        position - Position of the mesh.
--        rotation - Rotation of the mesh.
--        matrix - Transformation matrix of the mesh (combines position, rotation and other transformations).
--        material - Material to use.
--        layer - to use.
--        camera - If null (default), the mesh will be drawn in all cameras. Otherwise it will be rendered in the given Camera only.
--        submeshIndex - Which subset of the mesh to draw. This applies only to meshes that are composed of several materials.
--        properties - Additional material properties to apply onto material just before this mesh will be drawn. See MaterialPropertyBlock.
--        castShadows - Determines whether the mesh can cast shadows.
--        receiveShadows - Determines whether the mesh can receive shadows.
--        useLightProbes - Should the mesh use light probes?
--        probeAnchor - If used, the mesh will use this Transform's position to sample light probes and find the matching reflection probe.
--        lightProbeUsage - LightProbeUsage for the mesh.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param matrix UnityEngine.Matrix4x4
---@param material UnityEngine.Material
---@param layer int
---@param camera UnityEngine.Camera
---@param submeshIndex int
---@param properties UnityEngine.MaterialPropertyBlock
---@param castShadows UnityEngine.Rendering.ShadowCastingMode
---@param receiveShadows bool
---@param probeAnchor UnityEngine.Transform
---@param useLightProbes bool
function CS.UnityEngine.Graphics:DrawMesh(mesh, matrix, material, layer, camera, submeshIndex, properties, castShadows, receiveShadows, probeAnchor, useLightProbes) end

--
--Draw a mesh.
--
--```plaintext
--Params: mesh - The Mesh to draw.
--        position - Position of the mesh.
--        rotation - Rotation of the mesh.
--        matrix - Transformation matrix of the mesh (combines position, rotation and other transformations).
--        material - Material to use.
--        layer - to use.
--        camera - If null (default), the mesh will be drawn in all cameras. Otherwise it will be rendered in the given Camera only.
--        submeshIndex - Which subset of the mesh to draw. This applies only to meshes that are composed of several materials.
--        properties - Additional material properties to apply onto material just before this mesh will be drawn. See MaterialPropertyBlock.
--        castShadows - Determines whether the mesh can cast shadows.
--        receiveShadows - Determines whether the mesh can receive shadows.
--        useLightProbes - Should the mesh use light probes?
--        probeAnchor - If used, the mesh will use this Transform's position to sample light probes and find the matching reflection probe.
--        lightProbeUsage - LightProbeUsage for the mesh.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param matrix UnityEngine.Matrix4x4
---@param material UnityEngine.Material
---@param layer int
---@param camera UnityEngine.Camera
---@param submeshIndex int
---@param properties UnityEngine.MaterialPropertyBlock
---@param castShadows UnityEngine.Rendering.ShadowCastingMode
---@param receiveShadows bool
---@param probeAnchor UnityEngine.Transform
---@param lightProbeUsage UnityEngine.Rendering.LightProbeUsage
function CS.UnityEngine.Graphics:DrawMesh(mesh, matrix, material, layer, camera, submeshIndex, properties, castShadows, receiveShadows, probeAnchor, lightProbeUsage) end

---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param submeshIndex int
---@param material UnityEngine.Material
---@param matrices UnityEngine.Matrix4x4[]
function CS.UnityEngine.Graphics:DrawMeshInstanced(mesh, submeshIndex, material, matrices) end

---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param submeshIndex int
---@param material UnityEngine.Material
---@param matrices UnityEngine.Matrix4x4[]
---@param count int
function CS.UnityEngine.Graphics:DrawMeshInstanced(mesh, submeshIndex, material, matrices, count) end

---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param submeshIndex int
---@param material UnityEngine.Material
---@param matrices UnityEngine.Matrix4x4[]
---@param count int
---@param properties UnityEngine.MaterialPropertyBlock
function CS.UnityEngine.Graphics:DrawMeshInstanced(mesh, submeshIndex, material, matrices, count, properties) end

---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param submeshIndex int
---@param material UnityEngine.Material
---@param matrices UnityEngine.Matrix4x4[]
---@param count int
---@param properties UnityEngine.MaterialPropertyBlock
---@param castShadows UnityEngine.Rendering.ShadowCastingMode
function CS.UnityEngine.Graphics:DrawMeshInstanced(mesh, submeshIndex, material, matrices, count, properties, castShadows) end

---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param submeshIndex int
---@param material UnityEngine.Material
---@param matrices UnityEngine.Matrix4x4[]
---@param count int
---@param properties UnityEngine.MaterialPropertyBlock
---@param castShadows UnityEngine.Rendering.ShadowCastingMode
---@param receiveShadows bool
function CS.UnityEngine.Graphics:DrawMeshInstanced(mesh, submeshIndex, material, matrices, count, properties, castShadows, receiveShadows) end

---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param submeshIndex int
---@param material UnityEngine.Material
---@param matrices UnityEngine.Matrix4x4[]
---@param count int
---@param properties UnityEngine.MaterialPropertyBlock
---@param castShadows UnityEngine.Rendering.ShadowCastingMode
---@param receiveShadows bool
---@param layer int
function CS.UnityEngine.Graphics:DrawMeshInstanced(mesh, submeshIndex, material, matrices, count, properties, castShadows, receiveShadows, layer) end

---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param submeshIndex int
---@param material UnityEngine.Material
---@param matrices UnityEngine.Matrix4x4[]
---@param count int
---@param properties UnityEngine.MaterialPropertyBlock
---@param castShadows UnityEngine.Rendering.ShadowCastingMode
---@param receiveShadows bool
---@param layer int
---@param camera UnityEngine.Camera
function CS.UnityEngine.Graphics:DrawMeshInstanced(mesh, submeshIndex, material, matrices, count, properties, castShadows, receiveShadows, layer, camera) end

---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param submeshIndex int
---@param material UnityEngine.Material
---@param matrices UnityEngine.Matrix4x4[]
---@param count int
---@param properties UnityEngine.MaterialPropertyBlock
---@param castShadows UnityEngine.Rendering.ShadowCastingMode
---@param receiveShadows bool
---@param layer int
---@param camera UnityEngine.Camera
---@param lightProbeUsage UnityEngine.Rendering.LightProbeUsage
function CS.UnityEngine.Graphics:DrawMeshInstanced(mesh, submeshIndex, material, matrices, count, properties, castShadows, receiveShadows, layer, camera, lightProbeUsage) end

---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param submeshIndex int
---@param material UnityEngine.Material
---@param matrices System.Collections.Generic.List<UnityEngine.Matrix4x4>
function CS.UnityEngine.Graphics:DrawMeshInstanced(mesh, submeshIndex, material, matrices) end

---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param submeshIndex int
---@param material UnityEngine.Material
---@param matrices System.Collections.Generic.List<UnityEngine.Matrix4x4>
---@param properties UnityEngine.MaterialPropertyBlock
function CS.UnityEngine.Graphics:DrawMeshInstanced(mesh, submeshIndex, material, matrices, properties) end

---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param submeshIndex int
---@param material UnityEngine.Material
---@param matrices System.Collections.Generic.List<UnityEngine.Matrix4x4>
---@param properties UnityEngine.MaterialPropertyBlock
---@param castShadows UnityEngine.Rendering.ShadowCastingMode
function CS.UnityEngine.Graphics:DrawMeshInstanced(mesh, submeshIndex, material, matrices, properties, castShadows) end

---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param submeshIndex int
---@param material UnityEngine.Material
---@param matrices System.Collections.Generic.List<UnityEngine.Matrix4x4>
---@param properties UnityEngine.MaterialPropertyBlock
---@param castShadows UnityEngine.Rendering.ShadowCastingMode
---@param receiveShadows bool
function CS.UnityEngine.Graphics:DrawMeshInstanced(mesh, submeshIndex, material, matrices, properties, castShadows, receiveShadows) end

---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param submeshIndex int
---@param material UnityEngine.Material
---@param matrices System.Collections.Generic.List<UnityEngine.Matrix4x4>
---@param properties UnityEngine.MaterialPropertyBlock
---@param castShadows UnityEngine.Rendering.ShadowCastingMode
---@param receiveShadows bool
---@param layer int
function CS.UnityEngine.Graphics:DrawMeshInstanced(mesh, submeshIndex, material, matrices, properties, castShadows, receiveShadows, layer) end

---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param submeshIndex int
---@param material UnityEngine.Material
---@param matrices System.Collections.Generic.List<UnityEngine.Matrix4x4>
---@param properties UnityEngine.MaterialPropertyBlock
---@param castShadows UnityEngine.Rendering.ShadowCastingMode
---@param receiveShadows bool
---@param layer int
---@param camera UnityEngine.Camera
function CS.UnityEngine.Graphics:DrawMeshInstanced(mesh, submeshIndex, material, matrices, properties, castShadows, receiveShadows, layer, camera) end

---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param submeshIndex int
---@param material UnityEngine.Material
---@param matrices System.Collections.Generic.List<UnityEngine.Matrix4x4>
---@param properties UnityEngine.MaterialPropertyBlock
---@param castShadows UnityEngine.Rendering.ShadowCastingMode
---@param receiveShadows bool
---@param layer int
---@param camera UnityEngine.Camera
---@param lightProbeUsage UnityEngine.Rendering.LightProbeUsage
function CS.UnityEngine.Graphics:DrawMeshInstanced(mesh, submeshIndex, material, matrices, properties, castShadows, receiveShadows, layer, camera, lightProbeUsage) end

---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param submeshIndex int
---@param material UnityEngine.Material
---@param bounds UnityEngine.Bounds
---@param bufferWithArgs UnityEngine.ComputeBuffer
---@param argsOffset int
---@param properties UnityEngine.MaterialPropertyBlock
---@param castShadows UnityEngine.Rendering.ShadowCastingMode
---@param receiveShadows bool
---@param layer int
---@param camera UnityEngine.Camera
---@param lightProbeUsage UnityEngine.Rendering.LightProbeUsage
function CS.UnityEngine.Graphics:DrawMeshInstancedIndirect(mesh, submeshIndex, material, bounds, bufferWithArgs, argsOffset, properties, castShadows, receiveShadows, layer, camera, lightProbeUsage) end

---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param submeshIndex int
---@param material UnityEngine.Material
---@param bounds UnityEngine.Bounds
---@param bufferWithArgs UnityEngine.GraphicsBuffer
---@param argsOffset int
---@param properties UnityEngine.MaterialPropertyBlock
---@param castShadows UnityEngine.Rendering.ShadowCastingMode
---@param receiveShadows bool
---@param layer int
---@param camera UnityEngine.Camera
---@param lightProbeUsage UnityEngine.Rendering.LightProbeUsage
function CS.UnityEngine.Graphics:DrawMeshInstancedIndirect(mesh, submeshIndex, material, bounds, bufferWithArgs, argsOffset, properties, castShadows, receiveShadows, layer, camera, lightProbeUsage) end

--
--Draw a texture in screen coordinates.
--
--```plaintext
--Params: screenRect - Rectangle on the screen to use for the texture. In pixel coordinates with (0,0) in the upper-left corner.
--        texture - Texture to draw.
--        sourceRect - Region of the texture to use. In normalized coordinates with (0,0) in the bottom-left corner.
--        leftBorder - Number of pixels from the left that are not affected by scale.
--        rightBorder - Number of pixels from the right that are not affected by scale.
--        topBorder - Number of pixels from the top that are not affected by scale.
--        bottomBorder - Number of pixels from the bottom that are not affected by scale.
--        color - Color that modulates the output. The neutral value is (0.5, 0.5, 0.5, 0.5). Set as vertex color for the shader.
--        mat - Custom Material that can be used to draw the texture. If null is passed, a default material with the Internal-GUITexture.shader is used.
--        pass - If -1 (default), draws all passes in the material. Otherwise, draws given pass only.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param screenRect UnityEngine.Rect
---@param texture UnityEngine.Texture
---@param sourceRect UnityEngine.Rect
---@param leftBorder int
---@param rightBorder int
---@param topBorder int
---@param bottomBorder int
---@param color UnityEngine.Color
---@param mat UnityEngine.Material
function CS.UnityEngine.Graphics:DrawTexture(screenRect, texture, sourceRect, leftBorder, rightBorder, topBorder, bottomBorder, color, mat) end

---@source UnityEngine.CoreModule.dll
---@param screenRect UnityEngine.Rect
---@param texture UnityEngine.Texture
---@param sourceRect UnityEngine.Rect
---@param leftBorder int
---@param rightBorder int
---@param topBorder int
---@param bottomBorder int
---@param color UnityEngine.Color
function CS.UnityEngine.Graphics:DrawTexture(screenRect, texture, sourceRect, leftBorder, rightBorder, topBorder, bottomBorder, color) end

--
--Draw a texture in screen coordinates.
--
--```plaintext
--Params: screenRect - Rectangle on the screen to use for the texture. In pixel coordinates with (0,0) in the upper-left corner.
--        texture - Texture to draw.
--        sourceRect - Region of the texture to use. In normalized coordinates with (0,0) in the bottom-left corner.
--        leftBorder - Number of pixels from the left that are not affected by scale.
--        rightBorder - Number of pixels from the right that are not affected by scale.
--        topBorder - Number of pixels from the top that are not affected by scale.
--        bottomBorder - Number of pixels from the bottom that are not affected by scale.
--        color - Color that modulates the output. The neutral value is (0.5, 0.5, 0.5, 0.5). Set as vertex color for the shader.
--        mat - Custom Material that can be used to draw the texture. If null is passed, a default material with the Internal-GUITexture.shader is used.
--        pass - If -1 (default), draws all passes in the material. Otherwise, draws given pass only.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param screenRect UnityEngine.Rect
---@param texture UnityEngine.Texture
---@param sourceRect UnityEngine.Rect
---@param leftBorder int
---@param rightBorder int
---@param topBorder int
---@param bottomBorder int
---@param mat UnityEngine.Material
function CS.UnityEngine.Graphics:DrawTexture(screenRect, texture, sourceRect, leftBorder, rightBorder, topBorder, bottomBorder, mat) end

---@source UnityEngine.CoreModule.dll
---@param screenRect UnityEngine.Rect
---@param texture UnityEngine.Texture
---@param sourceRect UnityEngine.Rect
---@param leftBorder int
---@param rightBorder int
---@param topBorder int
---@param bottomBorder int
function CS.UnityEngine.Graphics:DrawTexture(screenRect, texture, sourceRect, leftBorder, rightBorder, topBorder, bottomBorder) end

--
--Draw a texture in screen coordinates.
--
--```plaintext
--Params: screenRect - Rectangle on the screen to use for the texture. In pixel coordinates with (0,0) in the upper-left corner.
--        texture - Texture to draw.
--        sourceRect - Region of the texture to use. In normalized coordinates with (0,0) in the bottom-left corner.
--        leftBorder - Number of pixels from the left that are not affected by scale.
--        rightBorder - Number of pixels from the right that are not affected by scale.
--        topBorder - Number of pixels from the top that are not affected by scale.
--        bottomBorder - Number of pixels from the bottom that are not affected by scale.
--        color - Color that modulates the output. The neutral value is (0.5, 0.5, 0.5, 0.5). Set as vertex color for the shader.
--        mat - Custom Material that can be used to draw the texture. If null is passed, a default material with the Internal-GUITexture.shader is used.
--        pass - If -1 (default), draws all passes in the material. Otherwise, draws given pass only.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param screenRect UnityEngine.Rect
---@param texture UnityEngine.Texture
---@param leftBorder int
---@param rightBorder int
---@param topBorder int
---@param bottomBorder int
---@param mat UnityEngine.Material
function CS.UnityEngine.Graphics:DrawTexture(screenRect, texture, leftBorder, rightBorder, topBorder, bottomBorder, mat) end

---@source UnityEngine.CoreModule.dll
---@param screenRect UnityEngine.Rect
---@param texture UnityEngine.Texture
---@param leftBorder int
---@param rightBorder int
---@param topBorder int
---@param bottomBorder int
function CS.UnityEngine.Graphics:DrawTexture(screenRect, texture, leftBorder, rightBorder, topBorder, bottomBorder) end

--
--Draw a texture in screen coordinates.
--
--```plaintext
--Params: screenRect - Rectangle on the screen to use for the texture. In pixel coordinates with (0,0) in the upper-left corner.
--        texture - Texture to draw.
--        sourceRect - Region of the texture to use. In normalized coordinates with (0,0) in the bottom-left corner.
--        leftBorder - Number of pixels from the left that are not affected by scale.
--        rightBorder - Number of pixels from the right that are not affected by scale.
--        topBorder - Number of pixels from the top that are not affected by scale.
--        bottomBorder - Number of pixels from the bottom that are not affected by scale.
--        color - Color that modulates the output. The neutral value is (0.5, 0.5, 0.5, 0.5). Set as vertex color for the shader.
--        mat - Custom Material that can be used to draw the texture. If null is passed, a default material with the Internal-GUITexture.shader is used.
--        pass - If -1 (default), draws all passes in the material. Otherwise, draws given pass only.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param screenRect UnityEngine.Rect
---@param texture UnityEngine.Texture
---@param mat UnityEngine.Material
function CS.UnityEngine.Graphics:DrawTexture(screenRect, texture, mat) end

---@source UnityEngine.CoreModule.dll
---@param screenRect UnityEngine.Rect
---@param texture UnityEngine.Texture
function CS.UnityEngine.Graphics:DrawTexture(screenRect, texture) end

---@source UnityEngine.CoreModule.dll
---@param rt UnityEngine.RenderTexture
function CS.UnityEngine.Graphics:SetRenderTarget(rt) end

---@source UnityEngine.CoreModule.dll
---@param rt UnityEngine.RenderTexture
---@param mipLevel int
function CS.UnityEngine.Graphics:SetRenderTarget(rt, mipLevel) end

---@source UnityEngine.CoreModule.dll
---@param rt UnityEngine.RenderTexture
---@param mipLevel int
---@param face UnityEngine.CubemapFace
function CS.UnityEngine.Graphics:SetRenderTarget(rt, mipLevel, face) end

---@source UnityEngine.CoreModule.dll
---@param colorBuffer UnityEngine.RenderBuffer
---@param depthBuffer UnityEngine.RenderBuffer
function CS.UnityEngine.Graphics:SetRenderTarget(colorBuffer, depthBuffer) end

---@source UnityEngine.CoreModule.dll
---@param colorBuffer UnityEngine.RenderBuffer
---@param depthBuffer UnityEngine.RenderBuffer
---@param mipLevel int
function CS.UnityEngine.Graphics:SetRenderTarget(colorBuffer, depthBuffer, mipLevel) end

---@source UnityEngine.CoreModule.dll
---@param colorBuffer UnityEngine.RenderBuffer
---@param depthBuffer UnityEngine.RenderBuffer
---@param mipLevel int
---@param face UnityEngine.CubemapFace
function CS.UnityEngine.Graphics:SetRenderTarget(colorBuffer, depthBuffer, mipLevel, face) end

---@source UnityEngine.CoreModule.dll
---@param index int
---@param uav UnityEngine.ComputeBuffer
function CS.UnityEngine.Graphics:SetRandomWriteTarget(index, uav) end

---@source UnityEngine.CoreModule.dll
---@param index int
---@param uav UnityEngine.GraphicsBuffer
function CS.UnityEngine.Graphics:SetRandomWriteTarget(index, uav) end


--
--Low-level graphics library.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.GL: object
--
--Mode for Begin: draw triangles.
--
---@source UnityEngine.CoreModule.dll
---@field TRIANGLES int
--
--Mode for Begin: draw triangle strip.
--
---@source UnityEngine.CoreModule.dll
---@field TRIANGLE_STRIP int
--
--Mode for Begin: draw quads.
--
---@source UnityEngine.CoreModule.dll
---@field QUADS int
--
--Mode for Begin: draw lines.
--
---@source UnityEngine.CoreModule.dll
---@field LINES int
--
--Mode for Begin: draw line strip.
--
---@source UnityEngine.CoreModule.dll
---@field LINE_STRIP int
--
--Should rendering be done in wireframe?
--
---@source UnityEngine.CoreModule.dll
---@field wireframe bool
--
--Controls whether Linear-to-sRGB color conversion is performed while rendering.
--
---@source UnityEngine.CoreModule.dll
---@field sRGBWrite bool
--
--Select whether to invert the backface culling (true) or not (false).
--
---@source UnityEngine.CoreModule.dll
---@field invertCulling bool
--
--Gets or sets the modelview matrix.
--
---@source UnityEngine.CoreModule.dll
---@field modelview UnityEngine.Matrix4x4
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.GL = {}

--
--Submit a vertex.
--
---@source UnityEngine.CoreModule.dll
---@param x float
---@param y float
---@param z float
function CS.UnityEngine.GL:Vertex3(x, y, z) end

--
--Submit a vertex.
--
---@source UnityEngine.CoreModule.dll
---@param v UnityEngine.Vector3
function CS.UnityEngine.GL:Vertex(v) end

--
--Sets current texture coordinate (x,y,z) for all texture units.
--
---@source UnityEngine.CoreModule.dll
---@param x float
---@param y float
---@param z float
function CS.UnityEngine.GL:TexCoord3(x, y, z) end

--
--Sets current texture coordinate (v.x,v.y,v.z) for all texture units.
--
---@source UnityEngine.CoreModule.dll
---@param v UnityEngine.Vector3
function CS.UnityEngine.GL:TexCoord(v) end

--
--Sets current texture coordinate (x,y) for all texture units.
--
---@source UnityEngine.CoreModule.dll
---@param x float
---@param y float
function CS.UnityEngine.GL:TexCoord2(x, y) end

--
--Sets current texture coordinate (x,y,z) to the actual texture unit.
--
---@source UnityEngine.CoreModule.dll
---@param unit int
---@param x float
---@param y float
---@param z float
function CS.UnityEngine.GL:MultiTexCoord3(unit, x, y, z) end

--
--Sets current texture coordinate (v.x,v.y,v.z) to the actual texture unit.
--
---@source UnityEngine.CoreModule.dll
---@param unit int
---@param v UnityEngine.Vector3
function CS.UnityEngine.GL:MultiTexCoord(unit, v) end

--
--Sets current texture coordinate (x,y) for the actual texture unit.
--
---@source UnityEngine.CoreModule.dll
---@param unit int
---@param x float
---@param y float
function CS.UnityEngine.GL:MultiTexCoord2(unit, x, y) end

--
--Sets current vertex color.
--
---@source UnityEngine.CoreModule.dll
---@param c UnityEngine.Color
function CS.UnityEngine.GL:Color(c) end

--
--Sends queued-up commands in the driver's command buffer to the GPU.
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.GL:Flush() end

--
--Resolves the render target for subsequent operations sampling from it.
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.GL:RenderTargetBarrier() end

--
--Sets the current model matrix to the one specified.
--
---@source UnityEngine.CoreModule.dll
---@param m UnityEngine.Matrix4x4
function CS.UnityEngine.GL:MultMatrix(m) end

--
--Send a user-defined event to a native code plugin.
--
--```plaintext
--Params: eventID - User defined id to send to the callback.
--        callback - Native code callback to queue for Unity's renderer to invoke.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param eventID int
function CS.UnityEngine.GL:IssuePluginEvent(eventID) end

---@source UnityEngine.CoreModule.dll
---@param revertBackFaces bool
function CS.UnityEngine.GL:SetRevertBackfacing(revertBackFaces) end

--
--Saves the model, view and projection matrices to the top of the matrix stack.
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.GL:PushMatrix() end

--
--Restores the model, view and projection matrices off the top of the matrix stack.
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.GL:PopMatrix() end

--
--Load an identity into the current model and view matrices.
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.GL:LoadIdentity() end

--
--Helper function to set up an orthograhic projection.
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.GL:LoadOrtho() end

--
--Setup a matrix for pixel-correct rendering.
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.GL:LoadPixelMatrix() end

--
--Load an arbitrary matrix to the current projection matrix.
--
---@source UnityEngine.CoreModule.dll
---@param mat UnityEngine.Matrix4x4
function CS.UnityEngine.GL:LoadProjectionMatrix(mat) end

--
--Invalidate the internally cached render state.
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.GL:InvalidateState() end

--
--Adjusted projection matrix for the current graphics API.
--
--```plaintext
--Params: proj - Source projection matrix.
--        renderIntoTexture - Will this projection be used for rendering into a RenderTexture?
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param proj UnityEngine.Matrix4x4
---@param renderIntoTexture bool
---@return Matrix4x4
function CS.UnityEngine.GL:GetGPUProjectionMatrix(proj, renderIntoTexture) end

--
--Setup a matrix for pixel-correct rendering.
--
---@source UnityEngine.CoreModule.dll
---@param left float
---@param right float
---@param bottom float
---@param top float
function CS.UnityEngine.GL:LoadPixelMatrix(left, right, bottom, top) end

--
--Send a user-defined event to a native code plugin.
--
--```plaintext
--Params: eventID - User defined id to send to the callback.
--        callback - Native code callback to queue for Unity's renderer to invoke.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param callback System.IntPtr
---@param eventID int
function CS.UnityEngine.GL:IssuePluginEvent(callback, eventID) end

--
--Begin drawing 3D primitives.
--
--```plaintext
--Params: mode - Primitives to draw: can be TRIANGLES, TRIANGLE_STRIP, QUADS or LINES.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param mode int
function CS.UnityEngine.GL:Begin(mode) end

--
--End drawing 3D primitives.
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.GL:End() end

--
--Clear the current render buffer.
--
--```plaintext
--Params: clearDepth - Should the depth buffer be cleared?
--        clearColor - Should the color buffer be cleared?
--        backgroundColor - The color to clear with, used only if clearColor is true.
--        depth - The depth to clear the z-buffer with, used only if clearDepth is true. The valid
--range is from 0 (near plane) to 1 (far plane). The value is graphics API agnostic: the abstraction layer will convert
--the value to match the convention of the current graphics API.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param clearDepth bool
---@param clearColor bool
---@param backgroundColor UnityEngine.Color
---@param depth float
function CS.UnityEngine.GL:Clear(clearDepth, clearColor, backgroundColor, depth) end

---@source UnityEngine.CoreModule.dll
---@param clearDepth bool
---@param clearColor bool
---@param backgroundColor UnityEngine.Color
function CS.UnityEngine.GL:Clear(clearDepth, clearColor, backgroundColor) end

--
--Set the rendering viewport.
--
---@source UnityEngine.CoreModule.dll
---@param pixelRect UnityEngine.Rect
function CS.UnityEngine.GL:Viewport(pixelRect) end

--
--Clear the current render buffer with camera's skybox.
--
--```plaintext
--Params: clearDepth - Should the depth buffer be cleared?
--        camera - Camera to get projection parameters and skybox from.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param clearDepth bool
---@param camera UnityEngine.Camera
function CS.UnityEngine.GL:ClearWithSkybox(clearDepth, camera) end


--
--Scales render textures to support dynamic resolution if the target platform/graphics API supports it.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.ScalableBufferManager: object
--
--Width scale factor to control dynamic resolution.
--
---@source UnityEngine.CoreModule.dll
---@field widthScaleFactor float
--
--Height scale factor to control dynamic resolution.
--
---@source UnityEngine.CoreModule.dll
---@field heightScaleFactor float
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.ScalableBufferManager = {}

--
--Function to resize all buffers marked as DynamicallyScalable.
--
--```plaintext
--Params: widthScale - New scale factor for the width the ScalableBufferManager will use to resize all render textures the user marked as DynamicallyScalable, has to be some value greater than 0.0 and less than or equal to 1.0.
--        heightScale - New scale factor for the height the ScalableBufferManager will use to resize all render textures the user marked as DynamicallyScalable, has to be some value greater than 0.0 and less than or equal to 1.0.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param widthScale float
---@param heightScale float
function CS.UnityEngine.ScalableBufferManager:ResizeBuffers(widthScale, heightScale) end


--
--Struct containing basic FrameTimings and accompanying relevant data.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.FrameTiming: System.ValueType
--
--This is the CPU clock time at the point Present was called for the current frame.
--
---@source UnityEngine.CoreModule.dll
---@field cpuTimePresentCalled ulong
--
--The CPU time for a given frame, in ms.
--
---@source UnityEngine.CoreModule.dll
---@field cpuFrameTime double
--
--This is the CPU clock time at the point GPU finished rendering the frame and interrupted the CPU.
--
---@source UnityEngine.CoreModule.dll
---@field cpuTimeFrameComplete ulong
--
--The GPU time for a given frame, in ms.
--
---@source UnityEngine.CoreModule.dll
---@field gpuFrameTime double
--
--This was the height scale factor of the Dynamic Resolution system(if used) for the given frame and the linked frame timings.
--
---@source UnityEngine.CoreModule.dll
---@field heightScale float
--
--This was the width scale factor of the Dynamic Resolution system(if used) for the given frame and the linked frame timings.
--
---@source UnityEngine.CoreModule.dll
---@field widthScale float
--
--This was the vsync mode for the given frame and the linked frame timings.
--
---@source UnityEngine.CoreModule.dll
---@field syncInterval uint
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.FrameTiming = {}


--
--The FrameTimingManager allows the user to capture and access FrameTiming data for multple frames.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.FrameTimingManager: object
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.FrameTimingManager = {}

--
--This function triggers the FrameTimingManager to capture a snapshot of FrameTiming's data, that can then be accessed by the user.
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.FrameTimingManager:CaptureFrameTimings() end

--
--Returns the number of FrameTimings it actually was able to get. This will always be equal to or less than the requested numFrames depending on availability of captured FrameTimings.
--
--```plaintext
--Params: numFrames - User supplies a desired number of frames they would like FrameTimings for. This should be equal to or less than the maximum FrameTimings the platform can capture.
--        timings - An array of FrameTiming structs that is passed in by the user and will be filled with data as requested. It is the users job to make sure the array that is passed is large enough to hold the requested number of FrameTimings.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param numFrames uint
---@param timings UnityEngine.FrameTiming[]
---@return UInt32
function CS.UnityEngine.FrameTimingManager:GetLatestTimings(numFrames, timings) end

--
--Number of vsyncs per second of the current platform.
--
---@source UnityEngine.CoreModule.dll
---@return Single
function CS.UnityEngine.FrameTimingManager:GetVSyncsPerSecond() end

--
--GPU timer frequency for current platform.
--
---@source UnityEngine.CoreModule.dll
---@return UInt64
function CS.UnityEngine.FrameTimingManager:GetGpuTimerFrequency() end

--
--CPU timer frequency for current platform.
--
---@source UnityEngine.CoreModule.dll
---@return UInt64
function CS.UnityEngine.FrameTimingManager:GetCpuTimerFrequency() end


--
--Data of a lightmap.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.LightmapData: object
---@source UnityEngine.CoreModule.dll
---@field lightmapLight UnityEngine.Texture2D
--
--Lightmap storing color of incoming light.
--
---@source UnityEngine.CoreModule.dll
---@field lightmapColor UnityEngine.Texture2D
--
--Lightmap storing dominant direction of incoming light.
--
---@source UnityEngine.CoreModule.dll
---@field lightmapDir UnityEngine.Texture2D
--
--Texture storing occlusion mask per light (ShadowMask, up to four lights).
--
---@source UnityEngine.CoreModule.dll
---@field shadowMask UnityEngine.Texture2D
---@source UnityEngine.CoreModule.dll
---@field lightmap UnityEngine.Texture2D
---@source UnityEngine.CoreModule.dll
---@field lightmapFar UnityEngine.Texture2D
---@source UnityEngine.CoreModule.dll
---@field lightmapNear UnityEngine.Texture2D
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.LightmapData = {}


--
--Stores lightmaps of the Scene.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.LightmapSettings: UnityEngine.Object
--
--Lightmap array.
--
---@source UnityEngine.CoreModule.dll
---@field lightmaps UnityEngine.LightmapData[]
--
--NonDirectional or CombinedDirectional Specular lightmaps rendering mode.
--
---@source UnityEngine.CoreModule.dll
---@field lightmapsMode UnityEngine.LightmapsMode
--
--Baked Light Probe data.
--
---@source UnityEngine.CoreModule.dll
---@field lightProbes UnityEngine.LightProbes
---@source UnityEngine.CoreModule.dll
---@field lightmapsModeLegacy UnityEngine.LightmapsModeLegacy
---@source UnityEngine.CoreModule.dll
---@field bakedColorSpace UnityEngine.ColorSpace
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.LightmapSettings = {}


--
--Fully describes setup of RenderTarget.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.RenderTargetSetup: System.ValueType
--
--Color Buffers to set.
--
---@source UnityEngine.CoreModule.dll
---@field color UnityEngine.RenderBuffer[]
--
--Depth Buffer to set.
--
---@source UnityEngine.CoreModule.dll
---@field depth UnityEngine.RenderBuffer
--
--Mip Level to render to.
--
---@source UnityEngine.CoreModule.dll
---@field mipLevel int
--
--Cubemap face to render to.
--
---@source UnityEngine.CoreModule.dll
---@field cubemapFace UnityEngine.CubemapFace
--
--Slice of a Texture3D or Texture2DArray to set as a render target.
--
---@source UnityEngine.CoreModule.dll
---@field depthSlice int
--
--Load Actions for Color Buffers. It will override any actions set on RenderBuffers themselves.
--
---@source UnityEngine.CoreModule.dll
---@field colorLoad UnityEngine.Rendering.RenderBufferLoadAction[]
--
--Store Actions for Color Buffers. It will override any actions set on RenderBuffers themselves.
--
---@source UnityEngine.CoreModule.dll
---@field colorStore UnityEngine.Rendering.RenderBufferStoreAction[]
--
--Load Action for Depth Buffer. It will override any actions set on RenderBuffer itself.
--
---@source UnityEngine.CoreModule.dll
---@field depthLoad UnityEngine.Rendering.RenderBufferLoadAction
--
--Store Actions for Depth Buffer. It will override any actions set on RenderBuffer itself.
--
---@source UnityEngine.CoreModule.dll
---@field depthStore UnityEngine.Rendering.RenderBufferStoreAction
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.RenderTargetSetup = {}


--
--Stores light probe data for all currently loaded Scenes.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.LightProbes: UnityEngine.Object
--
--Positions of the baked light probes (Read Only).
--
---@source UnityEngine.CoreModule.dll
---@field positions UnityEngine.Vector3[]
--
--Coefficients of baked light probes.
--
---@source UnityEngine.CoreModule.dll
---@field bakedProbes UnityEngine.Rendering.SphericalHarmonicsL2[]
--
--The number of light probes (Read Only).
--
---@source UnityEngine.CoreModule.dll
---@field count int
--
--The number of cells space is divided into (Read Only).
--
---@source UnityEngine.CoreModule.dll
---@field cellCount int
---@source UnityEngine.CoreModule.dll
---@field coefficients float[]
---@source UnityEngine.CoreModule.dll
---@field tetrahedralizationCompleted System.Action
---@source UnityEngine.CoreModule.dll
---@field needsRetetrahedralization System.Action
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.LightProbes = {}

---@source UnityEngine.CoreModule.dll
---@param value System.Action
function CS.UnityEngine.LightProbes:add_tetrahedralizationCompleted(value) end

---@source UnityEngine.CoreModule.dll
---@param value System.Action
function CS.UnityEngine.LightProbes:remove_tetrahedralizationCompleted(value) end

---@source UnityEngine.CoreModule.dll
---@param value System.Action
function CS.UnityEngine.LightProbes:add_needsRetetrahedralization(value) end

---@source UnityEngine.CoreModule.dll
---@param value System.Action
function CS.UnityEngine.LightProbes:remove_needsRetetrahedralization(value) end

--
--Synchronously tetrahedralize the currently loaded LightProbe positions.
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.LightProbes:Tetrahedralize() end

--
--Asynchronously tetrahedralize the currently loaded LightProbe positions.
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.LightProbes:TetrahedralizeAsync() end

---@source UnityEngine.CoreModule.dll
---@param position UnityEngine.Vector3
---@param renderer UnityEngine.Renderer
---@param probe UnityEngine.Rendering.SphericalHarmonicsL2
function CS.UnityEngine.LightProbes:GetInterpolatedProbe(position, renderer, probe) end

--
--Calculate light probes and occlusion probes at the given world space positions.
--
--```plaintext
--Params: positions - The array of world space positions used to evaluate the probes.
--        lightProbes - The array where the resulting light probes are written to.
--        occlusionProbes - The array where the resulting occlusion probes are written to.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param positions UnityEngine.Vector3[]
---@param lightProbes UnityEngine.Rendering.SphericalHarmonicsL2[]
---@param occlusionProbes UnityEngine.Vector4[]
function CS.UnityEngine.LightProbes:CalculateInterpolatedLightAndOcclusionProbes(positions, lightProbes, occlusionProbes) end

---@source UnityEngine.CoreModule.dll
---@param positions System.Collections.Generic.List<UnityEngine.Vector3>
---@param lightProbes System.Collections.Generic.List<UnityEngine.Rendering.SphericalHarmonicsL2>
---@param occlusionProbes System.Collections.Generic.List<UnityEngine.Vector4>
function CS.UnityEngine.LightProbes:CalculateInterpolatedLightAndOcclusionProbes(positions, lightProbes, occlusionProbes) end

---@source UnityEngine.CoreModule.dll
---@param position UnityEngine.Vector3
---@param renderer UnityEngine.Renderer
---@param coefficients float[]
function CS.UnityEngine.LightProbes.GetInterpolatedLightProbe(position, renderer, coefficients) end


--
--Script interface for.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.QualitySettings: UnityEngine.Object
---@source UnityEngine.CoreModule.dll
---@field currentLevel UnityEngine.QualityLevel
--
--The maximum number of pixel lights that should affect any object.
--
---@source UnityEngine.CoreModule.dll
---@field pixelLightCount int
--
--Realtime Shadows type to be used.
--
---@source UnityEngine.CoreModule.dll
---@field shadows UnityEngine.ShadowQuality
--
--Directional light shadow projection.
--
---@source UnityEngine.CoreModule.dll
---@field shadowProjection UnityEngine.ShadowProjection
--
--Number of cascades to use for directional light shadows.
--
---@source UnityEngine.CoreModule.dll
---@field shadowCascades int
--
--Shadow drawing distance.
--
---@source UnityEngine.CoreModule.dll
---@field shadowDistance float
--
--The default resolution of the shadow maps.
--
---@source UnityEngine.CoreModule.dll
---@field shadowResolution UnityEngine.ShadowResolution
--
--The rendering mode of Shadowmask.
--
---@source UnityEngine.CoreModule.dll
---@field shadowmaskMode UnityEngine.ShadowmaskMode
--
--Offset shadow frustum near plane.
--
---@source UnityEngine.CoreModule.dll
---@field shadowNearPlaneOffset float
--
--The normalized cascade distribution for a 2 cascade setup. The value defines the position of the cascade with respect to Zero.
--
---@source UnityEngine.CoreModule.dll
---@field shadowCascade2Split float
--
--The normalized cascade start position for a 4 cascade setup. Each member of the vector defines the normalized position of the coresponding cascade with respect to Zero.
--
---@source UnityEngine.CoreModule.dll
---@field shadowCascade4Split UnityEngine.Vector3
--
--Global multiplier for the LOD's switching distance.
--
---@source UnityEngine.CoreModule.dll
---@field lodBias float
--
--Global anisotropic filtering mode.
--
---@source UnityEngine.CoreModule.dll
---@field anisotropicFiltering UnityEngine.AnisotropicFiltering
--
--A texture size limit applied to most textures.
--
---@source UnityEngine.CoreModule.dll
---@field masterTextureLimit int
--
--A maximum LOD level. All LOD groups.
--
---@source UnityEngine.CoreModule.dll
---@field maximumLODLevel int
--
--Budget for how many ray casts can be performed per frame for approximate collision testing.
--
---@source UnityEngine.CoreModule.dll
---@field particleRaycastBudget int
--
--Should soft blending be used for particles?
--
---@source UnityEngine.CoreModule.dll
---@field softParticles bool
--
--Use a two-pass shader for the vegetation in the terrain engine.
--
---@source UnityEngine.CoreModule.dll
---@field softVegetation bool
--
--The VSync Count.
--
---@source UnityEngine.CoreModule.dll
---@field vSyncCount int
--
--Choose the level of Multi-Sample Anti-aliasing (MSAA) that the GPU performs.
--
---@source UnityEngine.CoreModule.dll
---@field antiAliasing int
--
--Async texture upload provides timesliced async texture upload on the render thread with tight control over memory and timeslicing. There are no allocations except for the ones which driver has to do. To read data and upload texture data a ringbuffer whose size can be controlled is re-used.
--
--Use asyncUploadTimeSlice to set the time-slice in milliseconds for asynchronous texture uploads per
--frame. Minimum value is 1 and maximum is 33.
--
---@source UnityEngine.CoreModule.dll
---@field asyncUploadTimeSlice int
--
--Asynchronous texture and mesh data upload provides timesliced async texture and mesh data upload on the render thread with tight control over memory and timeslicing. There are no allocations except for the ones which driver has to do. To read data and upload texture and mesh data, Unity re-uses a ringbuffer whose size can be controlled.
--
--Use asyncUploadBufferSize to set the buffer size for asynchronous texture and mesh data uploads. The size is in megabytes. The minimum value is 2 and the maximum value is 512. The buffer resizes automatically to fit the largest texture currently loading. To avoid re-sizing of the buffer, which can incur performance cost, set the value approximately to the size of biggest texture used in the Scene.
--
---@source UnityEngine.CoreModule.dll
---@field asyncUploadBufferSize int
--
--This flag controls if the async upload pipeline's ring buffer remains allocated when there are no active loading operations.
--Set this to true, to make the ring buffer allocation persist after all upload operations have completed.
--If you have issues with excessive memory usage, you can set this to false. This means you reduce the runtime memory footprint, but memory fragmentation can occur.
--The default value is true.
--
---@source UnityEngine.CoreModule.dll
---@field asyncUploadPersistentBuffer bool
--
--Enables realtime reflection probes.
--
---@source UnityEngine.CoreModule.dll
---@field realtimeReflectionProbes bool
--
--If enabled, billboards will face towards camera position rather than camera orientation.
--
---@source UnityEngine.CoreModule.dll
---@field billboardsFaceCameraPosition bool
--
--In resolution scaling mode, this factor is used to multiply with the target Fixed DPI specified to get the actual Fixed DPI to use for this quality setting.
--
---@source UnityEngine.CoreModule.dll
---@field resolutionScalingFixedDPIFactor float
--
--The RenderPipelineAsset that defines the override render pipeline for the current quality level.
--
---@source UnityEngine.CoreModule.dll
---@field renderPipeline UnityEngine.Rendering.RenderPipelineAsset
---@source UnityEngine.CoreModule.dll
---@field blendWeights UnityEngine.BlendWeights
--
--The maximum number of bones per vertex that are taken into account during skinning, for all meshes in the project.
--
---@source UnityEngine.CoreModule.dll
---@field skinWeights UnityEngine.SkinWeights
--
--Enable automatic streaming of texture mipmap levels based on their distance from all active cameras.
--
---@source UnityEngine.CoreModule.dll
---@field streamingMipmapsActive bool
--
--The total amount of memory to be used by streaming and non-streaming textures.
--
---@source UnityEngine.CoreModule.dll
---@field streamingMipmapsMemoryBudget float
--
--The number of renderer instances that are processed each frame when calculating which texture mipmap levels should be streamed.
--
---@source UnityEngine.CoreModule.dll
---@field streamingMipmapsRenderersPerFrame int
--
--The maximum number of mipmap levels to discard for each texture.
--
---@source UnityEngine.CoreModule.dll
---@field streamingMipmapsMaxLevelReduction int
--
--Process all enabled Cameras for texture streaming (rather than just those with StreamingController components).
--
---@source UnityEngine.CoreModule.dll
---@field streamingMipmapsAddAllCameras bool
--
--The maximum number of active texture file IO requests from the texture streaming system.
--
---@source UnityEngine.CoreModule.dll
---@field streamingMipmapsMaxFileIORequests int
--
--Maximum number of frames queued up by graphics driver.
--
---@source UnityEngine.CoreModule.dll
---@field maxQueuedFrames int
--
--The indexed list of available Quality Settings.
--
---@source UnityEngine.CoreModule.dll
---@field names string[]
--
--Desired color space (Read Only).
--
---@source UnityEngine.CoreModule.dll
---@field desiredColorSpace UnityEngine.ColorSpace
--
--Active color space (Read Only).
--
---@source UnityEngine.CoreModule.dll
---@field activeColorSpace UnityEngine.ColorSpace
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.QualitySettings = {}

--
--Increase the current quality level.
--
--```plaintext
--Params: applyExpensiveChanges - Should expensive changes be applied (Anti-aliasing etc).
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param applyExpensiveChanges bool
function CS.UnityEngine.QualitySettings:IncreaseLevel(applyExpensiveChanges) end

--
--Decrease the current quality level.
--
--```plaintext
--Params: applyExpensiveChanges - Should expensive changes be applied (Anti-aliasing etc).
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param applyExpensiveChanges bool
function CS.UnityEngine.QualitySettings:DecreaseLevel(applyExpensiveChanges) end

---@source UnityEngine.CoreModule.dll
---@param index int
function CS.UnityEngine.QualitySettings:SetQualityLevel(index) end

---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.QualitySettings:IncreaseLevel() end

---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.QualitySettings:DecreaseLevel() end

--
--Returns null if the quality level does not exist, or if no asset is assigned to that quality level. Otherwise, returns the RenderPipelineAsset that defines the override render pipeline for the quality level.
--
--```plaintext
--Params: index - Index of the quality level.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param index int
---@return RenderPipelineAsset
function CS.UnityEngine.QualitySettings:GetRenderPipelineAssetAt(index) end

--
--Returns the current graphics quality level.
--
---@source UnityEngine.CoreModule.dll
---@return Int32
function CS.UnityEngine.QualitySettings:GetQualityLevel() end

--
--Sets a new graphics quality level.
--
--```plaintext
--Params: index - Quality index to set.
--        applyExpensiveChanges - Should expensive changes be applied (Anti-aliasing etc).
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param index int
---@param applyExpensiveChanges bool
function CS.UnityEngine.QualitySettings:SetQualityLevel(index, applyExpensiveChanges) end


--
--The type for the number of bits to be used when an HDR display is active in each color channel of swap chain buffers. The bit count also defines the method Unity uses to render content to the display.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.D3DHDRDisplayBitDepth: System.Enum
--
--Unity will use R10G10B10A2 buffer format and Rec2020 primaries with ST2084 PQ encoding.
--
---@source UnityEngine.CoreModule.dll
---@field D3DHDRDisplayBitDepth10 UnityEngine.D3DHDRDisplayBitDepth
--
--Unity will use R16G16B16A16 buffer format and Rec709 primaries with linear color (no encoding).
--
---@source UnityEngine.CoreModule.dll
---@field D3DHDRDisplayBitDepth16 UnityEngine.D3DHDRDisplayBitDepth
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.D3DHDRDisplayBitDepth = {}

---@source 
---@param value any
---@return UnityEngine.D3DHDRDisplayBitDepth
function CS.UnityEngine.D3DHDRDisplayBitDepth:__CastFrom(value) end


--
--Extension methods to the Renderer class, used only for the UpdateGIMaterials method used by the Global Illumination System.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.RendererExtensions: object
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.RendererExtensions = {}

--
--Schedules an update of the albedo and emissive Textures of a system that contains the Renderer.
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.RendererExtensions.UpdateGIMaterials() end


--
--Provides access to HDR display settings and information.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.HDROutputSettings: object
--
--The list of currently connected displays with possible HDR availability.
--
---@source UnityEngine.CoreModule.dll
---@field displays UnityEngine.HDROutputSettings[]
--
--The HDROutputSettings for the main display.
--
---@source UnityEngine.CoreModule.dll
---@field main UnityEngine.HDROutputSettings
--
--Describes whether HDR output is currently active on the display. It is true if this is the case, and @@false@ otherwise.
--
---@source UnityEngine.CoreModule.dll
---@field active bool
--
--Describes whether HDR is currently available on your primary display and that you have HDR enabled in your Unity Project. It is true if this is the case, and false otherwise.
--
---@source UnityEngine.CoreModule.dll
---@field available bool
--
--Describes whether Unity performs HDR tonemapping automatically.
--
---@source UnityEngine.CoreModule.dll
---@field automaticHDRTonemapping bool
--
--The ColorGamut used to output to the active HDR display.
--
---@source UnityEngine.CoreModule.dll
---@field displayColorGamut UnityEngine.ColorGamut
--
--The RenderTextureFormat of the display buffer for the active HDR display.
--
---@source UnityEngine.CoreModule.dll
---@field format UnityEngine.RenderTextureFormat
--
--The Experimental.Rendering.GraphicsFormat of the display buffer for the active HDR display.
--
---@source UnityEngine.CoreModule.dll
---@field graphicsFormat UnityEngine.Experimental.Rendering.GraphicsFormat
--
--The base luminance of a white paper surface in nits or candela per square meter (cd/m2).
--
---@source UnityEngine.CoreModule.dll
---@field paperWhiteNits float
--
--Maximum input luminance at which gradation is preserved even when the entire screen is bright.
--
---@source UnityEngine.CoreModule.dll
---@field maxFullFrameToneMapLuminance int
--
--Maximum input luminance at which gradation is preserved when 10% of the screen is bright.
--
---@source UnityEngine.CoreModule.dll
---@field maxToneMapLuminance int
--
--Minimum input luminance at which gradation is identifiable.
--
---@source UnityEngine.CoreModule.dll
---@field minToneMapLuminance int
--
--Describes whether the user has requested to change the HDR Output Mode. It is true if this is the case, and false otherwise.
--
---@source UnityEngine.CoreModule.dll
---@field HDRModeChangeRequested bool
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.HDROutputSettings = {}

--
--Use this function to request a change in the HDR Output Mode and in the value of HDROutputSettings.active.
--
--```plaintext
--Params: enabled - Indicates whether HDR should be enabled.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param enabled bool
function CS.UnityEngine.HDROutputSettings.RequestHDRModeChange(enabled) end

--
--Sets the base luminance of a white paper surface in nits or candela per square meter (cd/m2).
--
--```plaintext
--Params: paperWhite - The brightness of paper white in nits.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param paperWhite float
function CS.UnityEngine.HDROutputSettings:SetPaperWhiteInNits(paperWhite) end


--
--When using HDR rendering it can sometime be desirable to switch to LDR rendering during ImageEffect rendering.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.ImageEffectTransformsToLDR: System.Attribute
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.ImageEffectTransformsToLDR = {}


--
--Represents a display resolution.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.Resolution: System.ValueType
--
--Resolution width in pixels.
--
---@source UnityEngine.CoreModule.dll
---@field width int
--
--Resolution height in pixels.
--
---@source UnityEngine.CoreModule.dll
---@field height int
--
--Resolution's vertical refresh rate in Hz.
--
---@source UnityEngine.CoreModule.dll
---@field refreshRate int
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.Resolution = {}

--
--A string with the format "width x height @ refreshRateHz".
--
---@source UnityEngine.CoreModule.dll
---@return String
function CS.UnityEngine.Resolution.ToString() end


--
--Any Image Effect with this attribute can be rendered into the Scene view camera.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.ImageEffectAllowedInSceneView: System.Attribute
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.ImageEffectAllowedInSceneView = {}


--
--Any Image Effect with this attribute will be rendered after opaque geometry but before transparent geometry.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.ImageEffectOpaque: System.Attribute
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.ImageEffectOpaque = {}


--
--Any Image Effect with this attribute will be rendered after Dynamic Resolution stage.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.ImageEffectAfterScale: System.Attribute
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.ImageEffectAfterScale = {}


--
--Use this attribute when image effects are implemented using Command Buffers.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.ImageEffectUsesCommandBuffer: System.Attribute
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.ImageEffectUsesCommandBuffer = {}


--
--A class that allows you to create or modify meshes.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.Mesh: UnityEngine.Object
---@source UnityEngine.CoreModule.dll
---@field uv1 UnityEngine.Vector2[]
--
--Format of the mesh index buffer data.
--
---@source UnityEngine.CoreModule.dll
---@field indexFormat UnityEngine.Rendering.IndexFormat
--
--Gets the number of vertex buffers present in the Mesh. (Read Only)
--
---@source UnityEngine.CoreModule.dll
---@field vertexBufferCount int
--
--Returns BlendShape count on this mesh.
--
---@source UnityEngine.CoreModule.dll
---@field blendShapeCount int
--
--The bind poses. The bind pose at each index refers to the bone with the same index.
--
---@source UnityEngine.CoreModule.dll
---@field bindposes UnityEngine.Matrix4x4[]
--
--Returns true if the Mesh is read/write enabled, or false if it is not.
--
---@source UnityEngine.CoreModule.dll
---@field isReadable bool
--
--Returns the number of vertices in the Mesh (Read Only).
--
---@source UnityEngine.CoreModule.dll
---@field vertexCount int
--
--The number of sub-meshes inside the Mesh object.
--
---@source UnityEngine.CoreModule.dll
---@field subMeshCount int
--
--The bounding volume of the Mesh.
--
---@source UnityEngine.CoreModule.dll
---@field bounds UnityEngine.Bounds
--
--Returns a copy of the vertex positions or assigns a new vertex positions array.
--
---@source UnityEngine.CoreModule.dll
---@field vertices UnityEngine.Vector3[]
--
--The normals of the Mesh.
--
---@source UnityEngine.CoreModule.dll
---@field normals UnityEngine.Vector3[]
--
--The tangents of the Mesh.
--
---@source UnityEngine.CoreModule.dll
---@field tangents UnityEngine.Vector4[]
--
--The texture coordinates (UVs) in the first channel.
--
---@source UnityEngine.CoreModule.dll
---@field uv UnityEngine.Vector2[]
--
--The texture coordinates (UVs) in the second channel.
--
---@source UnityEngine.CoreModule.dll
---@field uv2 UnityEngine.Vector2[]
--
--The texture coordinates (UVs) in the third channel.
--
---@source UnityEngine.CoreModule.dll
---@field uv3 UnityEngine.Vector2[]
--
--The texture coordinates (UVs) in the fourth channel.
--
---@source UnityEngine.CoreModule.dll
---@field uv4 UnityEngine.Vector2[]
--
--The texture coordinates (UVs) in the fifth channel.
--
---@source UnityEngine.CoreModule.dll
---@field uv5 UnityEngine.Vector2[]
--
--The texture coordinates (UVs) in the sixth channel.
--
---@source UnityEngine.CoreModule.dll
---@field uv6 UnityEngine.Vector2[]
--
--The texture coordinates (UVs) in the seventh channel.
--
---@source UnityEngine.CoreModule.dll
---@field uv7 UnityEngine.Vector2[]
--
--The texture coordinates (UVs) in the eighth channel.
--
---@source UnityEngine.CoreModule.dll
---@field uv8 UnityEngine.Vector2[]
--
--Vertex colors of the Mesh.
--
---@source UnityEngine.CoreModule.dll
---@field colors UnityEngine.Color[]
--
--Vertex colors of the Mesh.
--
---@source UnityEngine.CoreModule.dll
---@field colors32 UnityEngine.Color32[]
--
--Returns the number of vertex attributes that the mesh has. (Read Only)
--
---@source UnityEngine.CoreModule.dll
---@field vertexAttributeCount int
--
--An array containing all triangles in the Mesh.
--
---@source UnityEngine.CoreModule.dll
---@field triangles int[]
--
--The BoneWeight for each vertex in the Mesh, which represents 4 bones per vertex.
--
---@source UnityEngine.CoreModule.dll
---@field boneWeights UnityEngine.BoneWeight[]
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.Mesh = {}

--
--Sets the index buffer size and format.
--
--```plaintext
--Params: indexCount - Size of index buffer.
--        format - Format of the indices.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param indexCount int
---@param format UnityEngine.Rendering.IndexFormat
function CS.UnityEngine.Mesh.SetIndexBufferParams(indexCount, format) end

--
--Information about the vertex attribute.
--
--```plaintext
--Params: index - The vertex attribute index (0 to vertexAttributeCount-1).
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param index int
---@return VertexAttributeDescriptor
function CS.UnityEngine.Mesh.GetVertexAttribute(index) end

--
--Returns true if the data attribute is present in the mesh.
--
--```plaintext
--Params: attr - Vertex data attribute to check for.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param attr UnityEngine.Rendering.VertexAttribute
---@return Boolean
function CS.UnityEngine.Mesh.HasVertexAttribute(attr) end

--
--Dimensionality of the data attribute, or zero if it is not present.
--
--```plaintext
--Params: attr - Vertex data attribute to check for.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param attr UnityEngine.Rendering.VertexAttribute
---@return Int32
function CS.UnityEngine.Mesh.GetVertexAttributeDimension(attr) end

--
--Format of the data attribute.
--
--```plaintext
--Params: attr - Vertex data attribute to check for.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param attr UnityEngine.Rendering.VertexAttribute
---@return VertexAttributeFormat
function CS.UnityEngine.Mesh.GetVertexAttributeFormat(attr) end

--
--Pointer to the underlying graphics API vertex buffer.
--
--```plaintext
--Params: bufferIndex - Which vertex buffer to get (some Meshes might have more than one). See vertexBufferCount.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param index int
---@return IntPtr
function CS.UnityEngine.Mesh.GetNativeVertexBufferPtr(index) end

--
--Pointer to the underlying graphics API index buffer.
--
---@source UnityEngine.CoreModule.dll
---@return IntPtr
function CS.UnityEngine.Mesh.GetNativeIndexBufferPtr() end

--
--Clears all blend shapes from Mesh.
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.Mesh.ClearBlendShapes() end

--
--Returns name of BlendShape by given index.
--
---@source UnityEngine.CoreModule.dll
---@param shapeIndex int
---@return String
function CS.UnityEngine.Mesh.GetBlendShapeName(shapeIndex) end

--
--Returns index of BlendShape by given name.
--
---@source UnityEngine.CoreModule.dll
---@param blendShapeName string
---@return Int32
function CS.UnityEngine.Mesh.GetBlendShapeIndex(blendShapeName) end

--
--Returns the frame count for a blend shape.
--
--```plaintext
--Params: shapeIndex - The shape index to get frame count from.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param shapeIndex int
---@return Int32
function CS.UnityEngine.Mesh.GetBlendShapeFrameCount(shapeIndex) end

--
--Returns the weight of a blend shape frame.
--
--```plaintext
--Params: shapeIndex - The shape index of the frame.
--        frameIndex - The frame index to get the weight from.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param shapeIndex int
---@param frameIndex int
---@return Single
function CS.UnityEngine.Mesh.GetBlendShapeFrameWeight(shapeIndex, frameIndex) end

--
--Retreives deltaVertices, deltaNormals and deltaTangents of a blend shape frame.
--
--```plaintext
--Params: shapeIndex - The shape index of the frame.
--        frameIndex - The frame index to get the weight from.
--        deltaVertices - Delta vertices output array for the frame being retreived.
--        deltaNormals - Delta normals output array for the frame being retreived.
--        deltaTangents - Delta tangents output array for the frame being retreived.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param shapeIndex int
---@param frameIndex int
---@param deltaVertices UnityEngine.Vector3[]
---@param deltaNormals UnityEngine.Vector3[]
---@param deltaTangents UnityEngine.Vector3[]
function CS.UnityEngine.Mesh.GetBlendShapeFrameVertices(shapeIndex, frameIndex, deltaVertices, deltaNormals, deltaTangents) end

--
--Adds a new blend shape frame.
--
--```plaintext
--Params: shapeName - Name of the blend shape to add a frame to.
--        frameWeight - Weight for the frame being added.
--        deltaVertices - Delta vertices for the frame being added.
--        deltaNormals - Delta normals for the frame being added.
--        deltaTangents - Delta tangents for the frame being added.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param shapeName string
---@param frameWeight float
---@param deltaVertices UnityEngine.Vector3[]
---@param deltaNormals UnityEngine.Vector3[]
---@param deltaTangents UnityEngine.Vector3[]
function CS.UnityEngine.Mesh.AddBlendShapeFrame(shapeName, frameWeight, deltaVertices, deltaNormals, deltaTangents) end

---@source UnityEngine.CoreModule.dll
---@param bonesPerVertex Unity.Collections.NativeArray<byte>
---@param weights Unity.Collections.NativeArray<UnityEngine.BoneWeight1>
function CS.UnityEngine.Mesh.SetBoneWeights(bonesPerVertex, weights) end

--
--Returns all non-zero bone weights for the Mesh, in vertex index order.
--
---@source UnityEngine.CoreModule.dll
---@return NativeArray
function CS.UnityEngine.Mesh.GetAllBoneWeights() end

--
--Returns the number of non-zero bone weights for each vertex.
--
---@source UnityEngine.CoreModule.dll
---@return NativeArray
function CS.UnityEngine.Mesh.GetBonesPerVertex() end

--
--Sets the information about a sub-mesh of the Mesh.
--
--```plaintext
--Params: index - Sub-mesh index. See subMeshCount. Out of range indices throw an exception.
--        desc - Sub-mesh data.
--        flags - Flags controlling the function behavior, see MeshUpdateFlags.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param index int
---@param desc UnityEngine.Rendering.SubMeshDescriptor
---@param flags UnityEngine.Rendering.MeshUpdateFlags
function CS.UnityEngine.Mesh.SetSubMesh(index, desc, flags) end

--
--Sub-mesh data.
--
--```plaintext
--Params: index - Sub-mesh index. See subMeshCount. Out of range indices throw an exception.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param index int
---@return SubMeshDescriptor
function CS.UnityEngine.Mesh.GetSubMesh(index) end

--
--Notify Renderer components of mesh geometry change.
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.Mesh.MarkModified() end

--
--Average of triangle area / uv area.
--
--```plaintext
--Params: uvSetIndex - UV set index to return the UV distibution metric for. 0 for first.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param uvSetIndex int
---@return Single
function CS.UnityEngine.Mesh.GetUVDistributionMetric(uvSetIndex) end

---@source UnityEngine.CoreModule.dll
---@param vertices System.Collections.Generic.List<UnityEngine.Vector3>
function CS.UnityEngine.Mesh.GetVertices(vertices) end

---@source UnityEngine.CoreModule.dll
---@param inVertices System.Collections.Generic.List<UnityEngine.Vector3>
function CS.UnityEngine.Mesh.SetVertices(inVertices) end

---@source UnityEngine.CoreModule.dll
---@param inVertices System.Collections.Generic.List<UnityEngine.Vector3>
---@param start int
---@param length int
function CS.UnityEngine.Mesh.SetVertices(inVertices, start, length) end

---@source UnityEngine.CoreModule.dll
---@param inVertices System.Collections.Generic.List<UnityEngine.Vector3>
---@param start int
---@param length int
---@param flags UnityEngine.Rendering.MeshUpdateFlags
function CS.UnityEngine.Mesh.SetVertices(inVertices, start, length, flags) end

--
--Assigns a new vertex positions array.
--
--```plaintext
--Params: inVertices - Per-vertex positions.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param inVertices UnityEngine.Vector3[]
function CS.UnityEngine.Mesh.SetVertices(inVertices) end

--
--Sets the vertex positions of the Mesh, using a part of the input array.
--
--```plaintext
--Params: inVertices - Per-vertex positions.
--        start - Index of the first element to take from the input array.
--        length - Number of elements to take from the input array.
--        flags - Flags controlling the function behavior, see MeshUpdateFlags.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param inVertices UnityEngine.Vector3[]
---@param start int
---@param length int
function CS.UnityEngine.Mesh.SetVertices(inVertices, start, length) end

--
--Sets the vertex positions of the Mesh, using a part of the input array.
--
--```plaintext
--Params: inVertices - Per-vertex positions.
--        start - Index of the first element to take from the input array.
--        length - Number of elements to take from the input array.
--        flags - Flags controlling the function behavior, see MeshUpdateFlags.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param inVertices UnityEngine.Vector3[]
---@param start int
---@param length int
---@param flags UnityEngine.Rendering.MeshUpdateFlags
function CS.UnityEngine.Mesh.SetVertices(inVertices, start, length, flags) end

---@source UnityEngine.CoreModule.dll
---@param inVertices Unity.Collections.NativeArray<T>
function CS.UnityEngine.Mesh.SetVertices(inVertices) end

---@source UnityEngine.CoreModule.dll
---@param inVertices Unity.Collections.NativeArray<T>
---@param start int
---@param length int
function CS.UnityEngine.Mesh.SetVertices(inVertices, start, length) end

---@source UnityEngine.CoreModule.dll
---@param inVertices Unity.Collections.NativeArray<T>
---@param start int
---@param length int
---@param flags UnityEngine.Rendering.MeshUpdateFlags
function CS.UnityEngine.Mesh.SetVertices(inVertices, start, length, flags) end

---@source UnityEngine.CoreModule.dll
---@param normals System.Collections.Generic.List<UnityEngine.Vector3>
function CS.UnityEngine.Mesh.GetNormals(normals) end

---@source UnityEngine.CoreModule.dll
---@param inNormals System.Collections.Generic.List<UnityEngine.Vector3>
function CS.UnityEngine.Mesh.SetNormals(inNormals) end

---@source UnityEngine.CoreModule.dll
---@param inNormals System.Collections.Generic.List<UnityEngine.Vector3>
---@param start int
---@param length int
function CS.UnityEngine.Mesh.SetNormals(inNormals, start, length) end

---@source UnityEngine.CoreModule.dll
---@param inNormals System.Collections.Generic.List<UnityEngine.Vector3>
---@param start int
---@param length int
---@param flags UnityEngine.Rendering.MeshUpdateFlags
function CS.UnityEngine.Mesh.SetNormals(inNormals, start, length, flags) end

--
--Set the normals of the Mesh.
--
--```plaintext
--Params: inNormals - Per-vertex normals.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param inNormals UnityEngine.Vector3[]
function CS.UnityEngine.Mesh.SetNormals(inNormals) end

--
--Sets the vertex normals of the Mesh, using a part of the input array.
--
--```plaintext
--Params: inNormals - Per-vertex normals.
--        start - Index of the first element to take from the input array.
--        length - Number of elements to take from the input array.
--        flags - Flags controlling the function behavior, see MeshUpdateFlags.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param inNormals UnityEngine.Vector3[]
---@param start int
---@param length int
function CS.UnityEngine.Mesh.SetNormals(inNormals, start, length) end

--
--Sets the vertex normals of the Mesh, using a part of the input array.
--
--```plaintext
--Params: inNormals - Per-vertex normals.
--        start - Index of the first element to take from the input array.
--        length - Number of elements to take from the input array.
--        flags - Flags controlling the function behavior, see MeshUpdateFlags.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param inNormals UnityEngine.Vector3[]
---@param start int
---@param length int
---@param flags UnityEngine.Rendering.MeshUpdateFlags
function CS.UnityEngine.Mesh.SetNormals(inNormals, start, length, flags) end

---@source UnityEngine.CoreModule.dll
---@param inNormals Unity.Collections.NativeArray<T>
function CS.UnityEngine.Mesh.SetNormals(inNormals) end

---@source UnityEngine.CoreModule.dll
---@param inNormals Unity.Collections.NativeArray<T>
---@param start int
---@param length int
function CS.UnityEngine.Mesh.SetNormals(inNormals, start, length) end

---@source UnityEngine.CoreModule.dll
---@param inNormals Unity.Collections.NativeArray<T>
---@param start int
---@param length int
---@param flags UnityEngine.Rendering.MeshUpdateFlags
function CS.UnityEngine.Mesh.SetNormals(inNormals, start, length, flags) end

---@source UnityEngine.CoreModule.dll
---@param tangents System.Collections.Generic.List<UnityEngine.Vector4>
function CS.UnityEngine.Mesh.GetTangents(tangents) end

---@source UnityEngine.CoreModule.dll
---@param inTangents System.Collections.Generic.List<UnityEngine.Vector4>
function CS.UnityEngine.Mesh.SetTangents(inTangents) end

---@source UnityEngine.CoreModule.dll
---@param inTangents System.Collections.Generic.List<UnityEngine.Vector4>
---@param start int
---@param length int
function CS.UnityEngine.Mesh.SetTangents(inTangents, start, length) end

---@source UnityEngine.CoreModule.dll
---@param inTangents System.Collections.Generic.List<UnityEngine.Vector4>
---@param start int
---@param length int
---@param flags UnityEngine.Rendering.MeshUpdateFlags
function CS.UnityEngine.Mesh.SetTangents(inTangents, start, length, flags) end

--
--Set the tangents of the Mesh.
--
--```plaintext
--Params: inTangents - Per-vertex tangents.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param inTangents UnityEngine.Vector4[]
function CS.UnityEngine.Mesh.SetTangents(inTangents) end

--
--Sets the tangents of the Mesh, using a part of the input array.
--
--```plaintext
--Params: inTangents - Per-vertex tangents.
--        start - Index of the first element to take from the input array.
--        length - Number of elements to take from the input array.
--        flags - Flags controlling the function behavior, see MeshUpdateFlags.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param inTangents UnityEngine.Vector4[]
---@param start int
---@param length int
function CS.UnityEngine.Mesh.SetTangents(inTangents, start, length) end

--
--Sets the tangents of the Mesh, using a part of the input array.
--
--```plaintext
--Params: inTangents - Per-vertex tangents.
--        start - Index of the first element to take from the input array.
--        length - Number of elements to take from the input array.
--        flags - Flags controlling the function behavior, see MeshUpdateFlags.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param inTangents UnityEngine.Vector4[]
---@param start int
---@param length int
---@param flags UnityEngine.Rendering.MeshUpdateFlags
function CS.UnityEngine.Mesh.SetTangents(inTangents, start, length, flags) end

---@source UnityEngine.CoreModule.dll
---@param inTangents Unity.Collections.NativeArray<T>
function CS.UnityEngine.Mesh.SetTangents(inTangents) end

---@source UnityEngine.CoreModule.dll
---@param inTangents Unity.Collections.NativeArray<T>
---@param start int
---@param length int
function CS.UnityEngine.Mesh.SetTangents(inTangents, start, length) end

---@source UnityEngine.CoreModule.dll
---@param inTangents Unity.Collections.NativeArray<T>
---@param start int
---@param length int
---@param flags UnityEngine.Rendering.MeshUpdateFlags
function CS.UnityEngine.Mesh.SetTangents(inTangents, start, length, flags) end

---@source UnityEngine.CoreModule.dll
---@param colors System.Collections.Generic.List<UnityEngine.Color>
function CS.UnityEngine.Mesh.GetColors(colors) end

---@source UnityEngine.CoreModule.dll
---@param inColors System.Collections.Generic.List<UnityEngine.Color>
function CS.UnityEngine.Mesh.SetColors(inColors) end

---@source UnityEngine.CoreModule.dll
---@param inColors System.Collections.Generic.List<UnityEngine.Color>
---@param start int
---@param length int
function CS.UnityEngine.Mesh.SetColors(inColors, start, length) end

---@source UnityEngine.CoreModule.dll
---@param inColors System.Collections.Generic.List<UnityEngine.Color>
---@param start int
---@param length int
---@param flags UnityEngine.Rendering.MeshUpdateFlags
function CS.UnityEngine.Mesh.SetColors(inColors, start, length, flags) end

--
--Set the per-vertex colors of the Mesh.
--
--```plaintext
--Params: inColors - Per-vertex colors.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param inColors UnityEngine.Color[]
function CS.UnityEngine.Mesh.SetColors(inColors) end

--
--Sets the per-vertex colors of the Mesh, using a part of the input array.
--
--```plaintext
--Params: inColors - Per-vertex colors.
--        start - Index of the first element to take from the input array.
--        length - Number of elements to take from the input array.
--        flags - Flags controlling the function behavior, see MeshUpdateFlags.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param inColors UnityEngine.Color[]
---@param start int
---@param length int
function CS.UnityEngine.Mesh.SetColors(inColors, start, length) end

--
--Sets the per-vertex colors of the Mesh, using a part of the input array.
--
--```plaintext
--Params: inColors - Per-vertex colors.
--        start - Index of the first element to take from the input array.
--        length - Number of elements to take from the input array.
--        flags - Flags controlling the function behavior, see MeshUpdateFlags.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param inColors UnityEngine.Color[]
---@param start int
---@param length int
---@param flags UnityEngine.Rendering.MeshUpdateFlags
function CS.UnityEngine.Mesh.SetColors(inColors, start, length, flags) end

---@source UnityEngine.CoreModule.dll
---@param colors System.Collections.Generic.List<UnityEngine.Color32>
function CS.UnityEngine.Mesh.GetColors(colors) end

---@source UnityEngine.CoreModule.dll
---@param inColors System.Collections.Generic.List<UnityEngine.Color32>
function CS.UnityEngine.Mesh.SetColors(inColors) end

---@source UnityEngine.CoreModule.dll
---@param inColors System.Collections.Generic.List<UnityEngine.Color32>
---@param start int
---@param length int
function CS.UnityEngine.Mesh.SetColors(inColors, start, length) end

---@source UnityEngine.CoreModule.dll
---@param inColors System.Collections.Generic.List<UnityEngine.Color32>
---@param start int
---@param length int
---@param flags UnityEngine.Rendering.MeshUpdateFlags
function CS.UnityEngine.Mesh.SetColors(inColors, start, length, flags) end

--
--Set the per-vertex colors of the Mesh.
--
--```plaintext
--Params: inColors - Per-vertex colors.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param inColors UnityEngine.Color32[]
function CS.UnityEngine.Mesh.SetColors(inColors) end

--
--Sets the per-vertex colors of the Mesh, using a part of the input array.
--
--```plaintext
--Params: inColors - Per-vertex colors.
--        start - Index of the first element to take from the input array.
--        length - Number of elements to take from the input array.
--        flags - Flags controlling the function behavior, see MeshUpdateFlags.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param inColors UnityEngine.Color32[]
---@param start int
---@param length int
function CS.UnityEngine.Mesh.SetColors(inColors, start, length) end

--
--Sets the per-vertex colors of the Mesh, using a part of the input array.
--
--```plaintext
--Params: inColors - Per-vertex colors.
--        start - Index of the first element to take from the input array.
--        length - Number of elements to take from the input array.
--        flags - Flags controlling the function behavior, see MeshUpdateFlags.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param inColors UnityEngine.Color32[]
---@param start int
---@param length int
---@param flags UnityEngine.Rendering.MeshUpdateFlags
function CS.UnityEngine.Mesh.SetColors(inColors, start, length, flags) end

---@source UnityEngine.CoreModule.dll
---@param inColors Unity.Collections.NativeArray<T>
function CS.UnityEngine.Mesh.SetColors(inColors) end

---@source UnityEngine.CoreModule.dll
---@param inColors Unity.Collections.NativeArray<T>
---@param start int
---@param length int
function CS.UnityEngine.Mesh.SetColors(inColors, start, length) end

---@source UnityEngine.CoreModule.dll
---@param inColors Unity.Collections.NativeArray<T>
---@param start int
---@param length int
---@param flags UnityEngine.Rendering.MeshUpdateFlags
function CS.UnityEngine.Mesh.SetColors(inColors, start, length, flags) end

---@source UnityEngine.CoreModule.dll
---@param channel int
---@param uvs System.Collections.Generic.List<UnityEngine.Vector2>
function CS.UnityEngine.Mesh.SetUVs(channel, uvs) end

---@source UnityEngine.CoreModule.dll
---@param channel int
---@param uvs System.Collections.Generic.List<UnityEngine.Vector3>
function CS.UnityEngine.Mesh.SetUVs(channel, uvs) end

---@source UnityEngine.CoreModule.dll
---@param channel int
---@param uvs System.Collections.Generic.List<UnityEngine.Vector4>
function CS.UnityEngine.Mesh.SetUVs(channel, uvs) end

---@source UnityEngine.CoreModule.dll
---@param channel int
---@param uvs System.Collections.Generic.List<UnityEngine.Vector2>
---@param start int
---@param length int
function CS.UnityEngine.Mesh.SetUVs(channel, uvs, start, length) end

---@source UnityEngine.CoreModule.dll
---@param channel int
---@param uvs System.Collections.Generic.List<UnityEngine.Vector2>
---@param start int
---@param length int
---@param flags UnityEngine.Rendering.MeshUpdateFlags
function CS.UnityEngine.Mesh.SetUVs(channel, uvs, start, length, flags) end

---@source UnityEngine.CoreModule.dll
---@param channel int
---@param uvs System.Collections.Generic.List<UnityEngine.Vector3>
---@param start int
---@param length int
function CS.UnityEngine.Mesh.SetUVs(channel, uvs, start, length) end

---@source UnityEngine.CoreModule.dll
---@param channel int
---@param uvs System.Collections.Generic.List<UnityEngine.Vector3>
---@param start int
---@param length int
---@param flags UnityEngine.Rendering.MeshUpdateFlags
function CS.UnityEngine.Mesh.SetUVs(channel, uvs, start, length, flags) end

---@source UnityEngine.CoreModule.dll
---@param channel int
---@param uvs System.Collections.Generic.List<UnityEngine.Vector4>
---@param start int
---@param length int
function CS.UnityEngine.Mesh.SetUVs(channel, uvs, start, length) end

---@source UnityEngine.CoreModule.dll
---@param channel int
---@param uvs System.Collections.Generic.List<UnityEngine.Vector4>
---@param start int
---@param length int
---@param flags UnityEngine.Rendering.MeshUpdateFlags
function CS.UnityEngine.Mesh.SetUVs(channel, uvs, start, length, flags) end

--
--Sets the texture coordinates (UVs) stored in a given channel.
--
--```plaintext
--Params: channel - The channel, in [0..7] range.
--        uvs - The UV data to set.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param channel int
---@param uvs UnityEngine.Vector2[]
function CS.UnityEngine.Mesh.SetUVs(channel, uvs) end

--
--Sets the texture coordinates (UVs) stored in a given channel.
--
--```plaintext
--Params: channel - The channel, in [0..7] range.
--        uvs - The UV data to set.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param channel int
---@param uvs UnityEngine.Vector3[]
function CS.UnityEngine.Mesh.SetUVs(channel, uvs) end

--
--Sets the texture coordinates (UVs) stored in a given channel.
--
--```plaintext
--Params: channel - The channel, in [0..7] range.
--        uvs - The UV data to set.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param channel int
---@param uvs UnityEngine.Vector4[]
function CS.UnityEngine.Mesh.SetUVs(channel, uvs) end

--
--Sets the UVs of the Mesh, using a part of the input array.
--
--```plaintext
--Params: channel - The UV channel, in [0..7] range.
--        uvs - UVs to set for the given index.
--        start - Index of the first element to take from the input array.
--        length - Number of elements to take from the input array.
--        flags - Flags controlling the function behavior, see MeshUpdateFlags.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param channel int
---@param uvs UnityEngine.Vector2[]
---@param start int
---@param length int
function CS.UnityEngine.Mesh.SetUVs(channel, uvs, start, length) end

--
--Sets the UVs of the Mesh, using a part of the input array.
--
--```plaintext
--Params: channel - The UV channel, in [0..7] range.
--        uvs - UVs to set for the given index.
--        start - Index of the first element to take from the input array.
--        length - Number of elements to take from the input array.
--        flags - Flags controlling the function behavior, see MeshUpdateFlags.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param channel int
---@param uvs UnityEngine.Vector2[]
---@param start int
---@param length int
---@param flags UnityEngine.Rendering.MeshUpdateFlags
function CS.UnityEngine.Mesh.SetUVs(channel, uvs, start, length, flags) end

--
--Sets the UVs of the Mesh, using a part of the input array.
--
--```plaintext
--Params: channel - The UV channel, in [0..7] range.
--        uvs - UVs to set for the given index.
--        start - Index of the first element to take from the input array.
--        length - Number of elements to take from the input array.
--        flags - Flags controlling the function behavior, see MeshUpdateFlags.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param channel int
---@param uvs UnityEngine.Vector3[]
---@param start int
---@param length int
function CS.UnityEngine.Mesh.SetUVs(channel, uvs, start, length) end

--
--Sets the UVs of the Mesh, using a part of the input array.
--
--```plaintext
--Params: channel - The UV channel, in [0..7] range.
--        uvs - UVs to set for the given index.
--        start - Index of the first element to take from the input array.
--        length - Number of elements to take from the input array.
--        flags - Flags controlling the function behavior, see MeshUpdateFlags.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param channel int
---@param uvs UnityEngine.Vector3[]
---@param start int
---@param length int
---@param flags UnityEngine.Rendering.MeshUpdateFlags
function CS.UnityEngine.Mesh.SetUVs(channel, uvs, start, length, flags) end

--
--Sets the UVs of the Mesh, using a part of the input array.
--
--```plaintext
--Params: channel - The UV channel, in [0..7] range.
--        uvs - UVs to set for the given index.
--        start - Index of the first element to take from the input array.
--        length - Number of elements to take from the input array.
--        flags - Flags controlling the function behavior, see MeshUpdateFlags.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param channel int
---@param uvs UnityEngine.Vector4[]
---@param start int
---@param length int
function CS.UnityEngine.Mesh.SetUVs(channel, uvs, start, length) end

--
--Sets the UVs of the Mesh, using a part of the input array.
--
--```plaintext
--Params: channel - The UV channel, in [0..7] range.
--        uvs - UVs to set for the given index.
--        start - Index of the first element to take from the input array.
--        length - Number of elements to take from the input array.
--        flags - Flags controlling the function behavior, see MeshUpdateFlags.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param channel int
---@param uvs UnityEngine.Vector4[]
---@param start int
---@param length int
---@param flags UnityEngine.Rendering.MeshUpdateFlags
function CS.UnityEngine.Mesh.SetUVs(channel, uvs, start, length, flags) end

---@source UnityEngine.CoreModule.dll
---@param channel int
---@param uvs Unity.Collections.NativeArray<T>
function CS.UnityEngine.Mesh.SetUVs(channel, uvs) end

---@source UnityEngine.CoreModule.dll
---@param channel int
---@param uvs Unity.Collections.NativeArray<T>
---@param start int
---@param length int
function CS.UnityEngine.Mesh.SetUVs(channel, uvs, start, length) end

---@source UnityEngine.CoreModule.dll
---@param channel int
---@param uvs Unity.Collections.NativeArray<T>
---@param start int
---@param length int
---@param flags UnityEngine.Rendering.MeshUpdateFlags
function CS.UnityEngine.Mesh.SetUVs(channel, uvs, start, length, flags) end

---@source UnityEngine.CoreModule.dll
---@param channel int
---@param uvs System.Collections.Generic.List<UnityEngine.Vector2>
function CS.UnityEngine.Mesh.GetUVs(channel, uvs) end

---@source UnityEngine.CoreModule.dll
---@param channel int
---@param uvs System.Collections.Generic.List<UnityEngine.Vector3>
function CS.UnityEngine.Mesh.GetUVs(channel, uvs) end

---@source UnityEngine.CoreModule.dll
---@param channel int
---@param uvs System.Collections.Generic.List<UnityEngine.Vector4>
function CS.UnityEngine.Mesh.GetUVs(channel, uvs) end

--
--Array of vertex attribute information.
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.Mesh.GetVertexAttributes() end

--
--The number of vertex attributes returned in the attributes container.
--
--```plaintext
--Params: attributes - Collection of vertex attributes to receive the results.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param attributes UnityEngine.Rendering.VertexAttributeDescriptor[]
---@return Int32
function CS.UnityEngine.Mesh.GetVertexAttributes(attributes) end

---@source UnityEngine.CoreModule.dll
---@param attributes System.Collections.Generic.List<UnityEngine.Rendering.VertexAttributeDescriptor>
---@return Int32
function CS.UnityEngine.Mesh.GetVertexAttributes(attributes) end

--
--Sets the vertex buffer size and layout.
--
--```plaintext
--Params: vertexCount - The number of vertices in the Mesh.
--        attributes - Layout of the vertex data -- which attributes are present, their data types and so on.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param vertexCount int
---@param attributes UnityEngine.Rendering.VertexAttributeDescriptor[]
function CS.UnityEngine.Mesh.SetVertexBufferParams(vertexCount, attributes) end

---@source UnityEngine.CoreModule.dll
---@param vertexCount int
---@param attributes Unity.Collections.NativeArray<UnityEngine.Rendering.VertexAttributeDescriptor>
function CS.UnityEngine.Mesh.SetVertexBufferParams(vertexCount, attributes) end

---@source UnityEngine.CoreModule.dll
---@param data Unity.Collections.NativeArray<T>
---@param dataStart int
---@param meshBufferStart int
---@param count int
---@param stream int
---@param flags UnityEngine.Rendering.MeshUpdateFlags
function CS.UnityEngine.Mesh.SetVertexBufferData(data, dataStart, meshBufferStart, count, stream, flags) end

---@source UnityEngine.CoreModule.dll
---@param data T[]
---@param dataStart int
---@param meshBufferStart int
---@param count int
---@param stream int
---@param flags UnityEngine.Rendering.MeshUpdateFlags
function CS.UnityEngine.Mesh.SetVertexBufferData(data, dataStart, meshBufferStart, count, stream, flags) end

---@source UnityEngine.CoreModule.dll
---@param data System.Collections.Generic.List<T>
---@param dataStart int
---@param meshBufferStart int
---@param count int
---@param stream int
---@param flags UnityEngine.Rendering.MeshUpdateFlags
function CS.UnityEngine.Mesh.SetVertexBufferData(data, dataStart, meshBufferStart, count, stream, flags) end

--
--Returns a MeshDataArray containing read-only MeshData structs. See Mesh.MeshDataArray and Mesh.MeshData.
--
--```plaintext
--Params: mesh - The input mesh.
--        meshes - The input meshes.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@return MeshDataArray
function CS.UnityEngine.Mesh:AcquireReadOnlyMeshData(mesh) end

--
--Returns a MeshDataArray containing read-only MeshData structs. See Mesh.MeshDataArray and Mesh.MeshData.
--
--```plaintext
--Params: mesh - The input mesh.
--        meshes - The input meshes.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param meshes UnityEngine.Mesh[]
---@return MeshDataArray
function CS.UnityEngine.Mesh:AcquireReadOnlyMeshData(meshes) end

---@source UnityEngine.CoreModule.dll
---@param meshes System.Collections.Generic.List<UnityEngine.Mesh>
---@return MeshDataArray
function CS.UnityEngine.Mesh:AcquireReadOnlyMeshData(meshes) end

--
--Returns a MeshDataArray containing writeable MeshData structs. See Mesh.MeshDataArray and Mesh.MeshData.
--
--```plaintext
--Params: meshCount - The amount of meshes that will be created.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param meshCount int
---@return MeshDataArray
function CS.UnityEngine.Mesh:AllocateWritableMeshData(meshCount) end

---@source UnityEngine.CoreModule.dll
---@param data UnityEngine.Mesh.MeshDataArray
---@param mesh UnityEngine.Mesh
---@param flags UnityEngine.Rendering.MeshUpdateFlags
function CS.UnityEngine.Mesh:ApplyAndDisposeWritableMeshData(data, mesh, flags) end

---@source UnityEngine.CoreModule.dll
---@param data UnityEngine.Mesh.MeshDataArray
---@param meshes UnityEngine.Mesh[]
---@param flags UnityEngine.Rendering.MeshUpdateFlags
function CS.UnityEngine.Mesh:ApplyAndDisposeWritableMeshData(data, meshes, flags) end

---@source UnityEngine.CoreModule.dll
---@param data UnityEngine.Mesh.MeshDataArray
---@param meshes System.Collections.Generic.List<UnityEngine.Mesh>
---@param flags UnityEngine.Rendering.MeshUpdateFlags
function CS.UnityEngine.Mesh:ApplyAndDisposeWritableMeshData(data, meshes, flags) end

--
--Fetches the triangle list for the specified sub-mesh on this object.
--
--```plaintext
--Params: triangles - A list of vertex indices to populate.
--        submesh - The sub-mesh index. See subMeshCount.
--        applyBaseVertex - True (default value) will apply base vertex offset to returned indices.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param submesh int
function CS.UnityEngine.Mesh.GetTriangles(submesh) end

--
--Fetches the triangle list for the specified sub-mesh on this object.
--
--```plaintext
--Params: triangles - A list of vertex indices to populate.
--        submesh - The sub-mesh index. See subMeshCount.
--        applyBaseVertex - True (default value) will apply base vertex offset to returned indices.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param submesh int
---@param applyBaseVertex bool
function CS.UnityEngine.Mesh.GetTriangles(submesh, applyBaseVertex) end

---@source UnityEngine.CoreModule.dll
---@param triangles System.Collections.Generic.List<int>
---@param submesh int
function CS.UnityEngine.Mesh.GetTriangles(triangles, submesh) end

---@source UnityEngine.CoreModule.dll
---@param triangles System.Collections.Generic.List<int>
---@param submesh int
---@param applyBaseVertex bool
function CS.UnityEngine.Mesh.GetTriangles(triangles, submesh, applyBaseVertex) end

---@source UnityEngine.CoreModule.dll
---@param triangles System.Collections.Generic.List<ushort>
---@param submesh int
---@param applyBaseVertex bool
function CS.UnityEngine.Mesh.GetTriangles(triangles, submesh, applyBaseVertex) end

--
--Array with face indices.
--
--```plaintext
--Params: submesh - The sub-mesh index. See subMeshCount.
--        applyBaseVertex - True (default value) will apply base vertex offset to returned indices.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param submesh int
function CS.UnityEngine.Mesh.GetIndices(submesh) end

--
--Array with face indices.
--
--```plaintext
--Params: submesh - The sub-mesh index. See subMeshCount.
--        applyBaseVertex - True (default value) will apply base vertex offset to returned indices.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param submesh int
---@param applyBaseVertex bool
function CS.UnityEngine.Mesh.GetIndices(submesh, applyBaseVertex) end

---@source UnityEngine.CoreModule.dll
---@param indices System.Collections.Generic.List<int>
---@param submesh int
function CS.UnityEngine.Mesh.GetIndices(indices, submesh) end

---@source UnityEngine.CoreModule.dll
---@param indices System.Collections.Generic.List<int>
---@param submesh int
---@param applyBaseVertex bool
function CS.UnityEngine.Mesh.GetIndices(indices, submesh, applyBaseVertex) end

---@source UnityEngine.CoreModule.dll
---@param indices System.Collections.Generic.List<ushort>
---@param submesh int
---@param applyBaseVertex bool
function CS.UnityEngine.Mesh.GetIndices(indices, submesh, applyBaseVertex) end

---@source UnityEngine.CoreModule.dll
---@param data Unity.Collections.NativeArray<T>
---@param dataStart int
---@param meshBufferStart int
---@param count int
---@param flags UnityEngine.Rendering.MeshUpdateFlags
function CS.UnityEngine.Mesh.SetIndexBufferData(data, dataStart, meshBufferStart, count, flags) end

---@source UnityEngine.CoreModule.dll
---@param data T[]
---@param dataStart int
---@param meshBufferStart int
---@param count int
---@param flags UnityEngine.Rendering.MeshUpdateFlags
function CS.UnityEngine.Mesh.SetIndexBufferData(data, dataStart, meshBufferStart, count, flags) end

---@source UnityEngine.CoreModule.dll
---@param data System.Collections.Generic.List<T>
---@param dataStart int
---@param meshBufferStart int
---@param count int
---@param flags UnityEngine.Rendering.MeshUpdateFlags
function CS.UnityEngine.Mesh.SetIndexBufferData(data, dataStart, meshBufferStart, count, flags) end

--
--Gets the starting index location within the Mesh's index buffer, for the given sub-mesh.
--
---@source UnityEngine.CoreModule.dll
---@param submesh int
---@return UInt32
function CS.UnityEngine.Mesh.GetIndexStart(submesh) end

--
--Gets the index count of the given sub-mesh.
--
---@source UnityEngine.CoreModule.dll
---@param submesh int
---@return UInt32
function CS.UnityEngine.Mesh.GetIndexCount(submesh) end

--
--The offset applied to all vertex indices of this sub-mesh.
--
--```plaintext
--Params: submesh - The sub-mesh index. See subMeshCount.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param submesh int
---@return UInt32
function CS.UnityEngine.Mesh.GetBaseVertex(submesh) end

--
--Sets the triangle list for the sub-mesh.
--
--```plaintext
--Params: triangles - The list of indices that define the triangles.
--        submesh - The sub-mesh to modify.
--        calculateBounds - Calculate the bounding box of the Mesh after setting the triangles. This is done by default.
--Use false when you want to use the existing bounding box and reduce the CPU cost of setting the triangles.
--        baseVertex - Optional vertex offset that is added to all triangle vertex indices.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param triangles int[]
---@param submesh int
function CS.UnityEngine.Mesh.SetTriangles(triangles, submesh) end

--
--Sets the triangle list for the sub-mesh.
--
--```plaintext
--Params: triangles - The list of indices that define the triangles.
--        submesh - The sub-mesh to modify.
--        calculateBounds - Calculate the bounding box of the Mesh after setting the triangles. This is done by default.
--Use false when you want to use the existing bounding box and reduce the CPU cost of setting the triangles.
--        baseVertex - Optional vertex offset that is added to all triangle vertex indices.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param triangles int[]
---@param submesh int
---@param calculateBounds bool
function CS.UnityEngine.Mesh.SetTriangles(triangles, submesh, calculateBounds) end

--
--Sets the triangle list for the sub-mesh.
--
--```plaintext
--Params: triangles - The list of indices that define the triangles.
--        submesh - The sub-mesh to modify.
--        calculateBounds - Calculate the bounding box of the Mesh after setting the triangles. This is done by default.
--Use false when you want to use the existing bounding box and reduce the CPU cost of setting the triangles.
--        baseVertex - Optional vertex offset that is added to all triangle vertex indices.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param triangles int[]
---@param submesh int
---@param calculateBounds bool
---@param baseVertex int
function CS.UnityEngine.Mesh.SetTriangles(triangles, submesh, calculateBounds, baseVertex) end

--
--Sets the triangle list of the Mesh, using a part of the input array.
--
--```plaintext
--Params: triangles - The list of indices that define the triangles.
--        trianglesStart - Index of the first element to take from the input array.
--        trianglesLength - Number of elements to take from the input array.
--        submesh - The sub-mesh to modify.
--        calculateBounds - Calculate the bounding box of the Mesh after setting the triangles. This is done by default.
--Use false when you want to use the existing bounding box and reduce the CPU cost of setting the triangles.
--        baseVertex - Optional vertex offset that is added to all triangle vertex indices.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param triangles int[]
---@param trianglesStart int
---@param trianglesLength int
---@param submesh int
---@param calculateBounds bool
---@param baseVertex int
function CS.UnityEngine.Mesh.SetTriangles(triangles, trianglesStart, trianglesLength, submesh, calculateBounds, baseVertex) end

--
--Sets the triangle list for the sub-mesh.
--
--```plaintext
--Params: triangles - The list of indices that define the triangles.
--        submesh - The sub-mesh to modify.
--        calculateBounds - Calculate the bounding box of the Mesh after setting the triangles. This is done by default.
--Use false when you want to use the existing bounding box and reduce the CPU cost of setting the triangles.
--        baseVertex - Optional vertex offset that is added to all triangle vertex indices.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param triangles ushort[]
---@param submesh int
---@param calculateBounds bool
---@param baseVertex int
function CS.UnityEngine.Mesh.SetTriangles(triangles, submesh, calculateBounds, baseVertex) end

--
--Sets the triangle list of the Mesh, using a part of the input array.
--
--```plaintext
--Params: triangles - The list of indices that define the triangles.
--        trianglesStart - Index of the first element to take from the input array.
--        trianglesLength - Number of elements to take from the input array.
--        submesh - The sub-mesh to modify.
--        calculateBounds - Calculate the bounding box of the Mesh after setting the triangles. This is done by default.
--Use false when you want to use the existing bounding box and reduce the CPU cost of setting the triangles.
--        baseVertex - Optional vertex offset that is added to all triangle vertex indices.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param triangles ushort[]
---@param trianglesStart int
---@param trianglesLength int
---@param submesh int
---@param calculateBounds bool
---@param baseVertex int
function CS.UnityEngine.Mesh.SetTriangles(triangles, trianglesStart, trianglesLength, submesh, calculateBounds, baseVertex) end

---@source UnityEngine.CoreModule.dll
---@param triangles System.Collections.Generic.List<int>
---@param submesh int
function CS.UnityEngine.Mesh.SetTriangles(triangles, submesh) end

---@source UnityEngine.CoreModule.dll
---@param triangles System.Collections.Generic.List<int>
---@param submesh int
---@param calculateBounds bool
function CS.UnityEngine.Mesh.SetTriangles(triangles, submesh, calculateBounds) end

---@source UnityEngine.CoreModule.dll
---@param triangles System.Collections.Generic.List<int>
---@param submesh int
---@param calculateBounds bool
---@param baseVertex int
function CS.UnityEngine.Mesh.SetTriangles(triangles, submesh, calculateBounds, baseVertex) end

---@source UnityEngine.CoreModule.dll
---@param triangles System.Collections.Generic.List<int>
---@param trianglesStart int
---@param trianglesLength int
---@param submesh int
---@param calculateBounds bool
---@param baseVertex int
function CS.UnityEngine.Mesh.SetTriangles(triangles, trianglesStart, trianglesLength, submesh, calculateBounds, baseVertex) end

---@source UnityEngine.CoreModule.dll
---@param triangles System.Collections.Generic.List<ushort>
---@param submesh int
---@param calculateBounds bool
---@param baseVertex int
function CS.UnityEngine.Mesh.SetTriangles(triangles, submesh, calculateBounds, baseVertex) end

---@source UnityEngine.CoreModule.dll
---@param triangles System.Collections.Generic.List<ushort>
---@param trianglesStart int
---@param trianglesLength int
---@param submesh int
---@param calculateBounds bool
---@param baseVertex int
function CS.UnityEngine.Mesh.SetTriangles(triangles, trianglesStart, trianglesLength, submesh, calculateBounds, baseVertex) end

--
--Sets the index buffer for the sub-mesh.
--
--```plaintext
--Params: indices - The array of indices that define the mesh faces.
--        topology - The topology of the Mesh, e.g: Triangles, Lines, Quads, Points, etc. See MeshTopology.
--        submesh - The sub-mesh to modify.
--        calculateBounds - Calculate the bounding box of the Mesh after setting the indices. This is done by default.
--Use false when you want to use the existing bounding box and reduce the CPU cost of setting the indices.
--        baseVertex - Optional vertex offset that is added to all vertex indices.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param indices int[]
---@param topology UnityEngine.MeshTopology
---@param submesh int
function CS.UnityEngine.Mesh.SetIndices(indices, topology, submesh) end

--
--Sets the index buffer for the sub-mesh.
--
--```plaintext
--Params: indices - The array of indices that define the mesh faces.
--        topology - The topology of the Mesh, e.g: Triangles, Lines, Quads, Points, etc. See MeshTopology.
--        submesh - The sub-mesh to modify.
--        calculateBounds - Calculate the bounding box of the Mesh after setting the indices. This is done by default.
--Use false when you want to use the existing bounding box and reduce the CPU cost of setting the indices.
--        baseVertex - Optional vertex offset that is added to all vertex indices.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param indices int[]
---@param topology UnityEngine.MeshTopology
---@param submesh int
---@param calculateBounds bool
function CS.UnityEngine.Mesh.SetIndices(indices, topology, submesh, calculateBounds) end

--
--Sets the index buffer for the sub-mesh.
--
--```plaintext
--Params: indices - The array of indices that define the mesh faces.
--        topology - The topology of the Mesh, e.g: Triangles, Lines, Quads, Points, etc. See MeshTopology.
--        submesh - The sub-mesh to modify.
--        calculateBounds - Calculate the bounding box of the Mesh after setting the indices. This is done by default.
--Use false when you want to use the existing bounding box and reduce the CPU cost of setting the indices.
--        baseVertex - Optional vertex offset that is added to all vertex indices.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param indices int[]
---@param topology UnityEngine.MeshTopology
---@param submesh int
---@param calculateBounds bool
---@param baseVertex int
function CS.UnityEngine.Mesh.SetIndices(indices, topology, submesh, calculateBounds, baseVertex) end

--
--Sets the index buffer of a sub-mesh, using a part of the input array.
--
--```plaintext
--Params: indices - The array of indices that define the mesh faces.
--        indicesStart - Index of the first element to take from the input array.
--        indicesLength - Number of elements to take from the input array.
--        topology - The topology of the Mesh, e.g: Triangles, Lines, Quads, Points, etc. See MeshTopology.
--        submesh - The sub-mesh to modify.
--        calculateBounds - Calculate the bounding box of the Mesh after setting the indices. This is done by default.
--Use false when you want to use the existing bounding box and reduce the CPU cost of setting the indices.
--        baseVertex - Optional vertex offset that is added to all vertex indices.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param indices int[]
---@param indicesStart int
---@param indicesLength int
---@param topology UnityEngine.MeshTopology
---@param submesh int
---@param calculateBounds bool
---@param baseVertex int
function CS.UnityEngine.Mesh.SetIndices(indices, indicesStart, indicesLength, topology, submesh, calculateBounds, baseVertex) end

--
--Sets the index buffer for the sub-mesh.
--
--```plaintext
--Params: indices - The array of indices that define the mesh faces.
--        topology - The topology of the Mesh, e.g: Triangles, Lines, Quads, Points, etc. See MeshTopology.
--        submesh - The sub-mesh to modify.
--        calculateBounds - Calculate the bounding box of the Mesh after setting the indices. This is done by default.
--Use false when you want to use the existing bounding box and reduce the CPU cost of setting the indices.
--        baseVertex - Optional vertex offset that is added to all vertex indices.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param indices ushort[]
---@param topology UnityEngine.MeshTopology
---@param submesh int
---@param calculateBounds bool
---@param baseVertex int
function CS.UnityEngine.Mesh.SetIndices(indices, topology, submesh, calculateBounds, baseVertex) end

--
--Sets the index buffer of a sub-mesh, using a part of the input array.
--
--```plaintext
--Params: indices - The array of indices that define the mesh faces.
--        indicesStart - Index of the first element to take from the input array.
--        indicesLength - Number of elements to take from the input array.
--        topology - The topology of the Mesh, e.g: Triangles, Lines, Quads, Points, etc. See MeshTopology.
--        submesh - The sub-mesh to modify.
--        calculateBounds - Calculate the bounding box of the Mesh after setting the indices. This is done by default.
--Use false when you want to use the existing bounding box and reduce the CPU cost of setting the indices.
--        baseVertex - Optional vertex offset that is added to all vertex indices.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param indices ushort[]
---@param indicesStart int
---@param indicesLength int
---@param topology UnityEngine.MeshTopology
---@param submesh int
---@param calculateBounds bool
---@param baseVertex int
function CS.UnityEngine.Mesh.SetIndices(indices, indicesStart, indicesLength, topology, submesh, calculateBounds, baseVertex) end

---@source UnityEngine.CoreModule.dll
---@param indices Unity.Collections.NativeArray<T>
---@param topology UnityEngine.MeshTopology
---@param submesh int
---@param calculateBounds bool
---@param baseVertex int
function CS.UnityEngine.Mesh.SetIndices(indices, topology, submesh, calculateBounds, baseVertex) end

---@source UnityEngine.CoreModule.dll
---@param indices Unity.Collections.NativeArray<T>
---@param indicesStart int
---@param indicesLength int
---@param topology UnityEngine.MeshTopology
---@param submesh int
---@param calculateBounds bool
---@param baseVertex int
function CS.UnityEngine.Mesh.SetIndices(indices, indicesStart, indicesLength, topology, submesh, calculateBounds, baseVertex) end

---@source UnityEngine.CoreModule.dll
---@param indices System.Collections.Generic.List<int>
---@param topology UnityEngine.MeshTopology
---@param submesh int
---@param calculateBounds bool
---@param baseVertex int
function CS.UnityEngine.Mesh.SetIndices(indices, topology, submesh, calculateBounds, baseVertex) end

---@source UnityEngine.CoreModule.dll
---@param indices System.Collections.Generic.List<int>
---@param indicesStart int
---@param indicesLength int
---@param topology UnityEngine.MeshTopology
---@param submesh int
---@param calculateBounds bool
---@param baseVertex int
function CS.UnityEngine.Mesh.SetIndices(indices, indicesStart, indicesLength, topology, submesh, calculateBounds, baseVertex) end

---@source UnityEngine.CoreModule.dll
---@param indices System.Collections.Generic.List<ushort>
---@param topology UnityEngine.MeshTopology
---@param submesh int
---@param calculateBounds bool
---@param baseVertex int
function CS.UnityEngine.Mesh.SetIndices(indices, topology, submesh, calculateBounds, baseVertex) end

---@source UnityEngine.CoreModule.dll
---@param indices System.Collections.Generic.List<ushort>
---@param indicesStart int
---@param indicesLength int
---@param topology UnityEngine.MeshTopology
---@param submesh int
---@param calculateBounds bool
---@param baseVertex int
function CS.UnityEngine.Mesh.SetIndices(indices, indicesStart, indicesLength, topology, submesh, calculateBounds, baseVertex) end

--
--Sets information defining all sub-meshes in this Mesh, replacing any existing sub-meshes.
--
--```plaintext
--Params: desc - An array or list of sub-mesh data descriptors.
--        start - Index of the first element to take from the array or list in desc.
--        count - Number of elements to take from the array or list in desc.
--        flags - (Optional) Flags controlling the function behavior, see MeshUpdateFlags.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param desc UnityEngine.Rendering.SubMeshDescriptor[]
---@param start int
---@param count int
---@param flags UnityEngine.Rendering.MeshUpdateFlags
function CS.UnityEngine.Mesh.SetSubMeshes(desc, start, count, flags) end

--
--Sets information defining all sub-meshes in this Mesh, replacing any existing sub-meshes.
--
--```plaintext
--Params: desc - An array or list of sub-mesh data descriptors.
--        start - Index of the first element to take from the array or list in desc.
--        count - Number of elements to take from the array or list in desc.
--        flags - (Optional) Flags controlling the function behavior, see MeshUpdateFlags.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param desc UnityEngine.Rendering.SubMeshDescriptor[]
---@param flags UnityEngine.Rendering.MeshUpdateFlags
function CS.UnityEngine.Mesh.SetSubMeshes(desc, flags) end

---@source UnityEngine.CoreModule.dll
---@param desc System.Collections.Generic.List<UnityEngine.Rendering.SubMeshDescriptor>
---@param start int
---@param count int
---@param flags UnityEngine.Rendering.MeshUpdateFlags
function CS.UnityEngine.Mesh.SetSubMeshes(desc, start, count, flags) end

---@source UnityEngine.CoreModule.dll
---@param desc System.Collections.Generic.List<UnityEngine.Rendering.SubMeshDescriptor>
---@param flags UnityEngine.Rendering.MeshUpdateFlags
function CS.UnityEngine.Mesh.SetSubMeshes(desc, flags) end

---@source UnityEngine.CoreModule.dll
---@param desc Unity.Collections.NativeArray<T>
---@param start int
---@param count int
---@param flags UnityEngine.Rendering.MeshUpdateFlags
function CS.UnityEngine.Mesh.SetSubMeshes(desc, start, count, flags) end

---@source UnityEngine.CoreModule.dll
---@param desc Unity.Collections.NativeArray<T>
---@param flags UnityEngine.Rendering.MeshUpdateFlags
function CS.UnityEngine.Mesh.SetSubMeshes(desc, flags) end

---@source UnityEngine.CoreModule.dll
---@param bindposes System.Collections.Generic.List<UnityEngine.Matrix4x4>
function CS.UnityEngine.Mesh.GetBindposes(bindposes) end

---@source UnityEngine.CoreModule.dll
---@param boneWeights System.Collections.Generic.List<UnityEngine.BoneWeight>
function CS.UnityEngine.Mesh.GetBoneWeights(boneWeights) end

--
--Clears all vertex data and all triangle indices.
--
--```plaintext
--Params: keepVertexLayout - True if the existing Mesh data layout should be preserved.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param keepVertexLayout bool
function CS.UnityEngine.Mesh.Clear(keepVertexLayout) end

---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.Mesh.Clear() end

---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.Mesh.RecalculateBounds() end

---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.Mesh.RecalculateNormals() end

---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.Mesh.RecalculateTangents() end

--
--Recalculate the bounding volume of the Mesh from the vertices.
--
--```plaintext
--Params: flags - Flags controlling the function behavior, see MeshUpdateFlags.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param flags UnityEngine.Rendering.MeshUpdateFlags
function CS.UnityEngine.Mesh.RecalculateBounds(flags) end

--
--Recalculates the normals of the Mesh from the triangles and vertices.
--
--```plaintext
--Params: flags - Flags controlling the function behavior, see MeshUpdateFlags.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param flags UnityEngine.Rendering.MeshUpdateFlags
function CS.UnityEngine.Mesh.RecalculateNormals(flags) end

--
--Recalculates the tangents of the Mesh from the normals and texture coordinates.
--
--```plaintext
--Params: flags - Flags controlling the function behavior, see MeshUpdateFlags.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param flags UnityEngine.Rendering.MeshUpdateFlags
function CS.UnityEngine.Mesh.RecalculateTangents(flags) end

--
--Recalculates the UV distribution metric of the Mesh from the vertices and uv coordinates.
--
--```plaintext
--Params: uvSetIndex - The UV set index to set the UV distibution metric for. Use 0 for first index.
--        uvAreaThreshold - The minimum UV area to consider. The default value is 1e-9f.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param uvSetIndex int
---@param uvAreaThreshold float
function CS.UnityEngine.Mesh.RecalculateUVDistributionMetric(uvSetIndex, uvAreaThreshold) end

--
--Recalculates the UV distribution metrics of the Mesh from the vertices and uv coordinates.
--
--```plaintext
--Params: uvAreaThreshold - The minimum UV area to consider. The default value is 1e-9f.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param uvAreaThreshold float
function CS.UnityEngine.Mesh.RecalculateUVDistributionMetrics(uvAreaThreshold) end

--
--Optimize mesh for frequent updates.
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.Mesh.MarkDynamic() end

--
--Upload previously done Mesh modifications to the graphics API.
--
--```plaintext
--Params: markNoLongerReadable - Frees up system memory copy of mesh data when set to true.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param markNoLongerReadable bool
function CS.UnityEngine.Mesh.UploadMeshData(markNoLongerReadable) end

--
--Optimizes the Mesh data to improve rendering performance.
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.Mesh.Optimize() end

--
--Optimizes the geometry of the Mesh to improve rendering performance.
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.Mesh.OptimizeIndexBuffers() end

--
--Optimizes the vertices of the Mesh to improve rendering performance.
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.Mesh.OptimizeReorderVertexBuffer() end

--
--Gets the topology of a sub-mesh.
--
---@source UnityEngine.CoreModule.dll
---@param submesh int
---@return MeshTopology
function CS.UnityEngine.Mesh.GetTopology(submesh) end

--
--Combines several Meshes into this Mesh.
--
--```plaintext
--Params: combine - Descriptions of the Meshes to combine.
--        mergeSubMeshes - Defines whether Meshes should be combined into a single sub-mesh.
--        useMatrices - Defines whether the transforms supplied in the CombineInstance array should be used or ignored.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param combine UnityEngine.CombineInstance[]
---@param mergeSubMeshes bool
---@param useMatrices bool
---@param hasLightmapData bool
function CS.UnityEngine.Mesh.CombineMeshes(combine, mergeSubMeshes, useMatrices, hasLightmapData) end

--
--Combines several Meshes into this Mesh.
--
--```plaintext
--Params: combine - Descriptions of the Meshes to combine.
--        mergeSubMeshes - Defines whether Meshes should be combined into a single sub-mesh.
--        useMatrices - Defines whether the transforms supplied in the CombineInstance array should be used or ignored.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param combine UnityEngine.CombineInstance[]
---@param mergeSubMeshes bool
---@param useMatrices bool
function CS.UnityEngine.Mesh.CombineMeshes(combine, mergeSubMeshes, useMatrices) end

--
--Combines several Meshes into this Mesh.
--
--```plaintext
--Params: combine - Descriptions of the Meshes to combine.
--        mergeSubMeshes - Defines whether Meshes should be combined into a single sub-mesh.
--        useMatrices - Defines whether the transforms supplied in the CombineInstance array should be used or ignored.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param combine UnityEngine.CombineInstance[]
---@param mergeSubMeshes bool
function CS.UnityEngine.Mesh.CombineMeshes(combine, mergeSubMeshes) end

--
--Combines several Meshes into this Mesh.
--
--```plaintext
--Params: combine - Descriptions of the Meshes to combine.
--        mergeSubMeshes - Defines whether Meshes should be combined into a single sub-mesh.
--        useMatrices - Defines whether the transforms supplied in the CombineInstance array should be used or ignored.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param combine UnityEngine.CombineInstance[]
function CS.UnityEngine.Mesh.CombineMeshes(combine) end


--
--Struct describing the result of a Global Illumination bake for a given light.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.LightBakingOutput: System.ValueType
--
--In case of a LightmapBakeType.Mixed light, contains the index of the light as seen from the occlusion probes point of view if any, otherwise -1.
--
---@source UnityEngine.CoreModule.dll
---@field probeOcclusionLightIndex int
--
--In case of a LightmapBakeType.Mixed light, contains the index of the occlusion mask channel to use if any, otherwise -1.
--
---@source UnityEngine.CoreModule.dll
---@field occlusionMaskChannel int
--
--This property describes what part of a light's contribution was baked.
--
---@source UnityEngine.CoreModule.dll
---@field lightmapBakeType UnityEngine.LightmapBakeType
--
--In case of a LightmapBakeType.Mixed light, describes what Mixed mode was used to bake the light, irrelevant otherwise.
--
---@source UnityEngine.CoreModule.dll
---@field mixedLightingMode UnityEngine.MixedLightingMode
--
--Is the light contribution already stored in lightmaps and/or lightprobes?
--
---@source UnityEngine.CoreModule.dll
---@field isBaked bool
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.LightBakingOutput = {}


--
--Allows mixed lights to control shadow caster culling when Shadowmasks are present.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.LightShadowCasterMode: System.Enum
--
--Use the global Shadowmask Mode from the quality settings.
--
---@source UnityEngine.CoreModule.dll
---@field Default UnityEngine.LightShadowCasterMode
--
--Render only non-lightmapped objects into the shadow map. This corresponds with the Shadowmask mode.
--
---@source UnityEngine.CoreModule.dll
---@field NonLightmappedOnly UnityEngine.LightShadowCasterMode
--
--Render all shadow casters into the shadow map. This corresponds with the distance Shadowmask mode.
--
---@source UnityEngine.CoreModule.dll
---@field Everything UnityEngine.LightShadowCasterMode
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.LightShadowCasterMode = {}

---@source 
---@param value any
---@return UnityEngine.LightShadowCasterMode
function CS.UnityEngine.LightShadowCasterMode:__CastFrom(value) end


--
--Script interface for.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.Light: UnityEngine.Behaviour
--
--The type of the light.
--
---@source UnityEngine.CoreModule.dll
---@field type UnityEngine.LightType
--
--This property describes the shape of the spot light. Only Scriptable Render Pipelines use this property; the built-in renderer does not support it.
--
---@source UnityEngine.CoreModule.dll
---@field shape UnityEngine.LightShape
--
--The angle of the light's spotlight cone in degrees.
--
---@source UnityEngine.CoreModule.dll
---@field spotAngle float
--
--The angle of the light's spotlight inner cone in degrees.
--
---@source UnityEngine.CoreModule.dll
---@field innerSpotAngle float
--
--The color of the light.
--
---@source UnityEngine.CoreModule.dll
---@field color UnityEngine.Color
--
--The color temperature of the light.
--          Correlated Color Temperature (abbreviated as CCT) is multiplied with the color filter when calculating the final color of a light source. The color temperature of the electromagnetic radiation emitted from an ideal black body is defined as its surface temperature in Kelvin. White is 6500K according to the D65 standard. A candle light is 1800K and a soft warm light bulb is 2700K.
--          If you want to use colorTemperature, GraphicsSettings.lightsUseLinearIntensity and Light.useColorTemperature has to be enabled.
--          See Also: GraphicsSettings.lightsUseLinearIntensity, GraphicsSettings.useColorTemperature.
--
---@source UnityEngine.CoreModule.dll
---@field colorTemperature float
--
--Set to true to use the color temperature.
--
---@source UnityEngine.CoreModule.dll
---@field useColorTemperature bool
--
--The Intensity of a light is multiplied with the Light color.
--
---@source UnityEngine.CoreModule.dll
---@field intensity float
--
--The multiplier that defines the strength of the bounce lighting.
--
---@source UnityEngine.CoreModule.dll
---@field bounceIntensity float
--
--Set to true to override light bounding sphere for culling.
--
---@source UnityEngine.CoreModule.dll
---@field useBoundingSphereOverride bool
--
--Bounding sphere used to override the regular light bounding sphere during culling.
--
---@source UnityEngine.CoreModule.dll
---@field boundingSphereOverride UnityEngine.Vector4
--
--Whether to cull shadows for this Light when the Light is outside of the view frustum.
--
---@source UnityEngine.CoreModule.dll
---@field useViewFrustumForShadowCasterCull bool
--
--The custom resolution of the shadow map.
--
---@source UnityEngine.CoreModule.dll
---@field shadowCustomResolution int
--
--Shadow mapping constant bias.
--
---@source UnityEngine.CoreModule.dll
---@field shadowBias float
--
--Shadow mapping normal-based bias.
--
---@source UnityEngine.CoreModule.dll
---@field shadowNormalBias float
--
--Near plane value to use for shadow frustums.
--
---@source UnityEngine.CoreModule.dll
---@field shadowNearPlane float
--
--Set to true to enable custom matrix for culling during shadows.
--
---@source UnityEngine.CoreModule.dll
---@field useShadowMatrixOverride bool
--
--Projection matrix used to override the regular light matrix during shadow culling.
--
---@source UnityEngine.CoreModule.dll
---@field shadowMatrixOverride UnityEngine.Matrix4x4
--
--The range of the light.
--
---@source UnityEngine.CoreModule.dll
---@field range float
--
--The to use for this light.
--
---@source UnityEngine.CoreModule.dll
---@field flare UnityEngine.Flare
--
--This property describes the output of the last Global Illumination bake.
--
---@source UnityEngine.CoreModule.dll
---@field bakingOutput UnityEngine.LightBakingOutput
--
--This is used to light certain objects in the Scene selectively.
--
---@source UnityEngine.CoreModule.dll
---@field cullingMask int
--
--Determines which rendering LayerMask this Light affects.
--
---@source UnityEngine.CoreModule.dll
---@field renderingLayerMask int
--
--Allows you to override the global Shadowmask Mode per light. Only use this with render pipelines that can handle per light Shadowmask modes. Incompatible with the legacy renderers.
--
---@source UnityEngine.CoreModule.dll
---@field lightShadowCasterMode UnityEngine.LightShadowCasterMode
--
--Controls the amount of artificial softening applied to the edges of shadows cast by the Point or Spot light.
--
---@source UnityEngine.CoreModule.dll
---@field shadowRadius float
--
--Controls the amount of artificial softening applied to the edges of shadows cast by directional lights.
--
---@source UnityEngine.CoreModule.dll
---@field shadowAngle float
--
--How this light casts shadows
--
---@source UnityEngine.CoreModule.dll
---@field shadows UnityEngine.LightShadows
--
--Strength of light's shadows.
--
---@source UnityEngine.CoreModule.dll
---@field shadowStrength float
--
--The resolution of the shadow map.
--
---@source UnityEngine.CoreModule.dll
---@field shadowResolution UnityEngine.Rendering.LightShadowResolution
---@source UnityEngine.CoreModule.dll
---@field shadowSoftness float
---@source UnityEngine.CoreModule.dll
---@field shadowSoftnessFade float
--
--Per-light, per-layer shadow culling distances. Directional lights only.
--
---@source UnityEngine.CoreModule.dll
---@field layerShadowCullDistances float[]
--
--The size of a directional light's cookie.
--
---@source UnityEngine.CoreModule.dll
---@field cookieSize float
--
--The cookie texture projected by the light.
--
---@source UnityEngine.CoreModule.dll
---@field cookie UnityEngine.Texture
--
--How to render the light.
--
---@source UnityEngine.CoreModule.dll
---@field renderMode UnityEngine.LightRenderMode
---@source UnityEngine.CoreModule.dll
---@field bakedIndex int
--
--The size of the area light (Editor only).
--
---@source UnityEngine.CoreModule.dll
---@field areaSize UnityEngine.Vector2
--
--This property describes what part of a light's contribution can be baked (Editor only).
--
---@source UnityEngine.CoreModule.dll
---@field lightmapBakeType UnityEngine.LightmapBakeType
--
--Number of command buffers set up on this light (Read Only).
--
---@source UnityEngine.CoreModule.dll
---@field commandBufferCount int
---@source UnityEngine.CoreModule.dll
---@field pixelLightCount int
---@source UnityEngine.CoreModule.dll
---@field shadowConstantBias float
---@source UnityEngine.CoreModule.dll
---@field shadowObjectSizeBias float
---@source UnityEngine.CoreModule.dll
---@field attenuate bool
---@source UnityEngine.CoreModule.dll
---@field lightmappingMode UnityEngine.LightmappingMode
--
--Is the light contribution already stored in lightmaps and/or lightprobes (Read Only). Obsolete; replaced by Light-lightmapBakeType.
--
---@source UnityEngine.CoreModule.dll
---@field isBaked bool
---@source UnityEngine.CoreModule.dll
---@field alreadyLightmapped bool
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.Light = {}

--
--Revert all light parameters to default.
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.Light.Reset() end

--
--Sets a light dirty to notify the light baking backends to update their internal light representation (Editor only).
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.Light.SetLightDirty() end

--
--Add a command buffer to be executed at a specified place.
--
--```plaintext
--Params: evt - When to execute the command buffer during rendering.
--        buffer - The buffer to execute.
--        shadowPassMask - A mask specifying which shadow passes to execute the buffer for.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param evt UnityEngine.Rendering.LightEvent
---@param buffer UnityEngine.Rendering.CommandBuffer
function CS.UnityEngine.Light.AddCommandBuffer(evt, buffer) end

--
--Add a command buffer to be executed at a specified place.
--
--```plaintext
--Params: evt - When to execute the command buffer during rendering.
--        buffer - The buffer to execute.
--        shadowPassMask - A mask specifying which shadow passes to execute the buffer for.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param evt UnityEngine.Rendering.LightEvent
---@param buffer UnityEngine.Rendering.CommandBuffer
---@param shadowPassMask UnityEngine.Rendering.ShadowMapPass
function CS.UnityEngine.Light.AddCommandBuffer(evt, buffer, shadowPassMask) end

--
--Adds a command buffer to the GPU's async compute queues and executes that command buffer when graphics processing reaches a given point.
--
--```plaintext
--Params: evt - The point during the graphics processing at which this command buffer should commence on the GPU.
--        buffer - The buffer to execute.
--        queueType - The desired async compute queue type to execute the buffer on.
--        shadowPassMask - A mask specifying which shadow passes to execute the buffer for.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param evt UnityEngine.Rendering.LightEvent
---@param buffer UnityEngine.Rendering.CommandBuffer
---@param queueType UnityEngine.Rendering.ComputeQueueType
function CS.UnityEngine.Light.AddCommandBufferAsync(evt, buffer, queueType) end

--
--Adds a command buffer to the GPU's async compute queues and executes that command buffer when graphics processing reaches a given point.
--
--```plaintext
--Params: evt - The point during the graphics processing at which this command buffer should commence on the GPU.
--        buffer - The buffer to execute.
--        queueType - The desired async compute queue type to execute the buffer on.
--        shadowPassMask - A mask specifying which shadow passes to execute the buffer for.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param evt UnityEngine.Rendering.LightEvent
---@param buffer UnityEngine.Rendering.CommandBuffer
---@param shadowPassMask UnityEngine.Rendering.ShadowMapPass
---@param queueType UnityEngine.Rendering.ComputeQueueType
function CS.UnityEngine.Light.AddCommandBufferAsync(evt, buffer, shadowPassMask, queueType) end

--
--Remove command buffer from execution at a specified place.
--
--```plaintext
--Params: evt - When to execute the command buffer during rendering.
--        buffer - The buffer to execute.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param evt UnityEngine.Rendering.LightEvent
---@param buffer UnityEngine.Rendering.CommandBuffer
function CS.UnityEngine.Light.RemoveCommandBuffer(evt, buffer) end

--
--Remove command buffers from execution at a specified place.
--
--```plaintext
--Params: evt - When to execute the command buffer during rendering.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param evt UnityEngine.Rendering.LightEvent
function CS.UnityEngine.Light.RemoveCommandBuffers(evt) end

--
--Remove all command buffers set on this light.
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.Light.RemoveAllCommandBuffers() end

--
--Array of command buffers.
--
--```plaintext
--Params: evt - When to execute the command buffer during rendering.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param evt UnityEngine.Rendering.LightEvent
function CS.UnityEngine.Light.GetCommandBuffers(evt) end

---@source UnityEngine.CoreModule.dll
---@param type UnityEngine.LightType
---@param layer int
function CS.UnityEngine.Light:GetLights(type, layer) end


--
--A script interface for the.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.Skybox: UnityEngine.Behaviour
--
--The material used by the skybox.
--
---@source UnityEngine.CoreModule.dll
---@field material UnityEngine.Material
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.Skybox = {}


--
--A class to access the Mesh of the.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.MeshFilter: UnityEngine.Component
--
--Returns the shared mesh of the mesh filter.
--
---@source UnityEngine.CoreModule.dll
---@field sharedMesh UnityEngine.Mesh
--
--Returns the instantiated Mesh assigned to the mesh filter.
--
---@source UnityEngine.CoreModule.dll
---@field mesh UnityEngine.Mesh
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.MeshFilter = {}


--
--Rendering path of a Camera.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.RenderingPath: System.Enum
--
--Use Player Settings.
--
---@source UnityEngine.CoreModule.dll
---@field UsePlayerSettings UnityEngine.RenderingPath
--
--Vertex Lit.
--
---@source UnityEngine.CoreModule.dll
---@field VertexLit UnityEngine.RenderingPath
--
--Forward Rendering.
--
---@source UnityEngine.CoreModule.dll
---@field Forward UnityEngine.RenderingPath
--
--Deferred Lighting (Legacy).
--
---@source UnityEngine.CoreModule.dll
---@field DeferredLighting UnityEngine.RenderingPath
--
--Deferred Shading.
--
---@source UnityEngine.CoreModule.dll
---@field DeferredShading UnityEngine.RenderingPath
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.RenderingPath = {}

---@source 
---@param value any
---@return UnityEngine.RenderingPath
function CS.UnityEngine.RenderingPath:__CastFrom(value) end


--
--Transparent object sorting mode of a Camera.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.TransparencySortMode: System.Enum
--
--Default transparency sorting mode.
--
---@source UnityEngine.CoreModule.dll
---@field Default UnityEngine.TransparencySortMode
--
--Perspective transparency sorting mode.
--
---@source UnityEngine.CoreModule.dll
---@field Perspective UnityEngine.TransparencySortMode
--
--Orthographic transparency sorting mode.
--
---@source UnityEngine.CoreModule.dll
---@field Orthographic UnityEngine.TransparencySortMode
--
--Sort objects based on distance along a custom axis.
--
---@source UnityEngine.CoreModule.dll
---@field CustomAxis UnityEngine.TransparencySortMode
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.TransparencySortMode = {}

---@source 
---@param value any
---@return UnityEngine.TransparencySortMode
function CS.UnityEngine.TransparencySortMode:__CastFrom(value) end


--
--A struct containing Mesh data for C# Job System access.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.MeshData: System.ValueType
--
--Gets the number of vertices in the MeshData. (Read Only)
--
---@source UnityEngine.CoreModule.dll
---@field vertexCount int
--
--Gets the number of vertex buffers in the MeshData. (Read Only)
--
---@source UnityEngine.CoreModule.dll
---@field vertexBufferCount int
--
--Gets the format of the index buffer data in the MeshData. (Read Only)
--
---@source UnityEngine.CoreModule.dll
---@field indexFormat UnityEngine.Rendering.IndexFormat
--
--The number of sub-meshes in the MeshData.
--
---@source UnityEngine.CoreModule.dll
---@field subMeshCount int
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.MeshData = {}

--
--Returns true if the data attribute is present in the Mesh. Returns false if it is not.
--
--```plaintext
--Params: attr - The vertex attribute to check for.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param attr UnityEngine.Rendering.VertexAttribute
---@return Boolean
function CS.UnityEngine.MeshData.HasVertexAttribute(attr) end

--
--Returns the dimension of the vertex attribute. Returns 0 if the vertex attribute is not present.
--
--```plaintext
--Params: attr - The vertex attribute to get the dimension of.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param attr UnityEngine.Rendering.VertexAttribute
---@return Int32
function CS.UnityEngine.MeshData.GetVertexAttributeDimension(attr) end

--
--Returns the format of the given vertex attribute.
--
--```plaintext
--Params: attr - The vertex attribute to check the format of.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param attr UnityEngine.Rendering.VertexAttribute
---@return VertexAttributeFormat
function CS.UnityEngine.MeshData.GetVertexAttributeFormat(attr) end

---@source UnityEngine.CoreModule.dll
---@param outVertices Unity.Collections.NativeArray<UnityEngine.Vector3>
function CS.UnityEngine.MeshData.GetVertices(outVertices) end

---@source UnityEngine.CoreModule.dll
---@param outNormals Unity.Collections.NativeArray<UnityEngine.Vector3>
function CS.UnityEngine.MeshData.GetNormals(outNormals) end

---@source UnityEngine.CoreModule.dll
---@param outTangents Unity.Collections.NativeArray<UnityEngine.Vector4>
function CS.UnityEngine.MeshData.GetTangents(outTangents) end

---@source UnityEngine.CoreModule.dll
---@param outColors Unity.Collections.NativeArray<UnityEngine.Color>
function CS.UnityEngine.MeshData.GetColors(outColors) end

---@source UnityEngine.CoreModule.dll
---@param outColors Unity.Collections.NativeArray<UnityEngine.Color32>
function CS.UnityEngine.MeshData.GetColors(outColors) end

---@source UnityEngine.CoreModule.dll
---@param channel int
---@param outUVs Unity.Collections.NativeArray<UnityEngine.Vector2>
function CS.UnityEngine.MeshData.GetUVs(channel, outUVs) end

---@source UnityEngine.CoreModule.dll
---@param channel int
---@param outUVs Unity.Collections.NativeArray<UnityEngine.Vector3>
function CS.UnityEngine.MeshData.GetUVs(channel, outUVs) end

---@source UnityEngine.CoreModule.dll
---@param channel int
---@param outUVs Unity.Collections.NativeArray<UnityEngine.Vector4>
function CS.UnityEngine.MeshData.GetUVs(channel, outUVs) end

---@source UnityEngine.CoreModule.dll
---@param stream int
---@return NativeArray
function CS.UnityEngine.MeshData.GetVertexData(stream) end

--
--Sets the vertex buffer size and layout of the Mesh that Unity creates from the MeshData.
--
--```plaintext
--Params: vertexCount - The number of vertices in the Mesh.
--        attributes - Layout of the vertex data: which attributes are present, their data types and so on.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param vertexCount int
---@param attributes UnityEngine.Rendering.VertexAttributeDescriptor[]
function CS.UnityEngine.MeshData.SetVertexBufferParams(vertexCount, attributes) end

---@source UnityEngine.CoreModule.dll
---@param vertexCount int
---@param attributes Unity.Collections.NativeArray<UnityEngine.Rendering.VertexAttributeDescriptor>
function CS.UnityEngine.MeshData.SetVertexBufferParams(vertexCount, attributes) end

--
--Sets the index buffer size and format of the Mesh that Unity creates from the MeshData.
--
--```plaintext
--Params: indexCount - The size of the index buffer.
--        format - The format of the indices.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param indexCount int
---@param format UnityEngine.Rendering.IndexFormat
function CS.UnityEngine.MeshData.SetIndexBufferParams(indexCount, format) end

---@source UnityEngine.CoreModule.dll
---@param outIndices Unity.Collections.NativeArray<ushort>
---@param submesh int
---@param applyBaseVertex bool
function CS.UnityEngine.MeshData.GetIndices(outIndices, submesh, applyBaseVertex) end

---@source UnityEngine.CoreModule.dll
---@param outIndices Unity.Collections.NativeArray<int>
---@param submesh int
---@param applyBaseVertex bool
function CS.UnityEngine.MeshData.GetIndices(outIndices, submesh, applyBaseVertex) end

---@source UnityEngine.CoreModule.dll
---@return NativeArray
function CS.UnityEngine.MeshData.GetIndexData() end

--
--Returns sub-mesh data.
--
--```plaintext
--Params: index - The index of the sub-mesh. See Mesh.MeshData.subMeshCount|subMeshCount. If you specify an out of range index, Unity throws an exception.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param index int
---@return SubMeshDescriptor
function CS.UnityEngine.MeshData.GetSubMesh(index) end

--
--Sets the data for a sub-mesh of the Mesh that Unity creates from the MeshData.
--
--```plaintext
--Params: index - The index of the sub-mesh to set data for. See Mesh.MeshData.subMeshCount|subMeshCount. If you specify an out of range index, Unity throws an exception.
--        desc - Sub-mesh data.
--        flags - Flags controlling the function behavior. See MeshUpdateFlags.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param index int
---@param desc UnityEngine.Rendering.SubMeshDescriptor
---@param flags UnityEngine.Rendering.MeshUpdateFlags
function CS.UnityEngine.MeshData.SetSubMesh(index, desc, flags) end


--
--An array of Mesh data snapshots for C# Job System access.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.MeshDataArray: System.ValueType
--
--Number of Mesh data elements in the MeshDataArray.
--
---@source UnityEngine.CoreModule.dll
---@field Length int
---@source UnityEngine.CoreModule.dll
---@field this[] UnityEngine.Mesh.MeshData
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.MeshDataArray = {}

--
--Use this method to dispose of the MeshDataArray struct.
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.MeshDataArray.Dispose() end


--
--General functionality for all renderers.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.Renderer: UnityEngine.Component
---@source UnityEngine.CoreModule.dll
---@field lightmapTilingOffset UnityEngine.Vector4
---@source UnityEngine.CoreModule.dll
---@field lightProbeAnchor UnityEngine.Transform
---@source UnityEngine.CoreModule.dll
---@field castShadows bool
--
--Specifies whether this renderer has a per-object motion vector pass.
--
---@source UnityEngine.CoreModule.dll
---@field motionVectors bool
--
--Should light probes be used for this Renderer?
--
---@source UnityEngine.CoreModule.dll
---@field useLightProbes bool
--
--The bounding volume of the renderer (Read Only).
--
---@source UnityEngine.CoreModule.dll
---@field bounds UnityEngine.Bounds
--
--Makes the rendered 3D object visible if enabled.
--
---@source UnityEngine.CoreModule.dll
---@field enabled bool
--
--Is this renderer visible in any camera? (Read Only)
--
---@source UnityEngine.CoreModule.dll
---@field isVisible bool
--
--Does this object cast shadows?
--
---@source UnityEngine.CoreModule.dll
---@field shadowCastingMode UnityEngine.Rendering.ShadowCastingMode
--
--Does this object receive shadows?
--
---@source UnityEngine.CoreModule.dll
---@field receiveShadows bool
--
--Allows turning off rendering for a specific component.
--
---@source UnityEngine.CoreModule.dll
---@field forceRenderingOff bool
--
--Specifies the mode for motion vector rendering.
--
---@source UnityEngine.CoreModule.dll
---@field motionVectorGenerationMode UnityEngine.MotionVectorGenerationMode
--
--The light probe interpolation type.
--
---@source UnityEngine.CoreModule.dll
---@field lightProbeUsage UnityEngine.Rendering.LightProbeUsage
--
--Should reflection probes be used for this Renderer?
--
---@source UnityEngine.CoreModule.dll
---@field reflectionProbeUsage UnityEngine.Rendering.ReflectionProbeUsage
--
--Determines which rendering layer this renderer lives on.
--
---@source UnityEngine.CoreModule.dll
---@field renderingLayerMask uint
--
--This value sorts renderers by priority. Lower values are rendered first and higher values are rendered last.
--
---@source UnityEngine.CoreModule.dll
---@field rendererPriority int
--
--Describes how this renderer is updated for ray tracing.
--
---@source UnityEngine.CoreModule.dll
---@field rayTracingMode UnityEngine.Experimental.Rendering.RayTracingMode
--
--Name of the Renderer's sorting layer.
--
---@source UnityEngine.CoreModule.dll
---@field sortingLayerName string
--
--Unique ID of the Renderer's sorting layer.
--
---@source UnityEngine.CoreModule.dll
---@field sortingLayerID int
--
--Renderer's order within a sorting layer.
--
---@source UnityEngine.CoreModule.dll
---@field sortingOrder int
--
--Controls if dynamic occlusion culling should be performed for this renderer.
--
---@source UnityEngine.CoreModule.dll
---@field allowOcclusionWhenDynamic bool
--
--Indicates whether the renderer is part of a with other renderers.
--
---@source UnityEngine.CoreModule.dll
---@field isPartOfStaticBatch bool
--
--Matrix that transforms a point from world space into local space (Read Only).
--
---@source UnityEngine.CoreModule.dll
---@field worldToLocalMatrix UnityEngine.Matrix4x4
--
--Matrix that transforms a point from local space into world space (Read Only).
--
---@source UnityEngine.CoreModule.dll
---@field localToWorldMatrix UnityEngine.Matrix4x4
--
--If set, the Renderer will use the Light Probe Proxy Volume component attached to the source GameObject.
--
---@source UnityEngine.CoreModule.dll
---@field lightProbeProxyVolumeOverride UnityEngine.GameObject
--
--If set, Renderer will use this Transform's position to find the light or reflection probe.
--
---@source UnityEngine.CoreModule.dll
---@field probeAnchor UnityEngine.Transform
--
--The index of the baked lightmap applied to this renderer.
--
---@source UnityEngine.CoreModule.dll
---@field lightmapIndex int
--
--The index of the realtime lightmap applied to this renderer.
--
---@source UnityEngine.CoreModule.dll
---@field realtimeLightmapIndex int
--
--The UV scale & offset used for a lightmap.
--
---@source UnityEngine.CoreModule.dll
---@field lightmapScaleOffset UnityEngine.Vector4
--
--The UV scale & offset used for a realtime lightmap.
--
---@source UnityEngine.CoreModule.dll
---@field realtimeLightmapScaleOffset UnityEngine.Vector4
--
--Returns all the instantiated materials of this object.
--
---@source UnityEngine.CoreModule.dll
---@field materials UnityEngine.Material[]
--
--Returns the first instantiated Material assigned to the renderer.
--
---@source UnityEngine.CoreModule.dll
---@field material UnityEngine.Material
--
--The shared material of this object.
--
---@source UnityEngine.CoreModule.dll
---@field sharedMaterial UnityEngine.Material
--
--All the shared materials of this object.
--
---@source UnityEngine.CoreModule.dll
---@field sharedMaterials UnityEngine.Material[]
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.Renderer = {}

--
--Returns true if the Renderer has a material property block attached via SetPropertyBlock.
--
---@source UnityEngine.CoreModule.dll
---@return Boolean
function CS.UnityEngine.Renderer.HasPropertyBlock() end

--
--Lets you set or clear per-renderer or per-material parameter overrides.
--
--```plaintext
--Params: properties - Property block with values you want to override.
--        materialIndex - The index of the Material you want to override the parameters of. The index ranges from 0 to Renderer.sharedMaterial.Length-1.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param properties UnityEngine.MaterialPropertyBlock
function CS.UnityEngine.Renderer.SetPropertyBlock(properties) end

--
--Lets you set or clear per-renderer or per-material parameter overrides.
--
--```plaintext
--Params: properties - Property block with values you want to override.
--        materialIndex - The index of the Material you want to override the parameters of. The index ranges from 0 to Renderer.sharedMaterial.Length-1.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param properties UnityEngine.MaterialPropertyBlock
---@param materialIndex int
function CS.UnityEngine.Renderer.SetPropertyBlock(properties, materialIndex) end

--
--Get per-Renderer or per-Material property block.
--
--```plaintext
--Params: properties - Material parameters to retrieve.
--        materialIndex - The index of the Material you want to get overridden parameters from. The index ranges from 0 to Renderer.sharedMaterials.Length-1.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param properties UnityEngine.MaterialPropertyBlock
function CS.UnityEngine.Renderer.GetPropertyBlock(properties) end

--
--Get per-Renderer or per-Material property block.
--
--```plaintext
--Params: properties - Material parameters to retrieve.
--        materialIndex - The index of the Material you want to get overridden parameters from. The index ranges from 0 to Renderer.sharedMaterials.Length-1.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param properties UnityEngine.MaterialPropertyBlock
---@param materialIndex int
function CS.UnityEngine.Renderer.GetPropertyBlock(properties, materialIndex) end

---@source UnityEngine.CoreModule.dll
---@param m System.Collections.Generic.List<UnityEngine.Material>
function CS.UnityEngine.Renderer.GetMaterials(m) end

---@source UnityEngine.CoreModule.dll
---@param m System.Collections.Generic.List<UnityEngine.Material>
function CS.UnityEngine.Renderer.GetSharedMaterials(m) end

---@source UnityEngine.CoreModule.dll
---@param result System.Collections.Generic.List<UnityEngine.Rendering.ReflectionProbeBlendInfo>
function CS.UnityEngine.Renderer.GetClosestReflectionProbes(result) end


--
--A script interface for a.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.Projector: UnityEngine.Behaviour
---@source UnityEngine.CoreModule.dll
---@field isOrthoGraphic bool
---@source UnityEngine.CoreModule.dll
---@field orthoGraphicSize float
--
--The near clipping plane distance.
--
---@source UnityEngine.CoreModule.dll
---@field nearClipPlane float
--
--The far clipping plane distance.
--
---@source UnityEngine.CoreModule.dll
---@field farClipPlane float
--
--The field of view of the projection in degrees.
--
---@source UnityEngine.CoreModule.dll
---@field fieldOfView float
--
--The aspect ratio of the projection.
--
---@source UnityEngine.CoreModule.dll
---@field aspectRatio float
--
--Is the projection orthographic (true) or perspective (false)?
--
---@source UnityEngine.CoreModule.dll
---@field orthographic bool
--
--Projection's half-size when in orthographic mode.
--
---@source UnityEngine.CoreModule.dll
---@field orthographicSize float
--
--Which object layers are ignored by the projector.
--
---@source UnityEngine.CoreModule.dll
---@field ignoreLayers int
--
--The material that will be projected onto every object.
--
---@source UnityEngine.CoreModule.dll
---@field material UnityEngine.Material
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.Projector = {}


--
--Shader scripts used for all rendering.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.Shader: UnityEngine.Object
--
--Shader hardware tier classification for current device.
--
---@source UnityEngine.CoreModule.dll
---@field globalShaderHardwareTier UnityEngine.Rendering.ShaderHardwareTier
--
--Shader LOD level for this shader.
--
---@source UnityEngine.CoreModule.dll
---@field maximumLOD int
--
--Shader LOD level for all shaders.
--
---@source UnityEngine.CoreModule.dll
---@field globalMaximumLOD int
--
--Can this shader run on the end-users graphics card? (Read Only)
--
---@source UnityEngine.CoreModule.dll
---@field isSupported bool
--
--Render pipeline currently in use.
--
---@source UnityEngine.CoreModule.dll
---@field globalRenderPipeline string
--
--Render queue of this shader. (Read Only)
--
---@source UnityEngine.CoreModule.dll
---@field renderQueue int
--
--Returns the number of shader passes on the active SubShader.
--
---@source UnityEngine.CoreModule.dll
---@field passCount int
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.Shader = {}

---@source UnityEngine.CoreModule.dll
---@param propertyName string
---@param mode UnityEngine.TexGenMode
function CS.UnityEngine.Shader:SetGlobalTexGenMode(propertyName, mode) end

---@source UnityEngine.CoreModule.dll
---@param propertyName string
---@param matrixName string
function CS.UnityEngine.Shader:SetGlobalTextureMatrixName(propertyName, matrixName) end

--
--Finds a shader with the given name.
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@return Shader
function CS.UnityEngine.Shader:Find(name) end

--
--Enables a global shader keyword.
--
--```plaintext
--Params: keyword - The name of the local shader keyword to enable.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param keyword string
function CS.UnityEngine.Shader:EnableKeyword(keyword) end

--
--Disables a global shader keyword.
--
--```plaintext
--Params: keyword - The name of the local shader keyword to disable.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param keyword string
function CS.UnityEngine.Shader:DisableKeyword(keyword) end

--
--Returns true if the given global shader keyword is enabled. Otherwise, returns false.
--
--```plaintext
--Params: keyword - The name of the global shader keyword to check.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param keyword string
---@return Boolean
function CS.UnityEngine.Shader:IsKeywordEnabled(keyword) end

--
--Prewarms all shader variants of all Shaders currently in memory.
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.Shader:WarmupAllShaders() end

--
--Unique integer for the name.
--
--```plaintext
--Params: name - Shader property name.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@return Int32
function CS.UnityEngine.Shader:PropertyToID(name) end

--
--Returns the dependency shader.
--
--```plaintext
--Params: name - The name of the dependency to query.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@return Shader
function CS.UnityEngine.Shader.GetDependency(name) end

--
--Search for the pass tag specified by tagName on the shader's active SubShader and returns the value of the tag.
--
--```plaintext
--Params: passIndex - The index of the pass.
--        tagName - The name of the pass tag.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param passIndex int
---@param tagName UnityEngine.Rendering.ShaderTagId
---@return ShaderTagId
function CS.UnityEngine.Shader.FindPassTagValue(passIndex, tagName) end

--
--Sets a global float property for all shaders.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@param value float
function CS.UnityEngine.Shader:SetGlobalFloat(name, value) end

--
--Sets a global float property for all shaders.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
---@param value float
function CS.UnityEngine.Shader:SetGlobalFloat(nameID, value) end

--
--Sets a global int property for all shaders.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@param value int
function CS.UnityEngine.Shader:SetGlobalInt(name, value) end

--
--Sets a global int property for all shaders.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
---@param value int
function CS.UnityEngine.Shader:SetGlobalInt(nameID, value) end

--
--Sets a global vector property for all shaders.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@param value UnityEngine.Vector4
function CS.UnityEngine.Shader:SetGlobalVector(name, value) end

--
--Sets a global vector property for all shaders.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
---@param value UnityEngine.Vector4
function CS.UnityEngine.Shader:SetGlobalVector(nameID, value) end

--
--Sets a global color property for all shaders.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@param value UnityEngine.Color
function CS.UnityEngine.Shader:SetGlobalColor(name, value) end

--
--Sets a global color property for all shaders.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
---@param value UnityEngine.Color
function CS.UnityEngine.Shader:SetGlobalColor(nameID, value) end

--
--Sets a global matrix property for all shaders.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@param value UnityEngine.Matrix4x4
function CS.UnityEngine.Shader:SetGlobalMatrix(name, value) end

--
--Sets a global matrix property for all shaders.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
---@param value UnityEngine.Matrix4x4
function CS.UnityEngine.Shader:SetGlobalMatrix(nameID, value) end

--
--Sets a global texture property for all shaders.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        value - The texture to set.
--        element - Optional parameter that specifies the type of data to set from the RenderTexture.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@param value UnityEngine.Texture
function CS.UnityEngine.Shader:SetGlobalTexture(name, value) end

--
--Sets a global texture property for all shaders.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        value - The texture to set.
--        element - Optional parameter that specifies the type of data to set from the RenderTexture.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
---@param value UnityEngine.Texture
function CS.UnityEngine.Shader:SetGlobalTexture(nameID, value) end

--
--Sets a global texture property for all shaders.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        value - The texture to set.
--        element - Optional parameter that specifies the type of data to set from the RenderTexture.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@param value UnityEngine.RenderTexture
---@param element UnityEngine.Rendering.RenderTextureSubElement
function CS.UnityEngine.Shader:SetGlobalTexture(name, value, element) end

--
--Sets a global texture property for all shaders.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        value - The texture to set.
--        element - Optional parameter that specifies the type of data to set from the RenderTexture.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
---@param value UnityEngine.RenderTexture
---@param element UnityEngine.Rendering.RenderTextureSubElement
function CS.UnityEngine.Shader:SetGlobalTexture(nameID, value, element) end

--
--Sets a global buffer property for all shaders.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        value - The buffer to set.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@param value UnityEngine.ComputeBuffer
function CS.UnityEngine.Shader:SetGlobalBuffer(name, value) end

--
--Sets a global buffer property for all shaders.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        value - The buffer to set.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
---@param value UnityEngine.ComputeBuffer
function CS.UnityEngine.Shader:SetGlobalBuffer(nameID, value) end

--
--Sets a global buffer property for all shaders.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        value - The buffer to set.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@param value UnityEngine.GraphicsBuffer
function CS.UnityEngine.Shader:SetGlobalBuffer(name, value) end

--
--Sets a global buffer property for all shaders.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        value - The buffer to set.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
---@param value UnityEngine.GraphicsBuffer
function CS.UnityEngine.Shader:SetGlobalBuffer(nameID, value) end

--
--Sets a ComputeBuffer or GraphicsBuffer as a named constant buffer for all shader types.
--
--```plaintext
--Params: nameID - The name ID of the constant buffer retrieved by Shader.PropertyToID.
--        name - The name of the constant buffer to override.
--        value - The buffer to override the constant buffer values with, or null to remove binding.
--        offset - Offset in bytes from the beginning of the buffer to bind. Must be a multiple of SystemInfo.constantBufferOffsetAlignment, or 0 if that value is 0.
--        size - The number of bytes to bind.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@param value UnityEngine.ComputeBuffer
---@param offset int
---@param size int
function CS.UnityEngine.Shader:SetGlobalConstantBuffer(name, value, offset, size) end

--
--Sets a ComputeBuffer or GraphicsBuffer as a named constant buffer for all shader types.
--
--```plaintext
--Params: nameID - The name ID of the constant buffer retrieved by Shader.PropertyToID.
--        name - The name of the constant buffer to override.
--        value - The buffer to override the constant buffer values with, or null to remove binding.
--        offset - Offset in bytes from the beginning of the buffer to bind. Must be a multiple of SystemInfo.constantBufferOffsetAlignment, or 0 if that value is 0.
--        size - The number of bytes to bind.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
---@param value UnityEngine.ComputeBuffer
---@param offset int
---@param size int
function CS.UnityEngine.Shader:SetGlobalConstantBuffer(nameID, value, offset, size) end

--
--Sets a ComputeBuffer or GraphicsBuffer as a named constant buffer for all shader types.
--
--```plaintext
--Params: nameID - The name ID of the constant buffer retrieved by Shader.PropertyToID.
--        name - The name of the constant buffer to override.
--        value - The buffer to override the constant buffer values with, or null to remove binding.
--        offset - Offset in bytes from the beginning of the buffer to bind. Must be a multiple of SystemInfo.constantBufferOffsetAlignment, or 0 if that value is 0.
--        size - The number of bytes to bind.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@param value UnityEngine.GraphicsBuffer
---@param offset int
---@param size int
function CS.UnityEngine.Shader:SetGlobalConstantBuffer(name, value, offset, size) end

--
--Sets a ComputeBuffer or GraphicsBuffer as a named constant buffer for all shader types.
--
--```plaintext
--Params: nameID - The name ID of the constant buffer retrieved by Shader.PropertyToID.
--        name - The name of the constant buffer to override.
--        value - The buffer to override the constant buffer values with, or null to remove binding.
--        offset - Offset in bytes from the beginning of the buffer to bind. Must be a multiple of SystemInfo.constantBufferOffsetAlignment, or 0 if that value is 0.
--        size - The number of bytes to bind.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
---@param value UnityEngine.GraphicsBuffer
---@param offset int
---@param size int
function CS.UnityEngine.Shader:SetGlobalConstantBuffer(nameID, value, offset, size) end

---@source UnityEngine.CoreModule.dll
---@param name string
---@param values System.Collections.Generic.List<float>
function CS.UnityEngine.Shader:SetGlobalFloatArray(name, values) end

---@source UnityEngine.CoreModule.dll
---@param nameID int
---@param values System.Collections.Generic.List<float>
function CS.UnityEngine.Shader:SetGlobalFloatArray(nameID, values) end

--
--Sets a global float array property for all shaders.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@param values float[]
function CS.UnityEngine.Shader:SetGlobalFloatArray(name, values) end

--
--Sets a global float array property for all shaders.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
---@param values float[]
function CS.UnityEngine.Shader:SetGlobalFloatArray(nameID, values) end

---@source UnityEngine.CoreModule.dll
---@param name string
---@param values System.Collections.Generic.List<UnityEngine.Vector4>
function CS.UnityEngine.Shader:SetGlobalVectorArray(name, values) end

---@source UnityEngine.CoreModule.dll
---@param nameID int
---@param values System.Collections.Generic.List<UnityEngine.Vector4>
function CS.UnityEngine.Shader:SetGlobalVectorArray(nameID, values) end

--
--Sets a global vector array property for all shaders.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@param values UnityEngine.Vector4[]
function CS.UnityEngine.Shader:SetGlobalVectorArray(name, values) end

--
--Sets a global vector array property for all shaders.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
---@param values UnityEngine.Vector4[]
function CS.UnityEngine.Shader:SetGlobalVectorArray(nameID, values) end

---@source UnityEngine.CoreModule.dll
---@param name string
---@param values System.Collections.Generic.List<UnityEngine.Matrix4x4>
function CS.UnityEngine.Shader:SetGlobalMatrixArray(name, values) end

---@source UnityEngine.CoreModule.dll
---@param nameID int
---@param values System.Collections.Generic.List<UnityEngine.Matrix4x4>
function CS.UnityEngine.Shader:SetGlobalMatrixArray(nameID, values) end

--
--Sets a global matrix array property for all shaders.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@param values UnityEngine.Matrix4x4[]
function CS.UnityEngine.Shader:SetGlobalMatrixArray(name, values) end

--
--Sets a global matrix array property for all shaders.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
---@param values UnityEngine.Matrix4x4[]
function CS.UnityEngine.Shader:SetGlobalMatrixArray(nameID, values) end

--
--Gets a global float property for all shaders previously set using SetGlobalFloat.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@return Single
function CS.UnityEngine.Shader:GetGlobalFloat(name) end

--
--Gets a global float property for all shaders previously set using SetGlobalFloat.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
---@return Single
function CS.UnityEngine.Shader:GetGlobalFloat(nameID) end

--
--Gets a global int property for all shaders previously set using SetGlobalInt.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@return Int32
function CS.UnityEngine.Shader:GetGlobalInt(name) end

--
--Gets a global int property for all shaders previously set using SetGlobalInt.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
---@return Int32
function CS.UnityEngine.Shader:GetGlobalInt(nameID) end

--
--Gets a global vector property for all shaders previously set using SetGlobalVector.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@return Vector4
function CS.UnityEngine.Shader:GetGlobalVector(name) end

--
--Gets a global vector property for all shaders previously set using SetGlobalVector.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
---@return Vector4
function CS.UnityEngine.Shader:GetGlobalVector(nameID) end

--
--Gets a global color property for all shaders previously set using SetGlobalColor.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@return Color
function CS.UnityEngine.Shader:GetGlobalColor(name) end

--
--Gets a global color property for all shaders previously set using SetGlobalColor.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
---@return Color
function CS.UnityEngine.Shader:GetGlobalColor(nameID) end

--
--Gets a global matrix property for all shaders previously set using SetGlobalMatrix.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@return Matrix4x4
function CS.UnityEngine.Shader:GetGlobalMatrix(name) end

--
--Gets a global matrix property for all shaders previously set using SetGlobalMatrix.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
---@return Matrix4x4
function CS.UnityEngine.Shader:GetGlobalMatrix(nameID) end

--
--Gets a global texture property for all shaders previously set using SetGlobalTexture.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@return Texture
function CS.UnityEngine.Shader:GetGlobalTexture(name) end

--
--Gets a global texture property for all shaders previously set using SetGlobalTexture.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
---@return Texture
function CS.UnityEngine.Shader:GetGlobalTexture(nameID) end

--
--Gets a global float array for all shaders previously set using SetGlobalFloatArray.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
function CS.UnityEngine.Shader:GetGlobalFloatArray(name) end

--
--Gets a global float array for all shaders previously set using SetGlobalFloatArray.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
function CS.UnityEngine.Shader:GetGlobalFloatArray(nameID) end

--
--Gets a global vector array for all shaders previously set using SetGlobalVectorArray.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
function CS.UnityEngine.Shader:GetGlobalVectorArray(name) end

--
--Gets a global vector array for all shaders previously set using SetGlobalVectorArray.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
function CS.UnityEngine.Shader:GetGlobalVectorArray(nameID) end

--
--Gets a global matrix array for all shaders previously set using SetGlobalMatrixArray.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
function CS.UnityEngine.Shader:GetGlobalMatrixArray(name) end

--
--Gets a global matrix array for all shaders previously set using SetGlobalMatrixArray.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
function CS.UnityEngine.Shader:GetGlobalMatrixArray(nameID) end

---@source UnityEngine.CoreModule.dll
---@param name string
---@param values System.Collections.Generic.List<float>
function CS.UnityEngine.Shader:GetGlobalFloatArray(name, values) end

---@source UnityEngine.CoreModule.dll
---@param nameID int
---@param values System.Collections.Generic.List<float>
function CS.UnityEngine.Shader:GetGlobalFloatArray(nameID, values) end

---@source UnityEngine.CoreModule.dll
---@param name string
---@param values System.Collections.Generic.List<UnityEngine.Vector4>
function CS.UnityEngine.Shader:GetGlobalVectorArray(name, values) end

---@source UnityEngine.CoreModule.dll
---@param nameID int
---@param values System.Collections.Generic.List<UnityEngine.Vector4>
function CS.UnityEngine.Shader:GetGlobalVectorArray(nameID, values) end

---@source UnityEngine.CoreModule.dll
---@param name string
---@param values System.Collections.Generic.List<UnityEngine.Matrix4x4>
function CS.UnityEngine.Shader:GetGlobalMatrixArray(name, values) end

---@source UnityEngine.CoreModule.dll
---@param nameID int
---@param values System.Collections.Generic.List<UnityEngine.Matrix4x4>
function CS.UnityEngine.Shader:GetGlobalMatrixArray(nameID, values) end

--
--Returns the number of properties in this Shader.
--
---@source UnityEngine.CoreModule.dll
---@return Int32
function CS.UnityEngine.Shader.GetPropertyCount() end

--
--Finds the index of a shader property by its name.
--
--```plaintext
--Params: propertyName - The name of the shader property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param propertyName string
---@return Int32
function CS.UnityEngine.Shader.FindPropertyIndex(propertyName) end

--
--Returns the name of the shader property at the specified index.
--
--```plaintext
--Params: propertyIndex - The index of the shader property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param propertyIndex int
---@return String
function CS.UnityEngine.Shader.GetPropertyName(propertyIndex) end

--
--Returns the nameId of the shader property at the specified index.
--
--```plaintext
--Params: propertyIndex - The index of the shader property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param propertyIndex int
---@return Int32
function CS.UnityEngine.Shader.GetPropertyNameId(propertyIndex) end

--
--Returns the ShaderPropertyType of the property at the specified index.
--
--```plaintext
--Params: propertyIndex - The index of the shader property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param propertyIndex int
---@return ShaderPropertyType
function CS.UnityEngine.Shader.GetPropertyType(propertyIndex) end

--
--Returns the description string of the shader property at the specified index.
--
--```plaintext
--Params: propertyIndex - The index of the shader property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param propertyIndex int
---@return String
function CS.UnityEngine.Shader.GetPropertyDescription(propertyIndex) end

--
--Returns the ShaderPropertyFlags of the shader property at the specified index.
--
--```plaintext
--Params: propertyIndex - The index of the shader property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param propertyIndex int
---@return ShaderPropertyFlags
function CS.UnityEngine.Shader.GetPropertyFlags(propertyIndex) end

--
--Returns an array of strings containing attributes of the shader property at the specified index.
--
--```plaintext
--Params: propertyIndex - The index of the shader property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param propertyIndex int
function CS.UnityEngine.Shader.GetPropertyAttributes(propertyIndex) end

--
--Returns the default float value of the shader property at the specified index.
--
--```plaintext
--Params: propertyIndex - The index of the shader property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param propertyIndex int
---@return Single
function CS.UnityEngine.Shader.GetPropertyDefaultFloatValue(propertyIndex) end

--
--Returns the default Vector4 value of the shader property at the specified index.
--
--```plaintext
--Params: propertyIndex - The index of the shader property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param propertyIndex int
---@return Vector4
function CS.UnityEngine.Shader.GetPropertyDefaultVectorValue(propertyIndex) end

--
--Returns the min and max limits for a <a href="Rendering.ShaderPropertyType.Range.html">Range</a> property at the specified index.
--
--```plaintext
--Params: propertyIndex - The index of the shader property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param propertyIndex int
---@return Vector2
function CS.UnityEngine.Shader.GetPropertyRangeLimits(propertyIndex) end

--
--Returns the TextureDimension of a <a href="Rendering.ShaderPropertyType.Texture.html">Texture</a> shader property at the specified index.
--
--```plaintext
--Params: propertyIndex - The index of the shader property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param propertyIndex int
---@return TextureDimension
function CS.UnityEngine.Shader.GetPropertyTextureDimension(propertyIndex) end

--
--Returns the default Texture name of a <a href="Rendering.ShaderPropertyType.Texture.html">Texture</a> shader property at the specified index.
--
--```plaintext
--Params: propertyIndex - The index of the shader property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param propertyIndex int
---@return String
function CS.UnityEngine.Shader.GetPropertyTextureDefaultName(propertyIndex) end

---@source UnityEngine.CoreModule.dll
---@param propertyIndex int
---@param stackName string
---@param layerIndex int
---@return Boolean
function CS.UnityEngine.Shader.FindTextureStack(propertyIndex, stackName, layerIndex) end


--
--Single, dual, or directional lightmaps rendering mode, used only in GIWorkflowMode.Legacy
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.LightmapsModeLegacy: System.Enum
--
--Single, traditional lightmap rendering mode.
--
---@source UnityEngine.CoreModule.dll
---@field Single UnityEngine.LightmapsModeLegacy
--
--Dual lightmap rendering mode.
--
---@source UnityEngine.CoreModule.dll
---@field Dual UnityEngine.LightmapsModeLegacy
--
--Directional rendering mode.
--
---@source UnityEngine.CoreModule.dll
---@field Directional UnityEngine.LightmapsModeLegacy
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.LightmapsModeLegacy = {}

---@source 
---@param value any
---@return UnityEngine.LightmapsModeLegacy
function CS.UnityEngine.LightmapsModeLegacy:__CastFrom(value) end


--
--The trail renderer is used to make trails behind objects in the Scene as they move about.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.TrailRenderer: UnityEngine.Renderer
--
--Get the number of line segments in the trail.
--
---@source UnityEngine.CoreModule.dll
---@field numPositions int
--
--How long does the trail take to fade out.
--
---@source UnityEngine.CoreModule.dll
---@field time float
--
--The width of the trail at the spawning point.
--
---@source UnityEngine.CoreModule.dll
---@field startWidth float
--
--The width of the trail at the end of the trail.
--
---@source UnityEngine.CoreModule.dll
---@field endWidth float
--
--Set an overall multiplier that is applied to the TrailRenderer.widthCurve to get the final width of the trail.
--
---@source UnityEngine.CoreModule.dll
---@field widthMultiplier float
--
--Does the GameObject of this Trail Renderer auto destruct?
--
---@source UnityEngine.CoreModule.dll
---@field autodestruct bool
--
--Creates trails when the GameObject moves.
--
---@source UnityEngine.CoreModule.dll
---@field emitting bool
--
--Set this to a value greater than 0, to get rounded corners between each segment of the trail.
--
---@source UnityEngine.CoreModule.dll
---@field numCornerVertices int
--
--Set this to a value greater than 0, to get rounded corners on each end of the trail.
--
---@source UnityEngine.CoreModule.dll
---@field numCapVertices int
--
--Set the minimum distance the trail can travel before a new vertex is added to it.
--
---@source UnityEngine.CoreModule.dll
---@field minVertexDistance float
--
--Set the color at the start of the trail.
--
---@source UnityEngine.CoreModule.dll
---@field startColor UnityEngine.Color
--
--Set the color at the end of the trail.
--
---@source UnityEngine.CoreModule.dll
---@field endColor UnityEngine.Color
--
--Get the number of line segments in the trail.
--
---@source UnityEngine.CoreModule.dll
---@field positionCount int
--
--Apply a shadow bias to prevent self-shadowing artifacts. The specified value is the proportion of the trail width at each segment.
--
---@source UnityEngine.CoreModule.dll
---@field shadowBias float
--
--Configures a trail to generate Normals and Tangents. With this data, Scene lighting can affect the trail via Normal Maps and the Unity Standard Shader, or your own custom-built Shaders.
--
---@source UnityEngine.CoreModule.dll
---@field generateLightingData bool
--
--Choose whether the U coordinate of the trail texture is tiled or stretched.
--
---@source UnityEngine.CoreModule.dll
---@field textureMode UnityEngine.LineTextureMode
--
--Select whether the trail will face the camera, or the orientation of the Transform Component.
--
---@source UnityEngine.CoreModule.dll
---@field alignment UnityEngine.LineAlignment
--
--Set the curve describing the width of the trail at various points along its length.
--
---@source UnityEngine.CoreModule.dll
---@field widthCurve UnityEngine.AnimationCurve
--
--Set the color gradient describing the color of the trail at various points along its length.
--
---@source UnityEngine.CoreModule.dll
---@field colorGradient UnityEngine.Gradient
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.TrailRenderer = {}

--
--Set the position of a vertex in the trail.
--
--```plaintext
--Params: index - Which position to set.
--        position - The new position.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param index int
---@param position UnityEngine.Vector3
function CS.UnityEngine.TrailRenderer.SetPosition(index, position) end

--
--The position at the specified index in the array.
--
--```plaintext
--Params: index - The index of the position to retrieve.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param index int
---@return Vector3
function CS.UnityEngine.TrailRenderer.GetPosition(index) end

--
--Removes all points from the TrailRenderer.
--Useful for restarting a trail from a new position.
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.TrailRenderer.Clear() end

--
--Creates a snapshot of TrailRenderer and stores it in mesh.
--
--```plaintext
--Params: mesh - A static mesh that will receive the snapshot of the trail.
--        camera - The camera used for determining which way camera-space trails will face.
--        useTransform - Include the rotation and scale of the Transform in the baked mesh.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param useTransform bool
function CS.UnityEngine.TrailRenderer.BakeMesh(mesh, useTransform) end

--
--Creates a snapshot of TrailRenderer and stores it in mesh.
--
--```plaintext
--Params: mesh - A static mesh that will receive the snapshot of the trail.
--        camera - The camera used for determining which way camera-space trails will face.
--        useTransform - Include the rotation and scale of the Transform in the baked mesh.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param camera UnityEngine.Camera
---@param useTransform bool
function CS.UnityEngine.TrailRenderer.BakeMesh(mesh, camera, useTransform) end

--
--How many positions were actually stored in the output array.
--
--```plaintext
--Params: positions - The array of positions to retrieve.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param positions UnityEngine.Vector3[]
---@return Int32
function CS.UnityEngine.TrailRenderer.GetPositions(positions) end

--
--Sets the positions of all vertices in the trail.
--
--```plaintext
--Params: positions - The array of positions to set.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param positions UnityEngine.Vector3[]
function CS.UnityEngine.TrailRenderer.SetPositions(positions) end

--
--Adds a position to the trail.
--
--```plaintext
--Params: position - The position to add to the trail.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param position UnityEngine.Vector3
function CS.UnityEngine.TrailRenderer.AddPosition(position) end

--
--Add an array of positions to the trail.
--
--```plaintext
--Params: positions - The positions to add to the trail.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param positions UnityEngine.Vector3[]
function CS.UnityEngine.TrailRenderer.AddPositions(positions) end

---@source UnityEngine.CoreModule.dll
---@param positions Unity.Collections.NativeArray<UnityEngine.Vector3>
function CS.UnityEngine.TrailRenderer.SetPositions(positions) end

---@source UnityEngine.CoreModule.dll
---@param positions Unity.Collections.NativeSlice<UnityEngine.Vector3>
function CS.UnityEngine.TrailRenderer.SetPositions(positions) end

---@source UnityEngine.CoreModule.dll
---@param positions Unity.Collections.NativeArray<UnityEngine.Vector3>
---@return Int32
function CS.UnityEngine.TrailRenderer.GetPositions(positions) end

---@source UnityEngine.CoreModule.dll
---@param positions Unity.Collections.NativeSlice<UnityEngine.Vector3>
---@return Int32
function CS.UnityEngine.TrailRenderer.GetPositions(positions) end

---@source UnityEngine.CoreModule.dll
---@param positions Unity.Collections.NativeArray<UnityEngine.Vector3>
function CS.UnityEngine.TrailRenderer.AddPositions(positions) end

---@source UnityEngine.CoreModule.dll
---@param positions Unity.Collections.NativeSlice<UnityEngine.Vector3>
function CS.UnityEngine.TrailRenderer.AddPositions(positions) end


--
--Describes different types of camera.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.CameraType: System.Enum
--
--Used to indicate a regular in-game camera.
--
---@source UnityEngine.CoreModule.dll
---@field Game UnityEngine.CameraType
--
--Used to indicate that a camera is used for rendering the Scene View in the Editor.
--
---@source UnityEngine.CoreModule.dll
---@field SceneView UnityEngine.CameraType
--
--Used to indicate a camera that is used for rendering previews in the Editor.
--
---@source UnityEngine.CoreModule.dll
---@field Preview UnityEngine.CameraType
--
--Used to indicate that a camera is used for rendering VR (in edit mode) in the Editor.
--
---@source UnityEngine.CoreModule.dll
---@field VR UnityEngine.CameraType
--
--Used to indicate a camera that is used for rendering reflection probes.
--
---@source UnityEngine.CoreModule.dll
---@field Reflection UnityEngine.CameraType
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.CameraType = {}

---@source 
---@param value any
---@return UnityEngine.CameraType
function CS.UnityEngine.CameraType:__CastFrom(value) end


--
--The line renderer is used to draw free-floating lines in 3D space.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.LineRenderer: UnityEngine.Renderer
--
--Set the number of line segments.
--
---@source UnityEngine.CoreModule.dll
---@field numPositions int
--
--Set the width at the start of the line.
--
---@source UnityEngine.CoreModule.dll
---@field startWidth float
--
--Set the width at the end of the line.
--
---@source UnityEngine.CoreModule.dll
---@field endWidth float
--
--Set an overall multiplier that is applied to the LineRenderer.widthCurve to get the final width of the line.
--
---@source UnityEngine.CoreModule.dll
---@field widthMultiplier float
--
--Set this to a value greater than 0, to get rounded corners between each segment of the line.
--
---@source UnityEngine.CoreModule.dll
---@field numCornerVertices int
--
--Set this to a value greater than 0, to get rounded corners on each end of the line.
--
---@source UnityEngine.CoreModule.dll
---@field numCapVertices int
--
--If enabled, the lines are defined in world space.
--
---@source UnityEngine.CoreModule.dll
---@field useWorldSpace bool
--
--Connect the start and end positions of the line together to form a continuous loop.
--
---@source UnityEngine.CoreModule.dll
---@field loop bool
--
--Set the color at the start of the line.
--
---@source UnityEngine.CoreModule.dll
---@field startColor UnityEngine.Color
--
--Set the color at the end of the line.
--
---@source UnityEngine.CoreModule.dll
---@field endColor UnityEngine.Color
--
--Set/get the number of vertices.
--
---@source UnityEngine.CoreModule.dll
---@field positionCount int
--
--Apply a shadow bias to prevent self-shadowing artifacts. The specified value is the proportion of the line width at each segment.
--
---@source UnityEngine.CoreModule.dll
---@field shadowBias float
--
--Configures a line to generate Normals and Tangents. With this data, Scene lighting can affect the line via Normal Maps and the Unity Standard Shader, or your own custom-built Shaders.
--
---@source UnityEngine.CoreModule.dll
---@field generateLightingData bool
--
--Choose whether the U coordinate of the line texture is tiled or stretched.
--
---@source UnityEngine.CoreModule.dll
---@field textureMode UnityEngine.LineTextureMode
--
--Select whether the line will face the camera, or the orientation of the Transform Component.
--
---@source UnityEngine.CoreModule.dll
---@field alignment UnityEngine.LineAlignment
--
--Set the curve describing the width of the line at various points along its length.
--
---@source UnityEngine.CoreModule.dll
---@field widthCurve UnityEngine.AnimationCurve
--
--Set the color gradient describing the color of the line at various points along its length.
--
---@source UnityEngine.CoreModule.dll
---@field colorGradient UnityEngine.Gradient
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.LineRenderer = {}

--
--Set the line width at the start and at the end.
--
---@source UnityEngine.CoreModule.dll
---@param start float
---@param end float
function CS.UnityEngine.LineRenderer.SetWidth(start, end) end

--
--Set the line color at the start and at the end.
--
---@source UnityEngine.CoreModule.dll
---@param start UnityEngine.Color
---@param end UnityEngine.Color
function CS.UnityEngine.LineRenderer.SetColors(start, end) end

--
--Set the number of line segments.
--
---@source UnityEngine.CoreModule.dll
---@param count int
function CS.UnityEngine.LineRenderer.SetVertexCount(count) end

--
--Set the position of a vertex in the line.
--
--```plaintext
--Params: index - Which position to set.
--        position - The new position.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param index int
---@param position UnityEngine.Vector3
function CS.UnityEngine.LineRenderer.SetPosition(index, position) end

--
--The position at the specified index in the array.
--
--```plaintext
--Params: index - The index of the position to retrieve.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param index int
---@return Vector3
function CS.UnityEngine.LineRenderer.GetPosition(index) end

--
--Generates a simplified version of the original line by removing points that fall within the specified tolerance.
--
--```plaintext
--Params: tolerance - This value is used to evaluate which points should be removed from the line. A higher value results in a simpler line (less points). A positive value close to zero results in a line with little to no reduction. A value of zero or less has no effect.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param tolerance float
function CS.UnityEngine.LineRenderer.Simplify(tolerance) end

--
--Creates a snapshot of LineRenderer and stores it in mesh.
--
--```plaintext
--Params: mesh - A static mesh that will receive the snapshot of the line.
--        camera - The camera used for determining which way camera-space lines will face.
--        useTransform - Include the rotation and scale of the Transform in the baked mesh.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param useTransform bool
function CS.UnityEngine.LineRenderer.BakeMesh(mesh, useTransform) end

--
--Creates a snapshot of LineRenderer and stores it in mesh.
--
--```plaintext
--Params: mesh - A static mesh that will receive the snapshot of the line.
--        camera - The camera used for determining which way camera-space lines will face.
--        useTransform - Include the rotation and scale of the Transform in the baked mesh.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param camera UnityEngine.Camera
---@param useTransform bool
function CS.UnityEngine.LineRenderer.BakeMesh(mesh, camera, useTransform) end

--
--How many positions were actually stored in the output array.
--
--```plaintext
--Params: positions - The array of positions to retrieve. The array passed should be of at least positionCount in size.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param positions UnityEngine.Vector3[]
---@return Int32
function CS.UnityEngine.LineRenderer.GetPositions(positions) end

--
--Set the positions of all vertices in the line.
--
--```plaintext
--Params: positions - The array of positions to set.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param positions UnityEngine.Vector3[]
function CS.UnityEngine.LineRenderer.SetPositions(positions) end

---@source UnityEngine.CoreModule.dll
---@param positions Unity.Collections.NativeArray<UnityEngine.Vector3>
function CS.UnityEngine.LineRenderer.SetPositions(positions) end

---@source UnityEngine.CoreModule.dll
---@param positions Unity.Collections.NativeSlice<UnityEngine.Vector3>
function CS.UnityEngine.LineRenderer.SetPositions(positions) end

---@source UnityEngine.CoreModule.dll
---@param positions Unity.Collections.NativeArray<UnityEngine.Vector3>
---@return Int32
function CS.UnityEngine.LineRenderer.GetPositions(positions) end

---@source UnityEngine.CoreModule.dll
---@param positions Unity.Collections.NativeSlice<UnityEngine.Vector3>
---@return Int32
function CS.UnityEngine.LineRenderer.GetPositions(positions) end


--
--ComputeBuffer type.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.ComputeBufferType: System.Enum
--
--Default ComputeBuffer type (structured buffer).
--
---@source UnityEngine.CoreModule.dll
---@field Default UnityEngine.ComputeBufferType
--
--Raw ComputeBuffer type (byte address buffer).
--
---@source UnityEngine.CoreModule.dll
---@field Raw UnityEngine.ComputeBufferType
--
--Append-consume ComputeBuffer type.
--
---@source UnityEngine.CoreModule.dll
---@field Append UnityEngine.ComputeBufferType
--
--ComputeBuffer with a counter.
--
---@source UnityEngine.CoreModule.dll
---@field Counter UnityEngine.ComputeBufferType
--
--ComputeBuffer that you can use as a constant buffer (uniform buffer).
--
---@source UnityEngine.CoreModule.dll
---@field Constant UnityEngine.ComputeBufferType
--
--ComputeBuffer that you can use as a structured buffer.
--
---@source UnityEngine.CoreModule.dll
---@field Structured UnityEngine.ComputeBufferType
---@source UnityEngine.CoreModule.dll
---@field DrawIndirect UnityEngine.ComputeBufferType
--
--ComputeBuffer used for Graphics.DrawProceduralIndirect, ComputeShader.DispatchIndirect or Graphics.DrawMeshInstancedIndirect arguments.
--
---@source UnityEngine.CoreModule.dll
---@field IndirectArguments UnityEngine.ComputeBufferType
---@source UnityEngine.CoreModule.dll
---@field GPUMemory UnityEngine.ComputeBufferType
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.ComputeBufferType = {}

---@source 
---@param value any
---@return UnityEngine.ComputeBufferType
function CS.UnityEngine.ComputeBufferType:__CastFrom(value) end


--
--A block of material values to apply.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.MaterialPropertyBlock: object
--
--Is the material property block empty? (Read Only)
--
---@source UnityEngine.CoreModule.dll
---@field isEmpty bool
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.MaterialPropertyBlock = {}

---@source UnityEngine.CoreModule.dll
---@param name string
---@param value float
function CS.UnityEngine.MaterialPropertyBlock.AddFloat(name, value) end

---@source UnityEngine.CoreModule.dll
---@param nameID int
---@param value float
function CS.UnityEngine.MaterialPropertyBlock.AddFloat(nameID, value) end

---@source UnityEngine.CoreModule.dll
---@param name string
---@param value UnityEngine.Vector4
function CS.UnityEngine.MaterialPropertyBlock.AddVector(name, value) end

---@source UnityEngine.CoreModule.dll
---@param nameID int
---@param value UnityEngine.Vector4
function CS.UnityEngine.MaterialPropertyBlock.AddVector(nameID, value) end

---@source UnityEngine.CoreModule.dll
---@param name string
---@param value UnityEngine.Color
function CS.UnityEngine.MaterialPropertyBlock.AddColor(name, value) end

---@source UnityEngine.CoreModule.dll
---@param nameID int
---@param value UnityEngine.Color
function CS.UnityEngine.MaterialPropertyBlock.AddColor(nameID, value) end

---@source UnityEngine.CoreModule.dll
---@param name string
---@param value UnityEngine.Matrix4x4
function CS.UnityEngine.MaterialPropertyBlock.AddMatrix(name, value) end

---@source UnityEngine.CoreModule.dll
---@param nameID int
---@param value UnityEngine.Matrix4x4
function CS.UnityEngine.MaterialPropertyBlock.AddMatrix(nameID, value) end

---@source UnityEngine.CoreModule.dll
---@param name string
---@param value UnityEngine.Texture
function CS.UnityEngine.MaterialPropertyBlock.AddTexture(name, value) end

---@source UnityEngine.CoreModule.dll
---@param nameID int
---@param value UnityEngine.Texture
function CS.UnityEngine.MaterialPropertyBlock.AddTexture(nameID, value) end

--
--Clear material property values.
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.MaterialPropertyBlock.Clear() end

--
--Set a float property.
--
--```plaintext
--Params: name - The name of the property.
--        nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        value - The float value to set.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@param value float
function CS.UnityEngine.MaterialPropertyBlock.SetFloat(name, value) end

--
--Set a float property.
--
--```plaintext
--Params: name - The name of the property.
--        nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        value - The float value to set.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
---@param value float
function CS.UnityEngine.MaterialPropertyBlock.SetFloat(nameID, value) end

--
--Adds a property to the block. If an int property with the given name already exists, the old value is replaced.
--
--```plaintext
--Params: name - The name of the property.
--        nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        value - The int value to set.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@param value int
function CS.UnityEngine.MaterialPropertyBlock.SetInt(name, value) end

--
--Adds a property to the block. If an int property with the given name already exists, the old value is replaced.
--
--```plaintext
--Params: name - The name of the property.
--        nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        value - The int value to set.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
---@param value int
function CS.UnityEngine.MaterialPropertyBlock.SetInt(nameID, value) end

--
--Set a vector property.
--
--```plaintext
--Params: name - The name of the property.
--        nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        value - The Vector4 value to set.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@param value UnityEngine.Vector4
function CS.UnityEngine.MaterialPropertyBlock.SetVector(name, value) end

--
--Set a vector property.
--
--```plaintext
--Params: name - The name of the property.
--        nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        value - The Vector4 value to set.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
---@param value UnityEngine.Vector4
function CS.UnityEngine.MaterialPropertyBlock.SetVector(nameID, value) end

--
--Set a color property.
--
--```plaintext
--Params: name - The name of the property.
--        nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        value - The Color value to set.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@param value UnityEngine.Color
function CS.UnityEngine.MaterialPropertyBlock.SetColor(name, value) end

--
--Set a color property.
--
--```plaintext
--Params: name - The name of the property.
--        nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        value - The Color value to set.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
---@param value UnityEngine.Color
function CS.UnityEngine.MaterialPropertyBlock.SetColor(nameID, value) end

--
--Set a matrix property.
--
--```plaintext
--Params: name - The name of the property.
--        nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        value - The matrix value to set.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@param value UnityEngine.Matrix4x4
function CS.UnityEngine.MaterialPropertyBlock.SetMatrix(name, value) end

--
--Set a matrix property.
--
--```plaintext
--Params: name - The name of the property.
--        nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        value - The matrix value to set.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
---@param value UnityEngine.Matrix4x4
function CS.UnityEngine.MaterialPropertyBlock.SetMatrix(nameID, value) end

--
--Set a buffer property.
--
--```plaintext
--Params: name - The name of the property.
--        nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        value - The ComputeBuffer or GraphicsBuffer to set.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@param value UnityEngine.ComputeBuffer
function CS.UnityEngine.MaterialPropertyBlock.SetBuffer(name, value) end

--
--Set a buffer property.
--
--```plaintext
--Params: name - The name of the property.
--        nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        value - The ComputeBuffer or GraphicsBuffer to set.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
---@param value UnityEngine.ComputeBuffer
function CS.UnityEngine.MaterialPropertyBlock.SetBuffer(nameID, value) end

--
--Set a buffer property.
--
--```plaintext
--Params: name - The name of the property.
--        nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        value - The ComputeBuffer or GraphicsBuffer to set.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@param value UnityEngine.GraphicsBuffer
function CS.UnityEngine.MaterialPropertyBlock.SetBuffer(name, value) end

--
--Set a buffer property.
--
--```plaintext
--Params: name - The name of the property.
--        nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        value - The ComputeBuffer or GraphicsBuffer to set.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
---@param value UnityEngine.GraphicsBuffer
function CS.UnityEngine.MaterialPropertyBlock.SetBuffer(nameID, value) end

--
--Set a texture property.
--
--```plaintext
--Params: name - The name of the property.
--        nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        value - The Texture to set.
--        element - Optional parameter that specifies the type of data to set from the RenderTexture.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@param value UnityEngine.Texture
function CS.UnityEngine.MaterialPropertyBlock.SetTexture(name, value) end

--
--Set a texture property.
--
--```plaintext
--Params: name - The name of the property.
--        nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        value - The Texture to set.
--        element - Optional parameter that specifies the type of data to set from the RenderTexture.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
---@param value UnityEngine.Texture
function CS.UnityEngine.MaterialPropertyBlock.SetTexture(nameID, value) end

--
--Set a texture property.
--
--```plaintext
--Params: name - The name of the property.
--        nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        value - The Texture to set.
--        element - Optional parameter that specifies the type of data to set from the RenderTexture.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@param value UnityEngine.RenderTexture
---@param element UnityEngine.Rendering.RenderTextureSubElement
function CS.UnityEngine.MaterialPropertyBlock.SetTexture(name, value, element) end

--
--Set a texture property.
--
--```plaintext
--Params: name - The name of the property.
--        nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        value - The Texture to set.
--        element - Optional parameter that specifies the type of data to set from the RenderTexture.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
---@param value UnityEngine.RenderTexture
---@param element UnityEngine.Rendering.RenderTextureSubElement
function CS.UnityEngine.MaterialPropertyBlock.SetTexture(nameID, value, element) end

--
--Sets a ComputeBuffer or GraphicsBuffer as a named constant buffer for the MaterialPropertyBlock.
--
--```plaintext
--Params: name - The name of the constant buffer to override.
--        value - The buffer to override the constant buffer values with.
--        offset - Offset in bytes from the beginning of the buffer to bind. Must be a multiple of SystemInfo.constantBufferOffsetAlignment, or 0 if that value is 0.
--        size - The number of bytes to bind.
--        nameID - The shader property ID of the constant buffer to override.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@param value UnityEngine.ComputeBuffer
---@param offset int
---@param size int
function CS.UnityEngine.MaterialPropertyBlock.SetConstantBuffer(name, value, offset, size) end

--
--Sets a ComputeBuffer or GraphicsBuffer as a named constant buffer for the MaterialPropertyBlock.
--
--```plaintext
--Params: name - The name of the constant buffer to override.
--        value - The buffer to override the constant buffer values with.
--        offset - Offset in bytes from the beginning of the buffer to bind. Must be a multiple of SystemInfo.constantBufferOffsetAlignment, or 0 if that value is 0.
--        size - The number of bytes to bind.
--        nameID - The shader property ID of the constant buffer to override.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
---@param value UnityEngine.ComputeBuffer
---@param offset int
---@param size int
function CS.UnityEngine.MaterialPropertyBlock.SetConstantBuffer(nameID, value, offset, size) end

--
--Sets a ComputeBuffer or GraphicsBuffer as a named constant buffer for the MaterialPropertyBlock.
--
--```plaintext
--Params: name - The name of the constant buffer to override.
--        value - The buffer to override the constant buffer values with.
--        offset - Offset in bytes from the beginning of the buffer to bind. Must be a multiple of SystemInfo.constantBufferOffsetAlignment, or 0 if that value is 0.
--        size - The number of bytes to bind.
--        nameID - The shader property ID of the constant buffer to override.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@param value UnityEngine.GraphicsBuffer
---@param offset int
---@param size int
function CS.UnityEngine.MaterialPropertyBlock.SetConstantBuffer(name, value, offset, size) end

--
--Sets a ComputeBuffer or GraphicsBuffer as a named constant buffer for the MaterialPropertyBlock.
--
--```plaintext
--Params: name - The name of the constant buffer to override.
--        value - The buffer to override the constant buffer values with.
--        offset - Offset in bytes from the beginning of the buffer to bind. Must be a multiple of SystemInfo.constantBufferOffsetAlignment, or 0 if that value is 0.
--        size - The number of bytes to bind.
--        nameID - The shader property ID of the constant buffer to override.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
---@param value UnityEngine.GraphicsBuffer
---@param offset int
---@param size int
function CS.UnityEngine.MaterialPropertyBlock.SetConstantBuffer(nameID, value, offset, size) end

---@source UnityEngine.CoreModule.dll
---@param name string
---@param values System.Collections.Generic.List<float>
function CS.UnityEngine.MaterialPropertyBlock.SetFloatArray(name, values) end

---@source UnityEngine.CoreModule.dll
---@param nameID int
---@param values System.Collections.Generic.List<float>
function CS.UnityEngine.MaterialPropertyBlock.SetFloatArray(nameID, values) end

--
--Set a float array property.
--
--```plaintext
--Params: name - The name of the property.
--        nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        values - The array to set.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@param values float[]
function CS.UnityEngine.MaterialPropertyBlock.SetFloatArray(name, values) end

--
--Set a float array property.
--
--```plaintext
--Params: name - The name of the property.
--        nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        values - The array to set.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
---@param values float[]
function CS.UnityEngine.MaterialPropertyBlock.SetFloatArray(nameID, values) end

---@source UnityEngine.CoreModule.dll
---@param name string
---@param values System.Collections.Generic.List<UnityEngine.Vector4>
function CS.UnityEngine.MaterialPropertyBlock.SetVectorArray(name, values) end

---@source UnityEngine.CoreModule.dll
---@param nameID int
---@param values System.Collections.Generic.List<UnityEngine.Vector4>
function CS.UnityEngine.MaterialPropertyBlock.SetVectorArray(nameID, values) end

--
--Set a vector array property.
--
--```plaintext
--Params: nameID - The name of the property.
--        values - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The array to set.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@param values UnityEngine.Vector4[]
function CS.UnityEngine.MaterialPropertyBlock.SetVectorArray(name, values) end

--
--Set a vector array property.
--
--```plaintext
--Params: nameID - The name of the property.
--        values - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The array to set.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
---@param values UnityEngine.Vector4[]
function CS.UnityEngine.MaterialPropertyBlock.SetVectorArray(nameID, values) end

---@source UnityEngine.CoreModule.dll
---@param name string
---@param values System.Collections.Generic.List<UnityEngine.Matrix4x4>
function CS.UnityEngine.MaterialPropertyBlock.SetMatrixArray(name, values) end

---@source UnityEngine.CoreModule.dll
---@param nameID int
---@param values System.Collections.Generic.List<UnityEngine.Matrix4x4>
function CS.UnityEngine.MaterialPropertyBlock.SetMatrixArray(nameID, values) end

--
--Set a matrix array property.
--
--```plaintext
--Params: name - The name of the property.
--        values - The name ID of the property retrieved by Shader.PropertyToID.
--        nameID - The array to set.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@param values UnityEngine.Matrix4x4[]
function CS.UnityEngine.MaterialPropertyBlock.SetMatrixArray(name, values) end

--
--Set a matrix array property.
--
--```plaintext
--Params: name - The name of the property.
--        values - The name ID of the property retrieved by Shader.PropertyToID.
--        nameID - The array to set.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
---@param values UnityEngine.Matrix4x4[]
function CS.UnityEngine.MaterialPropertyBlock.SetMatrixArray(nameID, values) end

--
--Get a float from the property block.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@return Single
function CS.UnityEngine.MaterialPropertyBlock.GetFloat(name) end

--
--Get a float from the property block.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
---@return Single
function CS.UnityEngine.MaterialPropertyBlock.GetFloat(nameID) end

--
--Get an int from the property block.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@return Int32
function CS.UnityEngine.MaterialPropertyBlock.GetInt(name) end

--
--Get an int from the property block.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
---@return Int32
function CS.UnityEngine.MaterialPropertyBlock.GetInt(nameID) end

--
--Get a vector from the property block.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@return Vector4
function CS.UnityEngine.MaterialPropertyBlock.GetVector(name) end

--
--Get a vector from the property block.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
---@return Vector4
function CS.UnityEngine.MaterialPropertyBlock.GetVector(nameID) end

--
--Get a color from the property block.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@return Color
function CS.UnityEngine.MaterialPropertyBlock.GetColor(name) end

--
--Get a color from the property block.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
---@return Color
function CS.UnityEngine.MaterialPropertyBlock.GetColor(nameID) end

--
--Get a matrix from the property block.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@return Matrix4x4
function CS.UnityEngine.MaterialPropertyBlock.GetMatrix(name) end

--
--Get a matrix from the property block.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
---@return Matrix4x4
function CS.UnityEngine.MaterialPropertyBlock.GetMatrix(nameID) end

--
--Get a texture from the property block.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@return Texture
function CS.UnityEngine.MaterialPropertyBlock.GetTexture(name) end

--
--Get a texture from the property block.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
---@return Texture
function CS.UnityEngine.MaterialPropertyBlock.GetTexture(nameID) end

--
--Get a float array from the property block.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
function CS.UnityEngine.MaterialPropertyBlock.GetFloatArray(name) end

--
--Get a float array from the property block.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
function CS.UnityEngine.MaterialPropertyBlock.GetFloatArray(nameID) end

--
--Get a vector array from the property block.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
function CS.UnityEngine.MaterialPropertyBlock.GetVectorArray(name) end

--
--Get a vector array from the property block.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
function CS.UnityEngine.MaterialPropertyBlock.GetVectorArray(nameID) end

--
--Get a matrix array from the property block.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
function CS.UnityEngine.MaterialPropertyBlock.GetMatrixArray(name) end

--
--Get a matrix array from the property block.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
function CS.UnityEngine.MaterialPropertyBlock.GetMatrixArray(nameID) end

---@source UnityEngine.CoreModule.dll
---@param name string
---@param values System.Collections.Generic.List<float>
function CS.UnityEngine.MaterialPropertyBlock.GetFloatArray(name, values) end

---@source UnityEngine.CoreModule.dll
---@param nameID int
---@param values System.Collections.Generic.List<float>
function CS.UnityEngine.MaterialPropertyBlock.GetFloatArray(nameID, values) end

---@source UnityEngine.CoreModule.dll
---@param name string
---@param values System.Collections.Generic.List<UnityEngine.Vector4>
function CS.UnityEngine.MaterialPropertyBlock.GetVectorArray(name, values) end

---@source UnityEngine.CoreModule.dll
---@param nameID int
---@param values System.Collections.Generic.List<UnityEngine.Vector4>
function CS.UnityEngine.MaterialPropertyBlock.GetVectorArray(nameID, values) end

---@source UnityEngine.CoreModule.dll
---@param name string
---@param values System.Collections.Generic.List<UnityEngine.Matrix4x4>
function CS.UnityEngine.MaterialPropertyBlock.GetMatrixArray(name, values) end

---@source UnityEngine.CoreModule.dll
---@param nameID int
---@param values System.Collections.Generic.List<UnityEngine.Matrix4x4>
function CS.UnityEngine.MaterialPropertyBlock.GetMatrixArray(nameID, values) end

---@source UnityEngine.CoreModule.dll
---@param lightProbes System.Collections.Generic.List<UnityEngine.Rendering.SphericalHarmonicsL2>
function CS.UnityEngine.MaterialPropertyBlock.CopySHCoefficientArraysFrom(lightProbes) end

--
--This function converts and copies the entire source array into 7 Vector4 property arrays named unity_SHAr, unity_SHAg, unity_SHAb, unity_SHBr, unity_SHBg, unity_SHBb and unity_SHC for use with instanced rendering.
--
--```plaintext
--Params: lightProbes - The array of SH values to copy from.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param lightProbes UnityEngine.Rendering.SphericalHarmonicsL2[]
function CS.UnityEngine.MaterialPropertyBlock.CopySHCoefficientArraysFrom(lightProbes) end

---@source UnityEngine.CoreModule.dll
---@param lightProbes System.Collections.Generic.List<UnityEngine.Rendering.SphericalHarmonicsL2>
---@param sourceStart int
---@param destStart int
---@param count int
function CS.UnityEngine.MaterialPropertyBlock.CopySHCoefficientArraysFrom(lightProbes, sourceStart, destStart, count) end

--
--This function converts and copies the source array into 7 Vector4 property arrays named unity_SHAr, unity_SHAg, unity_SHAb, unity_SHBr, unity_SHBg, unity_SHBb and unity_SHC with the specified source and destination range for use with instanced rendering.
--
--```plaintext
--Params: lightProbes - The array of SH values to copy from.
--        sourceStart - The index of the first element in the source array to copy from.
--        destStart - The index of the first element in the destination MaterialPropertyBlock array to copy to.
--        count - The number of elements to copy.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param lightProbes UnityEngine.Rendering.SphericalHarmonicsL2[]
---@param sourceStart int
---@param destStart int
---@param count int
function CS.UnityEngine.MaterialPropertyBlock.CopySHCoefficientArraysFrom(lightProbes, sourceStart, destStart, count) end

---@source UnityEngine.CoreModule.dll
---@param occlusionProbes System.Collections.Generic.List<UnityEngine.Vector4>
function CS.UnityEngine.MaterialPropertyBlock.CopyProbeOcclusionArrayFrom(occlusionProbes) end

--
--This function copies the entire source array into a Vector4 property array named unity_ProbesOcclusion for use with instanced rendering.
--
--```plaintext
--Params: occlusionProbes - The array of probe occlusion values to copy from.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param occlusionProbes UnityEngine.Vector4[]
function CS.UnityEngine.MaterialPropertyBlock.CopyProbeOcclusionArrayFrom(occlusionProbes) end

---@source UnityEngine.CoreModule.dll
---@param occlusionProbes System.Collections.Generic.List<UnityEngine.Vector4>
---@param sourceStart int
---@param destStart int
---@param count int
function CS.UnityEngine.MaterialPropertyBlock.CopyProbeOcclusionArrayFrom(occlusionProbes, sourceStart, destStart, count) end

--
--This function copies the source array into a Vector4 property array named unity_ProbesOcclusion with the specified source and destination range for use with instanced rendering.
--
--```plaintext
--Params: occlusionProbes - The array of probe occlusion values to copy from.
--        sourceStart - The index of the first element in the source array to copy from.
--        destStart - The index of the first element in the destination MaterialPropertyBlock array to copy to.
--        count - The number of elements to copy.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param occlusionProbes UnityEngine.Vector4[]
---@param sourceStart int
---@param destStart int
---@param count int
function CS.UnityEngine.MaterialPropertyBlock.CopyProbeOcclusionArrayFrom(occlusionProbes, sourceStart, destStart, count) end


--
--The type of a Light.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.LightType: System.Enum
--
--The light is a spot light.
--
---@source UnityEngine.CoreModule.dll
---@field Spot UnityEngine.LightType
--
--The light is a directional light.
--
---@source UnityEngine.CoreModule.dll
---@field Directional UnityEngine.LightType
--
--The light is a point light.
--
---@source UnityEngine.CoreModule.dll
---@field Point UnityEngine.LightType
---@source UnityEngine.CoreModule.dll
---@field Area UnityEngine.LightType
--
--The light is a rectangle shaped area light. It affects only baked lightmaps and lightprobes.
--
---@source UnityEngine.CoreModule.dll
---@field Rectangle UnityEngine.LightType
--
--The light is a disc shaped area light. It affects only baked lightmaps and lightprobes.
--
---@source UnityEngine.CoreModule.dll
---@field Disc UnityEngine.LightType
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.LightType = {}

---@source 
---@param value any
---@return UnityEngine.LightType
function CS.UnityEngine.LightType:__CastFrom(value) end


--
--The Render Settings contain values for a range of visual elements in your Scene, like fog and ambient light.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.RenderSettings: UnityEngine.Object
---@source UnityEngine.CoreModule.dll
---@field ambientSkyboxAmount float
--
--Is fog enabled?
--
---@source UnityEngine.CoreModule.dll
---@field fog bool
--
--The starting distance of linear fog.
--
---@source UnityEngine.CoreModule.dll
---@field fogStartDistance float
--
--The ending distance of linear fog.
--
---@source UnityEngine.CoreModule.dll
---@field fogEndDistance float
--
--Fog mode to use.
--
---@source UnityEngine.CoreModule.dll
---@field fogMode UnityEngine.FogMode
--
--The color of the fog.
--
---@source UnityEngine.CoreModule.dll
---@field fogColor UnityEngine.Color
--
--The density of the exponential fog.
--
---@source UnityEngine.CoreModule.dll
---@field fogDensity float
--
--Ambient lighting mode.
--
---@source UnityEngine.CoreModule.dll
---@field ambientMode UnityEngine.Rendering.AmbientMode
--
--Ambient lighting coming from above.
--
---@source UnityEngine.CoreModule.dll
---@field ambientSkyColor UnityEngine.Color
--
--Ambient lighting coming from the sides.
--
---@source UnityEngine.CoreModule.dll
---@field ambientEquatorColor UnityEngine.Color
--
--Ambient lighting coming from below.
--
---@source UnityEngine.CoreModule.dll
---@field ambientGroundColor UnityEngine.Color
--
--How much the light from the Ambient Source affects the Scene.
--
---@source UnityEngine.CoreModule.dll
---@field ambientIntensity float
--
--Flat ambient lighting color.
--
---@source UnityEngine.CoreModule.dll
---@field ambientLight UnityEngine.Color
--
--The color used for the sun shadows in the Subtractive lightmode.
--
---@source UnityEngine.CoreModule.dll
---@field subtractiveShadowColor UnityEngine.Color
--
--The global skybox to use.
--
---@source UnityEngine.CoreModule.dll
---@field skybox UnityEngine.Material
--
--The light used by the procedural skybox.
--
---@source UnityEngine.CoreModule.dll
---@field sun UnityEngine.Light
--
--Custom or skybox ambient lighting data.
--
---@source UnityEngine.CoreModule.dll
---@field ambientProbe UnityEngine.Rendering.SphericalHarmonicsL2
--
--Custom specular reflection cubemap.
--
---@source UnityEngine.CoreModule.dll
---@field customReflection UnityEngine.Cubemap
--
--How much the skybox / custom cubemap reflection affects the Scene.
--
---@source UnityEngine.CoreModule.dll
---@field reflectionIntensity float
--
--The number of times a reflection includes other reflections.
--
---@source UnityEngine.CoreModule.dll
---@field reflectionBounces int
--
--Default reflection mode.
--
---@source UnityEngine.CoreModule.dll
---@field defaultReflectionMode UnityEngine.Rendering.DefaultReflectionMode
--
--Cubemap resolution for default reflection.
--
---@source UnityEngine.CoreModule.dll
---@field defaultReflectionResolution int
--
--Size of the Light halos.
--
---@source UnityEngine.CoreModule.dll
---@field haloStrength float
--
--The intensity of all flares in the Scene.
--
---@source UnityEngine.CoreModule.dll
---@field flareStrength float
--
--The fade speed of all flares in the Scene.
--
---@source UnityEngine.CoreModule.dll
---@field flareFadeSpeed float
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.RenderSettings = {}


--
--Describes the shape of a spot light.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.LightShape: System.Enum
--
--The shape of the spot light resembles a cone. This is the default shape for spot lights.
--
---@source UnityEngine.CoreModule.dll
---@field Cone UnityEngine.LightShape
--
--The shape of the spotlight resembles a pyramid or frustum. You can use this to simulate a screening or barn door effect on a normal spotlight.
--
---@source UnityEngine.CoreModule.dll
---@field Pyramid UnityEngine.LightShape
--
--The shape of the spot light resembles a box oriented along the ray direction.
--
---@source UnityEngine.CoreModule.dll
---@field Box UnityEngine.LightShape
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.LightShape = {}

---@source 
---@param value any
---@return UnityEngine.LightShape
function CS.UnityEngine.LightShape:__CastFrom(value) end


--
--The material class.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.Material: UnityEngine.Object
--
--The shader used by the material.
--
---@source UnityEngine.CoreModule.dll
---@field shader UnityEngine.Shader
--
--The main color of the Material.
--
---@source UnityEngine.CoreModule.dll
---@field color UnityEngine.Color
--
--The main texture.
--
---@source UnityEngine.CoreModule.dll
---@field mainTexture UnityEngine.Texture
--
--The offset of the main texture.
--
---@source UnityEngine.CoreModule.dll
---@field mainTextureOffset UnityEngine.Vector2
--
--The scale of the main texture.
--
---@source UnityEngine.CoreModule.dll
---@field mainTextureScale UnityEngine.Vector2
--
--Render queue of this material.
--
---@source UnityEngine.CoreModule.dll
---@field renderQueue int
--
--Defines how the material should interact with lightmaps and lightprobes.
--
---@source UnityEngine.CoreModule.dll
---@field globalIlluminationFlags UnityEngine.MaterialGlobalIlluminationFlags
--
--Gets and sets whether the Double Sided Global Illumination setting is enabled for this material.
--
---@source UnityEngine.CoreModule.dll
---@field doubleSidedGI bool
--
--Gets and sets whether GPU instancing is enabled for this material.
--
---@source UnityEngine.CoreModule.dll
---@field enableInstancing bool
--
--How many passes are in this material (Read Only).
--
---@source UnityEngine.CoreModule.dll
---@field passCount int
--
--An array containing the names of the local shader keywords that are currently enabled for this material.
--
---@source UnityEngine.CoreModule.dll
---@field shaderKeywords string[]
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.Material = {}

---@source UnityEngine.CoreModule.dll
---@param scriptContents string
---@return Material
function CS.UnityEngine.Material:Create(scriptContents) end

--
--Checks if material's shader has a property of a given name.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
---@return Boolean
function CS.UnityEngine.Material.HasProperty(nameID) end

--
--Checks if material's shader has a property of a given name.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@return Boolean
function CS.UnityEngine.Material.HasProperty(name) end

--
--Enables a local shader keyword for this material.
--
--```plaintext
--Params: keyword - The name of the local shader keyword to enable.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param keyword string
function CS.UnityEngine.Material.EnableKeyword(keyword) end

--
--Disables a local shader keyword for this material.
--
--```plaintext
--Params: keyword - The name of the local shader keyword to disable.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param keyword string
function CS.UnityEngine.Material.DisableKeyword(keyword) end

--
--Returns true if the given local shader keyword is enabled for this material. Otherwise, returns false.
--
--```plaintext
--Params: keyword - The name of the local shader keyword to check.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param keyword string
---@return Boolean
function CS.UnityEngine.Material.IsKeywordEnabled(keyword) end

--
--Enables or disables a Shader pass on a per-Material level.
--
--```plaintext
--Params: passName - Shader pass name (case insensitive).
--        enabled - Flag indicating whether this Shader pass should be enabled.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param passName string
---@param enabled bool
function CS.UnityEngine.Material.SetShaderPassEnabled(passName, enabled) end

--
--True if the Shader pass is enabled.
--
--```plaintext
--Params: passName - Shader pass name (case insensitive).
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param passName string
---@return Boolean
function CS.UnityEngine.Material.GetShaderPassEnabled(passName) end

--
--Returns the name of the shader pass at index pass.
--
---@source UnityEngine.CoreModule.dll
---@param pass int
---@return String
function CS.UnityEngine.Material.GetPassName(pass) end

--
--Returns the index of the pass passName.
--
---@source UnityEngine.CoreModule.dll
---@param passName string
---@return Int32
function CS.UnityEngine.Material.FindPass(passName) end

--
--Sets an override tag/value on the material.
--
--```plaintext
--Params: tag - Name of the tag to set.
--        val - Name of the value to set. Empty string to clear the override flag.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param tag string
---@param val string
function CS.UnityEngine.Material.SetOverrideTag(tag, val) end

--
--Get the value of material's shader tag.
--
---@source UnityEngine.CoreModule.dll
---@param tag string
---@param searchFallbacks bool
---@param defaultValue string
---@return String
function CS.UnityEngine.Material.GetTag(tag, searchFallbacks, defaultValue) end

--
--Get the value of material's shader tag.
--
---@source UnityEngine.CoreModule.dll
---@param tag string
---@param searchFallbacks bool
---@return String
function CS.UnityEngine.Material.GetTag(tag, searchFallbacks) end

--
--Interpolate properties between two materials.
--
---@source UnityEngine.CoreModule.dll
---@param start UnityEngine.Material
---@param end UnityEngine.Material
---@param t float
function CS.UnityEngine.Material.Lerp(start, end, t) end

--
--If false is returned, no rendering should be done.
--
--```plaintext
--Params: pass - Shader pass number to setup.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param pass int
---@return Boolean
function CS.UnityEngine.Material.SetPass(pass) end

--
--Copy properties from other material into this material.
--
---@source UnityEngine.CoreModule.dll
---@param mat UnityEngine.Material
function CS.UnityEngine.Material.CopyPropertiesFromMaterial(mat) end

--
--Computes a CRC hash value from the content of the material.
--
---@source UnityEngine.CoreModule.dll
---@return Int32
function CS.UnityEngine.Material.ComputeCRC() end

--
--Names of all texture properties exposed on this material.
--
--```plaintext
--Params: outNames - Names of all texture properties exposed on this material.
--        
--```
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.Material.GetTexturePropertyNames() end

--
--IDs of all texture properties exposed on this material.
--
--```plaintext
--Params: outNames - IDs of all texture properties exposed on this material.
--        
--```
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.Material.GetTexturePropertyNameIDs() end

---@source UnityEngine.CoreModule.dll
---@param outNames System.Collections.Generic.List<string>
function CS.UnityEngine.Material.GetTexturePropertyNames(outNames) end

---@source UnityEngine.CoreModule.dll
---@param outNames System.Collections.Generic.List<int>
function CS.UnityEngine.Material.GetTexturePropertyNameIDs(outNames) end

--
--Sets a named float value.
--
--```plaintext
--Params: nameID - Property name ID, use Shader.PropertyToID to get it.
--        value - Float value to set.
--        name - Property name, e.g. "_Glossiness".
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@param value float
function CS.UnityEngine.Material.SetFloat(name, value) end

--
--Sets a named float value.
--
--```plaintext
--Params: nameID - Property name ID, use Shader.PropertyToID to get it.
--        value - Float value to set.
--        name - Property name, e.g. "_Glossiness".
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
---@param value float
function CS.UnityEngine.Material.SetFloat(nameID, value) end

--
--Sets a named integer value.
--
--```plaintext
--Params: nameID - Property name ID, use Shader.PropertyToID to get it.
--        value - Integer value to set.
--        name - Property name, e.g. "_SrcBlend".
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@param value int
function CS.UnityEngine.Material.SetInt(name, value) end

--
--Sets a named integer value.
--
--```plaintext
--Params: nameID - Property name ID, use Shader.PropertyToID to get it.
--        value - Integer value to set.
--        name - Property name, e.g. "_SrcBlend".
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
---@param value int
function CS.UnityEngine.Material.SetInt(nameID, value) end

--
--Sets a named color value.
--
--```plaintext
--Params: nameID - Property name ID, use Shader.PropertyToID to get it.
--        name - Property name, e.g. "_Color".
--        value - Color value to set.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@param value UnityEngine.Color
function CS.UnityEngine.Material.SetColor(name, value) end

--
--Sets a named color value.
--
--```plaintext
--Params: nameID - Property name ID, use Shader.PropertyToID to get it.
--        name - Property name, e.g. "_Color".
--        value - Color value to set.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
---@param value UnityEngine.Color
function CS.UnityEngine.Material.SetColor(nameID, value) end

--
--Sets a named vector value.
--
--```plaintext
--Params: nameID - Property name ID, use Shader.PropertyToID to get it.
--        name - Property name, e.g. "_WaveAndDistance".
--        value - Vector value to set.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@param value UnityEngine.Vector4
function CS.UnityEngine.Material.SetVector(name, value) end

--
--Sets a named vector value.
--
--```plaintext
--Params: nameID - Property name ID, use Shader.PropertyToID to get it.
--        name - Property name, e.g. "_WaveAndDistance".
--        value - Vector value to set.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
---@param value UnityEngine.Vector4
function CS.UnityEngine.Material.SetVector(nameID, value) end

--
--Sets a named matrix for the shader.
--
--```plaintext
--Params: nameID - Property name ID, use Shader.PropertyToID to get it.
--        name - Property name, e.g. "_CubemapRotation".
--        value - Matrix value to set.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@param value UnityEngine.Matrix4x4
function CS.UnityEngine.Material.SetMatrix(name, value) end

--
--Sets a named matrix for the shader.
--
--```plaintext
--Params: nameID - Property name ID, use Shader.PropertyToID to get it.
--        name - Property name, e.g. "_CubemapRotation".
--        value - Matrix value to set.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
---@param value UnityEngine.Matrix4x4
function CS.UnityEngine.Material.SetMatrix(nameID, value) end

--
--Sets a named texture.
--
--```plaintext
--Params: nameID - Property name ID, use Shader.PropertyToID to get it.
--        name - Property name, e.g. "_MainTex".
--        value - Texture to set.
--        element - Optional parameter that specifies the type of data to set from the RenderTexture.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@param value UnityEngine.Texture
function CS.UnityEngine.Material.SetTexture(name, value) end

--
--Sets a named texture.
--
--```plaintext
--Params: nameID - Property name ID, use Shader.PropertyToID to get it.
--        name - Property name, e.g. "_MainTex".
--        value - Texture to set.
--        element - Optional parameter that specifies the type of data to set from the RenderTexture.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
---@param value UnityEngine.Texture
function CS.UnityEngine.Material.SetTexture(nameID, value) end

--
--Sets a named texture.
--
--```plaintext
--Params: nameID - Property name ID, use Shader.PropertyToID to get it.
--        name - Property name, e.g. "_MainTex".
--        value - Texture to set.
--        element - Optional parameter that specifies the type of data to set from the RenderTexture.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@param value UnityEngine.RenderTexture
---@param element UnityEngine.Rendering.RenderTextureSubElement
function CS.UnityEngine.Material.SetTexture(name, value, element) end

--
--Sets a named texture.
--
--```plaintext
--Params: nameID - Property name ID, use Shader.PropertyToID to get it.
--        name - Property name, e.g. "_MainTex".
--        value - Texture to set.
--        element - Optional parameter that specifies the type of data to set from the RenderTexture.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
---@param value UnityEngine.RenderTexture
---@param element UnityEngine.Rendering.RenderTextureSubElement
function CS.UnityEngine.Material.SetTexture(nameID, value, element) end

--
--Sets a named buffer value.
--
--```plaintext
--Params: nameID - Property name ID, use Shader.PropertyToID to get it.
--        name - Property name.
--        value - The ComputeBuffer or GraphicsBuffer value to set.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@param value UnityEngine.ComputeBuffer
function CS.UnityEngine.Material.SetBuffer(name, value) end

--
--Sets a named buffer value.
--
--```plaintext
--Params: nameID - Property name ID, use Shader.PropertyToID to get it.
--        name - Property name.
--        value - The ComputeBuffer or GraphicsBuffer value to set.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
---@param value UnityEngine.ComputeBuffer
function CS.UnityEngine.Material.SetBuffer(nameID, value) end

--
--Sets a named buffer value.
--
--```plaintext
--Params: nameID - Property name ID, use Shader.PropertyToID to get it.
--        name - Property name.
--        value - The ComputeBuffer or GraphicsBuffer value to set.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@param value UnityEngine.GraphicsBuffer
function CS.UnityEngine.Material.SetBuffer(name, value) end

--
--Sets a named buffer value.
--
--```plaintext
--Params: nameID - Property name ID, use Shader.PropertyToID to get it.
--        name - Property name.
--        value - The ComputeBuffer or GraphicsBuffer value to set.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
---@param value UnityEngine.GraphicsBuffer
function CS.UnityEngine.Material.SetBuffer(nameID, value) end

--
--Sets a ComputeBuffer or GraphicsBuffer as a named constant buffer for the material.
--
--```plaintext
--Params: name - The name of the constant buffer to override.
--        value - The ComputeBuffer to override the constant buffer values with, or null to remove binding.
--        offset - Offset in bytes from the beginning of the buffer to bind. Must be a multiple of SystemInfo.constantBufferOffsetAlignment, or 0 if that value is 0.
--        size - The number of bytes to bind.
--        nameID - The shader property ID of the constant buffer to override.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@param value UnityEngine.ComputeBuffer
---@param offset int
---@param size int
function CS.UnityEngine.Material.SetConstantBuffer(name, value, offset, size) end

--
--Sets a ComputeBuffer or GraphicsBuffer as a named constant buffer for the material.
--
--```plaintext
--Params: name - The name of the constant buffer to override.
--        value - The ComputeBuffer to override the constant buffer values with, or null to remove binding.
--        offset - Offset in bytes from the beginning of the buffer to bind. Must be a multiple of SystemInfo.constantBufferOffsetAlignment, or 0 if that value is 0.
--        size - The number of bytes to bind.
--        nameID - The shader property ID of the constant buffer to override.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
---@param value UnityEngine.ComputeBuffer
---@param offset int
---@param size int
function CS.UnityEngine.Material.SetConstantBuffer(nameID, value, offset, size) end

--
--Sets a ComputeBuffer or GraphicsBuffer as a named constant buffer for the material.
--
--```plaintext
--Params: name - The name of the constant buffer to override.
--        value - The ComputeBuffer to override the constant buffer values with, or null to remove binding.
--        offset - Offset in bytes from the beginning of the buffer to bind. Must be a multiple of SystemInfo.constantBufferOffsetAlignment, or 0 if that value is 0.
--        size - The number of bytes to bind.
--        nameID - The shader property ID of the constant buffer to override.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@param value UnityEngine.GraphicsBuffer
---@param offset int
---@param size int
function CS.UnityEngine.Material.SetConstantBuffer(name, value, offset, size) end

--
--Sets a ComputeBuffer or GraphicsBuffer as a named constant buffer for the material.
--
--```plaintext
--Params: name - The name of the constant buffer to override.
--        value - The ComputeBuffer to override the constant buffer values with, or null to remove binding.
--        offset - Offset in bytes from the beginning of the buffer to bind. Must be a multiple of SystemInfo.constantBufferOffsetAlignment, or 0 if that value is 0.
--        size - The number of bytes to bind.
--        nameID - The shader property ID of the constant buffer to override.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
---@param value UnityEngine.GraphicsBuffer
---@param offset int
---@param size int
function CS.UnityEngine.Material.SetConstantBuffer(nameID, value, offset, size) end

---@source UnityEngine.CoreModule.dll
---@param name string
---@param values System.Collections.Generic.List<float>
function CS.UnityEngine.Material.SetFloatArray(name, values) end

---@source UnityEngine.CoreModule.dll
---@param nameID int
---@param values System.Collections.Generic.List<float>
function CS.UnityEngine.Material.SetFloatArray(nameID, values) end

--
--Sets a float array property.
--
--```plaintext
--Params: name - Property name.
--        nameID - Property name ID. Use Shader.PropertyToID to get this ID.
--        values - Array of values to set.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@param values float[]
function CS.UnityEngine.Material.SetFloatArray(name, values) end

--
--Sets a float array property.
--
--```plaintext
--Params: name - Property name.
--        nameID - Property name ID. Use Shader.PropertyToID to get this ID.
--        values - Array of values to set.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
---@param values float[]
function CS.UnityEngine.Material.SetFloatArray(nameID, values) end

---@source UnityEngine.CoreModule.dll
---@param name string
---@param values System.Collections.Generic.List<UnityEngine.Color>
function CS.UnityEngine.Material.SetColorArray(name, values) end

---@source UnityEngine.CoreModule.dll
---@param nameID int
---@param values System.Collections.Generic.List<UnityEngine.Color>
function CS.UnityEngine.Material.SetColorArray(nameID, values) end

--
--Sets a color array property.
--
--```plaintext
--Params: name - Property name.
--        nameID - Property name ID, use Shader.PropertyToID to get it.
--        values - Array of values to set.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@param values UnityEngine.Color[]
function CS.UnityEngine.Material.SetColorArray(name, values) end

--
--Sets a color array property.
--
--```plaintext
--Params: name - Property name.
--        nameID - Property name ID, use Shader.PropertyToID to get it.
--        values - Array of values to set.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
---@param values UnityEngine.Color[]
function CS.UnityEngine.Material.SetColorArray(nameID, values) end

---@source UnityEngine.CoreModule.dll
---@param name string
---@param values System.Collections.Generic.List<UnityEngine.Vector4>
function CS.UnityEngine.Material.SetVectorArray(name, values) end

---@source UnityEngine.CoreModule.dll
---@param nameID int
---@param values System.Collections.Generic.List<UnityEngine.Vector4>
function CS.UnityEngine.Material.SetVectorArray(nameID, values) end

--
--Sets a vector array property.
--
--```plaintext
--Params: name - Property name.
--        values - Array of values to set.
--        nameID - Property name ID, use Shader.PropertyToID to get it.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@param values UnityEngine.Vector4[]
function CS.UnityEngine.Material.SetVectorArray(name, values) end

--
--Sets a vector array property.
--
--```plaintext
--Params: name - Property name.
--        values - Array of values to set.
--        nameID - Property name ID, use Shader.PropertyToID to get it.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
---@param values UnityEngine.Vector4[]
function CS.UnityEngine.Material.SetVectorArray(nameID, values) end

---@source UnityEngine.CoreModule.dll
---@param name string
---@param values System.Collections.Generic.List<UnityEngine.Matrix4x4>
function CS.UnityEngine.Material.SetMatrixArray(name, values) end

---@source UnityEngine.CoreModule.dll
---@param nameID int
---@param values System.Collections.Generic.List<UnityEngine.Matrix4x4>
function CS.UnityEngine.Material.SetMatrixArray(nameID, values) end

--
--Sets a matrix array property.
--
--```plaintext
--Params: name - Property name.
--        values - Array of values to set.
--        nameID - Property name ID, use Shader.PropertyToID to get it.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@param values UnityEngine.Matrix4x4[]
function CS.UnityEngine.Material.SetMatrixArray(name, values) end

--
--Sets a matrix array property.
--
--```plaintext
--Params: name - Property name.
--        values - Array of values to set.
--        nameID - Property name ID, use Shader.PropertyToID to get it.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
---@param values UnityEngine.Matrix4x4[]
function CS.UnityEngine.Material.SetMatrixArray(nameID, values) end

--
--Get a named float value.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@return Single
function CS.UnityEngine.Material.GetFloat(name) end

--
--Get a named float value.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
---@return Single
function CS.UnityEngine.Material.GetFloat(nameID) end

--
--Get a named integer value.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@return Int32
function CS.UnityEngine.Material.GetInt(name) end

--
--Get a named integer value.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
---@return Int32
function CS.UnityEngine.Material.GetInt(nameID) end

--
--Get a named color value.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@return Color
function CS.UnityEngine.Material.GetColor(name) end

--
--Get a named color value.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
---@return Color
function CS.UnityEngine.Material.GetColor(nameID) end

--
--Get a named vector value.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@return Vector4
function CS.UnityEngine.Material.GetVector(name) end

--
--Get a named vector value.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
---@return Vector4
function CS.UnityEngine.Material.GetVector(nameID) end

--
--Get a named matrix value from the shader.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@return Matrix4x4
function CS.UnityEngine.Material.GetMatrix(name) end

--
--Get a named matrix value from the shader.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
---@return Matrix4x4
function CS.UnityEngine.Material.GetMatrix(nameID) end

--
--Get a named texture.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@return Texture
function CS.UnityEngine.Material.GetTexture(name) end

--
--Get a named texture.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
---@return Texture
function CS.UnityEngine.Material.GetTexture(nameID) end

--
--Get a named float array.
--
--```plaintext
--Params: name - The name of the property.
--        nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
function CS.UnityEngine.Material.GetFloatArray(name) end

--
--Get a named float array.
--
--```plaintext
--Params: name - The name of the property.
--        nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
function CS.UnityEngine.Material.GetFloatArray(nameID) end

--
--Get a named color array.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
function CS.UnityEngine.Material.GetColorArray(name) end

--
--Get a named color array.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
function CS.UnityEngine.Material.GetColorArray(nameID) end

--
--Get a named vector array.
--
--```plaintext
--Params: name - The name of the property.
--        nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
function CS.UnityEngine.Material.GetVectorArray(name) end

--
--Get a named vector array.
--
--```plaintext
--Params: name - The name of the property.
--        nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
function CS.UnityEngine.Material.GetVectorArray(nameID) end

--
--Get a named matrix array.
--
--```plaintext
--Params: name - The name of the property.
--        nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
function CS.UnityEngine.Material.GetMatrixArray(name) end

--
--Get a named matrix array.
--
--```plaintext
--Params: name - The name of the property.
--        nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
function CS.UnityEngine.Material.GetMatrixArray(nameID) end

---@source UnityEngine.CoreModule.dll
---@param name string
---@param values System.Collections.Generic.List<float>
function CS.UnityEngine.Material.GetFloatArray(name, values) end

---@source UnityEngine.CoreModule.dll
---@param nameID int
---@param values System.Collections.Generic.List<float>
function CS.UnityEngine.Material.GetFloatArray(nameID, values) end

---@source UnityEngine.CoreModule.dll
---@param name string
---@param values System.Collections.Generic.List<UnityEngine.Color>
function CS.UnityEngine.Material.GetColorArray(name, values) end

---@source UnityEngine.CoreModule.dll
---@param nameID int
---@param values System.Collections.Generic.List<UnityEngine.Color>
function CS.UnityEngine.Material.GetColorArray(nameID, values) end

---@source UnityEngine.CoreModule.dll
---@param name string
---@param values System.Collections.Generic.List<UnityEngine.Vector4>
function CS.UnityEngine.Material.GetVectorArray(name, values) end

---@source UnityEngine.CoreModule.dll
---@param nameID int
---@param values System.Collections.Generic.List<UnityEngine.Vector4>
function CS.UnityEngine.Material.GetVectorArray(nameID, values) end

---@source UnityEngine.CoreModule.dll
---@param name string
---@param values System.Collections.Generic.List<UnityEngine.Matrix4x4>
function CS.UnityEngine.Material.GetMatrixArray(name, values) end

---@source UnityEngine.CoreModule.dll
---@param nameID int
---@param values System.Collections.Generic.List<UnityEngine.Matrix4x4>
function CS.UnityEngine.Material.GetMatrixArray(nameID, values) end

--
--Sets the placement offset of texture propertyName.
--
--```plaintext
--Params: nameID - Property name ID, use Shader.PropertyToID to get it.
--        name - Property name, for example: "_MainTex".
--        value - Texture placement offset.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@param value UnityEngine.Vector2
function CS.UnityEngine.Material.SetTextureOffset(name, value) end

--
--Sets the placement offset of texture propertyName.
--
--```plaintext
--Params: nameID - Property name ID, use Shader.PropertyToID to get it.
--        name - Property name, for example: "_MainTex".
--        value - Texture placement offset.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
---@param value UnityEngine.Vector2
function CS.UnityEngine.Material.SetTextureOffset(nameID, value) end

--
--Sets the placement scale of texture propertyName.
--
--```plaintext
--Params: nameID - Property name ID, use Shader.PropertyToID to get it.
--        name - Property name, e.g. "_MainTex".
--        value - Texture placement scale.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@param value UnityEngine.Vector2
function CS.UnityEngine.Material.SetTextureScale(name, value) end

--
--Sets the placement scale of texture propertyName.
--
--```plaintext
--Params: nameID - Property name ID, use Shader.PropertyToID to get it.
--        name - Property name, e.g. "_MainTex".
--        value - Texture placement scale.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
---@param value UnityEngine.Vector2
function CS.UnityEngine.Material.SetTextureScale(nameID, value) end

--
--Gets the placement offset of texture propertyName.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@return Vector2
function CS.UnityEngine.Material.GetTextureOffset(name) end

--
--Gets the placement offset of texture propertyName.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
---@return Vector2
function CS.UnityEngine.Material.GetTextureOffset(nameID) end

--
--Gets the placement scale of texture propertyName.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param name string
---@return Vector2
function CS.UnityEngine.Material.GetTextureScale(name) end

--
--Gets the placement scale of texture propertyName.
--
--```plaintext
--Params: nameID - The name ID of the property retrieved by Shader.PropertyToID.
--        name - The name of the property.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nameID int
---@return Vector2
function CS.UnityEngine.Material.GetTextureScale(nameID) end


--
--How the Light is rendered.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.LightRenderMode: System.Enum
--
--Automatically choose the render mode.
--
---@source UnityEngine.CoreModule.dll
---@field Auto UnityEngine.LightRenderMode
--
--Force the Light to be a pixel light.
--
---@source UnityEngine.CoreModule.dll
---@field ForcePixel UnityEngine.LightRenderMode
--
--Force the Light to be a vertex light.
--
---@source UnityEngine.CoreModule.dll
---@field ForceVertex UnityEngine.LightRenderMode
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.LightRenderMode = {}

---@source 
---@param value any
---@return UnityEngine.LightRenderMode
function CS.UnityEngine.LightRenderMode:__CastFrom(value) end


--
--GPU graphics data buffer, for working with data such as vertex and index buffers.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.GraphicsBuffer: object
--
--Number of elements in the buffer (Read Only).
--
---@source UnityEngine.CoreModule.dll
---@field count int
--
--Size of one element in the buffer (Read Only).
--
---@source UnityEngine.CoreModule.dll
---@field stride int
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.GraphicsBuffer = {}

---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.GraphicsBuffer.Dispose() end

--
--Release a Graphics Buffer.
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.GraphicsBuffer.Release() end

--
--Returns true if this graphics buffer is valid, or false otherwise.
--
---@source UnityEngine.CoreModule.dll
---@return Boolean
function CS.UnityEngine.GraphicsBuffer.IsValid() end

--
--Set the buffer with values from an array.
--
--```plaintext
--Params: data - Array of values to fill the buffer.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param data System.Array
function CS.UnityEngine.GraphicsBuffer.SetData(data) end

---@source UnityEngine.CoreModule.dll
---@param data System.Collections.Generic.List<T>
function CS.UnityEngine.GraphicsBuffer.SetData(data) end

---@source UnityEngine.CoreModule.dll
---@param data Unity.Collections.NativeArray<T>
function CS.UnityEngine.GraphicsBuffer.SetData(data) end

--
--Partial copy of data values from an array into the buffer.
--
--```plaintext
--Params: data - Array of values to fill the buffer.
--        managedBufferStartIndex - The first element index in data to copy to the graphics buffer.
--        count - The number of elements to copy.
--        graphicsBufferStartIndex - The first element index in the graphics buffer to receive the data.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param data System.Array
---@param managedBufferStartIndex int
---@param graphicsBufferStartIndex int
---@param count int
function CS.UnityEngine.GraphicsBuffer.SetData(data, managedBufferStartIndex, graphicsBufferStartIndex, count) end

---@source UnityEngine.CoreModule.dll
---@param data System.Collections.Generic.List<T>
---@param managedBufferStartIndex int
---@param graphicsBufferStartIndex int
---@param count int
function CS.UnityEngine.GraphicsBuffer.SetData(data, managedBufferStartIndex, graphicsBufferStartIndex, count) end

---@source UnityEngine.CoreModule.dll
---@param data Unity.Collections.NativeArray<T>
---@param nativeBufferStartIndex int
---@param graphicsBufferStartIndex int
---@param count int
function CS.UnityEngine.GraphicsBuffer.SetData(data, nativeBufferStartIndex, graphicsBufferStartIndex, count) end

--
--Read data values from the buffer into an array. The array can only use <a href="https:docs.microsoft.comen-usdotnetframeworkinteropblittable-and-non-blittable-types">blittable<a> types.
--
--```plaintext
--Params: data - An array to receive the data.
--        managedBufferStartIndex - The first element index in data where retrieved elements are copied.
--        computeBufferStartIndex - The first element index of the buffer from which elements are read.
--        count - The number of elements to retrieve.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param data System.Array
function CS.UnityEngine.GraphicsBuffer.GetData(data) end

--
--Read data values from the buffer into an array. The array can only use <a href="https:docs.microsoft.comen-usdotnetframeworkinteropblittable-and-non-blittable-types">blittable<a> types.
--
--```plaintext
--Params: data - An array to receive the data.
--        managedBufferStartIndex - The first element index in data where retrieved elements are copied.
--        computeBufferStartIndex - The first element index of the buffer from which elements are read.
--        count - The number of elements to retrieve.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param data System.Array
---@param managedBufferStartIndex int
---@param computeBufferStartIndex int
---@param count int
function CS.UnityEngine.GraphicsBuffer.GetData(data, managedBufferStartIndex, computeBufferStartIndex, count) end

--
--Pointer to the underlying graphics API buffer.
--
---@source UnityEngine.CoreModule.dll
---@return IntPtr
function CS.UnityEngine.GraphicsBuffer.GetNativeBufferPtr() end

--
--Sets counter value of append/consume buffer.
--
--```plaintext
--Params: counterValue - Value of the append/consume counter.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param counterValue uint
function CS.UnityEngine.GraphicsBuffer.SetCounterValue(counterValue) end

--
--Copy counter value of append/consume buffer into another buffer.
--
---@source UnityEngine.CoreModule.dll
---@param src UnityEngine.ComputeBuffer
---@param dst UnityEngine.ComputeBuffer
---@param dstOffsetBytes int
function CS.UnityEngine.GraphicsBuffer:CopyCount(src, dst, dstOffsetBytes) end

--
--Copy counter value of append/consume buffer into another buffer.
--
---@source UnityEngine.CoreModule.dll
---@param src UnityEngine.GraphicsBuffer
---@param dst UnityEngine.ComputeBuffer
---@param dstOffsetBytes int
function CS.UnityEngine.GraphicsBuffer:CopyCount(src, dst, dstOffsetBytes) end

--
--Copy counter value of append/consume buffer into another buffer.
--
---@source UnityEngine.CoreModule.dll
---@param src UnityEngine.ComputeBuffer
---@param dst UnityEngine.GraphicsBuffer
---@param dstOffsetBytes int
function CS.UnityEngine.GraphicsBuffer:CopyCount(src, dst, dstOffsetBytes) end

--
--Copy counter value of append/consume buffer into another buffer.
--
---@source UnityEngine.CoreModule.dll
---@param src UnityEngine.GraphicsBuffer
---@param dst UnityEngine.GraphicsBuffer
---@param dstOffsetBytes int
function CS.UnityEngine.GraphicsBuffer:CopyCount(src, dst, dstOffsetBytes) end


--
--Shadow casting options for a Light.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.LightShadows: System.Enum
--
--Do not cast shadows (default).
--
---@source UnityEngine.CoreModule.dll
---@field None UnityEngine.LightShadows
--
--Cast "hard" shadows (with no shadow filtering).
--
---@source UnityEngine.CoreModule.dll
---@field Hard UnityEngine.LightShadows
--
--Cast "soft" shadows (with 4x PCF filtering).
--
---@source UnityEngine.CoreModule.dll
---@field Soft UnityEngine.LightShadows
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.LightShadows = {}

---@source 
---@param value any
---@return UnityEngine.LightShadows
function CS.UnityEngine.LightShadows:__CastFrom(value) end


--
--Fog mode to use.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.FogMode: System.Enum
--
--Linear fog.
--
---@source UnityEngine.CoreModule.dll
---@field Linear UnityEngine.FogMode
--
--Exponential fog.
--
---@source UnityEngine.CoreModule.dll
---@field Exponential UnityEngine.FogMode
--
--Exponential squared fog (default).
--
---@source UnityEngine.CoreModule.dll
---@field ExponentialSquared UnityEngine.FogMode
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.FogMode = {}

---@source 
---@param value any
---@return UnityEngine.FogMode
function CS.UnityEngine.FogMode:__CastFrom(value) end


--
--Enum describing what part of a light contribution can be baked.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.LightmapBakeType: System.Enum
--
--Realtime lights cast run time light and shadows. They can change position, orientation, color, brightness, and many other properties at run time. No lighting gets baked into lightmaps or light probes..
--
---@source UnityEngine.CoreModule.dll
---@field Realtime UnityEngine.LightmapBakeType
--
--Baked lights cannot move or change in any way during run time. All lighting for static objects gets baked into lightmaps. Lighting and shadows for dynamic objects gets baked into Light Probes.
--
---@source UnityEngine.CoreModule.dll
---@field Baked UnityEngine.LightmapBakeType
--
--Mixed lights allow a mix of realtime and baked lighting, based on the Mixed Lighting Mode used. These lights cannot move, but can change color and intensity at run time. Changes to color and intensity only affect direct lighting as indirect lighting gets baked. If using Subtractive mode, changes to color or intensity are not calculated at run time on static objects.
--
---@source UnityEngine.CoreModule.dll
---@field Mixed UnityEngine.LightmapBakeType
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.LightmapBakeType = {}

---@source 
---@param value any
---@return UnityEngine.LightmapBakeType
function CS.UnityEngine.LightmapBakeType:__CastFrom(value) end


--
--Enum describing what lighting mode to be used with Mixed lights.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.MixedLightingMode: System.Enum
--
--Mixed lights provide realtime direct lighting while indirect light is baked into lightmaps and light probes.
--
---@source UnityEngine.CoreModule.dll
---@field IndirectOnly UnityEngine.MixedLightingMode
--
--Mixed lights provide realtime direct lighting. Indirect lighting gets baked into lightmaps and light probes. Shadowmasks and light probe occlusion get generated for baked shadows. The Shadowmask Mode used at run time can be set in the Quality Settings panel.
--
---@source UnityEngine.CoreModule.dll
---@field Shadowmask UnityEngine.MixedLightingMode
--
--Mixed lights provide baked direct and indirect lighting for static objects. Dynamic objects receive realtime direct lighting and cast shadows on static objects using the main directional light in the Scene.
--
---@source UnityEngine.CoreModule.dll
---@field Subtractive UnityEngine.MixedLightingMode
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.MixedLightingMode = {}

---@source 
---@param value any
---@return UnityEngine.MixedLightingMode
function CS.UnityEngine.MixedLightingMode:__CastFrom(value) end


--
--This property only takes effect if you enable a global illumination setting such as for the GameObject associated with the target Mesh Renderer. Otherwise this property defaults to the Light Probes setting.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.ReceiveGI: System.Enum
--
--Makes the GameObject use lightmaps to receive Global Illumination.
--
---@source UnityEngine.CoreModule.dll
---@field Lightmaps UnityEngine.ReceiveGI
--
--The object will have the option to use Light Probes to receive Global Illumination. See Rendering.LightProbeUsage.
--
---@source UnityEngine.CoreModule.dll
---@field LightProbes UnityEngine.ReceiveGI
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.ReceiveGI = {}

---@source 
---@param value any
---@return UnityEngine.ReceiveGI
function CS.UnityEngine.ReceiveGI:__CastFrom(value) end


--
--The type of graphics buffer.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.Target: System.Enum
--
--GraphicsBuffer can be used to store vertex data.
--
---@source UnityEngine.CoreModule.dll
---@field Vertex UnityEngine.GraphicsBuffer.Target
--
--GraphicsBuffer can be used as an index buffer.
--
---@source UnityEngine.CoreModule.dll
---@field Index UnityEngine.GraphicsBuffer.Target
--
--GraphicsBuffer can be used as a structured buffer.
--
---@source UnityEngine.CoreModule.dll
---@field Structured UnityEngine.GraphicsBuffer.Target
--
--GraphicsBuffer can be used as a raw buffer (ByteAddressBuffer).
--
---@source UnityEngine.CoreModule.dll
---@field Raw UnityEngine.GraphicsBuffer.Target
--
--GraphicsBuffer can be used as an append-consume buffer.
--
---@source UnityEngine.CoreModule.dll
---@field Append UnityEngine.GraphicsBuffer.Target
--
--GraphicsBuffer with an internal counter. See Also: GraphicsBuffer.SetCounterValue and GraphicsBuffer.CopyCount.
--
---@source UnityEngine.CoreModule.dll
---@field Counter UnityEngine.GraphicsBuffer.Target
--
--GraphicsBuffer can be used as an indirect argument buffer for indirect draws and dispatches.
--
---@source UnityEngine.CoreModule.dll
---@field IndirectArguments UnityEngine.GraphicsBuffer.Target
--
--GraphicsBuffer can be used as a constant buffer.
--
---@source UnityEngine.CoreModule.dll
---@field Constant UnityEngine.GraphicsBuffer.Target
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.Target = {}

---@source 
---@param value any
---@return UnityEngine.GraphicsBuffer.Target
function CS.UnityEngine.Target:__CastFrom(value) end


---@source UnityEngine.CoreModule.dll
---@class UnityEngine.QualityLevel: System.Enum
---@source UnityEngine.CoreModule.dll
---@field Fastest UnityEngine.QualityLevel
---@source UnityEngine.CoreModule.dll
---@field Fast UnityEngine.QualityLevel
---@source UnityEngine.CoreModule.dll
---@field Simple UnityEngine.QualityLevel
---@source UnityEngine.CoreModule.dll
---@field Good UnityEngine.QualityLevel
---@source UnityEngine.CoreModule.dll
---@field Beautiful UnityEngine.QualityLevel
---@source UnityEngine.CoreModule.dll
---@field Fantastic UnityEngine.QualityLevel
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.QualityLevel = {}

---@source 
---@param value any
---@return UnityEngine.QualityLevel
function CS.UnityEngine.QualityLevel:__CastFrom(value) end


--
--The portal for dynamically changing occlusion at runtime.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.OcclusionPortal: UnityEngine.Component
--
--Gets / sets the portal's open state.
--
---@source UnityEngine.CoreModule.dll
---@field open bool
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.OcclusionPortal = {}


--
--Shadow projection type for.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.ShadowProjection: System.Enum
--
--Close fit shadow maps with linear fadeout.
--
---@source UnityEngine.CoreModule.dll
---@field CloseFit UnityEngine.ShadowProjection
--
--Stable shadow maps with spherical fadeout.
--
---@source UnityEngine.CoreModule.dll
---@field StableFit UnityEngine.ShadowProjection
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.ShadowProjection = {}

---@source 
---@param value any
---@return UnityEngine.ShadowProjection
function CS.UnityEngine.ShadowProjection:__CastFrom(value) end


--
--OcclusionArea is an area in which occlusion culling is performed.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.OcclusionArea: UnityEngine.Component
--
--Center of the occlusion area relative to the transform.
--
---@source UnityEngine.CoreModule.dll
---@field center UnityEngine.Vector3
--
--Size that the occlusion area will have.
--
---@source UnityEngine.CoreModule.dll
---@field size UnityEngine.Vector3
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.OcclusionArea = {}


--
--Determines which type of shadows should be used.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.ShadowQuality: System.Enum
--
--Disable Shadows.
--
---@source UnityEngine.CoreModule.dll
---@field Disable UnityEngine.ShadowQuality
--
--Hard Shadows Only.
--
---@source UnityEngine.CoreModule.dll
---@field HardOnly UnityEngine.ShadowQuality
--
--Hard and Soft Shadows.
--
---@source UnityEngine.CoreModule.dll
---@field All UnityEngine.ShadowQuality
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.ShadowQuality = {}

---@source 
---@param value any
---@return UnityEngine.ShadowQuality
function CS.UnityEngine.ShadowQuality:__CastFrom(value) end


--
--A flare asset. Read more about flares in the.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.Flare: UnityEngine.Object
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.Flare = {}


--
--Default shadow resolution.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.ShadowResolution: System.Enum
--
--Low shadow map resolution.
--
---@source UnityEngine.CoreModule.dll
---@field Low UnityEngine.ShadowResolution
--
--Medium shadow map resolution.
--
---@source UnityEngine.CoreModule.dll
---@field Medium UnityEngine.ShadowResolution
--
--High shadow map resolution.
--
---@source UnityEngine.CoreModule.dll
---@field High UnityEngine.ShadowResolution
--
--Very high shadow map resolution.
--
---@source UnityEngine.CoreModule.dll
---@field VeryHigh UnityEngine.ShadowResolution
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.ShadowResolution = {}

---@source 
---@param value any
---@return UnityEngine.ShadowResolution
function CS.UnityEngine.ShadowResolution:__CastFrom(value) end


--
--Script interface for a.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.LensFlare: UnityEngine.Behaviour
--
--The strength of the flare.
--
---@source UnityEngine.CoreModule.dll
---@field brightness float
--
--The fade speed of the flare.
--
---@source UnityEngine.CoreModule.dll
---@field fadeSpeed float
--
--The color of the flare.
--
---@source UnityEngine.CoreModule.dll
---@field color UnityEngine.Color
--
--The to use.
--
---@source UnityEngine.CoreModule.dll
---@field flare UnityEngine.Flare
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.LensFlare = {}


--
--The rendering mode of Shadowmask.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.ShadowmaskMode: System.Enum
--
--Static shadow casters won't be rendered into realtime shadow maps. All shadows from static casters are handled via Shadowmasks and occlusion from Light Probes.
--
---@source UnityEngine.CoreModule.dll
---@field Shadowmask UnityEngine.ShadowmaskMode
--
--Static shadow casters will be rendered into realtime shadow maps. Shadowmasks and occlusion from Light Probes will only be used past the realtime shadow distance.
--
---@source UnityEngine.CoreModule.dll
---@field DistanceShadowmask UnityEngine.ShadowmaskMode
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.ShadowmaskMode = {}

---@source 
---@param value any
---@return UnityEngine.ShadowmaskMode
function CS.UnityEngine.ShadowmaskMode:__CastFrom(value) end


--
--Class containing methods to ease debugging while developing a game.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.Debug: object
--
--Get default debug logger.
--
---@source UnityEngine.CoreModule.dll
---@field unityLogger UnityEngine.ILogger
--
--Reports whether the development console is visible. The development console cannot be made to appear using:
--
---@source UnityEngine.CoreModule.dll
---@field developerConsoleVisible bool
--
--In the Build Settings dialog there is a check box called "Development Build".
--
---@source UnityEngine.CoreModule.dll
---@field isDebugBuild bool
---@source UnityEngine.CoreModule.dll
---@field logger UnityEngine.ILogger
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.Debug = {}

--
--Draws a line between specified start and end points.
--
--```plaintext
--Params: start - Point in world space where the line should start.
--        end - Point in world space where the line should end.
--        color - Color of the line.
--        duration - How long the line should be visible for.
--        depthTest - Should the line be obscured by objects closer to the camera?
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param start UnityEngine.Vector3
---@param end UnityEngine.Vector3
---@param color UnityEngine.Color
---@param duration float
function CS.UnityEngine.Debug:DrawLine(start, end, color, duration) end

--
--Draws a line between specified start and end points.
--
--```plaintext
--Params: start - Point in world space where the line should start.
--        end - Point in world space where the line should end.
--        color - Color of the line.
--        duration - How long the line should be visible for.
--        depthTest - Should the line be obscured by objects closer to the camera?
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param start UnityEngine.Vector3
---@param end UnityEngine.Vector3
---@param color UnityEngine.Color
function CS.UnityEngine.Debug:DrawLine(start, end, color) end

--
--Draws a line between specified start and end points.
--
--```plaintext
--Params: start - Point in world space where the line should start.
--        end - Point in world space where the line should end.
--        color - Color of the line.
--        duration - How long the line should be visible for.
--        depthTest - Should the line be obscured by objects closer to the camera?
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param start UnityEngine.Vector3
---@param end UnityEngine.Vector3
function CS.UnityEngine.Debug:DrawLine(start, end) end

--
--Draws a line between specified start and end points.
--
--```plaintext
--Params: start - Point in world space where the line should start.
--        end - Point in world space where the line should end.
--        color - Color of the line.
--        duration - How long the line should be visible for.
--        depthTest - Should the line be obscured by objects closer to the camera?
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param start UnityEngine.Vector3
---@param end UnityEngine.Vector3
---@param color UnityEngine.Color
---@param duration float
---@param depthTest bool
function CS.UnityEngine.Debug:DrawLine(start, end, color, duration, depthTest) end

--
--Draws a line from start to start + dir in world coordinates.
--
--```plaintext
--Params: start - Point in world space where the ray should start.
--        dir - Direction and length of the ray.
--        color - Color of the drawn line.
--        duration - How long the line will be visible for (in seconds).
--        depthTest - Should the line be obscured by other objects closer to the camera?
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param start UnityEngine.Vector3
---@param dir UnityEngine.Vector3
---@param color UnityEngine.Color
---@param duration float
function CS.UnityEngine.Debug:DrawRay(start, dir, color, duration) end

--
--Draws a line from start to start + dir in world coordinates.
--
--```plaintext
--Params: start - Point in world space where the ray should start.
--        dir - Direction and length of the ray.
--        color - Color of the drawn line.
--        duration - How long the line will be visible for (in seconds).
--        depthTest - Should the line be obscured by other objects closer to the camera?
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param start UnityEngine.Vector3
---@param dir UnityEngine.Vector3
---@param color UnityEngine.Color
function CS.UnityEngine.Debug:DrawRay(start, dir, color) end

--
--Draws a line from start to start + dir in world coordinates.
--
--```plaintext
--Params: start - Point in world space where the ray should start.
--        dir - Direction and length of the ray.
--        color - Color of the drawn line.
--        duration - How long the line will be visible for (in seconds).
--        depthTest - Should the line be obscured by other objects closer to the camera?
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param start UnityEngine.Vector3
---@param dir UnityEngine.Vector3
function CS.UnityEngine.Debug:DrawRay(start, dir) end

--
--Draws a line from start to start + dir in world coordinates.
--
--```plaintext
--Params: start - Point in world space where the ray should start.
--        dir - Direction and length of the ray.
--        color - Color of the drawn line.
--        duration - How long the line will be visible for (in seconds).
--        depthTest - Should the line be obscured by other objects closer to the camera?
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param start UnityEngine.Vector3
---@param dir UnityEngine.Vector3
---@param color UnityEngine.Color
---@param duration float
---@param depthTest bool
function CS.UnityEngine.Debug:DrawRay(start, dir, color, duration, depthTest) end

--
--Pauses the editor.
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.Debug:Break() end

---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.Debug:DebugBreak() end

--
--Populate an unmanaged buffer with the current managed call stack as a sequence of UTF-8 bytes, without allocating GC memory. Returns the number of bytes written into the buffer.
--
--```plaintext
--Params: buffer - Target buffer to receive the callstack text
--        bufferMax - Max number of bytes to write
--        projectFolder - Project folder path, to clean up path names
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param buffer byte*
---@param bufferMax int
---@param projectFolder string
---@return Int32
function CS.UnityEngine.Debug:ExtractStackTraceNoAlloc(buffer, bufferMax, projectFolder) end

--
--Logs a message to the Unity Console.
--
--```plaintext
--Params: message - String or object to be converted to string representation for display.
--        context - Object to which the message applies.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param message object
function CS.UnityEngine.Debug:Log(message) end

--
--Logs a message to the Unity Console.
--
--```plaintext
--Params: message - String or object to be converted to string representation for display.
--        context - Object to which the message applies.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param message object
---@param context UnityEngine.Object
function CS.UnityEngine.Debug:Log(message, context) end

--
--Logs a formatted message to the Unity Console.
--
--```plaintext
--Params: format - A composite format string.
--        args - Format arguments.
--        context - Object to which the message applies.
--        logType - Type of message e.g. warn or error etc.
--        logOptions - Option flags to treat the log message special.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param format string
---@param args object[]
function CS.UnityEngine.Debug:LogFormat(format, args) end

--
--Logs a formatted message to the Unity Console.
--
--```plaintext
--Params: format - A composite format string.
--        args - Format arguments.
--        context - Object to which the message applies.
--        logType - Type of message e.g. warn or error etc.
--        logOptions - Option flags to treat the log message special.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param context UnityEngine.Object
---@param format string
---@param args object[]
function CS.UnityEngine.Debug:LogFormat(context, format, args) end

--
--Logs a formatted message to the Unity Console.
--
--```plaintext
--Params: format - A composite format string.
--        args - Format arguments.
--        context - Object to which the message applies.
--        logType - Type of message e.g. warn or error etc.
--        logOptions - Option flags to treat the log message special.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param logType UnityEngine.LogType
---@param logOptions UnityEngine.LogOption
---@param context UnityEngine.Object
---@param format string
---@param args object[]
function CS.UnityEngine.Debug:LogFormat(logType, logOptions, context, format, args) end

--
--A variant of Debug.Log that logs an error message to the console.
--
--```plaintext
--Params: message - String or object to be converted to string representation for display.
--        context - Object to which the message applies.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param message object
function CS.UnityEngine.Debug:LogError(message) end

--
--A variant of Debug.Log that logs an error message to the console.
--
--```plaintext
--Params: message - String or object to be converted to string representation for display.
--        context - Object to which the message applies.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param message object
---@param context UnityEngine.Object
function CS.UnityEngine.Debug:LogError(message, context) end

--
--Logs a formatted error message to the Unity console.
--
--```plaintext
--Params: format - A composite format string.
--        args - Format arguments.
--        context - Object to which the message applies.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param format string
---@param args object[]
function CS.UnityEngine.Debug:LogErrorFormat(format, args) end

--
--Logs a formatted error message to the Unity console.
--
--```plaintext
--Params: format - A composite format string.
--        args - Format arguments.
--        context - Object to which the message applies.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param context UnityEngine.Object
---@param format string
---@param args object[]
function CS.UnityEngine.Debug:LogErrorFormat(context, format, args) end

--
--Clears errors from the developer console.
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.Debug:ClearDeveloperConsole() end

--
--A variant of Debug.Log that logs an error message to the console.
--
--```plaintext
--Params: context - Object to which the message applies.
--        exception - Runtime Exception.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param exception System.Exception
function CS.UnityEngine.Debug:LogException(exception) end

--
--A variant of Debug.Log that logs an error message to the console.
--
--```plaintext
--Params: context - Object to which the message applies.
--        exception - Runtime Exception.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param exception System.Exception
---@param context UnityEngine.Object
function CS.UnityEngine.Debug:LogException(exception, context) end

--
--A variant of Debug.Log that logs a warning message to the console.
--
--```plaintext
--Params: message - String or object to be converted to string representation for display.
--        context - Object to which the message applies.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param message object
function CS.UnityEngine.Debug:LogWarning(message) end

--
--A variant of Debug.Log that logs a warning message to the console.
--
--```plaintext
--Params: message - String or object to be converted to string representation for display.
--        context - Object to which the message applies.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param message object
---@param context UnityEngine.Object
function CS.UnityEngine.Debug:LogWarning(message, context) end

--
--Logs a formatted warning message to the Unity Console.
--
--```plaintext
--Params: format - A composite format string.
--        args - Format arguments.
--        context - Object to which the message applies.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param format string
---@param args object[]
function CS.UnityEngine.Debug:LogWarningFormat(format, args) end

--
--Logs a formatted warning message to the Unity Console.
--
--```plaintext
--Params: format - A composite format string.
--        args - Format arguments.
--        context - Object to which the message applies.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param context UnityEngine.Object
---@param format string
---@param args object[]
function CS.UnityEngine.Debug:LogWarningFormat(context, format, args) end

--
--Assert a condition and logs an error message to the Unity console on failure.
--
--```plaintext
--Params: condition - Condition you expect to be true.
--        context - Object to which the message applies.
--        message - String or object to be converted to string representation for display.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param condition bool
function CS.UnityEngine.Debug:Assert(condition) end

--
--Assert a condition and logs an error message to the Unity console on failure.
--
--```plaintext
--Params: condition - Condition you expect to be true.
--        context - Object to which the message applies.
--        message - String or object to be converted to string representation for display.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param condition bool
---@param context UnityEngine.Object
function CS.UnityEngine.Debug:Assert(condition, context) end

--
--Assert a condition and logs an error message to the Unity console on failure.
--
--```plaintext
--Params: condition - Condition you expect to be true.
--        context - Object to which the message applies.
--        message - String or object to be converted to string representation for display.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param condition bool
---@param message object
function CS.UnityEngine.Debug:Assert(condition, message) end

---@source UnityEngine.CoreModule.dll
---@param condition bool
---@param message string
function CS.UnityEngine.Debug:Assert(condition, message) end

--
--Assert a condition and logs an error message to the Unity console on failure.
--
--```plaintext
--Params: condition - Condition you expect to be true.
--        context - Object to which the message applies.
--        message - String or object to be converted to string representation for display.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param condition bool
---@param message object
---@param context UnityEngine.Object
function CS.UnityEngine.Debug:Assert(condition, message, context) end

---@source UnityEngine.CoreModule.dll
---@param condition bool
---@param message string
---@param context UnityEngine.Object
function CS.UnityEngine.Debug:Assert(condition, message, context) end

--
--Assert a condition and logs a formatted error message to the Unity console on failure.
--
--```plaintext
--Params: condition - Condition you expect to be true.
--        format - A composite format string.
--        args - Format arguments.
--        context - Object to which the message applies.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param condition bool
---@param format string
---@param args object[]
function CS.UnityEngine.Debug:AssertFormat(condition, format, args) end

--
--Assert a condition and logs a formatted error message to the Unity console on failure.
--
--```plaintext
--Params: condition - Condition you expect to be true.
--        format - A composite format string.
--        args - Format arguments.
--        context - Object to which the message applies.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param condition bool
---@param context UnityEngine.Object
---@param format string
---@param args object[]
function CS.UnityEngine.Debug:AssertFormat(condition, context, format, args) end

--
--A variant of Debug.Log that logs an assertion message to the console.
--
--```plaintext
--Params: message - String or object to be converted to string representation for display.
--        context - Object to which the message applies.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param message object
function CS.UnityEngine.Debug:LogAssertion(message) end

--
--A variant of Debug.Log that logs an assertion message to the console.
--
--```plaintext
--Params: message - String or object to be converted to string representation for display.
--        context - Object to which the message applies.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param message object
---@param context UnityEngine.Object
function CS.UnityEngine.Debug:LogAssertion(message, context) end

--
--Logs a formatted assertion message to the Unity console.
--
--```plaintext
--Params: format - A composite format string.
--        args - Format arguments.
--        context - Object to which the message applies.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param format string
---@param args object[]
function CS.UnityEngine.Debug:LogAssertionFormat(format, args) end

--
--Logs a formatted assertion message to the Unity console.
--
--```plaintext
--Params: format - A composite format string.
--        args - Format arguments.
--        context - Object to which the message applies.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param context UnityEngine.Object
---@param format string
---@param args object[]
function CS.UnityEngine.Debug:LogAssertionFormat(context, format, args) end

---@source UnityEngine.CoreModule.dll
---@param condition bool
---@param format string
---@param args object[]
function CS.UnityEngine.Debug:Assert(condition, format, args) end


--
--Object that is used to resolve references to an ExposedReference field.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.ExposedPropertyResolver: System.ValueType
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.ExposedPropertyResolver = {}


--
--Creates a type whos value is resolvable at runtime.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.ExposedReference: System.ValueType
---@source UnityEngine.CoreModule.dll
---@field exposedName UnityEngine.PropertyName
---@source UnityEngine.CoreModule.dll
---@field defaultValue UnityEngine.Object
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.ExposedReference = {}

---@source UnityEngine.CoreModule.dll
---@param resolver UnityEngine.IExposedPropertyTable
---@return T
function CS.UnityEngine.ExposedReference.Resolve(resolver) end


---@source UnityEngine.CoreModule.dll
---@class UnityEngine.IExposedPropertyTable
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.IExposedPropertyTable = {}

--
--Assigns a value for an ExposedReference.
--
--```plaintext
--Params: id - Identifier of the ExposedReference.
--        value - The value to assigned to the ExposedReference.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param id UnityEngine.PropertyName
---@param value UnityEngine.Object
function CS.UnityEngine.IExposedPropertyTable.SetReferenceValue(id, value) end

---@source UnityEngine.CoreModule.dll
---@param id UnityEngine.PropertyName
---@param idValid bool
---@return Object
function CS.UnityEngine.IExposedPropertyTable.GetReferenceValue(id, idValid) end

--
--Remove a value for the given reference.
--
--```plaintext
--Params: id - Identifier of the ExposedReference.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param id UnityEngine.PropertyName
function CS.UnityEngine.IExposedPropertyTable.ClearReferenceValue(id) end


--
--Values for Camera.clearFlags, determining what to clear when rendering a Camera.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.CameraClearFlags: System.Enum
--
--Clear with the skybox.
--
---@source UnityEngine.CoreModule.dll
---@field Skybox UnityEngine.CameraClearFlags
---@source UnityEngine.CoreModule.dll
---@field Color UnityEngine.CameraClearFlags
--
--Clear with a background color.
--
---@source UnityEngine.CoreModule.dll
---@field SolidColor UnityEngine.CameraClearFlags
--
--Clear only the depth buffer.
--
---@source UnityEngine.CoreModule.dll
---@field Depth UnityEngine.CameraClearFlags
--
--Don't clear anything.
--
---@source UnityEngine.CoreModule.dll
---@field Nothing UnityEngine.CameraClearFlags
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.CameraClearFlags = {}

---@source 
---@param value any
---@return UnityEngine.CameraClearFlags
function CS.UnityEngine.CameraClearFlags:__CastFrom(value) end


--
--Depth texture generation mode for Camera.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.DepthTextureMode: System.Enum
--
--Do not generate depth texture (Default).
--
---@source UnityEngine.CoreModule.dll
---@field None UnityEngine.DepthTextureMode
--
--Generate a depth texture.
--
---@source UnityEngine.CoreModule.dll
---@field Depth UnityEngine.DepthTextureMode
--
--Generate a depth + normals texture.
--
---@source UnityEngine.CoreModule.dll
---@field DepthNormals UnityEngine.DepthTextureMode
--
--Specifies whether motion vectors should be rendered (if possible).
--
---@source UnityEngine.CoreModule.dll
---@field MotionVectors UnityEngine.DepthTextureMode
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.DepthTextureMode = {}

---@source 
---@param value any
---@return UnityEngine.DepthTextureMode
function CS.UnityEngine.DepthTextureMode:__CastFrom(value) end


---@source UnityEngine.CoreModule.dll
---@class UnityEngine.TexGenMode: System.Enum
---@source UnityEngine.CoreModule.dll
---@field None UnityEngine.TexGenMode
---@source UnityEngine.CoreModule.dll
---@field SphereMap UnityEngine.TexGenMode
---@source UnityEngine.CoreModule.dll
---@field Object UnityEngine.TexGenMode
---@source UnityEngine.CoreModule.dll
---@field EyeLinear UnityEngine.TexGenMode
---@source UnityEngine.CoreModule.dll
---@field CubeReflect UnityEngine.TexGenMode
---@source UnityEngine.CoreModule.dll
---@field CubeNormal UnityEngine.TexGenMode
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.TexGenMode = {}

---@source 
---@param value any
---@return UnityEngine.TexGenMode
function CS.UnityEngine.TexGenMode:__CastFrom(value) end


--
--Anisotropic filtering mode.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.AnisotropicFiltering: System.Enum
--
--Disable anisotropic filtering for all textures.
--
---@source UnityEngine.CoreModule.dll
---@field Disable UnityEngine.AnisotropicFiltering
--
--Enable anisotropic filtering, as set for each texture.
--
---@source UnityEngine.CoreModule.dll
---@field Enable UnityEngine.AnisotropicFiltering
--
--Enable anisotropic filtering for all textures.
--
---@source UnityEngine.CoreModule.dll
---@field ForceEnable UnityEngine.AnisotropicFiltering
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.AnisotropicFiltering = {}

---@source 
---@param value any
---@return UnityEngine.AnisotropicFiltering
function CS.UnityEngine.AnisotropicFiltering:__CastFrom(value) end


---@source UnityEngine.CoreModule.dll
---@class UnityEngine.BlendWeights: System.Enum
---@source UnityEngine.CoreModule.dll
---@field OneBone UnityEngine.BlendWeights
---@source UnityEngine.CoreModule.dll
---@field TwoBones UnityEngine.BlendWeights
---@source UnityEngine.CoreModule.dll
---@field FourBones UnityEngine.BlendWeights
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.BlendWeights = {}

---@source 
---@param value any
---@return UnityEngine.BlendWeights
function CS.UnityEngine.BlendWeights:__CastFrom(value) end


--
--Skin weights.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.SkinWeights: System.Enum
--
--One bone affects each vertex.
--
---@source UnityEngine.CoreModule.dll
---@field OneBone UnityEngine.SkinWeights
--
--Two bones affect each vertex.
--
---@source UnityEngine.CoreModule.dll
---@field TwoBones UnityEngine.SkinWeights
--
--Four bones affect each vertex.
--
---@source UnityEngine.CoreModule.dll
---@field FourBones UnityEngine.SkinWeights
--
--An unlimited number of bones affect each vertex.
--
---@source UnityEngine.CoreModule.dll
---@field Unlimited UnityEngine.SkinWeights
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.SkinWeights = {}

---@source 
---@param value any
---@return UnityEngine.SkinWeights
function CS.UnityEngine.SkinWeights:__CastFrom(value) end


--
--Topology of Mesh faces.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.MeshTopology: System.Enum
--
--Mesh is made from triangles.
--
---@source UnityEngine.CoreModule.dll
---@field Triangles UnityEngine.MeshTopology
--
--Mesh is made from quads.
--
---@source UnityEngine.CoreModule.dll
---@field Quads UnityEngine.MeshTopology
--
--Mesh is made from lines.
--
---@source UnityEngine.CoreModule.dll
---@field Lines UnityEngine.MeshTopology
--
--Mesh is a line strip.
--
---@source UnityEngine.CoreModule.dll
---@field LineStrip UnityEngine.MeshTopology
--
--Mesh is made from points.
--
---@source UnityEngine.CoreModule.dll
---@field Points UnityEngine.MeshTopology
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.MeshTopology = {}

---@source 
---@param value any
---@return UnityEngine.MeshTopology
function CS.UnityEngine.MeshTopology:__CastFrom(value) end


--
--The maximum number of bones affecting a single vertex.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.SkinQuality: System.Enum
--
--Chooses the number of bones from the number current QualitySettings. (Default)
--
---@source UnityEngine.CoreModule.dll
---@field Auto UnityEngine.SkinQuality
--
--Use only 1 bone to deform a single vertex. (The most important bone will be used).
--
---@source UnityEngine.CoreModule.dll
---@field Bone1 UnityEngine.SkinQuality
--
--Use 2 bones to deform a single vertex. (The most important bones will be used).
--
---@source UnityEngine.CoreModule.dll
---@field Bone2 UnityEngine.SkinQuality
--
--Use 4 bones to deform a single vertex.
--
---@source UnityEngine.CoreModule.dll
---@field Bone4 UnityEngine.SkinQuality
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.SkinQuality = {}

---@source 
---@param value any
---@return UnityEngine.SkinQuality
function CS.UnityEngine.SkinQuality:__CastFrom(value) end


--
--Cubemap face.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.CubemapFace: System.Enum
--
--Cubemap face is unknown or unspecified.
--
---@source UnityEngine.CoreModule.dll
---@field Unknown UnityEngine.CubemapFace
--
--Right facing side (+x).
--
---@source UnityEngine.CoreModule.dll
---@field PositiveX UnityEngine.CubemapFace
--
--Left facing side (-x).
--
---@source UnityEngine.CoreModule.dll
---@field NegativeX UnityEngine.CubemapFace
--
--Upwards facing side (+y).
--
---@source UnityEngine.CoreModule.dll
---@field PositiveY UnityEngine.CubemapFace
--
--Downward facing side (-y).
--
---@source UnityEngine.CoreModule.dll
---@field NegativeY UnityEngine.CubemapFace
--
--Forward facing side (+z).
--
---@source UnityEngine.CoreModule.dll
---@field PositiveZ UnityEngine.CubemapFace
--
--Backward facing side (-z).
--
---@source UnityEngine.CoreModule.dll
---@field NegativeZ UnityEngine.CubemapFace
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.CubemapFace = {}

---@source 
---@param value any
---@return UnityEngine.CubemapFace
function CS.UnityEngine.CubemapFace:__CastFrom(value) end


--
--Color space for player settings.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.ColorSpace: System.Enum
--
--Uninitialized color space.
--
---@source UnityEngine.CoreModule.dll
---@field Uninitialized UnityEngine.ColorSpace
--
--Gamma color space.
--
---@source UnityEngine.CoreModule.dll
---@field Gamma UnityEngine.ColorSpace
--
--Linear color space.
--
---@source UnityEngine.CoreModule.dll
---@field Linear UnityEngine.ColorSpace
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.ColorSpace = {}

---@source 
---@param value any
---@return UnityEngine.ColorSpace
function CS.UnityEngine.ColorSpace:__CastFrom(value) end


--
--Format of a RenderTexture.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.RenderTextureFormat: System.Enum
--
--Color render texture format, 8 bits per channel.
--
---@source UnityEngine.CoreModule.dll
---@field ARGB32 UnityEngine.RenderTextureFormat
--
--A depth render texture format.
--
---@source UnityEngine.CoreModule.dll
---@field Depth UnityEngine.RenderTextureFormat
--
--Color render texture format, 16 bit floating point per channel.
--
---@source UnityEngine.CoreModule.dll
---@field ARGBHalf UnityEngine.RenderTextureFormat
--
--A native shadowmap render texture format.
--
---@source UnityEngine.CoreModule.dll
---@field Shadowmap UnityEngine.RenderTextureFormat
--
--Color render texture format.
--
---@source UnityEngine.CoreModule.dll
---@field RGB565 UnityEngine.RenderTextureFormat
--
--Color render texture format, 4 bit per channel.
--
---@source UnityEngine.CoreModule.dll
---@field ARGB4444 UnityEngine.RenderTextureFormat
--
--Color render texture format, 1 bit for Alpha channel, 5 bits for Red, Green and Blue channels.
--
---@source UnityEngine.CoreModule.dll
---@field ARGB1555 UnityEngine.RenderTextureFormat
--
--Default color render texture format: will be chosen accordingly to Frame Buffer format and Platform.
--
---@source UnityEngine.CoreModule.dll
---@field Default UnityEngine.RenderTextureFormat
--
--Color render texture format. 10 bits for colors, 2 bits for alpha.
--
---@source UnityEngine.CoreModule.dll
---@field ARGB2101010 UnityEngine.RenderTextureFormat
--
--Default HDR color render texture format: will be chosen accordingly to Frame Buffer format and Platform.
--
---@source UnityEngine.CoreModule.dll
---@field DefaultHDR UnityEngine.RenderTextureFormat
--
--Four color render texture format, 16 bits per channel, fixed point, unsigned normalized.
--
---@source UnityEngine.CoreModule.dll
---@field ARGB64 UnityEngine.RenderTextureFormat
--
--Color render texture format, 32 bit floating point per channel.
--
---@source UnityEngine.CoreModule.dll
---@field ARGBFloat UnityEngine.RenderTextureFormat
--
--Two color (RG) render texture format, 32 bit floating point per channel.
--
---@source UnityEngine.CoreModule.dll
---@field RGFloat UnityEngine.RenderTextureFormat
--
--Two color (RG) render texture format, 16 bit floating point per channel.
--
---@source UnityEngine.CoreModule.dll
---@field RGHalf UnityEngine.RenderTextureFormat
--
--Scalar (R) render texture format, 32 bit floating point.
--
---@source UnityEngine.CoreModule.dll
---@field RFloat UnityEngine.RenderTextureFormat
--
--Scalar (R) render texture format, 16 bit floating point.
--
---@source UnityEngine.CoreModule.dll
---@field RHalf UnityEngine.RenderTextureFormat
--
--Single channel (R) render texture format, 8 bit integer.
--
---@source UnityEngine.CoreModule.dll
---@field R8 UnityEngine.RenderTextureFormat
--
--Four channel (ARGB) render texture format, 32 bit signed integer per channel.
--
---@source UnityEngine.CoreModule.dll
---@field ARGBInt UnityEngine.RenderTextureFormat
--
--Two channel (RG) render texture format, 32 bit signed integer per channel.
--
---@source UnityEngine.CoreModule.dll
---@field RGInt UnityEngine.RenderTextureFormat
--
--Scalar (R) render texture format, 32 bit signed integer.
--
---@source UnityEngine.CoreModule.dll
---@field RInt UnityEngine.RenderTextureFormat
--
--Color render texture format, 8 bits per channel.
--
---@source UnityEngine.CoreModule.dll
---@field BGRA32 UnityEngine.RenderTextureFormat
--
--Color render texture format. R and G channels are 11 bit floating point, B channel is 10 bit floating point.
--
---@source UnityEngine.CoreModule.dll
---@field RGB111110Float UnityEngine.RenderTextureFormat
--
--Two color (RG) render texture format, 16 bits per channel, fixed point, unsigned normalized.
--
---@source UnityEngine.CoreModule.dll
---@field RG32 UnityEngine.RenderTextureFormat
--
--Four channel (RGBA) render texture format, 16 bit unsigned integer per channel.
--
---@source UnityEngine.CoreModule.dll
---@field RGBAUShort UnityEngine.RenderTextureFormat
--
--Two channel (RG) render texture format, 8 bits per channel.
--
---@source UnityEngine.CoreModule.dll
---@field RG16 UnityEngine.RenderTextureFormat
--
--Color render texture format, 10 bit per channel, extended range.
--
---@source UnityEngine.CoreModule.dll
---@field BGRA10101010_XR UnityEngine.RenderTextureFormat
--
--Color render texture format, 10 bit per channel, extended range.
--
---@source UnityEngine.CoreModule.dll
---@field BGR101010_XR UnityEngine.RenderTextureFormat
--
--Single channel (R) render texture format, 16 bit integer.
--
---@source UnityEngine.CoreModule.dll
---@field R16 UnityEngine.RenderTextureFormat
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.RenderTextureFormat = {}

---@source 
---@param value any
---@return UnityEngine.RenderTextureFormat
function CS.UnityEngine.RenderTextureFormat:__CastFrom(value) end


--
--Represents a color gamut.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.ColorGamut: System.Enum
--
--sRGB color gamut.
--
---@source UnityEngine.CoreModule.dll
---@field sRGB UnityEngine.ColorGamut
--
--Rec. 709 color gamut.
--
---@source UnityEngine.CoreModule.dll
---@field Rec709 UnityEngine.ColorGamut
--
--Rec. 2020 color gamut.
--
---@source UnityEngine.CoreModule.dll
---@field Rec2020 UnityEngine.ColorGamut
--
--Display-P3 color gamut.
--
---@source UnityEngine.CoreModule.dll
---@field DisplayP3 UnityEngine.ColorGamut
--
--HDR10 high dynamic range color gamut.
--
---@source UnityEngine.CoreModule.dll
---@field HDR10 UnityEngine.ColorGamut
--
--DolbyHDR high dynamic range color gamut.
--
---@source UnityEngine.CoreModule.dll
---@field DolbyHDR UnityEngine.ColorGamut
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.ColorGamut = {}

---@source 
---@param value any
---@return UnityEngine.ColorGamut
function CS.UnityEngine.ColorGamut:__CastFrom(value) end


--
--This enum describes how the RenderTexture is used as a VR eye texture. Instead of using the values of this enum manually, use the value returned by XR.XRSettings.eyeTextureDesc|eyeTextureDesc or other VR functions returning a RenderTextureDescriptor.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.VRTextureUsage: System.Enum
--
--The RenderTexture is not a VR eye texture. No special rendering behavior will occur.
--
---@source UnityEngine.CoreModule.dll
---@field None UnityEngine.VRTextureUsage
--
--This texture corresponds to a single eye on a stereoscopic display.
--
---@source UnityEngine.CoreModule.dll
---@field OneEye UnityEngine.VRTextureUsage
--
--This texture corresponds to two eyes on a stereoscopic display. This will be taken into account when using Graphics.Blit and other rendering functions.
--
---@source UnityEngine.CoreModule.dll
---@field TwoEyes UnityEngine.VRTextureUsage
--
--The texture used by an external XR provider.  The provider is responsible for defining the texture's layout and use.
--
---@source UnityEngine.CoreModule.dll
---@field DeviceSpecific UnityEngine.VRTextureUsage
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.VRTextureUsage = {}

---@source 
---@param value any
---@return UnityEngine.VRTextureUsage
function CS.UnityEngine.VRTextureUsage:__CastFrom(value) end


--
--Describes screen orientation.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.ScreenOrientation: System.Enum
---@source UnityEngine.CoreModule.dll
---@field Unknown UnityEngine.ScreenOrientation
--
--Portrait orientation.
--
---@source UnityEngine.CoreModule.dll
---@field Portrait UnityEngine.ScreenOrientation
--
--Portrait orientation, upside down.
--
---@source UnityEngine.CoreModule.dll
---@field PortraitUpsideDown UnityEngine.ScreenOrientation
--
--Landscape orientation, counter-clockwise from the portrait orientation.
--
---@source UnityEngine.CoreModule.dll
---@field LandscapeLeft UnityEngine.ScreenOrientation
--
--Landscape orientation, clockwise from the portrait orientation.
--
---@source UnityEngine.CoreModule.dll
---@field LandscapeRight UnityEngine.ScreenOrientation
--
--Auto-rotates the screen as necessary toward any of the enabled orientations.
--
---@source UnityEngine.CoreModule.dll
---@field AutoRotation UnityEngine.ScreenOrientation
---@source UnityEngine.CoreModule.dll
---@field Landscape UnityEngine.ScreenOrientation
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.ScreenOrientation = {}

---@source 
---@param value any
---@return UnityEngine.ScreenOrientation
function CS.UnityEngine.ScreenOrientation:__CastFrom(value) end


--
--Set of flags that control the state of a newly-created RenderTexture.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.RenderTextureCreationFlags: System.Enum
--
--Set this flag to allocate mipmaps in the RenderTexture. See RenderTexture.useMipMap for more details.
--
---@source UnityEngine.CoreModule.dll
---@field MipMap UnityEngine.RenderTextureCreationFlags
--
--Determines whether or not mipmaps are automatically generated when the RenderTexture is modified.
--This flag is set by default, and has no effect if the RenderTextureCreationFlags.MipMap flag is not also set.
--See RenderTexture.autoGenerateMips for more details.
--
---@source UnityEngine.CoreModule.dll
---@field AutoGenerateMips UnityEngine.RenderTextureCreationFlags
--
--When this flag is set, reads and writes to this texture are converted to SRGB color space. See RenderTexture.sRGB for more details.
--
---@source UnityEngine.CoreModule.dll
---@field SRGB UnityEngine.RenderTextureCreationFlags
--
--Set this flag when the Texture is to be used as a VR eye texture. This flag is cleared by default. This flag is set on a RenderTextureDesc when it is returned from GetDefaultVREyeTextureDesc or other VR functions returning a RenderTextureDesc.
--
---@source UnityEngine.CoreModule.dll
---@field EyeTexture UnityEngine.RenderTextureCreationFlags
--
--Set this flag to enable random access writes to the RenderTexture from shaders.
--Normally, pixel shaders only operate on pixels they are given. Compute shaders cannot write to textures without this flag. Random write enables shaders to write to arbitrary locations on a RenderTexture.  See RenderTexture.enableRandomWrite for more details, including supported platforms.
--
---@source UnityEngine.CoreModule.dll
---@field EnableRandomWrite UnityEngine.RenderTextureCreationFlags
--
--This flag is always set internally when a RenderTexture is created from script. It has no effect when set manually from script code.
--
---@source UnityEngine.CoreModule.dll
---@field CreatedFromScript UnityEngine.RenderTextureCreationFlags
--
--Clear this flag when a RenderTexture is a VR eye texture and the device does not automatically flip the texture when being displayed. This is platform specific and
--It is set by default. This flag is only cleared when part of a RenderTextureDesc that is returned from GetDefaultVREyeTextureDesc or other VR functions that return a RenderTextureDesc. Currently, only Hololens eye textures need to clear this flag.
--
---@source UnityEngine.CoreModule.dll
---@field AllowVerticalFlip UnityEngine.RenderTextureCreationFlags
--
--When this flag is set, the engine will not automatically resolve the color surface.
--
---@source UnityEngine.CoreModule.dll
---@field NoResolvedColorSurface UnityEngine.RenderTextureCreationFlags
--
--Set this flag to mark this RenderTexture for Dynamic Resolution should the target platform/graphics API support Dynamic Resolution. See ScalabeBufferManager for more details.
--
---@source UnityEngine.CoreModule.dll
---@field DynamicallyScalable UnityEngine.RenderTextureCreationFlags
--
--Setting this flag causes the RenderTexture to be bound as a multisampled texture in a shader. The flag prevents the RenderTexture from being resolved by default when RenderTexture.antiAliasing is greater than 1.
--
---@source UnityEngine.CoreModule.dll
---@field BindMS UnityEngine.RenderTextureCreationFlags
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.RenderTextureCreationFlags = {}

---@source 
---@param value any
---@return UnityEngine.RenderTextureCreationFlags
function CS.UnityEngine.RenderTextureCreationFlags:__CastFrom(value) end


--
--Filtering mode for textures. Corresponds to the settings in a.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.FilterMode: System.Enum
--
--Point filtering - texture pixels become blocky up close.
--
---@source UnityEngine.CoreModule.dll
---@field Point UnityEngine.FilterMode
--
--Bilinear filtering - texture samples are averaged.
--
---@source UnityEngine.CoreModule.dll
---@field Bilinear UnityEngine.FilterMode
--
--Trilinear filtering - texture samples are averaged and also blended between mipmap levels.
--
---@source UnityEngine.CoreModule.dll
---@field Trilinear UnityEngine.FilterMode
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.FilterMode = {}

---@source 
---@param value any
---@return UnityEngine.FilterMode
function CS.UnityEngine.FilterMode:__CastFrom(value) end


--
--Color space conversion mode of a RenderTexture.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.RenderTextureReadWrite: System.Enum
--
--Default color space conversion based on project settings.
--
---@source UnityEngine.CoreModule.dll
---@field Default UnityEngine.RenderTextureReadWrite
--
--Render texture contains linear (non-color) data; don't perform color conversions on it.
--
---@source UnityEngine.CoreModule.dll
---@field Linear UnityEngine.RenderTextureReadWrite
--
--Render texture contains sRGB (color) data, perform Linear<->sRGB conversions on it.
--
---@source UnityEngine.CoreModule.dll
---@field sRGB UnityEngine.RenderTextureReadWrite
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.RenderTextureReadWrite = {}

---@source 
---@param value any
---@return UnityEngine.RenderTextureReadWrite
function CS.UnityEngine.RenderTextureReadWrite:__CastFrom(value) end


--
--Wrap mode for textures.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.TextureWrapMode: System.Enum
--
--Tiles the texture, creating a repeating pattern.
--
---@source UnityEngine.CoreModule.dll
---@field Repeat UnityEngine.TextureWrapMode
--
--Clamps the texture to the last pixel at the edge.
--
---@source UnityEngine.CoreModule.dll
---@field Clamp UnityEngine.TextureWrapMode
--
--Tiles the texture, creating a repeating pattern by mirroring it at every integer boundary.
--
---@source UnityEngine.CoreModule.dll
---@field Mirror UnityEngine.TextureWrapMode
--
--Mirrors the texture once, then clamps to edge pixels.
--
---@source UnityEngine.CoreModule.dll
---@field MirrorOnce UnityEngine.TextureWrapMode
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.TextureWrapMode = {}

---@source 
---@param value any
---@return UnityEngine.TextureWrapMode
function CS.UnityEngine.TextureWrapMode:__CastFrom(value) end


--
--Flags enumeration of the render texture memoryless modes.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.RenderTextureMemoryless: System.Enum
--
--The render texture is not memoryless.
--
---@source UnityEngine.CoreModule.dll
---@field None UnityEngine.RenderTextureMemoryless
--
--Render texture color pixels are memoryless when RenderTexture.antiAliasing is set to 1.
--
---@source UnityEngine.CoreModule.dll
---@field Color UnityEngine.RenderTextureMemoryless
--
--Render texture depth pixels are memoryless.
--
---@source UnityEngine.CoreModule.dll
---@field Depth UnityEngine.RenderTextureMemoryless
--
--Render texture color pixels are memoryless when RenderTexture.antiAliasing is set to 2, 4 or 8.
--
---@source UnityEngine.CoreModule.dll
---@field MSAA UnityEngine.RenderTextureMemoryless
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.RenderTextureMemoryless = {}

---@source 
---@param value any
---@return UnityEngine.RenderTextureMemoryless
function CS.UnityEngine.RenderTextureMemoryless:__CastFrom(value) end


--
--NPOT Texture2D|textures support.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.NPOTSupport: System.Enum
--
--NPOT textures are not supported. Will be upscaled/padded at loading time.
--
---@source UnityEngine.CoreModule.dll
---@field None UnityEngine.NPOTSupport
--
--Limited NPOT support: no mipmaps and clamp TextureWrapMode|wrap mode will be forced.
--
---@source UnityEngine.CoreModule.dll
---@field Restricted UnityEngine.NPOTSupport
--
--Full NPOT support.
--
---@source UnityEngine.CoreModule.dll
---@field Full UnityEngine.NPOTSupport
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.NPOTSupport = {}

---@source 
---@param value any
---@return UnityEngine.NPOTSupport
function CS.UnityEngine.NPOTSupport:__CastFrom(value) end


--
--A set of flags that describe the level of HDR display support available on the system.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.HDRDisplaySupportFlags: System.Enum
--
--Flag used to denote that support for HDR displays is not available on the system.
--
---@source UnityEngine.CoreModule.dll
---@field None UnityEngine.HDRDisplaySupportFlags
--
--Flag used to denote that support for HDR displays is available on the system.
--
---@source UnityEngine.CoreModule.dll
---@field Supported UnityEngine.HDRDisplaySupportFlags
--
--Flag used to denote that the system can change whether output is performed in HDR or SDR ranges at runtime when connected to an HDR display.
--
---@source UnityEngine.CoreModule.dll
---@field RuntimeSwitchable UnityEngine.HDRDisplaySupportFlags
--
--Flag used to denote if the system supports automatic tonemapping to HDR displays.
--
---@source UnityEngine.CoreModule.dll
---@field AutomaticTonemapping UnityEngine.HDRDisplaySupportFlags
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.HDRDisplaySupportFlags = {}

---@source 
---@param value any
---@return UnityEngine.HDRDisplaySupportFlags
function CS.UnityEngine.HDRDisplaySupportFlags:__CastFrom(value) end


--
--Format used when creating textures from scripts.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.TextureFormat: System.Enum
--
--Alpha-only texture format, 8 bit integer.
--
---@source UnityEngine.CoreModule.dll
---@field Alpha8 UnityEngine.TextureFormat
--
--A 16 bits/pixel texture format. Texture stores color with an alpha channel.
--
---@source UnityEngine.CoreModule.dll
---@field ARGB4444 UnityEngine.TextureFormat
--
--Color texture format, 8-bits per channel.
--
---@source UnityEngine.CoreModule.dll
---@field RGB24 UnityEngine.TextureFormat
--
--Color with alpha texture format, 8-bits per channel.
--
---@source UnityEngine.CoreModule.dll
---@field RGBA32 UnityEngine.TextureFormat
--
--Color with alpha texture format, 8-bits per channel.
--
---@source UnityEngine.CoreModule.dll
---@field ARGB32 UnityEngine.TextureFormat
--
--A 16 bit color texture format.
--
---@source UnityEngine.CoreModule.dll
---@field RGB565 UnityEngine.TextureFormat
--
--Single channel (R) texture format, 16 bit integer.
--
---@source UnityEngine.CoreModule.dll
---@field R16 UnityEngine.TextureFormat
--
--Compressed color texture format.
--
---@source UnityEngine.CoreModule.dll
---@field DXT1 UnityEngine.TextureFormat
--
--Compressed color with alpha channel texture format.
--
---@source UnityEngine.CoreModule.dll
---@field DXT5 UnityEngine.TextureFormat
--
--Color and alpha  texture format, 4 bit per channel.
--
---@source UnityEngine.CoreModule.dll
---@field RGBA4444 UnityEngine.TextureFormat
--
--Color with alpha texture format, 8-bits per channel.
--
---@source UnityEngine.CoreModule.dll
---@field BGRA32 UnityEngine.TextureFormat
--
--Scalar (R)  texture format, 16 bit floating point.
--
---@source UnityEngine.CoreModule.dll
---@field RHalf UnityEngine.TextureFormat
--
--Two color (RG)  texture format, 16 bit floating point per channel.
--
---@source UnityEngine.CoreModule.dll
---@field RGHalf UnityEngine.TextureFormat
--
--RGB color and alpha texture format, 16 bit floating point per channel.
--
---@source UnityEngine.CoreModule.dll
---@field RGBAHalf UnityEngine.TextureFormat
--
--Scalar (R) texture format, 32 bit floating point.
--
---@source UnityEngine.CoreModule.dll
---@field RFloat UnityEngine.TextureFormat
--
--Two color (RG)  texture format, 32 bit floating point per channel.
--
---@source UnityEngine.CoreModule.dll
---@field RGFloat UnityEngine.TextureFormat
--
--RGB color and alpha texture format,  32-bit floats per channel.
--
---@source UnityEngine.CoreModule.dll
---@field RGBAFloat UnityEngine.TextureFormat
--
--A format that uses the YUV color space and is often used for video encoding or playback.
--
---@source UnityEngine.CoreModule.dll
---@field YUY2 UnityEngine.TextureFormat
--
--RGB HDR format, with 9 bit mantissa per channel and a 5 bit shared exponent.
--
---@source UnityEngine.CoreModule.dll
---@field RGB9e5Float UnityEngine.TextureFormat
--
--Compressed one channel (R) texture format.
--
---@source UnityEngine.CoreModule.dll
---@field BC4 UnityEngine.TextureFormat
--
--Compressed two-channel (RG) texture format.
--
---@source UnityEngine.CoreModule.dll
---@field BC5 UnityEngine.TextureFormat
--
--HDR compressed color texture format.
--
---@source UnityEngine.CoreModule.dll
---@field BC6H UnityEngine.TextureFormat
--
--High quality compressed color texture format.
--
---@source UnityEngine.CoreModule.dll
---@field BC7 UnityEngine.TextureFormat
--
--Compressed color texture format with Crunch compression for smaller storage sizes.
--
---@source UnityEngine.CoreModule.dll
---@field DXT1Crunched UnityEngine.TextureFormat
--
--Compressed color with alpha channel texture format with Crunch compression for smaller storage sizes.
--
---@source UnityEngine.CoreModule.dll
---@field DXT5Crunched UnityEngine.TextureFormat
--
--PowerVR (iOS) 2 bits/pixel compressed color texture format.
--
---@source UnityEngine.CoreModule.dll
---@field PVRTC_RGB2 UnityEngine.TextureFormat
--
--PowerVR (iOS) 2 bits/pixel compressed with alpha channel texture format.
--
---@source UnityEngine.CoreModule.dll
---@field PVRTC_RGBA2 UnityEngine.TextureFormat
--
--PowerVR (iOS) 4 bits/pixel compressed color texture format.
--
---@source UnityEngine.CoreModule.dll
---@field PVRTC_RGB4 UnityEngine.TextureFormat
--
--PowerVR (iOS) 4 bits/pixel compressed with alpha channel texture format.
--
---@source UnityEngine.CoreModule.dll
---@field PVRTC_RGBA4 UnityEngine.TextureFormat
--
--ETC (GLES2.0) 4 bits/pixel compressed RGB texture format.
--
---@source UnityEngine.CoreModule.dll
---@field ETC_RGB4 UnityEngine.TextureFormat
---@source UnityEngine.CoreModule.dll
---@field ATC_RGB4 UnityEngine.TextureFormat
---@source UnityEngine.CoreModule.dll
---@field ATC_RGBA8 UnityEngine.TextureFormat
--
--ETC2  EAC (GL ES 3.0) 4 bitspixel compressed unsigned single-channel texture format.
--
---@source UnityEngine.CoreModule.dll
---@field EAC_R UnityEngine.TextureFormat
--
--ETC2  EAC (GL ES 3.0) 4 bitspixel compressed signed single-channel texture format.
--
---@source UnityEngine.CoreModule.dll
---@field EAC_R_SIGNED UnityEngine.TextureFormat
--
--ETC2  EAC (GL ES 3.0) 8 bitspixel compressed unsigned dual-channel (RG) texture format.
--
---@source UnityEngine.CoreModule.dll
---@field EAC_RG UnityEngine.TextureFormat
--
--ETC2  EAC (GL ES 3.0) 8 bitspixel compressed signed dual-channel (RG) texture format.
--
---@source UnityEngine.CoreModule.dll
---@field EAC_RG_SIGNED UnityEngine.TextureFormat
--
--ETC2 (GL ES 3.0) 4 bits/pixel compressed RGB texture format.
--
---@source UnityEngine.CoreModule.dll
---@field ETC2_RGB UnityEngine.TextureFormat
--
--ETC2 (GL ES 3.0) 4 bits/pixel RGB+1-bit alpha texture format.
--
---@source UnityEngine.CoreModule.dll
---@field ETC2_RGBA1 UnityEngine.TextureFormat
--
--ETC2 (GL ES 3.0) 8 bits/pixel compressed RGBA texture format.
--
---@source UnityEngine.CoreModule.dll
---@field ETC2_RGBA8 UnityEngine.TextureFormat
--
--ASTC (4x4 pixel block in 128 bits) compressed RGB(A) texture format.
--
---@source UnityEngine.CoreModule.dll
---@field ASTC_4x4 UnityEngine.TextureFormat
--
--ASTC (5x5 pixel block in 128 bits) compressed RGB(A) texture format.
--
---@source UnityEngine.CoreModule.dll
---@field ASTC_5x5 UnityEngine.TextureFormat
--
--ASTC (6x6 pixel block in 128 bits) compressed RGB(A) texture format.
--
---@source UnityEngine.CoreModule.dll
---@field ASTC_6x6 UnityEngine.TextureFormat
--
--ASTC (8x8 pixel block in 128 bits) compressed RGB(A) texture format.
--
---@source UnityEngine.CoreModule.dll
---@field ASTC_8x8 UnityEngine.TextureFormat
--
--ASTC (10x10 pixel block in 128 bits) compressed RGB(A) texture format.
--
---@source UnityEngine.CoreModule.dll
---@field ASTC_10x10 UnityEngine.TextureFormat
--
--ASTC (12x12 pixel block in 128 bits) compressed RGB(A) texture format.
--
---@source UnityEngine.CoreModule.dll
---@field ASTC_12x12 UnityEngine.TextureFormat
--
--ETC 4 bits/pixel compressed RGB texture format.
--
---@source UnityEngine.CoreModule.dll
---@field ETC_RGB4_3DS UnityEngine.TextureFormat
--
--ETC 4 bitspixel RGB + 4 bitspixel Alpha compressed texture format.
--
---@source UnityEngine.CoreModule.dll
---@field ETC_RGBA8_3DS UnityEngine.TextureFormat
--
--Two color (RG) texture format, 8-bits per channel.
--
---@source UnityEngine.CoreModule.dll
---@field RG16 UnityEngine.TextureFormat
--
--Single channel (R) texture format, 8 bit integer.
--
---@source UnityEngine.CoreModule.dll
---@field R8 UnityEngine.TextureFormat
--
--Compressed color texture format with Crunch compression for smaller storage sizes.
--
---@source UnityEngine.CoreModule.dll
---@field ETC_RGB4Crunched UnityEngine.TextureFormat
--
--Compressed color with alpha channel texture format using Crunch compression for smaller storage sizes.
--
---@source UnityEngine.CoreModule.dll
---@field ETC2_RGBA8Crunched UnityEngine.TextureFormat
--
--ASTC (4x4 pixel block in 128 bits) compressed RGB(A) HDR texture format.
--
---@source UnityEngine.CoreModule.dll
---@field ASTC_HDR_4x4 UnityEngine.TextureFormat
--
--ASTC (5x5 pixel block in 128 bits) compressed RGB(A) HDR texture format.
--
---@source UnityEngine.CoreModule.dll
---@field ASTC_HDR_5x5 UnityEngine.TextureFormat
--
--ASTC (6x6 pixel block in 128 bits) compressed RGB(A) HDR texture format.
--
---@source UnityEngine.CoreModule.dll
---@field ASTC_HDR_6x6 UnityEngine.TextureFormat
--
--ASTC (8x8 pixel block in 128 bits) compressed RGB(A) texture format.
--
---@source UnityEngine.CoreModule.dll
---@field ASTC_HDR_8x8 UnityEngine.TextureFormat
--
--ASTC (10x10 pixel block in 128 bits) compressed RGB(A) HDR texture format.
--
---@source UnityEngine.CoreModule.dll
---@field ASTC_HDR_10x10 UnityEngine.TextureFormat
--
--ASTC (12x12 pixel block in 128 bits) compressed RGB(A) HDR texture format.
--
---@source UnityEngine.CoreModule.dll
---@field ASTC_HDR_12x12 UnityEngine.TextureFormat
--
--Two channel (RG) texture format, 16 bit integer per channel.
--
---@source UnityEngine.CoreModule.dll
---@field RG32 UnityEngine.TextureFormat
--
--Three channel (RGB) texture format, 16 bit integer per channel.
--
---@source UnityEngine.CoreModule.dll
---@field RGB48 UnityEngine.TextureFormat
--
--Four channel (RGBA) texture format, 16 bit integer per channel.
--
---@source UnityEngine.CoreModule.dll
---@field RGBA64 UnityEngine.TextureFormat
--
--ASTC (4x4 pixel block in 128 bits) compressed RGB texture format.
--
---@source UnityEngine.CoreModule.dll
---@field ASTC_RGB_4x4 UnityEngine.TextureFormat
--
--ASTC (5x5 pixel block in 128 bits) compressed RGB texture format.
--
---@source UnityEngine.CoreModule.dll
---@field ASTC_RGB_5x5 UnityEngine.TextureFormat
--
--ASTC (6x6 pixel block in 128 bits) compressed RGB texture format.
--
---@source UnityEngine.CoreModule.dll
---@field ASTC_RGB_6x6 UnityEngine.TextureFormat
--
--ASTC (8x8 pixel block in 128 bits) compressed RGB texture format.
--
---@source UnityEngine.CoreModule.dll
---@field ASTC_RGB_8x8 UnityEngine.TextureFormat
--
--ASTC (10x10 pixel block in 128 bits) compressed RGB texture format.
--
---@source UnityEngine.CoreModule.dll
---@field ASTC_RGB_10x10 UnityEngine.TextureFormat
--
--ASTC (12x12 pixel block in 128 bits) compressed RGB texture format.
--
---@source UnityEngine.CoreModule.dll
---@field ASTC_RGB_12x12 UnityEngine.TextureFormat
--
--ASTC (4x4 pixel block in 128 bits) compressed RGBA texture format.
--
---@source UnityEngine.CoreModule.dll
---@field ASTC_RGBA_4x4 UnityEngine.TextureFormat
--
--ASTC (5x5 pixel block in 128 bits) compressed RGBA texture format.
--
---@source UnityEngine.CoreModule.dll
---@field ASTC_RGBA_5x5 UnityEngine.TextureFormat
--
--ASTC (6x6 pixel block in 128 bits) compressed RGBA texture format.
--
---@source UnityEngine.CoreModule.dll
---@field ASTC_RGBA_6x6 UnityEngine.TextureFormat
--
--ASTC (8x8 pixel block in 128 bits) compressed RGBA texture format.
--
---@source UnityEngine.CoreModule.dll
---@field ASTC_RGBA_8x8 UnityEngine.TextureFormat
--
--ASTC (10x10 pixel block in 128 bits) compressed RGBA texture format.
--
---@source UnityEngine.CoreModule.dll
---@field ASTC_RGBA_10x10 UnityEngine.TextureFormat
--
--ASTC (12x12 pixel block in 128 bits) compressed RGBA texture format.
--
---@source UnityEngine.CoreModule.dll
---@field ASTC_RGBA_12x12 UnityEngine.TextureFormat
---@source UnityEngine.CoreModule.dll
---@field PVRTC_2BPP_RGB UnityEngine.TextureFormat
---@source UnityEngine.CoreModule.dll
---@field PVRTC_2BPP_RGBA UnityEngine.TextureFormat
---@source UnityEngine.CoreModule.dll
---@field PVRTC_4BPP_RGB UnityEngine.TextureFormat
---@source UnityEngine.CoreModule.dll
---@field PVRTC_4BPP_RGBA UnityEngine.TextureFormat
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.TextureFormat = {}

---@source 
---@param value any
---@return UnityEngine.TextureFormat
function CS.UnityEngine.TextureFormat:__CastFrom(value) end


--
--Lightmap (and lighting) configuration mode, controls how lightmaps interact with lighting and what kind of information they store.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.LightmapsMode: System.Enum
--
--Light intensity (no directional information), encoded as 1 lightmap.
--
---@source UnityEngine.CoreModule.dll
---@field NonDirectional UnityEngine.LightmapsMode
--
--Directional information for direct light is combined with directional information for indirect light, encoded as 2 lightmaps.
--
---@source UnityEngine.CoreModule.dll
---@field CombinedDirectional UnityEngine.LightmapsMode
--
--Directional information for direct light is stored separately from directional information for indirect light, encoded as 4 lightmaps.
--
---@source UnityEngine.CoreModule.dll
---@field SeparateDirectional UnityEngine.LightmapsMode
---@source UnityEngine.CoreModule.dll
---@field Single UnityEngine.LightmapsMode
---@source UnityEngine.CoreModule.dll
---@field Dual UnityEngine.LightmapsMode
---@source UnityEngine.CoreModule.dll
---@field Directional UnityEngine.LightmapsMode
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.LightmapsMode = {}

---@source 
---@param value any
---@return UnityEngine.LightmapsMode
function CS.UnityEngine.LightmapsMode:__CastFrom(value) end


--
--How the material interacts with lightmaps and lightprobes.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.MaterialGlobalIlluminationFlags: System.Enum
--
--The emissive lighting does not affect Global Illumination at all.
--
---@source UnityEngine.CoreModule.dll
---@field None UnityEngine.MaterialGlobalIlluminationFlags
--
--The emissive lighting will affect realtime Global Illumination. It emits lighting into realtime lightmaps and realtime lightprobes.
--
---@source UnityEngine.CoreModule.dll
---@field RealtimeEmissive UnityEngine.MaterialGlobalIlluminationFlags
--
--The emissive lighting affects baked Global Illumination. It emits lighting into baked lightmaps and baked lightprobes.
--
---@source UnityEngine.CoreModule.dll
---@field BakedEmissive UnityEngine.MaterialGlobalIlluminationFlags
--
--The emissive lighting is guaranteed to be black. This lets the lightmapping system know that it doesn't have to extract emissive lighting information from the material and can simply assume it is completely black.
--
---@source UnityEngine.CoreModule.dll
---@field EmissiveIsBlack UnityEngine.MaterialGlobalIlluminationFlags
--
--Helper Mask to be used to query the enum only based on whether realtime GI or baked GI is set, ignoring all other bits.
--
---@source UnityEngine.CoreModule.dll
---@field AnyEmissive UnityEngine.MaterialGlobalIlluminationFlags
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.MaterialGlobalIlluminationFlags = {}

---@source 
---@param value any
---@return UnityEngine.MaterialGlobalIlluminationFlags
function CS.UnityEngine.MaterialGlobalIlluminationFlags:__CastFrom(value) end


--
--The Light Probe Proxy Volume component offers the possibility to use higher resolution lighting for large non-static GameObjects.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.LightProbeProxyVolume: UnityEngine.Behaviour
--
--Checks if Light Probe Proxy Volumes are supported.
--
---@source UnityEngine.CoreModule.dll
---@field isFeatureSupported bool
--
--The world-space bounding box in which the 3D grid of interpolated Light Probes is generated.
--
---@source UnityEngine.CoreModule.dll
---@field boundsGlobal UnityEngine.Bounds
--
--The size of the bounding box in which the 3D grid of interpolated Light Probes is generated.
--
---@source UnityEngine.CoreModule.dll
---@field sizeCustom UnityEngine.Vector3
--
--The local-space origin of the bounding box in which the 3D grid of interpolated Light Probes is generated.
--
---@source UnityEngine.CoreModule.dll
---@field originCustom UnityEngine.Vector3
--
--Interpolated Light Probe density.
--
---@source UnityEngine.CoreModule.dll
---@field probeDensity float
--
--The 3D grid resolution on the x-axis.
--
---@source UnityEngine.CoreModule.dll
---@field gridResolutionX int
--
--The 3D grid resolution on the y-axis.
--
---@source UnityEngine.CoreModule.dll
---@field gridResolutionY int
--
--The 3D grid resolution on the z-axis.
--
---@source UnityEngine.CoreModule.dll
---@field gridResolutionZ int
--
--The bounding box mode for generating the 3D grid of interpolated Light Probes.
--
---@source UnityEngine.CoreModule.dll
---@field boundingBoxMode UnityEngine.LightProbeProxyVolume.BoundingBoxMode
--
--The resolution mode for generating the grid of interpolated Light Probes.
--
---@source UnityEngine.CoreModule.dll
---@field resolutionMode UnityEngine.LightProbeProxyVolume.ResolutionMode
--
--The mode in which the interpolated Light Probe positions are generated.
--
---@source UnityEngine.CoreModule.dll
---@field probePositionMode UnityEngine.LightProbeProxyVolume.ProbePositionMode
--
--Sets the way the Light Probe Proxy Volume refreshes.
--
---@source UnityEngine.CoreModule.dll
---@field refreshMode UnityEngine.LightProbeProxyVolume.RefreshMode
--
--Determines how many Spherical Harmonics bands will be evaluated to compute the ambient color.
--
---@source UnityEngine.CoreModule.dll
---@field qualityMode UnityEngine.LightProbeProxyVolume.QualityMode
--
--The texture data format used by the Light Probe Proxy Volume 3D texture.
--
---@source UnityEngine.CoreModule.dll
---@field dataFormat UnityEngine.LightProbeProxyVolume.DataFormat
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.LightProbeProxyVolume = {}

--
--Triggers an update of the Light Probe Proxy Volume.
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.LightProbeProxyVolume.Update() end


--
--The Skinned Mesh filter.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.SkinnedMeshRenderer: UnityEngine.Renderer
--
--The maximum number of bones per vertex that are taken into account during skinning.
--
---@source UnityEngine.CoreModule.dll
---@field quality UnityEngine.SkinQuality
--
--If enabled, the Skinned Mesh will be updated when offscreen. If disabled, this also disables updating animations.
--
---@source UnityEngine.CoreModule.dll
---@field updateWhenOffscreen bool
--
--Forces the Skinned Mesh to recalculate its matricies when rendered
--
---@source UnityEngine.CoreModule.dll
---@field forceMatrixRecalculationPerRender bool
---@source UnityEngine.CoreModule.dll
---@field rootBone UnityEngine.Transform
--
--The bones used to skin the mesh.
--
---@source UnityEngine.CoreModule.dll
---@field bones UnityEngine.Transform[]
--
--The mesh used for skinning.
--
---@source UnityEngine.CoreModule.dll
---@field sharedMesh UnityEngine.Mesh
--
--Specifies whether skinned motion vectors should be used for this renderer.
--
---@source UnityEngine.CoreModule.dll
---@field skinnedMotionVectors bool
--
--AABB of this Skinned Mesh in its local space.
--
---@source UnityEngine.CoreModule.dll
---@field localBounds UnityEngine.Bounds
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.SkinnedMeshRenderer = {}

--
--The weight of the BlendShape.
--
--```plaintext
--Params: index - The index of the BlendShape whose weight you want to retrieve. Index must be smaller than the Mesh.blendShapeCount of the Mesh attached to this Renderer.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param index int
---@return Single
function CS.UnityEngine.SkinnedMeshRenderer.GetBlendShapeWeight(index) end

--
--Sets the weight of a BlendShape for this Renderer.
--
--```plaintext
--Params: index - The index of the BlendShape to modify. Index must be smaller than the Mesh.blendShapeCount of the Mesh attached to this Renderer.
--        value - The weight for this BlendShape.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param index int
---@param value float
function CS.UnityEngine.SkinnedMeshRenderer.SetBlendShapeWeight(index, value) end

--
--Creates a snapshot of SkinnedMeshRenderer and stores it in mesh.
--
--```plaintext
--Params: mesh - A static mesh that will receive the snapshot of the skinned mesh.
--        useScale - Whether to use the SkinnedMeshRenderer's Transform scale when baking the Mesh. If this is true, Unity bakes the Mesh using the position, rotation, and scale values from the SkinnedMeshRenderer's Transform. If this is false, Unity bakes the Mesh using the position and rotation values from the SkinnedMeshRenderer's Transform, but without using the scale value from the SkinnedMeshRenderer's Transform. The default value is false.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
function CS.UnityEngine.SkinnedMeshRenderer.BakeMesh(mesh) end

--
--Creates a snapshot of SkinnedMeshRenderer and stores it in mesh.
--
--```plaintext
--Params: mesh - A static mesh that will receive the snapshot of the skinned mesh.
--        useScale - Whether to use the SkinnedMeshRenderer's Transform scale when baking the Mesh. If this is true, Unity bakes the Mesh using the position, rotation, and scale values from the SkinnedMeshRenderer's Transform. If this is false, Unity bakes the Mesh using the position and rotation values from the SkinnedMeshRenderer's Transform, but without using the scale value from the SkinnedMeshRenderer's Transform. The default value is false.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param mesh UnityEngine.Mesh
---@param useScale bool
function CS.UnityEngine.SkinnedMeshRenderer.BakeMesh(mesh, useScale) end


--
--Renders meshes inserted by the MeshFilter or TextMesh.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.MeshRenderer: UnityEngine.Renderer
--
--Vertex attributes in this mesh will override or add attributes of the primary mesh in the MeshRenderer.
--
---@source UnityEngine.CoreModule.dll
---@field additionalVertexStreams UnityEngine.Mesh
--
--Vertex attributes that override the primary mesh when the MeshRenderer uses lightmaps in the Realtime Global Illumination system.
--
---@source UnityEngine.CoreModule.dll
---@field enlightenVertexStream UnityEngine.Mesh
--
--Index of the first sub-mesh to use from the Mesh associated with this MeshRenderer (Read Only).
--
---@source UnityEngine.CoreModule.dll
---@field subMeshStartIndex int
--
--Specifies the relative lightmap resolution of this object. (Editor only)
--
---@source UnityEngine.CoreModule.dll
---@field scaleInLightmap float
--
--Determines how the object will receive global illumination. (Editor only)
--
---@source UnityEngine.CoreModule.dll
---@field receiveGI UnityEngine.ReceiveGI
--
--When enabled, seams in baked lightmaps will get smoothed. (Editor only)
--
---@source UnityEngine.CoreModule.dll
---@field stitchLightmapSeams bool
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.MeshRenderer = {}


---@source UnityEngine.CoreModule.dll
---@class UnityEngine.LightmappingMode: System.Enum
---@source UnityEngine.CoreModule.dll
---@field Realtime UnityEngine.LightmappingMode
---@source UnityEngine.CoreModule.dll
---@field Baked UnityEngine.LightmappingMode
---@source UnityEngine.CoreModule.dll
---@field Mixed UnityEngine.LightmappingMode
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.LightmappingMode = {}

---@source 
---@param value any
---@return UnityEngine.LightmappingMode
function CS.UnityEngine.LightmappingMode:__CastFrom(value) end


--
--Light Probe Group.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.LightProbeGroup: UnityEngine.Behaviour
--
--Editor only function to access and modify probe positions.
--
---@source UnityEngine.CoreModule.dll
---@field probePositions UnityEngine.Vector3[]
--
--Removes ringing from probes if enabled.
--
---@source UnityEngine.CoreModule.dll
---@field dering bool
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.LightProbeGroup = {}


--
--A collection of common line functions.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.LineUtility: object
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.LineUtility = {}

---@source UnityEngine.CoreModule.dll
---@param points System.Collections.Generic.List<UnityEngine.Vector3>
---@param tolerance float
---@param pointsToKeep System.Collections.Generic.List<int>
function CS.UnityEngine.LineUtility:Simplify(points, tolerance, pointsToKeep) end

---@source UnityEngine.CoreModule.dll
---@param points System.Collections.Generic.List<UnityEngine.Vector3>
---@param tolerance float
---@param simplifiedPoints System.Collections.Generic.List<UnityEngine.Vector3>
function CS.UnityEngine.LineUtility:Simplify(points, tolerance, simplifiedPoints) end

---@source UnityEngine.CoreModule.dll
---@param points System.Collections.Generic.List<UnityEngine.Vector2>
---@param tolerance float
---@param pointsToKeep System.Collections.Generic.List<int>
function CS.UnityEngine.LineUtility:Simplify(points, tolerance, pointsToKeep) end

---@source UnityEngine.CoreModule.dll
---@param points System.Collections.Generic.List<UnityEngine.Vector2>
---@param tolerance float
---@param simplifiedPoints System.Collections.Generic.List<UnityEngine.Vector2>
function CS.UnityEngine.LineUtility:Simplify(points, tolerance, simplifiedPoints) end


--
--The LOD (level of detail) fade modes. Modes other than LODFadeMode.None will result in Unity calculating a blend factor for blending/interpolating between two neighbouring LODs and pass it to your shader.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.LODFadeMode: System.Enum
--
--Indicates the LOD fading is turned off.
--
---@source UnityEngine.CoreModule.dll
---@field None UnityEngine.LODFadeMode
--
--Perform cross-fade style blending between the current LOD and the next LOD if the distance to camera falls in the range specified by the LOD.fadeTransitionWidth of each LOD.
--
---@source UnityEngine.CoreModule.dll
---@field CrossFade UnityEngine.LODFadeMode
--
--By specifying this mode, your LODGroup will perform a SpeedTree-style LOD fading scheme:
--
--
--* For all the mesh LODs other than the last (most crude) mesh LOD, the fade factor is calculated as the percentage of the object's current screen height, compared to the whole range of the LOD. It is 1, if the camera is right at the position where the previous LOD switches out and 0, if the next LOD is just about to switch in.
--
--
--* For the last mesh LOD and the billboard LOD, the cross-fade mode is used.
--
---@source UnityEngine.CoreModule.dll
---@field SpeedTree UnityEngine.LODFadeMode
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.LODFadeMode = {}

---@source 
---@param value any
---@return UnityEngine.LODFadeMode
function CS.UnityEngine.LODFadeMode:__CastFrom(value) end


--
--Structure for building a LOD for passing to the SetLODs function.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.LOD: System.ValueType
--
--The screen relative height to use for the transition [0-1].
--
---@source UnityEngine.CoreModule.dll
---@field screenRelativeTransitionHeight float
--
--Width of the cross-fade transition zone (proportion to the current LOD's whole length) [0-1]. Only used if it's not animated.
--
---@source UnityEngine.CoreModule.dll
---@field fadeTransitionWidth float
--
--List of renderers for this LOD level.
--
---@source UnityEngine.CoreModule.dll
---@field renderers UnityEngine.Renderer[]
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.LOD = {}


--
--LODGroup lets you group multiple Renderers into LOD levels.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.LODGroup: UnityEngine.Component
--
--The local reference point against which the LOD distance is calculated.
--
---@source UnityEngine.CoreModule.dll
---@field localReferencePoint UnityEngine.Vector3
--
--The size of the LOD object in local space.
--
---@source UnityEngine.CoreModule.dll
---@field size float
--
--The number of LOD levels.
--
---@source UnityEngine.CoreModule.dll
---@field lodCount int
--
--The LOD fade mode used.
--
---@source UnityEngine.CoreModule.dll
---@field fadeMode UnityEngine.LODFadeMode
--
--Specify if the cross-fading should be animated by time. The animation duration is specified globally as crossFadeAnimationDuration.
--
---@source UnityEngine.CoreModule.dll
---@field animateCrossFading bool
--
--Allows you to enable or disable the LODGroup.
--
---@source UnityEngine.CoreModule.dll
---@field enabled bool
--
--The cross-fading animation duration in seconds. ArgumentException will be thrown if it is set to zero or a negative value.
--
---@source UnityEngine.CoreModule.dll
---@field crossFadeAnimationDuration float
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.LODGroup = {}

--
--Recalculate the bounding region for the LODGroup (Relatively slow, do not call often).
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.LODGroup.RecalculateBounds() end

--
--The LOD array.
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.LODGroup.GetLODs() end

---@source UnityEngine.CoreModule.dll
---@param lods UnityEngine.LOD[]
function CS.UnityEngine.LODGroup.SetLODS(lods) end

--
--Set the LODs for the LOD group. This will remove any existing LODs configured on the LODGroup.
--
--```plaintext
--Params: lods - The LODs to use for this group.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param lods UnityEngine.LOD[]
function CS.UnityEngine.LODGroup.SetLODs(lods) end

--
--```plaintext
--Params: index - The LOD level to use. Passing index < 0 will return to standard LOD processing.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param index int
function CS.UnityEngine.LODGroup.ForceLOD(index) end


--
--Describes 4 skinning bone weights that affect a vertex in a mesh.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.BoneWeight: System.ValueType
--
--Skinning weight for first bone.
--
---@source UnityEngine.CoreModule.dll
---@field weight0 float
--
--Skinning weight for second bone.
--
---@source UnityEngine.CoreModule.dll
---@field weight1 float
--
--Skinning weight for third bone.
--
---@source UnityEngine.CoreModule.dll
---@field weight2 float
--
--Skinning weight for fourth bone.
--
---@source UnityEngine.CoreModule.dll
---@field weight3 float
--
--Index of first bone.
--
---@source UnityEngine.CoreModule.dll
---@field boneIndex0 int
--
--Index of second bone.
--
---@source UnityEngine.CoreModule.dll
---@field boneIndex1 int
--
--Index of third bone.
--
---@source UnityEngine.CoreModule.dll
---@field boneIndex2 int
--
--Index of fourth bone.
--
---@source UnityEngine.CoreModule.dll
---@field boneIndex3 int
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.BoneWeight = {}

---@source UnityEngine.CoreModule.dll
---@return Int32
function CS.UnityEngine.BoneWeight.GetHashCode() end

---@source UnityEngine.CoreModule.dll
---@param other object
---@return Boolean
function CS.UnityEngine.BoneWeight.Equals(other) end

---@source UnityEngine.CoreModule.dll
---@param other UnityEngine.BoneWeight
---@return Boolean
function CS.UnityEngine.BoneWeight.Equals(other) end

---@source UnityEngine.CoreModule.dll
---@param lhs UnityEngine.BoneWeight
---@param rhs UnityEngine.BoneWeight
---@return Boolean
function CS.UnityEngine.BoneWeight:op_Equality(lhs, rhs) end

---@source UnityEngine.CoreModule.dll
---@param lhs UnityEngine.BoneWeight
---@param rhs UnityEngine.BoneWeight
---@return Boolean
function CS.UnityEngine.BoneWeight:op_Inequality(lhs, rhs) end


--
--Describes a bone weight that affects a vertex in a mesh.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.BoneWeight1: System.ValueType
--
--Skinning weight for bone.
--
---@source UnityEngine.CoreModule.dll
---@field weight float
--
--Index of bone.
--
---@source UnityEngine.CoreModule.dll
---@field boneIndex int
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.BoneWeight1 = {}

---@source UnityEngine.CoreModule.dll
---@param other object
---@return Boolean
function CS.UnityEngine.BoneWeight1.Equals(other) end

---@source UnityEngine.CoreModule.dll
---@param other UnityEngine.BoneWeight1
---@return Boolean
function CS.UnityEngine.BoneWeight1.Equals(other) end

---@source UnityEngine.CoreModule.dll
---@return Int32
function CS.UnityEngine.BoneWeight1.GetHashCode() end

---@source UnityEngine.CoreModule.dll
---@param lhs UnityEngine.BoneWeight1
---@param rhs UnityEngine.BoneWeight1
---@return Boolean
function CS.UnityEngine.BoneWeight1:op_Equality(lhs, rhs) end

---@source UnityEngine.CoreModule.dll
---@param lhs UnityEngine.BoneWeight1
---@param rhs UnityEngine.BoneWeight1
---@return Boolean
function CS.UnityEngine.BoneWeight1:op_Inequality(lhs, rhs) end


--
--Struct used to describe meshes to be combined using Mesh.CombineMeshes.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.CombineInstance: System.ValueType
--
--Mesh to combine.
--
---@source UnityEngine.CoreModule.dll
---@field mesh UnityEngine.Mesh
--
--Sub-Mesh index of the Mesh.
--
---@source UnityEngine.CoreModule.dll
---@field subMeshIndex int
--
--Matrix to transform the Mesh with before combining.
--
---@source UnityEngine.CoreModule.dll
---@field transform UnityEngine.Matrix4x4
--
--The baked lightmap UV scale and offset applied to the Mesh.
--
---@source UnityEngine.CoreModule.dll
---@field lightmapScaleOffset UnityEngine.Vector4
--
--The realtime lightmap UV scale and offset applied to the Mesh.
--
---@source UnityEngine.CoreModule.dll
---@field realtimeLightmapScaleOffset UnityEngine.Vector4
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.CombineInstance = {}


--
--Base class for Texture handling.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.Texture: UnityEngine.Object
--
--Can be used with Texture constructors that take a mip count to indicate that all mips should be generated.  The value of this field is -1.
--
---@source UnityEngine.CoreModule.dll
---@field GenerateAllMips int
---@source UnityEngine.CoreModule.dll
---@field masterTextureLimit int
--
--How many mipmap levels are in this Texture (Read Only).
--
---@source UnityEngine.CoreModule.dll
---@field mipmapCount int
---@source UnityEngine.CoreModule.dll
---@field anisotropicFiltering UnityEngine.AnisotropicFiltering
--
--Returns the GraphicsFormat format or color format of a Texture object.
--
---@source UnityEngine.CoreModule.dll
---@field graphicsFormat UnityEngine.Experimental.Rendering.GraphicsFormat
--
--Width of the Texture in pixels. (Read Only)
--
---@source UnityEngine.CoreModule.dll
---@field width int
--
--Height of the Texture in pixels. (Read Only)
--
---@source UnityEngine.CoreModule.dll
---@field height int
--
--Dimensionality (type) of the Texture (Read Only).
--
---@source UnityEngine.CoreModule.dll
---@field dimension UnityEngine.Rendering.TextureDimension
--
--Whether Unity stores an additional copy of this texture's pixel data in CPU-addressable memory.
--
---@source UnityEngine.CoreModule.dll
---@field isReadable bool
--
--Texture coordinate wrapping mode.
--
---@source UnityEngine.CoreModule.dll
---@field wrapMode UnityEngine.TextureWrapMode
--
--Texture U coordinate wrapping mode.
--
---@source UnityEngine.CoreModule.dll
---@field wrapModeU UnityEngine.TextureWrapMode
--
--Texture V coordinate wrapping mode.
--
---@source UnityEngine.CoreModule.dll
---@field wrapModeV UnityEngine.TextureWrapMode
--
--Texture W coordinate wrapping mode for Texture3D.
--
---@source UnityEngine.CoreModule.dll
---@field wrapModeW UnityEngine.TextureWrapMode
--
--Filtering mode of the Texture.
--
---@source UnityEngine.CoreModule.dll
---@field filterMode UnityEngine.FilterMode
--
--Defines the anisotropic filtering level of the Texture.
--
---@source UnityEngine.CoreModule.dll
---@field anisoLevel int
--
--The mipmap bias of the Texture.
--
---@source UnityEngine.CoreModule.dll
---@field mipMapBias float
---@source UnityEngine.CoreModule.dll
---@field texelSize UnityEngine.Vector2
--
--This counter is incremented when the Texture is updated.
--
---@source UnityEngine.CoreModule.dll
---@field updateCount uint
--
--The hash value of the Texture.
--
---@source UnityEngine.CoreModule.dll
---@field imageContentsHash UnityEngine.Hash128
--
--The total amount of Texture memory that Unity would use if it loads all Textures at mipmap level 0.
--
--This is a theoretical value that does not take into account any input from the streaming system or any other input, for example when you set the`Texture2D.requestedMipmapLevel` manually.
--
--To see a Texture memory value that takes inputs into account, use `desiredTextureMemory`.
--
--`totalTextureMemory` only includes instances of Texture2D and CubeMap Textures. It does not include any other Texture types, or 2D and CubeMap Textures that Unity creates internally.
--
---@source UnityEngine.CoreModule.dll
---@field totalTextureMemory ulong
--
--The total size of the Textures, in bytes, that Unity loads if there were no other constraints. Before Unity loads any Textures, it applies the which reduces the loaded Texture resolution if the Texture sizes exceed its value. The `desiredTextureMemory` value takes into account the mipmap levels that Unity has requested or that you have set manually.
--
--For example, if Unity does not load a Texture at full resolution because it is far away or its requested mipmap level is greater than 0,  Unity reduces the `desiredTextureMemory` value to match the total memory needed.
--
--The `desiredTextureMemory` value can be greater than the `targetTextureMemory` value.
--
---@source UnityEngine.CoreModule.dll
---@field desiredTextureMemory ulong
--
--The total amount of Texture memory that Unity allocates to the Textures in the scene after it applies the and finishes loading Textures. `targetTextureMemory`also takes mipmap streaming settings into account. This value only includes instances of Texture2D and CubeMap Textures. It does not include any other Texture types, or 2D and CubeMap Textures that Unity creates internally.
--
---@source UnityEngine.CoreModule.dll
---@field targetTextureMemory ulong
--
--The amount of memory that all Textures in the scene use.
--
---@source UnityEngine.CoreModule.dll
---@field currentTextureMemory ulong
--
--The amount of memory Unity allocates for non-streaming Textures in the scene. This only includes instances of Texture2D and CubeMap Textures. This does not include any other Texture types, or 2D and CubeMap Textures that Unity creates internally.
--
---@source UnityEngine.CoreModule.dll
---@field nonStreamingTextureMemory ulong
--
--How many times has a Texture been uploaded due to Texture mipmap streaming.
--
---@source UnityEngine.CoreModule.dll
---@field streamingMipmapUploadCount ulong
--
--Number of renderers registered with the Texture streaming system.
--
---@source UnityEngine.CoreModule.dll
---@field streamingRendererCount ulong
--
--Number of streaming Textures.
--
---@source UnityEngine.CoreModule.dll
---@field streamingTextureCount ulong
--
--The number of non-streaming Textures in the scene. This includes instances of Texture2D and CubeMap Textures. This does not include any other Texture types, or 2D and CubeMap Textures that Unity creates internally.
--
---@source UnityEngine.CoreModule.dll
---@field nonStreamingTextureCount ulong
--
--Number of streaming Textures with outstanding mipmaps to be loaded.
--
---@source UnityEngine.CoreModule.dll
---@field streamingTexturePendingLoadCount ulong
--
--Number of streaming Textures with mipmaps currently loading.
--
---@source UnityEngine.CoreModule.dll
---@field streamingTextureLoadingCount ulong
--
--Force streaming Textures to load all mipmap levels.
--
---@source UnityEngine.CoreModule.dll
---@field streamingTextureForceLoadAll bool
--
--This property forces the streaming Texture system to discard all unused mipmaps instead of caching them until the Texture is exceeded. This is useful when you profile or write tests to keep a predictable set of Textures in memory.
--
---@source UnityEngine.CoreModule.dll
---@field streamingTextureDiscardUnusedMips bool
--
--Allow Unity internals to perform Texture creation on any thread (rather than the dedicated render thread).
--
---@source UnityEngine.CoreModule.dll
---@field allowThreadedTextureCreation bool
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.Texture = {}

--
--Sets Anisotropic limits.
--
---@source UnityEngine.CoreModule.dll
---@param forcedMin int
---@param globalMax int
function CS.UnityEngine.Texture:SetGlobalAnisotropicFilteringLimits(forcedMin, globalMax) end

--
--Pointer to an underlying graphics API Texture resource.
--
---@source UnityEngine.CoreModule.dll
---@return IntPtr
function CS.UnityEngine.Texture.GetNativeTexturePtr() end

---@source UnityEngine.CoreModule.dll
---@return Int32
function CS.UnityEngine.Texture.GetNativeTextureID() end

--
--Increment the update counter.
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.Texture.IncrementUpdateCount() end

--
--This function sets mipmap streaming debug properties on any materials that use this Texture through the mipmap streaming system.
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.Texture:SetStreamingTextureMaterialDebugProperties() end


--
--Class that represents textures in C# code.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.Texture2D: UnityEngine.Texture
--
--The format of the pixel data in the texture (Read Only).
--
---@source UnityEngine.CoreModule.dll
---@field format UnityEngine.TextureFormat
--
--Gets a small Texture with all white pixels.
--
---@source UnityEngine.CoreModule.dll
---@field whiteTexture UnityEngine.Texture2D
--
--Gets a small Texture with all black pixels.
--
---@source UnityEngine.CoreModule.dll
---@field blackTexture UnityEngine.Texture2D
--
--Gets a small Texture with all red pixels.
--
---@source UnityEngine.CoreModule.dll
---@field redTexture UnityEngine.Texture2D
--
--Gets a small Texture with all gray pixels.
--
---@source UnityEngine.CoreModule.dll
---@field grayTexture UnityEngine.Texture2D
--
--Gets a small Texture with all gray pixels.
--
---@source UnityEngine.CoreModule.dll
---@field linearGrayTexture UnityEngine.Texture2D
--
--Gets a small Texture with pixels that represent surface normal vectors at a neutral position.
--
---@source UnityEngine.CoreModule.dll
---@field normalTexture UnityEngine.Texture2D
---@source UnityEngine.CoreModule.dll
---@field isReadable bool
--
--Returns true if the VTOnly checkbox was checked when the texture was imported; otherwise returns false. For additional information, see TextureImporter.vtOnly.
--
---@source UnityEngine.CoreModule.dll
---@field vtOnly bool
--
--Determines whether mipmap streaming is enabled for this Texture.
--
---@source UnityEngine.CoreModule.dll
---@field streamingMipmaps bool
--
--Sets the relative priority for this Texture when reducing memory size to fit within the memory budget.
--
---@source UnityEngine.CoreModule.dll
---@field streamingMipmapsPriority int
--
--The mipmap level to load.
--
---@source UnityEngine.CoreModule.dll
---@field requestedMipmapLevel int
--
--Restricts the mipmap streaming system to a minimum mip level for this Texture.
--
---@source UnityEngine.CoreModule.dll
---@field minimumMipmapLevel int
--
--The mipmap level calculated by the streaming system, which takes into account the streaming Cameras and the location of the objects containing this Texture. This is unaffected by requestedMipmapLevel or minimumMipmapLevel.
--
---@source UnityEngine.CoreModule.dll
---@field calculatedMipmapLevel int
--
--The mipmap level that the streaming system would load before memory budgets are applied.
--
---@source UnityEngine.CoreModule.dll
---@field desiredMipmapLevel int
--
--The mipmap level that the mipmap streaming system is in the process of loading.
--
---@source UnityEngine.CoreModule.dll
---@field loadingMipmapLevel int
--
--The mipmap level that is currently loaded by the streaming system.
--
---@source UnityEngine.CoreModule.dll
---@field loadedMipmapLevel int
--
--Indicates whether this texture was imported with TextureImporter.alphaIsTransparency enabled. This setting is available only in the Editor scripts. Note that changing this setting will have no effect; it must be enabled in TextureImporter instead.
--
---@source UnityEngine.CoreModule.dll
---@field alphaIsTransparency bool
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.Texture2D = {}

--
--Compress texture into DXT format.
--
---@source UnityEngine.CoreModule.dll
---@param highQuality bool
function CS.UnityEngine.Texture2D.Compress(highQuality) end

--
--Resets the requestedMipmapLevel field.
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.Texture2D.ClearRequestedMipmapLevel() end

--
--True if the mipmap level requested by requestedMipmapLevel has finished loading.
--
---@source UnityEngine.CoreModule.dll
---@return Boolean
function CS.UnityEngine.Texture2D.IsRequestedMipmapLevelLoaded() end

--
--Resets the minimumMipmapLevel field.
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.Texture2D.ClearMinimumMipmapLevel() end

--
--Updates Unity texture to use different native texture object.
--
--```plaintext
--Params: nativeTex - Native 2D texture object.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nativeTex System.IntPtr
function CS.UnityEngine.Texture2D.UpdateExternalTexture(nativeTex) end

--
--Raw texture data as a byte array.
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.Texture2D.GetRawTextureData() end

--
--An array that contains a copy of the requested pixel colors.
--
--```plaintext
--Params: x - The x position of the pixel array to fetch.
--        y - The y position of the pixel array to fetch.
--        blockWidth - The width length of the pixel array to fetch.
--        blockHeight - The height length of the pixel array to fetch.
--        miplevel - The mip level to read pixel data from. The default is 0.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param x int
---@param y int
---@param blockWidth int
---@param blockHeight int
---@param miplevel int
function CS.UnityEngine.Texture2D.GetPixels(x, y, blockWidth, blockHeight, miplevel) end

---@source UnityEngine.CoreModule.dll
---@param x int
---@param y int
---@param blockWidth int
---@param blockHeight int
function CS.UnityEngine.Texture2D.GetPixels(x, y, blockWidth, blockHeight) end

--
--An array that contains a copy of the requested pixel colors.
--
--```plaintext
--Params: miplevel - The mip level to read pixel data from. The default is 0.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param miplevel int
function CS.UnityEngine.Texture2D.GetPixels32(miplevel) end

---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.Texture2D.GetPixels32() end

--
--An array of rectangles containing the UV coordinates in the atlas for each input texture, or null if packing fails.
--
--```plaintext
--Params: textures - Array of textures to pack into the atlas.
--        padding - Padding in pixels between the packed textures.
--        maximumAtlasSize - Maximum size of the resulting texture.
--        makeNoLongerReadable - Should the texture be marked as no longer readable?
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param textures UnityEngine.Texture2D[]
---@param padding int
---@param maximumAtlasSize int
---@param makeNoLongerReadable bool
function CS.UnityEngine.Texture2D.PackTextures(textures, padding, maximumAtlasSize, makeNoLongerReadable) end

---@source UnityEngine.CoreModule.dll
---@param textures UnityEngine.Texture2D[]
---@param padding int
---@param maximumAtlasSize int
function CS.UnityEngine.Texture2D.PackTextures(textures, padding, maximumAtlasSize) end

---@source UnityEngine.CoreModule.dll
---@param textures UnityEngine.Texture2D[]
---@param padding int
function CS.UnityEngine.Texture2D.PackTextures(textures, padding) end

--
--Creates a Unity Texture out of an externally created native texture object.
--
--```plaintext
--Params: nativeTex - Native 2D texture object.
--        width - Width of texture in pixels.
--        height - Height of texture in pixels.
--        format - Format of underlying texture object.
--        mipmap - Does the texture have mipmaps?
--        linear - Is texture using linear color space?
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param width int
---@param height int
---@param format UnityEngine.TextureFormat
---@param mipChain bool
---@param linear bool
---@param nativeTex System.IntPtr
---@return Texture2D
function CS.UnityEngine.Texture2D:CreateExternalTexture(width, height, format, mipChain, linear, nativeTex) end

--
--Sets pixel color at coordinates (x,y).
--
---@source UnityEngine.CoreModule.dll
---@param x int
---@param y int
---@param color UnityEngine.Color
function CS.UnityEngine.Texture2D.SetPixel(x, y, color) end

---@source UnityEngine.CoreModule.dll
---@param x int
---@param y int
---@param color UnityEngine.Color
---@param mipLevel int
function CS.UnityEngine.Texture2D.SetPixel(x, y, color, mipLevel) end

--
--Set a block of pixel colors.
--
---@source UnityEngine.CoreModule.dll
---@param x int
---@param y int
---@param blockWidth int
---@param blockHeight int
---@param colors UnityEngine.Color[]
---@param miplevel int
function CS.UnityEngine.Texture2D.SetPixels(x, y, blockWidth, blockHeight, colors, miplevel) end

---@source UnityEngine.CoreModule.dll
---@param x int
---@param y int
---@param blockWidth int
---@param blockHeight int
---@param colors UnityEngine.Color[]
function CS.UnityEngine.Texture2D.SetPixels(x, y, blockWidth, blockHeight, colors) end

--
--Set a block of pixel colors.
--
--```plaintext
--Params: colors - The array of pixel colours to assign (a 2D image flattened to a 1D array).
--        miplevel - The mip level of the texture to write to.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param colors UnityEngine.Color[]
---@param miplevel int
function CS.UnityEngine.Texture2D.SetPixels(colors, miplevel) end

---@source UnityEngine.CoreModule.dll
---@param colors UnityEngine.Color[]
function CS.UnityEngine.Texture2D.SetPixels(colors) end

--
--Returns pixel color at coordinates (x, y).
--
---@source UnityEngine.CoreModule.dll
---@param x int
---@param y int
---@return Color
function CS.UnityEngine.Texture2D.GetPixel(x, y) end

---@source UnityEngine.CoreModule.dll
---@param x int
---@param y int
---@param mipLevel int
---@return Color
function CS.UnityEngine.Texture2D.GetPixel(x, y, mipLevel) end

--
--Returns filtered pixel color at normalized coordinates (u, v).
--
---@source UnityEngine.CoreModule.dll
---@param u float
---@param v float
---@return Color
function CS.UnityEngine.Texture2D.GetPixelBilinear(u, v) end

---@source UnityEngine.CoreModule.dll
---@param u float
---@param v float
---@param mipLevel int
---@return Color
function CS.UnityEngine.Texture2D.GetPixelBilinear(u, v, mipLevel) end

--
--Fills texture pixels with raw preformatted data.
--
--```plaintext
--Params: data - Raw data array to initialize texture pixels with.
--        size - Size of data in bytes.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param data System.IntPtr
---@param size int
function CS.UnityEngine.Texture2D.LoadRawTextureData(data, size) end

--
--Fills texture pixels with raw preformatted data.
--
--```plaintext
--Params: data - Raw data array to initialize texture pixels with.
--        size - Size of data in bytes.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param data byte[]
function CS.UnityEngine.Texture2D.LoadRawTextureData(data) end

---@source UnityEngine.CoreModule.dll
---@param data Unity.Collections.NativeArray<T>
function CS.UnityEngine.Texture2D.LoadRawTextureData(data) end

---@source UnityEngine.CoreModule.dll
---@param data T[]
---@param mipLevel int
---@param sourceDataStartIndex int
function CS.UnityEngine.Texture2D.SetPixelData(data, mipLevel, sourceDataStartIndex) end

---@source UnityEngine.CoreModule.dll
---@param data Unity.Collections.NativeArray<T>
---@param mipLevel int
---@param sourceDataStartIndex int
function CS.UnityEngine.Texture2D.SetPixelData(data, mipLevel, sourceDataStartIndex) end

---@source UnityEngine.CoreModule.dll
---@param mipLevel int
---@return NativeArray
function CS.UnityEngine.Texture2D.GetPixelData(mipLevel) end

---@source UnityEngine.CoreModule.dll
---@return NativeArray
function CS.UnityEngine.Texture2D.GetRawTextureData() end

--
--Actually apply all previous SetPixel and SetPixels changes.
--
--```plaintext
--Params: updateMipmaps - When set to true, mipmap levels are recalculated.
--        makeNoLongerReadable - When set to true, Unity discards the copy of pixel data in CPU-addressable memory after this operation.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param updateMipmaps bool
---@param makeNoLongerReadable bool
function CS.UnityEngine.Texture2D.Apply(updateMipmaps, makeNoLongerReadable) end

---@source UnityEngine.CoreModule.dll
---@param updateMipmaps bool
function CS.UnityEngine.Texture2D.Apply(updateMipmaps) end

---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.Texture2D.Apply() end

--
--Resizes the texture.
--
---@source UnityEngine.CoreModule.dll
---@param width int
---@param height int
---@return Boolean
function CS.UnityEngine.Texture2D.Resize(width, height) end

--
--Resizes the texture.
--
---@source UnityEngine.CoreModule.dll
---@param width int
---@param height int
---@param format UnityEngine.TextureFormat
---@param hasMipMap bool
---@return Boolean
function CS.UnityEngine.Texture2D.Resize(width, height, format, hasMipMap) end

---@source UnityEngine.CoreModule.dll
---@param width int
---@param height int
---@param format UnityEngine.Experimental.Rendering.GraphicsFormat
---@param hasMipMap bool
---@return Boolean
function CS.UnityEngine.Texture2D.Resize(width, height, format, hasMipMap) end

--
--Reads the pixels from the current render target (the screen, or a RenderTexture), and writes them to the texture.
--
--```plaintext
--Params: source - The region of the render target to read from.
--        destX - The horizontal pixel position in the texture to write the pixels to.
--        destY - The vertical pixel position in the texture to write the pixels to.
--        recalculateMipMaps - If this parameter is true, Unity automatically recalculates the mipmaps for the texture after writing the pixel data. Otherwise, Unity does not do this automatically.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param source UnityEngine.Rect
---@param destX int
---@param destY int
---@param recalculateMipMaps bool
function CS.UnityEngine.Texture2D.ReadPixels(source, destX, destY, recalculateMipMaps) end

---@source UnityEngine.CoreModule.dll
---@param source UnityEngine.Rect
---@param destX int
---@param destY int
function CS.UnityEngine.Texture2D.ReadPixels(source, destX, destY) end

---@source UnityEngine.CoreModule.dll
---@param sizes UnityEngine.Vector2[]
---@param padding int
---@param atlasSize int
---@param results System.Collections.Generic.List<UnityEngine.Rect>
---@return Boolean
function CS.UnityEngine.Texture2D:GenerateAtlas(sizes, padding, atlasSize, results) end

--
--Set a block of pixel colors.
--
---@source UnityEngine.CoreModule.dll
---@param colors UnityEngine.Color32[]
---@param miplevel int
function CS.UnityEngine.Texture2D.SetPixels32(colors, miplevel) end

---@source UnityEngine.CoreModule.dll
---@param colors UnityEngine.Color32[]
function CS.UnityEngine.Texture2D.SetPixels32(colors) end

--
--Set a block of pixel colors.
--
---@source UnityEngine.CoreModule.dll
---@param x int
---@param y int
---@param blockWidth int
---@param blockHeight int
---@param colors UnityEngine.Color32[]
---@param miplevel int
function CS.UnityEngine.Texture2D.SetPixels32(x, y, blockWidth, blockHeight, colors, miplevel) end

---@source UnityEngine.CoreModule.dll
---@param x int
---@param y int
---@param blockWidth int
---@param blockHeight int
---@param colors UnityEngine.Color32[]
function CS.UnityEngine.Texture2D.SetPixels32(x, y, blockWidth, blockHeight, colors) end

--
--An array that contains a copy of the requested pixel colors.
--
--```plaintext
--Params: miplevel - The mip level to read pixel data from. The default is 0.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param miplevel int
function CS.UnityEngine.Texture2D.GetPixels(miplevel) end

---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.Texture2D.GetPixels() end


--
--The resolution mode for generating a grid of interpolated Light Probes.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.ResolutionMode: System.Enum
--
--The automatic mode uses a number of interpolated Light Probes per unit area, and uses the bounding volume size to compute the resolution. The final resolution value is a power of 2.
--
---@source UnityEngine.CoreModule.dll
---@field Automatic UnityEngine.LightProbeProxyVolume.ResolutionMode
--
--The custom mode allows you to specify the 3D grid resolution.
--
---@source UnityEngine.CoreModule.dll
---@field Custom UnityEngine.LightProbeProxyVolume.ResolutionMode
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.ResolutionMode = {}

---@source 
---@param value any
---@return UnityEngine.LightProbeProxyVolume.ResolutionMode
function CS.UnityEngine.ResolutionMode:__CastFrom(value) end


--
--The bounding box mode for generating a grid of interpolated Light Probes.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.BoundingBoxMode: System.Enum
--
--The bounding box encloses the current Renderer and all the relevant Renderers down the hierarchy, in local space.
--
---@source UnityEngine.CoreModule.dll
---@field AutomaticLocal UnityEngine.LightProbeProxyVolume.BoundingBoxMode
--
--The bounding box encloses the current Renderer and all the relevant Renderers down the hierarchy, in world space.
--
---@source UnityEngine.CoreModule.dll
---@field AutomaticWorld UnityEngine.LightProbeProxyVolume.BoundingBoxMode
--
--A custom local-space bounding box is used. The user is able to edit the bounding box.
--
---@source UnityEngine.CoreModule.dll
---@field Custom UnityEngine.LightProbeProxyVolume.BoundingBoxMode
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.BoundingBoxMode = {}

---@source 
---@param value any
---@return UnityEngine.LightProbeProxyVolume.BoundingBoxMode
function CS.UnityEngine.BoundingBoxMode:__CastFrom(value) end


--
--The mode in which the interpolated Light Probe positions are generated.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.ProbePositionMode: System.Enum
--
--Divide the volume in cells based on resolution, and generate interpolated Light Probes positions in the corner/edge of the cells.
--
---@source UnityEngine.CoreModule.dll
---@field CellCorner UnityEngine.LightProbeProxyVolume.ProbePositionMode
--
--Divide the volume in cells based on resolution, and generate interpolated Light Probe positions in the center of the cells.
--
---@source UnityEngine.CoreModule.dll
---@field CellCenter UnityEngine.LightProbeProxyVolume.ProbePositionMode
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.ProbePositionMode = {}

---@source 
---@param value any
---@return UnityEngine.LightProbeProxyVolume.ProbePositionMode
function CS.UnityEngine.ProbePositionMode:__CastFrom(value) end


--
--An enum describing the way a Light Probe Proxy Volume refreshes in the Player.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.RefreshMode: System.Enum
--
--Automatically detects updates in Light Probes and triggers an update of the Light Probe volume.
--
---@source UnityEngine.CoreModule.dll
---@field Automatic UnityEngine.LightProbeProxyVolume.RefreshMode
--
--Causes Unity to update the Light Probe Proxy Volume every frame.
--
---@source UnityEngine.CoreModule.dll
---@field EveryFrame UnityEngine.LightProbeProxyVolume.RefreshMode
--
--Use this option to indicate that the Light Probe Proxy Volume is never to be automatically updated by Unity.
--
---@source UnityEngine.CoreModule.dll
---@field ViaScripting UnityEngine.LightProbeProxyVolume.RefreshMode
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.RefreshMode = {}

---@source 
---@param value any
---@return UnityEngine.LightProbeProxyVolume.RefreshMode
function CS.UnityEngine.RefreshMode:__CastFrom(value) end


--
--An enum describing the Quality option used by the Light Probe Proxy Volume component.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.QualityMode: System.Enum
--
--This option will use only two SH coefficients bands: L0 and L1. The coefficients are sampled from the Light Probe Proxy Volume 3D Texture. Using this option might increase the draw call batch sizes by not having to change the L2 coefficients per Renderer.
--
---@source UnityEngine.CoreModule.dll
---@field Low UnityEngine.LightProbeProxyVolume.QualityMode
--
--This option will use L0 and L1 SH coefficients from the Light Probe Proxy Volume 3D Texture. The L2 coefficients are constant per Renderer. By having to provide the L2 coefficients, draw call batches might be broken.
--
---@source UnityEngine.CoreModule.dll
---@field Normal UnityEngine.LightProbeProxyVolume.QualityMode
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.QualityMode = {}

---@source 
---@param value any
---@return UnityEngine.LightProbeProxyVolume.QualityMode
function CS.UnityEngine.QualityMode:__CastFrom(value) end


--
--Flags used to control the encoding to an EXR file.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.EXRFlags: System.Enum
--
--No flag. This will result in an uncompressed 16-bit float EXR file.
--
---@source UnityEngine.CoreModule.dll
---@field None UnityEngine.Texture2D.EXRFlags
--
--The texture will be exported as a 32-bit float EXR file (default is 16-bit).
--
---@source UnityEngine.CoreModule.dll
---@field OutputAsFloat UnityEngine.Texture2D.EXRFlags
--
--The texture will use the EXR ZIP compression format.
--
---@source UnityEngine.CoreModule.dll
---@field CompressZIP UnityEngine.Texture2D.EXRFlags
--
--The texture will use RLE (Run Length Encoding) EXR compression format (similar to Targa RLE compression).
--
---@source UnityEngine.CoreModule.dll
---@field CompressRLE UnityEngine.Texture2D.EXRFlags
--
--This texture will use Wavelet compression. This is best used for grainy images.
--
---@source UnityEngine.CoreModule.dll
---@field CompressPIZ UnityEngine.Texture2D.EXRFlags
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.EXRFlags = {}

---@source 
---@param value any
---@return UnityEngine.Texture2D.EXRFlags
function CS.UnityEngine.EXRFlags:__CastFrom(value) end


--
--The texture data format used by the Light Probe Proxy Volume 3D texture.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.DataFormat: System.Enum
--
--A 16-bit half floating-point format is used for the Light Probe Proxy Volume 3D texture.
--
---@source UnityEngine.CoreModule.dll
---@field HalfFloat UnityEngine.LightProbeProxyVolume.DataFormat
--
--A 32-bit floating-point format is used for the Light Probe Proxy Volume 3D texture.
--
---@source UnityEngine.CoreModule.dll
---@field Float UnityEngine.LightProbeProxyVolume.DataFormat
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.DataFormat = {}

---@source 
---@param value any
---@return UnityEngine.LightProbeProxyVolume.DataFormat
function CS.UnityEngine.DataFormat:__CastFrom(value) end


--
--Specify the source of a Custom Render Texture initialization.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.CustomRenderTextureInitializationSource: System.Enum
--
--Custom Render Texture is initialized by a Texture multiplied by a Color.
--
---@source UnityEngine.CoreModule.dll
---@field TextureAndColor UnityEngine.CustomRenderTextureInitializationSource
--
--Custom Render Texture is initalized with a Material.
--
---@source UnityEngine.CoreModule.dll
---@field Material UnityEngine.CustomRenderTextureInitializationSource
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.CustomRenderTextureInitializationSource = {}

---@source 
---@param value any
---@return UnityEngine.CustomRenderTextureInitializationSource
function CS.UnityEngine.CustomRenderTextureInitializationSource:__CastFrom(value) end


--
--Frequency of update or initialization of a Custom Render Texture.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.CustomRenderTextureUpdateMode: System.Enum
--
--Initialization/Update will occur once at load time and then can be triggered again by script.
--
---@source UnityEngine.CoreModule.dll
---@field OnLoad UnityEngine.CustomRenderTextureUpdateMode
--
--Initialization/Update will occur at every frame.
--
---@source UnityEngine.CoreModule.dll
---@field Realtime UnityEngine.CustomRenderTextureUpdateMode
--
--Initialization/Update will only occur when triggered by the script.
--
---@source UnityEngine.CoreModule.dll
---@field OnDemand UnityEngine.CustomRenderTextureUpdateMode
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.CustomRenderTextureUpdateMode = {}

---@source 
---@param value any
---@return UnityEngine.CustomRenderTextureUpdateMode
function CS.UnityEngine.CustomRenderTextureUpdateMode:__CastFrom(value) end


--
--Space in which coordinates are provided for Update Zones.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.CustomRenderTextureUpdateZoneSpace: System.Enum
--
--Coordinates are normalized. (0, 0) is top left and (1, 1) is bottom right.
--
---@source UnityEngine.CoreModule.dll
---@field Normalized UnityEngine.CustomRenderTextureUpdateZoneSpace
--
--Coordinates are expressed in pixels. (0, 0) is top left (width, height) is bottom right.
--
---@source UnityEngine.CoreModule.dll
---@field Pixel UnityEngine.CustomRenderTextureUpdateZoneSpace
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.CustomRenderTextureUpdateZoneSpace = {}

---@source 
---@param value any
---@return UnityEngine.CustomRenderTextureUpdateZoneSpace
function CS.UnityEngine.CustomRenderTextureUpdateZoneSpace:__CastFrom(value) end


--
--The type of motion vectors that should be generated.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.MotionVectorGenerationMode: System.Enum
--
--Use only camera movement to track motion.
--
---@source UnityEngine.CoreModule.dll
---@field Camera UnityEngine.MotionVectorGenerationMode
--
--Use a specific pass (if required) to track motion.
--
---@source UnityEngine.CoreModule.dll
---@field Object UnityEngine.MotionVectorGenerationMode
--
--Do not track motion. Motion vectors will be 0.
--
---@source UnityEngine.CoreModule.dll
---@field ForceNoMotion UnityEngine.MotionVectorGenerationMode
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.MotionVectorGenerationMode = {}

---@source 
---@param value any
---@return UnityEngine.MotionVectorGenerationMode
function CS.UnityEngine.MotionVectorGenerationMode:__CastFrom(value) end


--
--Choose how textures are applied to Lines and Trails.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.LineTextureMode: System.Enum
--
--Map the texture once along the entire length of the line.
--
---@source UnityEngine.CoreModule.dll
---@field Stretch UnityEngine.LineTextureMode
--
--Repeat the texture along the line, based on its length in world units. To set the tiling rate, use Material.SetTextureScale.
--
---@source UnityEngine.CoreModule.dll
---@field Tile UnityEngine.LineTextureMode
--
--Map the texture once along the entire length of the line, assuming all vertices are evenly spaced.
--
---@source UnityEngine.CoreModule.dll
---@field DistributePerSegment UnityEngine.LineTextureMode
--
--Repeat the texture along the line, repeating at a rate of once per line segment. To adjust the tiling rate, use Material.SetTextureScale.
--
---@source UnityEngine.CoreModule.dll
---@field RepeatPerSegment UnityEngine.LineTextureMode
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.LineTextureMode = {}

---@source 
---@param value any
---@return UnityEngine.LineTextureMode
function CS.UnityEngine.LineTextureMode:__CastFrom(value) end


--
--Control the direction lines face, when using the LineRenderer or TrailRenderer.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.LineAlignment: System.Enum
--
--Lines face the camera.
--
---@source UnityEngine.CoreModule.dll
---@field View UnityEngine.LineAlignment
--
--Lines face the direction of the Transform Component.
--
---@source UnityEngine.CoreModule.dll
---@field Local UnityEngine.LineAlignment
--
--Lines face the Z axis of the Transform Component.
--
---@source UnityEngine.CoreModule.dll
---@field TransformZ UnityEngine.LineAlignment
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.LineAlignment = {}

---@source 
---@param value any
---@return UnityEngine.LineAlignment
function CS.UnityEngine.LineAlignment:__CastFrom(value) end


--
--Class for handling cube maps, Use this to create or modify existing.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.Cubemap: UnityEngine.Texture
--
--The format of the pixel data in the texture (Read Only).
--
---@source UnityEngine.CoreModule.dll
---@field format UnityEngine.TextureFormat
---@source UnityEngine.CoreModule.dll
---@field isReadable bool
--
--Determines whether mipmap streaming is enabled for this Texture.
--
---@source UnityEngine.CoreModule.dll
---@field streamingMipmaps bool
--
--Sets the relative priority for this Texture when reducing memory size to fit within the memory budget.
--
---@source UnityEngine.CoreModule.dll
---@field streamingMipmapsPriority int
--
--The mipmap level to load.
--
---@source UnityEngine.CoreModule.dll
---@field requestedMipmapLevel int
--
--The mipmap level that the streaming system would load before memory budgets are applied.
--
---@source UnityEngine.CoreModule.dll
---@field desiredMipmapLevel int
--
--The mipmap level that the mipmap streaming system is in the process of loading.
--
---@source UnityEngine.CoreModule.dll
---@field loadingMipmapLevel int
--
--The mipmap level that is currently loaded by the streaming system.
--
---@source UnityEngine.CoreModule.dll
---@field loadedMipmapLevel int
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.Cubemap = {}

--
--Updates Unity cubemap to use different native cubemap texture object.
--
--```plaintext
--Params: nativeTexture - Native cubemap texture object.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nativeTexture System.IntPtr
function CS.UnityEngine.Cubemap.UpdateExternalTexture(nativeTexture) end

--
--Performs smoothing of near edge regions.
--
--```plaintext
--Params: smoothRegionWidthInPixels - Pixel distance at edges over which to apply smoothing.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param smoothRegionWidthInPixels int
function CS.UnityEngine.Cubemap.SmoothEdges(smoothRegionWidthInPixels) end

---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.Cubemap.SmoothEdges() end

--
--An array that contains a copy of the requested pixel colors, represented by Color structs.
--
--```plaintext
--Params: face - The cubemap face to read pixel data from.
--        miplevel - The mip level to read pixel data from. The default is 0.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param face UnityEngine.CubemapFace
---@param miplevel int
function CS.UnityEngine.Cubemap.GetPixels(face, miplevel) end

---@source UnityEngine.CoreModule.dll
---@param face UnityEngine.CubemapFace
function CS.UnityEngine.Cubemap.GetPixels(face) end

--
--Sets pixel colors of a cubemap face.
--
--```plaintext
--Params: colors - Pixel data for the Cubemap face.
--        face - The face to which the new data should be applied.
--        miplevel - The mipmap level for the face.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param colors UnityEngine.Color[]
---@param face UnityEngine.CubemapFace
---@param miplevel int
function CS.UnityEngine.Cubemap.SetPixels(colors, face, miplevel) end

---@source UnityEngine.CoreModule.dll
---@param colors UnityEngine.Color[]
---@param face UnityEngine.CubemapFace
function CS.UnityEngine.Cubemap.SetPixels(colors, face) end

--
--Resets the requestedMipmapLevel field.
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.Cubemap.ClearRequestedMipmapLevel() end

--
--True if the mipmap level requested by requestedMipmapLevel has finished loading.
--
---@source UnityEngine.CoreModule.dll
---@return Boolean
function CS.UnityEngine.Cubemap.IsRequestedMipmapLevelLoaded() end

--
--Creates a Unity cubemap out of externally created native cubemap object.
--
--```plaintext
--Params: size - The width and height of each face of the cubemap should be the same.
--        format - Format of underlying cubemap object.
--        mipmap - Does the cubemap have mipmaps?
--        nativeTex - Native cubemap texture object.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param width int
---@param format UnityEngine.TextureFormat
---@param mipmap bool
---@param nativeTex System.IntPtr
---@return Cubemap
function CS.UnityEngine.Cubemap:CreateExternalTexture(width, format, mipmap, nativeTex) end

---@source UnityEngine.CoreModule.dll
---@param data T[]
---@param mipLevel int
---@param face UnityEngine.CubemapFace
---@param sourceDataStartIndex int
function CS.UnityEngine.Cubemap.SetPixelData(data, mipLevel, face, sourceDataStartIndex) end

---@source UnityEngine.CoreModule.dll
---@param data Unity.Collections.NativeArray<T>
---@param mipLevel int
---@param face UnityEngine.CubemapFace
---@param sourceDataStartIndex int
function CS.UnityEngine.Cubemap.SetPixelData(data, mipLevel, face, sourceDataStartIndex) end

---@source UnityEngine.CoreModule.dll
---@param mipLevel int
---@param face UnityEngine.CubemapFace
---@return NativeArray
function CS.UnityEngine.Cubemap.GetPixelData(mipLevel, face) end

--
--Sets pixel color at coordinates (face, x, y).
--
---@source UnityEngine.CoreModule.dll
---@param face UnityEngine.CubemapFace
---@param x int
---@param y int
---@param color UnityEngine.Color
function CS.UnityEngine.Cubemap.SetPixel(face, x, y, color) end

--
--Returns pixel color at coordinates (face, x, y).
--
---@source UnityEngine.CoreModule.dll
---@param face UnityEngine.CubemapFace
---@param x int
---@param y int
---@return Color
function CS.UnityEngine.Cubemap.GetPixel(face, x, y) end

--
--Actually apply all previous SetPixel and SetPixels changes.
--
--```plaintext
--Params: updateMipmaps - When set to true, mipmap levels are recalculated.
--        makeNoLongerReadable - When set to true, Unity discards the copy of pixel data in CPU-addressable memory after this operation.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param updateMipmaps bool
---@param makeNoLongerReadable bool
function CS.UnityEngine.Cubemap.Apply(updateMipmaps, makeNoLongerReadable) end

---@source UnityEngine.CoreModule.dll
---@param updateMipmaps bool
function CS.UnityEngine.Cubemap.Apply(updateMipmaps) end

---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.Cubemap.Apply() end


--
--Class for handling 3D Textures, Use this to create.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.Texture3D: UnityEngine.Texture
--
--The depth of the texture (Read Only).
--
---@source UnityEngine.CoreModule.dll
---@field depth int
--
--The format of the pixel data in the texture (Read Only).
--
---@source UnityEngine.CoreModule.dll
---@field format UnityEngine.TextureFormat
---@source UnityEngine.CoreModule.dll
---@field isReadable bool
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.Texture3D = {}

--
--Updates Unity texture to use different native texture object.
--
--```plaintext
--Params: nativeTex - Native 3D texture object.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param nativeTex System.IntPtr
function CS.UnityEngine.Texture3D.UpdateExternalTexture(nativeTex) end

--
--An array that contains a copy of the requested pixel colors, represented by Color structs.
--
--```plaintext
--Params: miplevel - The mip level to read pixel data from. The default is 0.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param miplevel int
function CS.UnityEngine.Texture3D.GetPixels(miplevel) end

---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.Texture3D.GetPixels() end

--
--An array that contains a copy of the requested pixel colors.
--
--```plaintext
--Params: miplevel - The mip level to read pixel data from. The default is 0.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param miplevel int
function CS.UnityEngine.Texture3D.GetPixels32(miplevel) end

---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.Texture3D.GetPixels32() end

--
--Sets pixel colors of a 3D texture.
--
--```plaintext
--Params: colors - The colors to set the pixels to.
--        miplevel - The mipmap level to be affected by the new colors.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param colors UnityEngine.Color[]
---@param miplevel int
function CS.UnityEngine.Texture3D.SetPixels(colors, miplevel) end

---@source UnityEngine.CoreModule.dll
---@param colors UnityEngine.Color[]
function CS.UnityEngine.Texture3D.SetPixels(colors) end

--
--Sets pixel colors of a 3D texture.
--
--```plaintext
--Params: colors - The colors to set the pixels to.
--        miplevel - The mipmap level to be affected by the new colors.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param colors UnityEngine.Color32[]
---@param miplevel int
function CS.UnityEngine.Texture3D.SetPixels32(colors, miplevel) end

---@source UnityEngine.CoreModule.dll
---@param colors UnityEngine.Color32[]
function CS.UnityEngine.Texture3D.SetPixels32(colors) end

--
--Creates Unity Texture out of externally created native texture object.
--
--```plaintext
--Params: nativeTex - Native 3D texture object.
--        width - Width of texture in pixels.
--        height - Height of texture in pixels.
--        depth - Depth of texture in pixels
--        format - Format of underlying texture object.
--        mipmap - Does the texture have mipmaps?
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param width int
---@param height int
---@param depth int
---@param format UnityEngine.TextureFormat
---@param mipChain bool
---@param nativeTex System.IntPtr
---@return Texture3D
function CS.UnityEngine.Texture3D:CreateExternalTexture(width, height, depth, format, mipChain, nativeTex) end

--
--Actually apply all previous SetPixels changes.
--
--```plaintext
--Params: updateMipmaps - When set to true, mipmap levels are recalculated.
--        makeNoLongerReadable - Whether to discard the copy of pixel data in CPU-addressable memory after this operation.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param updateMipmaps bool
---@param makeNoLongerReadable bool
function CS.UnityEngine.Texture3D.Apply(updateMipmaps, makeNoLongerReadable) end

---@source UnityEngine.CoreModule.dll
---@param updateMipmaps bool
function CS.UnityEngine.Texture3D.Apply(updateMipmaps) end

---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.Texture3D.Apply() end

---@source UnityEngine.CoreModule.dll
---@param x int
---@param y int
---@param z int
---@param color UnityEngine.Color
function CS.UnityEngine.Texture3D.SetPixel(x, y, z, color) end

--
--Sets the pixel color that represents one mip level of the 3D texture at coordinates (x,y,z).
--
--```plaintext
--Params: x - X coordinate to access a pixel.
--        y - Y coordinate to access a pixel.
--        z - Z coordinate to access a pixel.
--        color - The colors to set the pixels to.
--        mipLevel - The mipmap level to be affected by the new colors.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param x int
---@param y int
---@param z int
---@param color UnityEngine.Color
---@param mipLevel int
function CS.UnityEngine.Texture3D.SetPixel(x, y, z, color, mipLevel) end

---@source UnityEngine.CoreModule.dll
---@param x int
---@param y int
---@param z int
---@return Color
function CS.UnityEngine.Texture3D.GetPixel(x, y, z) end

--
--The color of the pixel.
--
--```plaintext
--Params: x - X coordinate to access a pixel.
--        y - Y coordinate to access a pixel.
--        z - Z coordinate to access a pixel.
--        mipLevel - The mipmap level to be accessed.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param x int
---@param y int
---@param z int
---@param mipLevel int
---@return Color
function CS.UnityEngine.Texture3D.GetPixel(x, y, z, mipLevel) end

---@source UnityEngine.CoreModule.dll
---@param u float
---@param v float
---@param w float
---@return Color
function CS.UnityEngine.Texture3D.GetPixelBilinear(u, v, w) end

--
--The colors to return by bilinear filtering.
--
--```plaintext
--Params: u - U normalized coordinate to access a pixel.
--        v - V normalized coordinate to access a pixel.
--        w - W normalized coordinate to access a pixel.
--        mipLevel - The mipmap level to be accessed.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param u float
---@param v float
---@param w float
---@param mipLevel int
---@return Color
function CS.UnityEngine.Texture3D.GetPixelBilinear(u, v, w, mipLevel) end

---@source UnityEngine.CoreModule.dll
---@param data T[]
---@param mipLevel int
---@param sourceDataStartIndex int
function CS.UnityEngine.Texture3D.SetPixelData(data, mipLevel, sourceDataStartIndex) end

---@source UnityEngine.CoreModule.dll
---@param data Unity.Collections.NativeArray<T>
---@param mipLevel int
---@param sourceDataStartIndex int
function CS.UnityEngine.Texture3D.SetPixelData(data, mipLevel, sourceDataStartIndex) end

---@source UnityEngine.CoreModule.dll
---@param mipLevel int
---@return NativeArray
function CS.UnityEngine.Texture3D.GetPixelData(mipLevel) end


--
--Class for handling 2D texture arrays.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.Texture2DArray: UnityEngine.Texture
--
--Read Only. This property is used as a parameter in some overloads of the CommandBuffer.Blit, Graphics.Blit, CommandBuffer.SetRenderTarget, and Graphics.SetRenderTarget methods to indicate that all texture array slices are bound. The value of this property is -1.
--
---@source UnityEngine.CoreModule.dll
---@field allSlices int
--
--Number of elements in a texture array (Read Only).
--
---@source UnityEngine.CoreModule.dll
---@field depth int
--
--Texture format (Read Only).
--
---@source UnityEngine.CoreModule.dll
---@field format UnityEngine.TextureFormat
---@source UnityEngine.CoreModule.dll
---@field isReadable bool
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.Texture2DArray = {}

--
--An array that contains a copy of the requested pixel colors.
--
--```plaintext
--Params: arrayElement - The array slice to read pixel data from.
--        miplevel - The mip level to read pixel data from. The default is 0.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param arrayElement int
---@param miplevel int
function CS.UnityEngine.Texture2DArray.GetPixels(arrayElement, miplevel) end

---@source UnityEngine.CoreModule.dll
---@param arrayElement int
function CS.UnityEngine.Texture2DArray.GetPixels(arrayElement) end

--
--An array that contains a copy of the requested pixel colors.
--
--```plaintext
--Params: arrayElement - The array slice to read pixel data from.
--        miplevel - The mip level to read pixel data from. The default is 0.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param arrayElement int
---@param miplevel int
function CS.UnityEngine.Texture2DArray.GetPixels32(arrayElement, miplevel) end

---@source UnityEngine.CoreModule.dll
---@param arrayElement int
function CS.UnityEngine.Texture2DArray.GetPixels32(arrayElement) end

--
--Set pixel colors for the whole mip level.
--
--```plaintext
--Params: colors - An array of pixel colors.
--        arrayElement - The texture array element index.
--        miplevel - The mip level.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param colors UnityEngine.Color[]
---@param arrayElement int
---@param miplevel int
function CS.UnityEngine.Texture2DArray.SetPixels(colors, arrayElement, miplevel) end

---@source UnityEngine.CoreModule.dll
---@param colors UnityEngine.Color[]
---@param arrayElement int
function CS.UnityEngine.Texture2DArray.SetPixels(colors, arrayElement) end

--
--Set pixel colors for the whole mip level.
--
--```plaintext
--Params: colors - An array of pixel colors.
--        arrayElement - The texture array element index.
--        miplevel - The mip level.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param colors UnityEngine.Color32[]
---@param arrayElement int
---@param miplevel int
function CS.UnityEngine.Texture2DArray.SetPixels32(colors, arrayElement, miplevel) end

---@source UnityEngine.CoreModule.dll
---@param colors UnityEngine.Color32[]
---@param arrayElement int
function CS.UnityEngine.Texture2DArray.SetPixels32(colors, arrayElement) end

--
--Actually apply all previous SetPixels changes.
--
--```plaintext
--Params: updateMipmaps - When set to true, mipmap levels are recalculated.
--        makeNoLongerReadable - When set to true, Unity discards the copy of pixel data in CPU-addressable memory after this operation.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param updateMipmaps bool
---@param makeNoLongerReadable bool
function CS.UnityEngine.Texture2DArray.Apply(updateMipmaps, makeNoLongerReadable) end

---@source UnityEngine.CoreModule.dll
---@param data T[]
---@param mipLevel int
---@param element int
---@param sourceDataStartIndex int
function CS.UnityEngine.Texture2DArray.SetPixelData(data, mipLevel, element, sourceDataStartIndex) end

---@source UnityEngine.CoreModule.dll
---@param data Unity.Collections.NativeArray<T>
---@param mipLevel int
---@param element int
---@param sourceDataStartIndex int
function CS.UnityEngine.Texture2DArray.SetPixelData(data, mipLevel, element, sourceDataStartIndex) end

---@source UnityEngine.CoreModule.dll
---@param mipLevel int
---@param element int
---@return NativeArray
function CS.UnityEngine.Texture2DArray.GetPixelData(mipLevel, element) end

---@source UnityEngine.CoreModule.dll
---@param updateMipmaps bool
function CS.UnityEngine.Texture2DArray.Apply(updateMipmaps) end

---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.Texture2DArray.Apply() end


--
--Class for handling Cubemap arrays.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.CubemapArray: UnityEngine.Texture
--
--Number of cubemaps in the array (Read Only).
--
---@source UnityEngine.CoreModule.dll
---@field cubemapCount int
--
--Texture format (Read Only).
--
---@source UnityEngine.CoreModule.dll
---@field format UnityEngine.TextureFormat
---@source UnityEngine.CoreModule.dll
---@field isReadable bool
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.CubemapArray = {}

--
--An array that contains a copy of the requested pixel colors, represented by Color structs.
--
--```plaintext
--Params: face - The cubemap face to read pixel data from.
--        arrayElement - The array element ("slice") to read pixel data from.
--        miplevel - The mip level to read pixel data from. The default is 0.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param face UnityEngine.CubemapFace
---@param arrayElement int
---@param miplevel int
function CS.UnityEngine.CubemapArray.GetPixels(face, arrayElement, miplevel) end

---@source UnityEngine.CoreModule.dll
---@param face UnityEngine.CubemapFace
---@param arrayElement int
function CS.UnityEngine.CubemapArray.GetPixels(face, arrayElement) end

--
--An array that contains a copy of the requested pixel colors, represented by lower-precision Color32 structs.
--
--```plaintext
--Params: face - The cubemap face to read pixel data from.
--        arrayElement - The array element ("slice") to read pixel data from.
--        miplevel - The mip level to read pixel data from. The default is 0.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param face UnityEngine.CubemapFace
---@param arrayElement int
---@param miplevel int
function CS.UnityEngine.CubemapArray.GetPixels32(face, arrayElement, miplevel) end

---@source UnityEngine.CoreModule.dll
---@param face UnityEngine.CubemapFace
---@param arrayElement int
function CS.UnityEngine.CubemapArray.GetPixels32(face, arrayElement) end

--
--Set pixel colors for a single array slice/face.
--
--```plaintext
--Params: colors - An array of pixel colors.
--        face - Cubemap face to set pixels for.
--        arrayElement - Array element index to set pixels for.
--        miplevel - Mipmap level to set pixels for.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param colors UnityEngine.Color[]
---@param face UnityEngine.CubemapFace
---@param arrayElement int
---@param miplevel int
function CS.UnityEngine.CubemapArray.SetPixels(colors, face, arrayElement, miplevel) end

---@source UnityEngine.CoreModule.dll
---@param colors UnityEngine.Color[]
---@param face UnityEngine.CubemapFace
---@param arrayElement int
function CS.UnityEngine.CubemapArray.SetPixels(colors, face, arrayElement) end

--
--Set pixel colors for a single array slice/face.
--
--```plaintext
--Params: colors - An array of pixel colors in low precision (8 bits/channel) format.
--        face - Cubemap face to set pixels for.
--        arrayElement - Array element index to set pixels for.
--        miplevel - Mipmap level to set pixels for.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param colors UnityEngine.Color32[]
---@param face UnityEngine.CubemapFace
---@param arrayElement int
---@param miplevel int
function CS.UnityEngine.CubemapArray.SetPixels32(colors, face, arrayElement, miplevel) end

---@source UnityEngine.CoreModule.dll
---@param colors UnityEngine.Color32[]
---@param face UnityEngine.CubemapFace
---@param arrayElement int
function CS.UnityEngine.CubemapArray.SetPixels32(colors, face, arrayElement) end

--
--Actually apply all previous SetPixels changes.
--
--```plaintext
--Params: updateMipmaps - When set to true, mipmap levels are recalculated.
--        makeNoLongerReadable - When set to true, Unity discards the copy of pixel data in CPU-addressable memory after this operation.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param updateMipmaps bool
---@param makeNoLongerReadable bool
function CS.UnityEngine.CubemapArray.Apply(updateMipmaps, makeNoLongerReadable) end

---@source UnityEngine.CoreModule.dll
---@param updateMipmaps bool
function CS.UnityEngine.CubemapArray.Apply(updateMipmaps) end

---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.CubemapArray.Apply() end

---@source UnityEngine.CoreModule.dll
---@param data T[]
---@param mipLevel int
---@param face UnityEngine.CubemapFace
---@param element int
---@param sourceDataStartIndex int
function CS.UnityEngine.CubemapArray.SetPixelData(data, mipLevel, face, element, sourceDataStartIndex) end

---@source UnityEngine.CoreModule.dll
---@param data Unity.Collections.NativeArray<T>
---@param mipLevel int
---@param face UnityEngine.CubemapFace
---@param element int
---@param sourceDataStartIndex int
function CS.UnityEngine.CubemapArray.SetPixelData(data, mipLevel, face, element, sourceDataStartIndex) end

---@source UnityEngine.CoreModule.dll
---@param mipLevel int
---@param face UnityEngine.CubemapFace
---@param element int
---@return NativeArray
function CS.UnityEngine.CubemapArray.GetPixelData(mipLevel, face, element) end


--
--Class for handling Sparse Textures.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.SparseTexture: UnityEngine.Texture
--
--Get sparse texture tile width (Read Only).
--
---@source UnityEngine.CoreModule.dll
---@field tileWidth int
--
--Get sparse texture tile height (Read Only).
--
---@source UnityEngine.CoreModule.dll
---@field tileHeight int
--
--Is the sparse texture actually created? (Read Only)
--
---@source UnityEngine.CoreModule.dll
---@field isCreated bool
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.SparseTexture = {}

--
--Update sparse texture tile with color values.
--
--```plaintext
--Params: tileX - Tile X coordinate.
--        tileY - Tile Y coordinate.
--        miplevel - Mipmap level of the texture.
--        data - Tile color data.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param tileX int
---@param tileY int
---@param miplevel int
---@param data UnityEngine.Color32[]
function CS.UnityEngine.SparseTexture.UpdateTile(tileX, tileY, miplevel, data) end

--
--Update sparse texture tile with raw pixel values.
--
--```plaintext
--Params: tileX - Tile X coordinate.
--        tileY - Tile Y coordinate.
--        miplevel - Mipmap level of the texture.
--        data - Tile raw pixel data.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param tileX int
---@param tileY int
---@param miplevel int
---@param data byte[]
function CS.UnityEngine.SparseTexture.UpdateTileRaw(tileX, tileY, miplevel, data) end

--
--Unload sparse texture tile.
--
--```plaintext
--Params: tileX - Tile X coordinate.
--        tileY - Tile Y coordinate.
--        miplevel - Mipmap level of the texture.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param tileX int
---@param tileY int
---@param miplevel int
function CS.UnityEngine.SparseTexture.UnloadTile(tileX, tileY, miplevel) end


--
--Render textures are textures that can be rendered to.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.RenderTexture: UnityEngine.Texture
--
--The width of the render texture in pixels.
--
---@source UnityEngine.CoreModule.dll
---@field width int
--
--The height of the render texture in pixels.
--
---@source UnityEngine.CoreModule.dll
---@field height int
--
--Dimensionality (type) of the render texture.
--
---@source UnityEngine.CoreModule.dll
---@field dimension UnityEngine.Rendering.TextureDimension
--
--The color format of the render texture.
--
---@source UnityEngine.CoreModule.dll
---@field graphicsFormat UnityEngine.Experimental.Rendering.GraphicsFormat
--
--Render texture has mipmaps when this flag is set.
--
---@source UnityEngine.CoreModule.dll
---@field useMipMap bool
--
--Does this render texture use sRGB read/write conversions? (Read Only).
--
---@source UnityEngine.CoreModule.dll
---@field sRGB bool
--
--If this RenderTexture is a VR eye texture used in stereoscopic rendering, this property decides what special rendering occurs, if any.
--
---@source UnityEngine.CoreModule.dll
---@field vrUsage UnityEngine.VRTextureUsage
--
--The render texture memoryless mode property.
--
---@source UnityEngine.CoreModule.dll
---@field memorylessMode UnityEngine.RenderTextureMemoryless
---@source UnityEngine.CoreModule.dll
---@field format UnityEngine.RenderTextureFormat
--
--The format of the stencil data that you can encapsulate within a RenderTexture.
--
--Specifying this property creates a stencil element for the RenderTexture and sets its format.
--This allows for stencil data to be bound as a Texture to all shader types for the platforms that support it.
--This property does not specify the format of the stencil buffer, which is constrained by the depth buffer format specified in RenderTexture.depth.
--
--Currently, most platforms only support R8_UInt (DirectX11, DirectX12), while PS4 also supports R8_UNorm.
--
---@source UnityEngine.CoreModule.dll
---@field stencilFormat UnityEngine.Experimental.Rendering.GraphicsFormat
--
--Mipmap levels are generated automatically when this flag is set.
--
---@source UnityEngine.CoreModule.dll
---@field autoGenerateMips bool
--
--Volume extent of a 3D render texture or number of slices of array texture.
--
---@source UnityEngine.CoreModule.dll
---@field volumeDepth int
--
--The antialiasing level for the RenderTexture.
--
---@source UnityEngine.CoreModule.dll
---@field antiAliasing int
--
--If true and antiAliasing is greater than 1, the render texture will not be resolved by default.  Use this if the render texture needs to be bound as a multisampled texture in a shader.
--
---@source UnityEngine.CoreModule.dll
---@field bindTextureMS bool
--
--Enable random access write into this render texture on Shader Model 5.0 level shaders.
--
---@source UnityEngine.CoreModule.dll
---@field enableRandomWrite bool
--
--Is the render texture marked to be scaled by the.
--
---@source UnityEngine.CoreModule.dll
---@field useDynamicScale bool
---@source UnityEngine.CoreModule.dll
---@field isPowerOfTwo bool
--
--Currently active render texture.
--
---@source UnityEngine.CoreModule.dll
---@field active UnityEngine.RenderTexture
--
--Color buffer of the render texture (Read Only).
--
---@source UnityEngine.CoreModule.dll
---@field colorBuffer UnityEngine.RenderBuffer
--
--Depth/stencil buffer of the render texture (Read Only).
--
---@source UnityEngine.CoreModule.dll
---@field depthBuffer UnityEngine.RenderBuffer
--
--The precision of the render texture's depth buffer in bits (0, 16, 24/32 are supported).
--
---@source UnityEngine.CoreModule.dll
---@field depth int
--
--This struct contains all the information required to create a RenderTexture. It can be copied, cached, and reused to easily create RenderTextures that all share the same properties.
--
---@source UnityEngine.CoreModule.dll
---@field descriptor UnityEngine.RenderTextureDescriptor
---@source UnityEngine.CoreModule.dll
---@field generateMips bool
---@source UnityEngine.CoreModule.dll
---@field isCubemap bool
--
--If enabled, this Render Texture will be used as a Texture3D.
--
---@source UnityEngine.CoreModule.dll
---@field isVolume bool
---@source UnityEngine.CoreModule.dll
---@field enabled bool
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.RenderTexture = {}

--
--Pointer to an underlying graphics API depth buffer resource.
--
---@source UnityEngine.CoreModule.dll
---@return IntPtr
function CS.UnityEngine.RenderTexture.GetNativeDepthBufferPtr() end

--
--Hint the GPU driver that the contents of the RenderTexture will not be used.
--
--```plaintext
--Params: discardColor - Should the colour buffer be discarded?
--        discardDepth - Should the depth buffer be discarded?
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param discardColor bool
---@param discardDepth bool
function CS.UnityEngine.RenderTexture.DiscardContents(discardColor, discardDepth) end

--
--Indicate that there's a RenderTexture restore operation expected.
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.RenderTexture.MarkRestoreExpected() end

--
--Hint the GPU driver that the contents of the RenderTexture will not be used.
--
--```plaintext
--Params: discardColor - Should the colour buffer be discarded?
--        discardDepth - Should the depth buffer be discarded?
--        
--```
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.RenderTexture.DiscardContents() end

--
--Force an antialiased render texture to be resolved.
--
--```plaintext
--Params: target - The render texture to resolve into.  If set, the target render texture must have the same dimensions and format as the source.
--        
--```
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.RenderTexture.ResolveAntiAliasedSurface() end

--
--Force an antialiased render texture to be resolved.
--
--```plaintext
--Params: target - The render texture to resolve into.  If set, the target render texture must have the same dimensions and format as the source.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param target UnityEngine.RenderTexture
function CS.UnityEngine.RenderTexture.ResolveAntiAliasedSurface(target) end

--
--Assigns this RenderTexture as a global shader property named propertyName.
--
---@source UnityEngine.CoreModule.dll
---@param propertyName string
function CS.UnityEngine.RenderTexture.SetGlobalShaderProperty(propertyName) end

--
--True if the texture is created, else false.
--
---@source UnityEngine.CoreModule.dll
---@return Boolean
function CS.UnityEngine.RenderTexture.Create() end

--
--Releases the RenderTexture.
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.RenderTexture.Release() end

--
--Is the render texture actually created?
--
---@source UnityEngine.CoreModule.dll
---@return Boolean
function CS.UnityEngine.RenderTexture.IsCreated() end

--
--Generate mipmap levels of a render texture.
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.RenderTexture.GenerateMips() end

---@source UnityEngine.CoreModule.dll
---@param equirect UnityEngine.RenderTexture
---@param eye UnityEngine.Camera.MonoOrStereoscopicEye
function CS.UnityEngine.RenderTexture.ConvertToEquirect(equirect, eye) end

--
--Does a RenderTexture have stencil buffer?
--
--```plaintext
--Params: rt - Render texture, or null for main screen.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param rt UnityEngine.RenderTexture
---@return Boolean
function CS.UnityEngine.RenderTexture:SupportsStencil(rt) end

--
--Release a temporary texture allocated with GetTemporary.
--
---@source UnityEngine.CoreModule.dll
---@param temp UnityEngine.RenderTexture
function CS.UnityEngine.RenderTexture:ReleaseTemporary(temp) end

--
--Allocate a temporary render texture.
--
--```plaintext
--Params: width - Width in pixels.
--        height - Height in pixels.
--        depthBuffer - Depth buffer bits (0, 16 or 24). Note that only 24 bit depth has stencil buffer.
--        format - Render texture format.
--        readWrite - Color space conversion mode.
--        antiAliasing - Number of antialiasing samples to store in the texture. Valid values are 1, 2, 4, and 8. Throws an exception if any other value is passed.
--        memorylessMode - Render texture memoryless mode.
--        desc - Use this RenderTextureDesc for the settings when creating the temporary RenderTexture.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param desc UnityEngine.RenderTextureDescriptor
---@return RenderTexture
function CS.UnityEngine.RenderTexture:GetTemporary(desc) end

---@source UnityEngine.CoreModule.dll
---@param width int
---@param height int
---@param depthBuffer int
---@param format UnityEngine.Experimental.Rendering.GraphicsFormat
---@param antiAliasing int
---@param memorylessMode UnityEngine.RenderTextureMemoryless
---@param vrUsage UnityEngine.VRTextureUsage
---@param useDynamicScale bool
---@return RenderTexture
function CS.UnityEngine.RenderTexture:GetTemporary(width, height, depthBuffer, format, antiAliasing, memorylessMode, vrUsage, useDynamicScale) end

---@source UnityEngine.CoreModule.dll
---@param width int
---@param height int
---@param depthBuffer int
---@param format UnityEngine.Experimental.Rendering.GraphicsFormat
---@param antiAliasing int
---@param memorylessMode UnityEngine.RenderTextureMemoryless
---@param vrUsage UnityEngine.VRTextureUsage
---@return RenderTexture
function CS.UnityEngine.RenderTexture:GetTemporary(width, height, depthBuffer, format, antiAliasing, memorylessMode, vrUsage) end

---@source UnityEngine.CoreModule.dll
---@param width int
---@param height int
---@param depthBuffer int
---@param format UnityEngine.Experimental.Rendering.GraphicsFormat
---@param antiAliasing int
---@param memorylessMode UnityEngine.RenderTextureMemoryless
---@return RenderTexture
function CS.UnityEngine.RenderTexture:GetTemporary(width, height, depthBuffer, format, antiAliasing, memorylessMode) end

---@source UnityEngine.CoreModule.dll
---@param width int
---@param height int
---@param depthBuffer int
---@param format UnityEngine.Experimental.Rendering.GraphicsFormat
---@param antiAliasing int
---@return RenderTexture
function CS.UnityEngine.RenderTexture:GetTemporary(width, height, depthBuffer, format, antiAliasing) end

---@source UnityEngine.CoreModule.dll
---@param width int
---@param height int
---@param depthBuffer int
---@param format UnityEngine.Experimental.Rendering.GraphicsFormat
---@return RenderTexture
function CS.UnityEngine.RenderTexture:GetTemporary(width, height, depthBuffer, format) end

--
--Allocate a temporary render texture.
--
--```plaintext
--Params: width - Width in pixels.
--        height - Height in pixels.
--        depthBuffer - Depth buffer bits (0, 16 or 24). Note that only 24 bit depth has stencil buffer.
--        format - Render texture format.
--        readWrite - Color space conversion mode.
--        antiAliasing - Number of antialiasing samples to store in the texture. Valid values are 1, 2, 4, and 8. Throws an exception if any other value is passed.
--        memorylessMode - Render texture memoryless mode.
--        desc - Use this RenderTextureDesc for the settings when creating the temporary RenderTexture.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param width int
---@param height int
---@param depthBuffer int
---@param format UnityEngine.RenderTextureFormat
---@param readWrite UnityEngine.RenderTextureReadWrite
---@param antiAliasing int
---@param memorylessMode UnityEngine.RenderTextureMemoryless
---@param vrUsage UnityEngine.VRTextureUsage
---@param useDynamicScale bool
---@return RenderTexture
function CS.UnityEngine.RenderTexture:GetTemporary(width, height, depthBuffer, format, readWrite, antiAliasing, memorylessMode, vrUsage, useDynamicScale) end

---@source UnityEngine.CoreModule.dll
---@param width int
---@param height int
---@param depthBuffer int
---@param format UnityEngine.RenderTextureFormat
---@param readWrite UnityEngine.RenderTextureReadWrite
---@param antiAliasing int
---@param memorylessMode UnityEngine.RenderTextureMemoryless
---@param vrUsage UnityEngine.VRTextureUsage
---@return RenderTexture
function CS.UnityEngine.RenderTexture:GetTemporary(width, height, depthBuffer, format, readWrite, antiAliasing, memorylessMode, vrUsage) end

---@source UnityEngine.CoreModule.dll
---@param width int
---@param height int
---@param depthBuffer int
---@param format UnityEngine.RenderTextureFormat
---@param readWrite UnityEngine.RenderTextureReadWrite
---@param antiAliasing int
---@param memorylessMode UnityEngine.RenderTextureMemoryless
---@return RenderTexture
function CS.UnityEngine.RenderTexture:GetTemporary(width, height, depthBuffer, format, readWrite, antiAliasing, memorylessMode) end

---@source UnityEngine.CoreModule.dll
---@param width int
---@param height int
---@param depthBuffer int
---@param format UnityEngine.RenderTextureFormat
---@param readWrite UnityEngine.RenderTextureReadWrite
---@param antiAliasing int
---@return RenderTexture
function CS.UnityEngine.RenderTexture:GetTemporary(width, height, depthBuffer, format, readWrite, antiAliasing) end

---@source UnityEngine.CoreModule.dll
---@param width int
---@param height int
---@param depthBuffer int
---@param format UnityEngine.RenderTextureFormat
---@param readWrite UnityEngine.RenderTextureReadWrite
---@return RenderTexture
function CS.UnityEngine.RenderTexture:GetTemporary(width, height, depthBuffer, format, readWrite) end

---@source UnityEngine.CoreModule.dll
---@param width int
---@param height int
---@param depthBuffer int
---@param format UnityEngine.RenderTextureFormat
---@return RenderTexture
function CS.UnityEngine.RenderTexture:GetTemporary(width, height, depthBuffer, format) end

---@source UnityEngine.CoreModule.dll
---@param width int
---@param height int
---@param depthBuffer int
---@return RenderTexture
function CS.UnityEngine.RenderTexture:GetTemporary(width, height, depthBuffer) end

---@source UnityEngine.CoreModule.dll
---@param width int
---@param height int
---@return RenderTexture
function CS.UnityEngine.RenderTexture:GetTemporary(width, height) end

---@source UnityEngine.CoreModule.dll
---@param color UnityEngine.Color
function CS.UnityEngine.RenderTexture.SetBorderColor(color) end

---@source UnityEngine.CoreModule.dll
---@return Vector2
function CS.UnityEngine.RenderTexture.GetTexelOffset() end


--
--Structure describing an Update Zone.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.CustomRenderTextureUpdateZone: System.ValueType
--
--Position of the center of the Update Zone within the Custom Render Texture.
--
---@source UnityEngine.CoreModule.dll
---@field updateZoneCenter UnityEngine.Vector3
--
--Size of the Update Zone.
--
---@source UnityEngine.CoreModule.dll
---@field updateZoneSize UnityEngine.Vector3
--
--Rotation of the Update Zone.
--
---@source UnityEngine.CoreModule.dll
---@field rotation float
--
--Shader Pass used to update the Custom Render Texture for this Update Zone.
--
---@source UnityEngine.CoreModule.dll
---@field passIndex int
--
--If true, and if the texture is double buffered, a request is made to swap the buffers before the next update. Otherwise, the buffers will not be swapped.
--
---@source UnityEngine.CoreModule.dll
---@field needSwap bool
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.CustomRenderTextureUpdateZone = {}


--
--Custom Render Textures are an extension to Render Textures that allow you to render directly to the Texture using a Shader.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.CustomRenderTexture: UnityEngine.RenderTexture
--
--The Material that Unity uses to initialize the content of a Custom Render Texture.
--
---@source UnityEngine.CoreModule.dll
---@field material UnityEngine.Material
--
--The Material that Unity uses to initialize a Custom Render Texture. Initialization texture and color are ignored if you have set this parameter.
--
---@source UnityEngine.CoreModule.dll
---@field initializationMaterial UnityEngine.Material
--
--The Texture that Unity uses to initialize a Custom Render Texture, multiplied by the initialization color. Unity ignores this parameter if an initializationMaterial is set.
--
---@source UnityEngine.CoreModule.dll
---@field initializationTexture UnityEngine.Texture
--
--Determine if Unity initializes the Custom Render Texture with a Texture and a Color or a Material.
--
---@source UnityEngine.CoreModule.dll
---@field initializationSource UnityEngine.CustomRenderTextureInitializationSource
--
--The color that Unity uses to initialize a Custom Render Texture. Unity ignores this parameter if an initializationMaterial is set.
--
---@source UnityEngine.CoreModule.dll
---@field initializationColor UnityEngine.Color
--
--Determine how Unity updates the Custom Render Texture.
--
---@source UnityEngine.CoreModule.dll
---@field updateMode UnityEngine.CustomRenderTextureUpdateMode
--
--Determine how Unity initializes a texture.
--
---@source UnityEngine.CoreModule.dll
---@field initializationMode UnityEngine.CustomRenderTextureUpdateMode
--
--The space in which Unity expresses update zones. You can set this to Normalized or Pixel space.
--
---@source UnityEngine.CoreModule.dll
---@field updateZoneSpace UnityEngine.CustomRenderTextureUpdateZoneSpace
--
--The Shader Pass Unity uses to update the Custom Render Texture.
--
---@source UnityEngine.CoreModule.dll
---@field shaderPass int
--
--The bit field that you can use to enable or disable update on each of the cubemap faces. The bit order from least to most significant bit is as follows: +X, -X, +Y, -Y, +Z, -Z.
--
---@source UnityEngine.CoreModule.dll
---@field cubemapFaceMask uint
--
--When this parameter is set to true, Unity double-buffers the Custom Render Texture so that you can access it during its own update.
--
---@source UnityEngine.CoreModule.dll
---@field doubleBuffered bool
--
--When this parameter is set to true, Unity wraps Update zones around the border of the Custom Render Texture. Otherwise, Unity clamps Update zones at the border of the Custom Render Texture.
--
---@source UnityEngine.CoreModule.dll
---@field wrapUpdateZones bool
--
--The period in seconds that Unity updates real-time Custom Render Textures. A value of 0.0 means Unity updates real-time Custom Render Textures every frame.
--
---@source UnityEngine.CoreModule.dll
---@field updatePeriod float
---@source UnityEngine.CoreModule.dll
CS.UnityEngine.CustomRenderTexture = {}

--
--Triggers an update of the Custom Render Texture.
--
--```plaintext
--Params: count - Number of upate pass to perform. The default value of this count parameter is 1.
--        
--```
--
---@source UnityEngine.CoreModule.dll
---@param count int
function CS.UnityEngine.CustomRenderTexture.Update(count) end

---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.CustomRenderTexture.Update() end

--
--Initializes the Custom Render Texture at the start of the next frame. Unity calls Initialise() before CustomRenderTexture.Update.
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.CustomRenderTexture.Initialize() end

--
--Clear all Update Zones.
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.CustomRenderTexture.ClearUpdateZones() end

---@source UnityEngine.CoreModule.dll
---@param updateZones System.Collections.Generic.List<UnityEngine.CustomRenderTextureUpdateZone>
function CS.UnityEngine.CustomRenderTexture.GetUpdateZones(updateZones) end

--
--If CustomRenderTexture. doubleBuffered is true, this returns the Render Texture that this Custom Render Texture uses for double buffering. If CustomRenderTexture. doubleBuffered is false, this returns null.
--
---@source UnityEngine.CoreModule.dll
---@return RenderTexture
function CS.UnityEngine.CustomRenderTexture.GetDoubleBufferRenderTexture() end

--
--Updates the internal Render Texture that a Custom Render Texture uses for double buffering, so that it matches the size and format of the Custom Render Texture.
--
---@source UnityEngine.CoreModule.dll
function CS.UnityEngine.CustomRenderTexture.EnsureDoubleBufferConsistency() end

--
--Setup the list of Update Zones for the Custom Render Texture.
--
---@source UnityEngine.CoreModule.dll
---@param updateZones UnityEngine.CustomRenderTextureUpdateZone[]
function CS.UnityEngine.CustomRenderTexture.SetUpdateZones(updateZones) end


--
--This struct contains all the information required to create a RenderTexture. It can be copied, cached, and reused to easily create RenderTextures that all share the same properties. Avoid using the default constructor as it does not initialize some flags with the recommended values.
--
---@source UnityEngine.CoreModule.dll
---@class UnityEngine.RenderTextureDescriptor: System.ValueType
--
--The width of the render texture in pixels.
--
---@source UnityEngine.CoreModule.dll
---@field width int
--
--The height of the render texture in pixels.
--
---@source UnityEngine.CoreModule.dll
---@field height int
--
--The multisample antialiasing level for the RenderTexture.
--
--See Also: RenderTexture.antiAliasing.
--
---@source UnityEngine.CoreModule.dll
---@field msaaSamples int
--
--Volume exte